// ---------------------------------------------------------------------------
// - Libatxt.cpp                                                             -
// - aleph:txt library - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Sort.hpp"
#include "Digest.hpp"
#include "Libatxt.hpp"
#include "Predatxt.hpp"
#include "Function.hpp"
#include "PrintTable.hpp"

namespace aleph {
  Object* init_aleph_txt (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;
    
    // create the aleph:sys nameset
    Nameset* aset = interp->mknset ("aleph", interp->getgset ());
    Nameset* atxt = interp->mknset ("txt",   aset);
    
    // bind all classes in the aleph:txt nameset
    atxt->symcst ("Digest",     new Meta (Digest::mknew));
    atxt->symcst ("PrintTable", new Meta (PrintTable::mknew));
    
    // bind the special functions
    atxt->symcst ("sort",       new Function (atxt_qsort));

    // bind all predicates in the aleph:txt nameset
    atxt->symcst ("digest-p",      new Function (atxt_dgstp));
    atxt->symcst ("print-table-p", new Function (atxt_ptblp));
    
    // not used but needed
    return nilp;
  }
}

extern "C" {
  aleph::Object* dli_aleph_txt (aleph::Interp* interp, aleph::Vector* argv) {
    return init_aleph_txt (interp, argv);
  }
}
