// ---------------------------------------------------------------------------
// - Former.hpp                                                              -
// - aleph engine - form builder virtual class definition                    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_FORMER_HPP
#define  ALEPH_FORMER_HPP

#ifndef  ALEPH_FORM_HPP
#include "Form.hpp"
#endif

namespace aleph {

  /// The Former class is a virtual class used to derive form reader. The 
  /// class defines only a virtual method call "parse" which returns a form.
  /// The virtual method "getlnum" returns the reader line number
  /// @author amaury darsch

  class Former : public Object {
  public:
    /// @return a new form
    virtual Form* parse (void) =0;

    /// @return the reader line number
    virtual long getlnum (void) const =0;
  };
}

#endif
