// ---------------------------------------------------------------------------
// - Axcopts.hpp                                                             -
// - aleph cross compiler - options class definitions                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef ALEPH_AXCOPTS_HPP
#define ALEPH_AXCOPTS_HPP

#ifndef  ALEPH_STRVEC_HPP
#include "Strvec.hpp"
#endif

namespace aleph {

  /// The Axcopts class is the class used by the aleph cross compiler to 
  /// store user options. The instance is simply created with the standard 
  /// main program arguments.
  /// @author amaury darsch

  class Axcopts {
  private:
    /// the argument list
    Strvec d_argv;
    /// the paths list
    Strvec d_path;

  public:
    /// create a new option class from the main arguments
    /// @param argc the number of arguments
    /// @param argv the argument array
    Axcopts (int argc, char** argv);

    /// @return the string vector of arguments
    const Strvec& getargv (void) const {
      return d_argv;
    }

    /// @return the string vector of paths
    const Strvec& getpath (void) const {
      return d_path;
    }

  private:
    // make the copy constructor private
    Axcopts (const Axcopts&);
    // make the assignment operator private
    Axcopts& operator = (const Axcopts&);
  };
}

#endif
