// ---------------------------------------------------------------------------
// - Aodopts.cpp                                                             -
// - aleph object database - main program implementation                     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Aod.hpp"
#include "Aodopts.hpp"

// main interpreter 

int main (int argc, char** argv) {
  using namespace aleph;
  OutputTerm terr (OutputTerm::ERROR);

  // create a new option instance
  Aodopts* options = new Aodopts (argc,argv);

  // get the optional file name
  String fname = options->getfname ();
  bool   sflag = (fname.length () == 0);

  // create a new data commands
  Input*  is  = nilp;
  Output* os  = nilp;
  Output* es  = nilp;
  Aod*    aod = (sflag == true) ? new Aod : new Aod (is, os, es);

  // set the commands flags
  aod->setassert (options->getassert ());
  aod->setargs   (options->getargs   ());
  aod->setpath   (options->getpath   ());

  // loop or execute on the standard input or a file
  bool status = false;
  try {
    status  = (sflag == true) ? aod->loop () : aod->loop (fname); 
  } catch (const Exception& e) {
    terr.errorln (e);
    status = false;
  } catch (...) {
    terr << "fatal: unknown exception trapped\n";
    status = false;
  }

  // clean eveything and return
  delete aod;
  delete options;
  return status ? 0 : 1;
}
