// ---------------------------------------------------------------------------
// - Libapi.cpp                                                              -
// - example:api library - declaration & implementation                      -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Libapi.hpp"
#include "Apicalls.hpp"
#include "Function.hpp"

namespace example {
  // use the aleph namespace
  using namespace aleph;

  // initialize the api library
  Object* init_example_api (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;

    // create the api nameset
    Nameset* api = interp->mknset ("api", interp->getgset ());

    // bind the add fucntion
    api->symcst ("add", new Function (api_add));

    // not used but needed
    return nilp;
  }
}

extern "C" {
  aleph::Object* dli_example_api (aleph::Interp* interp, 
					   aleph::Vector* argv) {
    return example::init_example_api (interp, argv);
  }
}
