; eric smith, david russinoff, with suggestions by matt kaufmann
; amd, june 2001 

(in-package "ACL2")

;note: the proofs in this file are very messy.  i haven't taken time to clean
;them up by eliminating hacks or increasing elegance. -eric

(include-book "repsproofs")

; bias of a q bit exponent field is 2^(q-1)-1 
;(defun bias (q) (- (expt 2 (- q 1)) 1) )

(defthm integerp-bias
  (implies (and (integerp q)
                (> q 0))
           (integerp (bias q)))
  :hints (("goal" :in-theory (enable bias)))
  :rule-classes (:type-prescription :rewrite)
  )

(in-theory (disable bias))


;;encoding of floating-point numbers with implicit msb
;;bit vectors of length p+q, consisting of 1-bit sign field, 
;;q-bit exponent field (bias = 2**(q-1)-1), and (p-1)-bit 
;;significand field:
;; p must be > 1



;;;**********************************************************************
;;;                       field extractors
;;;**********************************************************************

(defun isgnf (x p q) (bitn x (1- (+ p q))))
(defun iexpof (x p q) (bits x (- (+ p q) 2) (1- p)))
(defun isigf (x p) (bits x (- p 2) 0))


;;;**********************************************************************
;;;                       representable numbers
;;;**********************************************************************

(defun nrepp (x p q)
  (and (rationalp x)
       (not (= x 0))
       (< 0 (+ (expo x) (bias q)))
       (< (+ (expo x) (bias q)) (- (expt 2 q) 1))
       (exactp x p)))

(defun drepp (x p q)
  (and (rationalp x)
       (not (= x 0))
       (<= (- 2 p) (+ (expo x) (bias q)))
       (<= (+ (expo x) (bias q)) 0)
       (exactp x (+ -2 p (expt 2 (- q 1)) (expo x)))))
;bits available in the sig field = p-1-(-bias-expo(x))


(defun irepp (x p q)
  (or (nrepp x p q)
      (drepp x p q)))


;;;**********************************************************************
;;;                      valid encodings
;;;**********************************************************************

(defun nencodingp (x p q)
  (and (bvecp x (+ p q))
       (< 0 (iexpof x p q))
       (< (iexpof x p q) (- (expt 2 q) 1))))

(defun dencodingp (x p q)
  (and (bvecp x (+ p q))
       (= (iexpof x p q) 0)
       (not (= (isigf x p) 0))))

(defun iencodingp (x p q)
  (or (nencodingp x p q)
      (dencodingp x p q)))


;;;**********************************************************************
;;;                       encode
;;;**********************************************************************

; sig, expo, and sgn are defined in float.lisp

(defun nencode (x p q)
  (cat (cat (if (= (sgn x) 1) 0 1)
            (+ (expo x) (bias q))
            q)
       (* (- (sig x) 1) (expt 2 (- p 1)))
       (- p 1)))

(defun dencode (x p q)
  (cat (cat (if (= (sgn x) 1) 0 1)
            0
            q)
       (* (sig x) (expt 2 (+ -2 p (expo x) (bias q))))
       (- p 1)))

(defun iencode (x p q)
  (cond ((nrepp x p q)
	 (nencode x p q))
	((drepp x p q)
	 (dencode x p q))))


;;;**********************************************************************
;;;                       decode
;;;**********************************************************************

(defun ndecode (x p q)
  (* (if (= (isgnf x p q) 0) 1 -1)
     (+ (expt 2 (- (iexpof x p q) (bias q)))
        (* (isigf x p)
           (expt 2 (+ 1 (iexpof x p q) (- (bias q)) (- p)))))))


(defun ddecode (x p q)
  (* (if (= (isgnf x p q) 0) 1 -1)
     (isigf x p)
     (expt 2 (+ 2 (- (bias q)) (- p)))))


(defun idecode (x p q)
  (cond ((nencodingp x p q)
	 (ndecode x p q))
	((dencodingp x p q)
	 (ddecode x p q))))

;;;**********************************************************************
;;;                       theorems
;;;**********************************************************************

(in-theory (disable isgnf 
                    iexpof 
                    isigf 
                    idecode 
                    ndecode 
                    ddecode
                    iencode
                    nencode
                    dencode
                    iencodingp
                    nencodingp
                    dencodingp
                    irepp
                    nrepp
                    drepp

                    sig))

(defthm not-both-nencodingp-and-dencodingp
  (implies (iencodingp x p q)
	   (iff (nencodingp x p q)
		(not (dencodingp x p q))))
  :rule-classes ()
  :hints (("goal" :in-theory (enable iencodingp nencodingp dencodingp))))




; the field extractors return bit-vectors.


;some of the rules below may be bad because they are put into both the
; forward-chaining and type-prescription rule classes, causing them
; not to always work. 

(defthm bvecp-isigf-forward-3
  (implies (and (rationalp x)
                (>= x 0)
                (integerp p)
                (> p 1))
           (bvecp (isigf x p) (- p 1)))
  :hints (("goal" :in-theory (enable isigf natp)))
  :rule-classes (:rewrite
                 (:forward-chaining :trigger-terms ((isigf x p)))))


;add? ;better than the t-p rule?
(defthm floor->=-0
  (implies (rationalp x)
           (equal (<= 0 (fl x))
                  (<= 0 x))))

;dangerous?
(defthm prod->=-0
  (implies (and (rationalp x)
                (rationalp y)
                (< 0 x))
           (and (equal (<= 0 (* x y))
                       (<= 0 y))
                (equal (<= 0 (* y x))
                       (<= 0 y)))))

(defthm isigf-forward
  (implies (and (rationalp x)
                (>= x 0)
                (integerp p)
                (> p 1))
           (<= 0 (isigf x p)))
  :hints (("goal" :in-theory (enable isigf natp)))
  :rule-classes (:rewrite
                 :linear                 
                 :type-prescription))

(defthm iexpof-forward
  (implies (and (rationalp x)
                (>= x 0)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (<= 0 (iexpof x p q)))
  :hints (("goal" :in-theory (enable iexpof natp)))
  :rule-classes (:rewrite
                 :linear                 
                 :type-prescription))



(defthm bvecp-iexpof-forward
  (implies (and (integerp p)
                (> p 1)
                (integerp q)
                (> q 0)
                (rationalp x)
                (>= x 0))
           (bvecp (iexpof x p q) q ))
  :hints (("goal" :in-theory (enable iexpof natp bvecp)))
  :rule-classes ((:forward-chaining :trigger-terms ((iexpof x p q)))))
;rc?

(defthm bvecp-isgnf-forward
    (implies (and (integerp p)
                  (> p 1)
                  (integerp q)
                  (> q 0)
                  (iencodingp x p q))
             (bvecp (isgnf x p q) 1 ))
    :hints (("goal" :in-theory (enable isgnf natp iencodingp dencodingp
                                       nencodingp)))
    :rule-classes ((:forward-chaining :trigger-terms ((isgnf x p q)))))
;rc?

;forward-chaining-rules for encoding types

(defthm nencodingp-forward-to-iencodingp
  (implies (nencodingp x p q)
           (iencodingp x p q) )
  :hints (("goal" :in-theory (enable iencodingp nencodingp)))
  :rule-classes (:rewrite :forward-chaining)
  )

(defthm dencodingp-forward-to-iencodingp
  (implies (dencodingp x p q)
           (iencodingp x p q) )
  :hints (("goal" :in-theory (enable iencodingp dencodingp)))
  :rule-classes (:rewrite :forward-chaining)
  )

;remove?
(defthm dencodingp-implies-ddecode-is-idecode
  (implies (dencodingp x p q)
           (equal (ddecode x p q)
                  (idecode x p q)))
  :hints (("goal" :in-theory (enable idecode)
		  :use (not-both-nencodingp-and-dencodingp)))
  :rule-classes :forward-chaining
  )


(defthm bias-non-negative-rationalp-type-prescription
  (implies
   (and (integerp q)
        (> q 0))
   (and (rationalp (bias q))
        (>= (bias q) 0)))
  :hints (("goal" :in-theory (enable bias)))
  :rule-classes (:rewrite :type-prescription))

;needed? t-p?

(defthm not-zero-ddecode
  (implies (and (dencodingp x p q)
                (integerp p)
                (< 1 p)
                (integerp q)
                (< 0 q))
           (not (equal (ddecode x p q) 0)))
  :hints (("goal" :in-theory (enable ddecode dencodingp))))

(defthm not-zero-ndecode
  (implies (and ;(nencodingp x p q)
                (rationalp x)
                (>= x 0)
                (integerp p)
                (< 1 p)
                (integerp q)
                (< 0 q))
           (not (equal (ndecode x p q) 0)))
  :hints (("goal" :in-theory (enable ndecode nencodingp))))

#|
(defthm isigf-type
  (integerp (isigf x p))
  :rule-classes :type-prescription)

(defthm iexpof-type
  (integerp (iexpof x p q))
  :rule-classes :type-prescription)
|#

;(in-theory (disable bvecp-bits))

(defthm expo-minus-dist
  (equal (expo (+ (* -1 x) (* -1 y)))
         (expo (+ x y)))
  :hints (("Goal" :in-theory (disable expo-minus)
          :use (:instance expo-minus (x (* -1 (+ x y)))))))


(defthm sig-minus-dist
  (equal (sig (+ (* -1 x) (* -1 y)))
         (sig (+ x y)))
  :hints (("Goal" :in-theory (disable sig-minus)
          :use (:instance sig-minus (x (* -1 (+ x y)))))))


(defthm sgn-minus-dist
  (implies (and
            (acl2-numberp x)
            (acl2-numberp y))
           (equal (sgn (+ (* -1 x) (* -1 y)))
                  (* -1 (sgn (+ x y)))))
  :hints (("Goal" :in-theory (disable sgn-minus)
          :use (:instance sgn-minus (x (* -1 (+ x y)))))))

(defthm expo-ndecode
  (implies
   (and (nencodingp x p q)
        (integerp p)
        (> p 1)
        (integerp q)
        (> q 0))  
   (equal
    (expo (ndecode x p q))
    (- (iexpof x p q) (bias q))))
  :hints (("goal" 
           :use ((:instance a15 (i 2) (j1 1) (j2 (+ (* -1 (BIAS Q)) (IEXPOF X P Q))))
                 (:instance expo-squeeze
                           (x (+ (EXPT 2 (+ (* -1 (BIAS Q)) (IEXPOF X P Q)))
                            (* (ISIGF X P)
                               (EXPT 2
                                     (+ 1 (* -1 P)
                                        (* -1 (BIAS Q))
                                        (IEXPOF X P Q))))))
                           (n (+ (* -1 (BIAS Q)) (IEXPOF X P Q)))))
           :in-theory (enable ndecode nencodingp))))

(defthm sgn-ndecode
  (implies
   (and ; (nencodingp x p q)
    (rationalp x)
    (>= x 0)
    (integerp p)
    (> p 1)
    (integerp q)
    (> q 0))
   (equal
    (sgn (ndecode x p q))
    (if (= (isgnf x p q) 0) 1 -1)))
  :hints (("goal" :in-theory (enable ndecode sgn))))

;why? these are good rules!
(in-theory (disable sig-shift sig-minus sig-shift-2 expo-minus expo-shift expo-shift-2))


(defthm nencodingp-forward-to-positive-rationalp
  (implies (and (nencodingp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0)
                )
           (and (rationalp x)
                (>= x 0)))
  :hints (("Goal" :in-theory (enable nencodingp)))
  :rule-classes (:forward-chaining :rewrite))

(defthm dencodingp-forward-to-positive-rationalp
  (implies (and (dencodingp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0)
                )
           (and (rationalp x)
                (>= x 0)))
  :hints (("Goal" :in-theory (enable dencodingp)))
  :rule-classes (:forward-chaining :rewrite))


(defun ndecode (x p q)
  (* (if (= (isgnf x p q) 0) 1 -1)
     (+ (expt 2 (- (iexpof x p q) (bias q)))
        (* (isigf x p)
           (expt 2 (+ 1 (iexpof x p q) (- (bias q)) (- p)))))))

(defthm equal-cancel-+
  (implies (and (rationalp x)
                (rationalp y)
                (rationalp z))
           (and (equal (equal (+ x y) (+ x z))
                  (equal y z))
                (equal (equal (+ y x) (+ z x))
                  (equal y z))
                (equal (equal (+ x y) (+ z x))
                       (equal y z))
                (equal (equal (+ y x) (+ x z))
                       (equal y z)))))


(defthm equal-cancel-*
  (implies (and (rationalp x)
                (rationalp y)
                (rationalp y1)

                (not (equal 0 x)))
           (and (equal (equal (* x y) (* x y1))
                  (equal y y1))
                (equal (equal (* y x) (* y1 x))
                  (equal y y1))
                (equal (equal (* x y) (* y1 x))
                       (equal y y1))
                (equal (equal (* y x) (* x y1))
                       (equal y y1))))
  :hints (("Goal" :use ((:instance *-strongly-monotonic (y+ y1))
                        (:instance *-strongly-monotonic (y y1) (y+ y))
                        (:instance *-strongly-monotonic (y+ y1) (x (- x)))
                        (:instance *-strongly-monotonic (y y1) (y+ y) (x (- x)))))))

;generalize
(defthm equal-cancel-*-5
  (implies  (and (rationalp x)
                 (rationalp y)
                 (rationalp y1)
                 (rationalp y2))
            (and 
             (equal (equal (* x y) (* x y1 y2))
                    (or (equal x 0)
                        (equal y (* y1 y2))))
             (equal (equal (* x y) (* y1 x y2))
                    (or (equal x 0)
                        (equal y (* y1 y2))))
             (equal (equal (* x y) (* y1 y2 x))
                    (or (equal x 0)
                        (equal y (* y1 y2))))
             (equal (equal (* y x) (* x y1 y2))
                    (or (equal x 0)
                        (equal y (* y1 y2))))
             (equal (equal (* y x) (* y1 x y2))
                    (or (equal x 0)
                        (equal y (* y1 y2))))
             (equal (equal (* y x) (* y1 y2 x))
                    (or (equal x 0)
                        (equal y (* y1 y2)))))))

(defthm ndecode-rewrite
  (implies (and
            (rationalp x)
            (integerp p)
            (> p 1)
            (integerp q)
            (> q 0))
           
           (= (ndecode x p q)
              (* (if (= (isgnf x p q) 0) 1 -1)
                 (* (expt 2 (- (iexpof x p q) (bias q)))
                    (+ 1 (* (isigf x p)
                            (expt 2 (+ 1 (- p)))))))))
  :hints (("Goal" :in-theory (enable ndecode))))

(in-theory (disable ndecode))


(defthm isigf-upper-bound-linear
  (implies (and (integerp x)
                (>= x 0)
                (integerp p)
                (> p 1))
           (< (isigf x p) (expt 2 (- p 1) )))
  :rule-classes (:rewrite :linear))

;remove?
#|
(defthm only-1-has-integerp-sig
  (implies (and 
            (rationalp x)
            (not (equal x 0))
            (integerp (sig x)))
           (= (sig x) 1))
  :hints (("Goal" :use (sig-upper-bound sig-lower-bound)))
)
|#
     
;no distributivity
(defthm a9-eric
  (and (equal (* 0 x) 0)
       (equal (* x (* y z)) (* y (* x z)))
;       (equal (* x (+ y z)) (+ (* x y) (* x z)))
 ;      (equal (* (+ y z) x) (+ (* y x) (* z x)))
       ))


(defthm dist-constants
  (implies (syntaxp (quotep c))
           (= (* c (+ a b))
              (+ (* c a) (* c b)))))

(in-theory (disable dist-constants))

;distributing would mess up the nice form of ndecode
(defthm sig-ndecode
  (implies
   (and (nencodingp x p q) ;gen?
        (integerp p)
        (> p 1)
        (integerp q)
        (> q 0))
   (equal
    (sig (ndecode x p q))
    (+ 1 (/ (isigf x p) (expt 2 (- p 1))))
    ))
  :otf-flg t
  :hints (("goal" :in-theory (set-difference-theories
                              (enable ndecode sig-shift sig-shift-2 sig-minus dist-constants)
                              '(a9 distributivity
                                   )))))

(defthm sgn-ddecode
  (implies
   (and (dencodingp x p q)
        (integerp p)
        (> p 1)
        (integerp q)
        (> q 0))
   (equal
    (sgn (ddecode x p q))
    (if (= (isgnf x p q) 0) 1 -1)))
  :hints (("Goal" :in-theory (enable ddecode dencodingp sgn))))

(defthm sig-ddecode
  (implies
   (and (dencodingp x p q)
        (integerp p)
        (> p 1)
        (integerp q)
        (> q 0))
   (equal
    (sig (ddecode x p q))
    (sig (isigf x p))))
  :hints (("Goal" :in-theory (enable ddecode sgn sig-minus sig-shift sig-shift-2))))

(defthm expo-ddecode
  (implies
   (and (dencodingp x p q)
        (integerp p)
        (> p 1)
        (integerp q)
        (> q 0))
   (equal
    (expo (ddecode x p q))
    (+ 2 (- p) (- (bias q)) (expo (isigf x p)))))
  :hints (("Goal" :in-theory (enable ddecode dencodingp expo-minus expo-shift expo-shift-2))))

(defthm sgn-idecode
  (implies
   (and (iencodingp x p q)
        (integerp p)
        (> p 1)
        (integerp q)
        (> q 0))
   (equal
    (sgn (idecode x p q))
    (if (= (isgnf x p q) 0) 1 -1)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable idecode iencodingp)
                              '(ndecode-rewrite)))))

(defthm sig-idecode
  (implies
   (and (iencodingp x p q)
        (integerp p)
        (> p 1)
        (integerp q)
        (> q 0))
   (equal
    (sig (idecode x p q))
    (cond ((nencodingp x p q)
           (+ 1 (/ (isigf x p) (expt 2 (- p 1)))))
          ((dencodingp x p q)
           (sig (isigf x p))))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable idecode iencodingp)
                              '(ndecode-rewrite)))))

(defthm expo-idecode
  (implies
   (and (iencodingp x p q)
        (integerp p)
        (> p 1)
        (integerp q)
        (> q 0))
   (equal
    (expo (idecode x p q))
    (cond ((nencodingp x p q)
           (- (iexpof x p q) (bias q)))         
          ((dencodingp x p q)
           (+ 2 (- p) (- (bias q)) (expo (isigf x p)))))))         
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable idecode iencodingp)
                              '(ndecode-rewrite)))))


;these are expensive f-c rules?
(defthm expo-of-non-negative-integerp
  (implies (and (integerp n)
                (>= n 0))
           (>= (expo n) 0))
  :hints (("Goal" :in-theory (enable expo)
           :use ((:instance expo>= 
                            (x n)
                            (n 0)))))
  :rule-classes (:rewrite :type-prescription))

;(:FORWARD-CHAINING :TRIGGER-TERMS ((expo n)))

(defthm expo-bvecp-non-negative
  (implies (bvecp x n)
           (<= 0 (expo x)))
  :rule-classes (:rewrite
                 :TYPE-PRESCRIPTION))
;(:FORWARD-CHAINING :TRIGGER-TERMS ((expo n)))

(defthm expo-bvecp-upper-bound
  (implies (and (bvecp x n)
                (integerp n)
                (> n 0))
           (< (expo x) n ))
  :hints (("Goal" :in-theory (enable bvecp)
           :use ((:instance expo<= ( n (- n 1))))))
  :rule-classes (:rewrite :linear))

;(:FORWARD-CHAINING :TRIGGER-TERMS ((expo x)))

;remove?
(defthm integer-expo-bvecp
  (implies (and (integerp n)
                (>= n 0))
           (bvecp n (+ (expo n) 1)))
  :hints (("Goal" :in-theory (enable bvecp)
           :use ((:instance expo-upper-bound (x n))))))

(in-theory (disable bvecp-exactp))

;elsewhere?
(defthm exactp-minus-rewrite
  (equal (exactp (* -1 x) n)
         (exactp x n))
  :hints (("Goal" :use (exactp-minus))))

;elsewhere?
(defthm exactp-shift-rewrite
  (implies (and (rationalp x)
                (integerp m)
                (integerp n))
           (and (equal
                 (exactp (* (expt 2 n) x) m)
                 (exactp x m))
                (equal
                 (exactp (* x (expt 2 n)) m)
                 (exactp x m))))
  :hints (("Goal" :use exactp-shift-iff)))

(defthm integer-expo-exact-pos
  (implies (and (integerp n)
                (>= n 0))
           (and
            (exactp n (+ (expo n) 1))
            (exactp n (+ 1 (expo n)))))
  :hints (("Goal" :in-theory (enable natp bvecp)
           :use ((:instance bvecp-exactp (x n) (n (+ (expo n) 1)))
                 (:instance expo-upper-bound (x n))))))

;add?
(defthm integer-expo-exact
  (implies (integerp n)
           (and
            (exactp n (+ (expo n) 1))
            (exactp n (+ 1 (expo n)))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expo-minus)
                              '(integer-expo-exact-pos))
           :use ((:instance integer-expo-exact-pos (n (- n)))
                 (:instance integer-expo-exact-pos (n n))))))

(local
 (defthm drepp-decode-1
  (IMPLIES (AND (DENCODINGP X P Q)
                (INTEGERP P)
                (< 1 P)
                (INTEGERP Q)
                (< 0 Q))
           (EXACTP (DDECODE X P Q)
                   (+ (* -1 (BIAS Q))
                      (EXPT 2 (+ -1 Q))
                      (EXPO (ISIGF X P)))))
  :hints (("Goal" :in-theory (enable ddecode dencodingp bias)))))     

(defthm drepp-ddecode
  (implies (and (dencodingp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (drepp (ddecode x p q) p q))
  :hints (("Goal" :in-theory (enable drepp))))


;add? ;three summand version?
(defthm exactp-minus-dist
  (equal (exactp (+ (* -1 x) (* -1 y)) n)
         (exactp (+ x y) n))
  :hints (("Goal" :in-theory (disable exactp-minus-rewrite)
          :use (:instance exactp-minus-rewrite (x (* -1 (+ x y)))))))

(defthm nrepp-ndecode-hack
   (implies (and (nencodingp x p q)
                 (integerp p)
                 (> p 1)
                 (integerp q)
                 (> q 0))
           (exactp (ndecode x p q) p))
   :hints (("Goal" :in-theory (set-difference-theories
                               (enable nrepp nencodingp ndecode exactp
                                       sig-shift sig-shift-2 sig-minus)
                               '(a9 distributivity)))
           (and stable-under-simplificationp
                '(:in-theory (enable a9 distributivity)))))

(defthm nrepp-ndecode
  (implies (and (nencodingp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (nrepp (ndecode x p q) p q))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable nrepp nencodingp)
                              '(ndecode-rewrite)))))

(defthm irepp-idecode
  (implies (and (iencodingp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (irepp (idecode x p q) p q))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable idecode irepp iencodingp)
                              '( NDECODE-REWRITE)))))


(DEFTHM integerp-cat
  (IMPLIES (AND (integerp x)
                (integerp y)
                (integerp n)
                (>= n 0)
                )
           (and (integerp (CAT X Y N))
                ))
  :RULE-CLASSES (:TYPE-PRESCRIPTION :REWRITE)
  :hints (("Goal" :in-theory (enable cat))))

(local 
 (defthm nencodingp-nencode-1-2
   (IMPLIES (AND (RATIONALP X)
                 (< 0 (+ (BIAS Q) (EXPO X)))
                 (< (+ (BIAS Q) (EXPO X))
                    (+ -1 (EXPT 2 Q)))
                 (EXACTP X P)
                 (INTEGERP P)
                 (< 1 P)
                 (INTEGERP Q)
                 (< 0 Q)
                 )
            (INTEGERP (* (SIG X) (EXPT 2 (+ -1 P)))
                      ))
   :hints (("Goal" :in-theory (set-difference-theories
                               (enable exactp)
                               '(exactp-sig-x))))))


(local
 (defthm nencodingp-nencode-1
   (IMPLIES (AND (NREPP X P Q)
                 (INTEGERP P)
                 (< 1 P)
                 (INTEGERP Q)
                 (< 0 Q))
            (INTEGERP (NENCODE X P Q)))
   :hints (("Goal" :in-theory (set-difference-theories (enable nencode nrepp cat)
                                                       '(nencodingp-nencode-1-2))
            :use nencodingp-nencode-1-2))))

(in-theory (disable cat))

;means natp-integerp had to be enabled in an event below
(local
 (defthm nencodingp-nencode-2-1
   (IMPLIES (AND (RATIONALP X)
                 (NOT (EQUAL X 0))
                 (< 0 (+ (BIAS Q) (EXPO X)))
                 (< (+ (BIAS Q) (EXPO X))
                    (+ -1 (EXPT 2 Q)))
                 (EXACTP X P)
                 (INTEGERP P)
                 (< 1 P)
                 (INTEGERP Q)
                 (< 0 Q)
                 )
            (natp (+ (* -1 (EXPT 2 (+ -1 P)))
                     (* (SIG X) (EXPT 2 (+ -1 P))))
                  ))
   :hints (("Goal" :in-theory (enable natp exactp)
            :use ( sig-lower-bound exactp-sig-x)))))

(local 
 (defthm nencodingp-nencode-2
   (IMPLIES (AND (NREPP X P Q)
                 (INTEGERP P)
                 (< 1 P)
                 (INTEGERP Q)
                 (< 0 Q))
            (<= 0 (NENCODE X P Q)))
 :hints (("Goal"  :in-theory (enable nencode nrepp)))))

(local
 (defthm nencodingp-nencode-3
   (IMPLIES (AND (NREPP X P Q)
                 (INTEGERP P)
                 (< 1 P)
                 (INTEGERP Q)
                 (< 0 Q))
            (< (NENCODE X P Q) (EXPT 2 (+ P Q))))
   :hints (("Goal" :in-theory (set-difference-theories
                               (enable nencode nrepp natp bvecp expt natp-integerp)
                                       '(cat-bvecp))
            :use (sig-lower-bound
                  sig-upper-bound
                  (:instance cat-bvecp
                             (x (CAT 1 (+ (BIAS Q) (EXPO X)) Q))
                             (y (+ (* -1 (EXPT 2 (+ -1 P)))
                                   (* (SIG X) (EXPT 2 (+ -1 P)))))
                             (n (+ -1 P))
                             (p (+ p q)))
                  (:instance cat-bvecp
                             (x (+ (BIAS Q) (EXPO X)))
                             (y (+ (* -1 (EXPT 2 (+ -1 P)))
                                   (* (SIG X) (EXPT 2 (+ -1 P)))))
                             (n (+ -1 P))
                             (p (+ p q)))))
                 
           ;; Ouch!  The following two hints mimic the use of split in the
           ;; proof-checker after the initial :use hint.  Matt K. added this in
           ;; order to get the proof through after installing a modification to
           ;; the development version of ACL2 2.6 that includes the
           ;; assume-true-false patch, but does not yet know whether the need
           ;; to do so signifies a deficiency in ACL2 that should be remedied.
           ("Goal'''" :in-theory '(implies))
           '(:computed-hint-replacement
             t
             :in-theory (enable nencode nrepp natp bvecp expt cat-bvecp natp-integerp)))))

(local
 (defthm nencodingp-nencode-4
   (IMPLIES (AND (NREPP X P Q)
                 (INTEGERP P)
                 (< 1 P)
                 (INTEGERP Q)
                 (< 0 Q))
            (< 0 (IEXPOF (NENCODE X P Q) P Q)))
   :hints (("Goal"  :in-theory (enable nrepp nencode iexpof natp bvecp natp-integerp)
            :use (sig-upper-bound sig-lower-bound)))))

(local
 (encapsulate
  ()

; Proof of nencodingp-nencode-5-lemma modified by Matt K. for v2-9, due to the
; change to rewrite-clause that avoids using forward-chaining facts derived
; from a literal that has been rewritten.

  (local
   (defthm nencodingp-nencode-5-lemma


     (or (not (NREPP X P Q))
         (IMPLIES (AND 
                   (INTEGERP P)
                   (< 1 P)
                   (INTEGERP Q)
                   (< 0 Q))
                  (< (IEXPOF (NENCODE X P Q) P Q)
                     (+ -1 (EXPT 2 Q)))))
     :rule-classes nil
     :hints (("Goal"  :in-theory (enable nrepp nencode iexpof natp bvecp natp-integerp)
              :use (sig-upper-bound sig-lower-bound)))))

  (defthm nencodingp-nencode-5

; rewrite rule based on the above

    (IMPLIES (AND (NREPP X P Q)
                  (INTEGERP P)
                  (< 1 P)
                  (INTEGERP Q)
                  (< 0 Q))
             (< (IEXPOF (NENCODE X P Q) P Q)
                (+ -1 (EXPT 2 Q))))
    :hints (("Goal"  :use nencodingp-nencode-5-lemma)))))

(defthm nencodingp-nencode
    (implies (and (nrepp x p q)
                  (integerp p)
                  (> p 1)
                  (integerp q)
                  (> q 0))
             (nencodingp (nencode x p q) p q) )
    :hints (("Goal" :in-theory (enable nencodingp bvecp)))
    :OTF-FLG T)

(local
 (defthm dencodingp-dencode-hack-2
   (implies (and (drepp x p q)
                 (integerp p)
                 (> p 1)
                 (integerp q)
                 (> q 0))
            (<= 0 
                (EXPT 2 (+ -3 P  (EXPT 2 (+ -1 Q))))))))

(local (in-theory (disable dencodingp-dencode-hack-2)))

(local
 (defthm dencodingp-dencode-hack-3
   (implies (and (drepp x p q)
                 (integerp p)
                 (> p 1)
                 (integerp q)
                 (> q 0))
            (equal (* (SIG X)
                      (EXPT 2 (+ -3 P (EXPO X) (EXPT 2 (+ -1 Q)))))
                   (* (abs x) (EXPT 2 (+ -3 P (EXPT 2 (+ -1 Q)))))))
   :hints (("Goal" :in-theory (set-difference-theories
                               (enable drepp sgn)
                               '(abs))
            :use fp-abs))
   :rule-classes nil))



(local
 (defthm dencodingp-dencode-hack-1
   (implies (and (drepp x p q)
                 (integerp p)
                 (> p 1)
                 (integerp q)
                 (> q 0))
            (natp (* (SIG X)
                     (EXPT 2 (+ -3 P (EXPO X) (EXPT 2 (+ -1 Q)))))))
           
   :hints (("Goal" :in-theory (set-difference-theories (enable dencodingp drepp natp dencode
                                                               iexpof
                                                               isigf
                                                               bias exactp
                                                               )
                                                       '(abs))
            :use ( dencodingp-dencode-hack-3)))))


(local 
 (defthm dencodingp-dencode-hack-5
   (implies (and (drepp x p q)
                 (integerp p)
                 (> p 1)
                 (integerp q)
                 (> q 0))
            (<= (+ -3 P (EXPO X) (EXPT 2 (+ -1 Q))) (- p 2)))
   :hints (("Goal" :in-theory (set-difference-theories (enable dencodingp drepp natp dencode
                                                               iexpof isigf bias exactp
                                                               bvecp)
                                                       '(abs))))
   :rule-classes nil))







(local 
 (defthm dencodingp-dencode-hack-4
   (implies (and (drepp x p q)
                 (integerp p)
                 (> p 1)
                 (integerp q)
                 (> q 0))
            (bvecp (* (SIG X)
                      (EXPT 2 (+ -3 P (EXPO X) (EXPT 2 (+ -1 Q))))) (- p 1)))
           
   :hints (("Goal" :in-theory (set-difference-theories (enable dencodingp drepp natp dencode
                                                               iexpof isigf bias exactp
                                                               expt
                                                               bvecp)
                                                       '(abs))
            :use ( dencodingp-dencode-hack-3
                   sig-upper-bound 
                   dencodingp-dencode-hack-5
                   (:instance expt-weak-monotone
                              (n (+ -3 P (EXPO X) (EXPT 2
                                                        (+
                                                         -1
                                                         Q))))
                              (m (- p 2))))))))

(local (in-theory (disable dencodingp-dencode-hack-4)))

(in-theory (disable cat-associative)) ;yuck

(defthm dencodingp-dencode
  (implies (and (drepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (dencodingp (dencode x p q) p q) )
  :hints (("Goal" :in-theory (enable exactp 
                                     dencodingp 
                                     drepp 
                                     natp 
                                     dencode
                                     iexpof 
                                     isigf 
                                     bias
                                     bvecp
                                     bvecp-bits-0)
           :use (sig-upper-bound 
                 sig-lower-bound 
                 dencodingp-dencode-hack-4
                 (:instance expt-strong-monotone
                            (n (- p 1))
                            (m (+ p q)))))))


(defthm iencodingp-iencode
  (implies (and (irepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (iencodingp (iencode x p q) p q) )
  :hints (("Goal" :in-theory (enable iencodingp irepp iencode))))




(defthm isgnf-nencode-1
  (IMPLIES (AND (RATIONALP X)
                (NOT (EQUAL X 0))
                (< 0 (+ (BIAS Q) (EXPO X)))
                (< (+ (BIAS Q) (EXPO X))
                   (+ -1 (EXPT 2 Q)))
                (EXACTP X P)
                (INTEGERP P)
                (< 1 P)
                (INTEGERP Q)
                (< 0 Q)
                )
           (bvecp (+ (* -1 (EXPT 2 (+ -1 P)))
                     (* (SIG X) (EXPT 2 (+ -1 P))))
                  (- p 1)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable natp bvecp)
                              '(nencodingp-nencode-2-1))
           :use (sig-lower-bound sig-upper-bound nencodingp-nencode-2-1)))
:rule-classes nil)



(defthm isgnf-nencode-2
  (IMPLIES (AND (RATIONALP X)
                (NOT (EQUAL X 0))
                (< 0 (+ (BIAS Q) (EXPO X)))
                (< (+ (BIAS Q) (EXPO X))
                   (+ -1 (EXPT 2 Q)))
                (EXACTP X P)
                (INTEGERP P)
                (< 1 P)
                (INTEGERP Q)
                (< 0 Q)
                )
           (bvecp (+ (bias q) (expo x)) q))
    :hints (("Goal" :in-theory 
                              (enable bias bvecp))))

(in-theory (disable isgnf-nencode-2))                 

(defthm isgnf-nencode
  (implies (and (nrepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (isgnf (nencode x p q) p q)
            (if (= (sgn x) 1) 0 1)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable isgnf nencode nrepp bvecp)
                              '(nencodingp-nencode-2-1 bitn-bvecp-0))
           :use (nencodingp-nencode-2-1
                 sig-lower-bound
                 sig-upper-bound
                 isgnf-nencode-2
                 (:instance bitn-bvecp-0 (m 0)
                            (x (+ (BIAS Q) (EXPO X)))
                            (n q))))))

(defthm isgnf-dencode
  (implies (and (drepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (isgnf (dencode x p q) p q)
            (if (= (sgn x) 1) 0 1)))

  :hints (("Goal" :in-theory (set-difference-theories
                              (enable isgnf dencode drepp bvecp bias)
                              '(nencodingp-nencode-2-1 bitn-bvecp-0))
           :use (dencodingp-dencode-hack-4 
                 (:instance bitn-bvecp-0 
                            (m q)
                            (x (* (SIG X)
                                  (EXPT 2 (+ -3 P (EXPO X) (EXPT 2 (+ -1 Q))))))
                            (n (- p 1)))))))


(defthm isgnf-iencode
  (implies (and (irepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (isgnf (iencode x p q) p q)
            (if (= (sgn x) 1) 0 1)))

  :hints (("Goal" :in-theory (enable irepp iencode))))
  






(defthm isigf-nencode-1
  (implies (and (nrepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (bvecp (+ (* -2 (EXPT 2 (+ -2 P)))
                     (* 2 (SIG X) (EXPT 2 (+ -2 P)))) (- p 1)   ))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable isigf nencode nrepp bvecp expt)
                              '())
           :use isgnf-nencode-1))
  :rule-classes nil)

(defthm isigf-nencode
  (implies (and (nrepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (isigf (nencode x p q) p)
            (* (- (sig x) 1) (expt 2 (- p 1)))))
  :hints (("Goal" :in-theory (enable isigf nencode nrepp natp expt)
           :use (isigf-nencode-1))))

(defthm isigf-dencode
  (implies (and (drepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (isigf (dencode x p q) p)
            (* (sig x) (expt 2 (+ -2 p (expo x) (bias q))))))
            
 :hints (("Goal" :in-theory (enable isigf dencode drepp natp bias)
          :use dencodingp-dencode-hack-4)))

(defthm iexpof-nencode
  (implies (and (nrepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (iexpof (nencode x p q) p q)
            (+ (expo x) (bias q))))
  :hints (("Goal" :in-theory (enable iexpof nencode nrepp natp bvecp natp-integerp expt) 
           :use (
                 isigf-nencode-1

                 ))))



(defthm iexpof-dencode
  (implies (and (drepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal (iexpof (dencode x p q) p q)
                  0))
  :otf-flg t
  :hints (("Goal" :in-theory (enable iexpof dencode drepp natp bias
                                      bvecp-bits-0
                                      )
           :use (dencodingp-dencode-hack-4))))

(defthm ndecode-nencode
  (implies (and (nrepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (ndecode (nencode x p q) p q)
            x))
  :hints (("Goal" :in-theory (enable nrepp ndecode cat sgn)
          :use fp-abs)))

(defthm ddecode-dencode
  (implies (and (drepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (ddecode (dencode x p q) p q)
            x))
  :hints (("Goal" :in-theory (enable drepp ddecode cat sgn)
          :use fp-abs)))

(defthm not-both-nrepp-and-drepp
  (implies (irepp x p q)
	   (iff (nrepp x p q)
		(not (drepp x p q))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable irepp nrepp drepp))))


(in-theory (disable dencodingp-dencode))

(defthm idecode-iencode
  (implies (and (irepp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (idecode (iencode x p q) p q)
            x))
  :hints (("Goal" :in-theory (enable irepp idecode iencode idecode)
		  :use (dencodingp-dencode
			not-both-nrepp-and-drepp
			(:instance not-both-nencodingp-and-dencodingp (x (dencode x p q)))))))

(local 
 (defthm hack-eric-2
   (implies (AND
             (BVECP X (+ P Q))
             (NATP P)
             (< 1 P)
             (NATP Q)
             (< 0 Q)
             (nencodingp x p q))
            (equal
             (+ (BITS X (+ -2 P) 0)
                (* 2 (EXPT 2 (+ -2 P Q)))
                (* 2 (EXPT 2 (+ -2 P))
                   (BITS X (+ -2 P Q) (+ -1 P))))
             (+ (BITS X (+ -2 P Q) 0)
                (* 2 (EXPT 2 (+ -2 P Q)))) ))
   :hints (("Goal" :in-theory (enable nencodingp expt) 
            :use ((:instance bits-plus-bits
                             (x x)
                             (m (+ -1 p q)) 
                             (n (- p 1))
                             (r 0)))))
   :rule-classes nil))



(defthm nencode-ndecode
  (implies (and (nencodingp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (nencode (ndecode x p q) p q)
            x))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable nencodingp nencode iexpof isigf isgnf sgn
                                      cat natp)
                              '(ndecode-rewrite))
           :use ((:instance bits-plus-bits
                            (r 0)
                            (n (- p 1))
                            (m (+ -1 p q)))
                 (:instance bits-plus-bitn
                            (n (+ p q -1))
                            (m 0))
                 hack-eric-2
                 (:instance bitn-0-1 (x x) (n (+ -1 p
                                                 q)))))))


(local 
 (defthm hack-eric-2-two
   (implies (AND
             (BVECP X (+ P Q))
             (NATP P)
             (< 1 P)
             (NATP Q)
             (< 0 Q)
             (dencodingp x p q)
             )
            (equal
             (+ (BITS X (+ -2 P) 0)
                (* 2 (EXPT 2 (+ -2 P Q)))
                (* 2 (EXPT 2 (+ -2 P))
                   (BITS X (+ -2 P Q) (+ -1 P))))
             (+ (BITS X (+ -2 P Q) 0)
                (* 2 (EXPT 2 (+ -2 P Q)))) ))
   :hints (("Goal" :in-theory (enable dencodingp expt) 
            :use ((:instance bits-plus-bits
                             (x x)
                             (m (+ -1 p q)) 
                             (n (- p 1))
                             (r 0)))))
   :rule-classes nil))

; reduce the number of cases?
(defthm dencode-ddecode
  (implies (and (dencodingp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (dencode (ddecode x p q) p q)
            x))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable dencodingp dencode iexpof isigf isgnf sgn
                                      cat natp)
                              '())
           :use ((:instance bits-plus-bits
                            (r 0)
                            (n (- p 1))
                            (m (+ -1 p q)))
                 (:instance fp-rep (x (BITS X (+ -2 P) 0)))
                 (:instance bits-plus-bitn
                            (n (+ p q -1))
                            (m 0))
                 hack-eric-2-two
                 (:instance bitn-0-1 (x x) (n (+ -1 p
                                                 q)))
                 (:instance bitn-0-1 (x x) (n (+ -2 p
                                                 q)))
                 (:instance fp-rep (x (BITS X (+ -2 P) 0)))))))

(defthm iencode-idecode
  (implies (and (iencodingp x p q)
                (integerp p)
                (> p 1)
                (integerp q)
                (> q 0))
           (equal
            (iencode (idecode x p q) p q)
            x))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable irepp idecode iencode idecode)
                              '(ndecode-rewrite))
		  :use (not-both-nencodingp-and-dencodingp
			(:instance not-both-nrepp-and-drepp (x (ddecode x p q)))))))

;needed?
(defthm bias-non-negative-integerp-type-prescription
  (implies (and (integerp q)
                (> q 0))
           (and (integerp (bias q))
            (>= (bias q) 0)))
  :hints (("Goal" :in-theory (enable bias)))
  :rule-classes :TYPE-PRESCRIPTION
  )

