(in-package "ACL2")

(include-book "rtl")



;; NOTE:: all proofs are now in bits2-proofs.lisp  !!

(local (include-book "bits2-proofs")) 
(include-book "expo")


(DEFUN FL (X) (FLOOR X 1))

#|
(include-book
 "ground-zero") ; move up
(include-book
 "mod2")
(include-book
 "factor-2")
;(include-book
; "remmod")
(include-book
 "expt")
(include-book
 "fl")
(include-book
 "defs")
(include-book
 "lowbits")
(include-book
 "factor-out")
|#


;this book is still a mess

;should bits-rewrite-to-bits be exported disabled?

#|

bits is like Russinoff's "bits" but uses mod instead of rem.
The use of "mod" seems to allow nicer results to be proved.

For example, unlike bits, bits *always* returns a non-negative integer.  Many hyps of other lemmas require
expressions to be non-negative integers, and with bits, this requires further checking of the arguments (at
worst, checking all the way to the leaves of the expression tree each time).

My scheme for using bits involves immediately rewriting bits to bits (from the inside out).

The file mixed.lisp contains bits versions of many of the results about bits.

|#


#|
todo:
 add case-split to all hyps about i and j (indices to bits must be integers and j must be <= i or else weird
stuff happens (but we can easily handle these cases).

|#

;In proofs about RTL terms, i and j are almost always constants

(defun bits (x i j)
  (if (or (not (integerp i))
          (not (integerp j)))
      0
  (fl (/ (mod x (expt 2 (1+ i))) (expt 2 j)))))

(in-theory (disable bits))


(defthm bits-nonnegative-integerp-type
  (and (<= 0 (bits x i j))
       (integerp (bits x i j)))
  :rule-classes (:type-prescription))

;this rule is no better than bits-nonnegative-integer-type and might be worse
(in-theory (disable (:type-prescription bits)))

(defthm bits-natp
  (natp (bits x i j)))

(defthm bits-with-x-0
  (equal (bits 0 i j)
         0))

(defthm bits-of-non-rational
  (implies (not (rationalp x))
           (equal (bits x i j)
                  0)))

(defthm bits-with-i-not-an-integer
  (implies (not (integerp i))
           (equal (bits x i j)
                  0))
  :hints (("Goal" :in-theory (enable bits))))

(defthm bits-with-j-not-an-integer
  (implies (not (integerp j))
           (equal (bits x i j)
                  0))
  :hints (("Goal" :in-theory (enable bits))))


(defthm bits-with-indices-in-the-wrong-order
  (implies (< i j)
           (equal (bits x i j)
                  0)))

(defthm bits-upper-bound
  (< (bits x i j) (expt 2 (+ 1 i (- j))))
  :rule-classes (:rewrite (:linear :trigger-terms ((bits x i j))))
  :hints (("Goal" :in-theory (enable bits 
                                     expt-pull-negation-out-of-power
                                     expt-split))))

;tigher bound
(defthm bits-upper-bound-tighter
  (implies (case-split (<= j i))
           (<= (bits x i j) (+ -1 (expt 2 (+ i 1 (- j))))))
  :rule-classes (:rewrite (:linear :trigger-terms ((bits x i j))))
  :hints (("Goal" :cases ((rationalp x) (not (acl2-numberp x)))
           :in-theory (enable bits 
                              expt-pull-negation-out-of-power
                              expt-split))))
  
;like  mod-upper-bound-3
(defthm bits-upper-bound-2
  (implies (<= (expt 2 (+ 1 i (- j))) z)
           (< (bits x i j) z)))


;I have many theorems dealing with the simplification of bits of a sum



#|
;taking sort of a long time (3-4 secs)
(defthm bits-sum-lowbits
  (implies (and (rationalp x)
                (rationalp y)
                (integerp i)
                (integerp j))
           (equal (bits (+ x             y) i j)
                  (bits (+ (lowbits x i) y) i j))))
(in-theory (disable bits-sum-lowbits))

;special case of the above -- helps rewrite the constant to a unique (positive) value
;make another rule to handle negative constants
(defthm bits-sum-reduce-leading-constant
  (implies (and (syntaxp (and (quotep x) (>= (cadr x) (expt 2 (+ (cadr i) 1)))))
                (rationalp x)
                (rationalp y)
                (integerp i)
                (integerp j))
           (equal (bits (+ x             y) i j)
                  (bits (+ (lowbits x i) y) i j))))
|#


;a is a free var
(defthm bits-force
  (implies (and (integerp x)
                (integerp i)
                (>= i 0)
                (integerp a)
                (<= (* a (expt 2 (+ i 1))) x)
                (< x (* (1+ a) (expt 2 (+ i 1)))))
           (equal (bits x i 0) (- x (* a (expt 2 (+ i 1))))))
  :rule-classes nil
)

(defthm bits-force-with-a-chosen-neg
  (implies (and (integerp x)
                (integerp i)
                (>= i 0)
                (<= (* -1 (expt 2 (+ i 1))) x)
                (< x 0))
           (equal (bits x i 0) (- x (* -1 (expt 2 (+ i 1)))))))
                                      

#|
;high bits don't matter - add syntaxp hyp that one addend is a constant with high bits still present

(defthm bits-blah
  (implies (and (integerp m)
                (integerp i)
                (>= i 0)
                (< m 0)
                (>= m (* -1 (expt 2 (+ i 1)))))
           (equal (bits m i 0) (- m (* -1 (expt 2 (+ i 1))))))
  :hints (("Goal" :in-theory (enable bits)))
  )
|#

(defthm bits-shift
  (implies (and (case-split (integerp n))
                (case-split (integerp i))
                (case-split (integerp j))
                )
           (and (equal (bits (* (expt 2 n) x) i j)
                       (bits x (- i n) (- j n)))
                (equal (bits (* x (expt 2 n)) i j)
                       (bits x (- i n) (- j n))))))





(defthm bits-shift-to-make-j-0
  (implies (and (syntaxp (and (quotep j) (> (cadr j) 0)))
;                (rationalp x)
                (integerp i)
                (integerp j)
                )
           (equal (bits x i j )
                  (bits (* (expt 2 (- j)) x) (- i j) 0))))

(in-theory (disable bits-shift-to-make-j-0))




;special case of the above with leading constant (power of 2) factor
(defthm bits-shift-leading-constant
  (implies (and (syntaxp (quotep k))
                (equal k (expt 2 (expo k)))
                (rationalp k)
 ;               (rationalp x)
                (integerp i)
                (integerp j)
                )
           (equal (bits (* k x) i j)
                  (bits x (- i (expo k)) (- j (expo k)) ))))

(in-theory (disable bits-shift-leading-constant)) ;this rule can loop with bits-shift-to-make-j-0

#|
;why have this?
(defthm bits-shift-out-even
  (implies (and (integerp x)
                (evenp x)
                (integerp i)
                (integerp j)
                (>= i j))
           (equal (bits x i j)
                  (bits (/ x 2) (- i 1) (- j 1) )))
  :hints (("Goal" :in-theory (enable expt-pull-negation-out-of-power
                                     bits 
                                     mod-cancel 
                                     expt-split-rewrite)))
  )
|#




;(in-theory (enable natp))

;allows you to split bit vectors into two parts
;free var n (where to split)
;resembles doc's bits-plus-bits
(defthm bits-plus-bits2
  (implies (and ;(rationalp x)
                (integerp i) 
                (integerp j)
                (integerp n)
                (<= j n)
                (<= n i))
           (equal (bits x i j)
                  (+ (* (bits x i n) (expt 2 (- n j)))
                     (bits x (1- n) j))))
  :rule-classes nil)

;a hint that worked for this before I made such nice rules is in junk.lisp under bits-plus-bits-hint

;(in-theory (disable bits-plus-bits)) ;keep disabled



#|
;use mbitn?
;could use even-odd phrasing?
(defthm bits-down-to-1-case-split
  (implies (and (integerp x)
                (>= x 0)
                (integerp i)
                (>= i 1))
           (equal (bits x i 1)
                  (if (equal (bitn x 0) 0)
                      (/ (bits x i 0) 2) ;use the fact that we know bit 0 is 0?
                    (/ (+ -1 (bits x i 0)) 2) ;use the fact that we know bit 0 is 1?
                    ))))
|#

;this really has two separate cases
;generalize with j not 0?
(defthm bits-split-around-zero
  (implies (and (>= x (- (expt 2 (+ i 1))))
                (< x (expt 2 (+ i 1)))
                (integerp x)
                (integerp i)
                (<= 0 i)
                )
           (equal (bits x i 0)
                  (if (<= 0 x)
                      x
                    (+ x (expt 2 (+ i 1)))))))



;dup
(defun bvecp (x k)
  (and (integerp x)
       (>= x 0)
       (< x (expt 2 k))))

(defthm bits-bvecp
  (implies (and (<= (+ 1 i (- j)) n)
                (case-split (integerp n))
                )
           (bvecp (bits x i j) n)))

;do we want this rule enabled?
(defthm bits-bvecp-fw
  (implies (equal n (- (1+ i) j)) ; note equal here to help with the fw chaining
           (bvecp (bits x i j) n))
  :rule-classes
  ((:forward-chaining :trigger-terms ((bits x i j)))))


#|
;would like these
;x<2^n
(defthm test2
  (IMPLIES (AND (INTEGERP N) (<= 0 N) (rationalP X) (<= 0 x))
         (EQUAL (FLOOR (* 1/2 x) 1)
                (FLOOR (* 1/2 (FLOOR x 1))
                       1)))
  :otf-flg t
  :hints (("Goal" :in-theory (enable floor))))

  :otf-flg t
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable fl)
                              '(floor-fl-eric))))
)


(defthm test
  (IMPLIES (AND (INTEGERP N) (<= 0 N) (INTEGERP X))
         (EQUAL (FL (* 1/2 X (/ (EXPT 2 N))))
                (FL (* 1/2 (FL (* X (/ (EXPT 2 N))))))))
  :otf-flg t
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable fl)
                              '(floor-fl-eric)))))
)

;really would like this for mbitn
(defthm bits-n-n-rewrite
  (implies (and (integerp n)
                (<= 0 n)
                (integerp x))
           (equal (bits x n n)
                  (bitn x n)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable mod
                                      bits bitn-def-mod
                                       expt-pull-negation-out-of-power
                                       expt-split-rewrite)
                              '(expt-inverse
                                 BITN-0-MEANS-EVEN ;eff
;mod-cancel
                                ))
)))


|#


#|


;these may be made moot by my method of using lowbits with bits of a sum

(defthm bits-sum-simplify-first-term
  (implies (and (>= (abs x) (expt 2 (+ j 1))) ;prevents loop
                (rationalp x)
                (rationalp y)
                (integerp j)
                (<= 0 j)
                )
           (equal (bits (+ x y) j 0)
                  (bits (+ (lowbits x j) y) j 0))))

(defthm bits-sum-simplify-second-term
  (implies (and (>= (abs x) (expt 2 (+ j 1))) ;prevents loop
                (rationalp x)
                (rationalp y)
                (integerp j)
                (<= 0 j)
                )
           (equal (bits (+ y x) j 0)
                  (bits (+ (lowbits x j) y) j 0))))

|#


;from nbits (moved here after I proved that nbits and bits were the same)


;better names: make the dropped term x, the others a,b,c,...
;;; more bits thms like this!

(defthm bits-sum-drop-irrelevant-term-2-of-2
  (implies (integerp (/ y (expt 2 (+ 1 i))))
           (equal (bits (+ x y) i j)
                  (bits x i j))))

(defthm bits-sum-drop-irrelevant-term-1-of-2
  (implies (integerp (/ y (expt 2 (+ 1 i))))
           (equal (bits (+ y x) i j)
                  (bits x i j))))



(defthm bits-sum-drop-irrelevant-term-3-of-3
  (implies (integerp (/ y (expt 2 (+ 1 i))))
           (equal (bits (+ w x y) i j)
                  (bits (+ w x) i j))))

(defthm bits-sum-drop-irrelevant-term-2-of-3
  (implies (integerp (/ y (expt 2 (+ 1 i))))
           (equal (bits (+ w y x) i j)
                  (bits (+ w x) i j))))


#|

This series of events deals with simplifying expressions like
(equal (bits x 8 0) 
       (+ (bits x 6 0) k))
Intuitively, bits 6 down-to 0 appear on both sides of the sum and should be "cancelled".  
The remaining bits will need to be "shifted" back into place.

More rules are probably needed to make the theory complete.
|#

#|
(defthm bits-cancel-lowbits-in-comparison
  (implies (and (> i+ i)
                (rationalp k)
                (rationalp x)
                (integerp i)
                (integerp j)
                (<= j i)
                (integerp i+)
                )
           (equal (equal (+ k (bits x i j))
                         (bits x i+ j))
                  (equal (* (expt 2 (+ 1 i (- j))) 
                            (BITS X I+ (+ 1 I))) 
                         k))))

(defthm bits-cancel-lowbits-in-comparison-alt-2
  (implies (and (> i+ i)
                (rationalp k)
                (rationalp x)
                (integerp i)
                (integerp j)
                (<= j i)
                (integerp i+)
                )
           (equal (equal (+ (bits x i j) k)
                         (bits x i+ j))
                  (equal (* (expt 2 (+ 1 i (- j))) 
                            (BITS X I+ (+ 1 I))) 
                         k))))



;todo: rephrase the conclusion of the above by moving the "constant" (* 2 (EXPT 2 I) (/ (EXPT 2 J))) to the other
;side
;a good idea since k is usually divisible by that quantity (with the rule above, we often end up with an
equality in which each side should have a power of 2 divided out of it
; not needed if we have good meta rules for cancelling factors from an inequality


(defthm bits-cancel-lowbits-in-comparison-2
  (implies (and (> i+ i)
                (rationalp k)
                (rationalp x)
                (integerp i)
                (integerp j)
                (<= j i)
                (integerp i+)

                )
           (equal (equal (+ k (bits x i j))
                         (bits x i+ j))
                  (equal (*  
                            (BITS X I+ (+ 1 I))) 
                         (/ k (expt 2 (+ 1 i (- j)))))))
  :hints (("Goal"          
           :use (:instance bits-cancel-lowbits-in-comparison)
           :in-theory (set-difference-theories
                       (enable expt-split-rewrite)
                       '(bits-cancel-lowbits-in-comparison))
           )))




(defthm bits-cancel-lowbits-in-comparison-3
  (implies (and (> i+ i)
                (rationalp k)
                (rationalp x)
                (integerp i)
                (integerp j)
                (<= j i)
                (integerp i+)
                (rationalp y)
                )
           (equal (equal (+ (bits x i+ j) k)
                         (+ y (bits x i j)))
                  (equal (* (expt 2 (+ 1 i (- j )))
                            (BITS X I+ (+ 1 I))) 
                         (- y k)))))

;better conclusion?
(defthm bits-cancel-lowbits-in-comparison-no-constant
  (implies (and (> i+ i)
                (rationalp x)
                (integerp i)
                (integerp j)
                (<= j i)
                (integerp i+)
                )
           (equal (equal (bits x i j)
                         (bits x i+ j))
                  (equal (* 2 (EXPT 2 I)
                           (/ (EXPT 2 J))
                           (BITS X I+ (+ 1 I))) 
                         0))))

(defthm bits-cancel-lowbits-in-comparison-no-constant-2
  (implies (and (> i+ i)
                (rationalp x)
                (integerp i)
                (integerp j)
                (<= j i)
                (integerp i+)
                )
           (equal (equal (bits x i+ j)
                         (bits x i j))
                  (equal (* 2 (EXPT 2 I)
                           (/ (EXPT 2 J))
                           (BITS X I+ (+ 1 I))) 
                         0))))
|#

;the theory above (cancelling bits in comparisons) is not complete
;it should also deal with bitn
;perhaps a meta rule would be a good idea here?




;kind of yucky
(defthm bits-minus
  (implies (and (case-split (rationalp x))
                (case-split (integerp i))
                (case-split (<= j i))
                (case-split (integerp j))
                )
           (equal (bits (* -1 x) i j)
                  (if (integerp (* 1/2 X (/ (EXPT 2 I))))
                    (- (bits x i j))
                    (if (INTEGERP (* X (/ (EXPT 2 J))))
                        (+ (* 2 (EXPT 2 I) (/ (EXPT 2 J))) (- (bits x i j)))
                      (+ -1 (* 2 (EXPT 2 I) (/ (EXPT 2 J))) (- (bits x i j)))))))
  )

(defthm bits-minus-alt
  (implies (and (syntaxp (negative-syntaxp x))
                (case-split (rationalp x))
                (case-split (integerp i))
                (case-split (<= j i))
                (case-split (integerp j))
                )
           (equal (bits x i j)
                  (if (integerp (* 1/2 (- X) (/ (EXPT 2 I))))
                    (- (bits (- x) i j))
                    (if (INTEGERP (* (- X) (/ (EXPT 2 J))))
                        (+ (* 2 (EXPT 2 I) (/ (EXPT 2 J))) (- (bits (- x) i j)))
                      (+ -1 (* 2 (EXPT 2 I) (/ (EXPT 2 J))) (- (bits (- x) i j))))))))
(in-theory (disable bits-minus-alt))



#|

(defthm bits-shift-alt
  (implies (and (syntaxp (should-have-a-2-factor-divided-out x))
                (> j 0) ;restricts application 
                (rationalp x)
                (integerp i)
                (integerp j)
                )
           (equal (bits x i j)
                  (bits (/ x 2) (- i 1) (- j 1)))))

|#


;drops hyps like this: (<= (BITS x 30 24) 253)
;Recall that <= gets rewritten to < during proofs
(defthm bits-drop-silly-upper-bound
  (implies (and (syntaxp (quotep k))
                (>= k (+ -1 (expt 2 (+ 1 i (- j)))))
                (case-split (<= j i))
                (case-split (integerp i))
                (case-split (integerp j))
                )
           (equal (< k (bits x i j))
                  nil)))

;rewrite things like (<= 4096 (BITS x 23 12)) to false
;Recall that <= gets rewritten to < during proofs
(defthm bits-drop-silly-lower-bound
  (implies (and (syntaxp (quotep k))
                (> k (+ -1 (expt 2 (+ 1 i (- j)))))
                (case-split (<= j i))
                (case-split (integerp i))
                (case-split (integerp j))
                )
  (equal (< (bits x i j) k)
         t)))

;rewrite (< -64 (BITS (*::EX1_SRC_RECIP) 64 59)) to t
(defthm bits-drop-silly-bound-3
  (implies (and (syntaxp (quotep k))
                (< k 0)
                )
  (equal (< k (bits x i j))
         t)))

(defthm bits-drop-silly-bound-4
  (implies (and (syntaxp (quotep k))
                (<= k 0)
                )
  (equal (< (bits x i j) k)
         nil)))


#|
(defthm bits-turn-bound-into-equal
  (implies (and (syntaxp (quotep k))
                (equal k (+ -2 (expt 2 (+ 1 i (- j)))))
                (case-split (<= j i))
                (case-split (rationalp x))
                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (rationalp k))
                )
           (equal (< k (bits x i j))
                  (equal (bits x i j) (+ k 1))))
  :hints (("Goal" :in-theory (disable  bits-upper-bound-tighter
                                        bits-upper-bound
                                         bits-upper-bound-2)
           :use  bits-upper-bound-tighter))
)
|#






;junk:


#|
;why?
(defthm nbits-shift-out-even
  (implies (and (integerp x)
                (evenp x)
                (integerp i)
                (integerp j)
                (>= i j))
           (equal (nbits x i j)
                  (nbits (/ x 2) (- i 1) (- j 1)))))
;why?
(defthm nbits-shift-out-even-constant-multiplier
  (implies (and (syntaxp (and (quotep k) (evenp (cadr k))))
                (integerp x)
                (integerp k)
                (evenp k)
                (integerp i)
                (integerp j)
                (>= i j))
           (equal (nbits (* k x) i j)
                  (nbits (* 1/2 k x) (- i 1) (- j 1) )))
  :hints (("Goal" :in-theory (disable nbits nbits-shift-out-even)
           :use (:instance nbits-shift-out-even (x (* x k)))
))
)



;(in-theory (disable nbits-shift-out-even))

these two are subsumed by the above:
(defthm nbits-tail
    (implies (and (natp i)
		  (bvecp x (1+ i)))
	     (equal (nbits x i 0)
		    x)))

(defthm nbits-tail-nice
    (implies (and (integerp i)
                  (>= i 0)
                  (integerp x)
                  (<= 0 x)
                  (< x (expt 2 (+ 1 i))))
	     (equal (nbits x i 0)
		    x))
    :hints (("Goal" :in-theory (enable bvecp)))
)

|#


(defthm bits-<-1
  (equal (< (bits x i j) 1)
         (equal (bits x i j) 0)))

;put bits-cancel- in the name?
(defthm bits-at-least-zeros
  (implies (and (syntaxp (quotep k))
                (equal k (expt 2 (- j2 j)))
                (<= j j2)
                (case-split (rationalp x))
                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (integerp j2))
                )
  (equal (< (BITS x i j)
            (* k (BITS x i j2)))
         nil)))

(defthm bits-upper-with-subrange
  (implies (and (syntaxp (quotep k))
                (<= j j2)
                (equal k (expt 2 (- j2 j)))
                (case-split (<= j2 i)) ;drop?
                (case-split (rationalp x))
                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (integerp j2))
                )
           (< (BITS x i j) 
              (BINARY-+ k (BINARY-* k (BITS x i j2))))))

(defthm bits-upper-with-subrange-alt
  (implies (and (syntaxp (quotep k))
                (<= j j2)
                (equal k (expt 2 (- j2 j)))
                (case-split (<= j2 i)) ;drop?
                (case-split (rationalp x))
                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (integerp j2))
                )
           (equal (< (BINARY-+ k (BINARY-* k (BITS x i j2))) 
                     (BITS x i j))
                  nil)))


;make another version for k negative?
;do we need both of the rules below?
(defthm bits-equal-impossible-constant
  (implies (and (syntaxp (quotep k))
                (>= k (expt 2 (+ 1 i (- j))))
                )
           (equal (equal (bits x i j) k)
                  nil)))

(defthm bits-equal-impossible-constant-2
  (implies (and (syntaxp (quotep k))
                (>= k (expt 2 (+ 1 i (- j))))
                )
           (equal (equal k (bits x i j))
                  nil)))


#|
;degenerate case
;rename?
;expensive
(defthm bits-sum-drop-irrelevant-term-1-of-1
  (implies (and (rationalp x) ;(integerp x)

                (integerp i)
                (<= 0 i)
                (integerp j)
                (<= 0 j)

                (integerp (/ x (expt 2 (+ 1 i))))
                )
           (equal (bits x i j)
                  0))
  :hints (("Goal" :in-theory (enable bits bits)))
  :rule-classes ((:rewrite :backchain-limit-lst (nil nil nil nil nil 1)))
)
|#

(defthm bits-compare-to-zero
  (implies (and (case-split (rationalp x))
                (case-split (integerp i))
                (case-split (integerp j))
                )
           (equal (not (< 0 (bits x i j)))
                  (equal 0 (bits x i j)))))




;expensive?
 (defthm bits-ignore-negative-bits-of-integer
   (implies (and (integerp x)
                 (< j 0)
                 (case-split (integerp j))
                 )
            (equal (bits x i j)
                   (* (expt 2 (- j)) (bits x i 0))))
   :hints (("Goal" :cases ((<= j i))
            :in-theory (enable)))
   )






(defthm bits-does-nothing-2
  (implies (and (<= j 0) ;a bit strange (j will usually be zero?)
                (bvecp x (+ i 1)) ;expand?
                (case-split (integerp i))
                (case-split (integerp j))
                )
           (equal (bits x i j)
                  (* (expt 2 (- j)) x)))
)

;disable since it can be bad to leave "naked" signals and we never want to see expt
(in-theory (disable bits-does-nothing-2))

#|
(defthm bits-shift-better
  (implies (and (bind-free (can-take-out-numeric-power-of-2 x) (c))
                (force (power2p c))
                (case-split (integerp i))
                (case-split (integerp j))
                )
           (equal (bits x i j)
                  (bits (/ x c) (- i (expo c)) (- j (expo c))))))

|#


(local (include-book "expt2"))

;same as bits-upper-bound (kill this and rename all refs to it)
(defthm bits<
  (< (bits x i j) (expt 2 (- (1+ i) j)))
  )

;like bits-reduce
;was called bits-tail
(defthm bits-does-nothing
  (implies (and (bvecp x (1+ i))
                (case-split (integerp i))
                )
           (equal (bits x i 0)
                  x))
  :hints (("Goal" :in-theory (disable)
           :cases ((<= i -1)))))

(in-theory (disable bits-does-nothing))
