/**
 * @file Client_Task.cpp
 * @author Will Otte <wotte@dre.vanderbilt.edu
 *
 * Client_Task.cpp,v 1.2 2004/04/21 12:40:38 jwillemsen Exp
 *
 * Implements the Client_Task class defined in Client_Task.h.
 */

#include "Client_Task.h"
#include "testC.h"
#include "Client_ORBInitializer.h"


Client_Task::Client_Task (const char *input,
                          CORBA::ORB_ptr corb,
                          ACE_Thread_Manager *thr_mgr)
        : ACE_Task_Base (thr_mgr),
          input_ (input),
          corb_ (CORBA::ORB::_duplicate (corb))
{}


int
Client_Task::svc (void)
{
  ACE_TRY_NEW_ENV
    {
      CORBA::Object_var object =
        corb_->string_to_object (input_ ACE_ENV_ARG_PARAMETER);
      ACE_TRY_CHECK;

      Bug1495_Regression::Bug1495_var server =
        Bug1495_Regression::Bug1495::_narrow (object.in ()
                                              ACE_ENV_ARG_PARAMETER);
      ACE_TRY_CHECK;

      if (CORBA::is_nil (server.in ()))
        {
          ACE_ERROR ((LM_ERROR,
                      "Object reference <%s> is nil\n",
                      input_));

          return 1;
        }

      // call the thread_id function on the test object
      CORBA::Long remote_thread_id;

      server->get_thread_id (remote_thread_id ACE_ENV_ARG_PARAMETER);
      ACE_TRY_CHECK;

      ACE_DEBUG ((LM_INFO,
                  "Remote thread ID was %i\n",
                  remote_thread_id));

      CORBA::Long mythread_id = (CORBA::Long)ACE_Thread::self();
      if (mythread_id != remote_thread_id)
        {
          ACE_ERROR ((LM_ERROR,
                      "ERROR:  Failed Bug_1495_Regression test. "
                      "Expected thread id was %i, received %i.\n",
                      mythread_id,
                      remote_thread_id));
        }
      else
        {
          ACE_DEBUG ((LM_INFO,
                      "Passed Bug_1495_Regression test.\n"
                      "Local thread id was %i, received %i.\n",
                      mythread_id,
                      remote_thread_id));
        }
    }
  ACE_CATCHANY
    {
      ACE_PRINT_EXCEPTION (ACE_ANY_EXCEPTION,
                           "Caught exception:");
      return 1;
    }
  ACE_ENDTRY;

  return 0;
}
