// Relay_Consumer.cpp,v 1.4 2003/08/24 13:50:14 jwillemsen Exp

#include "Relay_Consumer.h"

ACE_RCSID(Notify, TAO_Notify_Tests_Relay_Consumer, "Relay_Consumer.cpp,v 1.4 2003/08/24 13:50:14 jwillemsen Exp")

#include "LookupManager.h"

TAO_Notify_Tests_Relay_Consumer::TAO_Notify_Tests_Relay_Consumer (ACE_CString& destination)
  : destination_ (destination)
{
}

TAO_Notify_Tests_Relay_Consumer::~TAO_Notify_Tests_Relay_Consumer ()
{
}

void
TAO_Notify_Tests_Relay_Consumer::connect (ACE_ENV_SINGLE_ARG_DECL)
{
  TAO_Notify_Tests_Direct_Consumer::connect (ACE_ENV_SINGLE_ARG_PARAMETER);
  ACE_CHECK;

  // Resolve the destination object.
  LOOKUP_MANAGER->resolve (this->destination_object_, this->destination_.c_str () ACE_ENV_ARG_PARAMETER);
  ACE_CHECK;
}

void
TAO_Notify_Tests_Relay_Consumer::push_structured_event (const CosNotification::StructuredEvent &notification
                                              ACE_ENV_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException,
                   CosEventComm::Disconnected))
{
  // The Periodic Consumer will record the run statistics.
  //TAO_Notify_Tests_Periodic_Consumer::push_structured_event (notification ACE_ENV_ARG_PARAMETER);
  //ACE_CHECK;

  // Forward the event.
  if (CORBA::is_nil (this->destination_object_.in ()))
    ACE_DEBUG ((LM_DEBUG, "(%P,%t) Cannot Relay - Destination object %s is nil", this->destination_.c_str ()));
  else
    this->destination_object_->push_structured_event (notification ACE_ENV_ARG_PARAMETER);
}
