/* -*- C++ -*- */
/**
 *  @file   Supplier.h
 *
 *  Supplier.h,v 1.2 2004/02/04 20:20:20 parsons Exp
 *
 *  @author Carlos O'Ryan (coryan@cs.wustl.edu)
 *
 *  IIOP Gateway
 */
#ifndef SUPPLIER_H
#define SUPPLIER_H

#include "orbsvcs/orbsvcs/RtecEventCommS.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

/**
 * @class Supplier
 *
 * @brief Simple supplier object
 *
 * This class is a supplier of events. It simply publishes one event type.
 */
class Supplier : public POA_RtecEventComm::PushSupplier
{
public:
  /// Constructor
  Supplier (void);

  /// Run the test
  int run (int argc, char* argv[]);

  // = The RtecEventComm::PushSupplier methods

  /// The skeleton methods.
  virtual void disconnect_push_supplier (ACE_ENV_SINGLE_ARG_DECL_NOT_USED)
    ACE_THROW_SPEC ((CORBA::SystemException));

private:
  int parse_args (int argc, char *argv[]);
};

#endif /* SUPPLIER_H */
