#ifndef S9X_CONTROLLER_H
#define S9X_CONTROLLER_H

#include "defines.h"
#include "frend.h"
#include "misc.h"
#include "skins.h"
#include <string>

#ifndef S9X_JS_COUNT
#define S9X_JS_COUNT 2
#endif

class s9x_JoyMap;
enum
{
  A_BTN, B_BTN, X_BTN, Y_BTN,
  L_BTN, R_BTN, START_BTN, SELECT_BTN,
  GAMEPAD, BUTTONPAD, PADTEXT, PADCOLORCOUNT
};
typedef fr_Colors PadColors[PADCOLORCOUNT];

class s9x_Controller : public s9x_Notepage
{
 public:
 private:
  fr_Window		DevWindow, MapWindow;
  fr_File		devJS0, devJS1, devJS2, devJS3, *devJS[S9X_JS_COUNT];
  fr_Button		DevBtn, DevClose, MapBtn, MapCloseBtn;
  fr_PulldownMenu	Buttons;
  fr_Checkbox		Old, UseJoystick, Swap;
  fr_Element*		MapDiagram;
  fr_Box		detailbox;
  fr_ButtonBox		MapButtonBox;
  PadColors             defaultpadcolors, padcolors;
  s9x_JoyMap		*Map[S9X_JS_COUNT];
  void			EventOccurred(fr_Event*e);
 public:
   			s9x_Controller(fr_Notebook*parent);
  virtual               ~s9x_Controller();
  void			SetToDefaults();
  void			Set9xVersion(float version);
  void			SiftArgs(fr_ArgList& L);
  void			CompileArgs(fr_ArgList& L);
  void			ApplySkin(s9x_Skin*S);
  const PadColors&      getColors() const { return padcolors; }
};

class s9x_JoyMap : 	public fr_Option, private fr_Listener
{
 public:
 private:
   int			Index, Row, SelectedBtn, axes, buttons;
   int                  buttonmap[GAMEPAD];
   int			device_fd, device_id;
   bool			IsVisible;
   std::string          jsdev, jsname, jserr;
   fr_TextArea          details;
   const PadColors      &clr;
   void			SetBtn(int btn, int val);
   int			GetBtn(int btn);
   void			EventOccurred(fr_Event*e);
 public:
			s9x_JoyMap(s9x_Controller*parent, int j, fr_Box&b);
   void			SetToDefault();
   bool			IsDefault();
   void			SiftArgs(fr_ArgList& L);
   void			CompileArgs(fr_ArgList& L);
   void			SetSelectedBtnVal(int val);
   int			GetSelectedBtnVal();
   void                 updateDetails();
   void		        moveSelector(int dir);
   int  		OpenDevice(const std::string& dev);
   void			CloseDevice();
};

#endif
