/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.util.MemIndirection;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Traceable;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.vsp001.PartKind;
import java.io.PrintStream;

public abstract class SQLPacket
extends MemIndirection
implements Traceable {
    protected int segmOffs;
    protected int partOffs;
    protected static final int Alignment_C = 8;

    protected SQLPacket(StructuredMem structuredMem) {
        super(structuredMem);
    }

    protected final int aligned(int n) {
        int n2 = n % 8;
        if (n2 != 0) {
            n += 8 - n2;
        }
        return n;
    }

    int dumpPart(PrintStream printStream, int n, int n2) {
        printStream.println("       <PART ");
        printStream.println("       partkind=\"" + PartKind.names[this.getInt1(n2 + 0)] + "\"");
        printStream.println("       arg_count=\"" + this.getInt2(n2 + 2) + "\"");
        printStream.println("       buflen=\"" + this.getInt4(n2 + 8) + "\"");
        printStream.println("       bufsize=\"" + this.getInt4(n2 + 12) + "\"");
        printStream.println("       partpos=\"" + n2 + "\"");
        int n3 = n2 + 16;
        StructuredMem structuredMem = this.getPointer(n2 + 16);
        int n4 = this.getInt4(n2 + 8);
        n = n == -1 ? n4 : Math.min(n, n4);
        switch (this.getInt1(n2 + 0)) {
            case 18: {
                String[] stringArray = new String[]{"vm_datapart", "vm_alldata", "vm_lastdata", "vm_nodata", "vm_no_more_data", "vm_last_putval", "vm_data_trunc", "vm_close"};
                byte by = this.getInt1(n3 + 0);
                byte by2 = this.getInt1(n3 + 25);
                byte by3 = this.getInt1(n3 + 28);
                printStream.println("       <LONG_DESCRIPTOR ");
                printStream.println("           undef_signal=\"" + by + (by == 256 ? " isNull" : " notNull") + "\"");
                printStream.println("           maxlen      =\"" + this.getInt4(n3 + 17) + "\"");
                printStream.println("           intern_pos  =\"" + this.getInt4(n3 + 21) + "\"");
                printStream.print("           info_set    =\"");
                if (by2 == 0) {
                    Tracer.println("0xFFFFFFFF\"");
                } else {
                    Tracer.print("0x");
                    Tracer.print((by2 & 0x80) != 0 ? "B" : "F");
                    Tracer.print((by2 & 0x40) != 0 ? "B" : "F");
                    Tracer.print((by2 & 0x20) != 0 ? "B" : "F");
                    Tracer.print((by2 & 0x10) != 0 ? "B" : "F");
                    Tracer.print((by2 & 8) != 0 ? "B" : "F");
                    Tracer.print((by2 & 4) != 0 ? "B" : "F");
                    Tracer.print((by2 & 2) != 0 ? "B" : "F");
                    Tracer.println((by2 & 1) != 0 ? "B\"" : "F\"");
                }
                printStream.println("           valmode     =\"" + by3 + " (" + stringArray[by3] + ")\"");
                printStream.println("           valind      =\"" + this.getInt2(n3 + 29) + "\"");
                printStream.println("           valpos      =\"" + this.getInt4(n3 + 33) + "\"");
                printStream.println("           vallen      =\"" + this.getInt4(n3 + 37) + "\"");
                printStream.println("       </LONG_DESCRIPTOR ");
                break;
            }
        }
        printStream.println("       </PART> ");
        return this.aligned(16 + n4);
    }

    abstract int dumpSegment(PrintStream var1, int var2, int var3);

    public int partCount() {
        return this.mem.getInt2(this.segmOffs + 8);
    }

    public int segmCount() {
        return this.mem.getInt2(22);
    }

    public void traceOn(PrintStream printStream) {
        this.traceOn(printStream, -1);
    }

    public void invariant() {
        byte by = this.getInt1(1);
        if (by <= 0) {
            throw new Error(MessageTranslator.translate("error.invariant.messswap", Integer.toString(by)));
        }
    }

    public void traceOn(PrintStream printStream, int n) {
        printStream.println("<PACKECT ");
        printStream.println("messcode=\"" + this.getInt1(0) + "\"");
        printStream.println("mess swap=\"" + this.getInt1(1) + "\"");
        printStream.println("application=\"" + this.getString(4, 8) + "\" >");
        printStream.println("<! (used " + String.valueOf(this.getInt4(16)) + " of " + String.valueOf(this.getInt4(12)) + ")>");
        int n2 = this.segmCount();
        int n3 = 32;
        int n4 = 0;
        while (n4 < n2) {
            n3 += this.dumpSegment(printStream, n, n3);
            ++n4;
        }
        printStream.println("</PACKECT> <!=================End of packet >");
    }
}

