/*  Festalon - NSF Player
 *  Copyright (C) 2002 Ben Parnell
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include "types.h"

#include "sound.h"
#include "x6502.h"
#include "nsf.h"
#include "filter.h"

#include "fcoeffs.h"

static int64 mrindex;
static int64 mrratio;
static int32 SoundVolume=100;

//static int32 minc=0,maxc=0;
static void SexyFilter(int32 *in, int32 count)
{
 static int64 acc1,acc2;
 int32 mul1,mul2,vmul;

 mul1=(94<<16)/FSettings.SndRate;
 mul2=(24<<16)/FSettings.SndRate;
 vmul=(SoundVolume<<16)/100;
 if(GameExpSound.volmul)
  vmul=((uint64)vmul*GameExpSound.volmul)>>16;
 while(count)
 {
  int64 ino=(int64)*in*vmul;
  acc1+=((ino-acc1)*mul1)>>16;
  acc2+=((ino-acc1-acc2)*mul2)>>16;
  {
   int32 t=(acc1-ino+acc2)>>16;
//   if(t<minc) minc=t;
//   if(t>maxc) maxc=t;

   if(t>32767) 
   {
    t=32767;
   // puts("clip high");
   }
   if(t<-32768) 
   {
    t=-32768;
  //  puts("clip low");
   }
   *in=t;
  }
  in++;
  count--;
 }
// printf("%d:%d\n",minc,maxc);
}

/* Returns number of samples written to out. */
/* leftover is set to the number of samples that need to be copied 
   from the end of in to the beginning of in.
*/

int32 NeoFilterSound(int32 *in, int32 *out, int32 inlen, int32 *leftover)
{
 int64 x;
 int64 max;
 int32 *outsave=out;
 int32 count=0;



 if(GameExpSound.HiFill) GameExpSound.HiFill();

         max=((int64)inlen-1)<<16;

         for(x=mrindex;x<max;x+=mrratio)
         {
          int32 acc=0,acc2=0;
          unsigned int c;
          int32 *S,*D;
  
          for(c=NCOEFFS,S=&in[(x>>16)-NCOEFFS],D=coeffs;c;c--,D++)
          {
           acc+=(S[c]**D)>>4;
           acc2+=(S[1+c]**D)>>4;
          }

          acc=((int64)acc*(65536-(x&65535))+(int64)acc2*(x&65535))>>(16+14);
  
          //if(acc>=(1<<29)) printf("ack\n");

          *out=acc;

          out++;
          count++;
         }
         mrindex=x-max;
         mrindex+=NCOEFFS*65536;
         *leftover=NCOEFFS+1;

 if(GameExpSound.NeoFill)
  GameExpSound.NeoFill(outsave,count);

 SexyFilter(outsave,count);

 return(count);
}

void MakeFilters(int32 rate)
{
 int32 *tabs[6]={C44100NTSC,C44100PAL,C48000NTSC,C48000PAL,C96000NTSC,C96000PAL};
 int32 *tmp;
 int32 x;
 mrindex=(int64)(NCOEFFS+1)<<16;
 mrratio=(int64)((double)(PAL?PAL_CPU:NTSC_CPU)/rate*65536);
 tmp=tabs[(PAL?1:0)|(rate==48000?2:0)|(rate==96000?4:0)];

 for(x=0;x<NCOEFFS>>1;x++)
 {
  //printf("%d:%d, %d\n",x,NCOEFFS-1-x,coeffs[x]);
  coeffs[x]=coeffs[NCOEFFS-1-x]=tmp[x];
 }
}

void FESTAI_SetVolume(int32 volume)
{
 SoundVolume=volume;
}
