#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <sys/time.h>
#include <time.h>

#include "globals.h"
#include "graphics.h"
#include "filetype.h"
#include "interface-xmms.h"

GdkPixbuf *skinpl,*skinbutton,*skinshufrep,*skinmain,*image;  
int fontsize,titleheight;

void cover_manager();

void load_def_skin()
	{gchar *name,*cmd;

	name=g_strdup_printf("%s/coverviewer/defskin.zip",DATADIR);
	cmd = g_strdup_printf("unzip >/dev/null -o -j \"%s\" -d %s", name, tempdir);
	system(cmd);
	g_free(cmd);
	free(name);
	}

void coview_init_imagebuffer()
	{
	if (xwin<250)
		{
		xwin=250;
		gdk_window_resize(window->window, xwin,ywin);
		}
	if (ywin<230)
		{
		ywin=230;
		imcount=0;
		gdk_window_resize(window->window, xwin,ywin);
		}
	if (imagebuffer) {gdk_pixmap_unref(imagebuffer);}
	imagebuffer=gdk_pixmap_new(window->window,xwin,ywin,-1);
	}

void coview_draw_title(gchar *title)
	{ GdkFont *font;
	gint lenght;
	GdkPixmap *titlebuffer;
	gchar *temp;
	gint skin_top,skin_bottom,skin_left,skin_right;

	if (title_display)
	{
	if (skinned)
		{skin_top=18;skin_bottom=37;skin_left=11;skin_right=19;}
		else
		{skin_top=skin_bottom=skin_left=skin_right=0;}


	if (moving!=2)
	{
	font=gdk_font_load(fontname);
	lenght=gdk_string_width(font,title);
	fontsize=gdk_string_height(font,"flidb'")+1;
	titleheight=gdk_string_height(font,"f'lidbgpq")+1;
	titlebuffer=gdk_pixmap_new(window->window,xwin,skin_top+titleheight+3,-1);
	gdk_draw_rectangle(titlebuffer,
				window->style->fg_gc[GTK_STATE_NORMAL],
				TRUE,
				skin_left,skin_top,
				xwin-skin_left-skin_right,3+titleheight);
	gdk_window_copy_area (drawzone->window,
    			      drawzone->style->fg_gc[GTK_STATE_NORMAL],
    			      skin_left,skin_top,
    			      titlebuffer,
    			      skin_left,skin_top,
    			      xwin-skin_left-skin_right,titleheight+3);

	if (lenght<=xwin-skin_left-skin_right-4)
		{
		gdk_draw_string(titlebuffer,	//GdkDrawable
				font,		//GdkFont
				window->style->bg_gc[GTK_STATE_NORMAL],	//GkGC
				skin_left+2,		//gint x
				skin_top+1+fontsize,	//gint y
				title);		//gchar *text,
		scroll=0;
		scrolldir=5;
		}
	else
		{
		temp=malloc(strlen(title)*2+6);
		strcpy(temp,title);
		strcat(temp," *** ");
		strcat(temp,title);
		gdk_draw_string(titlebuffer,
				font,
				window->style->bg_gc[GTK_STATE_NORMAL],
				skin_left+2-scroll,
				skin_top+1+fontsize,
				temp);
		scroll=scroll+scrolldir;
		if (scroll>lenght+(gdk_string_width(font," *** ")))
			{ scroll=scroll-lenght-(gdk_string_width(font," *** ")); }
		}
	gdk_draw_line(titlebuffer,
                            window->style->bg_gc[GTK_STATE_NORMAL],
                            skin_left+1,
                            skin_top+2+titleheight,
                            xwin-skin_right-1,
                            skin_top+2+titleheight);
	gdk_window_copy_area (drawzone->window,
    			      drawzone->style->fg_gc[GTK_STATE_NORMAL],
    			      skin_left+1,skin_top,
    			      titlebuffer,
    			      skin_left,skin_top,
    			      xwin-skin_left-skin_right-4,titleheight+3);
	gdk_font_unref(font);
	gdk_pixmap_unref(titlebuffer);
	}
	}
	gtk_window_set_title( (GtkWindow *) window,title);
	}

void coview_load_skin(gchar *pathname)
	{ gchar *temp,*path,*strtemp,*cmd;
	int i;
	GdkPixbuf *pixbuf;

	path=strdup(pathname);
	if (strcmp(path,"")!=0)
		{
		strtemp=up(path);
		if ((strstr(strtemp,".ZIP") !=NULL) || (strstr(strtemp,".WSZ") !=NULL))
			{// ZIPPED SKIN
			cmd = g_strdup_printf("unzip > /dev/null -o -j \"%s\" -d %s", path, tempdir);
			system(cmd);
			g_free(cmd);
			free(path);
			path=tempdir;
			}
		if ((strstr(strtemp,".TAR.GZ") !=NULL) || (strstr(strtemp,".TGZZ") !=NULL))
			{// TAR-GUNZIPED SKIN
			cmd = g_strdup_printf("tar >/dev/null xzf \"%s\" -C %s", path, tempdir);
			system(cmd);
			g_free(cmd);
			free(path);
			path=tempdir;
			}
		if (strstr(strtemp,".TAR.BZ2") !=NULL)
			{// TAR-bZIPED SKIN
			cmd = g_strdup_printf("bzip2 -dc \"%s\" | tar >/dev/null xf - -C %s", path, tempdir);
			system(cmd);
			g_free(cmd);
			free(path);
			path=tempdir;
			}
		if ((strstr(strtemp,".TAR") !=NULL) && (strstr(strtemp,".GZ")==NULL) && (strstr(strtemp,".BZ2")==NULL))
			{// TARED SKIN
			cmd = g_strdup_printf("tar >/dev/null xf \"%s\" -C %s", path, tempdir);
			system(cmd);
			g_free(cmd);
			free(path);
			path=tempdir;
			}
		free(strtemp);
		temp=strdup(path);
		skinpl= gdk_pixbuf_new_from_file((char *)find_file(temp,"PLEDIT.BMP"));
		skinbutton= gdk_pixbuf_new_from_file((char *)find_file(temp,"CBUTTONS.BMP"));
		skinshufrep= gdk_pixbuf_new_from_file((char *)find_file(temp,"SHUFREP.BMP"));
		skinmain= gdk_pixbuf_new_from_file((char *)find_file(temp,"MAIN.BMP"));
		free(temp);
		}
	if ((strcmp(path,"")==0) || !(skinpl && skinbutton && skinshufrep && skinmain))
		{
		load_def_skin();
		temp=strdup(tempdir);
		skinpl= gdk_pixbuf_new_from_file((char *)find_file(temp,"PLEDIT.BMP"));
		skinbutton= gdk_pixbuf_new_from_file((char *)find_file(temp,"CBUTTONS.BMP"));
		skinshufrep= gdk_pixbuf_new_from_file((char *)find_file(temp,"SHUFREP.BMP"));
		skinmain= gdk_pixbuf_new_from_file((char *)find_file(temp,"MAIN.BMP"));
		free(temp);
		/*skinpl=gdk_pixbuf_new_from_xpm_data ((const char **) pledit_xpm);
		skinbutton=gdk_pixbuf_new_from_xpm_data ((const char **) cbuttons_xpm);
		skinshufrep=gdk_pixbuf_new_from_xpm_data ((const char **) shufrep_xpm);
		skinmain=gdk_pixbuf_new_from_xpm_data ((const char **) main_xpm);*/
		}

	cmd = g_strdup_printf("\\rm -f -r %s/*.bmp >/dev/null", tempdir);
	system(cmd);
	g_free(cmd);
	cmd = g_strdup_printf("\\rm -f -r %s/*.BMP >/dev/null", tempdir);
	system(cmd);
	g_free(cmd);

	///Draw Skin
	pixbuf=gdk_pixbuf_scale_simple (skinpl,xwin+110,ywin+50,GDK_INTERP_BILINEAR);
	gdk_pixbuf_copy_area (skinpl,		// Source pixbuf
			      	0,0,		// Source x,y
			      	25,18,		// Width,Height to copy
			      	pixbuf,		// Destination pixbuf
			      	0,0);		// Destination x,y
	i=0;
	while (i*25+50<=xwin)
		{
		gdk_pixbuf_copy_area (skinpl,
			      	127,0,
			      	25,18,
			      	pixbuf,
			      	25+i*25,0);
		i++;
		}
	gdk_pixbuf_copy_area (skinpl,
			      	153,0,
			      	25,18,
			      	pixbuf,
			      	xwin-25,0);
	
	i=0;
	while (i*29+47<=ywin)
		{
		gdk_pixbuf_copy_area (skinpl,
			      	0,42,
			      	11,29,
			      	pixbuf,
			      	0,18+i*29);
		i++;
		}
	
	gdk_pixbuf_copy_area (skinpl,
			      	0,73,
			      	11,37,
			      	pixbuf,
			      	0,ywin-37);
	i=0;
	while (i*25+11<=xwin)
		{
		gdk_pixbuf_copy_area (skinpl,
			      	179,1,
			      	25,37,
			      	pixbuf,
			      	i*25+11,ywin-37);
		i++;
		}
	i=0;
	while (i*29+47<=ywin)
		{
		gdk_pixbuf_copy_area (skinpl,
			      	32,42,
			      	19,29,
			      	pixbuf,
			      	xwin-19,18+i*29);
		i++;
		}
	gdk_pixbuf_copy_area (skinpl,
			      	257,72,
			      	19,38,
			      	pixbuf,
			      	xwin-19,ywin-38);
	gdk_pixbuf_unref (skinpl);
	
	if (show_button)
	{
	gdk_pixbuf_copy_area (skinbutton,
			      	0,0,
			      	114,18,
			      	pixbuf,
			      	11,ywin-37+6);
/*	gdk_pixbuf_copy_area (skinbutton,
			      	0,0,
			      	114,18,
			      	pixbuf,
			      	11,ywin-37+7);

	gdk_pixbuf_copy_area (skinmain,
			      	135,88,
			      	25,20,
			      	pixbuf,
			      	11+114+4,ywin-37+6);	*/
	gdk_pixbuf_copy_area (skinbutton,
			      	114,0,
			      	136-114,16,
			      	pixbuf,
			      	11+114+4+1,ywin-37+6);
/*	gdk_pixbuf_copy_area (skinbutton,
			      	114,0,
			      	136-114,16,
			      	pixbuf,
			      	11+114+4+1,ywin-37+7);*/
	

	gdk_pixbuf_copy_area (skinmain,
			      	164,88,
			      	74,19,
			      	pixbuf,
			      	xwin-19-28-46,ywin-37+7);
	if (shuffle)
		{
		gdk_pixbuf_copy_area (skinshufrep,
			      	28,30,
			      	46,15,
			      	pixbuf,
			      	xwin-19-46-28,ywin-37+6);
/*		gdk_pixbuf_copy_area (skinshufrep,
			      	28,30,
			      	46,15,
			      	pixbuf,
			      	xwin-19-46-28,ywin-37+7);*/
		}
	else
		{
		gdk_pixbuf_copy_area (skinshufrep,
			      	28,0,
			      	46,15,
			      	pixbuf,
			      	xwin-19-46-28,ywin-37+6);
/*		gdk_pixbuf_copy_area (skinshufrep,
			      	28,0,
			      	46,15,
			      	pixbuf,
			      	xwin-19-46-28,ywin-37+7);*/
		}
	if (repeat)
		{
		gdk_pixbuf_copy_area (skinshufrep,
			      	0,30,
			      	28,15,
			      	pixbuf,
			      	xwin-19-28,ywin-37+6);
/*		gdk_pixbuf_copy_area (skinshufrep,
			      	0,30,
			      	28,15,
			      	pixbuf,
			      	xwin-19-28,ywin-37+7);*/
		}
	else
		{
		gdk_pixbuf_copy_area (skinshufrep,
			      	0,0,
			      	28,15,
			      	pixbuf,
			      	xwin-19-28,ywin-37+6);
/*		gdk_pixbuf_copy_area (skinshufrep,
			      	0,0,
			      	28,15,
			      	pixbuf,
			      	xwin-19-28,ywin-37+7);*/
		}
	}
	gdk_pixbuf_unref (skinshufrep);
	gdk_pixbuf_unref (skinbutton);
	gdk_pixbuf_unref (skinmain);
	
	gdk_pixbuf_render_to_drawable (pixbuf,
				       imagebuffer,
				       window->style->fg_gc[GTK_STATE_NORMAL],
    				       0,0,
				       0,0,11,ywin,
    				       GDK_RGB_DITHER_NORMAL,0,0);
	gdk_pixbuf_render_to_drawable (pixbuf,
				       imagebuffer,
				       window->style->fg_gc[GTK_STATE_NORMAL],
    				       0,0,
				       0,0,xwin,18,
    				       GDK_RGB_DITHER_NORMAL,0,0);
	gdk_pixbuf_render_to_drawable (pixbuf,
				       imagebuffer,
				       window->style->fg_gc[GTK_STATE_NORMAL],
    				       xwin-19,18,
				       xwin-19,18,19,ywin-18,
    				       GDK_RGB_DITHER_NORMAL,0,0);
	gdk_pixbuf_render_to_drawable (pixbuf,
				       imagebuffer,
				       window->style->fg_gc[GTK_STATE_NORMAL],
    				       11,ywin-37,
				       11,ywin-37,xwin-11-19,37,
    				       GDK_RGB_DITHER_NORMAL,0,0);
	gdk_pixbuf_unref (pixbuf);
	coview_display_skin();
	}

void coview_display_skin()
	{
	if (moving==0)
		{
		gdk_window_copy_area (drawzone->window,
			      drawzone->style->fg_gc[GTK_STATE_NORMAL],
			       0,0,
			      imagebuffer,
			       0,0,11,ywin);
		gdk_window_copy_area (drawzone->window,
			      drawzone->style->fg_gc[GTK_STATE_NORMAL],
			      0,0,
			      imagebuffer,
			      0,0,xwin,18);		
		gdk_window_copy_area (drawzone->window,
			      drawzone->style->fg_gc[GTK_STATE_NORMAL],
			      xwin-19,18,
			      imagebuffer,
			      xwin-19,18,19,ywin-18);
		gdk_window_copy_area (drawzone->window,
			      drawzone->style->fg_gc[GTK_STATE_NORMAL],
			      11,ywin-37,
			      imagebuffer,
			      11,ywin-37,xwin-11-19,37);
		}
	}

void coview_load_image(gchar *filename)
	{int x,y,xw,yw;
	GdkPixbuf *pixbuf;
	gint skin_top,skin_bottom,skin_left,skin_right;

	if (!title_display) titleheight=-3;
	if (skinned)
		{skin_top=18;skin_bottom=37;skin_left=11;skin_right=19;}
		else
		{skin_top=skin_bottom=skin_left=skin_right=0;}
	if (filename)
		{
		image=gdk_pixbuf_new_from_file(filename);
		if (!(image))
			{ /*invalid image!!! we must get rid of it */
			imcount=666;
			return;
			}
		}
		else image=gdk_pixbuf_new_from_file(empty_picture);
	if (!(image)) image=gdk_pixbuf_new_from_file(empty_picture);
	if (!(image)) image=gdk_pixbuf_new_from_file(tempimg);
	gdk_draw_rectangle(imagebuffer,
					window->style->fg_gc[GTK_STATE_NORMAL],
					TRUE,
					skin_left,skin_top,
					xwin-skin_left-skin_right,ywin-skin_top-skin_bottom);
	x=gdk_pixbuf_get_width(image);
	y=gdk_pixbuf_get_height(image);
	xw=xwin-skin_left-skin_right;
	yw=ywin-skin_top-titleheight-3-skin_bottom;
	
	if (ratio)
		{
		if (x*yw<y*xw)
        		{ 
			x=yw*x/y;
			y=yw;
			pixbuf = gdk_pixbuf_scale_simple (image,x,y,GDK_INTERP_BILINEAR);
			}
        	else
        		{ 
			y=xw*y/x;
			x=xw;
			pixbuf = gdk_pixbuf_scale_simple (image,x,y,GDK_INTERP_BILINEAR); 
			}
		}
	else
		{
		x=xw; y=yw;
		pixbuf = gdk_pixbuf_scale_simple (image,x,y,GDK_INTERP_BILINEAR);
		}
	
	gdk_pixbuf_render_to_drawable (pixbuf,			// A Pixbuf
				       imagebuffer,	 		// Destination drawable
				       window->style->fg_gc[GTK_STATE_NORMAL], 			// GC
    				       0,0, 			// Source X/Y in pixbuf
				       (xw-x)/2+skin_left,(yw-y)/2+skin_top+titleheight+3,x,y,		// Dest X/Y, Width, Height in destination
    				       GDK_RGB_DITHER_NORMAL,0,0);
	gdk_pixbuf_unref (pixbuf);
	gdk_pixbuf_unref (image);
	coview_display_image();	
	}
    
void coview_display_image()
	{
	gint skin_top,skin_bottom,skin_left,skin_right;

	if (!title_display) titleheight=-2;
	if (skinned)
		{skin_top=18;skin_bottom=37;skin_left=11;skin_right=19;}
		else
		{skin_top=skin_bottom=skin_left=skin_right=0;}
	
	if (moving==0)
		{
		gdk_window_copy_area (drawzone->window,
			      drawzone->style->fg_gc[GTK_STATE_NORMAL],
			      skin_left,skin_top+2+titleheight,
			      imagebuffer,
			      skin_left,skin_top+2+titleheight,
			      xwin-skin_left-skin_right,ywin-skin_top-skin_bottom-2-titleheight);
		}
	}

void coview_display_all()
	{
	if (moving==0)
	{
	gdk_window_copy_area (drawzone->window,
    			      drawzone->style->fg_gc[GTK_STATE_NORMAL],
    			      0,0,
    			      imagebuffer,
    			      0,0,
    			      xwin,ywin);
	}
	}

void slide_toggle()
	{
	if (slide)
		{slide=FALSE;}
	else {slide=TRUE; }
	imcount=0;
	}

void ratio_toggle()
	{
	if (ratio)
		{ratio=FALSE;}
	else {ratio=TRUE;}
	imcount=0;
	}

void skin_toggle()
	{
	if (skinned)
		skinned=FALSE;
	else {skinned=TRUE; redrawskin=TRUE;}
	imcount=0;
	}
	
void button_toggle()
	{
	if (show_button)
		show_button=FALSE;
	else
		show_button=TRUE;
	redrawskin=TRUE;
	imcount=0;
	}

void title_toggle()
	{
	if (title_display)
		{title_display=FALSE;}
	else {title_display=TRUE;}
	imcount=0;
	}

void fs_toggle()
	{
	if (fullscreen)
		{fullscreen=FALSE; skinned=TRUE; redrawskin=TRUE;}
	else {fullscreen=TRUE; skinned=FALSE;}
	if (fullscreen)
		{
		Xwin=xwin; Ywin=ywin;
		xwin=gdk_screen_width(); ywin=gdk_screen_height();
		Posx=posx; Posy=posy;
		posx=0; posy=0;
		}
		else
		{
		xwin=Xwin; ywin=Ywin;
		Xwin=gdk_screen_width(); Ywin=gdk_screen_height();
		posx=Posx; posy=Posy;
		Posx=0; Posy=0;
		}
	gdk_window_move_resize(window->window,posx,posy, xwin,ywin);
	coview_init_imagebuffer();
	imcount=0;
	}


void coview_menu()
	{ GtkWidget *menu,*label;
	
	menu=gtk_menu_new();

	label=gtk_menu_item_new_with_label("Coverviewer Menu");
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	label=gtk_menu_item_new();
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);

	label=gtk_menu_item_new_with_label("Play file");
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (coview_open),(gpointer)NULL);

	label=gtk_menu_item_new_with_label("Previous");
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (coview_play_prev),(gpointer)NULL);

	label=gtk_menu_item_new_with_label("Play");
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (coview_play),(gpointer)NULL);

	label=gtk_menu_item_new_with_label("Pause");
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (coview_pause),(gpointer)NULL);

	label=gtk_menu_item_new_with_label("Stop");
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (coview_stop),(gpointer)NULL);

	label=gtk_menu_item_new_with_label("Next");
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (coview_play_next),(gpointer)NULL);

	label=gtk_menu_item_new();
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);

	if (slide)
		{label=gtk_menu_item_new_with_label("Disable Slideshow");}
		else
		{label=gtk_menu_item_new_with_label("Enable Slideshow");}
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (slide_toggle),NULL);

	if (ratio)
		{label=gtk_menu_item_new_with_label("Don't Preserve Ratio");}
		else
		{label=gtk_menu_item_new_with_label("Preserve Ratio");}
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (ratio_toggle),NULL);

	if (skinned)
		{label=gtk_menu_item_new_with_label("Disable Skin");}
		else
		{label=gtk_menu_item_new_with_label("Enable Skin");}
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (skin_toggle),NULL);

	if (skinned)
	{
	if (show_button)
		{label=gtk_menu_item_new_with_label("Disable Buttons");}
		else
		{label=gtk_menu_item_new_with_label("Enable Buttons");}
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (button_toggle),NULL);
	}
		
	if (fullscreen)
		{label=gtk_menu_item_new_with_label("Windowed");}
		else
		{label=gtk_menu_item_new_with_label("Fullscreen");}
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (fs_toggle),NULL);

	if (title_display)
		{label=gtk_menu_item_new_with_label("Disable Title");}
		else
		{label=gtk_menu_item_new_with_label("Enable Title");}
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (title_toggle),NULL);

	if (im_found==0 && internet_search==FALSE && net_search==FALSE && curfile->artist!=NULL && curfile->album!=NULL)
		{label=gtk_menu_item_new_with_label("Search cover on Internet");
		gtk_menu_append((GtkMenu *)menu,label);
		gtk_widget_show (label);
		gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (netsearch),(gpointer) NULL);
		}

	if ( !managing && //from_dir &&
			(!net_search || lock_file) && 
			curfile->artist && 	curfile->album)
		{label=gtk_menu_item_new_with_label("Manage covers");
		gtk_menu_append((GtkMenu *)menu,label);
		gtk_widget_show (label);
		gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (cover_manager),(gpointer) NULL);
		}
	else
		{
		label=gtk_menu_item_new_with_label("Manage covers");
		gtk_menu_append((GtkMenu *)menu,label);
		gtk_widget_show (label);
		gtk_widget_set_sensitive(label,FALSE);			
		if (managing) label=gtk_menu_item_new_with_label(" -> already managing");
		if (net_search && !lock_file) label=gtk_menu_item_new_with_label(" -> net search launched");
		if (!(curfile->artist &&	curfile->album)) label=gtk_menu_item_new_with_label(" -> insufficient file info");
		gtk_menu_append((GtkMenu *)menu,label);
		gtk_widget_show (label);
		gtk_widget_set_sensitive(label,FALSE);			
		}
	
	label=gtk_menu_item_new();
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);

		
	if (coview_test_visible())
	{
		label=gtk_menu_item_new_with_label("Minimize XMMS");
		gtk_menu_append((GtkMenu *)menu,label);
		gtk_widget_show (label);
		gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (coview_window_visible),(gpointer) FALSE);
	}
	else
	{
		label=gtk_menu_item_new_with_label("Show XMMS");
		gtk_menu_append((GtkMenu *)menu,label);
		gtk_widget_show (label);
		gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (coview_window_visible),(gpointer) TRUE);
	}
	
	label=gtk_menu_item_new_with_label("EXIT");
	gtk_menu_append((GtkMenu *)menu,label);
	gtk_widget_show (label);
	gtk_signal_connect_object (GTK_OBJECT (label), "activate",GTK_SIGNAL_FUNC (coview_killall),NULL);


	gtk_menu_popup((GtkMenu *) menu,NULL,NULL,NULL,NULL,3,GDK_CURRENT_TIME);
	}

typedef struct cover {
	struct fileinfo *info;
	struct image_name_buffer *images;
} cover;

GtkWidget *bigbox;
GtkWidget *dialog;
struct cover *cover_pointer;
GdkPixmap *man_buffer[40];
void draw_man();
void redraw_man();

void man_expose(GtkWidget *widget,GdkEventExpose *event,GdkPixmap *data)
	{ GdkPixmap *pixmap=data;
	gdk_window_copy_area (widget->window,
			      window->style->fg_gc[GTK_STATE_NORMAL],
			      event->area.x, event->area.y,
			      pixmap,
			      event->area.x, event->area.y,
			      event->area.width, event->area.height);
	}

void img_browse_ok(GtkWidget * w, gpointer data)
	{GtkFileSelection *im_sel = GTK_FILE_SELECTION(data);
        gchar *name,*cmd;
		struct timeval timenow;
		struct tm brokentime;

        name = gtk_file_selection_get_filename(im_sel);
		cmd=up(name);
        if (name && (strstr(cmd,".JPG") || strstr(cmd,".JPEG") || strstr(cmd,".GIF") || strstr(cmd,".PNG") ||strstr(cmd,".BMP"))) 
		{
		gettimeofday(&timenow,NULL);
		localtime_r (&timenow.tv_sec, &brokentime);
		cmd=malloc(22);
		strftime(cmd,22, "%d-%m-%Y %Hh%Mm%S", &brokentime);
		cmd=g_strdup_printf("cp \"%s\" \"%s/%s - %s (%s).jpg\" 2>/dev/null",
			name,image_dir,cover_pointer->info->artist,cover_pointer->info->album,cmd);
		system(cmd);
		//printf("%s\n",cmd);
		find_cover("",cover_pointer->info,&(cover_pointer->images));
		gtk_container_remove(GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),bigbox);
		draw_man();
		}
        gtk_widget_destroy(GTK_WIDGET(im_sel));
	}

void file_man(GtkWidget *widget)
{
	static GtkWidget *image_sel;
	if (!image_sel)
	{
	image_sel = gtk_file_selection_new("Select Image");
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(image_sel)->ok_button), "clicked", GTK_SIGNAL_FUNC(img_browse_ok), image_sel);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(image_sel)->cancel_button), "clicked",
					GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(image_sel));
	gtk_signal_connect(GTK_OBJECT(image_sel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &image_sel);
	gtk_widget_show(image_sel);
    }
}

void search_man(GtkWidget *widget)
	{gchar *temp,*artist,*title;
		
	title=up(cover_pointer->info->album);
	title=net_purge(title);
	title=replace(title,"\\\'","\'");
	artist=up(cover_pointer->info->artist);
	artist=net_purge(artist);
	artist=replace(artist,"\\\'","\'");
	temp=malloc(strlen(title)+strlen(artist)+4);
	strcpy(temp,artist);
	strcat(temp," - ");
	strcat(temp,title);

	advnetsearch(cover_pointer->info);
	/*while (1)
		{ if (exists_file(image_dir,temp,".RESULT")) break; 
		for (i=0; i<100000;i++) { printf(""); }
		}
	find_cover("",cover_pointer->info,&(cover_pointer->images));
	gtk_container_remove(GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),bigbox);
	draw_man();	*/
	}


void off_man(GtkWidget *widget)
	{
	gtk_widget_destroy(widget);
	managing=FALSE;
	free(curfile->filename);
	curfile->filename=strdup("NEW");
	}
	
void do_del(struct image_name_buffer *imbuff)
	{
	int cnt=0;
	struct image_name_buffer *old;
	gchar *cmd;

	old=cover_pointer->images;
	while (old->next!=imbuff)
		{cnt++; old=old->next;}
	old->next=imbuff->next;
	cmd=g_strdup_printf("\\rm \"%s\" 2>/dev/null",imbuff->imagename);
	system(cmd);
	free(imbuff->imagename);
	free(imbuff);
	gtk_container_remove(GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),bigbox);
	while(cnt<40)
		{man_buffer[cnt]=man_buffer[cnt+1];
		cnt++;}
	redraw_man();
	}

void manage_delete(int nb)
{	struct image_name_buffer *imbuff;
	GtkWidget *ddialog, *dbox, *dlabel ,*dbutton;
	GdkPixmap *dbuffer; GdkPixbuf *image,*pixbuf;
	int cnt=0,x,y,x0,y0,N=400;
	
	imbuff=cover_pointer->images;
	while(cnt<nb)
		{cnt++;
		imbuff=imbuff->next;}
	
	ddialog = gtk_dialog_new();
		
	dbox=gtk_vbox_new((gboolean) FALSE, 5);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(ddialog)->vbox),dbox);

		image=gdk_pixbuf_new_from_file(imbuff->next->imagename);
		x=gdk_pixbuf_get_width(image); if (x<N) N=x;
		y=gdk_pixbuf_get_height(image); if (y<N) N=y;
	dlabel=gtk_drawing_area_new();
	gtk_drawing_area_size (GTK_DRAWING_AREA (dlabel),N+10, N+10);
	gtk_box_pack_start(GTK_BOX (dbox), dlabel,FALSE,TRUE,0);
		if (x<y)
        	{ x0=N*x/y; y0=N;
			pixbuf = gdk_pixbuf_scale_simple (image,x0,y0,GDK_INTERP_BILINEAR);
			}
        else
        	{ y0=N*y/x; x0=N;
			pixbuf = gdk_pixbuf_scale_simple (image,x0,y0,GDK_INTERP_BILINEAR); 
			}
		gdk_pixbuf_unref (image);
		
		dbuffer=gdk_pixmap_new(window->window,N+10,N+10,-1);
		gdk_draw_rectangle(dbuffer,window->style->black_gc,TRUE,0,0,N+10,N+10);
		gdk_pixbuf_render_to_drawable (pixbuf,dbuffer,window->style->fg_gc[GTK_STATE_NORMAL],
												0,0,(N+10-x0)/2,(N+10-y0)/2,x0,y0,GDK_RGB_DITHER_NORMAL,0,0);

	gtk_signal_connect (GTK_OBJECT(dlabel), "expose_event", GTK_SIGNAL_FUNC(man_expose), dbuffer);	

		
	dlabel=gtk_label_new(g_strdup_printf("Do you really want to delete this file? (%ux%upix)\n%s",x,y,imbuff->next->imagename));
	gtk_box_pack_start(GTK_BOX (dbox), dlabel,FALSE,TRUE,0);
	
	dbutton = gtk_button_new_with_label("Delete");
	gtk_signal_connect_object (GTK_OBJECT (dbutton), "clicked",	GTK_SIGNAL_FUNC (do_del), (gpointer) imbuff->next);
	gtk_signal_connect_object (GTK_OBJECT (dbutton), "clicked",	GTK_SIGNAL_FUNC (gtk_widget_destroy), (GtkObject *) ddialog);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(ddialog)->action_area),dbutton);

	dbutton = gtk_button_new_with_label("Cancel");
	gtk_signal_connect_object (GTK_OBJECT (dbutton), "clicked",	GTK_SIGNAL_FUNC (gtk_widget_destroy), (GtkObject *) ddialog);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(ddialog)->action_area),dbutton);

	gtk_widget_show_all (ddialog);
	gtk_window_set_title((GtkWindow *) ddialog,"Confirm deletion");
	gdk_window_set_functions(ddialog->window,12);
	gtk_window_set_policy(GTK_WINDOW(ddialog), FALSE, FALSE, FALSE);
}

void redraw_man()
{	GtkWidget *hbox=NULL,*cellbox,*label[40],*button;
	struct image_name_buffer *imbuff,*old;
	int cnt=-1;

	imbuff=cover_pointer->images->next;
	old=cover_pointer->images;
	
	bigbox=gtk_vbox_new((gboolean) FALSE, 5);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),bigbox);
	
	while (imbuff)
	{
		cnt++;
		if ((cnt % 5)==0)
			{
			if (cnt>0) // Stock the previous line...
				gtk_box_pack_start(GTK_BOX (bigbox), hbox,FALSE,TRUE,0);
			hbox=gtk_hbox_new((gboolean) FALSE, 5); // Create a new line
			}
		cellbox=gtk_vbox_new((gboolean) FALSE, 5); // Create a New cell
			
		label[cnt]=gtk_drawing_area_new();
		gtk_drawing_area_size (GTK_DRAWING_AREA (label[cnt]),150, 150);
		gtk_box_pack_start(GTK_BOX (cellbox), label[cnt],FALSE,TRUE,0); //Fill the cell
					
		button=gtk_button_new_with_label ((gchar *) "Delete");
		gtk_signal_connect_object (GTK_OBJECT (button), "clicked",	GTK_SIGNAL_FUNC (manage_delete),(gpointer) cnt);
		gtk_box_pack_start(GTK_BOX (cellbox), button,FALSE,TRUE,0); //Fill the cell
			
		gtk_box_pack_start(GTK_BOX (hbox), cellbox,FALSE,TRUE,0); //Stock the cell
			
			
		old=imbuff;
		imbuff=imbuff->next;
	}
	if (cnt>=0) // Stock the last line
		gtk_box_pack_start(GTK_BOX (bigbox), hbox,FALSE,TRUE,0);
	
	cnt=-1;
	if (cover_pointer->images->next)
		imbuff=cover_pointer->images->next;
	else
		imbuff=NULL;
	
	while (imbuff)
	{
		cnt++;
		gtk_signal_connect (GTK_OBJECT(label[cnt]), "expose_event", GTK_SIGNAL_FUNC(man_expose), man_buffer[cnt]);
		imbuff=imbuff->next;
	}
	gtk_widget_show_all (dialog);
}

void draw_man()
{	GtkWidget *hbox=NULL,*cellbox,*cell2,*label[40],*button;
	struct image_name_buffer *imbuff;
	int x,y,cnt=-1;
	GdkPixbuf *image,*pixbuf;

	imbuff=cover_pointer->images->next;
	
	bigbox=gtk_vbox_new((gboolean) FALSE, 5);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),bigbox);
	
	while (imbuff)
	{
		cnt++;
		if ((cnt % 5)==0)
			{
			if (cnt>0) // Stock the previous line...
				gtk_box_pack_start(GTK_BOX (bigbox), hbox,FALSE,TRUE,0);
			hbox=gtk_hbox_new((gboolean) FALSE, 5); // Create a new line
			}
		cellbox=gtk_vbox_new((gboolean) FALSE, 5); // Create a New cell
		cell2=gtk_hbox_new((gboolean) TRUE, 1);
			
		label[cnt]=gtk_drawing_area_new();
		gtk_drawing_area_size (GTK_DRAWING_AREA (label[cnt]),150, 150);
		gtk_box_pack_start(GTK_BOX (cellbox), label[cnt],FALSE,TRUE,0); //Fill the cell

		image=gdk_pixbuf_new_from_file(imbuff->imagename);
		x=gdk_pixbuf_get_width(image);
		y=gdk_pixbuf_get_height(image);
			
		button=gtk_label_new(g_strdup_printf("%ux%u",x,y));
		gtk_box_pack_start(GTK_BOX (cell2), button,FALSE,TRUE,0); //Fill the cell
			
		if (x<y)
        	{ x=140*x/y; y=140;
			pixbuf = gdk_pixbuf_scale_simple (image,x,y,GDK_INTERP_BILINEAR);}
        else
        	{ y=140*y/x; x=140;
			pixbuf = gdk_pixbuf_scale_simple (image,x,y,GDK_INTERP_BILINEAR); }
		gdk_pixbuf_unref (image);
		
		man_buffer[cnt]=gdk_pixmap_new(window->window,150,150,-1);
		gdk_draw_rectangle(man_buffer[cnt],window->style->black_gc,TRUE,0,0,150,150);
		gdk_pixbuf_render_to_drawable (pixbuf,man_buffer[cnt],window->style->fg_gc[GTK_STATE_NORMAL],
												0,0,(150-x)/2,(150-y)/2,x,y,GDK_RGB_DITHER_NORMAL,0,0);

		gtk_signal_connect (GTK_OBJECT(label[cnt]), "expose_event", GTK_SIGNAL_FUNC(man_expose), man_buffer[cnt]);
		gdk_pixbuf_unref (pixbuf);	
			
		button=gtk_button_new_with_label ((gchar *) "Delete");
		gtk_signal_connect_object (GTK_OBJECT (button), "clicked",	GTK_SIGNAL_FUNC (manage_delete),(gpointer) cnt);
		gtk_box_pack_start(GTK_BOX (cell2), button,FALSE,TRUE,0); //Fill the cell
		gtk_box_pack_start(GTK_BOX (cellbox), cell2,FALSE,TRUE,1); //Fill the cell
			
		gtk_box_pack_start(GTK_BOX (hbox), cellbox,FALSE,TRUE,0); //Stock the cell
			
		imbuff=imbuff->next;
	}
	if (cnt>=0) // Stock the last line
		gtk_box_pack_start(GTK_BOX (bigbox), hbox,FALSE,TRUE,0);
	
	gtk_widget_show_all (dialog);
}

void cover_manager()
	{GtkWidget *dbutton;
	gchar *filedir,*temp;
		
	managing=TRUE;
	dialog = gtk_dialog_new();
	
	cover_pointer=malloc(sizeof(cover));	
	cover_pointer->info=dupfileinfo(curfile);
	cover_pointer->images=malloc(sizeof(image_name_buffer));
	cover_pointer->images->imagename=malloc(1);
	cover_pointer->images->next=NULL;
		
	temp=strrchr(cover_pointer->info->filename,'/');
	if (temp)
		{
		filedir=(char *) malloc (temp-cover_pointer->info->filename+2);
	    strncpy(filedir,cover_pointer->info->filename,temp-cover_pointer->info->filename+1);
    	filedir[temp-cover_pointer->info->filename+1]=0;
		}
	else
		filedir=strdup("");		
	find_cover(filedir,cover_pointer->info,&(cover_pointer->images));

	dbutton = gtk_button_new_with_label("Search");
	gtk_signal_connect_object (GTK_OBJECT (dbutton), "clicked",	GTK_SIGNAL_FUNC (search_man), (GtkObject *) dialog);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),dbutton);

	dbutton = gtk_button_new_with_label("Add file");
	gtk_signal_connect_object (GTK_OBJECT (dbutton), "clicked",	GTK_SIGNAL_FUNC (file_man), (GtkObject *) dialog);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),dbutton);

	dbutton = gtk_button_new_with_label("Close");
	gtk_signal_connect_object (GTK_OBJECT (dbutton), "clicked",	GTK_SIGNAL_FUNC (off_man), (GtkObject *) dialog);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),dbutton);

	draw_man();

	gtk_window_set_title((GtkWindow *) dialog,g_strdup_printf("%s Cover Management",cover_pointer->info->album));
	gtk_signal_connect (GTK_OBJECT (dialog), "destroy",GTK_SIGNAL_FUNC (off_man),NULL);
	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);

	gdk_window_set_decorations (dialog->window,42);
	gdk_window_set_functions(dialog->window,44);

}

/*gint trans_session,first_list;
GtkWidget *menu,*label[22];

void coview_song_play(gint i)
	{
	xmms_remote_set_playlist_pos(trans_session, i+first_list );
	}

void coview_draw_playlist()
	{
	gint pos,i[22],im,j;
	gchar *temp;

	pos=xmms_remote_get_playlist_pos(trans_session);

	i[0]=first_list;
	if (i[0]<0) { i[0]=0; }
	im=xmms_remote_get_playlist_length(trans_session);
	if (im>i[0]+20) {im=i[0]+20;}
	if (im-20>0 && i[0]!=im-20) {i[0]=im-20;}
	j=0;
	while (i[j]<=im)
		{
		if (i[j]!=pos)
			{
			temp=xmms_remote_get_playlist_title(trans_session, i[j]);
			}
		else
			{
			temp=malloc(strlen(xmms_remote_get_playlist_title(trans_session, i[j]))+7);
			strcpy(temp,"-> ");
			strcat(temp,xmms_remote_get_playlist_title(trans_session, i[j]));
			strcat(temp," <-");
			}
		gtk_label_set_text (GTK_LABEL ( GTK_BIN (label[j])->child), temp);
		i[j+1]=i[j]+1;
		j++;
		}
	}

void menu_click(GtkWidget *widget,GdkEventButton *event,gpointer callback_data)
	{
	if (event->button==4)
		{
		first_list=first_list-5;
		if (first_list<0) {first_list=0;}
		coview_draw_playlist();
		}
	if (event->button==5)
		{
		first_list=first_list+5;
		if (first_list>=xmms_remote_get_playlist_length(trans_session)-10) {first_list=first_list-5;}
		coview_draw_playlist();
		}
	}

void coview_song_menu(gint session)
	{ int i;
	trans_session=session;
	
	menu=gtk_menu_new();
	
	for (i=0; i<21; i++)
		{ 
		label[i]=gtk_menu_item_new_with_label("BlaBla");
		gtk_signal_connect_object (GTK_OBJECT (label[i]), "activate",GTK_SIGNAL_FUNC (coview_song_play),(gpointer) i);
		gtk_menu_append((GtkMenu *)menu,label[i] );
		gtk_widget_show (label[i]);
		}
	
	gtk_menu_popup((GtkMenu *) menu,NULL,NULL,NULL,NULL,2,GDK_CURRENT_TIME);
	first_list=xmms_remote_get_playlist_pos(trans_session)-10;
	if (first_list<0) {first_list=0;}
	coview_draw_playlist();
	gtk_signal_connect (GTK_OBJECT(menu),"button_release_event",GTK_SIGNAL_FUNC(menu_click),NULL);
	}
*/
