/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _XFMUSIC__MAINWIN_H_
#define _XFMUSIC__MAINWIN_H_

#include <gtk/gtk.h>

#include "xfmedia-xine.h"

#include <xfmedia/xfmedia-playlist.h>
#include <xfmedia/xfmedia-playlist-queue.h>
#include "trayicon.h"

G_BEGIN_DECLS

typedef struct _XfmediaMainwin
{
    GtkWidget *window;
    GdkWindow *window_decs;
    GtkWidget *autohide_window;
    gint temp_disable_autohide;
    guint autohide_timer;
    gboolean is_iconified;
    GtkWidget *video_window;
    
    gint session_id;
    
    XfmediaTrayIcon *tray_icon;
    GtkWidget *tray_icon_menu;
    GtkWidget *tray_icon_playpause_btn;
    GtkWidget *tray_icon_play_img;
    GtkWidget *tray_icon_pause_img;
    
    GtkWidget *fs_controls;
    GtkWidget *fs_playpause_btn;
    GtkWidget *fs_play_btn_img;
    GtkWidget *fs_pause_btn_img;
    GtkWidget *fs_time_label;
    GtkWidget *fs_position_slider;
    
    GtkWidget *popup_menu;
    GtkWidget *time_label;
    gboolean show_time_remaining;
    
    GtkWidget *progress_box;
    GtkWidget *progress_label;
    GtkWidget *progress_bar;
    
    GtkWidget *song_label;
    GtkWidget *ui_message_label;
    
    GtkWidget *volume_btn;
    GtkWidget *volume_window;
    
    GtkWidget *position_slider;
    gboolean slider_sticky;
    
    GtkWidget *playpause_btn;
    GtkWidget *play_btn_img;
    GtkWidget *pause_btn_img;
    
    GtkWidget *playlist_pane;
    
    XfmediaPlaylist *plist;
    XfmediaPlaylistQueue *playlist_q;
    GtkWidget *playlist_q_mi;
    
    GtkWidget *add_menu;
    
    GtkWidget *shuffle_mi;
    GtkWidget *repeat_mi;
    GtkWidget *svis_mi;
    GtkWidget *mmarks_mi;
    
    GtkTooltips *tooltips;
    
    gboolean autohide_enabled;
    guint pos_id;
    gboolean oneshot;
    XfmediaPlaylistEntryRef *cur_playing;
    gint cur_playing_length;
    GQueue *shuffle_history;
    
    XfmediaXine *xfx;
    
    /* this sucks.  xine will block if a stream is playing and you try to open
     * another one and get info about it.  in fact, it locks the whole display,
     * including the keyboard.  so, we need to keep another one around. */
    GMutex *extra_xine_mx;
    xine_stream_t *extra_stream;
    xine_video_port_t *extra_vp;
    xine_audio_port_t *extra_ap;
    
    gchar *chooser_last_dir;
    
    /* settings dialog */
    GtkTreeView *ip_list;
    GtkTreeView *op_list;
    GtkWidget *tray_mini_chk;
    GtkWidget *tray_middle_box;
} XfmediaMainwin;

typedef enum
{
    XFMEDIA_INFOBAR_SONG_LABEL = 0,
    XFMEDIA_INFOBAR_PROGRESS_MESSAGE,
    XFMEDIA_INFOBAR_UI_MESSAGE,
    XFMEDIA_INFOBAR_N_TYPES
} XfmediaInfobarType;

XfmediaMainwin *xfmedia_mainwin_new(XfmediaXine *gtkx, GtkWindow *video_window);
void xfmedia_mainwin_destroy(XfmediaMainwin *mwin);

gboolean xfmedia_mainwin_get_file_info(XfmediaMainwin *mwin, const gchar *filename, gchar **title, gint *length);

void xfmedia_mainwin_set_time_label(XfmediaMainwin *mwin, gint time, gboolean is_remaining, const gchar *extra_pango_markup);
void xfmedia_mainwin_set_song_label(XfmediaMainwin *mwin, const gchar *str);
void xfmedia_mainwin_set_infobar_type(XfmediaMainwin *mwin, XfmediaInfobarType type);
void xfmedia_mainwin_set_play_buttons(XfmediaMainwin *mwin);
void xfmedia_mainwin_set_pause_buttons(XfmediaMainwin *mwin);
void xfmedia_mainwin_set_autohide(XfmediaMainwin *mwin, gboolean do_autohide);

void xfmedia_mainwin_activate_systray(XfmediaMainwin *mwin);
void xfmedia_mainwin_deactivate_systray(XfmediaMainwin *mwin);

void xfmedia_mainwin_connect_slider_callback(XfmediaMainwin *mwin);
void xfmedia_mainwin_disconnect_slider_callback(XfmediaMainwin *mwin);

gboolean xfmedia_mainwin_check_do_autohide(XfmediaMainwin *mwin);
void xfmedia_mainwin_show(XfmediaMainwin *mwin);

void xfmedia_mainwin_toggle_playpause(XfmediaMainwin *mwin);
void xfmedia_mainwin_stop(XfmediaMainwin *mwin);
void xfmedia_mainwin_next(XfmediaMainwin *mwin);
void xfmedia_mainwin_prev(XfmediaMainwin *mwin);

gboolean xfmedia_mainwin_play_uri(XfmediaMainwin *mwin, const gchar *uri, gint idx_ref);
gboolean xfmedia_mainwin_play_file_at_index(XfmediaMainwin *mwin, gint idx);
gboolean xfmedia_mainwin_play_file_at_index_persistent(XfmediaMainwin *mwin, gint idx);

void xfmedia_mainwin_enable_autohide(XfmediaMainwin *mwin);
void xfmedia_mainwin_disable_autohide(XfmediaMainwin *mwin);

void xfmedia_mainwin_queue_selected(XfmediaMainwin *mwin);
void xfmedia_mainwin_toggle_playlist_queue(XfmediaMainwin *mwin);

G_END_DECLS
 
#endif
