/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void useragent(void)
{

   FILE *fp_in = NULL, *fp_ou = NULL, *fp_ht = NULL;
   char ip[MAXLEN], data[MAXLEN], agent[MAXLEN], user[MAXLEN];
   char ipbefore[MAXLEN], namebefore[MAXLEN];
   char tagent[MAXLEN];
   char user_old[MAXLEN]="$#%0a3bc6";
   char agent_old[MAXLEN]="$#%0a3bc6";
   char hfile[MAXLEN];
   char idate[MAXLEN], fdate[MAXLEN];
   char tmp2[MAXLEN];
   int  agentot=0, agentot2=0, agentdif=0, cont=0, nagent;
   unsigned long totregsl=0;
   int cstatus;
   char ftime[128];
   struct getwordstruct gwarea;

   ip[0]='\0';
   data[0]='\0';
   agent[0]='\0';
   user[0]='\0';
   user_old[0]='\0';
   agent_old[0]='\0';
   ipbefore[0]='\0';
   namebefore[0]='\0';

   sprintf(tmp3,"%s/squagent.unsort",TempDir);
   sprintf(tmp2,"%s/squagent.log",TempDir);

   if((fp_in=fopen(UserAgentLog,"r"))==NULL) {
      fprintf(stderr, "SARG: (useragent) %s: %s\n",text[45],UserAgentLog);
      exit(1);
   }

   if((fp_ou=fopen(tmp3,"w"))==NULL) {
      fprintf(stderr, "SARG: (email) %s: %s\n",text[45],tmp3);
      exit(1);
   }

   if(debug) {
      debuga("%s: %s",text[66],UserAgentLog);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      totregsl++;
      getword_start(&gwarea,buf);
      if (getword(ip,sizeof(ip),&gwarea,' ')<0 || getword_skip(MAXLEN,&gwarea,'[')<0 ||
          getword(data,sizeof(data),&gwarea,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",UserAgentLog);
         exit(1);
      }
      if(totregsl == 1)
         strcpy(idate,data);
      if (getword_skip(MAXLEN,&gwarea,'"')<0 || getword(agent,sizeof(agent),&gwarea,'"')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",UserAgentLog);
         exit(1);
      }
      strcpy(warea,agent);
      strup(warea);
      if(strstr(warea,"SCRIPT") != 0 || strstr(warea,"ONLOAD") != 0)
         baddata();

      if(gwarea.current[0]!='\0') {
         if (getword_skip(MAXLEN,&gwarea,' ')<0 || getword(user,sizeof(user),&gwarea,'\n')<0) {
            printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",UserAgentLog);
            exit(1);
         }
      }

      if(user[0] == '-')
         strcpy(user,ip);
      if(user[0] == '\0')
         strcpy(user,ip);

      fprintf(fp_ou,"%s\t%s\t%s\n",ip,agent,user);
      user[0]='\0';
   }

   strcpy(fdate,data);

   if(debug) {
      debuga("   %s: %ld",text[10],totregsl);
   }

   fclose(fp_in);
   fclose(fp_ou);

   if(debug) {
      debuga("%s: %s",text[54],tmp2);
   }

   sprintf(csort,"sort -n -t \"\t\" -k 3,3 -k 2,2 -k 1,1 -o \"%s\" \"%s\"",tmp2,tmp3);
   cstatus=system(csort);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }
   if((fp_in=fopen(tmp2,"r"))==NULL) {
      fprintf(stderr, "SARG: (useragent) %s: %s\n",text[45],tmp2);
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }

   unlink(tmp3);

   sprintf(hfile,"%s/useragent.html", dirname);
   if((fp_ht=fopen(hfile,"w"))==NULL) {
      fprintf(stderr, "SARG: (useragent) %s: %s\n",text[45],hfile);
      exit(1);
   }

   if(debug)
      debuga("%s",text[72]);

   fprintf(fp_ht, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   css(fp_ht);
   fputs("</head>\n",fp_ht);
   //if(FontFace[0] != '\0') fprintf(fp_ht,"<font face=\"%s\">\n",FontFace);
   fprintf(fp_ht,"<body bgcolor=\"%s\" text=\"%s\" background=\"%s\">\n",BgColor,TxColor,BgImage);
   write_logo_image(fp_ht);

   if(strcmp(IndexTree,"date") == 0)
      show_sarg(fp_ht, "../../..");
   else
      show_sarg(fp_ht,"..");
   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ht);
   fprintf(fp_ht,"<tr><th align=\"center\" colspan=\"2\"><b><font color=\"%s\" size=\"+1\">%s</font></b></th></tr>\n",TiColor,text[105]);

   fputs("<tr><td></td></tr><tr><td></td></tr>",fp_ht);
   fputs("</table></div>\n",fp_ht);

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ht);

   fprintf(fp_ht,"<tr><td align=\"right\" bgcolor=\"%s\">%s:<td align=\"left\" bgcolor=\"%s\">%s - %s</td></td></tr>\n",HeaderBgColor,text[89],TxBgColor,idate,fdate);

   fputs("</table></div>\n",fp_ht);
   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ht);
   fputs("<tr><td></td><td></td></tr>",fp_ht);

   fprintf(fp_ou,"<tr><th align=\"left\" bgcolor=\"%s\"><font color=\"%s\">%s</font></th><th bgcolor=\"%s\" align=\"left\"><font color=\"%s\">%s</font></th></tr>\n",HeaderBgColor,HeaderColor,text[98],HeaderBgColor,HeaderColor,text[106]);

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword_start(&gwarea,buf);
      if (getword(ip,sizeof(ip),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",tmp2);
         exit(1);
      }

      if(Ip2Name) {
         if(strcmp(ip,ipbefore) != 0) {
            strcpy(ipbefore,ip);
            ip2name(ip,sizeof(ip));
            strcpy(namebefore,ip);
         } else strcpy(ip,namebefore);
      }

      if (getword(agent,sizeof(agent),&gwarea,'\t')<0 ||
          getword(user,sizeof(user),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",tmp2);
         exit(1);
      }

      if(strcmp(user,user_old) != 0) {
         fprintf(fp_ht,"<tr><td align=\"left\" bgcolor=\"%s\">%s</td><td align=\"left\" bgcolor=\"%s\">%s</td></tr>\n",TxBgColor,user,TxBgColor,agent);
         strcpy(user_old,user);
         strcpy(agent_old,agent);
      } else {
         if(strcmp(agent,agent_old) != 0) {
            fprintf(fp_ht,"<tr><td></td><td align=\"left\" bgcolor=\"%s\">%s</td></tr>\n",TxBgColor,agent);
            strcpy(agent_old,agent);
         }
      }
   }

   fputs("</table>\n",fp_ht);
   fclose(fp_in);
   fclose(fp_ou);

   sprintf(csort,"sort -t \"\t\" -k 2,2 -o \"%s\" \"%s\"",tmp3,tmp2);
   cstatus=system(csort);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }
   if((fp_in=fopen(tmp3,"r"))==NULL) {
      fprintf(stderr, "SARG: (useragent) %s: %s\n",text[45],tmp3);
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }

   unlink(tmp2);

   if((fp_ou=fopen(tmp2,"w"))==NULL) {
      fprintf(stderr, "SARG: (useragent) %s: %s\n",text[45],tmp2);
      exit(1);
   }

   agent_old[0]='\0';
   cont=0;

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword_start(&gwarea,buf);
      if (getword(ip,sizeof(ip),&gwarea,'\t')<0 ||
          getword(agent,sizeof(agent),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",tmp);
         exit(1);
      }

      if(!cont) {
         cont++;
         strcpy(agent_old,agent);
      }

      if(strcmp(agent,agent_old) != 0) {
         agentdif++;
         fprintf(fp_ou,"%06d %s\n",agentot,agent_old);
         strcpy(agent_old,agent);
         agentot2+=agentot;
         agentot=0;
      }
      agentot++;
   }
   agentdif++;
   fprintf(fp_ou,"%06d %s\n",agentot,agent);
   agentot2+=agentot;

   fclose(fp_in);
   fclose(fp_ou);

   unlink(tmp3);

   sprintf(csort,"sort -n -r -k 1,1 -o \"%s\" \"%s\"",tmp3,tmp2);
   cstatus=system(csort);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }
   if((fp_in=fopen(tmp3,"r"))==NULL) {
      fprintf(stderr, "SARG: (useragent) %s: %s\n",text[45],tmp3);
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }

   unlink(tmp2);

   if((fp_ht=fopen(hfile,"a"))==NULL) {
      fprintf(stderr, "SARG: (useragent) %s: %s\n",text[45],hfile);
      exit(1);
   }

   fputs("<br><br>\n",fp_ht);

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ht);
   fprintf(fp_ht,"<tr><th align=\"left\" bgcolor=\"%s\"><font color=\"%s\">%s</font></th><th bgcolor=\"%s\" align=\"left\"><font color=\"%s\">%s</font></th><th align=\"center\" bgcolor=\"%s\"><font color=\"%s\">%%</font></th></tr>\n",HeaderBgColor,HeaderColor,text[106],HeaderBgColor,HeaderColor,text[107],HeaderBgColor,HeaderColor);

   perc=0.;
   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      fixendofline(buf);
      getword_start(&gwarea,buf);
      if (getword(tagent,sizeof(tagent),&gwarea,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",tmp);
         exit(1);
      }
      nagent=atoi(tagent);
      if(agentot2>0) {
         perc=nagent * 100;
         perc=perc / agentot2;
      }

      fprintf(fp_ht,"<tr><td align=\"left\" bgcolor=\"%s\">%s</td><td align=\"right\" bgcolor=\"%s\">%d</td><td align=\"right\" bgcolor=\"%s\">%3.2f</td></tr>\n",TxBgColor,gwarea.current,TxBgColor,nagent,TxBgColor,perc);
   }

   fputs("</table></html>\n",fp_ht);
   if(ShowSargInfo) {
      zdate(ftime, sizeof(ftime), DateFormat);
      fprintf(fp_ht,"<br><br><div align=\"center\"><font size=\"-2\">%s <a href=\"%s\">%s-%s</a> %s %s</font></div>\n",text[108],URL,PGM,VERSION,text[109],ftime);
   }

   fputs("</table>\n</body>\n</html>\n",fp_ht);
   fclose(fp_in);
   fclose(fp_ht);

   unlink(tmp3);

   return;

}
