/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution
*/
#ifndef FILELIST_H
#define FILELIST_H

#include <qobject.h>
#include <qlistbox.h>
#include "common.h"

class Domain;
class StateInfo;
class Git;

class ListBoxFileItem: public QListBoxText {
public:
	ListBoxFileItem(QListBox* lb, SCRef t, const QColor& c);
	virtual void paint(QPainter* p);

private:
	QColor myColor;
};

class ListBoxFiles: public QObject {
Q_OBJECT
public:
	ListBoxFiles(Domain* mi, Git* g, QListBox* l);

	void clear();
	void update(const RevFile* files);

signals:
	void fileSelected(const QString&);
	void contextMenu(const QString&, int);

private slots:
	void on_currentChanged(QListBoxItem* item);
	void on_contextMenuRequested(QListBoxItem* item);
	void on_mouseButtonPressed(int, QListBoxItem*, const QPoint&);
	void on_clicked(QListBoxItem*);
	void on_onItem(QListBoxItem*);
	void on_onViewport();

private:
	void insertFiles(const RevFile* files);
	void mouseMoved();
	bool isMergeHeader(QListBoxItem* c) const;

	Domain* d;
	Git* git;
	QListBox* lb;
	StateInfo* st;
	QString dragFileName;
};

#endif
