/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef PROFILEMANAGER_H
#define PROFILEMANAGER_H

#include "profilemanagerbase.h"
#include "profilewidget.h"
#include <qptrlist.h>
#include <qtextedit.h>
#include "vpnaccountdata.h"
#include <kdialogbase.h>
#include <qlayout.h>

/**
@author Christoph Thielecke
*/
class ProfileManager : public KDialogBase {
	public:
		/**
		 *     Constructor
		 * @param AccountList The list with the profiles
		 * @param LogOutput Graphical debug output
		 * @param KvpncDebugLevel The debug level of kvpnc
		 * @param currentProfile The current profile
		 * @param parent Pointer to parent window
		 * @param name Name of the dialog
		 * @param modal True if dialog is modal
		 * @param fl Window flags
		 * @return nothing
		 */
		ProfileManager( QWidget *parent, const QString& caption, KVpncConfig *GlobalConfig);

		/**
		 *     Destruktor
		 * @return nothing
		 */
		~ProfileManager();

	public:
		ProfileWidget *MyprofileWidget; //< Widget with profile settings
		ProfileManagerDialogBase *main;
	
};

#endif
