/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *        0000                                                                 *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KVKBDMAINWIDGET_H
#define KVKBDMAINWIDGET_H


#include <qevent.h>
#include <qpoint.h>
#include <qtimer.h>
#include <kaboutdata.h>
#include <ksystemtray.h>
#include <kpopupmenu.h>
#include <qpainter.h>
#include <qthread.h>

#include "resizabledragwidget.h"
#include "VButton.h"
#include "numpadvbutton.h"
#include <X11/Xlib.h>

class KbdDock;
class KbdTray;

class MainWidget : public ResizableDragWidget
{
Q_OBJECT
public:
	MainWidget(KAboutData *about=0, bool tren=false, QWidget *parent=0,const char *name="", WFlags f=WStyle_Customize | Qt::WX11BypassWM |WStyle_NormalBorder);
	void mappingNotify(XMappingEvent *e);
	void finishInit();
	bool close ( bool alsoDelete );
	KbdDock* kbdDock() const;

public slots:
	void keyPress(unsigned int keycode);

	void toggleCaps();
	void toggleNumlock();

	void toggleShift();

	void queryModState();
	void showDock();
	
	void quitClicked();
	void chooseFont();
	void toggleNumericPad();
	void toggleFontAutoRes();
	void restorePosition();
	void showConfigMenu();
// 	void shutDown();
 	void saveState();
	void toggleLock();

protected:
	void resizeEvent(QResizeEvent *e);
	void hideEvent ( QHideEvent *e );


private:
	void updateFont();

	bool nresize;

	bool keyState(int iKey);
	void keyPress(int keycode);
	void setupText(VButton &v);


	VButton *caps;
	VButton *lshft;
	VButton *rshft;

	VButton *lctrl;
	VButton *rctrl;
	
	VButton *lalt;
	VButton *ralt;

	VButton *win;
	VButton *mnu;

	VButton *numl;
	VButton *div;
	VButton *mul;
	VButton *min;
	VButton *plu;
	VButton *ent;

	NumpadVButton *ins;
	NumpadVButton *del;
	
	QValueList<VButton *> btns;
	QValueList<VButton *> mod_keys;
	QValueList<VButton *> other_keys;
	QValueList<NumpadVButton *> numl_keys;

	void send_key(unsigned int keycode, bool press, bool release);
	 
	Display *display;	
	KbdTray *tray;
	KbdDock *dock;

	bool stand_alone;
	long keysym2ucs(KeySym keysym);

	bool extent_visible;
	VButton *quit;
	VButton *popup_menu;
	VButton *extent;
	double sdxs;
	double sdxb;
	int mnu_dock;
	int mnu_autores;
	int mnu_lock;

};


class KbdDock : public DragWidget
{
    Q_OBJECT

public:
    KbdDock(MainWidget *m);
    ~KbdDock();

	void paintEvent(QPaintEvent *);


private:
	QPixmap icn;
	MainWidget *mainWidget;
	

protected:
	void mouseReleaseEvent(QMouseEvent *e);

};

class KbdTray : public KSystemTray
{

public:
 	KbdTray( QWidget* parent = 0, const char* name  = 0 );

protected:	
    void mousePressEvent(QMouseEvent *);

};

#endif
