#ifndef CMDLINE_HINT_H
#define CMDLINE_HINT_H

#include <qmap.h>
#include <qvariant.h>
#include <qlistbox.h>
#include <qlineedit.h>

class Chat;
class UserGroup;
class CmdDescHint;

/*!
 * \class CmdLineHint
 * It's window which show ups when user demands to complete special word by PK.
 * It's list with items that matches to current completion pattern
 * and additional (internal) widget to show details about selected item
 * if it has such details informations set.
 * PK can complete commands, nicknames, UINs and emoticons.
 * \brief Cmd line completion items list window
 */
class CmdLineHint : public QListBox
{
	Q_OBJECT

	public:
		/*!
		 * \fn CmdLineHint(Chat* parent, QStringList matches)
		 * Creates hint without details descriptions.
		 * \param parent Parent chat window to make changes in.
		 * \param matches List of correct matches to display.
		 */
		CmdLineHint(Chat* parent, QStringList matches);

		/*!
		 * \fn CmdLineHint(Chat* parent, QStringList matches)
		 * Creates hint without details descriptions.
		 * \param parent Parent chat window to make changes in.
		 * \param matches List of correct matches to display.
		 * \param descriptions Details descriptions for items.
		 */
		CmdLineHint(Chat* parent, QStringList matches, QMap<QString,QString> descriptions);

		/*!
		 * \fn ~CmdLineHint()
		 * Deletes the listbox and all internal objects.
		 */
		~CmdLineHint();

	protected:
		/*!
		 * \fn void focusOutEvent(QFocusEvent *e)
		 * Called when user takes focus away from this hint.
		 * Destroys the hint widget.
		 * \param e Object describing taking off focus event.
		 */
		void focusOutEvent(QFocusEvent *e);

		/*!
		 * \fn void keyPressEvent(QKeyEvent * e)
		 * Handles keys to navigate between items in list.
		 * \param e Object describing key pressing event.
		 */
		void keyPressEvent(QKeyEvent * e);

		/*!
		 * \fn void keyReleaseEvent(QKeyEvent * e)
		 * Handles tab key (coming from chat window) to avoid sending it to this window.
		 * \param e Object describing key pressing event.
		 */
		void keyReleaseEvent(QKeyEvent * e);

	private:
		/*!
		 * \var QMap<QString,QString> desc
		 * The map, containing details descriptions for list items
		 * (description for some items can be empty).
		 */
		QMap<QString,QString> desc;

		/*!
		 * \var bool initialized
		 * Contains 'true' value after hint widget has been completly initialized.
		 * It's needed to decide if focusOutEvent should do its job.
		 */
		bool initialized;

		/*!
		 * \var Chat* chat
		 * Parent chat to replace word in.
		 */
		Chat* chat;

		/*!
		 * \var QLabel* hintDesc
		 * Details description widget for items that has entry in #desc.
		 */
		CmdDescHint* hintDesc;

		/*!
		 * \fn void init(Chat* parent, QStringList matches)
		 * Initializes internal data and objects, called by constructors.
		 * \param parent Parameter passed from constructor.
		 * \param matches Parameter passed from constructor.
		 */
		void init(Chat* parent, QStringList matches);

		/*!
		 * \fn void setCurrItem(int index)
		 * Sets new item as the current one and checks if it has some additional description
		 * to show in a second hint.
		 */
		void setCurrItem(int index);

	public slots:
		/*!
		 * \fn void handleDestroyingChat(const UserGroup *group)
		 * Called when any chat window is destroyed.
		 * \param group Users group that chat was opened for.
		 */
		void handleDestroyingChat(const UserGroup *group);
};

/*!
 * \author Pawel Salawa (Googie)
 */
class CmdDescHint : public QLineEdit
{
	public:
		CmdDescHint(QWidget *parent);
};

#endif
