/*
                              MIME Type Fetching
 */

#ifndef EDV_MIME_TYPE_GET_H
#define EDV_MIME_TYPE_GET_H

#include <sys/stat.h>
#include <glib.h>
#include "edv_mime_type.h"
#include "edv_context.h"


/*
 *	Gets the MIME Types list.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The total specifies the return value for the total number of MIME Types
 *	in the list.
 *
 *	The returned list must not be modified or deleted.
 */
extern edv_mime_type_struct **EDVMimeTypeList(
	edv_context_struct *ctx,
	gint *total
);

/*
 *	Matches the MIME Type by path and object statistics.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path or name of the object.
 *
 *	The lstat_buf specifies the local statistics of the object.
 *
 *	Returns the matched MIME Type or NULL on error, the returned
 *	MIME Type must not be modified or deleted.
 */
extern edv_mime_type_struct *EDVMimeTypeMatch(
	edv_context_struct *ctx,
	const gchar *path, const struct stat *lstat_buf
);

/*
 *	Matches the MIME Type by type string.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The type specifies the type string.
 *
 *	Returns the matched MIME Type or NULL on error, the returned
 *	MIME Type must not be modified or deleted.
 */
extern edv_mime_type_struct *EDVMimeTypeMatchType(
	edv_context_struct *ctx,
	const gchar *type
);


#endif	/* EDV_MIME_TYPE_GET_H */
