#ifndef GUIRGBIMG_H
#define GUIRGBIMG_H

#include <gtk/gtk.h>


extern void GUIImageBufferCopyArea(
	gint bpp,
	const guint8 *src_data,
	gint src_width, gint src_height, gint src_bpl,
	guint8 *tar_data,
	gint tar_width, gint tar_height, gint tar_bpl,
	gint tar_x, gint tar_y,
	const gboolean blend
);
extern void GUIImageBufferResize(
	gint bpp,
	const guint8 *src_data,
	gint src_width, gint src_height, gint src_bpl,
	guint8 *tar_data,
	gint tar_width, gint tar_height, gint tar_bpl
);
extern void GUIImageBufferRotateCW90(
	gint bpp,
	const guint8 *src_data,
	gint src_width, gint src_height, gint src_bpl,
	guint8 *tar_data,
	gint tar_width, gint tar_height, gint tar_bpl
);
extern void GUIImageBufferRotateCCW90(
	gint bpp,
	const guint8 *src_data,
	gint src_width, gint src_height, gint src_bpl,
	guint8 *tar_data,
	gint tar_width, gint tar_height, gint tar_bpl
);
extern void GUIImageBufferRotateCW180(
	gint bpp,
	const guint8 *src_data,
	gint src_width, gint src_height, gint src_bpl,
	guint8 *tar_data,
	gint tar_width, gint tar_height, gint tar_bpl
);
extern void GUIImageBufferMirrorH(
	gint bpp,
	const guint8 *src_data,
	gint src_width, gint src_height, gint src_bpl,
	guint8 *tar_data, 
	gint tar_width, gint tar_height, gint tar_bpl
);
extern void GUIImageBufferMirrorV(
	gint bpp,
	const guint8 *src_data,
	gint src_width, gint src_height, gint src_bpl,
	guint8 *tar_data, 
	gint tar_width, gint tar_height, gint tar_bpl
);
extern void GUIImageBufferFlattenWithBG(
	gint bpp,
	guint8 *data,
	gint width, gint height, gint bpl,   
	const guint8 *bg_color
);
#define gdk_get_rgb_image		GUIGetRGBImage
extern guint8 *GUIGetRGBImage(
	GdkDrawable *drawable,
	const GdkRectangle *rect,
	gint *width_rtn, gint *height_rtn, gint *bpl_rtn
);
#define gdk_get_rgba_image		GUIGetRGBAImage
extern guint8 *GUIGetRGBAImage(
	GdkDrawable *drawable,
	const GdkRectangle *rect,
	gint *width_rtn, gint *height_rtn, gint *bpl_rtn
);


#endif	/* GUIRGBIMG_H */
