/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <gnome-xml/parser.h>
#include <gnome-xml/tree.h>
#include <ctype.h>

#include "support.h"
#include "text_util.h"
#include "food.h"
#include "recipe.h"
#include "recipe_win.h"
#include "edit_food_dlg.h"

static GladeXML *xml = NULL;
static void load_xml( void);

/* load the glade xml if not already loaded. */
static void
load_xml()
{
	static gboolean loaded_xml = FALSE;

	/* load the glade interface. */
	if ( !loaded_xml)
	{
		xml = glade_xml_new( GNUTRITION_GLADEDIR "/edit_food_dlg.glade", NULL);
		loaded_xml = TRUE;

		if (  xml != NULL)
		{
			glade_xml_signal_autoconnect( xml);
		}
		else
		{
			g_log( "Gnutrition", G_LOG_LEVEL_ERROR,
					"gnutr_edit_food_dlg: cannot load glade file\n");
			return;
		}
	}
}

/* reopens the search dialog window, so an ingredient can be edited,
 * when the edit button is released in the AppBar on the recipe window. */
void
gnutr_show_edit_food_dlg()
{
	gchar *amount, *measure_sel, *food_desc;
	Food_t *food;
	GList *measure_glist = NULL;
	gchar *measure_text;
	gint i;

	Recipe_t *recipe = gnutr_ret_recipe();

	if ( xml == NULL) load_xml();

	/* get the food in the recipe to be edited. */
	food = (Food_t *)gtk_clist_get_row_data( 
			recipe->ingredient_clist, recipe->selected_row);

	gtk_clist_get_text( recipe->ingredient_clist, recipe->selected_row, 
			0, &amount);
	gtk_clist_get_text( recipe->ingredient_clist, recipe->selected_row, 
			1, &measure_sel);
	gtk_clist_get_text( recipe->ingredient_clist, recipe->selected_row, 
			2, &food_desc);

	/* create a list of measures for the selected food, put in
	 * the combo box. */
	for ( i=0; i< food->no_msre; i++)
	{
		measure_text = food->msre[i]->msre_desc;
		measure_glist = g_list_append( measure_glist, measure_text);
	}
	gtk_combo_set_popdown_strings( GTK_COMBO( glade_xml_get_widget( 
			xml, "gnutr_edit_food_msre_combo")), measure_glist);

	/* set the text entries. */
	gtk_entry_set_text( GTK_ENTRY( glade_xml_get_widget(
			xml, "gnutr_edit_food_sel_food_entry")), food_desc);

	gtk_entry_set_text( GTK_ENTRY( glade_xml_get_widget(
			xml, "gnutr_edit_food_msre_combo_entry")), measure_sel);

	gtk_entry_set_text( GTK_ENTRY( glade_xml_get_widget(
			xml, "gnutr_edit_food_amount_entry")), amount);

	g_list_free( measure_glist);

	gtk_widget_show( glade_xml_get_widget( xml, "gnutr_edit_food_dialog"));
}

/* The callback when the text in the measure combo entry is changed. */
void
on_gnutr_edit_food_msre_combo_entry_changed( GtkEditable *editable,
                                             gpointer     user_data)
{
	/* reset the amount to one. */
	gtk_entry_set_text( GTK_ENTRY(  glade_xml_get_widget(
			xml, "gnutr_edit_food_amount_entry")), "1\0");
}

/* The callback when the "Cancel" button is pressed in the edit food dialog. */
void
on_gnutr_edit_food_cancel_button_released( GtkButton *button,
                                           gpointer   user_data)
{	
	gtk_widget_hide( glade_xml_get_widget( xml, "gnutr_edit_food_dialog"));
}

/* The callback when the "OK" button is pressed in the edit food dialog. */
void
on_gnutr_edit_food_ok_button_released( GtkButton *button,
                                       gpointer   user_data)
{	
	Food_t *food;
	gchar *string, *clist_text[3];
	gint i;

	Recipe_t *recipe = gnutr_ret_recipe();

	food = (Food_t *)gtk_clist_get_row_data(
			recipe->ingredient_clist, recipe->selected_row);

	/* amount. */
	string = gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget( xml,
			"gnutr_edit_food_amount_entry")));
	clist_text[0] = g_strdup( string);

	/* measure. */
	string = gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget( xml,
		"gnutr_edit_food_msre_combo_entry")));
	clist_text[1] = g_strdup( string);

	/* reset to the new selected measure number. */
	food->sel_msre = get_food_measure_num( food, string);

	/* food description. */
	clist_text[2] = g_strdup( food->desc->fd_desc);

	/* Insert a new ingredient in the recipe clist. */
	gtk_clist_freeze( recipe->ingredient_clist);

	gtk_clist_insert( recipe->ingredient_clist, 
			recipe->selected_row, clist_text);
	gtk_clist_set_row_data( recipe->ingredient_clist, recipe->selected_row,
			( gpointer)food);

	/* remove old ingredient from the recipe clist. */
	gtk_clist_remove( recipe->ingredient_clist, recipe->selected_row+1);

	gtk_clist_thaw( recipe->ingredient_clist);

	/* free allocated memory. */
	for ( i=0; i<3; i++) g_free( clist_text[i]);

	/* hide the edit food dialog. */
	gtk_widget_hide( glade_xml_get_widget( xml, "gnutr_edit_food_dialog"));
}
