# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class SupportingDocumentTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.supporting_documents.create(friendly_name="friendly_name", type="type")

        values = {'FriendlyName': "friendly_name", 'Type': "type", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://trusthub.twilio.com/v1/SupportingDocuments',
            data=values,
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "status": "draft",
                "date_updated": "2021-02-11T17:23:00Z",
                "friendly_name": "Business-profile-physical-address",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "https://trusthub.twilio.com/v1/SupportingDocuments/RDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2021-02-11T17:23:00Z",
                "sid": "RDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "attributes": {
                    "address_sids": "ADaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                },
                "type": "customer_profile_address",
                "mime_type": null
            }
            '''
        ))

        actual = self.client.trusthub.v1.supporting_documents.create(friendly_name="friendly_name", type="type")

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.supporting_documents.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://trusthub.twilio.com/v1/SupportingDocuments',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "results": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://trusthub.twilio.com/v1/SupportingDocuments?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://trusthub.twilio.com/v1/SupportingDocuments?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "results"
                }
            }
            '''
        ))

        actual = self.client.trusthub.v1.supporting_documents.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "results": [
                    {
                        "status": "draft",
                        "date_updated": "2021-02-11T17:23:00Z",
                        "friendly_name": "Business-profile-physical-address",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "url": "https://trusthub.twilio.com/v1/SupportingDocuments/RDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "date_created": "2021-02-11T17:23:00Z",
                        "sid": "RDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "attributes": {
                            "address_sids": "ADaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        },
                        "type": "customer_profile_address",
                        "mime_type": null
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://trusthub.twilio.com/v1/SupportingDocuments?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://trusthub.twilio.com/v1/SupportingDocuments?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "results"
                }
            }
            '''
        ))

        actual = self.client.trusthub.v1.supporting_documents.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.supporting_documents("RDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://trusthub.twilio.com/v1/SupportingDocuments/RDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "status": "draft",
                "date_updated": "2021-02-11T17:23:00Z",
                "friendly_name": "Business-profile-physical-address",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "https://trusthub.twilio.com/v1/SupportingDocuments/RDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2021-02-11T17:23:00Z",
                "sid": "RDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "attributes": {
                    "address_sids": "ADaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                },
                "type": "customer_profile_address",
                "mime_type": null
            }
            '''
        ))

        actual = self.client.trusthub.v1.supporting_documents("RDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.supporting_documents("RDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://trusthub.twilio.com/v1/SupportingDocuments/RDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_update_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "status": "draft",
                "date_updated": "2021-02-11T17:23:00Z",
                "friendly_name": "friendly_name",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "https://trusthub.twilio.com/v1/SupportingDocuments/RDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2021-02-11T17:23:00Z",
                "sid": "RDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "attributes": {
                    "address_sids": "ADaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                },
                "type": "customer_profile_address",
                "mime_type": null
            }
            '''
        ))

        actual = self.client.trusthub.v1.supporting_documents("RDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.assertIsNotNone(actual)

    def test_delete_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.supporting_documents("RDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.holodeck.assert_has_request(Request(
            'delete',
            'https://trusthub.twilio.com/v1/SupportingDocuments/RDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_delete_response(self):
        self.holodeck.mock(Response(
            204,
            None,
        ))

        actual = self.client.trusthub.v1.supporting_documents("RDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.assertTrue(actual)
