# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.bulkexports.v1.export import ExportList
from twilio.rest.bulkexports.v1.export_configuration import ExportConfigurationList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Bulkexports

        :returns: V1 version of Bulkexports
        :rtype: twilio.rest.bulkexports.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._exports = None
        self._export_configuration = None

    @property
    def exports(self):
        """
        :rtype: twilio.rest.bulkexports.v1.export.ExportList
        """
        if self._exports is None:
            self._exports = ExportList(self)
        return self._exports

    @property
    def export_configuration(self):
        """
        :rtype: twilio.rest.bulkexports.v1.export_configuration.ExportConfigurationList
        """
        if self._export_configuration is None:
            self._export_configuration = ExportConfigurationList(self)
        return self._export_configuration

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Bulkexports.V1>'
