# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class RestoreAssistantTestCase(IntegrationTestCase):

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.autopilot.v1.restore_assistant.update(assistant="UAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")

        values = {'Assistant': "UAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://autopilot.twilio.com/v1/Assistants/Restore',
            data=values,
        ))

    def test_update_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "UAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2017-07-04T08:34:00Z",
                "date_updated": "2017-07-04T08:34:00Z",
                "unique_name": "so-so-unique",
                "friendly_name": "so so friendly",
                "needs_model_build": false,
                "latest_model_build_sid": null,
                "log_queries": true,
                "development_stage": "in-development",
                "callback_url": "https://example.com/callback_url",
                "callback_events": "model_build_completed model_build_failed"
            }
            '''
        ))

        actual = self.client.autopilot.v1.restore_assistant.update(assistant="UAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")

        self.assertIsNotNone(actual)
