# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class ActivationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of security domain activation."""

    NOT_DEFINED = "NotDefined"
    NOT_ACTIVATED = "NotActivated"
    ACTIVE = "Active"
    FAILED = "Failed"
    UNKNOWN = "Unknown"


class AutoGeneratedDomainNameLabelScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Cloud HSM Cluster's auto-generated Domain Name Label Scope."""

    TENANT_REUSE = "TenantReuse"
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    NO_REUSE = "NoReuse"


class BackupRestoreOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the backup/restore operation."""

    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"


class CloudHsmClusterSkuFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sku family of the Cloud HSM Cluster."""

    B = "B"


class CloudHsmClusterSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sku name of the Cloud HSM Cluster."""

    STANDARD_B1 = "Standard_B1"
    STANDARD_B10 = "Standard B10"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class JsonWebKeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state."""

    SUCCEEDED = "Succeeded"
    """The dedicated HSM has been fully provisioned."""
    PROVISIONING = "Provisioning"
    """The dedicated HSM is currently being provisioned."""
    ALLOCATING = "Allocating"
    """A device is currently being allocated for the dedicated HSM resource."""
    CONNECTING = "Connecting"
    """The dedicated HSM is being connected to the virtual network."""
    FAILED = "Failed"
    """Provisioning of the dedicated HSM has failed."""
    CHECKING_QUOTA = "CheckingQuota"
    """Validating the subscription has sufficient quota to allocate a dedicated HSM device."""
    DELETING = "Deleting"
    """The dedicated HSM is currently being deleted."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"
    UPDATING = "Updating"
    INTERNAL_ERROR = "InternalError"
    CANCELED = "Canceled"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    """Connection waiting for approval or rejection"""
    APPROVED = "Approved"
    """Connection approved"""
    REJECTED = "Rejected"
    """Connection Rejected"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Cloud HSM Cluster's provisioningState."""

    PROVISIONING = "Provisioning"
    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"
    FAILED = "Failed"
    DELETING = "Deleting"
    CANCELED = "Canceled"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Cloud HSM Cluster public network access."""

    DISABLED = "Disabled"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SKU of the dedicated HSM."""

    SAFE_NET_LUNA_NETWORK_HSM_A790 = "SafeNet Luna Network HSM A790"
    """The dedicated HSM is a Safenet Luna Network HSM A790 device."""
    PAY_SHIELD10_K_LMK1_CPS60 = "payShield10K_LMK1_CPS60"
    """The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with
    1 local master key which supports up to 60 calls per second."""
    PAY_SHIELD10_K_LMK1_CPS250 = "payShield10K_LMK1_CPS250"
    """The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with
    1 local master key which supports up to 250 calls per second."""
    PAY_SHIELD10_K_LMK1_CPS2500 = "payShield10K_LMK1_CPS2500"
    """The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with
    1 local master key which supports up to 2500 calls per second."""
    PAY_SHIELD10_K_LMK2_CPS60 = "payShield10K_LMK2_CPS60"
    """The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with
    2 local master keys which supports up to 60 calls per second."""
    PAY_SHIELD10_K_LMK2_CPS250 = "payShield10K_LMK2_CPS250"
    """The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with
    2 local master keys which supports up to 250 calls per second."""
    PAY_SHIELD10_K_LMK2_CPS2500 = "payShield10K_LMK2_CPS2500"
    """The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with
    2 local master keys which supports up to 2500 calls per second."""
