# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kubernetesconfiguration.extensions.aio import KubernetesConfigurationExtensionsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKubernetesConfigurationExtensionsMgmtExtensionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KubernetesConfigurationExtensionsMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_extensions_begin_create(self, resource_group):
        response = await (
            await self.client.extensions.begin_create(
                resource_group_name=resource_group.name,
                cluster_rp="str",
                cluster_resource_name="str",
                cluster_name="str",
                extension_name="str",
                extension={
                    "aksAssignedIdentity": {"principalId": "str", "tenantId": "str", "type": "str"},
                    "autoUpgradeMinorVersion": True,
                    "configurationProtectedSettings": {"str": "str"},
                    "configurationSettings": {"str": "str"},
                    "currentVersion": "str",
                    "customLocationSettings": {"str": "str"},
                    "errorInfo": {
                        "additionalInfo": [{"info": {}, "type": "str"}],
                        "code": "str",
                        "details": [...],
                        "message": "str",
                        "target": "str",
                    },
                    "extensionType": "str",
                    "id": "str",
                    "identity": {"principalId": "str", "tenantId": "str", "type": "SystemAssigned"},
                    "isSystemExtension": False,
                    "name": "str",
                    "packageUri": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str",
                    },
                    "provisioningState": "str",
                    "releaseTrain": "Stable",
                    "scope": {"cluster": {"releaseNamespace": "str"}, "namespace": {"targetNamespace": "str"}},
                    "statuses": [
                        {"code": "str", "displayStatus": "str", "level": "Information", "message": "str", "time": "str"}
                    ],
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                    "version": "str",
                },
                api_version="2024-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_extensions_get(self, resource_group):
        response = await self.client.extensions.get(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            extension_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_extensions_begin_delete(self, resource_group):
        response = await (
            await self.client.extensions.begin_delete(
                resource_group_name=resource_group.name,
                cluster_rp="str",
                cluster_resource_name="str",
                cluster_name="str",
                extension_name="str",
                api_version="2024-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_extensions_begin_update(self, resource_group):
        response = await (
            await self.client.extensions.begin_update(
                resource_group_name=resource_group.name,
                cluster_rp="str",
                cluster_resource_name="str",
                cluster_name="str",
                extension_name="str",
                patch_extension={
                    "autoUpgradeMinorVersion": True,
                    "configurationProtectedSettings": {"str": "str"},
                    "configurationSettings": {"str": "str"},
                    "releaseTrain": "Stable",
                    "version": "str",
                },
                api_version="2024-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_extensions_list(self, resource_group):
        response = self.client.extensions.list(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            api_version="2024-11-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
