# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterator, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import _model_base, models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ..._validation import api_version_validation
from ..._vendor import prepare_multipart_form_data
from ...operations._operations import (
    build_face_detect_from_url_request,
    build_face_detect_request,
    build_face_find_similar_from_large_face_list_request,
    build_face_find_similar_request,
    build_face_group_request,
    build_face_identify_from_large_person_group_request,
    build_face_session_create_liveness_session_request,
    build_face_session_create_liveness_with_verify_session_request,
    build_face_session_create_liveness_with_verify_session_with_verify_image_request,
    build_face_session_delete_liveness_session_request,
    build_face_session_delete_liveness_with_verify_session_request,
    build_face_session_detect_from_session_image_request,
    build_face_session_get_liveness_session_audit_entries_request,
    build_face_session_get_liveness_session_result_request,
    build_face_session_get_liveness_sessions_request,
    build_face_session_get_liveness_with_verify_session_audit_entries_request,
    build_face_session_get_liveness_with_verify_session_result_request,
    build_face_session_get_liveness_with_verify_sessions_request,
    build_face_session_get_session_image_request,
    build_face_verify_face_to_face_request,
    build_face_verify_from_large_person_group_request,
    build_large_face_list_add_face_from_url_request,
    build_large_face_list_add_face_request,
    build_large_face_list_create_request,
    build_large_face_list_delete_face_request,
    build_large_face_list_delete_request,
    build_large_face_list_get_face_request,
    build_large_face_list_get_faces_request,
    build_large_face_list_get_large_face_lists_request,
    build_large_face_list_get_request,
    build_large_face_list_get_training_status_request,
    build_large_face_list_train_request,
    build_large_face_list_update_face_request,
    build_large_face_list_update_request,
    build_large_person_group_add_face_from_url_request,
    build_large_person_group_add_face_request,
    build_large_person_group_create_person_request,
    build_large_person_group_create_request,
    build_large_person_group_delete_face_request,
    build_large_person_group_delete_person_request,
    build_large_person_group_delete_request,
    build_large_person_group_get_face_request,
    build_large_person_group_get_large_person_groups_request,
    build_large_person_group_get_person_request,
    build_large_person_group_get_persons_request,
    build_large_person_group_get_request,
    build_large_person_group_get_training_status_request,
    build_large_person_group_train_request,
    build_large_person_group_update_face_request,
    build_large_person_group_update_person_request,
    build_large_person_group_update_request,
)
from .._vendor import FaceClientMixinABC, FaceSessionClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
_Unset: Any = object()
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class LargeFaceListOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.ai.vision.face.aio.FaceAdministrationClient`'s
        :attr:`large_face_list` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create(
        self, large_face_list_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData
        and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/create-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        large_face_list_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        """Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData
        and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/create-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self, large_face_list_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData
        and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/create-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        large_face_list_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        """Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData
        and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/create-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "recognitionModel": recognition_model, "userData": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_face_list_create_request(
            large_face_list_id=large_face_list_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete(self, large_face_list_id: str, **kwargs: Any) -> None:
        """Delete a face from a Large Face List by specified largeFaceListId and persistedFaceId.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/delete-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_large_face_list_delete_request(
            large_face_list_id=large_face_list_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get(
        self, large_face_list_id: str, *, return_recognition_model: Optional[bool] = None, **kwargs: Any
    ) -> _models.LargeFaceList:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: LargeFaceList. The LargeFaceList is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargeFaceList
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargeFaceList] = kwargs.pop("cls", None)

        _request = build_large_face_list_get_request(
            large_face_list_id=large_face_list_id,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargeFaceList, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self, large_face_list_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        large_face_list_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self, large_face_list_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        large_face_list_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userData": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_face_list_update_request(
            large_face_list_id=large_face_list_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_face_lists(
        self,
        *,
        start: Optional[str] = None,
        top: Optional[int] = None,
        return_recognition_model: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.LargeFaceList]:
        """List Large Face Lists' information of largeFaceListId, name, userData and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-lists for more
        details.

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: list of LargeFaceList
        :rtype: list[~azure.ai.vision.face.models.LargeFaceList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LargeFaceList]] = kwargs.pop("cls", None)

        _request = build_large_face_list_get_large_face_lists_request(
            start=start,
            top=top,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LargeFaceList], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_training_status(self, large_face_list_id: str, **kwargs: Any) -> _models.FaceTrainingResult:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-training-status
        for more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :return: FaceTrainingResult. The FaceTrainingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceTrainingResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.FaceTrainingResult] = kwargs.pop("cls", None)

        _request = build_large_face_list_get_training_status_request(
            large_face_list_id=large_face_list_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceTrainingResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _train_initial(self, large_face_list_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_large_face_list_train_request(
            large_face_list_id=large_face_list_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_train(self, large_face_list_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Submit a Large Face List training task.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/train-large-face-list for more
        details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._train_initial(
                large_face_list_id=large_face_list_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def add_face_from_url(
        self,
        large_face_list_id: str,
        body: JSON,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/add-large-face-list-face-from-url
        for more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: JSON
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_face_from_url(
        self,
        large_face_list_id: str,
        *,
        url: str,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/add-large-face-list-face-from-url
        for more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_face_from_url(
        self,
        large_face_list_id: str,
        body: IO[bytes],
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/add-large-face-list-face-from-url
        for more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_face_from_url(
        self,
        large_face_list_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/add-large-face-list-face-from-url
        for more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_face_list_add_face_from_url_request(
            large_face_list_id=large_face_list_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def add_face(
        self,
        large_face_list_id: str,
        image_content: bytes,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a specified Large Face List, up to 1,000,000 faces.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/add-large-face-list-face for
        more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param image_content: The image to be analyzed. Required.
        :type image_content: bytes
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_large_face_list_add_face_request(
            large_face_list_id=large_face_list_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_face(self, large_face_list_id: str, persisted_face_id: str, **kwargs: Any) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/delete-large-face-list-face for
        more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_large_face_list_delete_face_request(
            large_face_list_id=large_face_list_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_face(
        self, large_face_list_id: str, persisted_face_id: str, **kwargs: Any
    ) -> _models.LargeFaceListFace:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-face for
        more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: LargeFaceListFace. The LargeFaceListFace is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargeFaceListFace
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargeFaceListFace] = kwargs.pop("cls", None)

        _request = build_large_face_list_get_face_request(
            large_face_list_id=large_face_list_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargeFaceListFace, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_face(
        self,
        large_face_list_id: str,
        persisted_face_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list-face for
        more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_face(
        self,
        large_face_list_id: str,
        persisted_face_id: str,
        *,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list-face for
        more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_face(
        self,
        large_face_list_id: str,
        persisted_face_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list-face for
        more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_face(
        self,
        large_face_list_id: str,
        persisted_face_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list-face for
        more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"userData": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_face_list_update_face_request(
            large_face_list_id=large_face_list_id,
            persisted_face_id=persisted_face_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_faces(
        self, large_face_list_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LargeFaceListFace]:
        """List faces' persistedFaceId and userData in a specified Large Face List.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-faces for
        more details.

        :param large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
         maximum length is 64. Required.
        :type large_face_list_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LargeFaceListFace
        :rtype: list[~azure.ai.vision.face.models.LargeFaceListFace]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LargeFaceListFace]] = kwargs.pop("cls", None)

        _request = build_large_face_list_get_faces_request(
            large_face_list_id=large_face_list_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LargeFaceListFace], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class LargePersonGroupOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.ai.vision.face.aio.FaceAdministrationClient`'s
        :attr:`large_person_group` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create(
        self, large_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create a new Large Person Group with user-specified largePersonGroupId, name, an optional
        userData and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        large_person_group_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        """Create a new Large Person Group with user-specified largePersonGroupId, name, an optional
        userData and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self, large_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Create a new Large Person Group with user-specified largePersonGroupId, name, an optional
        userData and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        large_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        **kwargs: Any
    ) -> None:
        """Create a new Large Person Group with user-specified largePersonGroupId, name, an optional
        userData and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :keyword recognition_model: The 'recognitionModel' associated with this face list. Supported
         'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and
         'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since
         its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall
         accuracy is improved compared with 'recognition_01' and 'recognition_02'. Known values are:
         "recognition_01", "recognition_02", "recognition_03", and "recognition_04". Default value is
         None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "recognitionModel": recognition_model, "userData": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_person_group_create_request(
            large_person_group_id=large_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete(self, large_person_group_id: str, **kwargs: Any) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/delete-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_large_person_group_delete_request(
            large_person_group_id=large_person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get(
        self, large_person_group_id: str, *, return_recognition_model: Optional[bool] = None, **kwargs: Any
    ) -> _models.LargePersonGroup:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: LargePersonGroup. The LargePersonGroup is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargePersonGroup
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargePersonGroup] = kwargs.pop("cls", None)

        _request = build_large_person_group_get_request(
            large_person_group_id=large_person_group_id,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargePersonGroup, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self, large_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        large_person_group_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self, large_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        large_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userData": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_person_group_update_request(
            large_person_group_id=large_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_large_person_groups(
        self,
        *,
        start: Optional[str] = None,
        top: Optional[int] = None,
        return_recognition_model: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.LargePersonGroup]:
        """List all existing Large Person Groups' largePersonGroupId, name, userData and recognitionModel.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-groups for
        more details.

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. Default value is None.
        :paramtype return_recognition_model: bool
        :return: list of LargePersonGroup
        :rtype: list[~azure.ai.vision.face.models.LargePersonGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LargePersonGroup]] = kwargs.pop("cls", None)

        _request = build_large_person_group_get_large_person_groups_request(
            start=start,
            top=top,
            return_recognition_model=return_recognition_model,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LargePersonGroup], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_training_status(self, large_person_group_id: str, **kwargs: Any) -> _models.FaceTrainingResult:
        """To check Large Person Group training status completed or still ongoing. Large Person Group
        training is an asynchronous operation triggered by "Train Large Person Group" API.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-training-status
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :return: FaceTrainingResult. The FaceTrainingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceTrainingResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.FaceTrainingResult] = kwargs.pop("cls", None)

        _request = build_large_person_group_get_training_status_request(
            large_person_group_id=large_person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceTrainingResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _train_initial(self, large_person_group_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_large_person_group_train_request(
            large_person_group_id=large_person_group_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["operation-Location"] = self._deserialize("str", response.headers.get("operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_train(self, large_person_group_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Submit a Large Person Group training task. Training is a crucial step that only a trained Large
        Person Group can be used by "Identify From Large Person Group".

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/train-large-person-group for
        more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._train_initial(
                large_person_group_id=large_person_group_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def create_person(
        self, large_person_group_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Large Person Group. To add face to this person, please call
        "Add Large Person Group Person Face".

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_person(
        self,
        large_person_group_id: str,
        *,
        name: str,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Large Person Group. To add face to this person, please call
        "Add Large Person Group Person Face".

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_person(
        self, large_person_group_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Large Person Group. To add face to this person, please call
        "Add Large Person Group Person Face".

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_person(
        self,
        large_person_group_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: str = _Unset,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CreatePersonResult:
        """Create a new person in a specified Large Person Group. To add face to this person, please call
        "Add Large Person Group Person Face".

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Required.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: CreatePersonResult. The CreatePersonResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreatePersonResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreatePersonResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if name is _Unset:
                raise TypeError("missing required argument: name")
            body = {"name": name, "userData": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_person_group_create_person_request(
            large_person_group_id=large_person_group_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreatePersonResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_person(self, large_person_group_id: str, person_id: str, **kwargs: Any) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/delete-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_large_person_group_delete_person_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_person(
        self, large_person_group_id: str, person_id: str, **kwargs: Any
    ) -> _models.LargePersonGroupPerson:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :return: LargePersonGroupPerson. The LargePersonGroupPerson is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargePersonGroupPerson
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargePersonGroupPerson] = kwargs.pop("cls", None)

        _request = build_large_person_group_get_person_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargePersonGroupPerson, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_person(
        self,
        large_person_group_id: str,
        person_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_person(
        self,
        large_person_group_id: str,
        person_id: str,
        *,
        content_type: str = "application/json",
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_person(
        self,
        large_person_group_id: str,
        person_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_person(
        self,
        large_person_group_id: str,
        person_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        name: Optional[str] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword name: User defined name, maximum length is 128. Default value is None.
        :paramtype name: str
        :keyword user_data: Optional user defined data. Length should not exceed 16K. Default value is
         None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"name": name, "userData": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_person_group_update_person_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_persons(
        self, large_person_group_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LargePersonGroupPerson]:
        """List all persons' information in the specified Large Person Group, including personId, name,
        userData and persistedFaceIds of registered person faces.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-persons
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LargePersonGroupPerson
        :rtype: list[~azure.ai.vision.face.models.LargePersonGroupPerson]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LargePersonGroupPerson]] = kwargs.pop("cls", None)

        _request = build_large_person_group_get_persons_request(
            large_person_group_id=large_person_group_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LargePersonGroupPerson], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_face_from_url(
        self,
        large_person_group_id: str,
        person_id: str,
        body: JSON,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a person into a Large Person Group for face identification or verification.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/add-large-person-group-person-face-from-url
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: JSON
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_face_from_url(
        self,
        large_person_group_id: str,
        person_id: str,
        *,
        url: str,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a person into a Large Person Group for face identification or verification.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/add-large-person-group-person-face-from-url
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_face_from_url(
        self,
        large_person_group_id: str,
        person_id: str,
        body: IO[bytes],
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a person into a Large Person Group for face identification or verification.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/add-large-person-group-person-face-from-url
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_face_from_url(
        self,
        large_person_group_id: str,
        person_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a person into a Large Person Group for face identification or verification.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/add-large-person-group-person-face-from-url
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_person_group_add_face_from_url_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def add_face(
        self,
        large_person_group_id: str,
        person_id: str,
        image_content: bytes,
        *,
        target_face: Optional[List[int]] = None,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddFaceResult:
        """Add a face to a person into a Large Person Group for face identification or verification.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/add-large-person-group-person-face
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param image_content: The image to be analyzed. Required.
        :type image_content: bytes
        :keyword target_face: A face rectangle to specify the target face to be added to a person, in
         the format of 'targetFace=left,top,width,height'. Default value is None.
        :paramtype target_face: list[int]
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword user_data: User-provided data attached to the face. The size limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: AddFaceResult. The AddFaceResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.AddFaceResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[_models.AddFaceResult] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_large_person_group_add_face_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            target_face=target_face,
            detection_model=detection_model,
            user_data=user_data,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddFaceResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_face(
        self, large_person_group_id: str, person_id: str, persisted_face_id: str, **kwargs: Any
    ) -> None:
        """Delete a face from a person in a Large Person Group by specified largePersonGroupId, personId
        and persistedFaceId.

        Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/delete-large-person-group-person-face
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_large_person_group_delete_face_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_face(
        self, large_person_group_id: str, person_id: str, persisted_face_id: str, **kwargs: Any
    ) -> _models.LargePersonGroupPersonFace:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person-face
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :return: LargePersonGroupPersonFace. The LargePersonGroupPersonFace is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.LargePersonGroupPersonFace
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LargePersonGroupPersonFace] = kwargs.pop("cls", None)

        _request = build_large_person_group_get_face_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            persisted_face_id=persisted_face_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LargePersonGroupPersonFace, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_face(
        self,
        large_person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person-face
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_face(
        self,
        large_person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        *,
        content_type: str = "application/json",
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person-face
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_face(
        self,
        large_person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person-face
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_face(
        self,
        large_person_group_id: str,
        person_id: str,
        persisted_face_id: str,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person-face
        for more details.

        :param large_person_group_id: ID of the container. Required.
        :type large_person_group_id: str
        :param person_id: ID of the person. Required.
        :type person_id: str
        :param persisted_face_id: Face ID of the face. Required.
        :type persisted_face_id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword user_data: User-provided data attached to the face. The length limit is 1K. Default
         value is None.
        :paramtype user_data: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"userData": user_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_large_person_group_update_face_request(
            large_person_group_id=large_person_group_id,
            person_id=person_id,
            persisted_face_id=persisted_face_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore


class FaceClientOperationsMixin(FaceClientMixinABC):

    @overload
    async def _detect_from_url(
        self,
        body: JSON,
        *,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]: ...
    @overload
    async def _detect_from_url(
        self,
        *,
        url: str,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]: ...
    @overload
    async def _detect_from_url(
        self,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]: ...

    @distributed_trace_async
    async def _detect_from_url(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]:
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-detection-operations/detect-from-url for more
        details.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on
         smaller faces (64x64 pixels) and rotated face orientations. Known values are: "detection_01",
         "detection_02", and "detection_03". Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[List[_models.FaceDetectionResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_detect_from_url_request(
            detection_model=detection_model,
            recognition_model=recognition_model,
            return_face_id=return_face_id,
            return_face_attributes=return_face_attributes,
            return_face_landmarks=return_face_landmarks,
            return_recognition_model=return_recognition_model,
            face_id_time_to_live=face_id_time_to_live,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceDetectionResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _detect(
        self,
        image_content: bytes,
        *,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]:
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        Please refer to https://learn.microsoft.com/rest/api/face/face-detection-operations/detect for
        more details.

        :param image_content: The input image binary. Required.
        :type image_content: bytes
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on
         smaller faces (64x64 pixels) and rotated face orientations. Known values are: "detection_01",
         "detection_02", and "detection_03". Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[List[_models.FaceDetectionResult]] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_face_detect_request(
            detection_model=detection_model,
            recognition_model=recognition_model,
            return_face_id=return_face_id,
            return_face_attributes=return_face_attributes,
            return_face_landmarks=return_face_landmarks,
            return_recognition_model=return_recognition_model,
            face_id_time_to_live=face_id_time_to_live,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceDetectionResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def find_similar(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/find-similar for more
        details.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def find_similar(
        self,
        *,
        face_id: str,
        face_ids: List[str],
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/find-similar for more
        details.

        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword face_ids: An array of candidate faceIds. All of them are created by "Detect" and the
         faceIds will expire 24 hours after the detection call. The number of faceIds is limited to
         1000. Required.
        :paramtype face_ids: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def find_similar(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/find-similar for more
        details.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def find_similar(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_id: str = _Unset,
        face_ids: List[str] = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/find-similar for more
        details.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword face_ids: An array of candidate faceIds. All of them are created by "Detect" and the
         faceIds will expire 24 hours after the detection call. The number of faceIds is limited to
         1000. Required.
        :paramtype face_ids: list[str]
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceFindSimilarResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            body = {
                "faceId": face_id,
                "faceIds": face_ids,
                "maxNumOfCandidatesReturned": max_num_of_candidates_returned,
                "mode": mode,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_find_similar_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceFindSimilarResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def verify_face_to_face(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        """Verify whether two faces belong to a same person.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/verify-face-to-face for
        more details.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def verify_face_to_face(
        self, *, face_id1: str, face_id2: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        """Verify whether two faces belong to a same person.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/verify-face-to-face for
        more details.

        :keyword face_id1: The faceId of one face, come from "Detect". Required.
        :paramtype face_id1: str
        :keyword face_id2: The faceId of another face, come from "Detect". Required.
        :paramtype face_id2: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def verify_face_to_face(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        """Verify whether two faces belong to a same person.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/verify-face-to-face for
        more details.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def verify_face_to_face(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, face_id1: str = _Unset, face_id2: str = _Unset, **kwargs: Any
    ) -> _models.FaceVerificationResult:
        """Verify whether two faces belong to a same person.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/verify-face-to-face for
        more details.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id1: The faceId of one face, come from "Detect". Required.
        :paramtype face_id1: str
        :keyword face_id2: The faceId of another face, come from "Detect". Required.
        :paramtype face_id2: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceVerificationResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id1 is _Unset:
                raise TypeError("missing required argument: face_id1")
            if face_id2 is _Unset:
                raise TypeError("missing required argument: face_id2")
            body = {"faceId1": face_id1, "faceId2": face_id2}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_verify_face_to_face_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceVerificationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def group(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceGroupingResult:
        """Divide candidate faces into groups based on face similarity.

        Please refer to https://learn.microsoft.com/rest/api/face/face-recognition-operations/group for
        more details.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def group(
        self, *, face_ids: List[str], content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceGroupingResult:
        """Divide candidate faces into groups based on face similarity.

        Please refer to https://learn.microsoft.com/rest/api/face/face-recognition-operations/group for
        more details.

        :keyword face_ids: Array of candidate faceIds created by "Detect". The maximum is 1000 faces.
         Required.
        :paramtype face_ids: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceGroupingResult:
        """Divide candidate faces into groups based on face similarity.

        Please refer to https://learn.microsoft.com/rest/api/face/face-recognition-operations/group for
        more details.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def group(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, face_ids: List[str] = _Unset, **kwargs: Any
    ) -> _models.FaceGroupingResult:
        """Divide candidate faces into groups based on face similarity.

        Please refer to https://learn.microsoft.com/rest/api/face/face-recognition-operations/group for
        more details.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_ids: Array of candidate faceIds created by "Detect". The maximum is 1000 faces.
         Required.
        :paramtype face_ids: list[str]
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceGroupingResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            body = {"faceIds": face_ids}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceGroupingResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def find_similar_from_large_face_list(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        """Given query face's faceId, to search the similar-looking faces from a Large Face List. A
        'largeFaceListId' is created by Create Large Face List.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/find-similar-from-large-face-list
        for more details.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def find_similar_from_large_face_list(
        self,
        *,
        face_id: str,
        large_face_list_id: str,
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        """Given query face's faceId, to search the similar-looking faces from a Large Face List. A
        'largeFaceListId' is created by Create Large Face List.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/find-similar-from-large-face-list
        for more details.

        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword large_face_list_id: An existing user-specified unique candidate Large Face List,
         created in "Create Large Face List". Large Face List contains a set of persistedFaceIds which
         are persisted and will never expire. Required.
        :paramtype large_face_list_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def find_similar_from_large_face_list(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        """Given query face's faceId, to search the similar-looking faces from a Large Face List. A
        'largeFaceListId' is created by Create Large Face List.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/find-similar-from-large-face-list
        for more details.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def find_similar_from_large_face_list(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_id: str = _Unset,
        large_face_list_id: str = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        """Given query face's faceId, to search the similar-looking faces from a Large Face List. A
        'largeFaceListId' is created by Create Large Face List.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/find-similar-from-large-face-list
        for more details.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword large_face_list_id: An existing user-specified unique candidate Large Face List,
         created in "Create Large Face List". Large Face List contains a set of persistedFaceIds which
         are persisted and will never expire. Required.
        :paramtype large_face_list_id: str
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceFindSimilarResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if large_face_list_id is _Unset:
                raise TypeError("missing required argument: large_face_list_id")
            body = {
                "faceId": face_id,
                "largeFaceListId": large_face_list_id,
                "maxNumOfCandidatesReturned": max_num_of_candidates_returned,
                "mode": mode,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_find_similar_from_large_face_list_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceFindSimilarResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def identify_from_large_person_group(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        """1-to-many identification to find the closest matches of the specific query person face from a
        Large Person Group.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/identify-from-person-group
        for more details.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def identify_from_large_person_group(
        self,
        *,
        face_ids: List[str],
        large_person_group_id: str,
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        """1-to-many identification to find the closest matches of the specific query person face from a
        Large Person Group.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/identify-from-person-group
        for more details.

        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword large_person_group_id: largePersonGroupId of the target Large Person Group, created by
         "Create Large Person Group". Parameter personGroupId and largePersonGroupId should not be
         provided at the same time. Required.
        :paramtype large_person_group_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def identify_from_large_person_group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        """1-to-many identification to find the closest matches of the specific query person face from a
        Large Person Group.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/identify-from-person-group
        for more details.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def identify_from_large_person_group(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_ids: List[str] = _Unset,
        large_person_group_id: str = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        confidence_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> List[_models.FaceIdentificationResult]:
        """1-to-many identification to find the closest matches of the specific query person face from a
        Large Person Group.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/identify-from-person-group
        for more details.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_ids: Array of query faces faceIds, created by the "Detect". Each of the faces are
         identified independently. The valid number of faceIds is between [1, 10]. Required.
        :paramtype face_ids: list[str]
        :keyword large_person_group_id: largePersonGroupId of the target Large Person Group, created by
         "Create Large Person Group". Parameter personGroupId and largePersonGroupId should not be
         provided at the same time. Required.
        :paramtype large_person_group_id: str
        :keyword max_num_of_candidates_returned: The range of maxNumOfCandidatesReturned is between 1
         and 100. Default value is 10. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword confidence_threshold: Customized identification confidence threshold, in the range of
         [0, 1]. Advanced user can tweak this value to override default internal threshold for better
         precision on their scenario data. Note there is no guarantee of this threshold value working on
         other data and after algorithm updates. Default value is None.
        :paramtype confidence_threshold: float
        :return: list of FaceIdentificationResult
        :rtype: list[~azure.ai.vision.face.models.FaceIdentificationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceIdentificationResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            if large_person_group_id is _Unset:
                raise TypeError("missing required argument: large_person_group_id")
            body = {
                "confidenceThreshold": confidence_threshold,
                "faceIds": face_ids,
                "largePersonGroupId": large_person_group_id,
                "maxNumOfCandidatesReturned": max_num_of_candidates_returned,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_identify_from_large_person_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceIdentificationResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def verify_from_large_person_group(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        """Verify whether a face belongs to a person in a Large Person Group.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/verify-from-large-person-group
        for more details.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def verify_from_large_person_group(
        self,
        *,
        face_id: str,
        large_person_group_id: str,
        person_id: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.FaceVerificationResult:
        """Verify whether a face belongs to a person in a Large Person Group.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/verify-from-large-person-group
        for more details.

        :keyword face_id: The faceId of the face, come from "Detect". Required.
        :paramtype face_id: str
        :keyword large_person_group_id: Using existing largePersonGroupId and personId for fast loading
         a specified person. largePersonGroupId is created in "Create Large Person Group". Required.
        :paramtype large_person_group_id: str
        :keyword person_id: Specify a certain person in Large Person Group. Required.
        :paramtype person_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def verify_from_large_person_group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        """Verify whether a face belongs to a person in a Large Person Group.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/verify-from-large-person-group
        for more details.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def verify_from_large_person_group(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_id: str = _Unset,
        large_person_group_id: str = _Unset,
        person_id: str = _Unset,
        **kwargs: Any
    ) -> _models.FaceVerificationResult:
        """Verify whether a face belongs to a person in a Large Person Group.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-recognition-operations/verify-from-large-person-group
        for more details.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: The faceId of the face, come from "Detect". Required.
        :paramtype face_id: str
        :keyword large_person_group_id: Using existing largePersonGroupId and personId for fast loading
         a specified person. largePersonGroupId is created in "Create Large Person Group". Required.
        :paramtype large_person_group_id: str
        :keyword person_id: Specify a certain person in Large Person Group. Required.
        :paramtype person_id: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceVerificationResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if large_person_group_id is _Unset:
                raise TypeError("missing required argument: large_person_group_id")
            if person_id is _Unset:
                raise TypeError("missing required argument: person_id")
            body = {"faceId": face_id, "largePersonGroupId": large_person_group_id, "personId": person_id}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_verify_from_large_person_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceVerificationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class FaceSessionClientOperationsMixin(FaceSessionClientMixinABC):

    @overload
    async def create_liveness_session(
        self, body: _models.CreateLivenessSessionContent, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        """Create a new detect liveness session.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-session
        for more details.

        :param body: Body parameter. Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessSessionContent
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_liveness_session(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        """Create a new detect liveness session.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-session
        for more details.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_liveness_session(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        """Create a new detect liveness session.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-session
        for more details.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_liveness_session(
        self, body: Union[_models.CreateLivenessSessionContent, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        """Create a new detect liveness session.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-session
        for more details.

        :param body: Body parameter. Is one of the following types: CreateLivenessSessionContent, JSON,
         IO[bytes] Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessSessionContent or JSON or IO[bytes]
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreateLivenessSessionResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_session_create_liveness_session_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateLivenessSessionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_liveness_session(self, session_id: str, **kwargs: Any) -> None:
        """Delete all session related information for matching the specified session id.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/delete-liveness-session
        for more details.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_session_delete_liveness_session_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_liveness_session_result(self, session_id: str, **kwargs: Any) -> _models.LivenessSession:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-result
        for more details.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: LivenessSession. The LivenessSession is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LivenessSession
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LivenessSession] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_session_result_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LivenessSession, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_liveness_sessions(
        self, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionItem]:
        """Lists sessions for /detectLiveness/SingleModal.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-sessions for
        more details.

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionItem
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionItem]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_sessions_request(
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_liveness_session_audit_entries(
        self, session_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionAuditEntry]:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-audit-entries
        for more details.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionAuditEntry
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionAuditEntry]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionAuditEntry]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_session_audit_entries_request(
            session_id=session_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionAuditEntry], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _create_liveness_with_verify_session(
        self,
        body: _models.CreateLivenessWithVerifySessionContent,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...
    @overload
    async def _create_liveness_with_verify_session(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...
    @overload
    async def _create_liveness_with_verify_session(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...

    @distributed_trace_async
    async def _create_liveness_with_verify_session(
        self, body: Union[_models.CreateLivenessWithVerifySessionContent, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult:
        """Create a new liveness session with verify. Client device submits VerifyImage during the
        /detectLivenessWithVerify/singleModal call.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-with-verify-session
        for more details.

        :param body: Body parameter. Is one of the following types:
         CreateLivenessWithVerifySessionContent, JSON, IO[bytes] Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessWithVerifySessionContent or JSON or
         IO[bytes]
        :return: CreateLivenessWithVerifySessionResult. The CreateLivenessWithVerifySessionResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessWithVerifySessionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreateLivenessWithVerifySessionResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_session_create_liveness_with_verify_session_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateLivenessWithVerifySessionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _create_liveness_with_verify_session_with_verify_image(  # pylint: disable=name-too-long
        self, body: _models.CreateLivenessWithVerifySessionMultipartContent, **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...
    @overload
    async def _create_liveness_with_verify_session_with_verify_image(  # pylint: disable=name-too-long
        self, body: JSON, **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...

    @distributed_trace_async
    async def _create_liveness_with_verify_session_with_verify_image(  # pylint: disable=name-too-long
        self, body: Union[_models.CreateLivenessWithVerifySessionMultipartContent, JSON], **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult:
        """Create a new liveness session with verify. Provide the verify image during session creation.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-with-verify-session-with-verify-image
        for more details.

        :param body: Request content of liveness with verify session creation. Is either a
         CreateLivenessWithVerifySessionMultipartContent type or a JSON type. Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessWithVerifySessionMultipartContent or
         JSON
        :return: CreateLivenessWithVerifySessionResult. The CreateLivenessWithVerifySessionResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessWithVerifySessionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CreateLivenessWithVerifySessionResult] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _model_base.Model) else body
        _file_fields: List[str] = ["VerifyImage"]
        _data_fields: List[str] = ["Parameters"]
        _files, _data = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_face_session_create_liveness_with_verify_session_with_verify_image_request(
            files=_files,
            data=_data,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateLivenessWithVerifySessionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_liveness_with_verify_session(self, session_id: str, **kwargs: Any) -> None:
        """Delete all session related information for matching the specified session id.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/delete-liveness-with-verify-session
        for more details.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_session_delete_liveness_with_verify_session_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_liveness_with_verify_session_result(
        self, session_id: str, **kwargs: Any
    ) -> _models.LivenessWithVerifySession:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-result
        for more details.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: LivenessWithVerifySession. The LivenessWithVerifySession is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.LivenessWithVerifySession
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LivenessWithVerifySession] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_with_verify_session_result_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LivenessWithVerifySession, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_liveness_with_verify_sessions(
        self, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionItem]:
        """Lists sessions for /detectLivenessWithVerify/SingleModal.

        Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-sessions
        for more details.

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionItem
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionItem]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_with_verify_sessions_request(
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_liveness_with_verify_session_audit_entries(  # pylint: disable=name-too-long
        self, session_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionAuditEntry]:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-audit-entries
        for more details.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionAuditEntry
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionAuditEntry]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionAuditEntry]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_with_verify_session_audit_entries_request(
            session_id=session_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionAuditEntry], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def detect_from_session_image(
        self,
        body: JSON,
        *,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]:
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-detection-operations/detect-from-session-image-id
        for more details.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on
         smaller faces (64x64 pixels) and rotated face orientations. Known values are: "detection_01",
         "detection_02", and "detection_03". Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def detect_from_session_image(
        self,
        *,
        session_image_id: str,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]:
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-detection-operations/detect-from-session-image-id
        for more details.

        :keyword session_image_id: Id of session image. Required.
        :paramtype session_image_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on
         smaller faces (64x64 pixels) and rotated face orientations. Known values are: "detection_01",
         "detection_02", and "detection_03". Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def detect_from_session_image(
        self,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]:
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-detection-operations/detect-from-session-image-id
        for more details.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on
         smaller faces (64x64 pixels) and rotated face orientations. Known values are: "detection_01",
         "detection_02", and "detection_03". Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    @api_version_validation(
        method_added_on="v1.2-preview.1",
        params_added_on={
            "v1.2-preview.1": [
                "content_type",
                "detection_model",
                "recognition_model",
                "return_face_id",
                "return_face_attributes",
                "return_face_landmarks",
                "return_recognition_model",
                "face_id_time_to_live",
                "accept",
            ]
        },
    )
    async def detect_from_session_image(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        session_image_id: str = _Unset,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any
    ) -> List[_models.FaceDetectionResult]:
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        Please refer to
        https://learn.microsoft.com/rest/api/face/face-detection-operations/detect-from-session-image-id
        for more details.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword session_image_id: Id of session image. Required.
        :paramtype session_image_id: str
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on
         smaller faces (64x64 pixels) and rotated face orientations. Known values are: "detection_01",
         "detection_02", and "detection_03". Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[List[_models.FaceDetectionResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if session_image_id is _Unset:
                raise TypeError("missing required argument: session_image_id")
            body = {"sessionImageId": session_image_id}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_session_detect_from_session_image_request(
            detection_model=detection_model,
            recognition_model=recognition_model,
            return_face_id=return_face_id,
            return_face_attributes=return_face_attributes,
            return_face_landmarks=return_face_landmarks,
            return_recognition_model=return_recognition_model,
            face_id_time_to_live=face_id_time_to_live,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceDetectionResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    @api_version_validation(
        method_added_on="v1.2-preview.1",
        params_added_on={"v1.2-preview.1": ["session_image_id", "accept"]},
    )
    async def get_session_image(self, session_image_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        """Please refer to
        https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-session-image for
        more details.

        :param session_image_id: The request ID of the image to be retrieved. Required.
        :type session_image_id: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_face_session_get_session_image_request(
            session_image_id=session_image_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
