# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models as _models
from ._configuration import WorkloadsClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    MonitorsOperations,
    Operations,
    PhpWorkloadsOperations,
    ProviderInstancesOperations,
    SAPApplicationServerInstancesOperations,
    SAPCentralInstancesOperations,
    SAPDatabaseInstancesOperations,
    SAPVirtualInstancesOperations,
    SkusOperations,
    WordpressInstancesOperations,
    WorkloadsClientOperationsMixin,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class WorkloadsClient(
    WorkloadsClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Workloads client provides access to various workload operations.

    :ivar php_workloads: PhpWorkloadsOperations operations
    :vartype php_workloads: azure.mgmt.workloads.operations.PhpWorkloadsOperations
    :ivar wordpress_instances: WordpressInstancesOperations operations
    :vartype wordpress_instances: azure.mgmt.workloads.operations.WordpressInstancesOperations
    :ivar sap_virtual_instances: SAPVirtualInstancesOperations operations
    :vartype sap_virtual_instances: azure.mgmt.workloads.operations.SAPVirtualInstancesOperations
    :ivar sap_central_instances: SAPCentralInstancesOperations operations
    :vartype sap_central_instances: azure.mgmt.workloads.operations.SAPCentralInstancesOperations
    :ivar sap_database_instances: SAPDatabaseInstancesOperations operations
    :vartype sap_database_instances: azure.mgmt.workloads.operations.SAPDatabaseInstancesOperations
    :ivar sap_application_server_instances: SAPApplicationServerInstancesOperations operations
    :vartype sap_application_server_instances:
     azure.mgmt.workloads.operations.SAPApplicationServerInstancesOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.workloads.operations.Operations
    :ivar monitors: MonitorsOperations operations
    :vartype monitors: azure.mgmt.workloads.operations.MonitorsOperations
    :ivar provider_instances: ProviderInstancesOperations operations
    :vartype provider_instances: azure.mgmt.workloads.operations.ProviderInstancesOperations
    :ivar skus: SkusOperations operations
    :vartype skus: azure.mgmt.workloads.operations.SkusOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2021-12-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = WorkloadsClientConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.php_workloads = PhpWorkloadsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.wordpress_instances = WordpressInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sap_virtual_instances = SAPVirtualInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sap_central_instances = SAPCentralInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sap_database_instances = SAPDatabaseInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sap_application_server_instances = SAPApplicationServerInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.monitors = MonitorsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.provider_instances = ProviderInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.skus = SkusOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "WorkloadsClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details) -> None:
        self._client.__exit__(*exc_details)
