# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, AsyncIterable, Callable, Dict, Optional, TypeVar

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._diagnostics_operations import build_execute_site_analysis_request, build_execute_site_analysis_slot_request, build_execute_site_detector_request, build_execute_site_detector_slot_request, build_get_hosting_environment_detector_response_request, build_get_site_analysis_request, build_get_site_analysis_slot_request, build_get_site_detector_request, build_get_site_detector_response_request, build_get_site_detector_response_slot_request, build_get_site_detector_slot_request, build_get_site_diagnostic_category_request, build_get_site_diagnostic_category_slot_request, build_list_hosting_environment_detector_responses_request, build_list_site_analyses_request, build_list_site_analyses_slot_request, build_list_site_detector_responses_request, build_list_site_detector_responses_slot_request, build_list_site_detectors_request, build_list_site_detectors_slot_request, build_list_site_diagnostic_categories_request, build_list_site_diagnostic_categories_slot_request
from .._vendor import MixinABC
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class DiagnosticsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.web.v2016_03_01.aio.WebSiteManagementClient`'s
        :attr:`diagnostics` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace
    def list_hosting_environment_detector_responses(
        self,
        resource_group_name: str,
        name: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DetectorResponseCollection]:
        """List Hosting Environment Detector Responses.

        List Hosting Environment Detector Responses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param name: Site Name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DetectorResponseCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DetectorResponseCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DetectorResponseCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_hosting_environment_detector_responses_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_hosting_environment_detector_responses.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_hosting_environment_detector_responses_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DetectorResponseCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_hosting_environment_detector_responses.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors"}  # type: ignore

    @distributed_trace_async
    async def get_hosting_environment_detector_response(
        self,
        resource_group_name: str,
        name: str,
        detector_name: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> _models.DetectorResponse:
        """Get Hosting Environment Detector Response.

        Get Hosting Environment Detector Response.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param name: App Service Environment Name.
        :type name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param start_time: Start Time. Default value is None.
        :type start_time: ~datetime.datetime
        :param end_time: End Time. Default value is None.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain. Default value is None.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DetectorResponse]

        
        request = build_get_hosting_environment_detector_response_request(
            resource_group_name=resource_group_name,
            name=name,
            detector_name=detector_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.get_hosting_environment_detector_response.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_hosting_environment_detector_response.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors/{detectorName}"}  # type: ignore


    @distributed_trace
    def list_site_detector_responses(
        self,
        resource_group_name: str,
        site_name: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DetectorResponseCollection]:
        """List Site Detector Responses.

        List Site Detector Responses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DetectorResponseCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DetectorResponseCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DetectorResponseCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_detector_responses_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_detector_responses.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_site_detector_responses_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DetectorResponseCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_detector_responses.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors"}  # type: ignore

    @distributed_trace_async
    async def get_site_detector_response(
        self,
        resource_group_name: str,
        site_name: str,
        detector_name: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> _models.DetectorResponse:
        """Get site detector response.

        Get site detector response.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param start_time: Start Time. Default value is None.
        :type start_time: ~datetime.datetime
        :param end_time: End Time. Default value is None.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain. Default value is None.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DetectorResponse]

        
        request = build_get_site_detector_response_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            detector_name=detector_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.get_site_detector_response.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_detector_response.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors/{detectorName}"}  # type: ignore


    @distributed_trace
    def list_site_diagnostic_categories(
        self,
        resource_group_name: str,
        site_name: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DiagnosticCategoryCollection]:
        """Get Diagnostics Categories.

        Get Diagnostics Categories.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticCategoryCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DiagnosticCategoryCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticCategoryCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_diagnostic_categories_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_diagnostic_categories.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_site_diagnostic_categories_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticCategoryCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_diagnostic_categories.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics"}  # type: ignore

    @distributed_trace_async
    async def get_site_diagnostic_category(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        **kwargs: Any
    ) -> _models.DiagnosticCategory:
        """Get Diagnostics Category.

        Get Diagnostics Category.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticCategory, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DiagnosticCategory
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticCategory]

        
        request = build_get_site_diagnostic_category_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_site_diagnostic_category.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticCategory', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_diagnostic_category.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}"}  # type: ignore


    @distributed_trace
    def list_site_analyses(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DiagnosticAnalysisCollection]:
        """Get Site Analyses.

        Get Site Analyses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticAnalysisCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DiagnosticAnalysisCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticAnalysisCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_analyses_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_analyses.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_site_analyses_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticAnalysisCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_analyses.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses"}  # type: ignore

    @distributed_trace_async
    async def get_site_analysis(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        analysis_name: str,
        **kwargs: Any
    ) -> _models.DiagnosticAnalysis:
        """Get Site Analysis.

        Get Site Analysis.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param analysis_name: Analysis Name.
        :type analysis_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticAnalysis, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DiagnosticAnalysis
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticAnalysis]

        
        request = build_get_site_analysis_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            analysis_name=analysis_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_site_analysis.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticAnalysis', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_analysis.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}"}  # type: ignore


    @distributed_trace_async
    async def execute_site_analysis(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        analysis_name: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> _models.DiagnosticAnalysis:
        """Execute Analysis.

        Execute Analysis.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Category Name.
        :type diagnostic_category: str
        :param analysis_name: Analysis Resource Name.
        :type analysis_name: str
        :param start_time: Start Time. Default value is None.
        :type start_time: ~datetime.datetime
        :param end_time: End Time. Default value is None.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain. Default value is None.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticAnalysis, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DiagnosticAnalysis
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticAnalysis]

        
        request = build_execute_site_analysis_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            analysis_name=analysis_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.execute_site_analysis.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticAnalysis', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    execute_site_analysis.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute"}  # type: ignore


    @distributed_trace
    def list_site_detectors(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DiagnosticDetectorCollection]:
        """Get Detectors.

        Get Detectors.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticDetectorCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DiagnosticDetectorCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticDetectorCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_detectors_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_detectors.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_site_detectors_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticDetectorCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_detectors.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors"}  # type: ignore

    @distributed_trace
    def get_site_detector(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        detector_name: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DiagnosticDetectorCollection]:
        """Get Detector.

        Get Detector.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param detector_name: Detector Name.
        :type detector_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticDetectorCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DiagnosticDetectorCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticDetectorCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_get_site_detector_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    detector_name=detector_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_site_detector.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_get_site_detector_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    detector_name=detector_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticDetectorCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    get_site_detector.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}"}  # type: ignore

    @distributed_trace_async
    async def execute_site_detector(
        self,
        resource_group_name: str,
        site_name: str,
        detector_name: str,
        diagnostic_category: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> _models.DiagnosticDetectorResponse:
        """Execute Detector.

        Execute Detector.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param diagnostic_category: Category Name.
        :type diagnostic_category: str
        :param start_time: Start Time. Default value is None.
        :type start_time: ~datetime.datetime
        :param end_time: End Time. Default value is None.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain. Default value is None.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticDetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DiagnosticDetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticDetectorResponse]

        
        request = build_execute_site_detector_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            detector_name=detector_name,
            diagnostic_category=diagnostic_category,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.execute_site_detector.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticDetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    execute_site_detector.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute"}  # type: ignore


    @distributed_trace
    def list_site_detector_responses_slot(
        self,
        resource_group_name: str,
        site_name: str,
        slot: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DetectorResponseCollection]:
        """List Site Detector Responses.

        List Site Detector Responses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DetectorResponseCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DetectorResponseCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DetectorResponseCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_detector_responses_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_detector_responses_slot.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_site_detector_responses_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DetectorResponseCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_detector_responses_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors"}  # type: ignore

    @distributed_trace_async
    async def get_site_detector_response_slot(
        self,
        resource_group_name: str,
        site_name: str,
        detector_name: str,
        slot: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> _models.DetectorResponse:
        """Get site detector response.

        Get site detector response.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param slot: Slot Name.
        :type slot: str
        :param start_time: Start Time. Default value is None.
        :type start_time: ~datetime.datetime
        :param end_time: End Time. Default value is None.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain. Default value is None.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DetectorResponse]

        
        request = build_get_site_detector_response_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            detector_name=detector_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.get_site_detector_response_slot.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_detector_response_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors/{detectorName}"}  # type: ignore


    @distributed_trace
    def list_site_diagnostic_categories_slot(
        self,
        resource_group_name: str,
        site_name: str,
        slot: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DiagnosticCategoryCollection]:
        """Get Diagnostics Categories.

        Get Diagnostics Categories.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticCategoryCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DiagnosticCategoryCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticCategoryCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_diagnostic_categories_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_diagnostic_categories_slot.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_site_diagnostic_categories_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticCategoryCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_diagnostic_categories_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics"}  # type: ignore

    @distributed_trace_async
    async def get_site_diagnostic_category_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        slot: str,
        **kwargs: Any
    ) -> _models.DiagnosticCategory:
        """Get Diagnostics Category.

        Get Diagnostics Category.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticCategory, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DiagnosticCategory
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticCategory]

        
        request = build_get_site_diagnostic_category_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_site_diagnostic_category_slot.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticCategory', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_diagnostic_category_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}"}  # type: ignore


    @distributed_trace
    def list_site_analyses_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        slot: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DiagnosticAnalysisCollection]:
        """Get Site Analyses.

        Get Site Analyses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticAnalysisCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DiagnosticAnalysisCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticAnalysisCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_analyses_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_analyses_slot.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_site_analyses_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticAnalysisCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_analyses_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses"}  # type: ignore

    @distributed_trace_async
    async def get_site_analysis_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        analysis_name: str,
        slot: str,
        **kwargs: Any
    ) -> _models.DiagnosticAnalysis:
        """Get Site Analysis.

        Get Site Analysis.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param analysis_name: Analysis Name.
        :type analysis_name: str
        :param slot: Slot - optional.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticAnalysis, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DiagnosticAnalysis
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticAnalysis]

        
        request = build_get_site_analysis_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            analysis_name=analysis_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_site_analysis_slot.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticAnalysis', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_analysis_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}"}  # type: ignore


    @distributed_trace_async
    async def execute_site_analysis_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        analysis_name: str,
        slot: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> _models.DiagnosticAnalysis:
        """Execute Analysis.

        Execute Analysis.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Category Name.
        :type diagnostic_category: str
        :param analysis_name: Analysis Resource Name.
        :type analysis_name: str
        :param slot: Slot Name.
        :type slot: str
        :param start_time: Start Time. Default value is None.
        :type start_time: ~datetime.datetime
        :param end_time: End Time. Default value is None.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain. Default value is None.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticAnalysis, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DiagnosticAnalysis
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticAnalysis]

        
        request = build_execute_site_analysis_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            analysis_name=analysis_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.execute_site_analysis_slot.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticAnalysis', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    execute_site_analysis_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute"}  # type: ignore


    @distributed_trace
    def list_site_detectors_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        slot: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DiagnosticDetectorCollection]:
        """Get Detectors.

        Get Detectors.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticDetectorCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DiagnosticDetectorCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticDetectorCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_detectors_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_detectors_slot.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_site_detectors_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticDetectorCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_detectors_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors"}  # type: ignore

    @distributed_trace
    def get_site_detector_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        detector_name: str,
        slot: str,
        **kwargs: Any
    ) -> AsyncIterable[_models.DiagnosticDetectorCollection]:
        """Get Detector.

        Get Detector.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param detector_name: Detector Name.
        :type detector_name: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticDetectorCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2016_03_01.models.DiagnosticDetectorCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticDetectorCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_get_site_detector_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    detector_name=detector_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_site_detector_slot.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_get_site_detector_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    detector_name=detector_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticDetectorCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    get_site_detector_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}"}  # type: ignore

    @distributed_trace_async
    async def execute_site_detector_slot(
        self,
        resource_group_name: str,
        site_name: str,
        detector_name: str,
        diagnostic_category: str,
        slot: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> _models.DiagnosticDetectorResponse:
        """Execute Detector.

        Execute Detector.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param diagnostic_category: Category Name.
        :type diagnostic_category: str
        :param slot: Slot Name.
        :type slot: str
        :param start_time: Start Time. Default value is None.
        :type start_time: ~datetime.datetime
        :param end_time: End Time. Default value is None.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain. Default value is None.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticDetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2016_03_01.models.DiagnosticDetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2016-03-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.DiagnosticDetectorResponse]

        
        request = build_execute_site_detector_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            detector_name=detector_name,
            diagnostic_category=diagnostic_category,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.execute_site_detector_slot.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticDetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    execute_site_detector_slot.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute"}  # type: ignore

