# Changelog

## v0.9.0 (2025-01-29)

### Features

- Add force parameter (#224) ([`5d3ab4f`](https://github.com/chemelli74/aiovodafone/commit/5d3ab4ff71de999f5fdca9c27ae9108b79a8b168))


### Build system

- Bump python-semantic-release/python-semantic-release from 9.16.1 to 9.17.0 (#221) ([`3295597`](https://github.com/chemelli74/aiovodafone/commit/3295597a97ee67449967bfea401babdfe99f34f6))
- Bump wagoid/commitlint-github-action from 6.2.0 to 6.2.1 (#219) ([`97cb66a`](https://github.com/chemelli74/aiovodafone/commit/97cb66a0d98ad594e51c5c46e1247fb85f4afb0c))
- Bump python-semantic-release/python-semantic-release from 9.15.2 to 9.16.1 (#218) ([`61c9750`](https://github.com/chemelli74/aiovodafone/commit/61c9750e3767163ddeb871cb362c9d07c683e367))


## v0.8.2 (2024-12-24)

### Bug fixes

- Fixed missing voice data for output (#209) ([`9ff4707`](https://github.com/chemelli74/aiovodafone/commit/9ff470705caa5692675ad94d76e70f8fb4c102bd))


### Code style

- Reorderd methods in api to have same listing as definition order of abstract class (#203) ([`2438038`](https://github.com/chemelli74/aiovodafone/commit/2438038b446b40fbc224bd13845a1d76a2b5b3a8))


### Build system

- Bump aiohttp from 3.11.10 to 3.11.11 (#213) ([`5a50dbc`](https://github.com/chemelli74/aiovodafone/commit/5a50dbc7cd58e61e84d74235214d24e7f0d6a4c0))


## v0.8.1 (2024-12-18)

### Bug fixes

- Optimize logging with ruff g004 (#211) ([`17cf4a2`](https://github.com/chemelli74/aiovodafone/commit/17cf4a23f9a899ec8481107737fa4b311e89f0f0))


### Build system

- Cleanup old settings (#210) ([`e4e7b8f`](https://github.com/chemelli74/aiovodafone/commit/e4e7b8f6b6079d110e4b34c7d5d926b53bb6d605))


## v0.8.0 (2024-12-17)

### Features

- Added docis and voice information for technicolor modems (#180) ([`bf769ad`](https://github.com/chemelli74/aiovodafone/commit/bf769adf1366f340d8516231ec93be3f8d0099b3))


### Build system

- Bump python-semantic-release/python-semantic-release from 9.15.1 to 9.15.2 (#208) ([`175b8fd`](https://github.com/chemelli74/aiovodafone/commit/175b8fd72738bcfad6354662d2a0e1ada2dfed23))
- Bump wagoid/commitlint-github-action from 6.1.2 to 6.2.0 (#207) ([`3be1313`](https://github.com/chemelli74/aiovodafone/commit/3be1313d722a47e6b6c2261c2409ebe372f9123a))
- Install poetry by default (#199) ([`f178a30`](https://github.com/chemelli74/aiovodafone/commit/f178a30253b654da929627dd0f4b131885240976))
- Fix checkout for remote branches (#198) ([`be89b7e`](https://github.com/chemelli74/aiovodafone/commit/be89b7e83301272007200fd5f98f56d991dc3bb5))
- Bump aiohttp from 3.11.9 to 3.11.10 (#196) ([`c4952c5`](https://github.com/chemelli74/aiovodafone/commit/c4952c5321f9fca1239a2f801f0a639887bd5a6c))
- Bump python-semantic-release/python-semantic-release from 9.15.0 to 9.15.1 (#195) ([`5d10748`](https://github.com/chemelli74/aiovodafone/commit/5d10748224b03b7cecbc088da0b71da088397e4a))
- Bump python-semantic-release/python-semantic-release (#193) ([`6d8bd78`](https://github.com/chemelli74/aiovodafone/commit/6d8bd78e6772e364a38aaf6ddc20cd86b7c66a61))
- Bump aiohttp from 3.11.7 to 3.11.9 (#192) ([`f283c37`](https://github.com/chemelli74/aiovodafone/commit/f283c37352d3cf9e77dd1b0ac52417027610e221))
- Bump pytest from 8.3.3 to 8.3.4 (#191) ([`49e9a2d`](https://github.com/chemelli74/aiovodafone/commit/49e9a2d9516ea6e79ab756029356722dbc6b7348))
- Bump aiohttp from 3.11.2 to 3.11.7 (#189) ([`ec5c0c4`](https://github.com/chemelli74/aiovodafone/commit/ec5c0c42b0b13560055b672d4500af6179be5cdc))
- Bump aiohttp from 3.10.10 to 3.11.2 (#187) ([`17f796c`](https://github.com/chemelli74/aiovodafone/commit/17f796ca51b18cf31d334f376bb2a3c11266da9d))
- Bump codecov/codecov-action from 4 to 5 (#186) ([`41c7400`](https://github.com/chemelli74/aiovodafone/commit/41c7400e971699bbc1d640e1eaea8a82ea57807d))
- Bump python-semantic-release/python-semantic-release (#185) ([`d180b2f`](https://github.com/chemelli74/aiovodafone/commit/d180b2fc83d78e6897610745203396068dbc2617))
- Bump python-semantic-release/python-semantic-release (#183) ([`dde42a7`](https://github.com/chemelli74/aiovodafone/commit/dde42a7af6a1dc3b4ae7d3b66637113effc7c456))
- Bump python-semantic-release/python-semantic-release (#182) ([`94dcfa4`](https://github.com/chemelli74/aiovodafone/commit/94dcfa45332ae1833dd3bea1eff8c016ef3842e1))
- Bump pytest-cov from 5.0.0 to 6.0.0 (#179) ([`9a62529`](https://github.com/chemelli74/aiovodafone/commit/9a62529d66f5be5c524be0265e2b4cb4dff35d08))


### Testing

- Cleanup .coveragerc (#178) ([`48d08fa`](https://github.com/chemelli74/aiovodafone/commit/48d08fa726bef4b2e8a1921f6b04383c8c9f2c12))


## v0.7.1 (2024-11-01)

### Bug fixes

- Fix license classifier (#177) ([`4e15884`](https://github.com/chemelli74/aiovodafone/commit/4e15884397fd9714c3d7599d74f289b51dfc1c2d))


## v0.7.0 (2024-11-01)

### Build system

- Revert to standard semantic release (#176) ([`a46a8aa`](https://github.com/chemelli74/aiovodafone/commit/a46a8aa4af33e20367d87c79aff66c72b0acfdf2))
- Add python 3.13 ([`059e38d`](https://github.com/chemelli74/aiovodafone/commit/059e38d16493bf62b1563d1f5d62f9b54021d5a7))
- Bump aiohttp from 3.10.9 to 3.10.10 ([`557c2d1`](https://github.com/chemelli74/aiovodafone/commit/557c2d13e511900ad9248ec48cad4f8df4096345))
- Migrate-config ([`f37b283`](https://github.com/chemelli74/aiovodafone/commit/f37b283c02db4983608ef37ca2200274edcf3d0a))
- Add commitlint to pre-commit ([`c7d770e`](https://github.com/chemelli74/aiovodafone/commit/c7d770e45535f16d9896c50c2a37addc289198ab))
- Bump aiohttp from 3.10.8 to 3.10.9 ([`a1e2e5e`](https://github.com/chemelli74/aiovodafone/commit/a1e2e5ea82ba360b8d6168d27de6d65f9ea84ce6))
- Bump aiohttp from 3.10.5 to 3.10.8 ([`c34f60b`](https://github.com/chemelli74/aiovodafone/commit/c34f60be76e0bb14a5091f9005b5ac89c1c67cb2))
- Bump pytest from 8.3.2 to 8.3.3 ([`6d29f90`](https://github.com/chemelli74/aiovodafone/commit/6d29f900e745dd74870be6e5b858629bffef4c98))
- Bump tiangolo/issue-manager from 0.5.0 to 0.5.1 ([`f08774d`](https://github.com/chemelli74/aiovodafone/commit/f08774d27f5fc02d90315bed3f673bc26ae5d329))
- Bump wagoid/commitlint-github-action from 6.1.1 to 6.1.2 ([`61d8d4b`](https://github.com/chemelli74/aiovodafone/commit/61d8d4b740579287d37c0bbf700827592d5c365e))
- Bump aiohttp from 3.10.4 to 3.10.5 ([`dacf0b3`](https://github.com/chemelli74/aiovodafone/commit/dacf0b302e4f190f114824b17bbd3bf64025596b))
- Bump wagoid/commitlint-github-action from 6.1.0 to 6.1.1 ([`6958b62`](https://github.com/chemelli74/aiovodafone/commit/6958b62bde7113e99a7a918b7609e6fb0f9b808d))
- Bump wagoid/commitlint-github-action from 6.0.2 to 6.1.0 ([`cd5cd8d`](https://github.com/chemelli74/aiovodafone/commit/cd5cd8d34ce3e9a347bb9a2b39b4aa13e18b4f27))
- Bump aiohttp from 3.10.2 to 3.10.4 ([`b806614`](https://github.com/chemelli74/aiovodafone/commit/b8066144a3be8b912dd99fbf71e56a0843d8bf2a))
- Bump aiohttp from 3.10.1 to 3.10.2 ([`e3b717f`](https://github.com/chemelli74/aiovodafone/commit/e3b717fb0c05c22eea26d0861a4c180aab70f54f))
- Bump wagoid/commitlint-github-action from 6.0.1 to 6.0.2 ([`4c25727`](https://github.com/chemelli74/aiovodafone/commit/4c25727e246789a5f53f524e393c810f9694fd74))
- Bump aiohttp from 3.9.5 to 3.10.1 ([`8cb2514`](https://github.com/chemelli74/aiovodafone/commit/8cb2514b5c36c12f26343ae8c397a80ae8187473))
- Bump snok/install-poetry from 1.4.0 to 1.4.1 ([`439108d`](https://github.com/chemelli74/aiovodafone/commit/439108d696e7ccd5fe5c535fc6a8c40e1761c6e1))
- Bump snok/install-poetry from 1.3.4 to 1.4.0 ([`ae04590`](https://github.com/chemelli74/aiovodafone/commit/ae045906c0bc6ca9339cb3ad9119536158a348e0))
- Bump pytest from 8.3.1 to 8.3.2 ([`2f8253b`](https://github.com/chemelli74/aiovodafone/commit/2f8253ba0db0743e2268f9e1cf40499a6a9164b2))
- Bump pytest from 8.2.2 to 8.3.1 ([`db98fb2`](https://github.com/chemelli74/aiovodafone/commit/db98fb28b13b5899565a21828b2ef4fee967c5aa))


### Features

- Drop python 3.11 support (#175) ([`b4b1fe7`](https://github.com/chemelli74/aiovodafone/commit/b4b1fe7207defadbf5bcf5c0753542fdd45756a2))


### Unknown

## v0.6.1 (2024-06-24)

### Bug fixes

- Fix license classifier (#131) ([`f929cfc`](https://github.com/chemelli74/aiovodafone/commit/f929cfc8e62610953bd20780eafe9023a5e86647))


### Unknown

### Build system

- Bump pytest from 8.2.1 to 8.2.2 ([`849cafc`](https://github.com/chemelli74/aiovodafone/commit/849cafc9230aa38f6b67544e4db0b952b3b32302))
- Bump pytest from 8.2.0 to 8.2.1 ([`eff402e`](https://github.com/chemelli74/aiovodafone/commit/eff402ef05f0cc298a18df197f686e4b8a523917))
- Bump pytest from 8.1.1 to 8.2.0 ([`12cebbb`](https://github.com/chemelli74/aiovodafone/commit/12cebbb29730ebf6a470052fdba30c5b87ad8aa3))


## v0.6.0 (2024-04-28)

### Unknown

### Features

- Support for vodafone sercomm h300s ([`4608915`](https://github.com/chemelli74/aiovodafone/commit/46089158bdfb49c69770a08da2c9756b11619fb2))


### Build system

- Minor updates ([`d4c3202`](https://github.com/chemelli74/aiovodafone/commit/d4c3202b50c56cc231ef624a3289a5f8fec84f2d))
- Bump aiohttp from 3.9.4 to 3.9.5 ([`e0c159c`](https://github.com/chemelli74/aiovodafone/commit/e0c159ca9aa0f70baa25f56f549e6439d2e5ba1c))
- Update cfg for v6 (breakingchange) ([`17e8a3b`](https://github.com/chemelli74/aiovodafone/commit/17e8a3b223e95aa4792885a12a2b81212e9c0719))
- Bump wagoid/commitlint-github-action from 5.4.5 to 6.0.1 ([`315494f`](https://github.com/chemelli74/aiovodafone/commit/315494f42b8fca9535594752d03784e4be86787f))
- Bump aiohttp from 3.9.3 to 3.9.4 ([`09e1948`](https://github.com/chemelli74/aiovodafone/commit/09e1948338badc0d6e7013272ce41bf354f24ddb))
- Bump idna from 3.6 to 3.7 ([`694377d`](https://github.com/chemelli74/aiovodafone/commit/694377d7a46f69f176058f29ca243653bbc7ddb1))
- Typo ([`52ea33f`](https://github.com/chemelli74/aiovodafone/commit/52ea33f462bc4096a610d54bc44698579a59dd67))
- Cleanup ([`a46f537`](https://github.com/chemelli74/aiovodafone/commit/a46f5370bfe977165d8397b76d59a4db88f034f8))
- Use ruff instead of isort, black, flake8, bandit and some pre-commit-hooks ([`10a7e43`](https://github.com/chemelli74/aiovodafone/commit/10a7e4311e8a1413d4a849a9eb3783a2e5e90d45))
- Bump pytest-cov from 4.1.0 to 5.0.0 ([`0f9133f`](https://github.com/chemelli74/aiovodafone/commit/0f9133f8a20de7e52778f0ae9c02b06ddd64b10f))
- Bump pytest from 8.0.2 to 8.1.0 ([`a0cb189`](https://github.com/chemelli74/aiovodafone/commit/a0cb189dfd8bdd151ecf921d5e8ed4896e638f02))
- Bump pytest from 8.0.1 to 8.0.2 ([`322ac34`](https://github.com/chemelli74/aiovodafone/commit/322ac3422f9adb95020859853f5835dd6654896d))
- Format devcontainer.json ([`dfa1359`](https://github.com/chemelli74/aiovodafone/commit/dfa135918a24dd73db702c51794852154cd0d03d))
- Bump pytest from 8.0.0 to 8.0.1 ([`7f46bb6`](https://github.com/chemelli74/aiovodafone/commit/7f46bb69d4bb6432a50cdd08cdb34b107c33016a))
- Bump pre-commit/action from 3.0.0 to 3.0.1 ([`7b75833`](https://github.com/chemelli74/aiovodafone/commit/7b75833ddfb1ac659cc6b4a8fa443b56ed20b8d2))
- Bump aiohttp from 3.9.2 to 3.9.3 ([`57cac7e`](https://github.com/chemelli74/aiovodafone/commit/57cac7e5ef6b18b0ce81e6917717e49634c6145d))
- Revert config change for actions/checkout@v4 ([`dab728a`](https://github.com/chemelli74/aiovodafone/commit/dab728a7795c11eb772cb3db4c0ced18465a0337))
- Bump tiangolo/issue-manager from 0.4.1 to 0.5.0 ([`e8f3a7a`](https://github.com/chemelli74/aiovodafone/commit/e8f3a7ab4374dfa5daf97fa58bc3c3963f516c2d))
- Bump pytest from 7.4.4 to 8.0.0 ([`47d0af7`](https://github.com/chemelli74/aiovodafone/commit/47d0af7e479adf253992984f6b4bfdcd8a276d4c))
- Bump aiohttp from 3.9.1 to 3.9.2 ([`f83e584`](https://github.com/chemelli74/aiovodafone/commit/f83e5846be37fb6d85ca6f1c3bb7ce2fbb5e22a3))


### Refactoring

- Short parameter for config file -cf instead of -f ([`c354354`](https://github.com/chemelli74/aiovodafone/commit/c354354e41825ca2e66eac7accbb5bbe31fa4e2c))
- Make library_test.py accept json config file ([`79956dd`](https://github.com/chemelli74/aiovodafone/commit/79956dd93ce4d0778573abf19a280f8760e9cabb))


## v0.5.4 (2024-01-21)

### Unknown

### Bug fixes

- Check logged-in before resatrt connection/router ([`ea994a9`](https://github.com/chemelli74/aiovodafone/commit/ea994a9485312c3c1da13a75b2bd4023937e7629))


## v0.5.3 (2024-01-20)

### Unknown

### Bug fixes

- Improve logging ([`782537e`](https://github.com/chemelli74/aiovodafone/commit/782537e50d7aef9cc4e287f6e9bcc88fea2691f1))


## v0.5.2 (2024-01-20)

### Unknown

### Build system

- Use fork to force python 3.11 ([`33a3568`](https://github.com/chemelli74/aiovodafone/commit/33a35684b6cbd94b0a757037087b6e1f120e410d))
- Update semantic-release to 8.x ([`796b801`](https://github.com/chemelli74/aiovodafone/commit/796b80165fc72e5d800d08c36d8b939e122d8fcc))
- Switch ci to python 3.11 ([`aae08b5`](https://github.com/chemelli74/aiovodafone/commit/aae08b5ca6c91568b539a31312767b32dba78925))
- Bump wagoid/commitlint-github-action from 5.4.4 to 5.4.5 ([`29a4999`](https://github.com/chemelli74/aiovodafone/commit/29a4999b986fac9fc2125039279887e64705acb2))
- Bump tiangolo/issue-manager from 0.4.0 to 0.4.1 ([`ab21128`](https://github.com/chemelli74/aiovodafone/commit/ab211287db8780f5f2b5c6e49fb694b1d51bfee7))
- Bump pytest from 7.4.3 to 7.4.4 ([`def2731`](https://github.com/chemelli74/aiovodafone/commit/def27311670d94c860dcb127f153f01c9693c2c4))
- Bump actions/setup-python from 4 to 5 ([`daced71`](https://github.com/chemelli74/aiovodafone/commit/daced711768df207a0802ab41029b0f05d0b3c54))


### Bug fixes

- Various fixes for get_device_type ([`ec8f01f`](https://github.com/chemelli74/aiovodafone/commit/ec8f01fc4be5ea22927b985f8148002b11419e85))


## v0.5.1 (2023-12-03)

### Unknown

### Bug fixes

- Interpret connected state correctly ([`686e19a`](https://github.com/chemelli74/aiovodafone/commit/686e19a70ce31cbec55f809eb48f6a2bceef5ff7))


## v0.5.0 (2023-12-03)

### Unknown

### Documentation

- Explain why code lookup is needed for sercomm devices ([`b137975`](https://github.com/chemelli74/aiovodafone/commit/b137975610697db46094f19c465b7f8ec07aa7fd))


### Features

- Add specific check for sercom csrf token ([`a8f1780`](https://github.com/chemelli74/aiovodafone/commit/a8f178012ec5e1679cdb44ba080cee64ad27fa23))
- Device detection, consider none as result ([`bb5204a`](https://github.com/chemelli74/aiovodafone/commit/bb5204ab1808b40b268f0c75c272a96c5f31281d))
- Require aiohttp.clientsession to determine device type ([`cdb4637`](https://github.com/chemelli74/aiovodafone/commit/cdb46375d3c04b50dfb01c18ab82f1dc70607048))
- Add additional detection for sercomm devices ([`6a3f4c0`](https://github.com/chemelli74/aiovodafone/commit/6a3f4c03af738705c8181a0126bf891527bd66fa))
- Add method to determine a device type ([`eb4f9c5`](https://github.com/chemelli74/aiovodafone/commit/eb4f9c50f1bd78c8b05fbadcf7bf0cc6b5ea529b))


### Refactoring

- Remove device type argument ([`36978a1`](https://github.com/chemelli74/aiovodafone/commit/36978a14754aeae65e4f99ceb3490e5500dd1f2c))
- Add staticmethod decorator, line breaks ([`92cb428`](https://github.com/chemelli74/aiovodafone/commit/92cb4284825a1c4fb64941856bb246e9e81d6f81))


## v0.4.3 (2023-11-28)

### Unknown

### Bug fixes

- Recreate closed aiohttp session ([`a2ec07b`](https://github.com/chemelli74/aiovodafone/commit/a2ec07b150118a64323e82a0d17b079603b73a03))


### Build system

- Bump aiohttp from 3.8.6 to 3.9.0 ([`3155d11`](https://github.com/chemelli74/aiovodafone/commit/3155d11f9336aa4cd1fd0f67f49eccd05e8f02e7))
- Bump wagoid/commitlint-github-action from 5.4.3 to 5.4.4 ([`96c7b3b`](https://github.com/chemelli74/aiovodafone/commit/96c7b3b3985ef05df784789f515e620be7628042))
- Bump pytest from 7.4.2 to 7.4.3 ([`f02a0c9`](https://github.com/chemelli74/aiovodafone/commit/f02a0c9c850e91c9f9a6e6f4e8cb1194fe861449))


## v0.4.2 (2023-10-26)

### Unknown

### Bug fixes

- Improve failed login handling ([`c39ffd1`](https://github.com/chemelli74/aiovodafone/commit/c39ffd1439dd7d5008945fcb5946e96402429239))


## v0.4.1 (2023-10-17)

### Unknown

### Refactoring

- Update library_test ([`f2abc82`](https://github.com/chemelli74/aiovodafone/commit/f2abc82812ca007a83d1e6576f065b7733dc166e))


### Bug fixes

- Add timezone to convert_uptime functions ([`d37cdbd`](https://github.com/chemelli74/aiovodafone/commit/d37cdbdca87955d4e0872aad69dd7f98351bcf91))


## v0.4.0 (2023-10-16)

### Unknown

### Refactoring

- Inline page urls and extract login message ([`d53faa9`](https://github.com/chemelli74/aiovodafone/commit/d53faa94c698cb2e771044218a7dd2d318e6d9db))
- Use one set of header for all types of stations ([`18c2633`](https://github.com/chemelli74/aiovodafone/commit/18c2633f25328cfcb440125cb37479bf7a35db02))


### Bug fixes

- Add abstract method for convert_uptime ([`9a2bc9d`](https://github.com/chemelli74/aiovodafone/commit/9a2bc9d2105e39bf390f2101bafdb7a758e4498e))


### Features

- Add device type for technicolor devices ([`2133eb4`](https://github.com/chemelli74/aiovodafone/commit/2133eb45639f426e12ba61b8f80f9ba0b6424c74))
- Use generic post and get methods for technicolor ([`170043f`](https://github.com/chemelli74/aiovodafone/commit/170043f38fffacacfccb2001efa04bfdb53e4752))


## v0.3.2 (2023-10-12)

### Unknown

### Bug fixes

- Timestamp formatting works on windows ([`e614eac`](https://github.com/chemelli74/aiovodafone/commit/e614eacc0f93c638cea64ed0a685d610bd34f14f))


### Refactoring

- Make get and post more generic ([`f91daf0`](https://github.com/chemelli74/aiovodafone/commit/f91daf0a56beae2a15fcb336e4a656ca56e75604))
- Move close to common api ([`a779243`](https://github.com/chemelli74/aiovodafone/commit/a779243cacf00eb362ce30cc0552cedf213f9641))
- Add technicolor firmware api structure ([`7c52386`](https://github.com/chemelli74/aiovodafone/commit/7c52386e8e15acc1b85ad66d5251fecb64cbfe68))


### Features

- Support technicolor vodafone stations from germany ([`09989a6`](https://github.com/chemelli74/aiovodafone/commit/09989a6b83c12347fc1826a5d59da68f2a9f77b7))


### Build system

- Bump aiohttp from 3.8.5 to 3.8.6 ([`d312246`](https://github.com/chemelli74/aiovodafone/commit/d312246728d715faec30e473306ebaaf07c920a8))
- Simplify vscode and docker environments ([`0080be7`](https://github.com/chemelli74/aiovodafone/commit/0080be757f398ce37c0ca10050e9043a8e57b81d))


## v0.3.1 (2023-09-26)

### Unknown

### Bug fixes

- Make beautifulsoup parsing more robust ([`dc2d47b`](https://github.com/chemelli74/aiovodafone/commit/dc2d47b9aafcb8ada255b05640ae59f1b5cbc98b))


## v0.3.0 (2023-09-20)

### Unknown

### Features

- Connection_type() ([`f0d82a3`](https://github.com/chemelli74/aiovodafone/commit/f0d82a33ca8824bcbb0deb02a1f2c0f13d7f13a3))


### Build system

- Remove bs4 dependency ([`9657b82`](https://github.com/chemelli74/aiovodafone/commit/9657b8258cb53b67cc83652fcb5ba37d41e99134))


## v0.2.1 (2023-09-19)

### Unknown

### Build system

- Fix commitlint ([`54becb6`](https://github.com/chemelli74/aiovodafone/commit/54becb6d9e9deb41eab1aa76caa79681eb8c3686))
- Pre-commit manual autoupdate ([`c88d9e4`](https://github.com/chemelli74/aiovodafone/commit/c88d9e493e010baba827a8861ece5dfc24cdbb13))
- Update poetry ([`ec46100`](https://github.com/chemelli74/aiovodafone/commit/ec461002d2c5d644957e3435e97c54727dcc4dbf))
- Fix poetry lock hook ([`51fb510`](https://github.com/chemelli74/aiovodafone/commit/51fb51049029da10bd968b8dade8c0c47e1cd4df))


### Bug fixes

- Mypy new version's complains ([`b8a552d`](https://github.com/chemelli74/aiovodafone/commit/b8a552d4015995135f1c80faa21fee388985b82e))


## v0.2.0 (2023-09-10)

### Unknown

### Bug fixes

- Missing wifi band info on some models ([`304c254`](https://github.com/chemelli74/aiovodafone/commit/304c254e7c3895bbc7b636c0a56523fbef4cc3ea))


### Features

- Basic checks to verify if model is supported ([`c3c34ff`](https://github.com/chemelli74/aiovodafone/commit/c3c34ff442008ec009299b882906041c51b3ef14))


### Build system

- Fix labels permission ([`7e43c06`](https://github.com/chemelli74/aiovodafone/commit/7e43c06cedc8e4edfa22b0dcaad3a3f799f585af))
- Bump actions/checkout from 3 to 4 ([`b1bc21b`](https://github.com/chemelli74/aiovodafone/commit/b1bc21bbb7c36845680a38446d0137e03f6bc454))
- Bump pytest from 7.4.1 to 7.4.2 ([`de654a3`](https://github.com/chemelli74/aiovodafone/commit/de654a3539c956e331bde8c44eafac6bd2cf6ab5))
- Bump pytest-cov from 3.0.0 to 4.1.0 ([`9d155fa`](https://github.com/chemelli74/aiovodafone/commit/9d155faec0593af82c49b120e582cf874408bcbb))
- Bump wagoid/commitlint-github-action from 5.4.1 to 5.4.3 ([`dd0c473`](https://github.com/chemelli74/aiovodafone/commit/dd0c473f625dc87a7881c41103114a63c75fffc9))
- Bump snok/install-poetry from 1.3.3 to 1.3.4 ([`9c11fdc`](https://github.com/chemelli74/aiovodafone/commit/9c11fdc3d322af1e517a75baa23b9bea27809913))


## v0.1.0 (2023-09-07)

### Bug fixes

- Handle credentials with special characters ([`d3b0a14`](https://github.com/chemelli74/aiovodafone/commit/d3b0a14910908735c5c87615ba51c8e227581c59))
- Handle credentials with special characters ([`1b4a6cd`](https://github.com/chemelli74/aiovodafone/commit/1b4a6cd5af2c6c644b2077515ad3164faab30c64))


### Features

- Full sensor data, restart connection/router ([`db68478`](https://github.com/chemelli74/aiovodafone/commit/db684781d2b732f7920209cf0ef6f0c4af2e6ec5))
- Full sensor data, restart connection/router ([`3f40512`](https://github.com/chemelli74/aiovodafone/commit/3f40512e5170bb3e1173ceafa6d7d44ee02a45eb))


## v0.0.8 (2023-09-05)

### Bug fixes

- Labels ([`6c78985`](https://github.com/chemelli74/aiovodafone/commit/6c7898585ee8ab9b8945e8bf1c86dcb5dca7cf7f))
- Labels ([`2e24074`](https://github.com/chemelli74/aiovodafone/commit/2e240749b1c41b7c3a025947191b68d92b7438a4))


### Unknown

## v0.0.7 (2023-09-05)

### Bug fixes

- Legacy device login ([`6dbb329`](https://github.com/chemelli74/aiovodafone/commit/6dbb3299d849a19d107624d6759fae8283594dbd))
- Legacy device login ([`8b10e98`](https://github.com/chemelli74/aiovodafone/commit/8b10e98170d6c99929a25fed1ca43b504a51dc81))


### Unknown

## v0.0.6 (2023-08-22)

### Bug fixes

- Poetry lock ([`b489804`](https://github.com/chemelli74/aiovodafone/commit/b4898044c77a6172cc28796f57832951cf2281f2))


## v0.0.5 (2023-07-28)

### Bug fixes

- Improve login handling ([`e50cf1a`](https://github.com/chemelli74/aiovodafone/commit/e50cf1a8ebf47b2088d9e43d321b6b18329d97bb))
- Stop script if login fails ([`3a31c02`](https://github.com/chemelli74/aiovodafone/commit/3a31c025660443c3455f5d3e2acab4721c34a0be))
- Drop python 3.9 ([`dd2ecb6`](https://github.com/chemelli74/aiovodafone/commit/dd2ecb66a9d5be687c4c576ae3e806f24791d6a5))


### Unknown

## v0.0.4 (2023-07-01)

### Bug fixes

- Adjust permissions to allow release ([`c8667b4`](https://github.com/chemelli74/aiovodafone/commit/c8667b463f339b7001ee4e6314610065ac9b9c6d))
- Remove legacy python versions that do not support old typing (#2) ([`c6d6a87`](https://github.com/chemelli74/aiovodafone/commit/c6d6a8789a723487c65c4bc84ed71d250a987821))
- Add some basic sanity tests (#1) ([`1d813d3`](https://github.com/chemelli74/aiovodafone/commit/1d813d3aa798221ceb982ae6b32bb3b5c942422a))
- Dependencies fix ([`118e1b3`](https://github.com/chemelli74/aiovodafone/commit/118e1b335b2cb9132295ba8e59cc84d77caef4ee))


### Unknown

### Build system

- 0.0.2 ([`213850d`](https://github.com/chemelli74/aiovodafone/commit/213850dd9e547838a77b1aab06d15eb532292871))
- First code version ([`0ff2c8e`](https://github.com/chemelli74/aiovodafone/commit/0ff2c8ec116f7d1882e70938d118557e0ecaa1f6))


### Refactoring

- Logout/close ([`8d053c3`](https://github.com/chemelli74/aiovodafone/commit/8d053c329dbb349728bcd642803d3bd446551b16))
