/* $Cambridge: hermes/src/prayer/session/msgmap.h,v 1.3 2008/09/16 09:59:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

struct msgmap {
    struct session *session;    /* Session associated with msgmap     */
    MAILSTREAM *stream;         /* Stream associated with this msgmap */
    unsigned long nmsgs;        /* Size of zoomap                      */
    unsigned long uid_last;     /* Last uid assigned to msgmap        */
    unsigned long marked;       /* Number of marked messages in folder */
    unsigned long tmp_marked;   /* Number of tmp marked messages in folder */
    struct memblock *sorted;    /* Sorted Zoommap                      */
    struct memblock *depths;    /* Message depths if threading on      */
    struct memblock *subset;    /* Marked msgmap                      */
    SORTMODE sort_mode;         /* Current Sort mode for this folder   */
    BOOL sort_reverse;          /* Reverse sort order                  */
    BOOL valid;                 /* sorted map valid or irrelevant      */
    BOOL valid_zoom;            /* zoom map valid or irrelevant      */
    BOOL zoom;                  /* Zoom map enabled                    */
};

struct msgmap *msgmap_create(struct pool *pool);

void msgmap_free(struct msgmap *z);

void msgmap_enable_zoom(struct msgmap *z);
void msgmap_disable_zoom(struct msgmap *z);
BOOL msgmap_have_zoom(struct msgmap *z);
void msgmap_sort_mode(struct msgmap *z, SORTMODE sort_mode);

SORTMODE msgmap_current_sort_mode(struct msgmap *z);

void msgmap_sort_reverse_enable(struct msgmap *z);
void msgmap_sort_reverse_disable(struct msgmap *z);
BOOL msgmap_sort_reverse(struct msgmap *z);

BOOL msgmap_update(struct msgmap *z);

unsigned long msgmap_find(struct msgmap *z, unsigned long msgno);

unsigned long msgmap_find_undeleted(struct msgmap *z, unsigned long msgno);

unsigned long msgmap_value(struct msgmap *z, unsigned long offset);

unsigned long msgmap_depth(struct msgmap *z, unsigned long offset);

unsigned long msgmap_size(struct msgmap *z);

void msgmap_invalidate(struct msgmap *z);

void msgmap_invalidate_zoom(struct msgmap *z);

void msgmap_check(struct msgmap *z);

/* Persistent mark stuff */

BOOL msgmap_mark(struct msgmap *z, unsigned long msgno);

BOOL msgmap_unmark(struct msgmap *z, unsigned long msgno);

BOOL msgmap_has_mark(struct msgmap *z, unsigned long msgno);

BOOL msgmap_mark_all(struct msgmap *z);

BOOL msgmap_unmark_all(struct msgmap *z);

unsigned long msgmap_marked_count(struct msgmap *z);

void msgmap_marked_set(struct msgmap *z, unsigned long count);

char *msgmap_mark_sequence(struct msgmap *z);

/* Temporary mark stuff */

BOOL msgmap_tmp_mark(struct msgmap *z, unsigned long msgno);

BOOL msgmap_tmp_unmark(struct msgmap *z, unsigned long msgno);

BOOL msgmap_has_tmp_mark(struct msgmap *z, unsigned long msgno);

BOOL msgmap_tmp_mark_all(struct msgmap *z);

BOOL msgmap_tmp_unmark_all(struct msgmap *z);

unsigned long msgmap_tmp_marked_count(struct msgmap *z);

char *msgmap_tmp_mark_sequence(struct msgmap *z);

/* Other calls */

BOOL
msgmap_associate(struct msgmap *z,
                 struct session *session, MAILSTREAM * stream);

BOOL msgmap_reset(struct msgmap *z);

BOOL msgmap_recalculate(struct msgmap *z);

BOOL msgmap_mark_searched(struct msgmap *z, BOOL narrow);
