/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/*
* When adding modules to the namespace, ensure that they are added in alphabetical order according to module name.
*/

// MODULES //

var setReadOnly = require( './../../define-read-only-property' );


// MAIN //

/**
* Top-level namespace.
*
* @namespace ns
*/
var ns = {};

/**
* @name anyByAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/any-by}
*/
setReadOnly( ns, 'anyByAsync', require( './../../async/any-by' ) );

/**
* @name anyByRightAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/any-by-right}
*/
setReadOnly( ns, 'anyByRightAsync', require( './../../async/any-by-right' ) );

/**
* @name bifurcateByAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/bifurcate-by}
*/
setReadOnly( ns, 'bifurcateByAsync', require( './../../async/bifurcate-by' ) );

/**
* @name composeAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/compose}
*/
setReadOnly( ns, 'composeAsync', require( './../../async/compose' ) );

/**
* @name countByAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/count-by}
*/
setReadOnly( ns, 'countByAsync', require( './../../async/count-by' ) );

/**
* @name doUntilAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/do-until}
*/
setReadOnly( ns, 'doUntilAsync', require( './../../async/do-until' ) );

/**
* @name doWhileAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/do-while}
*/
setReadOnly( ns, 'doWhileAsync', require( './../../async/do-while' ) );

/**
* @name everyByAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/every-by}
*/
setReadOnly( ns, 'everyByAsync', require( './../../async/every-by' ) );

/**
* @name everyByRightAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/every-by-right}
*/
setReadOnly( ns, 'everyByRightAsync', require( './../../async/every-by-right' ) );

/**
* @name forEachAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/for-each}
*/
setReadOnly( ns, 'forEachAsync', require( './../../async/for-each' ) );

/**
* @name forEachRightAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/for-each-right}
*/
setReadOnly( ns, 'forEachRightAsync', require( './../../async/for-each-right' ) );

/**
* @name functionSequenceAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/function-sequence}
*/
setReadOnly( ns, 'functionSequenceAsync', require( './../../async/function-sequence' ) );

/**
* @name groupByAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/group-by}
*/
setReadOnly( ns, 'groupByAsync', require( './../../async/group-by' ) );

/**
* @name ifelseAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/if-else}
*/
setReadOnly( ns, 'ifelseAsync', require( './../../async/if-else' ) );

/**
* @name ifthenAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/if-then}
*/
setReadOnly( ns, 'ifthenAsync', require( './../../async/if-then' ) );

/**
* @name inmapAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/inmap}
*/
setReadOnly( ns, 'inmapAsync', require( './../../async/inmap' ) );

/**
* @name inmapRightAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/inmap-right}
*/
setReadOnly( ns, 'inmapRightAsync', require( './../../async/inmap-right' ) );

/**
* @name mapFunAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/map-function}
*/
setReadOnly( ns, 'mapFunAsync', require( './../../async/map-function' ) );

/**
* @name mapKeysAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/map-keys}
*/
setReadOnly( ns, 'mapKeysAsync', require( './../../async/map-keys' ) );

/**
* @name mapValuesAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/map-values}
*/
setReadOnly( ns, 'mapValuesAsync', require( './../../async/map-values' ) );

/**
* @name noneByAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/none-by}
*/
setReadOnly( ns, 'noneByAsync', require( './../../async/none-by' ) );

/**
* @name noneByRightAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/none-by-right}
*/
setReadOnly( ns, 'noneByRightAsync', require( './../../async/none-by-right' ) );

/**
* @name reduceAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/reduce}
*/
setReadOnly( ns, 'reduceAsync', require( './../../async/reduce' ) );

/**
* @name reduceRightAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/reduce-right}
*/
setReadOnly( ns, 'reduceRightAsync', require( './../../async/reduce-right' ) );

/**
* @name waterfall
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/series-waterfall}
*/
setReadOnly( ns, 'waterfall', require( './../../async/series-waterfall' ) );

/**
* @name someByAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/some-by}
*/
setReadOnly( ns, 'someByAsync', require( './../../async/some-by' ) );

/**
* @name someByRightAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/some-by-right}
*/
setReadOnly( ns, 'someByRightAsync', require( './../../async/some-by-right' ) );

/**
* @name tabulateByAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/tabulate-by}
*/
setReadOnly( ns, 'tabulateByAsync', require( './../../async/tabulate-by' ) );

/**
* @name trycatchAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/try-catch}
*/
setReadOnly( ns, 'trycatchAsync', require( './../../async/try-catch' ) );

/**
* @name trythenAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/try-then}
*/
setReadOnly( ns, 'trythenAsync', require( './../../async/try-then' ) );

/**
* @name untilAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/until}
*/
setReadOnly( ns, 'untilAsync', require( './../../async/until' ) );

/**
* @name whileAsync
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/utils/async/while}
*/
setReadOnly( ns, 'whileAsync', require( './../../async/while' ) );


// EXPORTS //

module.exports = ns;
