/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Return a list of ndarray index modes.
*
* @module @stdlib/ndarray/index-modes
*
* @example
* var modes = require( '@stdlib/ndarray/index-modes' );
*
* var list = modes();
* // returns [ 'throw', 'clamp', 'wrap' ]
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-nonenumerable-read-only-property' );
var modes = require( './main.js' );
var enumeration = require( './enum.js' );


// MAIN //

setReadOnly( modes, 'enum', enumeration );


// EXPORTS //

module.exports = modes;
