/*
 * Copyright (c) 2016-2017 Digital Bazaar, Inc. All rights reserved.
 */
'use strict';

const forge = require('node-forge/lib/forge');
require('node-forge/lib/md');
require('node-forge/lib/sha1');
require('node-forge/lib/sha256');

module.exports = class MessageDigest {
  /**
   * Creates a new MessageDigest.
   *
   * @param algorithm the algorithm to use.
   */
  constructor(algorithm) {
    this.md = forge.md[algorithm].create();
  }

  update(msg) {
    this.md.update(msg, 'utf8');
  }

  digest() {
    return this.md.digest().toHex();
  }
};
