export const testData: any = {
    namedColors: [
        {
            name: "aliceblue",
            hexRGBString: "#f0f8ff",
            hexRGBAString: "#f0f8ffff",
            hexARGBString: "#fff0f8ff",
            webRGBString: "rgb(240,248,255)",
            webRGBAString: "rgba(240,248,255,1)",
            lum: 0.9288,
            temp: 7194,
            rgba: {
                r: 0.941176,
                g: 0.972549,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 207.999796,
                s: 1,
                l: 0.970588,
            },
            hsv: {
                h: 207.999796,
                s: 0.058824,
                v: 1,
            },
            xyz: {
                x: 0.87549,
                y: 0.928794,
                z: 1.079035,
            },
            lab: {
                l: 97.17864,
                a: -1.348652,
                b: -4.26287,
            },
            lch: {
                l: 97.17864,
                c: 4.471121,
                h: 252.444094,
            },
            lchToLabResult: {
                l: 97.17864,
                a: -1.348652,
                b: -4.26287,
            },
            labToLCHResult: {
                l: 97.17864,
                c: 4.471121,
                h: 252.444096,
            },
            labToXYZResult: {
                x: 0.87549,
                y: 0.928794,
                z: 1.079035,
            },
            xyzToLABResult: {
                l: 97.178636,
                a: -1.348562,
                b: -4.262887,
            },
            rgbToXYZResult: {
                x: 0.87549,
                y: 0.928794,
                z: 1.079035,
            },
            xyzToRGBResult: {
                r: 0.941177,
                g: 0.972549,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 97.17864,
                a: -1.348652,
                b: -4.26287,
            },
            labToRGBResult: {
                r: 0.941176,
                g: 0.972549,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 97.17864,
                c: 4.471121,
                h: 252.444094,
            },
            lchToRGBResult: {
                r: 0.941176,
                g: 0.972549,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.890684,
                    g: 0.980382,
                    b: 1.05522,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.83378,
                    g: 0.988251,
                    b: 1.110543,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.768568,
                    g: 0.99616,
                    b: 1.166006,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.691989,
                    g: 1.004115,
                    b: 1.221639,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.598463,
                    g: 1.012118,
                    b: 1.277466,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.475459,
                    g: 1.020176,
                    b: 1.333504,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.276883,
                    g: 1.028292,
                    b: 1.389769,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.968023,
                    g: 0.968023,
                    b: 0.968023,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.968023,
                    g: 0.968023,
                    b: 0.968023,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.968023,
                    g: 0.968023,
                    b: 0.968023,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.968023,
                    g: 0.968023,
                    b: 0.968023,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.968023,
                    g: 0.968023,
                    b: 0.968023,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.968023,
                    g: 0.968023,
                    b: 0.968023,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.968023,
                    g: 0.968023,
                    b: 0.968023,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.85518,
                    g: 0.886064,
                    b: 0.913035,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.77077,
                    g: 0.801141,
                    b: 0.827605,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.68804,
                    g: 0.717873,
                    b: 0.743798,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.607098,
                    g: 0.636363,
                    b: 0.661715,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.52807,
                    g: 0.556734,
                    b: 0.58147,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.451103,
                    g: 0.479129,
                    b: 0.5032,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.376374,
                    g: 0.403721,
                    b: 0.427067,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.028675,
                    g: 1.060516,
                    b: 1.088423,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.117605,
                    g: 1.149894,
                    b: 1.178236,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.207899,
                    g: 1.240619,
                    b: 1.269376,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.299498,
                    g: 1.332633,
                    b: 1.361789,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.39235,
                    g: 1.425885,
                    b: 1.455423,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.486405,
                    g: 1.520326,
                    b: 1.550233,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.58162,
                    g: 1.615914,
                    b: 1.646177,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.938566,
                    g: 0.996363,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.939871,
                    g: 0.984456,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.941176,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.618842,
                    g: 0.730476,
                    b: 0.79449,
                    a: 1,
                },
                {
                    r: 0.296507,
                    g: 0.488403,
                    b: 0.58898,
                    a: 1,
                },
            ],
        },
        {
            name: "antiquewhite",
            hexRGBString: "#faebd7",
            hexRGBAString: "#faebd7ff",
            hexARGBString: "#fffaebd7",
            webRGBString: "rgb(250,235,215)",
            webRGBAString: "rgba(250,235,215,1)",
            lum: 0.84647,
            temp: 5397,
            rgba: {
                r: 0.980392,
                g: 0.921569,
                b: 0.843137,
                a: 1,
            },
            hsl: {
                h: 34.285964,
                s: 0.777777,
                l: 0.911765,
            },
            hsv: {
                h: 34.285964,
                s: 0.14,
                v: 0.980392,
            },
            xyz: {
                x: 0.813976,
                y: 0.846483,
                z: 0.763275,
            },
            lab: {
                l: 93.731351,
                a: 1.838604,
                b: 11.526226,
            },
            lch: {
                l: 93.731351,
                c: 11.671947,
                h: 80.936827,
            },
            lchToLabResult: {
                l: 93.731351,
                a: 1.838604,
                b: 11.526226,
            },
            labToLCHResult: {
                l: 93.731351,
                c: 11.671947,
                h: 80.936829,
            },
            labToXYZResult: {
                x: 0.813976,
                y: 0.846483,
                z: 0.763275,
            },
            xyzToLABResult: {
                l: 93.731353,
                a: 1.838639,
                b: 11.526265,
            },
            rgbToXYZResult: {
                x: 0.813976,
                y: 0.846483,
                z: 0.763275,
            },
            xyzToRGBResult: {
                r: 0.980392,
                g: 0.921569,
                b: 0.843137,
                a: 1,
            },
            rgbToLABResult: {
                l: 93.731351,
                a: 1.838604,
                b: 11.526226,
            },
            labToRGBResult: {
                r: 0.980392,
                g: 0.921569,
                b: 0.843137,
                a: 1,
            },
            rgbToLCHResult: {
                l: 93.731351,
                c: 11.671947,
                h: 80.936827,
            },
            lchToRGBResult: {
                r: 0.980392,
                g: 0.921569,
                b: 0.843137,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.921569,
                    b: 0.843137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.010111,
                    g: 0.916663,
                    b: 0.786064,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.037074,
                    g: 0.911874,
                    b: 0.728686,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.061622,
                    g: 0.907195,
                    b: 0.670801,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.084034,
                    g: 0.902622,
                    b: 0.612124,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.104548,
                    g: 0.898149,
                    b: 0.552233,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.123365,
                    g: 0.893771,
                    b: 0.490483,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.140659,
                    g: 0.889482,
                    b: 0.425805,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.921569,
                    b: 0.843137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.947498,
                    g: 0.926596,
                    b: 0.90005,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.929223,
                    g: 0.929223,
                    b: 0.929223,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.929223,
                    g: 0.929223,
                    b: 0.929223,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.929223,
                    g: 0.929223,
                    b: 0.929223,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.929223,
                    g: 0.929223,
                    b: 0.929223,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.929223,
                    g: 0.929223,
                    b: 0.929223,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.929223,
                    g: 0.929223,
                    b: 0.929223,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.921569,
                    b: 0.843137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.893462,
                    g: 0.836001,
                    b: 0.758966,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.808053,
                    g: 0.752049,
                    b: 0.67649,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.724249,
                    g: 0.669812,
                    b: 0.595821,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.642145,
                    g: 0.589405,
                    b: 0.517085,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.561848,
                    g: 0.510962,
                    b: 0.440437,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.483484,
                    g: 0.434643,
                    b: 0.366056,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.407198,
                    g: 0.360644,
                    b: 0.294168,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.921569,
                    b: 0.843137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.068769,
                    g: 1.008666,
                    b: 0.928907,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.158527,
                    g: 1.097216,
                    b: 1.016193,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.249606,
                    g: 1.187149,
                    b: 1.104919,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.341952,
                    g: 1.278406,
                    b: 1.195018,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.435515,
                    g: 1.370931,
                    b: 1.286432,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.530251,
                    g: 1.464673,
                    b: 1.379105,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.626117,
                    g: 1.559587,
                    b: 1.472989,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.967134,
                    b: 0.894916,
                    a: 1,
                },
                {
                    r: 0.990196,
                    g: 0.944352,
                    b: 0.869027,
                    a: 1,
                },
                {
                    r: 0.980392,
                    g: 0.921569,
                    b: 0.843137,
                    a: 1,
                },
                {
                    r: 0.750618,
                    g: 0.67828,
                    b: 0.560944,
                    a: 1,
                },
                {
                    r: 0.520844,
                    g: 0.434992,
                    b: 0.278752,
                    a: 1,
                },
            ],
        },
        {
            name: "aqua",
            hexRGBString: "#00ffff",
            hexRGBAString: "#00ffffff",
            hexARGBString: "#ff00ffff",
            webRGBString: "rgb(0,255,255)",
            webRGBAString: "rgba(0,255,255,1)",
            lum: 0.7874,
            temp: 40000,
            rgba: {
                r: 0,
                g: 1,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 180,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 180,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.538014,
                y: 0.787327,
                z: 1.069496,
            },
            lab: {
                l: 91.11322,
                a: -48.087528,
                b: -14.131186,
            },
            lch: {
                l: 91.11322,
                c: 50.120862,
                h: 196.376156,
            },
            lchToLabResult: {
                l: 91.11322,
                a: -48.087528,
                b: -14.131186,
            },
            labToLCHResult: {
                l: 91.11322,
                c: 50.120862,
                h: 196.376156,
            },
            labToXYZResult: {
                x: 0.538014,
                y: 0.787327,
                z: 1.069496,
            },
            xyzToLABResult: {
                l: 91.113211,
                a: -48.087386,
                b: -14.131196,
            },
            rgbToXYZResult: {
                x: 0.538014,
                y: 0.787327,
                z: 1.069496,
            },
            xyzToRGBResult: {
                r: 0.000023,
                g: 1,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 91.11322,
                a: -48.087528,
                b: -14.131186,
            },
            labToRGBResult: {
                r: 0.000001,
                g: 1,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 91.11322,
                c: 50.120862,
                h: 196.376156,
            },
            lchToRGBResult: {
                r: 0.000001,
                g: 1,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -1.416276,
                    g: 1.012629,
                    b: 1.015635,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -2.795051,
                    g: 1.024648,
                    b: 1.031328,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -4.137153,
                    g: 1.036091,
                    b: 1.047075,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -5.443411,
                    g: 1.04699,
                    b: 1.062876,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -6.714653,
                    g: 1.057374,
                    b: 1.078728,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -7.951708,
                    g: 1.06727,
                    b: 1.09463,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -9.155404,
                    g: 1.076703,
                    b: 1.110581,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.369656,
                    g: 0.986721,
                    b: 0.984424,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.515014,
                    g: 0.972751,
                    b: 0.968908,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.6237,
                    g: 0.958041,
                    b: 0.953457,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.71441,
                    g: 0.942539,
                    b: 0.938071,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.794102,
                    g: 0.926185,
                    b: 0.922754,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.866244,
                    g: 0.908911,
                    b: 0.907509,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.899957,
                    g: 0.899957,
                    b: 0.899957,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.574477,
                    g: 0.911766,
                    b: 0.913069,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.969884,
                    g: 0.824942,
                    b: 0.827676,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -1.20902,
                    g: 0.739589,
                    b: 0.743909,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.314683,
                    g: 0.655777,
                    b: 0.66187,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.309675,
                    g: 0.573583,
                    b: 0.581673,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.216793,
                    g: 0.493087,
                    b: 0.503456,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.058839,
                    g: 0.414378,
                    b: 0.42738,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.271902,
                    g: 1.089584,
                    b: 1.088392,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.406637,
                    g: 1.180464,
                    b: 1.178175,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.521209,
                    g: 1.272592,
                    b: 1.269289,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.627627,
                    g: 1.365922,
                    b: 1.361676,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.730053,
                    g: 1.460411,
                    b: 1.455286,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.830414,
                    g: 1.556022,
                    b: 1.550074,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.929745,
                    g: 1.652717,
                    b: 1.645996,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.53828,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.26914,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.754818,
                    b: 0.759042,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.509637,
                    b: 0.518084,
                    a: 1,
                },
            ],
        },
        {
            name: "aquamarine",
            hexRGBString: "#7fffd4",
            hexRGBAString: "#7fffd4ff",
            hexARGBString: "#ff7fffd4",
            webRGBString: "rgb(127,255,212)",
            webRGBAString: "rgba(127,255,212,1)",
            lum: 0.807855,
            temp: 40000,
            rgba: {
                r: 0.498039,
                g: 1,
                b: 0.831373,
                a: 1,
            },
            hsl: {
                h: 159.843813,
                s: 1,
                l: 0.74902,
            },
            hsv: {
                h: 159.843813,
                s: 0.501961,
                v: 1,
            },
            xyz: {
                x: 0.563908,
                y: 0.807806,
                z: 0.748952,
            },
            lab: {
                l: 92.03398,
                a: -45.524525,
                b: 9.71807,
            },
            lch: {
                l: 92.03398,
                c: 46.550223,
                h: 167.949996,
            },
            lchToLabResult: {
                l: 92.03398,
                a: -45.524525,
                b: 9.71807,
            },
            labToLCHResult: {
                l: 92.03398,
                c: 46.550223,
                h: 167.949996,
            },
            labToXYZResult: {
                x: 0.563908,
                y: 0.807806,
                z: 0.748952,
            },
            xyzToLABResult: {
                l: 92.033973,
                a: -45.524398,
                b: 9.718082,
            },
            rgbToXYZResult: {
                x: 0.563908,
                y: 0.807806,
                z: 0.748952,
            },
            xyzToRGBResult: {
                r: 0.498041,
                g: 1,
                b: 0.831373,
                a: 1,
            },
            rgbToLABResult: {
                l: 92.03398,
                a: -45.524525,
                b: 9.71807,
            },
            labToRGBResult: {
                r: 0.498039,
                g: 1,
                b: 0.831373,
                a: 1,
            },
            rgbToLCHResult: {
                l: 92.03398,
                c: 46.550223,
                h: 167.949996,
            },
            lchToRGBResult: {
                r: 0.498039,
                g: 1,
                b: 0.831373,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.498039,
                    g: 1,
                    b: 0.831373,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.389569,
                    g: 1.012242,
                    b: 0.818261,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.227715,
                    g: 1.023854,
                    b: 0.805132,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.486272,
                    g: 1.034872,
                    b: 0.791984,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.47956,
                    g: 1.045328,
                    b: 0.778813,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -2.432775,
                    g: 1.055252,
                    b: 0.765618,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -3.346714,
                    g: 1.064669,
                    b: 0.752395,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -4.222176,
                    g: 1.073606,
                    b: 0.739142,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.498039,
                    g: 1,
                    b: 0.831373,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.585722,
                    g: 0.987091,
                    b: 0.844469,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.66176,
                    g: 0.97347,
                    b: 0.857552,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.730221,
                    g: 0.959091,
                    b: 0.870623,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.793315,
                    g: 0.943899,
                    b: 0.883684,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.852396,
                    g: 0.927835,
                    b: 0.896736,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.908358,
                    g: 0.91083,
                    b: 0.909782,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.910229,
                    g: 0.910229,
                    b: 0.910229,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.498039,
                    g: 1,
                    b: 0.831373,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.406467,
                    g: 0.911941,
                    b: 0.747433,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.311125,
                    g: 0.825306,
                    b: 0.665202,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.205156,
                    g: 0.740162,
                    b: 0.584794,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.042283,
                    g: 0.656583,
                    b: 0.506341,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.223087,
                    g: 0.574647,
                    b: 0.429997,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.370315,
                    g: 0.494443,
                    b: 0.355951,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.422145,
                    g: 0.416066,
                    b: 0.284431,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.498039,
                    g: 1,
                    b: 0.831373,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.588235,
                    g: 1.089424,
                    b: 0.916925,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.678135,
                    g: 1.180156,
                    b: 1.004004,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.768293,
                    g: 1.272146,
                    b: 1.092533,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.859016,
                    g: 1.365348,
                    b: 1.182445,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.950479,
                    g: 1.459717,
                    b: 1.273679,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.042785,
                    g: 1.555215,
                    b: 1.36618,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.135993,
                    g: 1.651804,
                    b: 1.459897,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.758585,
                    g: 1,
                    b: 0.929944,
                    a: 1,
                },
                {
                    r: 0.628312,
                    g: 1,
                    b: 0.880659,
                    a: 1,
                },
                {
                    r: 0.498039,
                    g: 1,
                    b: 0.831373,
                    a: 1,
                },
                {
                    r: 0.24902,
                    g: 0.754754,
                    b: 0.597171,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.509508,
                    b: 0.362968,
                    a: 1,
                },
            ],
        },
        {
            name: "azure",
            hexRGBString: "#f0ffff",
            hexRGBAString: "#f0ffffff",
            hexARGBString: "#fff0ffff",
            webRGBString: "rgb(240,255,255)",
            webRGBAString: "rgba(240,255,255,1)",
            lum: 0.972652,
            temp: 7194,
            rgba: {
                r: 0.941176,
                g: 1,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 180,
                s: 1,
                l: 0.970588,
            },
            hsv: {
                h: 180,
                s: 0.058824,
                v: 1,
            },
            xyz: {
                x: 0.897414,
                y: 0.972643,
                z: 1.086343,
            },
            lab: {
                l: 98.932407,
                a: -4.880434,
                b: -1.688288,
            },
            lch: {
                l: 98.932407,
                c: 5.164199,
                h: 199.082038,
            },
            lchToLabResult: {
                l: 98.932407,
                a: -4.880434,
                b: -1.688288,
            },
            labToLCHResult: {
                l: 98.932407,
                c: 5.164199,
                h: 199.082033,
            },
            labToXYZResult: {
                x: 0.897414,
                y: 0.972643,
                z: 1.086343,
            },
            xyzToLABResult: {
                l: 98.932401,
                a: -4.880431,
                b: -1.688299,
            },
            rgbToXYZResult: {
                x: 0.897414,
                y: 0.972643,
                z: 1.086343,
            },
            xyzToRGBResult: {
                r: 0.941176,
                g: 1,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 98.932407,
                a: -4.880434,
                b: -1.688288,
            },
            labToRGBResult: {
                r: 0.941176,
                g: 1,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 98.932407,
                c: 5.164199,
                h: 199.082038,
            },
            lchToRGBResult: {
                r: 0.941176,
                g: 1,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.866562,
                    g: 1.017357,
                    b: 1.018172,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.784339,
                    g: 1.033871,
                    b: 1.036416,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.691226,
                    g: 1.049598,
                    b: 1.05473,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.580907,
                    g: 1.06459,
                    b: 1.073112,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.437797,
                    g: 1.078894,
                    b: 1.091559,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.183284,
                    g: 1.092551,
                    b: 1.11007,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.313892,
                    g: 1.105598,
                    b: 1.128642,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.987877,
                    g: 0.987877,
                    b: 0.987877,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.987877,
                    g: 0.987877,
                    b: 0.987877,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.987877,
                    g: 0.987877,
                    b: 0.987877,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.987877,
                    g: 0.987877,
                    b: 0.987877,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.987877,
                    g: 0.987877,
                    b: 0.987877,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.987877,
                    g: 0.987877,
                    b: 0.987877,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.987877,
                    g: 0.987877,
                    b: 0.987877,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.855145,
                    g: 0.913026,
                    b: 0.913042,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.770696,
                    g: 0.827586,
                    b: 0.827619,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.687922,
                    g: 0.743768,
                    b: 0.743821,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.606929,
                    g: 0.661671,
                    b: 0.661747,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.52784,
                    g: 0.581412,
                    b: 0.581513,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.450802,
                    g: 0.503125,
                    b: 0.503256,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.375985,
                    g: 0.426971,
                    b: 0.427138,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.028707,
                    g: 1.088432,
                    b: 1.088417,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.117664,
                    g: 1.178252,
                    b: 1.178224,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.207984,
                    g: 1.269399,
                    b: 1.26936,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.299607,
                    g: 1.361818,
                    b: 1.361768,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.39248,
                    g: 1.455458,
                    b: 1.455398,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.486555,
                    g: 1.550274,
                    b: 1.550203,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.581788,
                    g: 1.646222,
                    b: 1.646143,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.919745,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.93046,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.941176,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.55971,
                    g: 0.758561,
                    b: 0.761362,
                    a: 1,
                },
                {
                    r: 0.178243,
                    g: 0.517122,
                    b: 0.522724,
                    a: 1,
                },
            ],
        },
        {
            name: "beige",
            hexRGBString: "#f5f5dc",
            hexRGBAString: "#f5f5dcff",
            hexARGBString: "#fff5f5dc",
            webRGBString: "rgb(245,245,220)",
            webRGBAString: "rgba(245,245,220,1)",
            lum: 0.898845,
            temp: 5684,
            rgba: {
                r: 0.960784,
                g: 0.960784,
                b: 0.862745,
                a: 1,
            },
            hsl: {
                h: 60,
                s: 0.555553,
                l: 0.911765,
            },
            hsv: {
                h: 60,
                s: 0.102041,
                v: 0.960784,
            },
            xyz: {
                x: 0.832253,
                y: 0.89885,
                z: 0.806614,
            },
            lab: {
                l: 95.949062,
                a: -4.19286,
                b: 12.04897,
            },
            lch: {
                l: 95.949062,
                c: 12.757655,
                h: 109.187128,
            },
            lchToLabResult: {
                l: 95.949062,
                a: -4.19286,
                b: 12.04897,
            },
            labToLCHResult: {
                l: 95.949062,
                c: 12.757655,
                h: 109.187127,
            },
            labToXYZResult: {
                x: 0.832253,
                y: 0.89885,
                z: 0.806614,
            },
            xyzToLABResult: {
                l: 95.949046,
                a: -4.192797,
                b: 12.048943,
            },
            rgbToXYZResult: {
                x: 0.832253,
                y: 0.89885,
                z: 0.806614,
            },
            xyzToRGBResult: {
                r: 0.960784,
                g: 0.960784,
                b: 0.862745,
                a: 1,
            },
            rgbToLABResult: {
                l: 95.949062,
                a: -4.19286,
                b: 12.04897,
            },
            labToRGBResult: {
                r: 0.960784,
                g: 0.960784,
                b: 0.862745,
                a: 1,
            },
            rgbToLCHResult: {
                l: 95.949062,
                c: 12.757655,
                h: 109.187128,
            },
            lchToRGBResult: {
                r: 0.960784,
                g: 0.960784,
                b: 0.862745,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.960784,
                    g: 0.960784,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.962628,
                    g: 0.964884,
                    b: 0.807171,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.962944,
                    g: 0.969043,
                    b: 0.751192,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.961805,
                    g: 0.973254,
                    b: 0.694604,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.959276,
                    g: 0.97751,
                    b: 0.637118,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.955415,
                    g: 0.981804,
                    b: 0.578322,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.950274,
                    g: 0.986131,
                    b: 0.517591,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.943897,
                    g: 0.990485,
                    b: 0.45392,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.960784,
                    g: 0.960784,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.957327,
                    g: 0.956749,
                    b: 0.918065,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.95415,
                    g: 0.95415,
                    b: 0.95415,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.95415,
                    g: 0.95415,
                    b: 0.95415,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.95415,
                    g: 0.95415,
                    b: 0.95415,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.95415,
                    g: 0.95415,
                    b: 0.95415,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.95415,
                    g: 0.95415,
                    b: 0.95415,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.95415,
                    g: 0.95415,
                    b: 0.95415,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.960784,
                    g: 0.960784,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.874339,
                    g: 0.874511,
                    b: 0.778181,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.78945,
                    g: 0.789813,
                    b: 0.695286,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.706205,
                    g: 0.706784,
                    b: 0.614168,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.624707,
                    g: 0.625529,
                    b: 0.534948,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.545072,
                    g: 0.546174,
                    b: 0.457773,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.467437,
                    g: 0.468867,
                    b: 0.382814,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.391965,
                    g: 0.393784,
                    b: 0.310281,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.960784,
                    g: 0.960784,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.048705,
                    g: 1.04855,
                    b: 0.948886,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.138033,
                    g: 1.137736,
                    b: 1.036523,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.228705,
                    g: 1.228277,
                    b: 1.125583,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.320664,
                    g: 1.320116,
                    b: 1.216002,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.413859,
                    g: 1.413199,
                    b: 1.30772,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.508242,
                    g: 1.507479,
                    b: 1.400686,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.603771,
                    g: 1.602911,
                    b: 1.49485,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.98796,
                    g: 0.988955,
                    b: 0.903974,
                    a: 1,
                },
                {
                    r: 0.974372,
                    g: 0.974869,
                    b: 0.88336,
                    a: 1,
                },
                {
                    r: 0.960784,
                    g: 0.960784,
                    b: 0.862745,
                    a: 1,
                },
                {
                    r: 0.712027,
                    g: 0.717784,
                    b: 0.578895,
                    a: 1,
                },
                {
                    r: 0.463269,
                    g: 0.474785,
                    b: 0.295044,
                    a: 1,
                },
            ],
        },
        {
            name: "bisque",
            hexRGBString: "#ffe4c4",
            hexRGBAString: "#ffe4c4ff",
            hexARGBString: "#ffffe4c4",
            webRGBString: "rgb(255,228,196)",
            webRGBAString: "rgba(255,228,196,1)",
            lum: 0.807324,
            temp: 4762,
            rgba: {
                r: 1,
                g: 0.894118,
                b: 0.768627,
                a: 1,
            },
            hsl: {
                h: 32.542518,
                s: 1,
                l: 0.884314,
            },
            hsv: {
                h: 32.542518,
                s: 0.231373,
                v: 1,
            },
            xyz: {
                x: 0.789476,
                y: 0.807346,
                z: 0.636384,
            },
            lab: {
                l: 92.013451,
                a: 4.430811,
                b: 19.012094,
            },
            lch: {
                l: 92.013451,
                c: 19.521573,
                h: 76.881253,
            },
            lchToLabResult: {
                l: 92.013451,
                a: 4.430811,
                b: 19.012094,
            },
            labToLCHResult: {
                l: 92.013451,
                c: 19.521573,
                h: 76.881253,
            },
            labToXYZResult: {
                x: 0.789476,
                y: 0.807346,
                z: 0.636384,
            },
            xyzToLABResult: {
                l: 92.013463,
                a: 4.430847,
                b: 19.012097,
            },
            rgbToXYZResult: {
                x: 0.789476,
                y: 0.807346,
                z: 0.636384,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.894118,
                b: 0.768627,
                a: 1,
            },
            rgbToLABResult: {
                l: 92.013451,
                a: 4.430811,
                b: 19.012094,
            },
            labToRGBResult: {
                r: 1,
                g: 0.894118,
                b: 0.768627,
                a: 1,
            },
            rgbToLCHResult: {
                l: 92.013451,
                c: 19.521573,
                h: 76.881253,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.894118,
                b: 0.768627,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.768627,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.029982,
                    g: 0.887978,
                    b: 0.712387,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.057437,
                    g: 0.881908,
                    b: 0.655674,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.082678,
                    g: 0.8759,
                    b: 0.598215,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.105964,
                    g: 0.869951,
                    b: 0.539606,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.127514,
                    g: 0.864053,
                    b: 0.479231,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.147517,
                    g: 0.8582,
                    b: 0.41607,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.166138,
                    g: 0.852386,
                    b: 0.348276,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.768627,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.967109,
                    g: 0.900332,
                    b: 0.824586,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.93083,
                    g: 0.906626,
                    b: 0.880405,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.91,
                    g: 0.91,
                    b: 0.91,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.91,
                    g: 0.91,
                    b: 0.91,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.91,
                    g: 0.91,
                    b: 0.91,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.91,
                    g: 0.91,
                    b: 0.91,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.91,
                    g: 0.91,
                    b: 0.91,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.768627,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.912187,
                    g: 0.809062,
                    b: 0.685813,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.825823,
                    g: 0.725652,
                    b: 0.604771,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.740979,
                    g: 0.643993,
                    b: 0.525619,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.657734,
                    g: 0.564205,
                    b: 0.448496,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.576177,
                    g: 0.486431,
                    b: 0.373567,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.496405,
                    g: 0.41084,
                    b: 0.301023,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.418529,
                    g: 0.337641,
                    b: 0.231092,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.768627,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.089198,
                    g: 0.98073,
                    b: 0.853107,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.179723,
                    g: 1.068819,
                    b: 0.939163,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.271521,
                    g: 1.158313,
                    b: 1.026714,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.364544,
                    g: 1.24915,
                    b: 1.115688,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.458747,
                    g: 1.341271,
                    b: 1.206021,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.554089,
                    g: 1.434626,
                    b: 1.297655,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.650532,
                    g: 1.529168,
                    b: 1.390537,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.956142,
                    b: 0.867903,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.92513,
                    b: 0.818265,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.894118,
                    b: 0.768627,
                    a: 1,
                },
                {
                    r: 0.766714,
                    g: 0.654854,
                    b: 0.49713,
                    a: 1,
                },
                {
                    r: 0.533428,
                    g: 0.41559,
                    b: 0.225634,
                    a: 1,
                },
            ],
        },
        {
            name: "black",
            hexRGBString: "#000000",
            hexRGBAString: "#000000ff",
            hexARGBString: "#ff000000",
            webRGBString: "rgb(0,0,0)",
            webRGBAString: "rgba(0,0,0,1)",
            lum: 0,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0,
            },
            xyz: {
                x: 0,
                y: 0,
                z: 0,
            },
            lab: {
                l: 0,
                a: 0,
                b: 0,
            },
            lch: {
                l: 0,
                c: 0,
                h: 0,
            },
            lchToLabResult: {
                l: 0,
                a: 0,
                b: 0,
            },
            labToLCHResult: {
                l: 0,
                c: 0,
                h: 0,
            },
            labToXYZResult: {
                x: 0,
                y: 0,
                z: 0,
            },
            xyzToLABResult: {
                l: 0,
                a: 0,
                b: 0,
            },
            rgbToXYZResult: {
                x: 0,
                y: 0,
                z: 0,
            },
            xyzToRGBResult: {
                r: 0,
                g: 0,
                b: 0,
                a: 1,
            },
            rgbToLABResult: {
                l: 0,
                a: 0,
                b: 0,
            },
            labToRGBResult: {
                r: 0,
                g: 0,
                b: 0,
                a: 1,
            },
            rgbToLCHResult: {
                l: 0,
                c: 0,
                h: 0,
            },
            lchToRGBResult: {
                r: 0,
                g: 0,
                b: 0,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.110339,
                    g: -0.110339,
                    b: -0.110339,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.220677,
                    g: -0.220677,
                    b: -0.220677,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.331016,
                    g: -0.331016,
                    b: -0.331016,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.441355,
                    g: -0.441355,
                    b: -0.441355,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.551694,
                    g: -0.551694,
                    b: -0.551694,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.662032,
                    g: -0.662032,
                    b: -0.662032,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.772371,
                    g: -0.772371,
                    b: -0.772371,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.089998,
                    g: 0.089998,
                    b: 0.089998,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.151222,
                    g: 0.151222,
                    b: 0.151222,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.216329,
                    g: 0.216329,
                    b: 0.216329,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.284742,
                    g: 0.284742,
                    b: 0.284742,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.356042,
                    g: 0.356042,
                    b: 0.356042,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.429915,
                    g: 0.429915,
                    b: 0.429915,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.506116,
                    g: 0.506116,
                    b: 0.506116,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.63,
                    g: 0.63,
                    b: 0.63,
                    a: 1,
                },
                {
                    r: 0.315,
                    g: 0.315,
                    b: 0.315,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "blanchedalmond",
            hexRGBString: "#ffebcd",
            hexRGBAString: "#ffebcdff",
            hexARGBString: "#ffffebcd",
            webRGBString: "rgb(255,235,205)",
            webRGBAString: "rgba(255,235,205,1)",
            lum: 0.850845,
            temp: 4999,
            rgba: {
                r: 1,
                g: 0.921569,
                b: 0.803922,
                a: 1,
            },
            hsl: {
                h: 36.000061,
                s: 1,
                l: 0.901961,
            },
            hsv: {
                h: 36.000061,
                s: 0.196078,
                v: 1,
            },
            xyz: {
                x: 0.819677,
                y: 0.850863,
                z: 0.698512,
            },
            lab: {
                l: 93.920287,
                a: 2.13013,
                b: 17.026125,
            },
            lch: {
                l: 93.920287,
                c: 17.158858,
                h: 82.868806,
            },
            lchToLabResult: {
                l: 93.920287,
                a: 2.13013,
                b: 17.026126,
            },
            labToLCHResult: {
                l: 93.920287,
                c: 17.158857,
                h: 82.868806,
            },
            labToXYZResult: {
                x: 0.819677,
                y: 0.850863,
                z: 0.698512,
            },
            xyzToLABResult: {
                l: 93.920291,
                a: 2.130202,
                b: 17.026152,
            },
            rgbToXYZResult: {
                x: 0.819677,
                y: 0.850863,
                z: 0.698512,
            },
            xyzToRGBResult: {
                r: 1.000001,
                g: 0.921569,
                b: 0.803922,
                a: 1,
            },
            rgbToLABResult: {
                l: 93.920287,
                a: 2.13013,
                b: 17.026125,
            },
            labToRGBResult: {
                r: 1,
                g: 0.921569,
                b: 0.803922,
                a: 1,
            },
            rgbToLCHResult: {
                l: 93.920287,
                c: 17.158858,
                h: 82.868806,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.921569,
                b: 0.803922,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.921569,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.026097,
                    g: 0.917393,
                    b: 0.746287,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.049749,
                    g: 0.913344,
                    b: 0.688191,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.071235,
                    g: 0.909418,
                    b: 0.629368,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.090792,
                    g: 0.905608,
                    b: 0.56943,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.108622,
                    g: 0.90191,
                    b: 0.507786,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.124899,
                    g: 0.898316,
                    b: 0.443479,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.139777,
                    g: 0.894822,
                    b: 0.374811,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.921569,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.971118,
                    g: 0.925878,
                    b: 0.861285,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.93903,
                    g: 0.930325,
                    b: 0.918513,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.931341,
                    g: 0.931341,
                    b: 0.931341,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.931341,
                    g: 0.931341,
                    b: 0.931341,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.931341,
                    g: 0.931341,
                    b: 0.931341,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.931341,
                    g: 0.931341,
                    b: 0.931341,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.931341,
                    g: 0.931341,
                    b: 0.931341,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.921569,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.912445,
                    g: 0.836015,
                    b: 0.720432,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.826363,
                    g: 0.752079,
                    b: 0.638672,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.741832,
                    g: 0.66986,
                    b: 0.558758,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.658936,
                    g: 0.589473,
                    b: 0.480822,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.57777,
                    g: 0.511053,
                    b: 0.40502,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.498442,
                    g: 0.434762,
                    b: 0.331537,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.421076,
                    g: 0.360796,
                    b: 0.260596,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.921569,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.088962,
                    g: 1.008653,
                    b: 0.889043,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.179269,
                    g: 1.097191,
                    b: 0.975709,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.270865,
                    g: 1.187114,
                    b: 1.063841,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.363701,
                    g: 1.278361,
                    b: 1.153371,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.457728,
                    g: 1.370876,
                    b: 1.244236,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.552906,
                    g: 1.46461,
                    b: 1.336382,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.649195,
                    g: 1.559517,
                    b: 1.429756,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.967804,
                    b: 0.880099,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.944686,
                    b: 0.842011,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.921569,
                    b: 0.803922,
                    a: 1,
                },
                {
                    r: 0.763278,
                    g: 0.679009,
                    b: 0.52615,
                    a: 1,
                },
                {
                    r: 0.526556,
                    g: 0.436449,
                    b: 0.248378,
                    a: 1,
                },
            ],
        },
        {
            name: "blue",
            hexRGBString: "#0000ff",
            hexRGBAString: "#0000ffff",
            hexARGBString: "#ff0000ff",
            webRGBString: "rgb(0,0,255)",
            webRGBAString: "rgba(0,0,255,1)",
            lum: 0.0722,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 240,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 240,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.180438,
                y: 0.072175,
                z: 0.950304,
            },
            lab: {
                l: 32.297011,
                a: 79.18752,
                b: -107.860162,
            },
            lch: {
                l: 32.297011,
                c: 133.807615,
                h: 306.284938,
            },
            lchToLabResult: {
                l: 32.297011,
                a: 79.18752,
                b: -107.860162,
            },
            labToLCHResult: {
                l: 32.297011,
                c: 133.807615,
                h: 306.284938,
            },
            labToXYZResult: {
                x: 0.180438,
                y: 0.072175,
                z: 0.950304,
            },
            xyzToLABResult: {
                l: 32.297011,
                a: 79.187785,
                b: -107.860155,
            },
            rgbToXYZResult: {
                x: 0.180438,
                y: 0.072175,
                z: 0.950304,
            },
            xyzToRGBResult: {
                r: 0.000022,
                g: -0.000007,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 32.297011,
                a: 79.18752,
                b: -107.860162,
            },
            labToRGBResult: {
                r: 0.000001,
                g: 0,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 32.297011,
                c: 133.807615,
                h: 306.284938,
            },
            lchToRGBResult: {
                r: 0.000001,
                g: 0,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.251279,
                    g: -0.057977,
                    b: 1.043476,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.531076,
                    g: -0.116084,
                    b: 1.087269,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.840472,
                    g: -0.174271,
                    b: 1.131374,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.180552,
                    g: -0.232486,
                    b: 1.175785,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.552398,
                    g: -0.290678,
                    b: 1.220498,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.957093,
                    g: -0.348796,
                    b: 1.265507,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -2.39572,
                    g: -0.406789,
                    b: 1.310808,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.139703,
                    g: 0.055751,
                    b: 0.956845,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.19841,
                    g: 0.092711,
                    b: 0.914017,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.237307,
                    g: 0.119729,
                    b: 0.871521,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.265725,
                    g: 0.141766,
                    b: 0.82936,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.287221,
                    g: 0.160676,
                    b: 0.787539,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.303604,
                    g: 0.177386,
                    b: 0.746062,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.315942,
                    g: 0.192437,
                    b: 0.704931,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.556665,
                    g: -0.113655,
                    b: 0.91003,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.926518,
                    g: -0.149023,
                    b: 0.82143,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -1.132359,
                    g: -0.128904,
                    b: 0.734295,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.161156,
                    g: -0.119829,
                    b: 0.649033,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.99355,
                    g: -0.196049,
                    b: 0.566383,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.708957,
                    g: -0.332282,
                    b: 0.486723,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.495388,
                    g: -0.46962,
                    b: 0.410368,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.270128,
                    g: 0.136363,
                    b: 1.091267,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.405292,
                    g: 0.228889,
                    b: 1.183771,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.520654,
                    g: 0.314057,
                    b: 1.277457,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.628012,
                    g: 0.39743,
                    b: 1.372282,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.731443,
                    g: 0.480731,
                    b: 1.468204,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.83283,
                    g: 0.564664,
                    b: 1.565187,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.933186,
                    g: 0.649548,
                    b: 1.663198,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.617915,
                    g: 0.625707,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.308957,
                    g: 0.312854,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.78486,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.569719,
                    a: 1,
                },
            ],
        },
        {
            name: "blueviolet",
            hexRGBString: "#8a2be2",
            hexRGBAString: "#8a2be2ff",
            hexARGBString: "#ff8a2be2",
            webRGBString: "rgb(138,43,226)",
            webRGBAString: "rgba(138,43,226,1)",
            lum: 0.12622,
            temp: 40000,
            rgba: {
                r: 0.541176,
                g: 0.168627,
                b: 0.886275,
                a: 1,
            },
            hsl: {
                h: 271.147498,
                s: 0.759337,
                l: 0.527451,
            },
            hsv: {
                h: 271.147498,
                s: 0.809735,
                v: 0.886275,
            },
            xyz: {
                x: 0.250692,
                y: 0.126218,
                z: 0.730524,
            },
            lab: {
                l: 42.187835,
                a: 69.844848,
                b: -74.763476,
            },
            lch: {
                l: 42.187835,
                c: 102.312659,
                h: 313.051924,
            },
            lchToLabResult: {
                l: 42.187835,
                a: 69.844848,
                b: -74.763476,
            },
            labToLCHResult: {
                l: 42.187835,
                c: 102.312659,
                h: 313.051924,
            },
            labToXYZResult: {
                x: 0.250692,
                y: 0.126218,
                z: 0.730524,
            },
            xyzToLABResult: {
                l: 42.187775,
                a: 69.845137,
                b: -74.763611,
            },
            rgbToXYZResult: {
                x: 0.250692,
                y: 0.126218,
                z: 0.730524,
            },
            xyzToRGBResult: {
                r: 0.541177,
                g: 0.168624,
                b: 0.886275,
                a: 1,
            },
            rgbToLABResult: {
                l: 42.187835,
                a: 69.844848,
                b: -74.763476,
            },
            labToRGBResult: {
                r: 0.541176,
                g: 0.168627,
                b: 0.886275,
                a: 1,
            },
            rgbToLCHResult: {
                l: 42.187835,
                c: 102.312659,
                h: 313.051924,
            },
            lchToRGBResult: {
                r: 0.541176,
                g: 0.168627,
                b: 0.886275,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.541176,
                    g: 0.168627,
                    b: 0.886275,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.545421,
                    g: 0.128432,
                    b: 0.925222,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.548664,
                    g: 0.067235,
                    b: 0.964416,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.550877,
                    g: -0.050177,
                    b: 1.003856,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.552028,
                    g: -0.176247,
                    b: 1.04354,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.552075,
                    g: -0.304978,
                    b: 1.083468,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.550972,
                    g: -0.436374,
                    b: 1.123636,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.548658,
                    g: -0.570441,
                    b: 1.164043,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.541176,
                    g: 0.168627,
                    b: 0.886275,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.535949,
                    g: 0.199969,
                    b: 0.847575,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.529754,
                    g: 0.226104,
                    b: 0.80912,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.522601,
                    g: 0.248704,
                    b: 0.77091,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.514493,
                    g: 0.268698,
                    b: 0.732942,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.505426,
                    g: 0.286666,
                    b: 0.69521,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.495392,
                    g: 0.302995,
                    b: 0.657708,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.484373,
                    g: 0.317962,
                    b: 0.620424,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.541176,
                    g: 0.168627,
                    b: 0.886275,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.450403,
                    g: 0.045376,
                    b: 0.799268,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.358096,
                    g: -0.109976,
                    b: 0.713743,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.261451,
                    g: -0.177541,
                    b: 0.629788,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.151022,
                    g: -0.179852,
                    b: 0.547508,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.03015,
                    g: -0.159883,
                    b: 0.467243,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.102265,
                    g: -0.216048,
                    b: 0.390282,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.029895,
                    g: -0.334558,
                    b: 0.317521,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.541176,
                    g: 0.168627,
                    b: 0.886275,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.631593,
                    g: 0.26037,
                    b: 0.974691,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.722233,
                    g: 0.346153,
                    b: 1.064453,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.81341,
                    g: 0.430373,
                    b: 1.155503,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.905303,
                    g: 0.514544,
                    b: 1.247791,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.998014,
                    g: 0.599313,
                    b: 1.341271,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.091602,
                    g: 0.684989,
                    b: 1.4359,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.186101,
                    g: 0.771723,
                    b: 1.531641,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.841713,
                    g: 0.682435,
                    b: 0.992682,
                    a: 1,
                },
                {
                    r: 0.691445,
                    g: 0.425531,
                    b: 0.939478,
                    a: 1,
                },
                {
                    r: 0.541176,
                    g: 0.168627,
                    b: 0.886275,
                    a: 1,
                },
                {
                    r: 0.369755,
                    g: 0.084314,
                    b: 0.692279,
                    a: 1,
                },
                {
                    r: 0.198334,
                    g: 0,
                    b: 0.498283,
                    a: 1,
                },
            ],
        },
        {
            name: "brown",
            hexRGBString: "#a52a2a",
            hexRGBAString: "#a52a2aff",
            hexARGBString: "#ffa52a2a",
            webRGBString: "rgb(165,42,42)",
            webRGBAString: "rgba(165,42,42,1)",
            lum: 0.098224,
            temp: 2431,
            rgba: {
                r: 0.647059,
                g: 0.164706,
                b: 0.164706,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0.594203,
                l: 0.405883,
            },
            hsv: {
                h: 0,
                s: 0.745454,
                v: 0.647059,
            },
            xyz: {
                x: 0.167649,
                y: 0.09825,
                z: 0.032037,
            },
            lab: {
                l: 37.526518,
                a: 49.690351,
                b: 30.543166,
            },
            lch: {
                l: 37.526518,
                c: 58.326803,
                h: 31.577793,
            },
            lchToLabResult: {
                l: 37.526518,
                a: 49.690351,
                b: 30.543166,
            },
            labToLCHResult: {
                l: 37.526518,
                c: 58.326803,
                h: 31.577793,
            },
            labToXYZResult: {
                x: 0.167649,
                y: 0.09825,
                z: 0.032037,
            },
            xyzToLABResult: {
                l: 37.526499,
                a: 49.690624,
                b: 30.543188,
            },
            rgbToXYZResult: {
                x: 0.167649,
                y: 0.09825,
                z: 0.032037,
            },
            xyzToRGBResult: {
                r: 0.64706,
                g: 0.164704,
                b: 0.164706,
                a: 1,
            },
            rgbToLABResult: {
                l: 37.526518,
                a: 49.690351,
                b: 30.543166,
            },
            labToRGBResult: {
                r: 0.647059,
                g: 0.164706,
                b: 0.164706,
                a: 1,
            },
            rgbToLCHResult: {
                l: 37.526518,
                c: 58.326803,
                h: 31.577793,
            },
            lchToRGBResult: {
                r: 0.647059,
                g: 0.164706,
                b: 0.164706,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.647059,
                    g: 0.164706,
                    b: 0.164706,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.678732,
                    g: 0.107422,
                    b: 0.140993,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.709599,
                    g: -0.016054,
                    b: 0.117162,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.739805,
                    g: -0.183846,
                    b: 0.093045,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.76947,
                    g: -0.358689,
                    b: 0.068328,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.798691,
                    g: -0.540775,
                    b: 0.042324,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.827618,
                    g: -0.730425,
                    b: 0.0146,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.856378,
                    g: -0.927968,
                    b: -0.012724,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.647059,
                    g: 0.164706,
                    b: 0.164706,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.614396,
                    g: 0.204712,
                    b: 0.188401,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.580507,
                    g: 0.23625,
                    b: 0.212139,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.545082,
                    g: 0.262499,
                    b: 0.23596,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.507704,
                    g: 0.285036,
                    b: 0.259891,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.467779,
                    g: 0.30478,
                    b: 0.283951,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.424428,
                    g: 0.322322,
                    b: 0.308152,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.376238,
                    g: 0.338068,
                    b: 0.332502,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.647059,
                    g: 0.164706,
                    b: 0.164706,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.556024,
                    g: 0.060325,
                    b: 0.101,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.466187,
                    g: -0.070456,
                    b: 0.032281,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.380563,
                    g: -0.128009,
                    b: -0.069991,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.301939,
                    g: -0.133158,
                    b: -0.183821,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.247048,
                    g: -0.181818,
                    b: -0.297701,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.221651,
                    g: -0.288655,
                    b: -0.408241,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.195486,
                    g: -0.398993,
                    b: -0.518579,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.647059,
                    g: 0.164706,
                    b: 0.164706,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.738956,
                    g: 0.250331,
                    b: 0.231678,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.831742,
                    g: 0.332296,
                    b: 0.301582,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.925432,
                    g: 0.4137,
                    b: 0.374125,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.020036,
                    g: 0.495622,
                    b: 0.449067,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.115555,
                    g: 0.578512,
                    b: 0.526208,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.211986,
                    g: 0.66257,
                    b: 0.605382,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.309324,
                    g: 0.747881,
                    b: 0.686447,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.913223,
                    g: 0.673997,
                    b: 0.675828,
                    a: 1,
                },
                {
                    r: 0.780141,
                    g: 0.419351,
                    b: 0.420267,
                    a: 1,
                },
                {
                    r: 0.647059,
                    g: 0.164706,
                    b: 0.164706,
                    a: 1,
                },
                {
                    r: 0.494706,
                    g: 0.082353,
                    b: 0.082353,
                    a: 1,
                },
                {
                    r: 0.342352,
                    g: 0,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "burlywood",
            hexRGBString: "#deb887",
            hexRGBAString: "#deb887ff",
            hexARGBString: "#ffdeb887",
            webRGBString: "rgb(222,184,135)",
            webRGBAString: "rgba(222,184,135,1)",
            lum: 0.515599,
            temp: 3824,
            rgba: {
                r: 0.870588,
                g: 0.721569,
                b: 0.529412,
                a: 1,
            },
            hsl: {
                h: 33.793174,
                s: 0.568627,
                l: 0.7,
            },
            hsv: {
                h: 33.793174,
                s: 0.391891,
                v: 0.870588,
            },
            xyz: {
                x: 0.516393,
                y: 0.515623,
                z: 0.301495,
            },
            lab: {
                l: 77.018378,
                a: 7.049858,
                b: 30.018846,
            },
            lch: {
                l: 77.018378,
                c: 30.835557,
                h: 76.783717,
            },
            lchToLabResult: {
                l: 77.018378,
                a: 7.049858,
                b: 30.018845,
            },
            labToLCHResult: {
                l: 77.018378,
                c: 30.835558,
                h: 76.783717,
            },
            labToXYZResult: {
                x: 0.516393,
                y: 0.515623,
                z: 0.301495,
            },
            xyzToLABResult: {
                l: 77.018375,
                a: 7.049789,
                b: 30.018814,
            },
            rgbToXYZResult: {
                x: 0.516393,
                y: 0.515623,
                z: 0.301495,
            },
            xyzToRGBResult: {
                r: 0.870587,
                g: 0.721569,
                b: 0.529412,
                a: 1,
            },
            rgbToLABResult: {
                l: 77.018378,
                a: 7.049858,
                b: 30.018846,
            },
            labToRGBResult: {
                r: 0.870588,
                g: 0.721569,
                b: 0.529412,
                a: 1,
            },
            rgbToLCHResult: {
                l: 77.018378,
                c: 30.835557,
                h: 76.783717,
            },
            lchToRGBResult: {
                r: 0.870588,
                g: 0.721569,
                b: 0.529412,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.870588,
                    g: 0.721569,
                    b: 0.529412,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.894598,
                    g: 0.715759,
                    b: 0.473906,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.916489,
                    g: 0.710009,
                    b: 0.416953,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.936533,
                    g: 0.704314,
                    b: 0.357594,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.954957,
                    g: 0.698662,
                    b: 0.294032,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.971959,
                    g: 0.693047,
                    b: 0.22224,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.98771,
                    g: 0.687459,
                    b: 0.129004,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.00236,
                    g: 0.681888,
                    b: -0.078159,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.870588,
                    g: 0.721569,
                    b: 0.529412,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.844132,
                    g: 0.727448,
                    b: 0.58404,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.814825,
                    g: 0.733404,
                    b: 0.63815,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.782154,
                    g: 0.739443,
                    b: 0.691983,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.745555,
                    g: 0.745555,
                    b: 0.745555,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.745555,
                    g: 0.745555,
                    b: 0.745555,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.745555,
                    g: 0.745555,
                    b: 0.745555,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.745555,
                    g: 0.745555,
                    b: 0.745555,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.870588,
                    g: 0.721569,
                    b: 0.529412,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.783677,
                    g: 0.640026,
                    b: 0.451576,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.698199,
                    g: 0.560363,
                    b: 0.375776,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.614213,
                    g: 0.482724,
                    b: 0.302127,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.531785,
                    g: 0.407282,
                    b: 0.230711,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.450982,
                    g: 0.334245,
                    b: 0.161473,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.371879,
                    g: 0.263878,
                    b: 0.093786,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.294843,
                    g: 0.196483,
                    b: 0.021421,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.870588,
                    g: 0.721569,
                    b: 0.529412,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.958874,
                    g: 0.804871,
                    b: 0.609166,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.048483,
                    g: 0.889826,
                    b: 0.690727,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.139366,
                    g: 0.976343,
                    b: 0.773996,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.231477,
                    g: 1.064341,
                    b: 0.858881,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.324775,
                    g: 1.15375,
                    b: 0.945301,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.419219,
                    g: 1.244505,
                    b: 1.033183,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.514772,
                    g: 1.33655,
                    b: 1.122461,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.977188,
                    g: 0.892792,
                    b: 0.779652,
                    a: 1,
                },
                {
                    r: 0.923888,
                    g: 0.807181,
                    b: 0.654532,
                    a: 1,
                },
                {
                    r: 0.870588,
                    g: 0.721569,
                    b: 0.529412,
                    a: 1,
                },
                {
                    r: 0.660546,
                    g: 0.513028,
                    b: 0.27926,
                    a: 1,
                },
                {
                    r: 0.450504,
                    g: 0.304487,
                    b: 0.029107,
                    a: 1,
                },
            ],
        },
        {
            name: "cadetblue",
            hexRGBString: "#5f9ea0",
            hexRGBAString: "#5f9ea0ff",
            hexARGBString: "#ff5f9ea0",
            webRGBString: "rgb(95,158,160)",
            webRGBAString: "rgba(95,158,160,1)",
            lum: 0.294247,
            temp: 40000,
            rgba: {
                r: 0.372549,
                g: 0.619608,
                b: 0.627451,
                a: 1,
            },
            hsl: {
                h: 181.846121,
                s: 0.254902,
                l: 0.5,
            },
            hsv: {
                h: 181.846121,
                s: 0.40625,
                v: 0.627451,
            },
            xyz: {
                x: 0.23289,
                y: 0.29423,
                z: 0.377029,
            },
            lab: {
                l: 61.15316,
                a: -19.679465,
                b: -7.420765,
            },
            lch: {
                l: 61.15316,
                c: 21.032096,
                h: 200.660538,
            },
            lchToLabResult: {
                l: 61.15316,
                a: -19.679464,
                b: -7.420765,
            },
            labToLCHResult: {
                l: 61.15316,
                c: 21.032097,
                h: 200.660539,
            },
            labToXYZResult: {
                x: 0.23289,
                y: 0.29423,
                z: 0.377029,
            },
            xyzToLABResult: {
                l: 61.153146,
                a: -19.679298,
                b: -7.420806,
            },
            rgbToXYZResult: {
                x: 0.23289,
                y: 0.29423,
                z: 0.377029,
            },
            xyzToRGBResult: {
                r: 0.37255,
                g: 0.619608,
                b: 0.627451,
                a: 1,
            },
            rgbToLABResult: {
                l: 61.15316,
                a: -19.679465,
                b: -7.420765,
            },
            labToRGBResult: {
                r: 0.372549,
                g: 0.619608,
                b: 0.627451,
                a: 1,
            },
            rgbToLCHResult: {
                l: 61.15316,
                c: 21.032096,
                h: 200.660538,
            },
            lchToRGBResult: {
                r: 0.372549,
                g: 0.619608,
                b: 0.627451,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.372549,
                    g: 0.619608,
                    b: 0.627451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.253426,
                    g: 0.632742,
                    b: 0.645518,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.103305,
                    g: 0.645012,
                    b: 0.663675,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.857774,
                    g: 0.656492,
                    b: 0.681919,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.589053,
                    g: 0.667245,
                    b: 0.700246,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -2.297965,
                    g: 0.677327,
                    b: 0.718653,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -2.985335,
                    g: 0.686787,
                    b: 0.737138,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -3.651987,
                    g: 0.69567,
                    b: 0.755699,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.372549,
                    g: 0.619608,
                    b: 0.627451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.459677,
                    g: 0.605526,
                    b: 0.609478,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.531948,
                    g: 0.590396,
                    b: 0.591603,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.578683,
                    g: 0.578683,
                    b: 0.578683,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.578683,
                    g: 0.578683,
                    b: 0.578683,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.578683,
                    g: 0.578683,
                    b: 0.578683,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.578683,
                    g: 0.578683,
                    b: 0.578683,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.578683,
                    g: 0.578683,
                    b: 0.578683,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.372549,
                    g: 0.619608,
                    b: 0.627451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.292431,
                    g: 0.539946,
                    b: 0.548039,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.211469,
                    g: 0.462271,
                    b: 0.470668,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.125287,
                    g: 0.38674,
                    b: 0.395515,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.008037,
                    g: 0.313542,
                    b: 0.322794,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.081674,
                    g: 0.242902,
                    b: 0.25278,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.105822,
                    g: 0.175101,
                    b: 0.185826,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.136286,
                    g: 0.116724,
                    b: 0.122103,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.372549,
                    g: 0.619608,
                    b: 0.627451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.453164,
                    g: 0.701124,
                    b: 0.708759,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.534794,
                    g: 0.784378,
                    b: 0.791838,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.617658,
                    g: 0.86927,
                    b: 0.876582,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.701842,
                    g: 0.955714,
                    b: 0.962897,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.78737,
                    g: 1.043631,
                    b: 1.050704,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.874235,
                    g: 1.132951,
                    b: 1.139928,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.962414,
                    g: 1.223613,
                    b: 1.230506,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.70566,
                    g: 0.872564,
                    b: 0.878488,
                    a: 1,
                },
                {
                    r: 0.539104,
                    g: 0.746086,
                    b: 0.75297,
                    a: 1,
                },
                {
                    r: 0.372549,
                    g: 0.619608,
                    b: 0.627451,
                    a: 1,
                },
                {
                    r: 0.186275,
                    g: 0.445716,
                    b: 0.460249,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.271823,
                    b: 0.293046,
                    a: 1,
                },
            ],
        },
        {
            name: "chartreuse",
            hexRGBString: "#7fff00",
            hexRGBAString: "#7fff00ff",
            hexARGBString: "#ff7fff00",
            webRGBString: "rgb(127,255,0)",
            webRGBAString: "rgba(127,255,0,1)",
            lum: 0.76032,
            temp: 1000,
            rgba: {
                r: 0.498039,
                g: 1,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 90.11766,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 90.11766,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.445112,
                y: 0.760288,
                z: 0.123295,
            },
            lab: {
                l: 89.872706,
                a: -68.066144,
                b: 85.779991,
            },
            lch: {
                l: 89.872706,
                c: 109.504369,
                h: 128.431886,
            },
            lchToLabResult: {
                l: 89.872706,
                a: -68.066144,
                b: 85.779991,
            },
            labToLCHResult: {
                l: 89.872706,
                c: 109.504369,
                h: 128.431886,
            },
            labToXYZResult: {
                x: 0.445112,
                y: 0.760288,
                z: 0.123295,
            },
            xyzToLABResult: {
                l: 89.872711,
                a: -68.066153,
                b: 85.780064,
            },
            rgbToXYZResult: {
                x: 0.445112,
                y: 0.760288,
                z: 0.123295,
            },
            xyzToRGBResult: {
                r: 0.498039,
                g: 1,
                b: -0.000004,
                a: 1,
            },
            rgbToLABResult: {
                l: 89.872706,
                a: -68.066144,
                b: 85.779991,
            },
            labToRGBResult: {
                r: 0.498039,
                g: 1,
                b: -0.000001,
                a: 1,
            },
            rgbToLCHResult: {
                l: 89.872706,
                c: 109.504369,
                h: 128.431886,
            },
            lchToRGBResult: {
                r: 0.498039,
                g: 1,
                b: -0.000001,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.498039,
                    g: 1,
                    b: -0.000001,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.449528,
                    g: 1.006515,
                    b: -0.307955,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.393342,
                    g: 1.012856,
                    b: -0.578668,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.325058,
                    g: 1.019023,
                    b: -0.814605,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.233131,
                    g: 1.025021,
                    b: -1.018231,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.034562,
                    g: 1.030853,
                    b: -1.192011,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.501076,
                    g: 1.03652,
                    b: -1.338411,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.032547,
                    g: 1.042026,
                    b: -1.459896,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.498039,
                    g: 1,
                    b: -0.000001,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.541106,
                    g: 0.993306,
                    b: 0.178906,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.580033,
                    g: 0.986429,
                    b: 0.264982,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.615657,
                    g: 0.979367,
                    b: 0.333097,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.648548,
                    g: 0.972114,
                    b: 0.392952,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.679115,
                    g: 0.964668,
                    b: 0.44808,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.707659,
                    g: 0.957022,
                    b: 0.500203,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.734412,
                    g: 0.949173,
                    b: 0.550297,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.498039,
                    g: 1,
                    b: -0.000001,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.398502,
                    g: 0.911405,
                    b: -0.271841,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.291118,
                    g: 0.824169,
                    b: -0.42531,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.159081,
                    g: 0.738343,
                    b: -0.483207,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.14766,
                    g: 0.653977,
                    b: -0.468331,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.406372,
                    g: 0.571048,
                    b: -0.429475,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.502476,
                    g: 0.489437,
                    b: -0.422036,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.470621,
                    g: 0.409102,
                    b: -0.443682,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.498039,
                    g: 1,
                    b: -0.000001,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.59428,
                    g: 1.089906,
                    b: 0.196311,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.689103,
                    g: 1.181075,
                    b: 0.306749,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.783442,
                    g: 1.273465,
                    b: 0.404071,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.877815,
                    g: 1.367035,
                    b: 0.496781,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.972525,
                    g: 1.461744,
                    b: 0.587713,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.067761,
                    g: 1.557558,
                    b: 0.678123,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.163641,
                    g: 1.654442,
                    b: 0.76865,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.794574,
                    g: 1,
                    b: 0.5892,
                    a: 1,
                },
                {
                    r: 0.646306,
                    g: 1,
                    b: 0.2946,
                    a: 1,
                },
                {
                    r: 0.498039,
                    g: 1,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.254678,
                    g: 0.750213,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.011317,
                    g: 0.500425,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "chocolate",
            hexRGBString: "#d2691e",
            hexRGBAString: "#d2691eff",
            hexARGBString: "#ffd2691e",
            webRGBString: "rgb(210,105,30)",
            webRGBAString: "rgba(210,105,30,1)",
            lum: 0.238985,
            temp: 2142,
            rgba: {
                r: 0.823529,
                g: 0.411765,
                b: 0.117647,
                a: 1,
            },
            hsl: {
                h: 25.000043,
                s: 0.75,
                l: 0.470588,
            },
            hsv: {
                h: 25.000043,
                s: 0.857143,
                v: 0.823529,
            },
            xyz: {
                x: 0.318675,
                y: 0.239025,
                z: 0.041636,
            },
            lab: {
                l: 55.990059,
                a: 37.052571,
                b: 56.740708,
            },
            lch: {
                l: 55.990059,
                c: 67.767256,
                h: 56.854835,
            },
            lchToLabResult: {
                l: 55.990059,
                a: 37.05257,
                b: 56.740709,
            },
            labToLCHResult: {
                l: 55.990059,
                c: 67.767256,
                h: 56.854834,
            },
            labToXYZResult: {
                x: 0.318675,
                y: 0.239025,
                z: 0.041636,
            },
            xyzToLABResult: {
                l: 55.990043,
                a: 37.052806,
                b: 56.740459,
            },
            rgbToXYZResult: {
                x: 0.318675,
                y: 0.239025,
                z: 0.041636,
            },
            xyzToRGBResult: {
                r: 0.82353,
                g: 0.411764,
                b: 0.11765,
                a: 1,
            },
            rgbToLABResult: {
                l: 55.990059,
                a: 37.052571,
                b: 56.740708,
            },
            labToRGBResult: {
                r: 0.823529,
                g: 0.411765,
                b: 0.117647,
                a: 1,
            },
            rgbToLCHResult: {
                l: 55.990059,
                c: 67.767256,
                h: 56.854835,
            },
            lchToRGBResult: {
                r: 0.823529,
                g: 0.411765,
                b: 0.117647,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.823529,
                    g: 0.411765,
                    b: 0.117647,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.847762,
                    g: 0.395046,
                    b: 0.027813,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.871059,
                    g: 0.377117,
                    b: -0.083558,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.893568,
                    g: 0.35775,
                    b: -0.169377,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.915419,
                    g: 0.33664,
                    b: -0.232648,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.936874,
                    g: 0.313315,
                    b: -0.285053,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.95815,
                    g: 0.287099,
                    b: -0.337237,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.97926,
                    g: 0.257007,
                    b: -0.389204,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.823529,
                    g: 0.411765,
                    b: 0.117647,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.798185,
                    g: 0.427451,
                    b: 0.176525,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.771524,
                    g: 0.442246,
                    b: 0.227152,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.743293,
                    g: 0.456263,
                    b: 0.274091,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.713185,
                    g: 0.469598,
                    b: 0.319101,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.680807,
                    g: 0.482329,
                    b: 0.363042,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.645649,
                    g: 0.494525,
                    b: 0.406397,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.607024,
                    g: 0.506244,
                    b: 0.449459,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.823529,
                    g: 0.411765,
                    b: 0.117647,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.729623,
                    g: 0.334777,
                    b: 0.014987,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.636677,
                    g: 0.259102,
                    b: -0.058502,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.546156,
                    g: 0.183535,
                    b: -0.114881,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.459921,
                    g: 0.104093,
                    b: -0.191735,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.379422,
                    g: 0.003964,
                    b: -0.285619,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.30719,
                    g: -0.05903,
                    b: -0.393088,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.253465,
                    g: -0.10991,
                    b: -0.506669,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.823529,
                    g: 0.411765,
                    b: 0.117647,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.918358,
                    g: 0.490318,
                    b: 0.198735,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.014092,
                    g: 0.5705,
                    b: 0.276442,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.110717,
                    g: 0.652304,
                    b: 0.354111,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.208222,
                    g: 0.735689,
                    b: 0.432741,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.306598,
                    g: 0.820603,
                    b: 0.512696,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.405834,
                    g: 0.906989,
                    b: 0.594106,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.505918,
                    g: 0.994791,
                    b: 0.677002,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.965762,
                    g: 0.773613,
                    b: 0.632788,
                    a: 1,
                },
                {
                    r: 0.894645,
                    g: 0.592689,
                    b: 0.375217,
                    a: 1,
                },
                {
                    r: 0.823529,
                    g: 0.411765,
                    b: 0.117647,
                    a: 1,
                },
                {
                    r: 0.629551,
                    g: 0.246765,
                    b: 0.058824,
                    a: 1,
                },
                {
                    r: 0.435573,
                    g: 0.081765,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "coral",
            hexRGBString: "#ff7f50",
            hexRGBAString: "#ff7f50ff",
            hexARGBString: "#ffff7f50",
            webRGBString: "rgb(255,127,80)",
            webRGBAString: "rgba(255,127,80,1)",
            lum: 0.370179,
            temp: 2610,
            rgba: {
                r: 1,
                g: 0.498039,
                b: 0.313725,
                a: 1,
            },
            hsl: {
                h: 16.114298,
                s: 1,
                l: 0.656863,
            },
            hsv: {
                h: 16.114298,
                s: 0.686275,
                v: 1,
            },
            xyz: {
                x: 0.50282,
                y: 0.37024,
                z: 0.120863,
            },
            lab: {
                l: 67.295025,
                a: 45.354311,
                b: 47.493423,
            },
            lch: {
                l: 67.295025,
                c: 65.670684,
                h: 46.3198,
            },
            lchToLabResult: {
                l: 67.295025,
                a: 45.354311,
                b: 47.493423,
            },
            labToLCHResult: {
                l: 67.295025,
                c: 65.670684,
                h: 46.3198,
            },
            labToXYZResult: {
                x: 0.50282,
                y: 0.37024,
                z: 0.120863,
            },
            xyzToLABResult: {
                l: 67.295032,
                a: 45.354387,
                b: 47.493453,
            },
            rgbToXYZResult: {
                x: 0.50282,
                y: 0.37024,
                z: 0.120863,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.498039,
                b: 0.313725,
                a: 1,
            },
            rgbToLABResult: {
                l: 67.295025,
                a: 45.354311,
                b: 47.493423,
            },
            labToRGBResult: {
                r: 1,
                g: 0.498039,
                b: 0.313725,
                a: 1,
            },
            rgbToLCHResult: {
                l: 67.295025,
                c: 65.670684,
                h: 46.3198,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.498039,
                b: 0.313725,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.498039,
                    b: 0.313725,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.032337,
                    g: 0.475301,
                    b: 0.272507,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.063612,
                    g: 0.450593,
                    b: 0.229235,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.093968,
                    g: 0.423495,
                    b: 0.182345,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.123526,
                    g: 0.393412,
                    b: 0.128068,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.152391,
                    g: 0.359457,
                    b: 0.051079,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.180654,
                    g: 0.320202,
                    b: -0.064758,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.208394,
                    g: 0.273057,
                    b: -0.159475,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.498039,
                    b: 0.313725,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.966433,
                    g: 0.51912,
                    b: 0.353693,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.931431,
                    g: 0.538783,
                    b: 0.392878,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.894748,
                    g: 0.557216,
                    b: 0.431571,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.856073,
                    g: 0.574569,
                    b: 0.469967,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.815013,
                    g: 0.590967,
                    b: 0.508197,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.771051,
                    g: 0.606512,
                    b: 0.546358,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.723489,
                    g: 0.621291,
                    b: 0.584517,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.498039,
                    b: 0.313725,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.904253,
                    g: 0.41737,
                    b: 0.239912,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.80937,
                    g: 0.337668,
                    b: 0.16726,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.715354,
                    g: 0.25825,
                    b: 0.093729,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.622216,
                    g: 0.177222,
                    b: 0.012701,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.531045,
                    g: 0.086513,
                    b: -0.057872,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.444102,
                    g: -0.035951,
                    b: -0.146226,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.362952,
                    g: -0.100201,
                    b: -0.249467,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.498039,
                    b: 0.313725,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.09661,
                    g: 0.57995,
                    b: 0.389217,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.19408,
                    g: 0.663211,
                    b: 0.466514,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.292404,
                    g: 0.747853,
                    b: 0.54561,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.391577,
                    g: 0.833872,
                    b: 0.626452,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.491589,
                    g: 0.921243,
                    b: 0.708973,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.592433,
                    g: 1.009933,
                    b: 0.7931,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.694097,
                    g: 1.099905,
                    b: 0.878763,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.801292,
                    b: 0.713109,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.649665,
                    b: 0.513417,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.498039,
                    b: 0.313725,
                    a: 1,
                },
                {
                    r: 0.77341,
                    g: 0.296348,
                    b: 0.156863,
                    a: 1,
                },
                {
                    r: 0.54682,
                    g: 0.094656,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "cornflowerblue",
            hexRGBString: "#6495ed",
            hexRGBAString: "#6495edff",
            hexARGBString: "#ff6495ed",
            webRGBString: "rgb(100,149,237)",
            webRGBAString: "rgba(100,149,237,1)",
            lum: 0.303187,
            temp: 40000,
            rgba: {
                r: 0.392157,
                g: 0.584314,
                b: 0.929412,
                a: 1,
            },
            hsl: {
                h: 218.540135,
                s: 0.791908,
                l: 0.660785,
            },
            hsv: {
                h: 218.540135,
                s: 0.578059,
                v: 0.929412,
            },
            xyz: {
                x: 0.312838,
                y: 0.30316,
                z: 0.843074,
            },
            lab: {
                l: 61.925962,
                a: 9.332984,
                b: -49.298101,
            },
            lch: {
                l: 61.925962,
                c: 50.173771,
                h: 280.72021,
            },
            lchToLabResult: {
                l: 61.925962,
                a: 9.332984,
                b: -49.2981,
            },
            labToLCHResult: {
                l: 61.925962,
                c: 50.173772,
                h: 280.72021,
            },
            labToXYZResult: {
                x: 0.312838,
                y: 0.30316,
                z: 0.843074,
            },
            xyzToLABResult: {
                l: 61.925923,
                a: 9.333263,
                b: -49.298175,
            },
            rgbToXYZResult: {
                x: 0.312838,
                y: 0.30316,
                z: 0.843074,
            },
            xyzToRGBResult: {
                r: 0.392159,
                g: 0.584313,
                b: 0.929412,
                a: 1,
            },
            rgbToLABResult: {
                l: 61.925962,
                a: 9.332984,
                b: -49.298101,
            },
            labToRGBResult: {
                r: 0.392157,
                g: 0.584314,
                b: 0.929412,
                a: 1,
            },
            rgbToLCHResult: {
                l: 61.925962,
                c: 50.173771,
                h: 280.72021,
            },
            lchToRGBResult: {
                r: 0.392157,
                g: 0.584314,
                b: 0.929412,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.392157,
                    g: 0.584314,
                    b: 0.929412,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.324415,
                    g: 0.584954,
                    b: 0.983137,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.220989,
                    g: 0.585894,
                    b: 1.03721,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.134477,
                    g: 0.587146,
                    b: 1.09164,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.847077,
                    g: 0.588721,
                    b: 1.146435,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.622956,
                    g: 0.590626,
                    b: 1.201596,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -2.464399,
                    g: 0.592872,
                    b: 1.257128,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -3.37369,
                    g: 0.595466,
                    b: 1.313028,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.392157,
                    g: 0.584314,
                    b: 0.929412,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.442682,
                    g: 0.583963,
                    b: 0.87602,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.482375,
                    g: 0.583889,
                    b: 0.822941,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.514356,
                    g: 0.584078,
                    b: 0.770145,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.540434,
                    g: 0.584518,
                    b: 0.717592,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.561768,
                    g: 0.585195,
                    b: 0.665225,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.579163,
                    g: 0.586094,
                    b: 0.612963,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.586627,
                    g: 0.586627,
                    b: 0.586627,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.392157,
                    g: 0.584314,
                    b: 0.929412,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.297139,
                    g: 0.506582,
                    b: 0.842815,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.190626,
                    g: 0.43111,
                    b: 0.757738,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.012391,
                    g: 0.358148,
                    b: 0.674264,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.230412,
                    g: 0.288027,
                    b: 0.592487,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.360264,
                    g: 0.221219,
                    b: 0.512517,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.399965,
                    g: 0.158451,
                    b: 0.434482,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.372309,
                    g: 0.10099,
                    b: 0.358542,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.392157,
                    g: 0.584314,
                    b: 0.929412,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.48323,
                    g: 0.664111,
                    b: 1.017456,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.572895,
                    g: 0.745815,
                    b: 1.106882,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.66227,
                    g: 0.829294,
                    b: 1.19763,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.751925,
                    g: 0.914438,
                    b: 1.289646,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.842168,
                    g: 1.001151,
                    b: 1.382882,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.933177,
                    g: 1.08935,
                    b: 1.477294,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.025052,
                    g: 1.17896,
                    b: 1.572839,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.745911,
                    g: 0.847919,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.569034,
                    g: 0.716116,
                    b: 0.964706,
                    a: 1,
                },
                {
                    r: 0.392157,
                    g: 0.584314,
                    b: 0.929412,
                    a: 1,
                },
                {
                    r: 0.196079,
                    g: 0.404846,
                    b: 0.740324,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.225378,
                    b: 0.551236,
                    a: 1,
                },
            ],
        },
        {
            name: "cornsilk",
            hexRGBString: "#fff8dc",
            hexRGBAString: "#fff8dcff",
            hexARGBString: "#fffff8dc",
            webRGBString: "rgb(255,248,220)",
            webRGBAString: "rgba(255,248,220,1)",
            lum: 0.935621,
            temp: 5418,
            rgba: {
                r: 1,
                g: 0.972549,
                b: 0.862745,
                a: 1,
            },
            hsl: {
                h: 48,
                s: 1,
                l: 0.931372,
            },
            hsv: {
                h: 48,
                s: 0.137255,
                v: 1,
            },
            xyz: {
                x: 0.877246,
                y: 0.935631,
                z: 0.811344,
            },
            lab: {
                l: 97.455674,
                a: -2.217674,
                b: 14.293535,
            },
            lch: {
                l: 97.455674,
                c: 14.464551,
                h: 98.819251,
            },
            lchToLabResult: {
                l: 97.455674,
                a: -2.217674,
                b: 14.293536,
            },
            labToLCHResult: {
                l: 97.455674,
                c: 14.46455,
                h: 98.819251,
            },
            labToXYZResult: {
                x: 0.877246,
                y: 0.935631,
                z: 0.811344,
            },
            xyzToLABResult: {
                l: 97.455666,
                a: -2.217617,
                b: 14.293523,
            },
            rgbToXYZResult: {
                x: 0.877246,
                y: 0.935631,
                z: 0.811344,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.972549,
                b: 0.862745,
                a: 1,
            },
            rgbToLABResult: {
                l: 97.455674,
                a: -2.217674,
                b: 14.293535,
            },
            labToRGBResult: {
                r: 1,
                g: 0.972549,
                b: 0.862745,
                a: 1,
            },
            rgbToLCHResult: {
                l: 97.455674,
                c: 14.464551,
                h: 98.819251,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.972549,
                b: 0.862745,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.972549,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.01231,
                    g: 0.973509,
                    b: 0.804589,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.022715,
                    g: 0.97461,
                    b: 0.745988,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.031368,
                    g: 0.975844,
                    b: 0.686702,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.038402,
                    g: 0.977205,
                    b: 0.626394,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.043933,
                    g: 0.978684,
                    b: 0.564563,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.04807,
                    g: 0.980274,
                    b: 0.500428,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.050906,
                    g: 0.981967,
                    b: 0.432687,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.972549,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.985611,
                    g: 0.971737,
                    b: 0.920628,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.971155,
                    g: 0.971154,
                    b: 0.971154,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.971155,
                    g: 0.971154,
                    b: 0.971154,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.971155,
                    g: 0.971154,
                    b: 0.971154,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.971155,
                    g: 0.971154,
                    b: 0.971154,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.971155,
                    g: 0.971154,
                    b: 0.971154,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.971155,
                    g: 0.971154,
                    b: 0.971154,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.972549,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.912759,
                    g: 0.886083,
                    b: 0.778151,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.827024,
                    g: 0.801182,
                    b: 0.695223,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.742877,
                    g: 0.717936,
                    b: 0.614066,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.66041,
                    g: 0.636453,
                    b: 0.5348,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.579728,
                    g: 0.556855,
                    b: 0.45757,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.500953,
                    g: 0.479286,
                    b: 0.382543,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.424228,
                    g: 0.403921,
                    b: 0.309924,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.972549,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.088674,
                    g: 1.060499,
                    b: 0.948913,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.178717,
                    g: 1.149861,
                    b: 1.036573,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.270069,
                    g: 1.240572,
                    b: 1.125654,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.362677,
                    g: 1.332572,
                    b: 1.216092,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.456493,
                    g: 1.425812,
                    b: 1.307828,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.551473,
                    g: 1.520242,
                    b: 1.40081,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.647576,
                    g: 1.615819,
                    b: 1.49499,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.990737,
                    b: 0.901944,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.981643,
                    b: 0.882344,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.972549,
                    b: 0.862745,
                    a: 1,
                },
                {
                    r: 0.751836,
                    g: 0.724477,
                    b: 0.576081,
                    a: 1,
                },
                {
                    r: 0.503671,
                    g: 0.476406,
                    b: 0.289418,
                    a: 1,
                },
            ],
        },
        {
            name: "crimson",
            hexRGBString: "#dc143c",
            hexRGBAString: "#dc143cff",
            hexARGBString: "#ffdc143c",
            webRGBString: "rgb(220,20,60)",
            webRGBAString: "rgba(220,20,60,1)",
            lum: 0.160422,
            temp: 2484,
            rgba: {
                r: 0.862745,
                g: 0.078431,
                b: 0.235294,
                a: 1,
            },
            hsl: {
                h: 347.999985,
                s: 0.833334,
                l: 0.470588,
            },
            hsv: {
                h: 347.999985,
                s: 0.909091,
                v: 0.862745,
            },
            xyz: {
                x: 0.305847,
                y: 0.160473,
                z: 0.057612,
            },
            lab: {
                l: 47.036436,
                a: 70.921115,
                b: 33.599677,
            },
            lch: {
                l: 47.036436,
                c: 78.477659,
                h: 25.349782,
            },
            lchToLabResult: {
                l: 47.036436,
                a: 70.921115,
                b: 33.599678,
            },
            labToLCHResult: {
                l: 47.036436,
                c: 78.477658,
                h: 25.349782,
            },
            labToXYZResult: {
                x: 0.305847,
                y: 0.160473,
                z: 0.057612,
            },
            xyzToLABResult: {
                l: 47.036484,
                a: 70.92093,
                b: 33.599555,
            },
            rgbToXYZResult: {
                x: 0.305847,
                y: 0.160473,
                z: 0.057612,
            },
            xyzToRGBResult: {
                r: 0.862745,
                g: 0.078437,
                b: 0.235295,
                a: 1,
            },
            rgbToLABResult: {
                l: 47.036436,
                a: 70.921115,
                b: 33.599677,
            },
            labToRGBResult: {
                r: 0.862745,
                g: 0.078432,
                b: 0.235294,
                a: 1,
            },
            rgbToLCHResult: {
                l: 47.036436,
                c: 78.477659,
                h: 25.349782,
            },
            lchToRGBResult: {
                r: 0.862745,
                g: 0.078432,
                b: 0.235294,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.862745,
                    g: 0.078432,
                    b: 0.235294,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.89678,
                    g: -0.152106,
                    b: 0.216724,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.930252,
                    g: -0.403957,
                    b: 0.198524,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.963248,
                    g: -0.665381,
                    b: 0.180767,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.995838,
                    g: -0.936589,
                    b: 0.163553,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.028084,
                    g: -1.217789,
                    b: 0.147017,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.060036,
                    g: -1.509191,
                    b: 0.13134,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.091741,
                    g: -1.811004,
                    b: 0.116768,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.862745,
                    g: 0.078432,
                    b: 0.235294,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.828046,
                    g: 0.172053,
                    b: 0.254178,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.792558,
                    g: 0.22776,
                    b: 0.273335,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.756128,
                    g: 0.269681,
                    b: 0.292732,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.718565,
                    g: 0.303821,
                    b: 0.312343,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.679622,
                    g: 0.332782,
                    b: 0.33215,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.638978,
                    g: 0.35797,
                    b: 0.352136,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.5962,
                    g: 0.380244,
                    b: 0.372289,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.862745,
                    g: 0.078432,
                    b: 0.235294,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.765437,
                    g: -0.173295,
                    b: 0.169302,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.668745,
                    g: -0.320873,
                    b: 0.107353,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.572912,
                    g: -0.375482,
                    b: 0.043514,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.480167,
                    g: -0.361837,
                    b: -0.060394,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.392088,
                    g: -0.302189,
                    b: -0.176227,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.317527,
                    g: -0.271145,
                    b: -0.29467,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.272663,
                    g: -0.330267,
                    b: -0.407949,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.862745,
                    g: 0.078432,
                    b: 0.235294,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.960704,
                    g: 0.215539,
                    b: 0.304579,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.059343,
                    g: 0.316789,
                    b: 0.376699,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.158685,
                    g: 0.409721,
                    b: 0.451333,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.258745,
                    g: 0.49972,
                    b: 0.528241,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.359534,
                    g: 0.588765,
                    b: 0.607233,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.461058,
                    g: 0.677764,
                    b: 0.688152,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.563319,
                    g: 0.767185,
                    b: 0.770869,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.990048,
                    g: 0.638969,
                    b: 0.712811,
                    a: 1,
                },
                {
                    r: 0.926397,
                    g: 0.3587,
                    b: 0.474052,
                    a: 1,
                },
                {
                    r: 0.862745,
                    g: 0.078431,
                    b: 0.235294,
                    a: 1,
                },
                {
                    r: 0.669546,
                    g: 0.039216,
                    b: 0.127235,
                    a: 1,
                },
                {
                    r: 0.476348,
                    g: 0,
                    b: 0.019175,
                    a: 1,
                },
            ],
        },
        {
            name: "cyan",
            hexRGBString: "#00ffff",
            hexRGBAString: "#00ffffff",
            hexARGBString: "#ff00ffff",
            webRGBString: "rgb(0,255,255)",
            webRGBAString: "rgba(0,255,255,1)",
            lum: 0.7874,
            temp: 40000,
            rgba: {
                r: 0,
                g: 1,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 180,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 180,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.538014,
                y: 0.787327,
                z: 1.069496,
            },
            lab: {
                l: 91.11322,
                a: -48.087528,
                b: -14.131186,
            },
            lch: {
                l: 91.11322,
                c: 50.120862,
                h: 196.376156,
            },
            lchToLabResult: {
                l: 91.11322,
                a: -48.087528,
                b: -14.131186,
            },
            labToLCHResult: {
                l: 91.11322,
                c: 50.120862,
                h: 196.376156,
            },
            labToXYZResult: {
                x: 0.538014,
                y: 0.787327,
                z: 1.069496,
            },
            xyzToLABResult: {
                l: 91.113211,
                a: -48.087386,
                b: -14.131196,
            },
            rgbToXYZResult: {
                x: 0.538014,
                y: 0.787327,
                z: 1.069496,
            },
            xyzToRGBResult: {
                r: 0.000023,
                g: 1,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 91.11322,
                a: -48.087528,
                b: -14.131186,
            },
            labToRGBResult: {
                r: 0.000001,
                g: 1,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 91.11322,
                c: 50.120862,
                h: 196.376156,
            },
            lchToRGBResult: {
                r: 0.000001,
                g: 1,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -1.416276,
                    g: 1.012629,
                    b: 1.015635,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -2.795051,
                    g: 1.024648,
                    b: 1.031328,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -4.137153,
                    g: 1.036091,
                    b: 1.047075,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -5.443411,
                    g: 1.04699,
                    b: 1.062876,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -6.714653,
                    g: 1.057374,
                    b: 1.078728,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -7.951708,
                    g: 1.06727,
                    b: 1.09463,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -9.155404,
                    g: 1.076703,
                    b: 1.110581,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.369656,
                    g: 0.986721,
                    b: 0.984424,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.515014,
                    g: 0.972751,
                    b: 0.968908,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.6237,
                    g: 0.958041,
                    b: 0.953457,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.71441,
                    g: 0.942539,
                    b: 0.938071,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.794102,
                    g: 0.926185,
                    b: 0.922754,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.866244,
                    g: 0.908911,
                    b: 0.907509,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.899957,
                    g: 0.899957,
                    b: 0.899957,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.574477,
                    g: 0.911766,
                    b: 0.913069,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.969884,
                    g: 0.824942,
                    b: 0.827676,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -1.20902,
                    g: 0.739589,
                    b: 0.743909,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.314683,
                    g: 0.655777,
                    b: 0.66187,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.309675,
                    g: 0.573583,
                    b: 0.581673,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.216793,
                    g: 0.493087,
                    b: 0.503456,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.058839,
                    g: 0.414378,
                    b: 0.42738,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.271902,
                    g: 1.089584,
                    b: 1.088392,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.406637,
                    g: 1.180464,
                    b: 1.178175,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.521209,
                    g: 1.272592,
                    b: 1.269289,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.627627,
                    g: 1.365922,
                    b: 1.361676,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.730053,
                    g: 1.460411,
                    b: 1.455286,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.830414,
                    g: 1.556022,
                    b: 1.550074,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.929745,
                    g: 1.652717,
                    b: 1.645996,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.53828,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.26914,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.754818,
                    b: 0.759042,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.509637,
                    b: 0.518084,
                    a: 1,
                },
            ],
        },
        {
            name: "darkblue",
            hexRGBString: "#00008b",
            hexRGBAString: "#00008bff",
            hexARGBString: "#ff00008b",
            webRGBString: "rgb(0,0,139)",
            webRGBAString: "rgba(0,0,139,1)",
            lum: 0.018641,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0,
                b: 0.545098,
                a: 1,
            },
            hsl: {
                h: 240,
                s: 1,
                l: 0.272549,
            },
            hsv: {
                h: 240,
                s: 1,
                v: 0.545098,
            },
            xyz: {
                x: 0.046586,
                y: 0.018634,
                z: 0.245352,
            },
            lab: {
                l: 14.753605,
                a: 50.423445,
                b: -68.681037,
            },
            lch: {
                l: 14.753605,
                c: 85.203337,
                h: 306.284938,
            },
            lchToLabResult: {
                l: 14.753605,
                a: 50.423445,
                b: -68.681037,
            },
            labToLCHResult: {
                l: 14.753605,
                c: 85.203337,
                h: 306.284938,
            },
            labToXYZResult: {
                x: 0.046586,
                y: 0.018634,
                z: 0.245352,
            },
            xyzToLABResult: {
                l: 14.753415,
                a: 50.424444,
                b: -68.681333,
            },
            rgbToXYZResult: {
                x: 0.046586,
                y: 0.018634,
                z: 0.245352,
            },
            xyzToRGBResult: {
                r: 0.000014,
                g: -0.00001,
                b: 0.545098,
                a: 1,
            },
            rgbToLABResult: {
                l: 14.753605,
                a: 50.423445,
                b: -68.681037,
            },
            labToRGBResult: {
                r: 0,
                g: 0,
                b: 0.545098,
                a: 1,
            },
            rgbToLCHResult: {
                l: 14.753605,
                c: 85.203337,
                h: 306.284938,
            },
            lchToRGBResult: {
                r: 0,
                g: 0,
                b: 0.545098,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.105165,
                    g: -0.023523,
                    b: 0.584016,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.228881,
                    g: -0.047111,
                    b: 0.623374,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.372233,
                    g: -0.070713,
                    b: 0.663161,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.536302,
                    g: -0.094276,
                    b: 0.703367,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.722172,
                    g: -0.117751,
                    b: 0.74398,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.930927,
                    g: -0.141086,
                    b: 0.78499,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.163648,
                    g: -0.164231,
                    b: 0.826388,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.076765,
                    g: 0.023408,
                    b: 0.506631,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.113843,
                    g: 0.046293,
                    b: 0.468627,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.136464,
                    g: 0.064721,
                    b: 0.431094,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.151169,
                    g: 0.079682,
                    b: 0.394042,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.160459,
                    g: 0.092447,
                    b: 0.357476,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.165592,
                    g: 0.103646,
                    b: 0.321397,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.167295,
                    g: 0.113649,
                    b: 0.285798,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.202891,
                    g: -0.03767,
                    b: 0.465084,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.236144,
                    g: -0.105736,
                    b: 0.387973,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.149664,
                    g: -0.228709,
                    b: 0.314941,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.121818,
                    g: -0.350566,
                    b: 0.246876,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.157713,
                    g: -0.46711,
                    b: 0.185881,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.244974,
                    g: -0.579373,
                    b: 0.136007,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.355283,
                    g: -0.689714,
                    b: 0.086117,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.175947,
                    g: 0.084764,
                    b: 0.626943,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.281244,
                    g: 0.161635,
                    b: 0.710481,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.375511,
                    g: 0.236029,
                    b: 0.795607,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.466138,
                    g: 0.31102,
                    b: 0.882236,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.555538,
                    g: 0.387399,
                    b: 0.970295,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.644764,
                    g: 0.465406,
                    b: 1.059718,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.73434,
                    g: 0.545091,
                    b: 1.150448,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.621776,
                    g: 0.626258,
                    b: 0.872819,
                    a: 1,
                },
                {
                    r: 0.310888,
                    g: 0.313129,
                    b: 0.708959,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.422448,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.299798,
                    a: 1,
                },
            ],
        },
        {
            name: "darkcyan",
            hexRGBString: "#008b8b",
            hexRGBAString: "#008b8bff",
            hexARGBString: "#ff008b8b",
            webRGBString: "rgb(0,139,139)",
            webRGBAString: "rgba(0,139,139,1)",
            lum: 0.203293,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0.545098,
                b: 0.545098,
                a: 1,
            },
            hsl: {
                h: 180,
                s: 1,
                l: 0.272549,
            },
            hsv: {
                h: 180,
                s: 1,
                v: 0.545098,
            },
            xyz: {
                x: 0.138906,
                y: 0.203274,
                z: 0.276126,
            },
            lab: {
                l: 52.205414,
                a: -30.620214,
                b: -8.998174,
            },
            lch: {
                l: 52.205414,
                c: 31.91496,
                h: 196.376156,
            },
            lchToLabResult: {
                l: 52.205414,
                a: -30.620214,
                b: -8.998174,
            },
            labToLCHResult: {
                l: 52.205414,
                c: 31.91496,
                h: 196.376156,
            },
            labToXYZResult: {
                x: 0.138906,
                y: 0.203274,
                z: 0.276126,
            },
            xyzToLABResult: {
                l: 52.205375,
                a: -30.61996,
                b: -8.998316,
            },
            rgbToXYZResult: {
                x: 0.138906,
                y: 0.203274,
                z: 0.276126,
            },
            xyzToRGBResult: {
                r: 0.00001,
                g: 0.545097,
                b: 0.545099,
                a: 1,
            },
            rgbToLABResult: {
                l: 52.205414,
                a: -30.620214,
                b: -8.998174,
            },
            labToRGBResult: {
                r: 0,
                g: 0.545098,
                b: 0.545098,
                a: 1,
            },
            rgbToLCHResult: {
                l: 52.205414,
                c: 31.91496,
                h: 196.376156,
            },
            lchToRGBResult: {
                r: 0,
                g: 0.545098,
                b: 0.545098,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.545098,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.569897,
                    g: 0.556223,
                    b: 0.55908,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -1.116216,
                    g: 0.566519,
                    b: 0.57314,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -1.639785,
                    g: 0.576057,
                    b: 0.587274,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -2.141433,
                    g: 0.5849,
                    b: 0.601479,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -2.621988,
                    g: 0.593102,
                    b: 0.615751,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -3.082278,
                    g: 0.600711,
                    b: 0.630088,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -3.523133,
                    g: 0.60777,
                    b: 0.644486,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.545098,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.237458,
                    g: 0.533062,
                    b: 0.531199,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.338817,
                    g: 0.520017,
                    b: 0.517388,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.415403,
                    g: 0.505848,
                    b: 0.50367,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.479974,
                    g: 0.490416,
                    b: 0.490052,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.488192,
                    g: 0.488192,
                    b: 0.488192,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.488192,
                    g: 0.488192,
                    b: 0.488192,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.488192,
                    g: 0.488192,
                    b: 0.488192,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.545098,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.211843,
                    g: 0.466636,
                    b: 0.467832,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.317942,
                    g: 0.390201,
                    b: 0.392794,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.341098,
                    g: 0.315944,
                    b: 0.320203,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.304109,
                    g: 0.244038,
                    b: 0.250335,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.23366,
                    g: 0.175007,
                    b: 0.183531,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.272124,
                    g: 0.123589,
                    b: 0.119578,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.379137,
                    g: 0.06589,
                    b: 0.053394,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.545098,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.176854,
                    g: 0.625455,
                    b: 0.624415,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.281488,
                    g: 0.707591,
                    b: 0.705634,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.374887,
                    g: 0.791406,
                    b: 0.788631,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.464598,
                    g: 0.876809,
                    b: 0.873299,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.553091,
                    g: 0.96372,
                    b: 0.959543,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.64144,
                    g: 1.052069,
                    b: 1.047281,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.730179,
                    g: 1.14179,
                    b: 1.136441,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.557725,
                    g: 0.844059,
                    b: 0.845333,
                    a: 1,
                },
                {
                    r: 0.278862,
                    g: 0.694578,
                    b: 0.695215,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.545098,
                    b: 0.545098,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.379895,
                    b: 0.385742,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.214691,
                    b: 0.226385,
                    a: 1,
                },
            ],
        },
        {
            name: "darkgoldenrod",
            hexRGBString: "#b8860b",
            hexRGBAString: "#b8860bff",
            hexARGBString: "#ffb8860b",
            webRGBString: "rgb(184,134,11)",
            webRGBAString: "rgba(184,134,11,1)",
            lum: 0.272647,
            temp: 2000,
            rgba: {
                r: 0.721569,
                g: 0.52549,
                b: 0.043137,
                a: 1,
            },
            hsl: {
                h: 42.658925,
                s: 0.88718,
                l: 0.382353,
            },
            hsv: {
                h: 42.658925,
                s: 0.940218,
                v: 0.721569,
            },
            xyz: {
                x: 0.283548,
                y: 0.27267,
                z: 0.040862,
            },
            lab: {
                l: 59.220698,
                a: 9.86482,
                b: 62.730473,
            },
            lch: {
                l: 59.220698,
                c: 63.501393,
                h: 81.063015,
            },
            lchToLabResult: {
                l: 59.220698,
                a: 9.86482,
                b: 62.730473,
            },
            labToLCHResult: {
                l: 59.220698,
                c: 63.501393,
                h: 81.063015,
            },
            labToXYZResult: {
                x: 0.283548,
                y: 0.27267,
                z: 0.040862,
            },
            xyzToLABResult: {
                l: 59.220655,
                a: 9.86503,
                b: 62.73062,
            },
            rgbToXYZResult: {
                x: 0.283548,
                y: 0.27267,
                z: 0.040862,
            },
            xyzToRGBResult: {
                r: 0.72157,
                g: 0.525489,
                b: 0.043133,
                a: 1,
            },
            rgbToLABResult: {
                l: 59.220698,
                a: 9.86482,
                b: 62.730473,
            },
            labToRGBResult: {
                r: 0.721569,
                g: 0.52549,
                b: 0.043137,
                a: 1,
            },
            rgbToLCHResult: {
                l: 59.220698,
                c: 63.501393,
                h: 81.063015,
            },
            lchToRGBResult: {
                r: 0.721569,
                g: 0.52549,
                b: 0.043137,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.721569,
                    g: 0.52549,
                    b: 0.043137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.732344,
                    g: 0.52194,
                    b: -0.124264,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.74205,
                    g: 0.518457,
                    b: -0.253309,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.750856,
                    g: 0.515029,
                    b: -0.348835,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.759039,
                    g: 0.511623,
                    b: -0.421104,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.767113,
                    g: 0.508171,
                    b: -0.491613,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.775122,
                    g: 0.504666,
                    b: -0.562107,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.783069,
                    g: 0.501107,
                    b: -0.632584,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.721569,
                    g: 0.52549,
                    b: 0.043137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.709538,
                    g: 0.529122,
                    b: 0.150273,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.69604,
                    g: 0.532847,
                    b: 0.220147,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.680832,
                    g: 0.53668,
                    b: 0.280428,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.663628,
                    g: 0.54063,
                    b: 0.336465,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.644083,
                    g: 0.54471,
                    b: 0.390324,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.621769,
                    g: 0.548931,
                    b: 0.443015,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.596139,
                    g: 0.553301,
                    b: 0.495098,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.721569,
                    g: 0.52549,
                    b: 0.043137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.632209,
                    g: 0.449135,
                    b: -0.083447,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.544094,
                    g: 0.37509,
                    b: -0.134279,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.459162,
                    g: 0.303326,
                    b: -0.173215,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.379854,
                    g: 0.233749,
                    b: -0.235055,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.308402,
                    g: 0.166196,
                    b: -0.316354,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.248554,
                    g: 0.099692,
                    b: -0.413667,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.207368,
                    g: 0.020969,
                    b: -0.522651,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.721569,
                    g: 0.52549,
                    b: 0.043137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.812097,
                    g: 0.603969,
                    b: 0.155133,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.903749,
                    g: 0.684414,
                    b: 0.241874,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.996491,
                    g: 0.766692,
                    b: 0.324101,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.090293,
                    g: 0.85069,
                    b: 0.405496,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.18513,
                    g: 0.936306,
                    b: 0.487301,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.280978,
                    g: 1.023455,
                    b: 0.570024,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.377814,
                    g: 1.112059,
                    b: 0.653894,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.909893,
                    g: 0.823402,
                    b: 0.598792,
                    a: 1,
                },
                {
                    r: 0.815731,
                    g: 0.674446,
                    b: 0.320964,
                    a: 1,
                },
                {
                    r: 0.721569,
                    g: 0.52549,
                    b: 0.043137,
                    a: 1,
                },
                {
                    r: 0.532774,
                    g: 0.348178,
                    b: 0.021569,
                    a: 1,
                },
                {
                    r: 0.343978,
                    g: 0.170866,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "darkgray",
            hexRGBString: "#a9a9a9",
            hexRGBAString: "#a9a9a9ff",
            hexARGBString: "#ffa9a9a9",
            webRGBString: "rgb(169,169,169)",
            webRGBAString: "rgba(169,169,169,1)",
            lum: 0.396755,
            temp: 6650,
            rgba: {
                r: 0.662745,
                g: 0.662745,
                b: 0.662745,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0.662745,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0.662745,
            },
            xyz: {
                x: 0.377104,
                y: 0.396755,
                z: 0.431999,
            },
            lab: {
                l: 69.237789,
                a: -0.000012,
                b: 0.000005,
            },
            lch: {
                l: 69.237789,
                c: 0.000013,
                h: 0,
            },
            lchToLabResult: {
                l: 69.237789,
                a: -0.000012,
                b: 0.000005,
            },
            labToLCHResult: {
                l: 69.237789,
                c: 0.000013,
                h: 0,
            },
            labToXYZResult: {
                x: 0.377104,
                y: 0.396755,
                z: 0.431999,
            },
            xyzToLABResult: {
                l: 69.237779,
                a: 0.000089,
                b: -0.000029,
            },
            rgbToXYZResult: {
                x: 0.377104,
                y: 0.396755,
                z: 0.431999,
            },
            xyzToRGBResult: {
                r: 0.662746,
                g: 0.662745,
                b: 0.662745,
                a: 1,
            },
            rgbToLABResult: {
                l: 69.237789,
                a: -0.000012,
                b: 0.000005,
            },
            labToRGBResult: {
                r: 0.662745,
                g: 0.662745,
                b: 0.662745,
                a: 1,
            },
            rgbToLCHResult: {
                l: 69.237789,
                c: 0.000013,
                h: 0,
            },
            lchToRGBResult: {
                r: 0.662745,
                g: 0.662745,
                b: 0.662745,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.582487,
                    g: 0.582488,
                    b: 0.582488,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.504205,
                    g: 0.504205,
                    b: 0.504205,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.428059,
                    g: 0.428059,
                    b: 0.428059,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.354247,
                    g: 0.354247,
                    b: 0.354247,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.283014,
                    g: 0.283014,
                    b: 0.283014,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.214677,
                    g: 0.214677,
                    b: 0.214677,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.149659,
                    g: 0.149659,
                    b: 0.149659,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.744841,
                    g: 0.744841,
                    b: 0.744841,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.82866,
                    g: 0.82866,
                    b: 0.82866,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.914102,
                    g: 0.914102,
                    b: 0.914102,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.001079,
                    g: 1.001079,
                    b: 1.001079,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.089514,
                    g: 1.089514,
                    b: 1.089514,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.179338,
                    g: 1.179338,
                    b: 1.179338,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.27049,
                    g: 1.27049,
                    b: 1.27049,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.875216,
                    g: 0.875216,
                    b: 0.875216,
                    a: 1,
                },
                {
                    r: 0.76898,
                    g: 0.76898,
                    b: 0.76898,
                    a: 1,
                },
                {
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    r: 0.469469,
                    g: 0.469469,
                    b: 0.469469,
                    a: 1,
                },
                {
                    r: 0.276194,
                    g: 0.276194,
                    b: 0.276194,
                    a: 1,
                },
            ],
        },
        {
            name: "darkgreen",
            hexRGBString: "#006400",
            hexRGBAString: "#006400ff",
            hexARGBString: "#ff006400",
            webRGBString: "rgb(0,100,0)",
            webRGBAString: "rgba(0,100,0,1)",
            lum: 0.091143,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0.392157,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 120,
                s: 1,
                l: 0.196079,
            },
            hsv: {
                h: 120,
                s: 1,
                v: 0.392157,
            },
            xyz: {
                x: 0.045569,
                y: 0.091137,
                z: 0.01519,
            },
            lab: {
                l: 36.202369,
                a: -43.369682,
                b: 41.858285,
            },
            lch: {
                l: 36.202369,
                c: 60.274749,
                h: 136.015953,
            },
            lchToLabResult: {
                l: 36.202369,
                a: -43.369682,
                b: 41.858285,
            },
            labToLCHResult: {
                l: 36.202369,
                c: 60.274749,
                h: 136.015953,
            },
            labToXYZResult: {
                x: 0.045569,
                y: 0.091137,
                z: 0.01519,
            },
            xyzToLABResult: {
                l: 36.202291,
                a: -43.368953,
                b: 41.85769,
            },
            rgbToXYZResult: {
                x: 0.045569,
                y: 0.091137,
                z: 0.01519,
            },
            xyzToRGBResult: {
                r: 0.000018,
                g: 0.392156,
                b: 0.000007,
                a: 1,
            },
            rgbToLABResult: {
                l: 36.202369,
                a: -43.369682,
                b: 41.858285,
            },
            labToRGBResult: {
                r: 0,
                g: 0.392157,
                b: 0,
                a: 1,
            },
            rgbToLCHResult: {
                l: 36.202369,
                c: 60.274749,
                h: 136.015953,
            },
            lchToRGBResult: {
                r: 0,
                g: 0.392157,
                b: 0,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.392157,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.14045,
                    g: 0.397577,
                    b: -0.064751,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.275354,
                    g: 0.402612,
                    b: -0.119109,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.400441,
                    g: 0.407248,
                    b: -0.172831,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.515818,
                    g: 0.411511,
                    b: -0.226387,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.621812,
                    g: 0.415424,
                    b: -0.279781,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.718751,
                    g: 0.419009,
                    b: -0.33302,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.80696,
                    g: 0.422288,
                    b: -0.386108,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.392157,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.106951,
                    g: 0.386345,
                    b: 0.072047,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.162095,
                    g: 0.380116,
                    b: 0.121976,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.203015,
                    g: 0.373441,
                    b: 0.163346,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.236819,
                    g: 0.366288,
                    b: 0.201106,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.266143,
                    g: 0.358618,
                    b: 0.23701,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.29229,
                    g: 0.350387,
                    b: 0.271886,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.316015,
                    g: 0.341545,
                    b: 0.306189,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.392157,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.112814,
                    g: 0.317029,
                    b: -0.061515,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.119615,
                    g: 0.243581,
                    b: -0.133332,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.093065,
                    g: 0.175116,
                    b: -0.223883,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.178306,
                    g: 0.128166,
                    b: -0.33089,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.288645,
                    g: 0.073769,
                    b: -0.441229,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.398983,
                    g: -0.027353,
                    b: -0.551567,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.509322,
                    g: -0.137692,
                    b: -0.661906,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.392157,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.137883,
                    g: 0.469282,
                    b: 0.096349,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.23076,
                    g: 0.548339,
                    b: 0.176033,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.316125,
                    g: 0.629218,
                    b: 0.252136,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.399627,
                    g: 0.71182,
                    b: 0.32835,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.483022,
                    g: 0.796053,
                    b: 0.405686,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.567026,
                    g: 0.881837,
                    b: 0.484482,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.651967,
                    g: 0.969096,
                    b: 0.564843,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.599213,
                    g: 0.783921,
                    b: 0.601823,
                    a: 1,
                },
                {
                    r: 0.299607,
                    g: 0.588039,
                    b: 0.300911,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.392157,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.264465,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.136774,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "darkgrey",
            hexRGBString: "#a9a9a9",
            hexRGBAString: "#a9a9a9ff",
            hexARGBString: "#ffa9a9a9",
            webRGBString: "rgb(169,169,169)",
            webRGBAString: "rgba(169,169,169,1)",
            lum: 0.396755,
            temp: 6650,
            rgba: {
                r: 0.662745,
                g: 0.662745,
                b: 0.662745,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0.662745,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0.662745,
            },
            xyz: {
                x: 0.377104,
                y: 0.396755,
                z: 0.431999,
            },
            lab: {
                l: 69.237789,
                a: -0.000012,
                b: 0.000005,
            },
            lch: {
                l: 69.237789,
                c: 0.000013,
                h: 0,
            },
            lchToLabResult: {
                l: 69.237789,
                a: -0.000012,
                b: 0.000005,
            },
            labToLCHResult: {
                l: 69.237789,
                c: 0.000013,
                h: 0,
            },
            labToXYZResult: {
                x: 0.377104,
                y: 0.396755,
                z: 0.431999,
            },
            xyzToLABResult: {
                l: 69.237779,
                a: 0.000089,
                b: -0.000029,
            },
            rgbToXYZResult: {
                x: 0.377104,
                y: 0.396755,
                z: 0.431999,
            },
            xyzToRGBResult: {
                r: 0.662746,
                g: 0.662745,
                b: 0.662745,
                a: 1,
            },
            rgbToLABResult: {
                l: 69.237789,
                a: -0.000012,
                b: 0.000005,
            },
            labToRGBResult: {
                r: 0.662745,
                g: 0.662745,
                b: 0.662745,
                a: 1,
            },
            rgbToLCHResult: {
                l: 69.237789,
                c: 0.000013,
                h: 0,
            },
            lchToRGBResult: {
                r: 0.662745,
                g: 0.662745,
                b: 0.662745,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.582487,
                    g: 0.582488,
                    b: 0.582488,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.504205,
                    g: 0.504205,
                    b: 0.504205,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.428059,
                    g: 0.428059,
                    b: 0.428059,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.354247,
                    g: 0.354247,
                    b: 0.354247,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.283014,
                    g: 0.283014,
                    b: 0.283014,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.214677,
                    g: 0.214677,
                    b: 0.214677,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.149659,
                    g: 0.149659,
                    b: 0.149659,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.744841,
                    g: 0.744841,
                    b: 0.744841,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.82866,
                    g: 0.82866,
                    b: 0.82866,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.914102,
                    g: 0.914102,
                    b: 0.914102,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.001079,
                    g: 1.001079,
                    b: 1.001079,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.089514,
                    g: 1.089514,
                    b: 1.089514,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.179338,
                    g: 1.179338,
                    b: 1.179338,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.27049,
                    g: 1.27049,
                    b: 1.27049,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.875216,
                    g: 0.875216,
                    b: 0.875216,
                    a: 1,
                },
                {
                    r: 0.76898,
                    g: 0.76898,
                    b: 0.76898,
                    a: 1,
                },
                {
                    r: 0.662745,
                    g: 0.662745,
                    b: 0.662745,
                    a: 1,
                },
                {
                    r: 0.469469,
                    g: 0.469469,
                    b: 0.469469,
                    a: 1,
                },
                {
                    r: 0.276194,
                    g: 0.276194,
                    b: 0.276194,
                    a: 1,
                },
            ],
        },
        {
            name: "darkkhaki",
            hexRGBString: "#bdb76b",
            hexRGBAString: "#bdb76bff",
            hexARGBString: "#ffbdb76b",
            webRGBString: "rgb(189,183,107)",
            webRGBAString: "rgba(189,183,107,1)",
            lum: 0.457473,
            temp: 3614,
            rgba: {
                r: 0.741176,
                g: 0.717647,
                b: 0.419608,
                a: 1,
            },
            hsl: {
                h: 55.609824,
                s: 0.383177,
                l: 0.580392,
            },
            hsv: {
                h: 55.609824,
                s: 0.433862,
                v: 0.741176,
            },
            xyz: {
                x: 0.405744,
                y: 0.457484,
                z: 0.206001,
            },
            lab: {
                l: 73.381967,
                a: -8.787739,
                b: 39.291633,
            },
            lch: {
                l: 73.381967,
                c: 40.26235,
                h: 102.606969,
            },
            lchToLabResult: {
                l: 73.381967,
                a: -8.787739,
                b: 39.291634,
            },
            labToLCHResult: {
                l: 73.381967,
                c: 40.262349,
                h: 102.60697,
            },
            labToXYZResult: {
                x: 0.405744,
                y: 0.457484,
                z: 0.206001,
            },
            xyzToLABResult: {
                l: 73.381978,
                a: -8.787729,
                b: 39.291563,
            },
            rgbToXYZResult: {
                x: 0.405744,
                y: 0.457484,
                z: 0.206001,
            },
            xyzToRGBResult: {
                r: 0.741176,
                g: 0.717647,
                b: 0.419609,
                a: 1,
            },
            rgbToLABResult: {
                l: 73.381967,
                a: -8.787739,
                b: 39.291633,
            },
            labToRGBResult: {
                r: 0.741176,
                g: 0.717647,
                b: 0.419608,
                a: 1,
            },
            rgbToLCHResult: {
                l: 73.381967,
                c: 40.26235,
                h: 102.606969,
            },
            lchToRGBResult: {
                r: 0.741176,
                g: 0.717647,
                b: 0.419608,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.741176,
                    g: 0.717647,
                    b: 0.419608,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.742051,
                    g: 0.720141,
                    b: 0.360152,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.741417,
                    g: 0.722732,
                    b: 0.296444,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.73938,
                    g: 0.725407,
                    b: 0.224428,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.73604,
                    g: 0.728158,
                    b: 0.130827,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.731488,
                    g: 0.730972,
                    b: -0.078881,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.725811,
                    g: 0.733839,
                    b: -0.309071,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.71909,
                    g: 0.73675,
                    b: -0.495198,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.741176,
                    g: 0.717647,
                    b: 0.419608,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.73867,
                    g: 0.71526,
                    b: 0.476628,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.734398,
                    g: 0.712991,
                    b: 0.532182,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.728204,
                    g: 0.710853,
                    b: 0.586846,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.719906,
                    g: 0.708855,
                    b: 0.640984,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.709289,
                    g: 0.70701,
                    b: 0.694842,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.706627,
                    g: 0.706627,
                    b: 0.706627,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.706627,
                    g: 0.706627,
                    b: 0.706627,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.741176,
                    g: 0.717647,
                    b: 0.419608,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.65679,
                    g: 0.636298,
                    b: 0.343133,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.57396,
                    g: 0.556847,
                    b: 0.268297,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.492759,
                    g: 0.479443,
                    b: 0.194684,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.413259,
                    g: 0.404262,
                    b: 0.120807,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.335536,
                    g: 0.331519,
                    b: 0.0389,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.260438,
                    g: 0.261418,
                    b: -0.033959,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.195019,
                    g: 0.193736,
                    b: -0.114674,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.741176,
                    g: 0.717647,
                    b: 0.419608,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.827053,
                    g: 0.800771,
                    b: 0.497826,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.914359,
                    g: 0.885562,
                    b: 0.577782,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.003036,
                    g: 0.971926,
                    b: 0.659429,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.09303,
                    g: 1.059782,
                    b: 0.742704,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.184293,
                    g: 1.149057,
                    b: 0.82754,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.276778,
                    g: 1.239687,
                    b: 0.913873,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.370443,
                    g: 1.331612,
                    b: 1.00164,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.908327,
                    g: 0.89802,
                    b: 0.739592,
                    a: 1,
                },
                {
                    r: 0.824752,
                    g: 0.807833,
                    b: 0.5796,
                    a: 1,
                },
                {
                    r: 0.741176,
                    g: 0.717647,
                    b: 0.419608,
                    a: 1,
                },
                {
                    r: 0.533401,
                    g: 0.518477,
                    b: 0.209804,
                    a: 1,
                },
                {
                    r: 0.325627,
                    g: 0.319306,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "darkmagenta",
            hexRGBString: "#8b008b",
            hexRGBAString: "#8b008bff",
            hexARGBString: "#ff8b008b",
            webRGBString: "rgb(139,0,139)",
            webRGBAString: "rgba(139,0,139,1)",
            lum: 0.07353,
            temp: 6650,
            rgba: {
                r: 0.545098,
                g: 0,
                b: 0.545098,
                a: 1,
            },
            hsl: {
                h: 300,
                s: 1,
                l: 0.272549,
            },
            hsv: {
                h: 300,
                s: 1,
                v: 0.545098,
            },
            xyz: {
                x: 0.153075,
                y: 0.073543,
                z: 0.250344,
            },
            lab: {
                l: 32.600206,
                a: 62.551681,
                b: -38.730859,
            },
            lch: {
                l: 32.600206,
                c: 73.57168,
                h: 328.234965,
            },
            lchToLabResult: {
                l: 32.600206,
                a: 62.551681,
                b: -38.730858,
            },
            labToLCHResult: {
                l: 32.600206,
                c: 73.571681,
                h: 328.234964,
            },
            labToXYZResult: {
                x: 0.153075,
                y: 0.073543,
                z: 0.250344,
            },
            xyzToLABResult: {
                l: 32.600243,
                a: 62.551512,
                b: -38.730817,
            },
            rgbToXYZResult: {
                x: 0.153075,
                y: 0.073543,
                z: 0.250344,
            },
            xyzToRGBResult: {
                r: 0.545098,
                g: 0.000005,
                b: 0.545098,
                a: 1,
            },
            rgbToLABResult: {
                l: 32.600206,
                a: 62.551681,
                b: -38.730859,
            },
            labToRGBResult: {
                r: 0.545098,
                g: 0,
                b: 0.545098,
                a: 1,
            },
            rgbToLCHResult: {
                l: 32.600206,
                c: 73.57168,
                h: 328.234965,
            },
            lchToRGBResult: {
                r: 0.545098,
                g: 0,
                b: 0.545098,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.545098,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.56767,
                    g: -0.12821,
                    b: 0.571249,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.58996,
                    g: -0.262351,
                    b: 0.597535,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.612002,
                    g: -0.402556,
                    b: 0.623959,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.633829,
                    g: -0.548957,
                    b: 0.650525,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.655466,
                    g: -0.701685,
                    b: 0.677234,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.676937,
                    g: -0.860872,
                    b: 0.704086,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.698262,
                    g: -1.026649,
                    b: 0.731083,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.545098,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.522198,
                    g: 0.096409,
                    b: 0.519078,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.498919,
                    g: 0.145143,
                    b: 0.493184,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.475195,
                    g: 0.17966,
                    b: 0.467406,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.450948,
                    g: 0.206934,
                    b: 0.441734,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.426077,
                    g: 0.229598,
                    b: 0.416156,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.400454,
                    g: 0.248984,
                    b: 0.390652,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.373909,
                    g: 0.265877,
                    b: 0.3652,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.545098,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.461055,
                    g: -0.139898,
                    b: 0.466486,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.378202,
                    g: -0.195467,
                    b: 0.389907,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.296416,
                    g: -0.189506,
                    b: 0.315532,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.222765,
                    g: -0.184781,
                    b: 0.244441,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.180656,
                    g: -0.26008,
                    b: 0.179773,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.155177,
                    g: -0.372415,
                    b: 0.125048,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.113753,
                    g: -0.48277,
                    b: 0.068288,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.545098,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.630385,
                    g: 0.147863,
                    b: 0.625603,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.716928,
                    g: 0.243457,
                    b: 0.707882,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.804722,
                    g: 0.330561,
                    b: 0.791832,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.893747,
                    g: 0.415343,
                    b: 0.877363,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.983979,
                    g: 0.49975,
                    b: 0.964395,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.075389,
                    g: 0.584592,
                    b: 1.052857,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.167949,
                    g: 0.670251,
                    b: 1.142686,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.855595,
                    g: 0.615589,
                    b: 0.857411,
                    a: 1,
                },
                {
                    r: 0.700347,
                    g: 0.307794,
                    b: 0.701255,
                    a: 1,
                },
                {
                    r: 0.545098,
                    g: 0,
                    b: 0.545098,
                    a: 1,
                },
                {
                    r: 0.394775,
                    g: 0,
                    b: 0.400367,
                    a: 1,
                },
                {
                    r: 0.244452,
                    g: 0,
                    b: 0.255636,
                    a: 1,
                },
            ],
        },
        {
            name: "darkolivegreen",
            hexRGBString: "#556b2f",
            hexRGBAString: "#556b2fff",
            hexARGBString: "#ff556b2f",
            webRGBString: "rgb(85,107,47)",
            webRGBAString: "rgba(85,107,47,1)",
            lum: 0.126519,
            temp: 3550,
            rgba: {
                r: 0.333333,
                g: 0.419608,
                b: 0.184314,
                a: 1,
            },
            hsl: {
                h: 82.000136,
                s: 0.38961,
                l: 0.301961,
            },
            hsv: {
                h: 82.000136,
                s: 0.560747,
                v: 0.419608,
            },
            xyz: {
                x: 0.095171,
                y: 0.126518,
                z: 0.046294,
            },
            lab: {
                l: 42.233862,
                a: -18.827878,
                b: 30.598343,
            },
            lch: {
                l: 42.233862,
                c: 35.926976,
                h: 121.60496,
            },
            lchToLabResult: {
                l: 42.233862,
                a: -18.827878,
                b: 30.598343,
            },
            labToLCHResult: {
                l: 42.233862,
                c: 35.926976,
                h: 121.60496,
            },
            labToXYZResult: {
                x: 0.095171,
                y: 0.126518,
                z: 0.046294,
            },
            xyzToLABResult: {
                l: 42.23384,
                a: -18.827608,
                b: 30.598439,
            },
            rgbToXYZResult: {
                x: 0.095171,
                y: 0.126518,
                z: 0.046294,
            },
            xyzToRGBResult: {
                r: 0.333335,
                g: 0.419607,
                b: 0.184313,
                a: 1,
            },
            rgbToLABResult: {
                l: 42.233862,
                a: -18.827878,
                b: 30.598343,
            },
            labToRGBResult: {
                r: 0.333333,
                g: 0.419608,
                b: 0.184314,
                a: 1,
            },
            rgbToLCHResult: {
                l: 42.233862,
                c: 35.926976,
                h: 121.60496,
            },
            lchToRGBResult: {
                r: 0.333333,
                g: 0.419608,
                b: 0.184314,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.333333,
                    g: 0.419608,
                    b: 0.184314,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.315089,
                    g: 0.425266,
                    b: 0.131347,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.294335,
                    g: 0.430737,
                    b: 0.062244,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.270661,
                    g: 0.436023,
                    b: -0.041549,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.243395,
                    g: 0.441121,
                    b: -0.125123,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.211848,
                    g: 0.446016,
                    b: -0.191981,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.17571,
                    g: 0.450661,
                    b: -0.257646,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.131648,
                    g: 0.455063,
                    b: -0.323199,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.333333,
                    g: 0.419608,
                    b: 0.184314,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.349331,
                    g: 0.413765,
                    b: 0.231738,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.363253,
                    g: 0.407736,
                    b: 0.276567,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.375204,
                    g: 0.401521,
                    b: 0.320062,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.385243,
                    g: 0.395119,
                    b: 0.362867,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.39081,
                    g: 0.39081,
                    b: 0.39081,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.39081,
                    g: 0.39081,
                    b: 0.39081,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.39081,
                    g: 0.39081,
                    b: 0.39081,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.333333,
                    g: 0.419608,
                    b: 0.184314,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.259473,
                    g: 0.34575,
                    b: 0.114578,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.187503,
                    g: 0.274418,
                    b: 0.042272,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.12242,
                    g: 0.205627,
                    b: -0.03815,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.082507,
                    g: 0.139083,
                    b: -0.134236,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.002255,
                    g: 0.083275,
                    b: -0.243124,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.112593,
                    g: -0.011882,
                    b: -0.353462,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.222932,
                    g: -0.122221,
                    b: -0.463801,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.333333,
                    g: 0.419608,
                    b: 0.184314,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.40916,
                    g: 0.495766,
                    b: 0.25527,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.486914,
                    g: 0.57404,
                    b: 0.328146,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.566517,
                    g: 0.654273,
                    b: 0.403064,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.647883,
                    g: 0.736335,
                    b: 0.479989,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.730924,
                    g: 0.820113,
                    b: 0.558837,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.815562,
                    g: 0.905509,
                    b: 0.639512,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.90172,
                    g: 0.992437,
                    b: 0.721921,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.742119,
                    g: 0.791581,
                    b: 0.659507,
                    a: 1,
                },
                {
                    r: 0.537726,
                    g: 0.605594,
                    b: 0.42191,
                    a: 1,
                },
                {
                    r: 0.333333,
                    g: 0.419608,
                    b: 0.184314,
                    a: 1,
                },
                {
                    r: 0.202768,
                    g: 0.280116,
                    b: 0.092157,
                    a: 1,
                },
                {
                    r: 0.072203,
                    g: 0.140625,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "darkorange",
            hexRGBString: "#ff8c00",
            hexRGBAString: "#ff8c00ff",
            hexARGBString: "#ffff8c00",
            webRGBString: "rgb(255,140,0)",
            webRGBAString: "rgba(255,140,0,1)",
            lum: 0.400162,
            temp: 1000,
            rgba: {
                r: 1,
                g: 0.54902,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 32.9412,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 32.9412,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.506231,
                y: 0.400222,
                z: 0.050592,
            },
            lab: {
                l: 69.485363,
                a: 36.825691,
                b: 75.487111,
            },
            lch: {
                l: 69.485363,
                c: 83.990687,
                h: 63.994993,
            },
            lchToLabResult: {
                l: 69.485363,
                a: 36.825691,
                b: 75.487112,
            },
            labToLCHResult: {
                l: 69.485363,
                c: 83.990687,
                h: 63.994993,
            },
            labToXYZResult: {
                x: 0.506231,
                y: 0.400222,
                z: 0.050592,
            },
            xyzToLABResult: {
                l: 69.48534,
                a: 36.825761,
                b: 75.487132,
            },
            rgbToXYZResult: {
                x: 0.506231,
                y: 0.400222,
                z: 0.050592,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.54902,
                b: -0.000001,
                a: 1,
            },
            rgbToLABResult: {
                l: 69.485363,
                a: 36.825691,
                b: 75.487111,
            },
            labToRGBResult: {
                r: 1,
                g: 0.54902,
                b: 0,
                a: 1,
            },
            rgbToLCHResult: {
                l: 69.485363,
                c: 83.990687,
                h: 63.994993,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.54902,
                b: 0,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.54902,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.020824,
                    g: 0.53642,
                    b: -0.172065,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.040857,
                    g: 0.523329,
                    b: -0.309141,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.060211,
                    g: 0.50969,
                    b: -0.414944,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.078987,
                    g: 0.495435,
                    b: -0.49319,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.097333,
                    g: 0.480471,
                    b: -0.551427,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.115524,
                    g: 0.464651,
                    b: -0.60767,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.133595,
                    g: 0.447859,
                    b: -0.663754,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.54902,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.978257,
                    g: 0.561181,
                    b: 0.13488,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.955452,
                    g: 0.572947,
                    b: 0.208792,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.931417,
                    g: 0.584357,
                    b: 0.269599,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.905959,
                    g: 0.595447,
                    b: 0.324765,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.878849,
                    g: 0.606249,
                    b: 0.376943,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.849812,
                    g: 0.61679,
                    b: 0.427397,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.81851,
                    g: 0.627096,
                    b: 0.476825,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.54902,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.902319,
                    g: 0.469564,
                    b: -0.138747,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.805542,
                    g: 0.391768,
                    b: -0.195262,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.710223,
                    g: 0.315436,
                    b: -0.211114,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.618026,
                    g: 0.239795,
                    b: -0.249818,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.529734,
                    g: 0.16325,
                    b: -0.311588,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.446459,
                    g: 0.07952,
                    b: -0.392978,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.370033,
                    g: -0.022732,
                    b: -0.490544,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.54902,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.09854,
                    g: 0.630136,
                    b: 0.146747,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.19791,
                    g: 0.712871,
                    b: 0.241737,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.298091,
                    g: 0.797171,
                    b: 0.328318,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.399069,
                    g: 0.882976,
                    b: 0.412634,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.500833,
                    g: 0.970229,
                    b: 0.496622,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.603371,
                    g: 1.058871,
                    b: 0.581084,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.706675,
                    g: 1.148848,
                    b: 0.666396,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.827916,
                    b: 0.584048,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.688468,
                    b: 0.292024,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.54902,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.763648,
                    g: 0.358372,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.527296,
                    g: 0.167724,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "darkorchid",
            hexRGBString: "#9932cc",
            hexRGBAString: "#9932ccff",
            hexARGBString: "#ff9932cc",
            webRGBString: "rgb(153,50,204)",
            webRGBAString: "rgba(153,50,204,1)",
            lum: 0.134131,
            temp: 12023,
            rgba: {
                r: 0.6,
                g: 0.196078,
                b: 0.8,
                a: 1,
            },
            hsl: {
                h: 280.129884,
                s: 0.6063,
                l: 0.498039,
            },
            hsv: {
                h: 280.129884,
                s: 0.754903,
                v: 0.8,
            },
            xyz: {
                x: 0.251745,
                y: 0.134138,
                z: 0.58378,
            },
            lab: {
                l: 43.380227,
                a: 65.153573,
                b: -60.097735,
            },
            lch: {
                l: 43.380227,
                c: 88.638174,
                h: 317.311521,
            },
            lchToLabResult: {
                l: 43.380227,
                a: 65.153573,
                b: -60.097735,
            },
            labToLCHResult: {
                l: 43.380227,
                c: 88.638174,
                h: 317.311521,
            },
            labToXYZResult: {
                x: 0.251745,
                y: 0.134138,
                z: 0.58378,
            },
            xyzToLABResult: {
                l: 43.380238,
                a: 65.153543,
                b: -60.09771,
            },
            rgbToXYZResult: {
                x: 0.251745,
                y: 0.134138,
                z: 0.58378,
            },
            xyzToRGBResult: {
                r: 0.6,
                g: 0.196078,
                b: 0.8,
                a: 1,
            },
            rgbToLABResult: {
                l: 43.380227,
                a: 65.153573,
                b: -60.097735,
            },
            labToRGBResult: {
                r: 0.6,
                g: 0.196078,
                b: 0.8,
                a: 1,
            },
            rgbToLCHResult: {
                l: 43.380227,
                c: 88.638174,
                h: 317.311521,
            },
            lchToRGBResult: {
                r: 0.6,
                g: 0.196078,
                b: 0.8,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.6,
                    g: 0.196078,
                    b: 0.8,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.612649,
                    g: 0.156611,
                    b: 0.835706,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.624716,
                    g: 0.100574,
                    b: 0.871618,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.636215,
                    g: -0.016103,
                    b: 0.907738,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.647159,
                    g: -0.166928,
                    b: 0.944066,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.657559,
                    g: -0.32187,
                    b: 0.980602,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.667422,
                    g: -0.480968,
                    b: 1.017347,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.676755,
                    g: -0.644265,
                    b: 1.054298,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.6,
                    g: 0.196078,
                    b: 0.8,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.58675,
                    g: 0.227496,
                    b: 0.764498,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.572876,
                    g: 0.253913,
                    b: 0.729196,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.558352,
                    g: 0.276831,
                    b: 0.694089,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.543145,
                    g: 0.297119,
                    b: 0.65917,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.527218,
                    g: 0.315333,
                    b: 0.624429,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.510522,
                    g: 0.331853,
                    b: 0.589853,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.493002,
                    g: 0.346954,
                    b: 0.555425,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.6,
                    g: 0.196078,
                    b: 0.8,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.513355,
                    g: 0.09148,
                    b: 0.71507,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.427306,
                    g: -0.069765,
                    b: 0.631737,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.34133,
                    g: -0.159189,
                    b: 0.550096,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.254234,
                    g: -0.178009,
                    b: 0.470265,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.165346,
                    g: -0.159906,
                    b: 0.392528,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.105516,
                    g: -0.207862,
                    b: 0.318487,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.10457,
                    g: -0.319803,
                    b: 0.249571,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.6,
                    g: 0.196078,
                    b: 0.8,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.687496,
                    g: 0.284504,
                    b: 0.886442,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.775971,
                    g: 0.369091,
                    b: 0.974324,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.86549,
                    g: 0.452821,
                    b: 1.06358,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.956082,
                    g: 0.536812,
                    b: 1.154153,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.047752,
                    g: 0.621561,
                    b: 1.24599,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.140498,
                    g: 0.707306,
                    b: 1.339043,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.234305,
                    g: 0.794161,
                    b: 1.433269,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.868419,
                    g: 0.691293,
                    b: 0.958216,
                    a: 1,
                },
                {
                    r: 0.73421,
                    g: 0.443685,
                    b: 0.879108,
                    a: 1,
                },
                {
                    r: 0.6,
                    g: 0.196078,
                    b: 0.8,
                    a: 1,
                },
                {
                    r: 0.430073,
                    g: 0.098039,
                    b: 0.620707,
                    a: 1,
                },
                {
                    r: 0.260146,
                    g: 0,
                    b: 0.441413,
                    a: 1,
                },
            ],
        },
        {
            name: "darkred",
            hexRGBString: "#8b0000",
            hexRGBAString: "#8b0000ff",
            hexARGBString: "#ff8b0000",
            webRGBString: "rgb(139,0,0)",
            webRGBAString: "rgba(139,0,0,1)",
            lum: 0.05489,
            temp: 1000,
            rgba: {
                r: 0.545098,
                g: 0,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 1,
                l: 0.272549,
            },
            hsv: {
                h: 0,
                s: 1,
                v: 0.545098,
            },
            xyz: {
                x: 0.106489,
                y: 0.054908,
                z: 0.004992,
            },
            lab: {
                l: 28.089768,
                a: 50.999675,
                b: 41.290787,
            },
            lch: {
                l: 28.089768,
                c: 65.619326,
                h: 38.994615,
            },
            lchToLabResult: {
                l: 28.089768,
                a: 50.999675,
                b: 41.290787,
            },
            labToLCHResult: {
                l: 28.089768,
                c: 65.619326,
                h: 38.994615,
            },
            labToXYZResult: {
                x: 0.106489,
                y: 0.054908,
                z: 0.004992,
            },
            xyzToLABResult: {
                l: 28.089638,
                a: 51.000121,
                b: 41.290105,
            },
            rgbToXYZResult: {
                x: 0.106489,
                y: 0.054908,
                z: 0.004992,
            },
            xyzToRGBResult: {
                r: 0.545098,
                g: -0.000009,
                b: 0.000005,
                a: 1,
            },
            rgbToLABResult: {
                l: 28.089768,
                a: 50.999675,
                b: 41.290787,
            },
            labToRGBResult: {
                r: 0.545098,
                g: 0,
                b: 0,
                a: 1,
            },
            rgbToLCHResult: {
                l: 28.089768,
                c: 65.619326,
                h: 38.994615,
            },
            lchToRGBResult: {
                r: 0.545098,
                g: 0,
                b: 0,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.545098,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.571483,
                    g: -0.103828,
                    b: -0.0405,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.597529,
                    g: -0.212731,
                    b: -0.080709,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.623294,
                    g: -0.32683,
                    b: -0.120619,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.648824,
                    g: -0.446249,
                    b: -0.160224,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.674159,
                    g: -0.57111,
                    b: -0.199516,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.699331,
                    g: -0.701538,
                    b: -0.238489,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.724369,
                    g: -0.837655,
                    b: -0.277136,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.545098,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.518305,
                    g: 0.083522,
                    b: 0.040778,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.490926,
                    g: 0.128045,
                    b: 0.074456,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.462453,
                    g: 0.159648,
                    b: 0.104419,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.432521,
                    g: 0.184696,
                    b: 0.133166,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.40067,
                    g: 0.205591,
                    b: 0.161389,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.366234,
                    g: 0.223554,
                    b: 0.189422,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.328189,
                    g: 0.239305,
                    b: 0.217443,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.545098,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.456313,
                    g: -0.109219,
                    b: -0.091072,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.372821,
                    g: -0.148011,
                    b: -0.196542,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.298493,
                    g: -0.148123,
                    b: -0.311881,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.25238,
                    g: -0.211621,
                    b: -0.424909,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.229717,
                    g: -0.321328,
                    b: -0.535284,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.204708,
                    g: -0.431667,
                    b: -0.645622,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.175768,
                    g: -0.542006,
                    b: -0.755961,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.545098,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.637481,
                    g: 0.131485,
                    b: 0.074403,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.731027,
                    g: 0.221845,
                    b: 0.142538,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.825394,
                    g: 0.305317,
                    b: 0.211577,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.92059,
                    g: 0.387259,
                    b: 0.282636,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.016623,
                    g: 0.469314,
                    b: 0.355885,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.113498,
                    g: 0.55214,
                    b: 0.43128,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.211216,
                    g: 0.63603,
                    b: 0.508718,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.873684,
                    g: 0.612674,
                    b: 0.614883,
                    a: 1,
                },
                {
                    r: 0.709391,
                    g: 0.306337,
                    b: 0.307441,
                    a: 1,
                },
                {
                    r: 0.545098,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.407121,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.269144,
                    g: 0,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "darksalmon",
            hexRGBString: "#e9967a",
            hexRGBAString: "#e9967aff",
            hexARGBString: "#ffe9967a",
            webRGBString: "rgb(233,150,122)",
            webRGBAString: "rgba(233,150,122,1)",
            lum: 0.405414,
            temp: 3414,
            rgba: {
                r: 0.913725,
                g: 0.588235,
                b: 0.478431,
                a: 1,
            },
            hsl: {
                h: 15.13515,
                s: 0.716128,
                l: 0.696078,
            },
            hsv: {
                h: 15.13515,
                s: 0.476395,
                v: 0.913725,
            },
            xyz: {
                x: 0.480261,
                y: 0.405454,
                z: 0.237052,
            },
            lab: {
                l: 69.856252,
                a: 28.174212,
                b: 27.711714,
            },
            lch: {
                l: 69.856252,
                c: 39.518671,
                h: 44.525846,
            },
            lchToLabResult: {
                l: 69.856252,
                a: 28.174212,
                b: 27.711715,
            },
            labToLCHResult: {
                l: 69.856252,
                c: 39.51867,
                h: 44.525845,
            },
            labToXYZResult: {
                x: 0.480261,
                y: 0.405454,
                z: 0.237052,
            },
            xyzToLABResult: {
                l: 69.856237,
                a: 28.174376,
                b: 27.711684,
            },
            rgbToXYZResult: {
                x: 0.480261,
                y: 0.405454,
                z: 0.237052,
            },
            xyzToRGBResult: {
                r: 0.913726,
                g: 0.588234,
                b: 0.478431,
                a: 1,
            },
            rgbToLABResult: {
                l: 69.856252,
                a: 28.174212,
                b: 27.711714,
            },
            labToRGBResult: {
                r: 0.913725,
                g: 0.588235,
                b: 0.478431,
                a: 1,
            },
            rgbToLCHResult: {
                l: 69.856252,
                c: 39.518671,
                h: 44.525846,
            },
            lchToRGBResult: {
                r: 0.913725,
                g: 0.588235,
                b: 0.478431,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.913725,
                    g: 0.588235,
                    b: 0.478431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.952557,
                    g: 0.569558,
                    b: 0.440995,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.989594,
                    g: 0.549656,
                    b: 0.403286,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.025102,
                    g: 0.528351,
                    b: 0.365135,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.059297,
                    g: 0.505415,
                    b: 0.326294,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.092357,
                    g: 0.480557,
                    b: 0.286378,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.124433,
                    g: 0.453387,
                    b: 0.244745,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.155652,
                    g: 0.423363,
                    b: 0.200222,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.913725,
                    g: 0.588235,
                    b: 0.478431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.872764,
                    g: 0.605833,
                    b: 0.515711,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.829245,
                    g: 0.62247,
                    b: 0.552919,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.782603,
                    g: 0.638248,
                    b: 0.59012,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.732061,
                    g: 0.65325,
                    b: 0.627359,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.676503,
                    g: 0.66755,
                    b: 0.664672,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.669261,
                    g: 0.669261,
                    b: 0.669261,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.669261,
                    g: 0.669261,
                    b: 0.669261,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.913725,
                    g: 0.588235,
                    b: 0.478431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.823849,
                    g: 0.508552,
                    b: 0.402401,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.735169,
                    g: 0.430725,
                    b: 0.328621,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.647709,
                    g: 0.35483,
                    b: 0.257275,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.561488,
                    g: 0.280903,
                    b: 0.188549,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.476516,
                    g: 0.20885,
                    b: 0.122562,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.392807,
                    g: 0.138143,
                    b: 0.058825,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.313224,
                    g: 0.065191,
                    b: -0.033388,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.913725,
                    g: 0.588235,
                    b: 0.478431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.004772,
                    g: 0.669688,
                    b: 0.556549,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.096962,
                    g: 0.752823,
                    b: 0.636611,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.190268,
                    g: 0.837559,
                    b: 0.718493,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.284661,
                    g: 0.923821,
                    b: 0.802088,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.380114,
                    g: 1.011537,
                    b: 0.887299,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.476601,
                    g: 1.100646,
                    b: 0.974042,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.574095,
                    g: 1.191088,
                    b: 1.062243,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.834829,
                    b: 0.774787,
                    a: 1,
                },
                {
                    r: 0.956863,
                    g: 0.711532,
                    b: 0.626609,
                    a: 1,
                },
                {
                    r: 0.913725,
                    g: 0.588235,
                    b: 0.478431,
                    a: 1,
                },
                {
                    r: 0.710332,
                    g: 0.381383,
                    b: 0.269245,
                    a: 1,
                },
                {
                    r: 0.506938,
                    g: 0.17453,
                    b: 0.060059,
                    a: 1,
                },
            ],
        },
        {
            name: "darkseagreen",
            hexRGBString: "#8fbc8f",
            hexRGBAString: "#8fbc8fff",
            hexARGBString: "#ff8fbc8f",
            webRGBString: "rgb(143,188,143)",
            webRGBAString: "rgba(143,188,143,1)",
            lum: 0.437893,
            temp: 6650,
            rgba: {
                r: 0.560784,
                g: 0.737255,
                b: 0.560784,
                a: 1,
            },
            hsl: {
                h: 120,
                s: 0.251397,
                l: 0.64902,
            },
            hsv: {
                h: 120,
                s: 0.239362,
                v: 0.737255,
            },
            xyz: {
                x: 0.342675,
                y: 0.437882,
                z: 0.326277,
            },
            lab: {
                l: 72.086677,
                a: -23.819609,
                b: 18.037796,
            },
            lch: {
                l: 72.086677,
                c: 29.878686,
                h: 142.864567,
            },
            lchToLabResult: {
                l: 72.086677,
                a: -23.819609,
                b: 18.037796,
            },
            labToLCHResult: {
                l: 72.086677,
                c: 29.878686,
                h: 142.864567,
            },
            labToXYZResult: {
                x: 0.342675,
                y: 0.437882,
                z: 0.326277,
            },
            xyzToLABResult: {
                l: 72.086703,
                a: -23.819557,
                b: 18.03788,
            },
            rgbToXYZResult: {
                x: 0.342675,
                y: 0.437882,
                z: 0.326277,
            },
            xyzToRGBResult: {
                r: 0.560785,
                g: 0.737255,
                b: 0.560784,
                a: 1,
            },
            rgbToLABResult: {
                l: 72.086677,
                a: -23.819609,
                b: 18.037796,
            },
            labToRGBResult: {
                r: 0.560784,
                g: 0.737255,
                b: 0.560784,
                a: 1,
            },
            rgbToLCHResult: {
                l: 72.086677,
                c: 29.878686,
                h: 142.864567,
            },
            lchToRGBResult: {
                r: 0.560784,
                g: 0.737255,
                b: 0.560784,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.560784,
                    g: 0.737255,
                    b: 0.560784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.521509,
                    g: 0.747377,
                    b: 0.526034,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.479008,
                    g: 0.757012,
                    b: 0.490821,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.432215,
                    g: 0.766188,
                    b: 0.454988,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.379355,
                    g: 0.77493,
                    b: 0.418316,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.317059,
                    g: 0.783261,
                    b: 0.3805,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.237272,
                    g: 0.791201,
                    b: 0.341078,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.104492,
                    g: 0.798768,
                    b: 0.299326,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.560784,
                    g: 0.737255,
                    b: 0.560784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.597528,
                    g: 0.726617,
                    b: 0.595189,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.632224,
                    g: 0.715429,
                    b: 0.629339,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.665223,
                    g: 0.703652,
                    b: 0.663305,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.692856,
                    g: 0.692856,
                    b: 0.692856,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.692856,
                    g: 0.692856,
                    b: 0.692856,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.692856,
                    g: 0.692856,
                    b: 0.692856,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.692856,
                    g: 0.692856,
                    b: 0.692856,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.560784,
                    g: 0.737255,
                    b: 0.560784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.4814,
                    g: 0.654906,
                    b: 0.48265,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.403831,
                    g: 0.574349,
                    b: 0.406614,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.328112,
                    g: 0.495708,
                    b: 0.332846,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.254185,
                    g: 0.419125,
                    b: 0.261544,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.181729,
                    g: 0.344769,
                    b: 0.192923,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.10946,
                    g: 0.272842,
                    b: 0.127175,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.030813,
                    g: 0.203585,
                    b: 0.064133,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.560784,
                    g: 0.737255,
                    b: 0.560784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.641917,
                    g: 0.821291,
                    b: 0.64087,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.724724,
                    g: 0.90692,
                    b: 0.72278,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.80913,
                    g: 0.994061,
                    b: 0.806405,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.895063,
                    g: 1.082639,
                    b: 0.891649,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.982456,
                    g: 1.17259,
                    b: 0.978426,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.071247,
                    g: 1.263854,
                    b: 1.06666,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.161377,
                    g: 1.356378,
                    b: 1.156285,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.808116,
                    g: 0.91297,
                    b: 0.809196,
                    a: 1,
                },
                {
                    r: 0.68445,
                    g: 0.825112,
                    b: 0.68499,
                    a: 1,
                },
                {
                    r: 0.560784,
                    g: 0.737255,
                    b: 0.560784,
                    a: 1,
                },
                {
                    r: 0.321211,
                    g: 0.541541,
                    b: 0.340646,
                    a: 1,
                },
                {
                    r: 0.081638,
                    g: 0.345827,
                    b: 0.120508,
                    a: 1,
                },
            ],
        },
        {
            name: "darkslateblue",
            hexRGBString: "#483d8b",
            hexRGBAString: "#483d8bff",
            hexARGBString: "#ff483d8b",
            webRGBString: "rgb(72,61,139)",
            webRGBAString: "rgba(72,61,139,1)",
            lum: 0.065793,
            temp: 40000,
            rgba: {
                r: 0.282353,
                g: 0.239216,
                b: 0.545098,
                a: 1,
            },
            hsl: {
                h: 248.461498,
                s: 0.389999,
                l: 0.392157,
            },
            hsv: {
                h: 248.461498,
                s: 0.56115,
                v: 0.545098,
            },
            xyz: {
                x: 0.090001,
                y: 0.065789,
                z: 0.252167,
            },
            lab: {
                l: 30.828368,
                a: 26.050923,
                b: -42.082493,
            },
            lch: {
                l: 30.828368,
                c: 49.493301,
                h: 301.759339,
            },
            lchToLabResult: {
                l: 30.828368,
                a: 26.050924,
                b: -42.082493,
            },
            labToLCHResult: {
                l: 30.828368,
                c: 49.493301,
                h: 301.759338,
            },
            labToXYZResult: {
                x: 0.090001,
                y: 0.065789,
                z: 0.252167,
            },
            xyzToLABResult: {
                l: 30.828375,
                a: 26.051101,
                b: -42.082449,
            },
            rgbToXYZResult: {
                x: 0.090001,
                y: 0.065789,
                z: 0.252167,
            },
            xyzToRGBResult: {
                r: 0.282355,
                g: 0.239216,
                b: 0.545098,
                a: 1,
            },
            rgbToLABResult: {
                l: 30.828368,
                a: 26.050923,
                b: -42.082493,
            },
            labToRGBResult: {
                r: 0.282353,
                g: 0.239216,
                b: 0.545098,
                a: 1,
            },
            rgbToLCHResult: {
                l: 30.828368,
                c: 49.493301,
                h: 301.759339,
            },
            lchToRGBResult: {
                r: 0.282353,
                g: 0.239216,
                b: 0.545098,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.282353,
                    g: 0.239216,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.270416,
                    g: 0.231247,
                    b: 0.586917,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.253693,
                    g: 0.223011,
                    b: 0.62913,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.230711,
                    g: 0.214497,
                    b: 0.67174,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.198722,
                    g: 0.205691,
                    b: 0.714747,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.151303,
                    g: 0.196577,
                    b: 0.75815,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.060871,
                    g: 0.187136,
                    b: 0.801946,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.157124,
                    g: 0.177342,
                    b: 0.846128,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.282353,
                    g: 0.239216,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.2904,
                    g: 0.246927,
                    b: 0.503664,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.295142,
                    g: 0.254388,
                    b: 0.462598,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.296979,
                    g: 0.261605,
                    b: 0.421873,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.29619,
                    g: 0.268583,
                    b: 0.381447,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.292969,
                    g: 0.275327,
                    b: 0.341246,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.287441,
                    g: 0.281841,
                    b: 0.301158,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.284482,
                    g: 0.284482,
                    b: 0.284482,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.282353,
                    g: 0.239216,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.201714,
                    g: 0.171847,
                    b: 0.466491,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.115812,
                    g: 0.107719,
                    b: 0.389925,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.001093,
                    g: 0.047076,
                    b: 0.315579,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.030194,
                    g: -0.055374,
                    b: 0.245039,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.061214,
                    g: -0.172325,
                    b: 0.180507,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.144639,
                    g: -0.284907,
                    b: 0.125236,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.254681,
                    g: -0.39527,
                    b: 0.068465,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.282353,
                    g: 0.239216,
                    b: 0.545098,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.362208,
                    g: 0.30948,
                    b: 0.625603,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.442607,
                    g: 0.382349,
                    b: 0.707885,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.524055,
                    g: 0.457589,
                    b: 0.79184,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.60676,
                    g: 0.535003,
                    b: 0.877376,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.690801,
                    g: 0.614428,
                    b: 0.964415,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.7762,
                    g: 0.695728,
                    b: 1.052884,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.862945,
                    g: 0.778784,
                    b: 1.142719,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.733975,
                    g: 0.713518,
                    b: 0.872287,
                    a: 1,
                },
                {
                    r: 0.508164,
                    g: 0.476367,
                    b: 0.708693,
                    a: 1,
                },
                {
                    r: 0.282353,
                    g: 0.239216,
                    b: 0.545098,
                    a: 1,
                },
                {
                    r: 0.15531,
                    g: 0.145129,
                    b: 0.420484,
                    a: 1,
                },
                {
                    r: 0.028268,
                    g: 0.051043,
                    b: 0.29587,
                    a: 1,
                },
            ],
        },
        {
            name: "darkslategray",
            hexRGBString: "#2f4f4f",
            hexRGBAString: "#2f4f4fff",
            hexARGBString: "#ff2f4f4f",
            webRGBString: "rgb(47,79,79)",
            webRGBAString: "rgba(47,79,79,1)",
            lum: 0.067608,
            temp: 40000,
            rgba: {
                r: 0.184314,
                g: 0.309804,
                b: 0.309804,
                a: 1,
            },
            hsl: {
                h: 180,
                s: 0.253968,
                l: 0.247059,
            },
            hsv: {
                h: 180,
                s: 0.405063,
                v: 0.309804,
            },
            xyz: {
                x: 0.05379,
                y: 0.067605,
                z: 0.084171,
            },
            lab: {
                l: 31.255246,
                a: -11.719839,
                b: -3.723636,
            },
            lch: {
                l: 31.255246,
                c: 12.297158,
                h: 197.62613,
            },
            lchToLabResult: {
                l: 31.255246,
                a: -11.719839,
                b: -3.723636,
            },
            labToLCHResult: {
                l: 31.255246,
                c: 12.297158,
                h: 197.626132,
            },
            labToXYZResult: {
                x: 0.05379,
                y: 0.067605,
                z: 0.084171,
            },
            xyzToLABResult: {
                l: 31.255344,
                a: -11.720798,
                b: -3.723543,
            },
            rgbToXYZResult: {
                x: 0.05379,
                y: 0.067605,
                z: 0.084171,
            },
            xyzToRGBResult: {
                r: 0.184306,
                g: 0.309806,
                b: 0.309804,
                a: 1,
            },
            rgbToLABResult: {
                l: 31.255246,
                a: -11.719839,
                b: -3.723636,
            },
            labToRGBResult: {
                r: 0.184314,
                g: 0.309804,
                b: 0.309804,
                a: 1,
            },
            rgbToLCHResult: {
                l: 31.255246,
                c: 12.297158,
                h: 197.62613,
            },
            lchToRGBResult: {
                r: 0.184314,
                g: 0.309804,
                b: 0.309804,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.066701,
                    g: 0.321328,
                    b: 0.323426,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.205774,
                    g: 0.331618,
                    b: 0.337164,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.468298,
                    g: 0.340832,
                    b: 0.35101,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.715925,
                    g: 0.349102,
                    b: 0.364955,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.949483,
                    g: 0.356532,
                    b: 0.378995,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.169796,
                    g: 0.363212,
                    b: 0.393123,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.377691,
                    g: 0.369219,
                    b: 0.407334,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.254234,
                    g: 0.296842,
                    b: 0.296308,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.114451,
                    g: 0.239932,
                    b: 0.240328,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.042105,
                    g: 0.173084,
                    b: 0.173996,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.02225,
                    g: 0.111344,
                    b: 0.11124,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.130854,
                    g: 0.042837,
                    b: 0.039197,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.241193,
                    g: -0.067419,
                    b: -0.071142,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.351532,
                    g: -0.177758,
                    b: -0.181481,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.461871,
                    g: -0.288096,
                    b: -0.291819,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.255399,
                    g: 0.382364,
                    b: 0.382046,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.328394,
                    g: 0.45735,
                    b: 0.456767,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.40342,
                    g: 0.534551,
                    b: 0.533743,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.480441,
                    g: 0.613793,
                    b: 0.612791,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.559375,
                    g: 0.694933,
                    b: 0.69376,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.640129,
                    g: 0.777846,
                    b: 0.776522,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.722608,
                    g: 0.862428,
                    b: 0.860968,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.640363,
                    g: 0.758012,
                    b: 0.758658,
                    a: 1,
                },
                {
                    r: 0.412339,
                    g: 0.533908,
                    b: 0.534231,
                    a: 1,
                },
                {
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    r: 0.092157,
                    g: 0.213422,
                    b: 0.216062,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.11704,
                    b: 0.122321,
                    a: 1,
                },
            ],
        },
        {
            name: "darkslategrey",
            hexRGBString: "#2f4f4f",
            hexRGBAString: "#2f4f4fff",
            hexARGBString: "#ff2f4f4f",
            webRGBString: "rgb(47,79,79)",
            webRGBAString: "rgba(47,79,79,1)",
            lum: 0.067608,
            temp: 40000,
            rgba: {
                r: 0.184314,
                g: 0.309804,
                b: 0.309804,
                a: 1,
            },
            hsl: {
                h: 180,
                s: 0.253968,
                l: 0.247059,
            },
            hsv: {
                h: 180,
                s: 0.405063,
                v: 0.309804,
            },
            xyz: {
                x: 0.05379,
                y: 0.067605,
                z: 0.084171,
            },
            lab: {
                l: 31.255246,
                a: -11.719839,
                b: -3.723636,
            },
            lch: {
                l: 31.255246,
                c: 12.297158,
                h: 197.62613,
            },
            lchToLabResult: {
                l: 31.255246,
                a: -11.719839,
                b: -3.723636,
            },
            labToLCHResult: {
                l: 31.255246,
                c: 12.297158,
                h: 197.626132,
            },
            labToXYZResult: {
                x: 0.05379,
                y: 0.067605,
                z: 0.084171,
            },
            xyzToLABResult: {
                l: 31.255344,
                a: -11.720798,
                b: -3.723543,
            },
            rgbToXYZResult: {
                x: 0.05379,
                y: 0.067605,
                z: 0.084171,
            },
            xyzToRGBResult: {
                r: 0.184306,
                g: 0.309806,
                b: 0.309804,
                a: 1,
            },
            rgbToLABResult: {
                l: 31.255246,
                a: -11.719839,
                b: -3.723636,
            },
            labToRGBResult: {
                r: 0.184314,
                g: 0.309804,
                b: 0.309804,
                a: 1,
            },
            rgbToLCHResult: {
                l: 31.255246,
                c: 12.297158,
                h: 197.62613,
            },
            lchToRGBResult: {
                r: 0.184314,
                g: 0.309804,
                b: 0.309804,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.066701,
                    g: 0.321328,
                    b: 0.323426,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.205774,
                    g: 0.331618,
                    b: 0.337164,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.468298,
                    g: 0.340832,
                    b: 0.35101,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.715925,
                    g: 0.349102,
                    b: 0.364955,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.949483,
                    g: 0.356532,
                    b: 0.378995,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.169796,
                    g: 0.363212,
                    b: 0.393123,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.377691,
                    g: 0.369219,
                    b: 0.407334,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.254234,
                    g: 0.296842,
                    b: 0.296308,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.288354,
                    g: 0.288354,
                    b: 0.288354,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.114451,
                    g: 0.239932,
                    b: 0.240328,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.042105,
                    g: 0.173084,
                    b: 0.173996,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.02225,
                    g: 0.111344,
                    b: 0.11124,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.130854,
                    g: 0.042837,
                    b: 0.039197,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.241193,
                    g: -0.067419,
                    b: -0.071142,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.351532,
                    g: -0.177758,
                    b: -0.181481,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.461871,
                    g: -0.288096,
                    b: -0.291819,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.255399,
                    g: 0.382364,
                    b: 0.382046,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.328394,
                    g: 0.45735,
                    b: 0.456767,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.40342,
                    g: 0.534551,
                    b: 0.533743,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.480441,
                    g: 0.613793,
                    b: 0.612791,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.559375,
                    g: 0.694933,
                    b: 0.69376,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.640129,
                    g: 0.777846,
                    b: 0.776522,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.722608,
                    g: 0.862428,
                    b: 0.860968,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.640363,
                    g: 0.758012,
                    b: 0.758658,
                    a: 1,
                },
                {
                    r: 0.412339,
                    g: 0.533908,
                    b: 0.534231,
                    a: 1,
                },
                {
                    r: 0.184314,
                    g: 0.309804,
                    b: 0.309804,
                    a: 1,
                },
                {
                    r: 0.092157,
                    g: 0.213422,
                    b: 0.216062,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.11704,
                    b: 0.122321,
                    a: 1,
                },
            ],
        },
        {
            name: "darkturquoise",
            hexRGBString: "#00ced1",
            hexRGBAString: "#00ced1ff",
            hexARGBString: "#ff00ced1",
            webRGBString: "rgb(0,206,209)",
            webRGBAString: "rgba(0,206,209,1)",
            lum: 0.48746,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0.807843,
                b: 0.819608,
                a: 1,
            },
            hsl: {
                h: 180.861265,
                s: 1,
                l: 0.409804,
            },
            hsv: {
                h: 180.861265,
                s: 1,
                v: 0.819608,
            },
            xyz: {
                x: 0.335745,
                y: 0.487415,
                z: 0.679477,
            },
            lab: {
                l: 75.290229,
                a: -40.043245,
                b: -13.513368,
            },
            lch: {
                l: 75.290229,
                c: 42.261952,
                h: 198.647963,
            },
            lchToLabResult: {
                l: 75.290229,
                a: -40.043245,
                b: -13.513368,
            },
            labToLCHResult: {
                l: 75.290229,
                c: 42.261952,
                h: 198.647962,
            },
            labToXYZResult: {
                x: 0.335745,
                y: 0.487415,
                z: 0.679477,
            },
            xyzToLABResult: {
                l: 75.290227,
                a: -40.043118,
                b: -13.513352,
            },
            rgbToXYZResult: {
                x: 0.335745,
                y: 0.487415,
                z: 0.679477,
            },
            xyzToRGBResult: {
                r: 0.000017,
                g: 0.807843,
                b: 0.819608,
                a: 1,
            },
            rgbToLABResult: {
                l: 75.290229,
                a: -40.043245,
                b: -13.513368,
            },
            labToRGBResult: {
                r: 0.000001,
                g: 0.807843,
                b: 0.819608,
                a: 1,
            },
            rgbToLCHResult: {
                l: 75.290229,
                c: 42.261952,
                h: 198.647963,
            },
            lchToRGBResult: {
                r: 0.000001,
                g: 0.807843,
                b: 0.819608,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.807843,
                    b: 0.819608,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -1.046392,
                    g: 0.819965,
                    b: 0.836758,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -2.063011,
                    g: 0.831417,
                    b: 0.853977,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -3.050681,
                    g: 0.842245,
                    b: 0.871263,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -4.010227,
                    g: 0.852488,
                    b: 0.888613,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -4.942474,
                    g: 0.862182,
                    b: 0.906026,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -5.848246,
                    g: 0.87136,
                    b: 0.923499,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -6.728369,
                    g: 0.880051,
                    b: 0.941031,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.807843,
                    b: 0.819608,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.319669,
                    g: 0.795003,
                    b: 0.80253,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.448151,
                    g: 0.781388,
                    b: 0.785526,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.544374,
                    g: 0.766934,
                    b: 0.7686,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.624815,
                    g: 0.75157,
                    b: 0.751754,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.695603,
                    g: 0.735212,
                    b: 0.734994,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.727006,
                    g: 0.727006,
                    b: 0.727006,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.727006,
                    g: 0.727006,
                    b: 0.727006,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.807843,
                    b: 0.819608,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.408902,
                    g: 0.723253,
                    b: 0.73598,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.667935,
                    g: 0.640269,
                    b: 0.654087,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.799898,
                    g: 0.55898,
                    b: 0.574046,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.827591,
                    g: 0.479483,
                    b: 0.495996,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.773813,
                    g: 0.401885,
                    b: 0.420102,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.661364,
                    g: 0.326303,
                    b: 0.346561,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.513044,
                    g: 0.252864,
                    b: 0.275624,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.807843,
                    b: 0.819608,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.234831,
                    g: 0.893962,
                    b: 0.904869,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.357746,
                    g: 0.981537,
                    b: 0.991675,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.463967,
                    g: 1.070505,
                    b: 1.079948,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.563772,
                    g: 1.160807,
                    b: 1.169617,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.660668,
                    g: 1.252389,
                    b: 1.26062,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.75625,
                    g: 1.345202,
                    b: 1.352901,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.851359,
                    g: 1.439201,
                    b: 1.446409,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.546273,
                    g: 0.94102,
                    b: 0.947995,
                    a: 1,
                },
                {
                    r: 0.273136,
                    g: 0.874432,
                    b: 0.883802,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.807843,
                    b: 0.819608,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.600748,
                    b: 0.616975,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.393653,
                    b: 0.414342,
                    a: 1,
                },
            ],
        },
        {
            name: "darkviolet",
            hexRGBString: "#9400d3",
            hexRGBAString: "#9400d3ff",
            hexARGBString: "#ff9400d3",
            webRGBString: "rgb(148,0,211)",
            webRGBAString: "rgba(148,0,211,1)",
            lum: 0.10999,
            temp: 15215,
            rgba: {
                r: 0.580392,
                g: 0,
                b: 0.827451,
                a: 1,
            },
            hsl: {
                h: 282.085296,
                s: 1,
                l: 0.413726,
            },
            hsv: {
                h: 282.085296,
                s: 1,
                v: 0.827451,
            },
            xyz: {
                x: 0.239682,
                y: 0.109996,
                z: 0.624759,
            },
            lab: {
                l: 39.579755,
                a: 76.32197,
                b: -70.366377,
            },
            lch: {
                l: 39.579755,
                c: 103.809779,
                h: 317.32495,
            },
            lchToLabResult: {
                l: 39.579755,
                a: 76.321971,
                b: -70.366377,
            },
            labToLCHResult: {
                l: 39.579755,
                c: 103.809779,
                h: 317.32495,
            },
            labToXYZResult: {
                x: 0.239682,
                y: 0.109996,
                z: 0.624759,
            },
            xyzToLABResult: {
                l: 39.579797,
                a: 76.321762,
                b: -70.366306,
            },
            rgbToXYZResult: {
                x: 0.239682,
                y: 0.109996,
                z: 0.624759,
            },
            xyzToRGBResult: {
                r: 0.580391,
                g: 0.000007,
                b: 0.827451,
                a: 1,
            },
            rgbToLABResult: {
                l: 39.579755,
                a: 76.32197,
                b: -70.366377,
            },
            labToRGBResult: {
                r: 0.580392,
                g: 0,
                b: 0.827451,
                a: 1,
            },
            rgbToLCHResult: {
                l: 39.579755,
                c: 103.809779,
                h: 317.32495,
            },
            lchToRGBResult: {
                r: 0.580392,
                g: 0,
                b: 0.827451,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.580392,
                    g: 0,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.59122,
                    g: -0.131923,
                    b: 0.863157,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.601475,
                    g: -0.2677,
                    b: 0.899083,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.611168,
                    g: -0.407374,
                    b: 0.935226,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.620306,
                    g: -0.550985,
                    b: 0.971587,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.628892,
                    g: -0.698576,
                    b: 1.008164,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.63693,
                    g: -0.850187,
                    b: 1.044956,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.644422,
                    g: -1.005861,
                    b: 1.08196,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.580392,
                    g: 0,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.568981,
                    g: 0.099307,
                    b: 0.791963,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.556972,
                    g: 0.149707,
                    b: 0.756693,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.544347,
                    g: 0.185879,
                    b: 0.72164,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.531084,
                    g: 0.214857,
                    b: 0.686799,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.517156,
                    g: 0.239284,
                    b: 0.652166,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.50253,
                    g: 0.260495,
                    b: 0.617735,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.487168,
                    g: 0.279272,
                    b: 0.583497,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.580392,
                    g: 0,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.491019,
                    g: -0.18587,
                    b: 0.74158,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.401416,
                    g: -0.273028,
                    b: 0.657251,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.310403,
                    g: -0.284273,
                    b: 0.57456,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.214954,
                    g: -0.242404,
                    b: 0.493625,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.121074,
                    g: -0.219567,
                    b: 0.415175,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.074449,
                    g: -0.28293,
                    b: 0.34057,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.094912,
                    g: -0.40171,
                    b: 0.270867,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.580392,
                    g: 0,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.670095,
                    g: 0.167208,
                    b: 0.914785,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.760419,
                    g: 0.268852,
                    b: 1.003512,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.851526,
                    g: 0.360176,
                    b: 1.093571,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.943506,
                    g: 0.448266,
                    b: 1.184908,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.036409,
                    g: 0.535417,
                    b: 1.277474,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.13026,
                    g: 0.622617,
                    b: 1.371223,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.22507,
                    g: 0.710347,
                    b: 1.466113,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.861102,
                    g: 0.617228,
                    b: 0.967301,
                    a: 1,
                },
                {
                    r: 0.720747,
                    g: 0.308614,
                    b: 0.897376,
                    a: 1,
                },
                {
                    r: 0.580392,
                    g: 0,
                    b: 0.827451,
                    a: 1,
                },
                {
                    r: 0.412425,
                    g: 0,
                    b: 0.641699,
                    a: 1,
                },
                {
                    r: 0.244457,
                    g: 0,
                    b: 0.455948,
                    a: 1,
                },
            ],
        },
        {
            name: "deeppink",
            hexRGBString: "#ff1493",
            hexRGBAString: "#ff1493ff",
            hexARGBString: "#ffff1493",
            webRGBString: "rgb(255,20,147)",
            webRGBAString: "rgba(255,20,147,1)",
            lum: 0.238669,
            temp: 3665,
            rgba: {
                r: 1,
                g: 0.078431,
                b: 0.576471,
                a: 1,
            },
            hsl: {
                h: 327.57443,
                s: 1,
                l: 0.539216,
            },
            hsv: {
                h: 327.57443,
                s: 0.921569,
                v: 1,
            },
            xyz: {
                x: 0.467604,
                y: 0.238734,
                z: 0.297439,
            },
            lab: {
                l: 55.960839,
                a: 84.538706,
                b: -5.700072,
            },
            lch: {
                l: 55.960839,
                c: 84.730653,
                h: 356.142637,
            },
            lchToLabResult: {
                l: 55.960839,
                a: 84.538706,
                b: -5.700072,
            },
            labToLCHResult: {
                l: 55.960839,
                c: 84.730653,
                h: 356.142637,
            },
            labToXYZResult: {
                x: 0.467604,
                y: 0.238734,
                z: 0.297439,
            },
            xyzToLABResult: {
                l: 55.960816,
                a: 84.538742,
                b: -5.700116,
            },
            rgbToXYZResult: {
                x: 0.467604,
                y: 0.238734,
                z: 0.297439,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.07843,
                b: 0.576471,
                a: 1,
            },
            rgbToLABResult: {
                l: 55.960839,
                a: 84.538706,
                b: -5.700072,
            },
            labToRGBResult: {
                r: 1,
                g: 0.078432,
                b: 0.576471,
                a: 1,
            },
            rgbToLCHResult: {
                l: 55.960839,
                c: 84.730653,
                h: 356.142637,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.078432,
                b: 0.576471,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.078432,
                    b: 0.576471,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.037983,
                    g: -0.256975,
                    b: 0.581261,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.075604,
                    g: -0.617936,
                    b: 0.586081,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.112914,
                    g: -0.992762,
                    b: 0.590931,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.149957,
                    g: -1.381713,
                    b: 0.595812,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.186771,
                    g: -1.785051,
                    b: 0.600722,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.223387,
                    g: -2.203035,
                    b: 0.605663,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.259834,
                    g: -2.635925,
                    b: 0.610635,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.078432,
                    b: 0.576471,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.961595,
                    g: 0.199173,
                    b: 0.571711,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.922695,
                    g: 0.266393,
                    b: 0.566982,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.883214,
                    g: 0.316232,
                    b: 0.562283,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.843046,
                    g: 0.356523,
                    b: 0.557613,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.802058,
                    g: 0.390536,
                    b: 0.552974,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.760087,
                    g: 0.420005,
                    b: 0.548364,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.716921,
                    g: 0.445978,
                    b: 0.543784,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.078432,
                    b: 0.576471,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.903981,
                    g: -0.263714,
                    b: 0.498506,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.80873,
                    g: -0.480889,
                    b: 0.422726,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.714207,
                    g: -0.583943,
                    b: 0.349343,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.620351,
                    g: -0.595674,
                    b: 0.27863,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.527074,
                    g: -0.538883,
                    b: 0.210952,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.434251,
                    g: -0.43637,
                    b: 0.146828,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.34609,
                    g: -0.348483,
                    b: 0.086591,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.078432,
                    b: 0.576471,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.096813,
                    g: 0.239477,
                    b: 0.656446,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.194436,
                    g: 0.350301,
                    b: 0.738289,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.292875,
                    g: 0.449757,
                    b: 0.821877,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.392135,
                    g: 0.544817,
                    b: 0.907107,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.492212,
                    g: 0.638033,
                    b: 0.993888,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.593104,
                    g: 0.7306,
                    b: 1.08214,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.694803,
                    g: 0.823148,
                    b: 1.171792,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.638686,
                    b: 0.856056,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.358559,
                    b: 0.716264,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.078431,
                    b: 0.576471,
                    a: 1,
                },
                {
                    r: 0.777927,
                    g: 0.039216,
                    b: 0.404508,
                    a: 1,
                },
                {
                    r: 0.555855,
                    g: 0,
                    b: 0.232545,
                    a: 1,
                },
            ],
        },
        {
            name: "deepskyblue",
            hexRGBString: "#00bfff",
            hexRGBAString: "#00bfffff",
            hexARGBString: "#ff00bfff",
            webRGBString: "rgb(0,191,255)",
            webRGBAString: "rgba(0,191,255,1)",
            lum: 0.444816,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0.74902,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 195.0588,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 195.0588,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.366733,
                y: 0.444767,
                z: 1.012403,
            },
            lab: {
                l: 72.54595,
                a: -17.65861,
                b: -42.541125,
            },
            lch: {
                l: 72.54595,
                c: 46.060545,
                h: 247.456904,
            },
            lchToLabResult: {
                l: 72.54595,
                a: -17.65861,
                b: -42.541125,
            },
            labToLCHResult: {
                l: 72.54595,
                c: 46.060545,
                h: 247.456905,
            },
            labToXYZResult: {
                x: 0.366733,
                y: 0.444767,
                z: 1.012403,
            },
            xyzToLABResult: {
                l: 72.545978,
                a: -17.658828,
                b: -42.541096,
            },
            rgbToXYZResult: {
                x: 0.366733,
                y: 0.444767,
                z: 1.012403,
            },
            xyzToRGBResult: {
                r: -0.000022,
                g: 0.749021,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 72.54595,
                a: -17.65861,
                b: -42.541125,
            },
            labToRGBResult: {
                r: 0.000001,
                g: 0.74902,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 72.54595,
                c: 46.060545,
                h: 247.456904,
            },
            lchToRGBResult: {
                r: 0.000001,
                g: 0.74902,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.74902,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -1.11161,
                    g: 0.757554,
                    b: 1.051438,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -2.271214,
                    g: 0.766095,
                    b: 1.10316,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -3.480762,
                    g: 0.77465,
                    b: 1.155174,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -4.742206,
                    g: 0.783227,
                    b: 1.207486,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -6.057499,
                    g: 0.791831,
                    b: 1.2601,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -7.428591,
                    g: 0.80047,
                    b: 1.31302,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -8.857435,
                    g: 0.809148,
                    b: 1.366245,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.74902,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.318009,
                    g: 0.740485,
                    b: 0.948834,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.438589,
                    g: 0.73194,
                    b: 0.897923,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.524413,
                    g: 0.723377,
                    b: 0.847245,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.592643,
                    g: 0.714785,
                    b: 0.796772,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.64977,
                    g: 0.706156,
                    b: 0.746465,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.697733,
                    g: 0.697733,
                    b: 0.697733,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.697733,
                    g: 0.697733,
                    b: 0.697733,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.74902,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.477491,
                    g: 0.666775,
                    b: 0.912512,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.792962,
                    g: 0.58636,
                    b: 0.826508,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.96921,
                    g: 0.507911,
                    b: 0.742065,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.029036,
                    g: 0.431594,
                    b: 0.659274,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.99524,
                    g: 0.357609,
                    b: 0.578233,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.890619,
                    g: 0.286214,
                    b: 0.49906,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.737975,
                    g: 0.217756,
                    b: 0.421891,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.74902,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.250964,
                    g: 0.83298,
                    b: 1.088902,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.378957,
                    g: 0.918555,
                    b: 1.179156,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.488735,
                    g: 1.005659,
                    b: 1.270705,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.591336,
                    g: 1.094213,
                    b: 1.363497,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.690556,
                    g: 1.184151,
                    b: 1.457485,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.788137,
                    g: 1.275411,
                    b: 1.552626,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.885006,
                    g: 1.367938,
                    b: 1.64888,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.54611,
                    g: 0.917186,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.273055,
                    g: 0.833103,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.74902,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.551216,
                    b: 0.789523,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.353412,
                    b: 0.579045,
                    a: 1,
                },
            ],
        },
        {
            name: "dimgray",
            hexRGBString: "#696969",
            hexRGBAString: "#696969ff",
            hexARGBString: "#ff696969",
            webRGBString: "rgb(105,105,105)",
            webRGBAString: "rgba(105,105,105,1)",
            lum: 0.141264,
            temp: 6650,
            rgba: {
                r: 0.411765,
                g: 0.411765,
                b: 0.411765,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0.411765,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0.411765,
            },
            xyz: {
                x: 0.134267,
                y: 0.141264,
                z: 0.153812,
            },
            lab: {
                l: 44.413593,
                a: -0.000009,
                b: 0.000003,
            },
            lch: {
                l: 44.413593,
                c: 0.000009,
                h: 0,
            },
            lchToLabResult: {
                l: 44.413593,
                a: -0.000008,
                b: 0.000003,
            },
            labToLCHResult: {
                l: 44.413593,
                c: 0.000009,
                h: 0,
            },
            labToXYZResult: {
                x: 0.134267,
                y: 0.141264,
                z: 0.153812,
            },
            xyzToLABResult: {
                l: 44.413661,
                a: -0.000125,
                b: 0.000109,
            },
            rgbToXYZResult: {
                x: 0.134267,
                y: 0.141264,
                z: 0.153812,
            },
            xyzToRGBResult: {
                r: 0.411765,
                g: 0.411766,
                b: 0.411765,
                a: 1,
            },
            rgbToLABResult: {
                l: 44.413593,
                a: -0.000009,
                b: 0.000003,
            },
            labToRGBResult: {
                r: 0.411765,
                g: 0.411765,
                b: 0.411765,
                a: 1,
            },
            rgbToLCHResult: {
                l: 44.413593,
                c: 0.000009,
                h: 0,
            },
            lchToRGBResult: {
                r: 0.411765,
                g: 0.411765,
                b: 0.411765,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.338492,
                    g: 0.338492,
                    b: 0.338492,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.26786,
                    g: 0.26786,
                    b: 0.26786,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.200205,
                    g: 0.200205,
                    b: 0.200205,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.135983,
                    g: 0.135983,
                    b: 0.135983,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.07414,
                    g: 0.07414,
                    b: 0.07414,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.026777,
                    g: -0.026777,
                    b: -0.026777,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.137116,
                    g: -0.137116,
                    b: -0.137116,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.48742,
                    g: 0.48742,
                    b: 0.48742,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.565252,
                    g: 0.565252,
                    b: 0.565252,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.645092,
                    g: 0.645092,
                    b: 0.645092,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.726798,
                    g: 0.726798,
                    b: 0.726798,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.81025,
                    g: 0.81025,
                    b: 0.81025,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.895346,
                    g: 0.895346,
                    b: 0.895346,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.981996,
                    g: 0.981996,
                    b: 0.981996,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.782353,
                    g: 0.782353,
                    b: 0.782353,
                    a: 1,
                },
                {
                    r: 0.597059,
                    g: 0.597059,
                    b: 0.597059,
                    a: 1,
                },
                {
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    r: 0.268858,
                    g: 0.268858,
                    b: 0.268858,
                    a: 1,
                },
                {
                    r: 0.125952,
                    g: 0.125952,
                    b: 0.125952,
                    a: 1,
                },
            ],
        },
        {
            name: "dimgrey",
            hexRGBString: "#696969",
            hexRGBAString: "#696969ff",
            hexARGBString: "#ff696969",
            webRGBString: "rgb(105,105,105)",
            webRGBAString: "rgba(105,105,105,1)",
            lum: 0.141264,
            temp: 6650,
            rgba: {
                r: 0.411765,
                g: 0.411765,
                b: 0.411765,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0.411765,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0.411765,
            },
            xyz: {
                x: 0.134267,
                y: 0.141264,
                z: 0.153812,
            },
            lab: {
                l: 44.413593,
                a: -0.000009,
                b: 0.000003,
            },
            lch: {
                l: 44.413593,
                c: 0.000009,
                h: 0,
            },
            lchToLabResult: {
                l: 44.413593,
                a: -0.000008,
                b: 0.000003,
            },
            labToLCHResult: {
                l: 44.413593,
                c: 0.000009,
                h: 0,
            },
            labToXYZResult: {
                x: 0.134267,
                y: 0.141264,
                z: 0.153812,
            },
            xyzToLABResult: {
                l: 44.413661,
                a: -0.000125,
                b: 0.000109,
            },
            rgbToXYZResult: {
                x: 0.134267,
                y: 0.141264,
                z: 0.153812,
            },
            xyzToRGBResult: {
                r: 0.411765,
                g: 0.411766,
                b: 0.411765,
                a: 1,
            },
            rgbToLABResult: {
                l: 44.413593,
                a: -0.000009,
                b: 0.000003,
            },
            labToRGBResult: {
                r: 0.411765,
                g: 0.411765,
                b: 0.411765,
                a: 1,
            },
            rgbToLCHResult: {
                l: 44.413593,
                c: 0.000009,
                h: 0,
            },
            lchToRGBResult: {
                r: 0.411765,
                g: 0.411765,
                b: 0.411765,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.338492,
                    g: 0.338492,
                    b: 0.338492,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.26786,
                    g: 0.26786,
                    b: 0.26786,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.200205,
                    g: 0.200205,
                    b: 0.200205,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.135983,
                    g: 0.135983,
                    b: 0.135983,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.07414,
                    g: 0.07414,
                    b: 0.07414,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.026777,
                    g: -0.026777,
                    b: -0.026777,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.137116,
                    g: -0.137116,
                    b: -0.137116,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.48742,
                    g: 0.48742,
                    b: 0.48742,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.565252,
                    g: 0.565252,
                    b: 0.565252,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.645092,
                    g: 0.645092,
                    b: 0.645092,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.726798,
                    g: 0.726798,
                    b: 0.726798,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.81025,
                    g: 0.81025,
                    b: 0.81025,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.895346,
                    g: 0.895346,
                    b: 0.895346,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.981996,
                    g: 0.981996,
                    b: 0.981996,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.782353,
                    g: 0.782353,
                    b: 0.782353,
                    a: 1,
                },
                {
                    r: 0.597059,
                    g: 0.597059,
                    b: 0.597059,
                    a: 1,
                },
                {
                    r: 0.411765,
                    g: 0.411765,
                    b: 0.411765,
                    a: 1,
                },
                {
                    r: 0.268858,
                    g: 0.268858,
                    b: 0.268858,
                    a: 1,
                },
                {
                    r: 0.125952,
                    g: 0.125952,
                    b: 0.125952,
                    a: 1,
                },
            ],
        },
        {
            name: "dodgerblue",
            hexRGBString: "#1e90ff",
            hexRGBAString: "#1e90ffff",
            hexARGBString: "#ff1e90ff",
            webRGBString: "rgb(30,144,255)",
            webRGBAString: "rgba(30,144,255,1)",
            lum: 0.274425,
            temp: 40000,
            rgba: {
                r: 0.117647,
                g: 0.564706,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 209.59999,
                s: 1,
                l: 0.558824,
            },
            hsv: {
                h: 209.59999,
                s: 0.882353,
                v: 1,
            },
            xyz: {
                x: 0.285518,
                y: 0.274388,
                z: 0.983797,
            },
            lab: {
                l: 59.378311,
                a: 9.95757,
                b: -63.387828,
            },
            lch: {
                l: 59.378311,
                c: 64.165177,
                h: 278.927614,
            },
            lchToLabResult: {
                l: 59.378311,
                a: 9.957571,
                b: -63.387828,
            },
            labToLCHResult: {
                l: 59.378311,
                c: 64.165177,
                h: 278.927613,
            },
            labToXYZResult: {
                x: 0.285518,
                y: 0.274388,
                z: 0.983797,
            },
            xyzToLABResult: {
                l: 59.378304,
                a: 9.957444,
                b: -63.387834,
            },
            rgbToXYZResult: {
                x: 0.285518,
                y: 0.274388,
                z: 0.983797,
            },
            xyzToRGBResult: {
                r: 0.117641,
                g: 0.564706,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 59.378311,
                a: 9.95757,
                b: -63.387828,
            },
            labToRGBResult: {
                r: 0.117647,
                g: 0.564706,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 59.378311,
                c: 64.165177,
                h: 278.927614,
            },
            lchToRGBResult: {
                r: 0.117647,
                g: 0.564706,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.117647,
                    g: 0.564706,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.482786,
                    g: 0.566598,
                    b: 1.054325,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -1.193786,
                    g: 0.568827,
                    b: 1.109028,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -1.967582,
                    g: 0.5714,
                    b: 1.164114,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -2.806501,
                    g: 0.574325,
                    b: 1.219583,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -3.712867,
                    g: 0.577608,
                    b: 1.275436,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -4.689003,
                    g: 0.581256,
                    b: 1.331671,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -5.737236,
                    g: 0.585273,
                    b: 1.388286,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.117647,
                    g: 0.564706,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.269037,
                    g: 0.56314,
                    b: 0.946048,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.349799,
                    g: 0.56189,
                    b: 0.892459,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.406893,
                    g: 0.560944,
                    b: 0.839218,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.450657,
                    g: 0.560291,
                    b: 0.786303,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.485455,
                    g: 0.559918,
                    b: 0.733684,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.513626,
                    g: 0.559812,
                    b: 0.681316,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.5366,
                    g: 0.559959,
                    b: 0.629138,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.117647,
                    g: 0.564706,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.323822,
                    g: 0.488032,
                    b: 0.911815,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.653358,
                    g: 0.413789,
                    b: 0.825059,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.843664,
                    g: 0.342293,
                    b: 0.739805,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.917542,
                    g: 0.273983,
                    b: 0.656136,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.89779,
                    g: 0.209516,
                    b: 0.574146,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.807208,
                    g: 0.149959,
                    b: 0.493951,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.662706,
                    g: 0.093384,
                    b: 0.415779,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.117647,
                    g: 0.564706,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.283504,
                    g: 0.643574,
                    b: 1.089551,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.401267,
                    g: 0.724449,
                    b: 1.180411,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.506403,
                    g: 0.807179,
                    b: 1.272526,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.606235,
                    g: 0.891638,
                    b: 1.365849,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.703573,
                    g: 0.977719,
                    b: 1.460338,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.799774,
                    g: 1.065331,
                    b: 1.555951,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.895577,
                    g: 1.154394,
                    b: 1.652652,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.622959,
                    g: 0.843696,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.370303,
                    g: 0.704201,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.117647,
                    g: 0.564706,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.058824,
                    g: 0.390215,
                    b: 0.794836,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.215725,
                    b: 0.589672,
                    a: 1,
                },
            ],
        },
        {
            name: "firebrick",
            hexRGBString: "#b22222",
            hexRGBAString: "#b22222ff",
            hexARGBString: "#ffb22222",
            webRGBString: "rgb(178,34,34)",
            webRGBAString: "rgba(178,34,34,1)",
            lum: 0.107245,
            temp: 2260,
            rgba: {
                r: 0.698039,
                g: 0.133333,
                b: 0.133333,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0.679246,
                l: 0.415686,
            },
            hsv: {
                h: 0,
                s: 0.808989,
                v: 0.698039,
            },
            xyz: {
                x: 0.192232,
                y: 0.107276,
                z: 0.025715,
            },
            lab: {
                l: 39.117912,
                a: 55.916776,
                b: 37.649074,
            },
            lch: {
                l: 39.117912,
                c: 67.410227,
                h: 33.9526,
            },
            lchToLabResult: {
                l: 39.117912,
                a: 55.916777,
                b: 37.649074,
            },
            labToLCHResult: {
                l: 39.117912,
                c: 67.410226,
                h: 33.9526,
            },
            labToXYZResult: {
                x: 0.192232,
                y: 0.107276,
                z: 0.025715,
            },
            xyzToLABResult: {
                l: 39.117839,
                a: 55.917019,
                b: 37.649224,
            },
            rgbToXYZResult: {
                x: 0.192232,
                y: 0.107276,
                z: 0.025715,
            },
            xyzToRGBResult: {
                r: 0.698039,
                g: 0.13333,
                b: 0.133331,
                a: 1,
            },
            rgbToLABResult: {
                l: 39.117912,
                a: 55.916776,
                b: 37.649074,
            },
            labToRGBResult: {
                r: 0.698039,
                g: 0.133333,
                b: 0.133333,
                a: 1,
            },
            rgbToLCHResult: {
                l: 39.117912,
                c: 67.410227,
                h: 33.9526,
            },
            lchToRGBResult: {
                r: 0.698039,
                g: 0.133333,
                b: 0.133333,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.698039,
                    g: 0.133333,
                    b: 0.133333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.728409,
                    g: 0.042792,
                    b: 0.106343,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.758111,
                    g: -0.127509,
                    b: 0.078123,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.787262,
                    g: -0.30466,
                    b: 0.047228,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.815967,
                    g: -0.488778,
                    b: 0.014778,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.844424,
                    g: -0.680273,
                    b: -0.015466,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.87271,
                    g: -0.879382,
                    b: -0.045273,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.900852,
                    g: -1.086256,
                    b: -0.074634,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.698039,
                    g: 0.133333,
                    b: 0.133333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.666854,
                    g: 0.183445,
                    b: 0.159698,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.634674,
                    g: 0.220573,
                    b: 0.185747,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.601267,
                    g: 0.250597,
                    b: 0.211653,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.566335,
                    g: 0.275967,
                    b: 0.237525,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.529475,
                    g: 0.29798,
                    b: 0.26343,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.490128,
                    g: 0.317422,
                    b: 0.289414,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.447477,
                    g: 0.334813,
                    b: 0.315509,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.698039,
                    g: 0.133333,
                    b: 0.133333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.604283,
                    g: -0.017954,
                    b: 0.068933,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.512189,
                    g: -0.141652,
                    b: -0.011142,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.424261,
                    g: -0.18861,
                    b: -0.111964,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.342284,
                    g: -0.180663,
                    b: -0.225041,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.277568,
                    g: -0.195262,
                    b: -0.340872,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.246331,
                    g: -0.287594,
                    b: -0.452245,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.223428,
                    g: -0.397933,
                    b: -0.562584,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.698039,
                    g: 0.133333,
                    b: 0.133333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.792559,
                    g: 0.229442,
                    b: 0.20014,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.887863,
                    g: 0.316125,
                    b: 0.269605,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.983967,
                    g: 0.400336,
                    b: 0.341609,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.080883,
                    g: 0.48416,
                    b: 0.415979,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.178618,
                    g: 0.568443,
                    b: 0.492542,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.277174,
                    g: 0.653572,
                    b: 0.571147,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.376551,
                    g: 0.739739,
                    b: 0.651657,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.931084,
                    g: 0.661912,
                    b: 0.66405,
                    a: 1,
                },
                {
                    r: 0.814561,
                    g: 0.397622,
                    b: 0.398692,
                    a: 1,
                },
                {
                    r: 0.698039,
                    g: 0.133333,
                    b: 0.133333,
                    a: 1,
                },
                {
                    r: 0.535918,
                    g: 0.066667,
                    b: 0.066667,
                    a: 1,
                },
                {
                    r: 0.373796,
                    g: 0,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "floralwhite",
            hexRGBString: "#fffaf0",
            hexRGBAString: "#fffaf0ff",
            hexARGBString: "#fffffaf0",
            webRGBString: "rgb(255,250,240)",
            webRGBAString: "rgba(255,250,240,1)",
            lum: 0.959225,
            temp: 6027,
            rgba: {
                r: 1,
                g: 0.980392,
                b: 0.941176,
                a: 1,
            },
            hsl: {
                h: 40,
                s: 1,
                l: 0.970588,
            },
            hsv: {
                h: 40,
                s: 0.058824,
                v: 1,
            },
            xyz: {
                x: 0.911517,
                y: 0.95923,
                z: 0.961341,
            },
            lab: {
                l: 98.401635,
                a: -0.03654,
                b: 5.376236,
            },
            lch: {
                l: 98.401635,
                c: 5.37636,
                h: 90.389411,
            },
            lchToLabResult: {
                l: 98.401635,
                a: -0.03654,
                b: 5.376236,
            },
            labToLCHResult: {
                l: 98.401635,
                c: 5.37636,
                h: 90.389409,
            },
            labToXYZResult: {
                x: 0.911517,
                y: 0.95923,
                z: 0.961341,
            },
            xyzToLABResult: {
                l: 98.401637,
                a: -0.036481,
                b: 5.376242,
            },
            rgbToXYZResult: {
                x: 0.911517,
                y: 0.95923,
                z: 0.961341,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.980392,
                b: 0.941176,
                a: 1,
            },
            rgbToLABResult: {
                l: 98.401635,
                a: -0.03654,
                b: 5.376236,
            },
            labToRGBResult: {
                r: 1,
                g: 0.980392,
                b: 0.941176,
                a: 1,
            },
            rgbToLCHResult: {
                l: 98.401635,
                c: 5.37636,
                h: 90.389411,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.980392,
                b: 0.941176,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.980392,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.023617,
                    g: 0.978428,
                    b: 0.882707,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.044684,
                    g: 0.976628,
                    b: 0.82402,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.06347,
                    g: 0.974985,
                    b: 0.764958,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.080205,
                    g: 0.973494,
                    b: 0.705304,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.095084,
                    g: 0.972148,
                    b: 0.644754,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.108275,
                    g: 0.970942,
                    b: 0.582858,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.119928,
                    g: 0.969867,
                    b: 0.518932,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.980392,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.98186,
                    g: 0.98186,
                    b: 0.98186,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.98186,
                    g: 0.98186,
                    b: 0.98186,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.98186,
                    g: 0.98186,
                    b: 0.98186,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.98186,
                    g: 0.98186,
                    b: 0.98186,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.98186,
                    g: 0.98186,
                    b: 0.98186,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.98186,
                    g: 0.98186,
                    b: 0.98186,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.98186,
                    g: 0.98186,
                    b: 0.98186,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.980392,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.912988,
                    g: 0.893773,
                    b: 0.855232,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.827507,
                    g: 0.80871,
                    b: 0.77088,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.743642,
                    g: 0.725292,
                    b: 0.688216,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.661492,
                    g: 0.643623,
                    b: 0.60735,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.581172,
                    g: 0.563824,
                    b: 0.528411,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.502815,
                    g: 0.486036,
                    b: 0.45155,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.426578,
                    g: 0.410429,
                    b: 0.376951,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.980392,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.088466,
                    g: 1.068486,
                    b: 1.028629,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.178317,
                    g: 1.157985,
                    b: 1.117516,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.269493,
                    g: 1.248826,
                    b: 1.207772,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.361938,
                    g: 1.340952,
                    b: 1.299336,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.455603,
                    g: 1.43431,
                    b: 1.392156,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.550441,
                    g: 1.528855,
                    b: 1.486181,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.646412,
                    g: 1.624543,
                    b: 1.581367,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.991188,
                    b: 0.930432,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.98579,
                    b: 0.935804,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.980392,
                    b: 0.941176,
                    a: 1,
                },
                {
                    r: 0.76058,
                    g: 0.728115,
                    b: 0.642746,
                    a: 1,
                },
                {
                    r: 0.52116,
                    g: 0.475837,
                    b: 0.344315,
                    a: 1,
                },
            ],
        },
        {
            name: "forestgreen",
            hexRGBString: "#228b22",
            hexRGBAString: "#228b22ff",
            hexARGBString: "#ff228b22",
            webRGBString: "rgb(34,139,34)",
            webRGBAString: "rgba(34,139,34,1)",
            lum: 0.189208,
            temp: 6650,
            rgba: {
                r: 0.133333,
                g: 0.545098,
                b: 0.133333,
                a: 1,
            },
            hsl: {
                h: 120,
                s: 0.606937,
                l: 0.339216,
            },
            hsv: {
                h: 120,
                s: 0.755396,
                v: 0.545098,
            },
            xyz: {
                x: 0.101804,
                y: 0.189196,
                z: 0.046284,
            },
            lab: {
                l: 50.593067,
                a: -49.585401,
                b: 45.01599,
            },
            lch: {
                l: 50.593067,
                c: 66.971273,
                h: 137.765336,
            },
            lchToLabResult: {
                l: 50.593067,
                a: -49.585401,
                b: 45.01599,
            },
            labToLCHResult: {
                l: 50.593067,
                c: 66.971273,
                h: 137.765336,
            },
            labToXYZResult: {
                x: 0.101804,
                y: 0.189196,
                z: 0.046284,
            },
            xyzToLABResult: {
                l: 50.593009,
                a: -49.585202,
                b: 45.015826,
            },
            rgbToXYZResult: {
                x: 0.101804,
                y: 0.189196,
                z: 0.046284,
            },
            xyzToRGBResult: {
                r: 0.133335,
                g: 0.545097,
                b: 0.133334,
                a: 1,
            },
            rgbToLABResult: {
                l: 50.593067,
                a: -49.585401,
                b: 45.01599,
            },
            labToRGBResult: {
                r: 0.133333,
                g: 0.545098,
                b: 0.133333,
                a: 1,
            },
            rgbToLCHResult: {
                l: 50.593067,
                c: 66.971273,
                h: 137.765336,
            },
            lchToRGBResult: {
                r: 0.133333,
                g: 0.545098,
                b: 0.133333,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.133333,
                    g: 0.545098,
                    b: 0.133333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.031929,
                    g: 0.551398,
                    b: 0.065543,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.265227,
                    g: 0.557349,
                    b: -0.045391,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.492845,
                    g: 0.562967,
                    b: -0.143543,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.714406,
                    g: 0.568268,
                    b: -0.225191,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.929533,
                    g: 0.573266,
                    b: -0.291896,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.137076,
                    g: 0.57797,
                    b: -0.346855,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.33265,
                    g: 0.582368,
                    b: -0.400132,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.133333,
                    g: 0.545098,
                    b: 0.133333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.205502,
                    g: 0.53843,
                    b: 0.183344,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.257778,
                    g: 0.531373,
                    b: 0.226766,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.300666,
                    g: 0.523903,
                    b: 0.266798,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.337828,
                    g: 0.515996,
                    b: 0.304846,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.371038,
                    g: 0.507623,
                    b: 0.341654,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.401303,
                    g: 0.49875,
                    b: 0.377666,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.42926,
                    g: 0.48934,
                    b: 0.413164,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.133333,
                    g: 0.545098,
                    b: 0.133333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.044454,
                    g: 0.465619,
                    b: 0.037133,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.184394,
                    g: 0.388002,
                    b: -0.049015,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.222928,
                    g: 0.31218,
                    b: -0.102181,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.168421,
                    g: 0.237812,
                    b: -0.175778,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.147763,
                    g: 0.17264,
                    b: -0.268718,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.242458,
                    g: 0.129334,
                    b: -0.376981,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.352797,
                    g: 0.075671,
                    b: -0.487319,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.133333,
                    g: 0.545098,
                    b: 0.133333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.23694,
                    g: 0.626344,
                    b: 0.213109,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.327764,
                    g: 0.709269,
                    b: 0.290582,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.414951,
                    g: 0.793789,
                    b: 0.368316,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.501137,
                    g: 0.87983,
                    b: 0.447123,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.587394,
                    g: 0.967323,
                    b: 0.527299,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.674228,
                    g: 1.056204,
                    b: 0.608948,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.761898,
                    g: 1.146417,
                    b: 0.692088,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.648252,
                    g: 0.840663,
                    b: 0.650811,
                    a: 1,
                },
                {
                    r: 0.390793,
                    g: 0.692881,
                    b: 0.392072,
                    a: 1,
                },
                {
                    r: 0.133333,
                    g: 0.545098,
                    b: 0.133333,
                    a: 1,
                },
                {
                    r: 0.066667,
                    g: 0.375903,
                    b: 0.066667,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.206707,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "fuchsia",
            hexRGBString: "#ff00ff",
            hexRGBAString: "#ff00ffff",
            hexARGBString: "#ffff00ff",
            webRGBString: "rgb(255,0,255)",
            webRGBAString: "rgba(255,0,255,1)",
            lum: 0.2848,
            temp: 6650,
            rgba: {
                r: 1,
                g: 0,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 300,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 300,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.592894,
                y: 0.284848,
                z: 0.969638,
            },
            lab: {
                l: 60.324212,
                a: 98.234312,
                b: -60.824892,
            },
            lch: {
                l: 60.324212,
                c: 115.540675,
                h: 328.234965,
            },
            lchToLabResult: {
                l: 60.324212,
                a: 98.234312,
                b: -60.824892,
            },
            labToLCHResult: {
                l: 60.324212,
                c: 115.540675,
                h: 328.234965,
            },
            labToXYZResult: {
                x: 0.592894,
                y: 0.284848,
                z: 0.969638,
            },
            xyzToLABResult: {
                l: 60.324221,
                a: 98.234297,
                b: -60.824877,
            },
            rgbToXYZResult: {
                x: 0.592894,
                y: 0.284848,
                z: 0.969638,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.000003,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 60.324212,
                a: 98.234312,
                b: -60.824892,
            },
            labToRGBResult: {
                r: 1,
                g: 0.000001,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 60.324212,
                c: 115.540675,
                h: 328.234965,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.000001,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.000001,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.02533,
                    g: -0.313574,
                    b: 1.029247,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.050448,
                    g: -0.63639,
                    b: 1.05859,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.075372,
                    g: -0.968579,
                    b: 1.08803,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.100118,
                    g: -1.310271,
                    b: 1.117569,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.1247,
                    g: -1.661599,
                    b: 1.147207,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.149133,
                    g: -2.022694,
                    b: 1.176947,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.173428,
                    g: -2.393689,
                    b: 1.206788,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.000001,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.974437,
                    g: 0.166328,
                    b: 0.970846,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.948618,
                    g: 0.238614,
                    b: 0.941783,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.922517,
                    g: 0.290499,
                    b: 0.912808,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.896105,
                    g: 0.332071,
                    b: 0.883916,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.869347,
                    g: 0.367125,
                    b: 0.855105,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.842205,
                    g: 0.397576,
                    b: 0.826368,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.814633,
                    g: 0.424546,
                    b: 0.797699,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.000001,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.905668,
                    g: -0.387446,
                    b: 0.911598,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.812206,
                    g: -0.629453,
                    b: 0.824606,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.719577,
                    g: -0.748818,
                    b: 0.739093,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.627725,
                    g: -0.76834,
                    b: 0.655137,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.536549,
                    g: -0.71082,
                    b: 0.572829,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.445887,
                    g: -0.599057,
                    b: 0.492277,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.355777,
                    g: -0.458917,
                    b: 0.413652,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.000001,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.095219,
                    g: 0.229385,
                    b: 1.089751,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.191334,
                    g: 0.350545,
                    b: 1.180794,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.288345,
                    g: 0.455518,
                    b: 1.273081,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.386248,
                    g: 0.554329,
                    b: 1.366565,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.485036,
                    g: 0.65039,
                    b: 1.461203,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.584699,
                    g: 0.745248,
                    b: 1.556957,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.685226,
                    g: 0.839717,
                    b: 1.65379,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.611883,
                    b: 1,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.305942,
                    b: 1,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.767057,
                    g: 0,
                    b: 0.771258,
                    a: 1,
                },
                {
                    r: 0.534114,
                    g: 0,
                    b: 0.542516,
                    a: 1,
                },
            ],
        },
        {
            name: "gainsboro",
            hexRGBString: "#dcdcdc",
            hexRGBAString: "#dcdcdcff",
            hexARGBString: "#ffdcdcdc",
            webRGBString: "rgb(220,220,220)",
            webRGBAString: "rgba(220,220,220,1)",
            lum: 0.715693,
            temp: 6650,
            rgba: {
                r: 0.862745,
                g: 0.862745,
                b: 0.862745,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0.862745,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0.862745,
            },
            xyz: {
                x: 0.680245,
                y: 0.715693,
                z: 0.779268,
            },
            lab: {
                l: 87.760883,
                a: -0.000015,
                b: 0.000006,
            },
            lch: {
                l: 87.760883,
                c: 0.000016,
                h: 0,
            },
            lchToLabResult: {
                l: 87.760883,
                a: -0.000015,
                b: 0.000006,
            },
            labToLCHResult: {
                l: 87.760883,
                c: 0.000016,
                h: 0,
            },
            labToXYZResult: {
                x: 0.680245,
                y: 0.715693,
                z: 0.779268,
            },
            xyzToLABResult: {
                l: 87.760864,
                a: 0.00006,
                b: 0.000001,
            },
            rgbToXYZResult: {
                x: 0.680245,
                y: 0.715693,
                z: 0.779268,
            },
            xyzToRGBResult: {
                r: 0.862745,
                g: 0.862745,
                b: 0.862745,
                a: 1,
            },
            rgbToLABResult: {
                l: 87.760883,
                a: -0.000015,
                b: 0.000006,
            },
            labToRGBResult: {
                r: 0.862745,
                g: 0.862745,
                b: 0.862745,
                a: 1,
            },
            rgbToLCHResult: {
                l: 87.760883,
                c: 0.000016,
                h: 0,
            },
            lchToRGBResult: {
                r: 0.862745,
                g: 0.862745,
                b: 0.862745,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.778264,
                    g: 0.778264,
                    b: 0.778264,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.695463,
                    g: 0.695463,
                    b: 0.695463,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.614453,
                    g: 0.614453,
                    b: 0.614453,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.53536,
                    g: 0.53536,
                    b: 0.53536,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.458336,
                    g: 0.458336,
                    b: 0.458336,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.383561,
                    g: 0.383561,
                    b: 0.383561,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.31126,
                    g: 0.311261,
                    b: 0.31126,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.948813,
                    g: 0.948813,
                    b: 0.948813,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.036383,
                    g: 1.036383,
                    b: 1.036383,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.125383,
                    g: 1.125383,
                    b: 1.125383,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.215747,
                    g: 1.215747,
                    b: 1.215747,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.307415,
                    g: 1.307415,
                    b: 1.307415,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.400334,
                    g: 1.400334,
                    b: 1.400334,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.494456,
                    g: 1.494456,
                    b: 1.494456,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.949216,
                    g: 0.949216,
                    b: 0.949216,
                    a: 1,
                },
                {
                    r: 0.90598,
                    g: 0.90598,
                    b: 0.90598,
                    a: 1,
                },
                {
                    r: 0.862745,
                    g: 0.862745,
                    b: 0.862745,
                    a: 1,
                },
                {
                    r: 0.635061,
                    g: 0.635061,
                    b: 0.635061,
                    a: 1,
                },
                {
                    r: 0.407378,
                    g: 0.407378,
                    b: 0.407378,
                    a: 1,
                },
            ],
        },
        {
            name: "ghostwhite",
            hexRGBString: "#f8f8ff",
            hexRGBAString: "#f8f8ffff",
            hexARGBString: "#fff8f8ff",
            webRGBString: "rgb(248,248,255)",
            webRGBAString: "rgba(248,248,255,1)",
            lum: 0.943113,
            temp: 6876,
            rgba: {
                r: 0.972549,
                g: 0.972549,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 240,
                s: 1,
                l: 0.986275,
            },
            hsv: {
                h: 240,
                s: 0.027451,
                v: 1,
            },
            xyz: {
                x: 0.903256,
                y: 0.943111,
                z: 1.080336,
            },
            lab: {
                l: 97.757214,
                a: 1.247117,
                b: -3.345468,
            },
            lch: {
                l: 97.757214,
                c: 3.570359,
                h: 290.444352,
            },
            lchToLabResult: {
                l: 97.757214,
                a: 1.247117,
                b: -3.345469,
            },
            labToLCHResult: {
                l: 97.757214,
                c: 3.570358,
                h: 290.44435,
            },
            labToXYZResult: {
                x: 0.903256,
                y: 0.943111,
                z: 1.080336,
            },
            xyzToLABResult: {
                l: 97.757208,
                a: 1.247144,
                b: -3.345455,
            },
            rgbToXYZResult: {
                x: 0.903256,
                y: 0.943111,
                z: 1.080336,
            },
            xyzToRGBResult: {
                r: 0.972549,
                g: 0.972549,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 97.757214,
                a: 1.247117,
                b: -3.345468,
            },
            labToRGBResult: {
                r: 0.972549,
                g: 0.972549,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 97.757214,
                c: 3.570359,
                h: 290.444352,
            },
            lchToRGBResult: {
                r: 0.972549,
                g: 0.972549,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.972549,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.966917,
                    g: 0.968241,
                    b: 1.054931,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.959449,
                    g: 0.964004,
                    b: 1.109877,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.950015,
                    g: 0.959844,
                    b: 1.164886,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.938465,
                    g: 0.955768,
                    b: 1.219999,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.924621,
                    g: 0.951783,
                    b: 1.275245,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.90827,
                    g: 0.947897,
                    b: 1.33065,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.889151,
                    g: 0.944116,
                    b: 1.386234,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.972549,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.974565,
                    g: 0.974565,
                    b: 0.974565,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.974565,
                    g: 0.974565,
                    b: 0.974565,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.974565,
                    g: 0.974565,
                    b: 0.974565,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.974565,
                    g: 0.974565,
                    b: 0.974565,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.974565,
                    g: 0.974565,
                    b: 0.974565,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.974565,
                    g: 0.974565,
                    b: 0.974565,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.974565,
                    g: 0.974565,
                    b: 0.974565,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.972549,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.886051,
                    g: 0.886064,
                    b: 0.913037,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.801113,
                    g: 0.801142,
                    b: 0.827609,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.717828,
                    g: 0.717874,
                    b: 0.743804,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.636298,
                    g: 0.636364,
                    b: 0.661723,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.556647,
                    g: 0.556735,
                    b: 0.581481,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.479016,
                    g: 0.479131,
                    b: 0.503214,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.403576,
                    g: 0.403724,
                    b: 0.427085,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.972549,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.060528,
                    g: 1.060516,
                    b: 1.088422,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.149917,
                    g: 1.149894,
                    b: 1.178233,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.240652,
                    g: 1.240618,
                    b: 1.269372,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.332675,
                    g: 1.332632,
                    b: 1.361784,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.425935,
                    g: 1.425884,
                    b: 1.455417,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.520385,
                    g: 1.520325,
                    b: 1.550226,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.61598,
                    g: 1.615913,
                    b: 1.646168,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.985622,
                    g: 0.986339,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.979085,
                    g: 0.979444,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.972549,
                    g: 0.972549,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.712894,
                    g: 0.719564,
                    b: 0.794078,
                    a: 1,
                },
                {
                    r: 0.453239,
                    g: 0.466579,
                    b: 0.588156,
                    a: 1,
                },
            ],
        },
        {
            name: "gold",
            hexRGBString: "#ffd700",
            hexRGBAString: "#ffd700ff",
            hexARGBString: "#ffffd700",
            webRGBString: "rgb(255,215,0)",
            webRGBAString: "rgba(255,215,0,1)",
            lum: 0.698608,
            temp: 1000,
            rgba: {
                r: 1,
                g: 0.843137,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 50.58822,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 50.58822,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.655444,
                y: 0.698649,
                z: 0.10033,
            },
            lab: {
                l: 86.930553,
                a: -1.923716,
                b: 87.132025,
            },
            lch: {
                l: 86.930553,
                c: 87.153258,
                h: 91.264781,
            },
            lchToLabResult: {
                l: 86.930553,
                a: -1.923716,
                b: 87.132025,
            },
            labToLCHResult: {
                l: 86.930553,
                c: 87.153258,
                h: 91.264781,
            },
            labToXYZResult: {
                x: 0.655444,
                y: 0.698649,
                z: 0.10033,
            },
            xyzToLABResult: {
                l: 86.93056,
                a: -1.923831,
                b: 87.131998,
            },
            rgbToXYZResult: {
                x: 0.655444,
                y: 0.698649,
                z: 0.10033,
            },
            xyzToRGBResult: {
                r: 0.999999,
                g: 0.843137,
                b: 0.000001,
                a: 1,
            },
            rgbToLABResult: {
                l: 86.930553,
                a: -1.923716,
                b: 87.132025,
            },
            labToRGBResult: {
                r: 1,
                g: 0.843137,
                b: -0.000001,
                a: 1,
            },
            rgbToLCHResult: {
                l: 86.930553,
                c: 87.153258,
                h: 91.264781,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.843137,
                b: -0.000001,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.843137,
                    b: -0.000001,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.004074,
                    g: 0.843002,
                    b: -0.322439,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.007257,
                    g: 0.842959,
                    b: -0.590059,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.00964,
                    g: 0.842998,
                    b: -0.807977,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.011312,
                    g: 0.843112,
                    b: -0.98131,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.012358,
                    g: 0.843292,
                    b: -1.115175,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.012863,
                    g: 0.843529,
                    b: -1.21469,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.012995,
                    g: 0.843805,
                    b: -1.290577,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.843137,
                    b: -0.000001,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.994937,
                    g: 0.843372,
                    b: 0.188368,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.988782,
                    g: 0.843715,
                    b: 0.281098,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.981423,
                    g: 0.844176,
                    b: 0.356323,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.97274,
                    g: 0.844761,
                    b: 0.423818,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.962597,
                    g: 0.84548,
                    b: 0.487094,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.950847,
                    g: 0.846341,
                    b: 0.547837,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.93732,
                    g: 0.84735,
                    b: 0.606991,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.843137,
                    b: -0.000001,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.905524,
                    g: 0.759685,
                    b: -0.235364,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.812086,
                    g: 0.677991,
                    b: -0.361321,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.719745,
                    g: 0.598171,
                    b: -0.400671,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.628708,
                    g: 0.520348,
                    b: -0.380232,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.540964,
                    g: 0.444479,
                    b: -0.371761,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.457972,
                    g: 0.370609,
                    b: -0.392109,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.38125,
                    g: 0.298807,
                    b: -0.437829,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.843137,
                    b: -0.000001,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.095476,
                    g: 0.928244,
                    b: 0.184397,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.191922,
                    g: 1.014916,
                    b: 0.291074,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.289313,
                    g: 1.103072,
                    b: 0.38576,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.387628,
                    g: 1.192641,
                    b: 0.476398,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.486847,
                    g: 1.283559,
                    b: 0.565607,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.586953,
                    g: 1.375768,
                    b: 0.654537,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.687927,
                    g: 1.469216,
                    b: 0.743762,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.94307,
                    b: 0.58055,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.893103,
                    b: 0.290275,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.843137,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.748474,
                    g: 0.619283,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.496949,
                    g: 0.395429,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "goldenrod",
            hexRGBString: "#daa520",
            hexRGBAString: "#daa520ff",
            hexARGBString: "#ffdaa520",
            webRGBString: "rgb(218,165,32)",
            webRGBAString: "rgba(218,165,32,1)",
            lum: 0.4192,
            temp: 2151,
            rgba: {
                r: 0.854902,
                g: 0.647059,
                b: 0.12549,
                a: 1,
            },
            hsl: {
                h: 42.903243,
                s: 0.744,
                l: 0.490196,
            },
            hsv: {
                h: 42.903243,
                s: 0.853211,
                v: 0.854902,
            },
            xyz: {
                x: 0.426323,
                y: 0.419233,
                z: 0.072129,
            },
            lab: {
                l: 70.817987,
                a: 8.524074,
                b: 68.761885,
            },
            lch: {
                l: 70.817987,
                c: 69.288215,
                h: 82.933374,
            },
            lchToLabResult: {
                l: 70.817987,
                a: 8.524074,
                b: 68.761885,
            },
            labToLCHResult: {
                l: 70.817987,
                c: 69.288214,
                h: 82.933374,
            },
            labToXYZResult: {
                x: 0.426323,
                y: 0.419233,
                z: 0.072129,
            },
            xyzToLABResult: {
                l: 70.818007,
                a: 8.524104,
                b: 68.761734,
            },
            rgbToXYZResult: {
                x: 0.426323,
                y: 0.419233,
                z: 0.072129,
            },
            xyzToRGBResult: {
                r: 0.854902,
                g: 0.647059,
                b: 0.125492,
                a: 1,
            },
            rgbToLABResult: {
                l: 70.817987,
                a: 8.524074,
                b: 68.761885,
            },
            labToRGBResult: {
                r: 0.854902,
                g: 0.647059,
                b: 0.12549,
                a: 1,
            },
            rgbToLCHResult: {
                l: 70.817987,
                c: 69.288215,
                h: 82.933374,
            },
            lchToRGBResult: {
                r: 0.854902,
                g: 0.647059,
                b: 0.12549,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.854902,
                    g: 0.647059,
                    b: 0.12549,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.865401,
                    g: 0.644054,
                    b: -0.065099,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.874845,
                    g: 0.641133,
                    b: -0.268901,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.883373,
                    g: 0.638285,
                    b: -0.429795,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.891112,
                    g: 0.635501,
                    b: -0.552788,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.898182,
                    g: 0.632769,
                    b: -0.642885,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.904858,
                    g: 0.630056,
                    b: -0.714025,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.911489,
                    g: 0.627316,
                    b: -0.784781,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.854902,
                    g: 0.647059,
                    b: 0.12549,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.843196,
                    g: 0.650159,
                    b: 0.215147,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.830115,
                    g: 0.653364,
                    b: 0.285113,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.815466,
                    g: 0.656683,
                    b: 0.347526,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.79903,
                    g: 0.660126,
                    b: 0.406129,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.780551,
                    g: 0.663701,
                    b: 0.462596,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.75972,
                    g: 0.667417,
                    b: 0.517819,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.73616,
                    g: 0.671283,
                    b: 0.572324,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.854902,
                    g: 0.647059,
                    b: 0.12549,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.763228,
                    g: 0.56762,
                    b: -0.027663,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.672685,
                    g: 0.490228,
                    b: -0.143526,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.583345,
                    g: 0.415053,
                    b: -0.183802,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.496855,
                    g: 0.342097,
                    b: -0.209514,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.415476,
                    g: 0.271295,
                    b: -0.259914,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.341038,
                    g: 0.20261,
                    b: -0.331556,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.276592,
                    g: 0.135596,
                    b: -0.420995,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.854902,
                    g: 0.647059,
                    b: 0.12549,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.947662,
                    g: 0.728401,
                    b: 0.222093,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.041473,
                    g: 0.811521,
                    b: 0.308511,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.136307,
                    g: 0.896312,
                    b: 0.392319,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.232141,
                    g: 0.982682,
                    b: 0.475716,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.328952,
                    g: 1.070547,
                    b: 0.55958,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.426717,
                    g: 1.159834,
                    b: 0.64431,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.525418,
                    g: 1.250479,
                    b: 0.730098,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.959071,
                    g: 0.868441,
                    b: 0.628741,
                    a: 1,
                },
                {
                    r: 0.906986,
                    g: 0.75775,
                    b: 0.377116,
                    a: 1,
                },
                {
                    r: 0.854902,
                    g: 0.647059,
                    b: 0.12549,
                    a: 1,
                },
                {
                    r: 0.639619,
                    g: 0.453227,
                    b: 0.062745,
                    a: 1,
                },
                {
                    r: 0.424337,
                    g: 0.259394,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "gray",
            hexRGBString: "#808080",
            hexRGBAString: "#808080ff",
            hexARGBString: "#ff808080",
            webRGBString: "rgb(128,128,128)",
            webRGBAString: "rgba(128,128,128,1)",
            lum: 0.215861,
            temp: 6650,
            rgba: {
                r: 0.501961,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0.501961,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0.501961,
            },
            xyz: {
                x: 0.205169,
                y: 0.215861,
                z: 0.235036,
            },
            lab: {
                l: 53.585037,
                a: -0.00001,
                b: 0.000004,
            },
            lch: {
                l: 53.585037,
                c: 0.000011,
                h: 0,
            },
            lchToLabResult: {
                l: 53.585037,
                a: -0.00001,
                b: 0.000004,
            },
            labToLCHResult: {
                l: 53.585037,
                c: 0.000011,
                h: 0,
            },
            labToXYZResult: {
                x: 0.205169,
                y: 0.215861,
                z: 0.235036,
            },
            xyzToLABResult: {
                l: 53.585067,
                a: -0.000197,
                b: -0.000011,
            },
            rgbToXYZResult: {
                x: 0.205169,
                y: 0.215861,
                z: 0.235036,
            },
            xyzToRGBResult: {
                r: 0.50196,
                g: 0.501962,
                b: 0.501961,
                a: 1,
            },
            rgbToLABResult: {
                l: 53.585037,
                a: -0.00001,
                b: 0.000004,
            },
            labToRGBResult: {
                r: 0.501961,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            rgbToLCHResult: {
                l: 53.585037,
                c: 0.000011,
                h: 0,
            },
            lchToRGBResult: {
                r: 0.501961,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.42588,
                    g: 0.42588,
                    b: 0.42588,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.352139,
                    g: 0.352139,
                    b: 0.352139,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.280986,
                    g: 0.280986,
                    b: 0.280986,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.212738,
                    g: 0.212738,
                    b: 0.212738,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.147824,
                    g: 0.147824,
                    b: 0.147824,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.086696,
                    g: 0.086696,
                    b: 0.086696,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.005935,
                    g: -0.005935,
                    b: -0.005935,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.580184,
                    g: 0.580184,
                    b: 0.580184,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.660386,
                    g: 0.660386,
                    b: 0.660386,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.742431,
                    g: 0.742431,
                    b: 0.742431,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.826201,
                    g: 0.826201,
                    b: 0.826201,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.911597,
                    g: 0.911597,
                    b: 0.911597,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.998531,
                    g: 0.998531,
                    b: 0.998531,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.086924,
                    g: 1.086924,
                    b: 1.086924,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.815726,
                    g: 0.815726,
                    b: 0.815726,
                    a: 1,
                },
                {
                    r: 0.658843,
                    g: 0.658843,
                    b: 0.658843,
                    a: 1,
                },
                {
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    r: 0.331706,
                    g: 0.331706,
                    b: 0.331706,
                    a: 1,
                },
                {
                    r: 0.161451,
                    g: 0.161451,
                    b: 0.161451,
                    a: 1,
                },
            ],
        },
        {
            name: "green",
            hexRGBString: "#008000",
            hexRGBAString: "#008000ff",
            hexARGBString: "#ff008000",
            webRGBString: "rgb(0,128,0)",
            webRGBAString: "rgba(0,128,0,1)",
            lum: 0.154384,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0.501961,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 120,
                s: 1,
                l: 0.250981,
            },
            hsv: {
                h: 120,
                s: 1,
                v: 0.501961,
            },
            xyz: {
                x: 0.077187,
                y: 0.154373,
                z: 0.025729,
            },
            lab: {
                l: 46.227451,
                a: -51.698512,
                b: 49.896861,
            },
            lch: {
                l: 46.227451,
                c: 71.850072,
                h: 136.015953,
            },
            lchToLabResult: {
                l: 46.227451,
                a: -51.698511,
                b: 49.896861,
            },
            labToLCHResult: {
                l: 46.227451,
                c: 71.850072,
                h: 136.015954,
            },
            labToXYZResult: {
                x: 0.077187,
                y: 0.154373,
                z: 0.025729,
            },
            xyzToLABResult: {
                l: 46.227416,
                a: -51.698016,
                b: 49.896705,
            },
            rgbToXYZResult: {
                x: 0.077187,
                y: 0.154373,
                z: 0.025729,
            },
            xyzToRGBResult: {
                r: 0.00002,
                g: 0.50196,
                b: 0.000003,
                a: 1,
            },
            rgbToLABResult: {
                l: 46.227451,
                a: -51.698512,
                b: 49.896861,
            },
            labToRGBResult: {
                r: 0,
                g: 0.501961,
                b: 0,
                a: 1,
            },
            rgbToLCHResult: {
                l: 46.227451,
                c: 71.850072,
                h: 136.015953,
            },
            lchToRGBResult: {
                r: 0,
                g: 0.501961,
                b: 0,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.501961,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.2,
                    g: 0.507656,
                    b: -0.093674,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.395439,
                    g: 0.513024,
                    b: -0.170476,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.585836,
                    g: 0.518079,
                    b: -0.232129,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.767655,
                    g: 0.522816,
                    b: -0.286825,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.938039,
                    g: 0.527232,
                    b: -0.341325,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.097314,
                    g: 0.531344,
                    b: -0.395634,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.245806,
                    g: 0.535169,
                    b: -0.449758,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.501961,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.132345,
                    g: 0.495922,
                    b: 0.091048,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.195991,
                    g: 0.489522,
                    b: 0.147114,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.24317,
                    g: 0.482739,
                    b: 0.19284,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.282135,
                    g: 0.475551,
                    b: 0.234051,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.315954,
                    g: 0.467933,
                    b: 0.272832,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.346147,
                    g: 0.459855,
                    b: 0.310182,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.373595,
                    g: 0.451285,
                    b: 0.346657,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.501961,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.176593,
                    g: 0.423338,
                    b: -0.080572,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.243664,
                    g: 0.346477,
                    b: -0.124033,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.207338,
                    g: 0.27109,
                    b: -0.188539,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.138697,
                    g: 0.199601,
                    b: -0.273008,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.194179,
                    g: 0.148476,
                    b: -0.376066,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.304518,
                    g: 0.104394,
                    b: -0.486404,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.414856,
                    g: 0.028143,
                    b: -0.596743,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0.501961,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.164281,
                    g: 0.582382,
                    b: 0.116098,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.26534,
                    g: 0.664513,
                    b: 0.201722,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.356394,
                    g: 0.748271,
                    b: 0.28187,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.44435,
                    g: 0.83358,
                    b: 0.361201,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.531439,
                    g: 0.920369,
                    b: 0.441091,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.618615,
                    g: 1.008574,
                    b: 0.522058,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.706347,
                    g: 1.098135,
                    b: 0.604314,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.597892,
                    g: 0.824284,
                    b: 0.601215,
                    a: 1,
                },
                {
                    r: 0.298946,
                    g: 0.663123,
                    b: 0.300607,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.501961,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.339045,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.176129,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "greenyellow",
            hexRGBString: "#adff2f",
            hexRGBAString: "#adff2fff",
            hexARGBString: "#ffadff2f",
            webRGBString: "rgb(173,255,47)",
            webRGBAString: "rgba(173,255,47,1)",
            lum: 0.806095,
            temp: 2481,
            rgba: {
                r: 0.678431,
                g: 1,
                b: 0.184314,
                a: 1,
            },
            hsl: {
                h: 83.653882,
                s: 1,
                l: 0.592157,
            },
            hsv: {
                h: 83.653882,
                s: 0.815686,
                v: 1,
            },
            xyz: {
                x: 0.535064,
                y: 0.806077,
                z: 0.154285,
            },
            lab: {
                l: 91.956822,
                a: -52.480878,
                b: 81.864459,
            },
            lch: {
                l: 91.956822,
                c: 97.242131,
                h: 122.662728,
            },
            lchToLabResult: {
                l: 91.956822,
                a: -52.480877,
                b: 81.864459,
            },
            labToLCHResult: {
                l: 91.956822,
                c: 97.242132,
                h: 122.662729,
            },
            labToXYZResult: {
                x: 0.535064,
                y: 0.806077,
                z: 0.154285,
            },
            xyzToLABResult: {
                l: 91.95684,
                a: -52.481062,
                b: 81.864445,
            },
            rgbToXYZResult: {
                x: 0.535064,
                y: 0.806077,
                z: 0.154285,
            },
            xyzToRGBResult: {
                r: 0.678429,
                g: 1.000001,
                b: 0.184314,
                a: 1,
            },
            rgbToLABResult: {
                l: 91.956822,
                a: -52.480878,
                b: 81.864459,
            },
            labToRGBResult: {
                r: 0.678431,
                g: 1,
                b: 0.184314,
                a: 1,
            },
            rgbToLCHResult: {
                l: 91.956822,
                c: 97.242131,
                h: 122.662728,
            },
            lchToRGBResult: {
                r: 0.678431,
                g: 1,
                b: 0.184314,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.678431,
                    g: 1,
                    b: 0.184314,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.649533,
                    g: 1.006307,
                    b: -0.014023,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.618353,
                    g: 1.012487,
                    b: -0.349081,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.584537,
                    g: 1.01854,
                    b: -0.640964,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.547598,
                    g: 1.024467,
                    b: -0.892732,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.506831,
                    g: 1.030267,
                    b: -1.107443,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.461162,
                    g: 1.035942,
                    b: -1.288152,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.408813,
                    g: 1.04149,
                    b: -1.43792,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.678431,
                    g: 1,
                    b: 0.184314,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.705307,
                    g: 0.993566,
                    b: 0.275642,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.730362,
                    g: 0.987004,
                    b: 0.347722,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.75375,
                    g: 0.980314,
                    b: 0.411122,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.775591,
                    g: 0.973495,
                    b: 0.469616,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.795983,
                    g: 0.966546,
                    b: 0.525026,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.815,
                    g: 0.959467,
                    b: 0.578379,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.832705,
                    g: 0.952257,
                    b: 0.63031,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.678431,
                    g: 1,
                    b: 0.184314,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.587993,
                    g: 0.912201,
                    b: -0.00264,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.497558,
                    g: 0.825838,
                    b: -0.239721,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.406328,
                    g: 0.740974,
                    b: -0.36678,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.312584,
                    g: 0.657677,
                    b: -0.406614,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.211991,
                    g: 0.576012,
                    b: -0.38495,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.095656,
                    g: 0.495884,
                    b: -0.372838,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.0653,
                    g: 0.417242,
                    b: -0.390177,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.678431,
                    g: 1,
                    b: 0.184314,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.769285,
                    g: 1.089174,
                    b: 0.291502,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.860787,
                    g: 1.179669,
                    b: 0.386476,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.953068,
                    g: 1.271432,
                    b: 0.47732,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.046205,
                    g: 1.364417,
                    b: 0.566693,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.140242,
                    g: 1.458581,
                    b: 0.655757,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.235201,
                    g: 1.553883,
                    b: 0.745099,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.331091,
                    g: 1.650285,
                    b: 0.835035,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.866165,
                    g: 1,
                    b: 0.65648,
                    a: 1,
                },
                {
                    r: 0.772298,
                    g: 1,
                    b: 0.420397,
                    a: 1,
                },
                {
                    r: 0.678431,
                    g: 1,
                    b: 0.184314,
                    a: 1,
                },
                {
                    r: 0.448383,
                    g: 0.750312,
                    b: 0.092157,
                    a: 1,
                },
                {
                    r: 0.218335,
                    g: 0.500624,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "grey",
            hexRGBString: "#808080",
            hexRGBAString: "#808080ff",
            hexARGBString: "#ff808080",
            webRGBString: "rgb(128,128,128)",
            webRGBAString: "rgba(128,128,128,1)",
            lum: 0.215861,
            temp: 6650,
            rgba: {
                r: 0.501961,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0.501961,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0.501961,
            },
            xyz: {
                x: 0.205169,
                y: 0.215861,
                z: 0.235036,
            },
            lab: {
                l: 53.585037,
                a: -0.00001,
                b: 0.000004,
            },
            lch: {
                l: 53.585037,
                c: 0.000011,
                h: 0,
            },
            lchToLabResult: {
                l: 53.585037,
                a: -0.00001,
                b: 0.000004,
            },
            labToLCHResult: {
                l: 53.585037,
                c: 0.000011,
                h: 0,
            },
            labToXYZResult: {
                x: 0.205169,
                y: 0.215861,
                z: 0.235036,
            },
            xyzToLABResult: {
                l: 53.585067,
                a: -0.000197,
                b: -0.000011,
            },
            rgbToXYZResult: {
                x: 0.205169,
                y: 0.215861,
                z: 0.235036,
            },
            xyzToRGBResult: {
                r: 0.50196,
                g: 0.501962,
                b: 0.501961,
                a: 1,
            },
            rgbToLABResult: {
                l: 53.585037,
                a: -0.00001,
                b: 0.000004,
            },
            labToRGBResult: {
                r: 0.501961,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            rgbToLCHResult: {
                l: 53.585037,
                c: 0.000011,
                h: 0,
            },
            lchToRGBResult: {
                r: 0.501961,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.42588,
                    g: 0.42588,
                    b: 0.42588,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.352139,
                    g: 0.352139,
                    b: 0.352139,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.280986,
                    g: 0.280986,
                    b: 0.280986,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.212738,
                    g: 0.212738,
                    b: 0.212738,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.147824,
                    g: 0.147824,
                    b: 0.147824,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.086696,
                    g: 0.086696,
                    b: 0.086696,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.005935,
                    g: -0.005935,
                    b: -0.005935,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.580184,
                    g: 0.580184,
                    b: 0.580184,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.660386,
                    g: 0.660386,
                    b: 0.660386,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.742431,
                    g: 0.742431,
                    b: 0.742431,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.826201,
                    g: 0.826201,
                    b: 0.826201,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.911597,
                    g: 0.911597,
                    b: 0.911597,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.998531,
                    g: 0.998531,
                    b: 0.998531,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.086924,
                    g: 1.086924,
                    b: 1.086924,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.815726,
                    g: 0.815726,
                    b: 0.815726,
                    a: 1,
                },
                {
                    r: 0.658843,
                    g: 0.658843,
                    b: 0.658843,
                    a: 1,
                },
                {
                    r: 0.501961,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    r: 0.331706,
                    g: 0.331706,
                    b: 0.331706,
                    a: 1,
                },
                {
                    r: 0.161451,
                    g: 0.161451,
                    b: 0.161451,
                    a: 1,
                },
            ],
        },
        {
            name: "honeydew",
            hexRGBString: "#f0fff0",
            hexRGBAString: "#f0fff0ff",
            hexARGBString: "#fff0fff0",
            webRGBString: "rgb(240,255,240)",
            webRGBAString: "rgba(240,255,240,1)",
            lum: 0.963365,
            temp: 6650,
            rgba: {
                r: 0.941176,
                g: 1,
                b: 0.941176,
                a: 1,
            },
            hsl: {
                h: 120,
                s: 1,
                l: 0.970588,
            },
            hsv: {
                h: 120,
                s: 0.058824,
                v: 1,
            },
            xyz: {
                x: 0.874204,
                y: 0.963359,
                z: 0.964102,
            },
            lab: {
                l: 98.56555,
                a: -7.565,
                b: 5.475361,
            },
            lch: {
                l: 98.56555,
                c: 9.338565,
                h: 144.103902,
            },
            lchToLabResult: {
                l: 98.56555,
                a: -7.564999,
                b: 5.475361,
            },
            labToLCHResult: {
                l: 98.56555,
                c: 9.338565,
                h: 144.103905,
            },
            labToXYZResult: {
                x: 0.874204,
                y: 0.963359,
                z: 0.964102,
            },
            xyzToLABResult: {
                l: 98.565549,
                a: -7.564954,
                b: 5.475342,
            },
            rgbToXYZResult: {
                x: 0.874204,
                y: 0.963359,
                z: 0.964102,
            },
            xyzToRGBResult: {
                r: 0.941176,
                g: 1,
                b: 0.941176,
                a: 1,
            },
            rgbToLABResult: {
                l: 98.56555,
                a: -7.565,
                b: 5.475361,
            },
            labToRGBResult: {
                r: 0.941176,
                g: 1,
                b: 0.941176,
                a: 1,
            },
            rgbToLCHResult: {
                l: 98.56555,
                c: 9.338565,
                h: 144.103902,
            },
            lchToRGBResult: {
                r: 0.941176,
                g: 1,
                b: 0.941176,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.904682,
                    g: 1.012852,
                    b: 0.905922,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.866776,
                    g: 1.025194,
                    b: 0.870534,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.827235,
                    g: 1.037052,
                    b: 0.834974,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.785776,
                    g: 1.048451,
                    b: 0.799197,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.742028,
                    g: 1.059412,
                    b: 0.763149,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.695491,
                    g: 1.069956,
                    b: 0.726763,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.645466,
                    g: 1.080101,
                    b: 0.689956,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.976437,
                    g: 0.986609,
                    b: 0.976327,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.983718,
                    g: 0.983718,
                    b: 0.983718,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.983718,
                    g: 0.983718,
                    b: 0.983718,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.983718,
                    g: 0.983718,
                    b: 0.983718,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.983718,
                    g: 0.983718,
                    b: 0.983718,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.983718,
                    g: 0.983718,
                    b: 0.983718,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.983718,
                    g: 0.983718,
                    b: 0.983718,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.855171,
                    g: 0.913011,
                    b: 0.855227,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.77075,
                    g: 0.827555,
                    b: 0.77087,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.688009,
                    g: 0.743718,
                    b: 0.6882,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.607054,
                    g: 0.661601,
                    b: 0.607328,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.52801,
                    g: 0.581317,
                    b: 0.528381,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.451025,
                    g: 0.503002,
                    b: 0.451511,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.376274,
                    g: 0.426816,
                    b: 0.376901,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.028684,
                    g: 1.088445,
                    b: 1.028633,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.117621,
                    g: 1.178277,
                    b: 1.117524,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.207921,
                    g: 1.269436,
                    b: 1.207783,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.299527,
                    g: 1.361865,
                    b: 1.299351,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.392384,
                    g: 1.455515,
                    b: 1.392173,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.486445,
                    g: 1.55034,
                    b: 1.4862,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.581664,
                    g: 1.646297,
                    b: 1.581389,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.949065,
                    g: 1,
                    b: 0.949608,
                    a: 1,
                },
                {
                    r: 0.945121,
                    g: 1,
                    b: 0.945392,
                    a: 1,
                },
                {
                    r: 0.941176,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    r: 0.659826,
                    g: 0.755298,
                    b: 0.665179,
                    a: 1,
                },
                {
                    r: 0.378476,
                    g: 0.510597,
                    b: 0.389182,
                    a: 1,
                },
            ],
        },
        {
            name: "hotpink",
            hexRGBString: "#ff69b4",
            hexRGBAString: "#ff69b4ff",
            hexARGBString: "#ffff69b4",
            webRGBString: "rgb(255,105,180)",
            webRGBAString: "rgba(255,105,180,1)",
            lum: 0.346584,
            temp: 4370,
            rgba: {
                r: 1,
                g: 0.411765,
                b: 0.705882,
                a: 1,
            },
            hsl: {
                h: 330.000051,
                s: 1,
                l: 0.705883,
            },
            hsv: {
                h: 330.000051,
                s: 0.588235,
                v: 1,
            },
            xyz: {
                x: 0.545322,
                y: 0.346639,
                z: 0.4699,
            },
            lab: {
                l: 65.486168,
                a: 64.238414,
                b: -10.646288,
            },
            lch: {
                l: 65.486168,
                c: 65.114647,
                h: 350.589854,
            },
            lchToLabResult: {
                l: 65.486168,
                a: 64.238414,
                b: -10.646288,
            },
            labToLCHResult: {
                l: 65.486168,
                c: 65.114647,
                h: 350.589854,
            },
            labToXYZResult: {
                x: 0.545322,
                y: 0.346639,
                z: 0.4699,
            },
            xyzToLABResult: {
                l: 65.48615,
                a: 64.238385,
                b: -10.646302,
            },
            rgbToXYZResult: {
                x: 0.545322,
                y: 0.346639,
                z: 0.4699,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.411765,
                b: 0.705882,
                a: 1,
            },
            rgbToLABResult: {
                l: 65.486168,
                a: 64.238414,
                b: -10.646288,
            },
            labToRGBResult: {
                r: 1,
                g: 0.411765,
                b: 0.705882,
                a: 1,
            },
            rgbToLCHResult: {
                l: 65.486168,
                c: 65.114647,
                h: 350.589854,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.411765,
                b: 0.705882,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.411765,
                    b: 0.705882,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.039816,
                    g: 0.36901,
                    b: 0.715685,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.079104,
                    g: 0.317135,
                    b: 0.725498,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.117933,
                    g: 0.249692,
                    b: 0.735322,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.156366,
                    g: 0.144555,
                    b: 0.745158,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.194453,
                    g: -0.195435,
                    b: 0.755005,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.23224,
                    g: -0.643237,
                    b: 0.764865,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.269764,
                    g: -1.106187,
                    b: 0.774737,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.411765,
                    b: 0.705882,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.959568,
                    g: 0.448333,
                    b: 0.696089,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.918417,
                    g: 0.480339,
                    b: 0.686306,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.876418,
                    g: 0.508794,
                    b: 0.676532,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.833415,
                    g: 0.534378,
                    b: 0.666765,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.789206,
                    g: 0.557576,
                    b: 0.657007,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.743533,
                    g: 0.578745,
                    b: 0.647255,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.696053,
                    g: 0.59816,
                    b: 0.637509,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.411765,
                    b: 0.705882,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.907729,
                    g: 0.324224,
                    b: 0.624573,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.816513,
                    g: 0.232522,
                    b: 0.545156,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.726357,
                    g: 0.125981,
                    b: 0.467775,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.637251,
                    g: -0.062169,
                    b: 0.392605,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.549174,
                    g: -0.20229,
                    b: 0.319858,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.462078,
                    g: -0.255329,
                    b: 0.249804,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.375873,
                    g: -0.244086,
                    b: 0.182792,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.411765,
                    b: 0.705882,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.093316,
                    g: 0.498092,
                    b: 0.788959,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.187663,
                    g: 0.584384,
                    b: 0.873698,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.283025,
                    g: 0.671197,
                    b: 0.960007,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.379382,
                    g: 0.758812,
                    b: 1.047806,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.476716,
                    g: 0.847379,
                    b: 1.137021,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.575006,
                    g: 0.936975,
                    b: 1.227589,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.674233,
                    g: 1.027637,
                    b: 1.319452,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.764799,
                    b: 0.903475,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.588282,
                    b: 0.804678,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.411765,
                    b: 0.705882,
                    a: 1,
                },
                {
                    r: 0.779762,
                    g: 0.205883,
                    b: 0.517228,
                    a: 1,
                },
                {
                    r: 0.559524,
                    g: 0,
                    b: 0.328573,
                    a: 1,
                },
            ],
        },
        {
            name: "indianred",
            hexRGBString: "#cd5c5c",
            hexRGBAString: "#cd5c5cff",
            hexARGBString: "#ffcd5c5c",
            webRGBString: "rgb(205,92,92)",
            webRGBAString: "rgba(205,92,92,1)",
            lum: 0.214061,
            temp: 3094,
            rgba: {
                r: 0.803922,
                g: 0.360784,
                b: 0.360784,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0.530517,
                l: 0.582353,
            },
            hsv: {
                h: 0,
                s: 0.55122,
                v: 0.803922,
            },
            xyz: {
                x: 0.309383,
                y: 0.214098,
                z: 0.126264,
            },
            lab: {
                l: 53.395116,
                a: 44.828356,
                b: 22.117179,
            },
            lch: {
                l: 53.395116,
                c: 49.98751,
                h: 26.260568,
            },
            lchToLabResult: {
                l: 53.395116,
                a: 44.828356,
                b: 22.117179,
            },
            labToLCHResult: {
                l: 53.395116,
                c: 49.98751,
                h: 26.260568,
            },
            labToXYZResult: {
                x: 0.309383,
                y: 0.214098,
                z: 0.126264,
            },
            xyzToLABResult: {
                l: 53.395109,
                a: 44.828429,
                b: 22.11713,
            },
            rgbToXYZResult: {
                x: 0.309383,
                y: 0.214098,
                z: 0.126264,
            },
            xyzToRGBResult: {
                r: 0.803922,
                g: 0.360784,
                b: 0.360784,
                a: 1,
            },
            rgbToLABResult: {
                l: 53.395116,
                a: 44.828356,
                b: 22.117179,
            },
            labToRGBResult: {
                r: 0.803922,
                g: 0.360784,
                b: 0.360784,
                a: 1,
            },
            rgbToLCHResult: {
                l: 53.395116,
                c: 49.98751,
                h: 26.260568,
            },
            lchToRGBResult: {
                r: 0.803922,
                g: 0.360784,
                b: 0.360784,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.803922,
                    g: 0.360784,
                    b: 0.360784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.842616,
                    g: 0.328279,
                    b: 0.339866,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.880166,
                    g: 0.289887,
                    b: 0.319131,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.916753,
                    g: 0.242464,
                    b: 0.298596,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.952522,
                    g: 0.178345,
                    b: 0.278283,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.987595,
                    g: 0.059481,
                    b: 0.258218,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.02207,
                    g: -0.230447,
                    b: 0.238437,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.056032,
                    g: -0.533618,
                    b: 0.218987,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.803922,
                    g: 0.360784,
                    b: 0.360784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.763856,
                    g: 0.389056,
                    b: 0.381872,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.722124,
                    g: 0.414089,
                    b: 0.40312,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.67834,
                    g: 0.436538,
                    b: 0.424519,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.631977,
                    g: 0.456861,
                    b: 0.44606,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.582282,
                    g: 0.475394,
                    b: 0.467739,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.528128,
                    g: 0.49239,
                    b: 0.48955,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.500062,
                    g: 0.500061,
                    b: 0.500061,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.803922,
                    g: 0.360784,
                    b: 0.360784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.713421,
                    g: 0.281435,
                    b: 0.289192,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.623945,
                    g: 0.201342,
                    b: 0.220448,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.53547,
                    g: 0.116003,
                    b: 0.154966,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.447956,
                    g: 0.001394,
                    b: 0.09336,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.362676,
                    g: -0.078168,
                    b: 0.014071,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.284043,
                    g: -0.099866,
                    b: -0.09843,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.229274,
                    g: -0.15581,
                    b: -0.211892,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.803922,
                    g: 0.360784,
                    b: 0.360784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.895454,
                    g: 0.440719,
                    b: 0.434916,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.988018,
                    g: 0.521743,
                    b: 0.511351,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.081604,
                    g: 0.60406,
                    b: 0.589896,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.176201,
                    g: 0.687746,
                    b: 0.670394,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.271793,
                    g: 0.772817,
                    b: 0.752714,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.368366,
                    g: 0.859259,
                    b: 0.83674,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.465899,
                    g: 0.947044,
                    b: 0.922377,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.972983,
                    g: 0.74671,
                    b: 0.748279,
                    a: 1,
                },
                {
                    r: 0.888453,
                    g: 0.553747,
                    b: 0.554532,
                    a: 1,
                },
                {
                    r: 0.803922,
                    g: 0.360784,
                    b: 0.360784,
                    a: 1,
                },
                {
                    r: 0.6255,
                    g: 0.180392,
                    b: 0.211567,
                    a: 1,
                },
                {
                    r: 0.447077,
                    g: 0,
                    b: 0.062349,
                    a: 1,
                },
            ],
        },
        {
            name: "indigo",
            hexRGBString: "#4b0082",
            hexRGBAString: "#4b0082ff",
            hexARGBString: "#ff4b0082",
            webRGBString: "rgb(75,0,130)",
            webRGBAString: "rgba(75,0,130,1)",
            lum: 0.031076,
            temp: 40000,
            rgba: {
                r: 0.294118,
                g: 0,
                b: 0.509804,
                a: 1,
            },
            hsl: {
                h: 274.615421,
                s: 1,
                l: 0.254902,
            },
            hsv: {
                h: 274.615421,
                s: 1,
                v: 0.509804,
            },
            xyz: {
                x: 0.069299,
                y: 0.031075,
                z: 0.213495,
            },
            lab: {
                l: 20.469459,
                a: 51.685587,
                b: -53.312608,
            },
            lch: {
                l: 20.469459,
                c: 74.253849,
                h: 314.112233,
            },
            lchToLabResult: {
                l: 20.469459,
                a: 51.685587,
                b: -53.312608,
            },
            labToLCHResult: {
                l: 20.469459,
                c: 74.253849,
                h: 314.112233,
            },
            labToXYZResult: {
                x: 0.069299,
                y: 0.031075,
                z: 0.213495,
            },
            xyzToLABResult: {
                l: 20.469379,
                a: 51.685682,
                b: -53.312774,
            },
            rgbToXYZResult: {
                x: 0.069299,
                y: 0.031075,
                z: 0.213495,
            },
            xyzToRGBResult: {
                r: 0.294117,
                g: -0.000002,
                b: 0.509804,
                a: 1,
            },
            rgbToLABResult: {
                l: 20.469459,
                a: 51.685587,
                b: -53.312608,
            },
            labToRGBResult: {
                r: 0.294118,
                g: 0,
                b: 0.509804,
                a: 1,
            },
            rgbToLCHResult: {
                l: 20.469459,
                c: 74.253849,
                h: 314.112233,
            },
            lchToRGBResult: {
                r: 0.294118,
                g: 0,
                b: 0.509804,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.294118,
                    g: 0,
                    b: 0.509804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.297831,
                    g: -0.051476,
                    b: 0.544314,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.300269,
                    g: -0.104844,
                    b: 0.579159,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.301374,
                    g: -0.160119,
                    b: 0.614333,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.301071,
                    g: -0.217313,
                    b: 0.649833,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.299262,
                    g: -0.276441,
                    b: 0.685653,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.295819,
                    g: -0.337517,
                    b: 0.721787,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.290575,
                    g: -0.400556,
                    b: 0.758231,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.294118,
                    g: 0,
                    b: 0.509804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.289169,
                    g: 0.048913,
                    b: 0.47563,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.283008,
                    g: 0.082615,
                    b: 0.441794,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.275643,
                    g: 0.106642,
                    b: 0.408295,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.267067,
                    g: 0.125751,
                    b: 0.375126,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.257253,
                    g: 0.141733,
                    b: 0.342275,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.246151,
                    g: 0.15549,
                    b: 0.309724,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.233682,
                    g: 0.167552,
                    b: 0.277435,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.294118,
                    g: 0,
                    b: 0.509804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.209563,
                    g: -0.067056,
                    b: 0.431362,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.121813,
                    g: -0.087027,
                    b: 0.355113,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.073941,
                    g: -0.163038,
                    b: 0.282874,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.07177,
                    g: -0.281597,
                    b: 0.216266,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.021239,
                    g: -0.396241,
                    b: 0.157545,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.081084,
                    g: -0.507248,
                    b: 0.109301,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.191422,
                    g: -0.617586,
                    b: 0.038595,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.294118,
                    g: 0,
                    b: 0.509804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.377297,
                    g: 0.108097,
                    b: 0.590147,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.460607,
                    g: 0.191613,
                    b: 0.672265,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.544648,
                    g: 0.270431,
                    b: 0.75605,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.629692,
                    g: 0.34879,
                    b: 0.841412,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.715862,
                    g: 0.427912,
                    b: 0.928271,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.803212,
                    g: 0.508244,
                    b: 1.016557,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.891757,
                    g: 0.589955,
                    b: 1.106207,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.752329,
                    g: 0.620077,
                    b: 0.851765,
                    a: 1,
                },
                {
                    r: 0.523224,
                    g: 0.310038,
                    b: 0.680785,
                    a: 1,
                },
                {
                    r: 0.294118,
                    g: 0,
                    b: 0.509804,
                    a: 1,
                },
                {
                    r: 0.186572,
                    g: 0,
                    b: 0.383299,
                    a: 1,
                },
                {
                    r: 0.079025,
                    g: 0,
                    b: 0.256793,
                    a: 1,
                },
            ],
        },
        {
            name: "ivory",
            hexRGBString: "#fffff0",
            hexRGBAString: "#fffff0ff",
            hexARGBString: "#fffffff0",
            webRGBString: "rgb(255,255,240)",
            webRGBAString: "rgba(255,255,240,1)",
            lum: 0.990713,
            temp: 6027,
            rgba: {
                r: 1,
                g: 1,
                b: 0.941176,
                a: 1,
            },
            hsl: {
                h: 60,
                s: 1,
                l: 0.970588,
            },
            hsv: {
                h: 60,
                s: 0.058824,
                v: 1,
            },
            xyz: {
                x: 0.92726,
                y: 0.990716,
                z: 0.966589,
            },
            lab: {
                l: 99.6399,
                a: -2.551413,
                b: 7.162693,
            },
            lch: {
                l: 99.6399,
                c: 7.603544,
                h: 109.60634,
            },
            lchToLabResult: {
                l: 99.6399,
                a: -2.551413,
                b: 7.162693,
            },
            labToLCHResult: {
                l: 99.6399,
                c: 7.603544,
                h: 109.606337,
            },
            labToXYZResult: {
                x: 0.92726,
                y: 0.990716,
                z: 0.966589,
            },
            xyzToLABResult: {
                l: 99.639902,
                a: -2.551355,
                b: 7.162676,
            },
            rgbToXYZResult: {
                x: 0.92726,
                y: 0.990716,
                z: 0.966589,
            },
            xyzToRGBResult: {
                r: 1,
                g: 1,
                b: 0.941176,
                a: 1,
            },
            rgbToLABResult: {
                l: 99.6399,
                a: -2.551413,
                b: 7.162693,
            },
            labToRGBResult: {
                r: 1,
                g: 1,
                b: 0.941176,
                a: 1,
            },
            rgbToLCHResult: {
                l: 99.6399,
                c: 7.603544,
                h: 109.60634,
            },
            lchToRGBResult: {
                r: 1,
                g: 1,
                b: 0.941176,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.002547,
                    g: 1.004215,
                    b: 0.88548,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.003562,
                    g: 1.008487,
                    b: 0.829502,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.003117,
                    g: 1.01281,
                    b: 0.773089,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.001277,
                    g: 1.017178,
                    b: 0.716035,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.9981,
                    g: 1.021585,
                    b: 0.658053,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.993638,
                    g: 1.026024,
                    b: 0.598732,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.987934,
                    g: 1.03049,
                    b: 0.537456,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.995908,
                    g: 0.995908,
                    b: 0.995908,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.995908,
                    g: 0.995908,
                    b: 0.995908,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.995908,
                    g: 0.995908,
                    b: 0.995908,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.995908,
                    g: 0.995908,
                    b: 0.995908,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.995908,
                    g: 0.995908,
                    b: 0.995908,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.995908,
                    g: 0.995908,
                    b: 0.995908,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.995908,
                    g: 0.995908,
                    b: 0.995908,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.912985,
                    g: 0.913044,
                    b: 0.855219,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.8275,
                    g: 0.827623,
                    b: 0.770853,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.743632,
                    g: 0.743828,
                    b: 0.688174,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.661478,
                    g: 0.661756,
                    b: 0.60729,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.581153,
                    g: 0.581525,
                    b: 0.528329,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.50279,
                    g: 0.503272,
                    b: 0.451443,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.426546,
                    g: 0.427158,
                    b: 0.376813,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.088468,
                    g: 1.088416,
                    b: 1.02864,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.178322,
                    g: 1.178221,
                    b: 1.117538,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.2695,
                    g: 1.269355,
                    b: 1.207803,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.361948,
                    g: 1.361761,
                    b: 1.299375,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.455615,
                    g: 1.45539,
                    b: 1.392202,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.550455,
                    g: 1.550195,
                    b: 1.486235,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.646426,
                    g: 1.646134,
                    b: 1.581428,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 1,
                    b: 0.932931,
                    a: 1,
                },
                {
                    r: 1,
                    g: 1,
                    b: 0.937054,
                    a: 1,
                },
                {
                    r: 1,
                    g: 1,
                    b: 0.941176,
                    a: 1,
                },
                {
                    r: 0.74373,
                    g: 0.748879,
                    b: 0.645245,
                    a: 1,
                },
                {
                    r: 0.487459,
                    g: 0.497758,
                    b: 0.349314,
                    a: 1,
                },
            ],
        },
        {
            name: "khaki",
            hexRGBString: "#f0e68c",
            hexRGBAString: "#f0e68cff",
            hexARGBString: "#fff0e68c",
            webRGBString: "rgb(240,230,140)",
            webRGBAString: "rgba(240,230,140,1)",
            lum: 0.770124,
            temp: 3698,
            rgba: {
                r: 0.941176,
                g: 0.901961,
                b: 0.54902,
                a: 1,
            },
            hsl: {
                h: 54.000092,
                s: 0.769229,
                l: 0.745098,
            },
            hsv: {
                h: 54.000092,
                s: 0.416666,
                v: 0.941176,
            },
            xyz: {
                x: 0.68967,
                y: 0.770143,
                z: 0.360382,
            },
            lab: {
                l: 90.328183,
                a: -9.009896,
                b: 44.979228,
            },
            lch: {
                l: 90.328183,
                c: 45.872749,
                h: 101.327141,
            },
            lchToLabResult: {
                l: 90.328183,
                a: -9.009896,
                b: 44.979227,
            },
            labToLCHResult: {
                l: 90.328183,
                c: 45.87275,
                h: 101.327141,
            },
            labToXYZResult: {
                x: 0.68967,
                y: 0.770143,
                z: 0.360382,
            },
            xyzToLABResult: {
                l: 90.328196,
                a: -9.009922,
                b: 44.979201,
            },
            rgbToXYZResult: {
                x: 0.68967,
                y: 0.770143,
                z: 0.360382,
            },
            xyzToRGBResult: {
                r: 0.941176,
                g: 0.901961,
                b: 0.54902,
                a: 1,
            },
            rgbToLABResult: {
                l: 90.328183,
                a: -9.009896,
                b: 44.979228,
            },
            labToRGBResult: {
                r: 0.941176,
                g: 0.901961,
                b: 0.54902,
                a: 1,
            },
            rgbToLCHResult: {
                l: 90.328183,
                c: 45.872749,
                h: 101.327141,
            },
            lchToRGBResult: {
                r: 0.941176,
                g: 0.901961,
                b: 0.54902,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.901961,
                    b: 0.54902,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.943722,
                    g: 0.904182,
                    b: 0.487579,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.944888,
                    g: 0.906501,
                    b: 0.423131,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.944765,
                    g: 0.908908,
                    b: 0.353678,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.943436,
                    g: 0.911397,
                    b: 0.274914,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.940977,
                    g: 0.913958,
                    b: 0.173757,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.937461,
                    g: 0.916583,
                    b: -0.070292,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.932957,
                    g: 0.919266,
                    b: -0.410798,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.901961,
                    b: 0.54902,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.937152,
                    g: 0.899845,
                    b: 0.608547,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.93154,
                    g: 0.897843,
                    b: 0.666823,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.924215,
                    g: 0.895963,
                    b: 0.724278,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.915036,
                    g: 0.894214,
                    b: 0.781204,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.903841,
                    g: 0.892604,
                    b: 0.837806,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.891216,
                    g: 0.891216,
                    b: 0.891216,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.891216,
                    g: 0.891216,
                    b: 0.891216,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.901961,
                    b: 0.54902,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.852907,
                    g: 0.816905,
                    b: 0.469,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.766001,
                    g: 0.733502,
                    b: 0.390541,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.680511,
                    g: 0.651856,
                    b: 0.313511,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.596493,
                    g: 0.572088,
                    b: 0.2375,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.514005,
                    g: 0.494343,
                    b: 0.161256,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.433108,
                    g: 0.41879,
                    b: 0.079817,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.353864,
                    g: 0.345637,
                    b: -0.014321,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.901961,
                    b: 0.54902,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.030757,
                    g: 0.988577,
                    b: 0.630624,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.121605,
                    g: 1.076674,
                    b: 0.713791,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.213674,
                    g: 1.166179,
                    b: 0.798475,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.306923,
                    g: 1.25703,
                    b: 0.884628,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.401315,
                    g: 1.349167,
                    b: 0.972196,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.496813,
                    g: 1.44254,
                    b: 1.061127,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.593384,
                    g: 1.537102,
                    b: 1.151371,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.983373,
                    g: 0.965902,
                    b: 0.786482,
                    a: 1,
                },
                {
                    r: 0.962274,
                    g: 0.933932,
                    b: 0.667751,
                    a: 1,
                },
                {
                    r: 0.941176,
                    g: 0.901961,
                    b: 0.54902,
                    a: 1,
                },
                {
                    r: 0.697686,
                    g: 0.669184,
                    b: 0.284233,
                    a: 1,
                },
                {
                    r: 0.454195,
                    g: 0.436408,
                    b: 0.019446,
                    a: 1,
                },
            ],
        },
        {
            name: "lavender",
            hexRGBString: "#e6e6fa",
            hexRGBAString: "#e6e6faff",
            hexARGBString: "#ffe6e6fa",
            webRGBString: "rgb(230,230,250)",
            webRGBAString: "rgba(230,230,250,1)",
            lum: 0.803188,
            temp: 7452,
            rgba: {
                r: 0.901961,
                g: 0.901961,
                b: 0.980392,
                a: 1,
            },
            hsl: {
                h: 240,
                s: 0.666664,
                l: 0.941177,
            },
            hsv: {
                h: 240,
                s: 0.08,
                v: 0.980392,
            },
            xyz: {
                x: 0.781819,
                y: 0.803184,
                z: 1.01808,
            },
            lab: {
                l: 91.827527,
                a: 3.70782,
                b: -9.661263,
            },
            lch: {
                l: 91.827527,
                c: 10.34833,
                h: 290.995912,
            },
            lchToLabResult: {
                l: 91.827527,
                a: 3.70782,
                b: -9.661263,
            },
            labToLCHResult: {
                l: 91.827527,
                c: 10.34833,
                h: 290.995909,
            },
            labToXYZResult: {
                x: 0.781819,
                y: 0.803184,
                z: 1.01808,
            },
            xyzToLABResult: {
                l: 91.827534,
                a: 3.707821,
                b: -9.661226,
            },
            rgbToXYZResult: {
                x: 0.781819,
                y: 0.803184,
                z: 1.01808,
            },
            xyzToRGBResult: {
                r: 0.901961,
                g: 0.901961,
                b: 0.980392,
                a: 1,
            },
            rgbToLABResult: {
                l: 91.827527,
                a: 3.70782,
                b: -9.661263,
            },
            labToRGBResult: {
                r: 0.901961,
                g: 0.901961,
                b: 0.980392,
                a: 1,
            },
            rgbToLCHResult: {
                l: 91.827527,
                c: 10.34833,
                h: 290.995912,
            },
            lchToRGBResult: {
                r: 0.901961,
                g: 0.901961,
                b: 0.980392,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.901961,
                    g: 0.901961,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.89535,
                    g: 0.897591,
                    b: 1.034418,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.886745,
                    g: 0.893295,
                    b: 1.088509,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.875989,
                    g: 0.889078,
                    b: 1.142707,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.862899,
                    g: 0.884949,
                    b: 1.197045,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.847249,
                    g: 0.880915,
                    b: 1.251551,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.828766,
                    g: 0.876985,
                    b: 1.306244,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.807111,
                    g: 0.873167,
                    b: 1.361142,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.901961,
                    g: 0.901961,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.906709,
                    g: 0.906396,
                    b: 0.926377,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.907924,
                    g: 0.907924,
                    b: 0.907924,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.907924,
                    g: 0.907924,
                    b: 0.907924,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.907924,
                    g: 0.907924,
                    b: 0.907924,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.907924,
                    g: 0.907924,
                    b: 0.907924,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.907924,
                    g: 0.907924,
                    b: 0.907924,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.907924,
                    g: 0.907924,
                    b: 0.907924,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.901961,
                    g: 0.901961,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.816619,
                    g: 0.816746,
                    b: 0.89373,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.732896,
                    g: 0.733168,
                    b: 0.808618,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.650892,
                    g: 0.651329,
                    b: 0.725146,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.570719,
                    g: 0.571347,
                    b: 0.643416,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.492509,
                    g: 0.493362,
                    b: 0.563546,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.416415,
                    g: 0.417541,
                    b: 0.485676,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.342624,
                    g: 0.344088,
                    b: 0.409972,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.901961,
                    g: 0.901961,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.988837,
                    g: 0.988723,
                    b: 1.068526,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.077171,
                    g: 1.076953,
                    b: 1.158061,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.166893,
                    g: 1.166583,
                    b: 1.248934,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.257944,
                    g: 1.257548,
                    b: 1.34109,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.350268,
                    g: 1.349793,
                    b: 1.434477,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.443814,
                    g: 1.443266,
                    b: 1.529048,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.538537,
                    g: 1.537921,
                    b: 1.62476,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.959238,
                    g: 0.960206,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.930599,
                    g: 0.931083,
                    b: 0.990196,
                    a: 1,
                },
                {
                    r: 0.901961,
                    g: 0.901961,
                    b: 0.980392,
                    a: 1,
                },
                {
                    r: 0.654614,
                    g: 0.662877,
                    b: 0.77856,
                    a: 1,
                },
                {
                    r: 0.407267,
                    g: 0.423793,
                    b: 0.576727,
                    a: 1,
                },
            ],
        },
        {
            name: "lavenderblush",
            hexRGBString: "#fff0f5",
            hexRGBAString: "#fff0f5ff",
            hexARGBString: "#fffff0f5",
            webRGBString: "rgb(255,240,245)",
            webRGBAString: "rgba(255,240,245,1)",
            lum: 0.901727,
            temp: 6189,
            rgba: {
                r: 1,
                g: 0.941176,
                b: 0.960784,
                a: 1,
            },
            hsl: {
                h: 340,
                s: 1,
                l: 0.970588,
            },
            hsv: {
                h: 340,
                s: 0.058824,
                v: 1,
            },
            xyz: {
                x: 0.888793,
                y: 0.901735,
                z: 0.990915,
            },
            lab: {
                l: 96.068697,
                a: 5.887383,
                b: -0.593695,
            },
            lch: {
                l: 96.068697,
                c: 5.917242,
                h: 354.241646,
            },
            lchToLabResult: {
                l: 96.068697,
                a: 5.887383,
                b: -0.593695,
            },
            labToLCHResult: {
                l: 96.068697,
                c: 5.917242,
                h: 354.24165,
            },
            labToXYZResult: {
                x: 0.888793,
                y: 0.901735,
                z: 0.990915,
            },
            xyzToLABResult: {
                l: 96.068691,
                a: 5.88737,
                b: -0.593738,
            },
            rgbToXYZResult: {
                x: 0.888793,
                y: 0.901735,
                z: 0.990915,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.941176,
                b: 0.960784,
                a: 1,
            },
            rgbToLABResult: {
                l: 96.068697,
                a: 5.887383,
                b: -0.593695,
            },
            labToRGBResult: {
                r: 1,
                g: 0.941176,
                b: 0.960784,
                a: 1,
            },
            rgbToLCHResult: {
                l: 96.068697,
                c: 5.917242,
                h: 354.241646,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.941176,
                b: 0.960784,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.941176,
                    b: 0.960784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.055866,
                    g: 0.921511,
                    b: 0.967689,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.109691,
                    g: 0.900623,
                    b: 0.974608,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.161806,
                    g: 0.878394,
                    b: 0.981543,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.21247,
                    g: 0.854678,
                    b: 0.988492,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.261892,
                    g: 0.829304,
                    b: 0.995457,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.310237,
                    g: 0.802063,
                    b: 1.002438,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.357645,
                    g: 0.772695,
                    b: 1.009433,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.941176,
                    b: 0.960784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.955498,
                    g: 0.955498,
                    b: 0.955498,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.955498,
                    g: 0.955498,
                    b: 0.955498,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.955498,
                    g: 0.955498,
                    b: 0.955498,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.955498,
                    g: 0.955498,
                    b: 0.955498,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.955498,
                    g: 0.955498,
                    b: 0.955498,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.955498,
                    g: 0.955498,
                    b: 0.955498,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.955498,
                    g: 0.955498,
                    b: 0.955498,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.941176,
                    b: 0.960784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.912972,
                    g: 0.85522,
                    b: 0.874505,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.827473,
                    g: 0.770854,
                    b: 0.7898,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.743588,
                    g: 0.688175,
                    b: 0.706762,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.661416,
                    g: 0.607292,
                    b: 0.625498,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.581071,
                    g: 0.528333,
                    b: 0.546133,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.502683,
                    g: 0.451448,
                    b: 0.468814,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.426411,
                    g: 0.37682,
                    b: 0.393718,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.941176,
                    b: 0.960784,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.08848,
                    g: 1.02864,
                    b: 1.048555,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.178345,
                    g: 1.117537,
                    b: 1.137747,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.269533,
                    g: 1.207802,
                    b: 1.228293,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.361989,
                    g: 1.299374,
                    b: 1.320137,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.455665,
                    g: 1.392201,
                    b: 1.413224,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.550513,
                    g: 1.486233,
                    b: 1.507508,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.646492,
                    g: 1.581426,
                    b: 1.602944,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.962664,
                    b: 0.99144,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.95192,
                    b: 0.976112,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.941176,
                    b: 0.960784,
                    a: 1,
                },
                {
                    r: 0.79075,
                    g: 0.676406,
                    b: 0.720292,
                    a: 1,
                },
                {
                    r: 0.5815,
                    g: 0.411636,
                    b: 0.4798,
                    a: 1,
                },
            ],
        },
        {
            name: "lawngreen",
            hexRGBString: "#7cfc00",
            hexRGBAString: "#7cfc00ff",
            hexARGBString: "#ff7cfc00",
            webRGBString: "rgb(124,252,0)",
            webRGBAString: "rgba(124,252,0,1)",
            lum: 0.739059,
            temp: 1000,
            rgba: {
                r: 0.486275,
                g: 0.988235,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 90.476152,
                s: 1,
                l: 0.494118,
            },
            hsv: {
                h: 90.476152,
                s: 1,
                v: 0.988235,
            },
            xyz: {
                x: 0.431214,
                y: 0.739027,
                z: 0.119924,
            },
            lab: {
                l: 88.876464,
                a: -67.856008,
                b: 84.952467,
            },
            lch: {
                l: 88.876464,
                c: 108.726076,
                h: 128.616204,
            },
            lchToLabResult: {
                l: 88.876464,
                a: -67.856009,
                b: 84.952467,
            },
            labToLCHResult: {
                l: 88.876464,
                c: 108.726075,
                h: 128.616204,
            },
            labToXYZResult: {
                x: 0.431214,
                y: 0.739027,
                z: 0.119924,
            },
            xyzToLABResult: {
                l: 88.876477,
                a: -67.856031,
                b: 84.952408,
            },
            rgbToXYZResult: {
                x: 0.431214,
                y: 0.739027,
                z: 0.119924,
            },
            xyzToRGBResult: {
                r: 0.486275,
                g: 0.988235,
                b: 0.000003,
                a: 1,
            },
            rgbToLABResult: {
                l: 88.876464,
                a: -67.856008,
                b: 84.952467,
            },
            labToRGBResult: {
                r: 0.486275,
                g: 0.988235,
                b: 0,
                a: 1,
            },
            rgbToLCHResult: {
                l: 88.876464,
                c: 108.726076,
                h: 128.616204,
            },
            lchToRGBResult: {
                r: 0.486275,
                g: 0.988235,
                b: 0,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.486275,
                    g: 0.988235,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.436965,
                    g: 0.994742,
                    b: -0.301461,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.379486,
                    g: 1.00107,
                    b: -0.566224,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.308785,
                    g: 1.007224,
                    b: -0.796736,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.210596,
                    g: 1.013205,
                    b: -0.995444,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.057742,
                    g: 1.019018,
                    b: -1.164794,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.583718,
                    g: 1.024665,
                    b: -1.307232,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.105372,
                    g: 1.030148,
                    b: -1.425204,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.486275,
                    g: 0.988235,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.529881,
                    g: 0.981547,
                    b: 0.176916,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.569193,
                    g: 0.974674,
                    b: 0.262309,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.605104,
                    g: 0.967612,
                    b: 0.329914,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.638216,
                    g: 0.960356,
                    b: 0.389343,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.668958,
                    g: 0.952903,
                    b: 0.444096,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.697645,
                    g: 0.945247,
                    b: 0.49588,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.724517,
                    g: 0.937383,
                    b: 0.54566,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.486275,
                    g: 0.988235,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.386385,
                    g: 0.89982,
                    b: -0.266259,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.277852,
                    g: 0.812773,
                    b: -0.41545,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.140321,
                    g: 0.727142,
                    b: -0.470373,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.182276,
                    g: 0.642981,
                    b: -0.453826,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.421416,
                    g: 0.560251,
                    b: -0.418692,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.501702,
                    g: 0.478839,
                    b: -0.415248,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.458128,
                    g: 0.398697,
                    b: -0.440438,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.486275,
                    g: 0.988235,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.582592,
                    g: 1.077967,
                    b: 0.194556,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.677371,
                    g: 1.16897,
                    b: 0.304443,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.771606,
                    g: 1.261199,
                    b: 0.40138,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.865842,
                    g: 1.354613,
                    b: 0.493788,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.9604,
                    g: 1.449172,
                    b: 0.58447,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.055475,
                    g: 1.544841,
                    b: 0.674664,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.151191,
                    g: 1.641584,
                    b: 0.765002,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.790062,
                    g: 1,
                    b: 0.589403,
                    a: 1,
                },
                {
                    r: 0.638169,
                    g: 0.994118,
                    b: 0.294701,
                    a: 1,
                },
                {
                    r: 0.486275,
                    g: 0.988235,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.245606,
                    g: 0.740932,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.004936,
                    g: 0.493629,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "lemonchiffon",
            hexRGBString: "#fffacd",
            hexRGBAString: "#fffacdff",
            hexARGBString: "#fffffacd",
            webRGBString: "rgb(255,250,205)",
            webRGBAString: "rgba(255,250,205,1)",
            lum: 0.94039,
            temp: 4999,
            rgba: {
                r: 1,
                g: 0.980392,
                b: 0.803922,
                a: 1,
            },
            hsl: {
                h: 53.999939,
                s: 1,
                l: 0.901961,
            },
            hsv: {
                h: 53.999939,
                s: 0.196078,
                v: 1,
            },
            xyz: {
                x: 0.864446,
                y: 0.940402,
                z: 0.713435,
            },
            lab: {
                l: 97.648172,
                a: -5.426733,
                b: 22.233778,
            },
            lch: {
                l: 97.648172,
                c: 22.886466,
                h: 103.71635,
            },
            lchToLabResult: {
                l: 97.648172,
                a: -5.426733,
                b: 22.233778,
            },
            labToLCHResult: {
                l: 97.648172,
                c: 22.886466,
                h: 103.71635,
            },
            labToXYZResult: {
                x: 0.864446,
                y: 0.940402,
                z: 0.713435,
            },
            xyzToLABResult: {
                l: 97.648185,
                a: -5.426777,
                b: 22.233832,
            },
            rgbToXYZResult: {
                x: 0.864446,
                y: 0.940402,
                z: 0.713435,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.980392,
                b: 0.803922,
                a: 1,
            },
            rgbToLABResult: {
                l: 97.648172,
                a: -5.426733,
                b: 22.233778,
            },
            labToRGBResult: {
                r: 1,
                g: 0.980392,
                b: 0.803922,
                a: 1,
            },
            rgbToLCHResult: {
                l: 97.648172,
                c: 22.886466,
                h: 103.71635,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.980392,
                b: 0.803922,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.980392,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.005459,
                    g: 0.982997,
                    b: 0.746111,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.009335,
                    g: 0.985702,
                    b: 0.687601,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.011724,
                    g: 0.988501,
                    b: 0.628059,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.012714,
                    g: 0.991386,
                    b: 0.566995,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.012386,
                    g: 0.99435,
                    b: 0.50365,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.01081,
                    g: 0.997385,
                    b: 0.436764,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.008053,
                    g: 1.000486,
                    b: 0.364009,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.980392,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.992846,
                    g: 0.977896,
                    b: 0.861271,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.983873,
                    g: 0.975515,
                    b: 0.918328,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.973331,
                    g: 0.973331,
                    b: 0.973331,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.973331,
                    g: 0.973331,
                    b: 0.973331,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.973331,
                    g: 0.973331,
                    b: 0.973331,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.973331,
                    g: 0.973331,
                    b: 0.973331,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.973331,
                    g: 0.973331,
                    b: 0.973331,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.980392,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.912466,
                    g: 0.893806,
                    b: 0.720276,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.826408,
                    g: 0.808779,
                    b: 0.638337,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.741901,
                    g: 0.725402,
                    b: 0.558212,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.659032,
                    g: 0.643779,
                    b: 0.480022,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.577895,
                    g: 0.564031,
                    b: 0.403909,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.4986,
                    g: 0.486302,
                    b: 0.33003,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.421269,
                    g: 0.410764,
                    b: 0.258559,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.980392,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.088942,
                    g: 1.068456,
                    b: 0.88918,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.179231,
                    g: 1.157928,
                    b: 0.975967,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.27081,
                    g: 1.248743,
                    b: 1.064209,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.363629,
                    g: 1.340845,
                    b: 1.153837,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.457642,
                    g: 1.434182,
                    b: 1.244793,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.552806,
                    g: 1.528706,
                    b: 1.337021,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.649081,
                    g: 1.624375,
                    b: 1.430471,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.995037,
                    b: 0.880956,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.987714,
                    b: 0.842439,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.980392,
                    b: 0.803922,
                    a: 1,
                },
                {
                    r: 0.746416,
                    g: 0.732085,
                    b: 0.525184,
                    a: 1,
                },
                {
                    r: 0.492832,
                    g: 0.483778,
                    b: 0.246446,
                    a: 1,
                },
            ],
        },
        {
            name: "lightblue",
            hexRGBString: "#add8e6",
            hexRGBAString: "#add8e6ff",
            hexARGBString: "#ffadd8e6",
            webRGBString: "rgb(173,216,230)",
            webRGBAString: "rgba(173,216,230,1)",
            lum: 0.637092,
            temp: 11914,
            rgba: {
                r: 0.678431,
                g: 0.847059,
                b: 0.901961,
                a: 1,
            },
            hsl: {
                h: 194.736814,
                s: 0.532711,
                l: 0.790196,
            },
            hsv: {
                h: 194.736814,
                s: 0.247827,
                v: 0.901961,
            },
            xyz: {
                x: 0.560681,
                y: 0.637069,
                z: 0.841901,
            },
            lab: {
                l: 83.812954,
                a: -10.891823,
                b: -11.47669,
            },
            lch: {
                l: 83.812954,
                c: 15.822333,
                h: 226.497765,
            },
            lchToLabResult: {
                l: 83.812954,
                a: -10.891823,
                b: -11.47669,
            },
            labToLCHResult: {
                l: 83.812954,
                c: 15.822333,
                h: 226.497765,
            },
            labToXYZResult: {
                x: 0.560681,
                y: 0.637069,
                z: 0.841901,
            },
            xyzToLABResult: {
                l: 83.812932,
                a: -10.891836,
                b: -11.476739,
            },
            rgbToXYZResult: {
                x: 0.560681,
                y: 0.637069,
                z: 0.841901,
            },
            xyzToRGBResult: {
                r: 0.67843,
                g: 0.847059,
                b: 0.901961,
                a: 1,
            },
            rgbToLABResult: {
                l: 83.812954,
                a: -10.891823,
                b: -11.47669,
            },
            labToRGBResult: {
                r: 0.678431,
                g: 0.847059,
                b: 0.901961,
                a: 1,
            },
            rgbToLCHResult: {
                l: 83.812954,
                c: 15.822333,
                h: 226.497765,
            },
            lchToRGBResult: {
                r: 0.678431,
                g: 0.847059,
                b: 0.901961,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.678431,
                    g: 0.847059,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.592765,
                    g: 0.859894,
                    b: 0.942443,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.486507,
                    g: 0.872316,
                    b: 0.983063,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.336417,
                    g: 0.884353,
                    b: 1.02383,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.225723,
                    g: 0.89603,
                    b: 1.064751,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.660088,
                    g: 0.907371,
                    b: 1.105834,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -3.108135,
                    g: 0.918398,
                    b: 1.147083,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -4.571071,
                    g: 0.92913,
                    b: 1.188501,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.678431,
                    g: 0.847059,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.751596,
                    g: 0.83378,
                    b: 0.861604,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.816193,
                    g: 0.820022,
                    b: 0.821358,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.819306,
                    g: 0.819306,
                    b: 0.819306,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.819306,
                    g: 0.819306,
                    b: 0.819306,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.819306,
                    g: 0.819306,
                    b: 0.819306,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.819306,
                    g: 0.819306,
                    b: 0.819306,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.819306,
                    g: 0.819306,
                    b: 0.819306,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.678431,
                    g: 0.847059,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.595903,
                    g: 0.762792,
                    b: 0.816702,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.514958,
                    g: 0.680215,
                    b: 0.733074,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.435609,
                    g: 0.599436,
                    b: 0.651178,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.357813,
                    g: 0.520582,
                    b: 0.571131,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.281376,
                    g: 0.443806,
                    b: 0.49307,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.205715,
                    g: 0.369287,
                    b: 0.417159,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.128917,
                    g: 0.297248,
                    b: 0.343595,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.678431,
                    g: 0.847059,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.762502,
                    g: 0.932919,
                    b: 0.988763,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.848065,
                    g: 1.02029,
                    b: 1.07703,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.935066,
                    g: 1.109096,
                    b: 1.166692,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.023453,
                    g: 1.199272,
                    b: 1.257688,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.113173,
                    g: 1.290759,
                    b: 1.349961,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.204177,
                    g: 1.383502,
                    b: 1.44346,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.29642,
                    g: 1.477452,
                    b: 1.538139,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.823071,
                    g: 0.95488,
                    b: 0.996758,
                    a: 1,
                },
                {
                    r: 0.750751,
                    g: 0.900969,
                    b: 0.94936,
                    a: 1,
                },
                {
                    r: 0.678431,
                    g: 0.847059,
                    b: 0.901961,
                    a: 1,
                },
                {
                    r: 0.339216,
                    g: 0.634014,
                    b: 0.705495,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.420968,
                    b: 0.509029,
                    a: 1,
                },
            ],
        },
        {
            name: "lightcoral",
            hexRGBString: "#f08080",
            hexRGBAString: "#f08080ff",
            hexARGBString: "#fff08080",
            webRGBString: "rgb(240,128,128)",
            webRGBAString: "rgba(240,128,128,1)",
            lum: 0.355221,
            temp: 3459,
            rgba: {
                r: 0.941176,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0.788731,
                l: 0.721569,
            },
            hsv: {
                h: 0,
                s: 0.466666,
                v: 0.941176,
            },
            xyz: {
                x: 0.475537,
                y: 0.355269,
                z: 0.247709,
            },
            lab: {
                l: 66.156844,
                a: 42.809852,
                b: 19.556773,
            },
            lch: {
                l: 66.156844,
                c: 47.065388,
                h: 24.552285,
            },
            lchToLabResult: {
                l: 66.156844,
                a: 42.809852,
                b: 19.556772,
            },
            labToLCHResult: {
                l: 66.156844,
                c: 47.065389,
                h: 24.552285,
            },
            labToXYZResult: {
                x: 0.475537,
                y: 0.355269,
                z: 0.247709,
            },
            xyzToLABResult: {
                l: 66.156846,
                a: 42.80997,
                b: 19.556791,
            },
            rgbToXYZResult: {
                x: 0.475537,
                y: 0.355269,
                z: 0.247709,
            },
            xyzToRGBResult: {
                r: 0.941177,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            rgbToLABResult: {
                l: 66.156844,
                a: 42.809852,
                b: 19.556773,
            },
            labToRGBResult: {
                r: 0.941176,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            rgbToLCHResult: {
                l: 66.156844,
                c: 47.065388,
                h: 24.552285,
            },
            lchToRGBResult: {
                r: 0.941176,
                g: 0.501961,
                b: 0.501961,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.984011,
                    g: 0.473344,
                    b: 0.481368,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.025546,
                    g: 0.441316,
                    b: 0.460928,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.065971,
                    g: 0.404897,
                    b: 0.440654,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.105442,
                    g: 0.362514,
                    b: 0.420557,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.144086,
                    g: 0.311333,
                    b: 0.400655,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.182012,
                    g: 0.245145,
                    b: 0.380965,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.219309,
                    g: 0.142881,
                    b: 0.36151,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.896801,
                    g: 0.527827,
                    b: 0.522698,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.850584,
                    g: 0.55141,
                    b: 0.543572,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.802127,
                    g: 0.573058,
                    b: 0.564574,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.750896,
                    g: 0.593038,
                    b: 0.5857,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.696146,
                    g: 0.611558,
                    b: 0.606943,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.63678,
                    g: 0.628789,
                    b: 0.628299,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.630464,
                    g: 0.630464,
                    b: 0.630464,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.849745,
                    g: 0.421696,
                    b: 0.42585,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.759394,
                    g: 0.342592,
                    b: 0.35208,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.670126,
                    g: 0.264144,
                    b: 0.280899,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.581934,
                    g: 0.184954,
                    b: 0.212634,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.494795,
                    g: 0.099974,
                    b: 0.147733,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.408662,
                    g: -0.010481,
                    b: 0.086878,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.325601,
                    g: -0.074201,
                    b: -0.000108,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.941176,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.033676,
                    g: 0.583583,
                    b: 0.580212,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.127231,
                    g: 0.666629,
                    b: 0.660441,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.221823,
                    g: 0.751107,
                    b: 0.74251,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.317432,
                    g: 0.836996,
                    b: 0.826303,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.414038,
                    g: 0.924264,
                    b: 0.911721,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.511621,
                    g: 1.012871,
                    b: 0.998674,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.61016,
                    g: 1.102774,
                    b: 1.087086,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.798914,
                    b: 0.80039,
                    a: 1,
                },
                {
                    r: 0.970588,
                    g: 0.650438,
                    b: 0.651176,
                    a: 1,
                },
                {
                    r: 0.941176,
                    g: 0.501961,
                    b: 0.501961,
                    a: 1,
                },
                {
                    r: 0.736579,
                    g: 0.285043,
                    b: 0.308384,
                    a: 1,
                },
                {
                    r: 0.531981,
                    g: 0.068125,
                    b: 0.114806,
                    a: 1,
                },
            ],
        },
        {
            name: "lightcyan",
            hexRGBString: "#e0ffff",
            hexRGBAString: "#e0ffffff",
            hexARGBString: "#ffe0ffff",
            webRGBString: "rgb(224,255,255)",
            webRGBAString: "rgba(224,255,255,1)",
            lum: 0.945873,
            temp: 8086,
            rgba: {
                r: 0.878431,
                g: 1,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 180,
                s: 1,
                l: 0.939216,
            },
            hsv: {
                h: 180,
                s: 0.121569,
                v: 1,
            },
            xyz: {
                x: 0.84546,
                y: 0.945854,
                z: 1.083908,
            },
            lab: {
                l: 97.867401,
                a: -9.94454,
                b: -3.375056,
            },
            lch: {
                l: 97.867401,
                c: 10.50166,
                h: 198.746587,
            },
            lchToLabResult: {
                l: 97.867401,
                a: -9.944539,
                b: -3.375056,
            },
            labToLCHResult: {
                l: 97.867401,
                c: 10.501661,
                h: 198.746588,
            },
            labToXYZResult: {
                x: 0.84546,
                y: 0.945854,
                z: 1.083908,
            },
            xyzToLABResult: {
                l: 97.867388,
                a: -9.944492,
                b: -3.375099,
            },
            rgbToXYZResult: {
                x: 0.84546,
                y: 0.945854,
                z: 1.083908,
            },
            xyzToRGBResult: {
                r: 0.878431,
                g: 1,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 97.867401,
                a: -9.94454,
                b: -3.375056,
            },
            labToRGBResult: {
                r: 0.878431,
                g: 1,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 97.867401,
                c: 10.50166,
                h: 198.746587,
            },
            lchToRGBResult: {
                r: 0.878431,
                g: 1,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.878431,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.798953,
                    g: 1.01673,
                    b: 1.017855,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.709707,
                    g: 1.032649,
                    b: 1.035781,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.605483,
                    g: 1.047811,
                    b: 1.053775,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.474431,
                    g: 1.062266,
                    b: 1.071834,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.272429,
                    g: 1.076055,
                    b: 1.089958,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.872293,
                    g: 1.08922,
                    b: 1.108143,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -2.486336,
                    g: 1.101794,
                    b: 1.126388,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.878431,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.950959,
                    g: 0.982399,
                    b: 0.982218,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.975811,
                    g: 0.975811,
                    b: 0.975811,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.975811,
                    g: 0.975811,
                    b: 0.975811,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.975811,
                    g: 0.975811,
                    b: 0.975811,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.975811,
                    g: 0.975811,
                    b: 0.975811,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.975811,
                    g: 0.975811,
                    b: 0.975811,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.975811,
                    g: 0.975811,
                    b: 0.975811,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.878431,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.793178,
                    g: 0.912978,
                    b: 0.913042,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.709522,
                    g: 0.827485,
                    b: 0.827621,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.627552,
                    g: 0.743607,
                    b: 0.743823,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.547367,
                    g: 0.661443,
                    b: 0.66175,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.469076,
                    g: 0.581107,
                    b: 0.581518,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.392798,
                    g: 0.50273,
                    b: 0.503262,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.318655,
                    g: 0.42647,
                    b: 0.427145,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.878431,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.965202,
                    g: 1.088475,
                    b: 1.088417,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.053418,
                    g: 1.178335,
                    b: 1.178223,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.143015,
                    g: 1.269519,
                    b: 1.269358,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.233934,
                    g: 1.361972,
                    b: 1.361765,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.326122,
                    g: 1.455643,
                    b: 1.455395,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.419529,
                    g: 1.550488,
                    b: 1.5502,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.514111,
                    g: 1.646464,
                    b: 1.646139,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.895336,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.886883,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.878431,
                    g: 1,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.474903,
                    g: 0.758119,
                    b: 0.761103,
                    a: 1,
                },
                {
                    r: 0.071374,
                    g: 0.516238,
                    b: 0.522205,
                    a: 1,
                },
            ],
        },
        {
            name: "lightgoldenrodyellow",
            hexRGBString: "#fafad2",
            hexRGBAString: "#fafad2ff",
            hexARGBString: "#fffafad2",
            webRGBString: "rgb(250,250,210)",
            webRGBAString: "rgba(250,250,210,1)",
            lum: 0.933483,
            temp: 5252,
            rgba: {
                r: 0.980392,
                g: 0.980392,
                b: 0.823529,
                a: 1,
            },
            hsl: {
                h: 60,
                s: 0.799999,
                l: 0.901961,
            },
            hsv: {
                h: 60,
                s: 0.16,
                v: 0.980392,
            },
            xyz: {
                x: 0.852418,
                y: 0.933491,
                z: 0.744878,
            },
            lab: {
                l: 97.369101,
                a: -6.481079,
                b: 19.237276,
            },
            lch: {
                l: 97.369101,
                c: 20.299684,
                h: 108.618781,
            },
            lchToLabResult: {
                l: 97.369101,
                a: -6.481079,
                b: 19.237276,
            },
            labToLCHResult: {
                l: 97.369101,
                c: 20.299684,
                h: 108.61878,
            },
            labToXYZResult: {
                x: 0.852418,
                y: 0.933491,
                z: 0.744878,
            },
            xyzToLABResult: {
                l: 97.369101,
                a: -6.481162,
                b: 19.237276,
            },
            rgbToXYZResult: {
                x: 0.852418,
                y: 0.933491,
                z: 0.744878,
            },
            xyzToRGBResult: {
                r: 0.980391,
                g: 0.980392,
                b: 0.823529,
                a: 1,
            },
            rgbToLABResult: {
                l: 97.369101,
                a: -6.481079,
                b: 19.237276,
            },
            labToRGBResult: {
                r: 0.980392,
                g: 0.980392,
                b: 0.823529,
                a: 1,
            },
            rgbToLCHResult: {
                l: 97.369101,
                c: 20.299684,
                h: 108.618781,
            },
            lchToRGBResult: {
                r: 0.980392,
                g: 0.980392,
                b: 0.823529,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.980392,
                    b: 0.823529,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.981389,
                    g: 0.984398,
                    b: 0.767226,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.980924,
                    g: 0.988462,
                    b: 0.710331,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.979063,
                    g: 0.992578,
                    b: 0.652568,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.975867,
                    g: 0.996738,
                    b: 0.593541,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.971392,
                    g: 1.000937,
                    b: 0.532656,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.965684,
                    g: 1.005168,
                    b: 0.468969,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.958789,
                    g: 1.009425,
                    b: 0.400848,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.980392,
                    b: 0.823529,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.977854,
                    g: 0.97645,
                    b: 0.879439,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.973689,
                    g: 0.97258,
                    b: 0.935103,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.970176,
                    g: 0.970176,
                    b: 0.970176,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.970176,
                    g: 0.970176,
                    b: 0.970176,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.970176,
                    g: 0.970176,
                    b: 0.970176,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.970176,
                    g: 0.970176,
                    b: 0.970176,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.970176,
                    g: 0.970176,
                    b: 0.970176,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.980392,
                    b: 0.823529,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.893369,
                    g: 0.893787,
                    b: 0.739578,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.807858,
                    g: 0.808739,
                    b: 0.657322,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.723939,
                    g: 0.725338,
                    b: 0.576869,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.641705,
                    g: 0.643687,
                    b: 0.498342,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.56126,
                    g: 0.563909,
                    b: 0.421885,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.482723,
                    g: 0.486145,
                    b: 0.347664,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.406234,
                    g: 0.410565,
                    b: 0.275872,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.980392,
                    b: 0.823529,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.068853,
                    g: 1.068474,
                    b: 0.909081,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.158688,
                    g: 1.157961,
                    b: 0.996152,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.249838,
                    g: 1.248791,
                    b: 1.084667,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.342249,
                    g: 1.340907,
                    b: 1.174559,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.435873,
                    g: 1.434256,
                    b: 1.26577,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.530665,
                    g: 1.528792,
                    b: 1.358245,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.626585,
                    g: 1.624472,
                    b: 1.451934,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.994941,
                    g: 0.996179,
                    b: 0.889303,
                    a: 1,
                },
                {
                    r: 0.987667,
                    g: 0.988285,
                    b: 0.856416,
                    a: 1,
                },
                {
                    r: 0.980392,
                    g: 0.980392,
                    b: 0.823529,
                    a: 1,
                },
                {
                    r: 0.727073,
                    g: 0.733239,
                    b: 0.544078,
                    a: 1,
                },
                {
                    r: 0.473753,
                    g: 0.486086,
                    b: 0.264626,
                    a: 1,
                },
            ],
        },
        {
            name: "lightgray",
            hexRGBString: "#d3d3d3",
            hexRGBAString: "#d3d3d3ff",
            hexARGBString: "#ffd3d3d3",
            webRGBString: "rgb(211,211,211)",
            webRGBAString: "rgba(211,211,211,1)",
            lum: 0.651406,
            temp: 6650,
            rgba: {
                r: 0.827451,
                g: 0.827451,
                b: 0.827451,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0.827451,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0.827451,
            },
            xyz: {
                x: 0.619142,
                y: 0.651406,
                z: 0.70927,
            },
            lab: {
                l: 84.556122,
                a: -0.000014,
                b: 0.000006,
            },
            lch: {
                l: 84.556122,
                c: 0.000016,
                h: 0,
            },
            lchToLabResult: {
                l: 84.556122,
                a: -0.000015,
                b: 0.000006,
            },
            labToLCHResult: {
                l: 84.556122,
                c: 0.000015,
                h: 0,
            },
            labToXYZResult: {
                x: 0.619142,
                y: 0.651406,
                z: 0.70927,
            },
            xyzToLABResult: {
                l: 84.556135,
                a: 0.000032,
                b: 0.000032,
            },
            rgbToXYZResult: {
                x: 0.619142,
                y: 0.651406,
                z: 0.70927,
            },
            xyzToRGBResult: {
                r: 0.827452,
                g: 0.827451,
                b: 0.827451,
                a: 1,
            },
            rgbToLABResult: {
                l: 84.556122,
                a: -0.000014,
                b: 0.000006,
            },
            labToRGBResult: {
                r: 0.827451,
                g: 0.827451,
                b: 0.827451,
                a: 1,
            },
            rgbToLCHResult: {
                l: 84.556122,
                c: 0.000016,
                h: 0,
            },
            lchToRGBResult: {
                r: 0.827451,
                g: 0.827451,
                b: 0.827451,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.743656,
                    g: 0.743656,
                    b: 0.743656,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.661585,
                    g: 0.661585,
                    b: 0.661585,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.581355,
                    g: 0.581355,
                    b: 0.581355,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.503101,
                    g: 0.503101,
                    b: 0.503101,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.426987,
                    g: 0.426987,
                    b: 0.426987,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.35321,
                    g: 0.35321,
                    b: 0.35321,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.282016,
                    g: 0.282016,
                    b: 0.282016,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.91287,
                    g: 0.91287,
                    b: 0.91287,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.999826,
                    g: 0.999826,
                    b: 0.999826,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.08824,
                    g: 1.088241,
                    b: 1.08824,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.178045,
                    g: 1.178045,
                    b: 1.178045,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.269178,
                    g: 1.269178,
                    b: 1.269178,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.361584,
                    g: 1.361584,
                    b: 1.361584,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.455211,
                    g: 1.455211,
                    b: 1.455211,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.936157,
                    g: 0.936157,
                    b: 0.936157,
                    a: 1,
                },
                {
                    r: 0.881804,
                    g: 0.881804,
                    b: 0.881804,
                    a: 1,
                },
                {
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    r: 0.606304,
                    g: 0.606304,
                    b: 0.606304,
                    a: 1,
                },
                {
                    r: 0.385158,
                    g: 0.385158,
                    b: 0.385158,
                    a: 1,
                },
            ],
        },
        {
            name: "lightgreen",
            hexRGBString: "#90ee90",
            hexRGBAString: "#90ee90ff",
            hexARGBString: "#ff90ee90",
            webRGBString: "rgb(144,238,144)",
            webRGBAString: "rgba(144,238,144,1)",
            lum: 0.690919,
            temp: 6650,
            rgba: {
                r: 0.564706,
                g: 0.933333,
                b: 0.564706,
                a: 1,
            },
            hsl: {
                h: 120,
                s: 0.734374,
                l: 0.74902,
            },
            hsv: {
                h: 120,
                s: 0.394958,
                v: 0.933333,
            },
            xyz: {
                x: 0.471079,
                y: 0.690892,
                z: 0.372335,
            },
            lab: {
                l: 86.548192,
                a: -46.327905,
                b: 36.949057,
            },
            lch: {
                l: 86.548192,
                c: 59.257975,
                h: 141.42571,
            },
            lchToLabResult: {
                l: 86.548192,
                a: -46.327905,
                b: 36.949057,
            },
            labToLCHResult: {
                l: 86.548192,
                c: 59.257975,
                h: 141.42571,
            },
            labToXYZResult: {
                x: 0.471079,
                y: 0.690892,
                z: 0.372335,
            },
            xyzToLABResult: {
                l: 86.548201,
                a: -46.328069,
                b: 36.949046,
            },
            rgbToXYZResult: {
                x: 0.471079,
                y: 0.690892,
                z: 0.372335,
            },
            xyzToRGBResult: {
                r: 0.564704,
                g: 0.933333,
                b: 0.564706,
                a: 1,
            },
            rgbToLABResult: {
                l: 86.548192,
                a: -46.327905,
                b: 36.949057,
            },
            labToRGBResult: {
                r: 0.564706,
                g: 0.933333,
                b: 0.564706,
                a: 1,
            },
            rgbToLCHResult: {
                l: 86.548192,
                c: 59.257975,
                h: 141.42571,
            },
            lchToRGBResult: {
                r: 0.564706,
                g: 0.933333,
                b: 0.564706,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.564706,
                    g: 0.933333,
                    b: 0.564706,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.515483,
                    g: 0.942435,
                    b: 0.525574,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.460441,
                    g: 0.951178,
                    b: 0.485426,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.396825,
                    g: 0.959576,
                    b: 0.443919,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.318849,
                    g: 0.967645,
                    b: 0.400546,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.20922,
                    g: 0.975397,
                    b: 0.354515,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.128497,
                    g: 0.982845,
                    b: 0.304483,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.711296,
                    g: 0.99,
                    b: 0.24784,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.564706,
                    g: 0.933333,
                    b: 0.564706,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.609666,
                    g: 0.923855,
                    b: 0.603068,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.651342,
                    g: 0.913983,
                    b: 0.640839,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.690393,
                    g: 0.903698,
                    b: 0.678154,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.727287,
                    g: 0.892978,
                    b: 0.715119,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.762369,
                    g: 0.8818,
                    b: 0.751815,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.795904,
                    g: 0.870138,
                    b: 0.788308,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.828098,
                    g: 0.857964,
                    b: 0.82465,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.564706,
                    g: 0.933333,
                    b: 0.564706,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.479626,
                    g: 0.846485,
                    b: 0.484912,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.394751,
                    g: 0.761125,
                    b: 0.406832,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.309031,
                    g: 0.677327,
                    b: 0.330445,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.219805,
                    g: 0.59517,
                    b: 0.255587,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.117333,
                    g: 0.514746,
                    b: 0.18168,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.052174,
                    g: 0.43615,
                    b: 0.106626,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.168531,
                    g: 0.35949,
                    b: 0.020416,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.564706,
                    g: 0.933333,
                    b: 0.564706,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.650474,
                    g: 1.021602,
                    b: 0.646181,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.737169,
                    g: 1.11123,
                    b: 0.72928,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.824913,
                    g: 1.202164,
                    b: 0.81394,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.913763,
                    g: 1.294351,
                    b: 0.900099,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.003741,
                    g: 1.387746,
                    b: 0.987694,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.09485,
                    g: 1.482304,
                    b: 1.076668,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.187078,
                    g: 1.577987,
                    b: 1.166967,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.807927,
                    g: 0.984999,
                    b: 0.809855,
                    a: 1,
                },
                {
                    r: 0.686317,
                    g: 0.959166,
                    b: 0.687281,
                    a: 1,
                },
                {
                    r: 0.564706,
                    g: 0.933333,
                    b: 0.564706,
                    a: 1,
                },
                {
                    r: 0.295684,
                    g: 0.699862,
                    b: 0.337738,
                    a: 1,
                },
                {
                    r: 0.026663,
                    g: 0.46639,
                    b: 0.110769,
                    a: 1,
                },
            ],
        },
        {
            name: "lightgrey",
            hexRGBString: "#d3d3d3",
            hexRGBAString: "#d3d3d3ff",
            hexARGBString: "#ffd3d3d3",
            webRGBString: "rgb(211,211,211)",
            webRGBAString: "rgba(211,211,211,1)",
            lum: 0.651406,
            temp: 6650,
            rgba: {
                r: 0.827451,
                g: 0.827451,
                b: 0.827451,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 0,
                l: 0.827451,
            },
            hsv: {
                h: 0,
                s: 0,
                v: 0.827451,
            },
            xyz: {
                x: 0.619142,
                y: 0.651406,
                z: 0.70927,
            },
            lab: {
                l: 84.556122,
                a: -0.000014,
                b: 0.000006,
            },
            lch: {
                l: 84.556122,
                c: 0.000016,
                h: 0,
            },
            lchToLabResult: {
                l: 84.556122,
                a: -0.000015,
                b: 0.000006,
            },
            labToLCHResult: {
                l: 84.556122,
                c: 0.000015,
                h: 0,
            },
            labToXYZResult: {
                x: 0.619142,
                y: 0.651406,
                z: 0.70927,
            },
            xyzToLABResult: {
                l: 84.556135,
                a: 0.000032,
                b: 0.000032,
            },
            rgbToXYZResult: {
                x: 0.619142,
                y: 0.651406,
                z: 0.70927,
            },
            xyzToRGBResult: {
                r: 0.827452,
                g: 0.827451,
                b: 0.827451,
                a: 1,
            },
            rgbToLABResult: {
                l: 84.556122,
                a: -0.000014,
                b: 0.000006,
            },
            labToRGBResult: {
                r: 0.827451,
                g: 0.827451,
                b: 0.827451,
                a: 1,
            },
            rgbToLCHResult: {
                l: 84.556122,
                c: 0.000016,
                h: 0,
            },
            lchToRGBResult: {
                r: 0.827451,
                g: 0.827451,
                b: 0.827451,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.743656,
                    g: 0.743656,
                    b: 0.743656,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.661585,
                    g: 0.661585,
                    b: 0.661585,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.581355,
                    g: 0.581355,
                    b: 0.581355,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.503101,
                    g: 0.503101,
                    b: 0.503101,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.426987,
                    g: 0.426987,
                    b: 0.426987,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.35321,
                    g: 0.35321,
                    b: 0.35321,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.282016,
                    g: 0.282016,
                    b: 0.282016,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.91287,
                    g: 0.91287,
                    b: 0.91287,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.999826,
                    g: 0.999826,
                    b: 0.999826,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.08824,
                    g: 1.088241,
                    b: 1.08824,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.178045,
                    g: 1.178045,
                    b: 1.178045,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.269178,
                    g: 1.269178,
                    b: 1.269178,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.361584,
                    g: 1.361584,
                    b: 1.361584,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.455211,
                    g: 1.455211,
                    b: 1.455211,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.936157,
                    g: 0.936157,
                    b: 0.936157,
                    a: 1,
                },
                {
                    r: 0.881804,
                    g: 0.881804,
                    b: 0.881804,
                    a: 1,
                },
                {
                    r: 0.827451,
                    g: 0.827451,
                    b: 0.827451,
                    a: 1,
                },
                {
                    r: 0.606304,
                    g: 0.606304,
                    b: 0.606304,
                    a: 1,
                },
                {
                    r: 0.385158,
                    g: 0.385158,
                    b: 0.385158,
                    a: 1,
                },
            ],
        },
        {
            name: "lightpink",
            hexRGBString: "#ffb6c1",
            hexRGBAString: "#ffb6c1ff",
            hexARGBString: "#ffffb6c1",
            webRGBString: "rgb(255,182,193)",
            webRGBAString: "rgba(255,182,193,1)",
            lum: 0.585661,
            temp: 4686,
            rgba: {
                r: 1,
                g: 0.713725,
                b: 0.756863,
                a: 1,
            },
            hsl: {
                h: 350.958763,
                s: 1,
                l: 0.856863,
            },
            hsv: {
                h: 350.958763,
                s: 0.286275,
                v: 1,
            },
            xyz: {
                x: 0.675948,
                y: 0.585698,
                z: 0.581865,
            },
            lab: {
                l: 81.054565,
                a: 27.962716,
                b: 5.035878,
            },
            lch: {
                l: 81.054565,
                c: 28.41256,
                h: 10.209113,
            },
            lchToLabResult: {
                l: 81.054565,
                a: 27.962716,
                b: 5.035878,
            },
            labToLCHResult: {
                l: 81.054565,
                c: 28.41256,
                h: 10.209112,
            },
            labToXYZResult: {
                x: 0.675948,
                y: 0.585698,
                z: 0.581865,
            },
            xyzToLABResult: {
                l: 81.054551,
                a: 27.962868,
                b: 5.035858,
            },
            rgbToXYZResult: {
                x: 0.675948,
                y: 0.585698,
                z: 0.581865,
            },
            xyzToRGBResult: {
                r: 1.000001,
                g: 0.713724,
                b: 0.756863,
                a: 1,
            },
            rgbToLABResult: {
                l: 81.054565,
                a: 27.962716,
                b: 5.035878,
            },
            labToRGBResult: {
                r: 1,
                g: 0.713725,
                b: 0.756863,
                a: 1,
            },
            rgbToLCHResult: {
                l: 81.054565,
                c: 28.41256,
                h: 10.209113,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.713725,
                b: 0.756863,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.713725,
                    b: 0.756863,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.051409,
                    g: 0.689492,
                    b: 0.748258,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.101124,
                    g: 0.663237,
                    b: 0.739736,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.149406,
                    g: 0.634637,
                    b: 0.731299,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.196462,
                    g: 0.603264,
                    b: 0.722952,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.242462,
                    g: 0.568539,
                    b: 0.714698,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.287542,
                    g: 0.529642,
                    b: 0.706542,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.331819,
                    g: 0.485342,
                    b: 0.698487,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.713725,
                    b: 0.756863,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.946561,
                    g: 0.736193,
                    b: 0.765546,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.890653,
                    g: 0.757099,
                    b: 0.774305,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.831678,
                    g: 0.77661,
                    b: 0.783136,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.789209,
                    g: 0.789209,
                    b: 0.789209,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.789209,
                    g: 0.789209,
                    b: 0.789209,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.789209,
                    g: 0.789209,
                    b: 0.789209,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.789209,
                    g: 0.789209,
                    b: 0.789209,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.713725,
                    b: 0.756863,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.911167,
                    g: 0.631357,
                    b: 0.674543,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.823685,
                    g: 0.550711,
                    b: 0.594049,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.737606,
                    g: 0.471877,
                    b: 0.515515,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.652986,
                    g: 0.39494,
                    b: 0.439102,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.56988,
                    g: 0.319966,
                    b: 0.365003,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.488346,
                    g: 0.246953,
                    b: 0.293462,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.408434,
                    g: 0.175688,
                    b: 0.224793,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.713725,
                    b: 0.756863,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.090133,
                    g: 0.797732,
                    b: 0.840894,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.181521,
                    g: 0.883299,
                    b: 0.926538,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.274119,
                    g: 0.970352,
                    b: 1.013708,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.367886,
                    g: 1.058826,
                    b: 1.102328,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.462785,
                    g: 1.14866,
                    b: 1.192329,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.558779,
                    g: 1.239798,
                    b: 1.28365,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.655835,
                    g: 1.332189,
                    b: 1.376238,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.877266,
                    b: 0.904381,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.795496,
                    b: 0.830622,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.713725,
                    b: 0.756863,
                    a: 1,
                },
                {
                    r: 0.788071,
                    g: 0.479999,
                    b: 0.539854,
                    a: 1,
                },
                {
                    r: 0.576141,
                    g: 0.246274,
                    b: 0.322845,
                    a: 1,
                },
            ],
        },
        {
            name: "lightsalmon",
            hexRGBString: "#ffa07a",
            hexRGBAString: "#ffa07aff",
            hexARGBString: "#ffffa07a",
            webRGBString: "rgb(255,160,122)",
            webRGBAString: "rgba(255,160,122,1)",
            lum: 0.478068,
            temp: 3216,
            rgba: {
                r: 1,
                g: 0.627451,
                b: 0.478431,
                a: 1,
            },
            hsl: {
                h: 17.14289,
                s: 1,
                l: 0.739216,
            },
            hsv: {
                h: 17.14289,
                s: 0.521569,
                v: 1,
            },
            xyz: {
                x: 0.573272,
                y: 0.478119,
                z: 0.24618,
            },
            lab: {
                l: 74.706118,
                a: 31.477513,
                b: 34.54871,
            },
            lch: {
                l: 74.706118,
                c: 46.73807,
                h: 47.663183,
            },
            lchToLabResult: {
                l: 74.706118,
                a: 31.477513,
                b: 34.54871,
            },
            labToLCHResult: {
                l: 74.706118,
                c: 46.73807,
                h: 47.663183,
            },
            labToXYZResult: {
                x: 0.573272,
                y: 0.478119,
                z: 0.24618,
            },
            xyzToLABResult: {
                l: 74.706134,
                a: 31.477356,
                b: 34.54867,
            },
            rgbToXYZResult: {
                x: 0.573272,
                y: 0.478119,
                z: 0.24618,
            },
            xyzToRGBResult: {
                r: 0.999999,
                g: 0.627452,
                b: 0.478431,
                a: 1,
            },
            rgbToLABResult: {
                l: 74.706118,
                a: 31.477513,
                b: 34.54871,
            },
            labToRGBResult: {
                r: 1,
                g: 0.627451,
                b: 0.478431,
                a: 1,
            },
            rgbToLCHResult: {
                l: 74.706118,
                c: 46.73807,
                h: 47.663183,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.627451,
                b: 0.478431,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.627451,
                    b: 0.478431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.036822,
                    g: 0.609215,
                    b: 0.437841,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.072051,
                    g: 0.589915,
                    b: 0.396706,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.105904,
                    g: 0.569408,
                    b: 0.354734,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.138562,
                    g: 0.547521,
                    b: 0.311467,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.170178,
                    g: 0.524033,
                    b: 0.266139,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.200882,
                    g: 0.49866,
                    b: 0.217325,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.230787,
                    g: 0.471027,
                    b: 0.161846,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.627451,
                    b: 0.478431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.961318,
                    g: 0.644741,
                    b: 0.518675,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.920444,
                    g: 0.661182,
                    b: 0.55871,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.876958,
                    g: 0.676858,
                    b: 0.598636,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.830306,
                    g: 0.691841,
                    b: 0.638527,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.779739,
                    g: 0.706192,
                    b: 0.678438,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.724198,
                    g: 0.719966,
                    b: 0.71841,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.720757,
                    g: 0.720757,
                    b: 0.720757,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.627451,
                    b: 0.478431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.907808,
                    g: 0.546609,
                    b: 0.401931,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.816699,
                    g: 0.467517,
                    b: 0.327554,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.726691,
                    g: 0.390229,
                    b: 0.255407,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.637793,
                    g: 0.314753,
                    b: 0.185521,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.550015,
                    g: 0.24097,
                    b: 0.117617,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.463364,
                    g: 0.168381,
                    b: 0.049841,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.3797,
                    g: 0.094335,
                    b: -0.03521,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.627451,
                    b: 0.478431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.093258,
                    g: 0.709973,
                    b: 0.556931,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.187563,
                    g: 0.794103,
                    b: 0.637313,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.282893,
                    g: 0.879768,
                    b: 0.71947,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.379228,
                    g: 0.966904,
                    b: 0.803303,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.476546,
                    g: 1.055445,
                    b: 0.888725,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.574826,
                    g: 1.145336,
                    b: 0.975657,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.674047,
                    g: 1.236522,
                    b: 1.064027,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.84995,
                    b: 0.772541,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.7387,
                    b: 0.625486,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.627451,
                    b: 0.478431,
                    a: 1,
                },
                {
                    r: 0.775671,
                    g: 0.416512,
                    b: 0.264247,
                    a: 1,
                },
                {
                    r: 0.551342,
                    g: 0.205574,
                    b: 0.050064,
                    a: 1,
                },
            ],
        },
        {
            name: "lightseagreen",
            hexRGBString: "#20b2aa",
            hexRGBAString: "#20b2aaff",
            hexARGBString: "#ff20b2aa",
            webRGBString: "rgb(32,178,170)",
            webRGBAString: "rgba(32,178,170,1)",
            lum: 0.350501,
            temp: 40000,
            rgba: {
                r: 0.12549,
                g: 0.698039,
                b: 0.666667,
                a: 1,
            },
            hsl: {
                h: 176.712386,
                s: 0.695238,
                l: 0.411765,
            },
            hsv: {
                h: 176.712386,
                s: 0.820225,
                v: 0.698039,
            },
            xyz: {
                x: 0.237683,
                y: 0.350471,
                z: 0.435345,
            },
            lab: {
                l: 65.785317,
                a: -37.513902,
                b: -6.331021,
            },
            lch: {
                l: 65.785317,
                c: 38.044378,
                h: 189.579239,
            },
            lchToLabResult: {
                l: 65.785317,
                a: -37.513902,
                b: -6.331021,
            },
            labToLCHResult: {
                l: 65.785317,
                c: 38.044378,
                h: 189.57924,
            },
            labToXYZResult: {
                x: 0.237683,
                y: 0.350471,
                z: 0.435345,
            },
            xyzToLABResult: {
                l: 65.785319,
                a: -37.513725,
                b: -6.330996,
            },
            rgbToXYZResult: {
                x: 0.237683,
                y: 0.350471,
                z: 0.435345,
            },
            xyzToRGBResult: {
                r: 0.125498,
                g: 0.698039,
                b: 0.666667,
                a: 1,
            },
            rgbToLABResult: {
                l: 65.785317,
                a: -37.513902,
                b: -6.331021,
            },
            labToRGBResult: {
                r: 0.12549,
                g: 0.698039,
                b: 0.666667,
                a: 1,
            },
            rgbToLCHResult: {
                l: 65.785317,
                c: 38.044378,
                h: 189.579239,
            },
            lchToRGBResult: {
                r: 0.12549,
                g: 0.698039,
                b: 0.666667,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.12549,
                    g: 0.698039,
                    b: 0.666667,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.59093,
                    g: 0.709728,
                    b: 0.674978,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -1.335789,
                    g: 0.720647,
                    b: 0.683345,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -2.048813,
                    g: 0.730851,
                    b: 0.691765,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -2.730855,
                    g: 0.74039,
                    b: 0.700234,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -3.382767,
                    g: 0.749309,
                    b: 0.708752,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -4.0054,
                    g: 0.757649,
                    b: 0.717316,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -4.599606,
                    g: 0.765445,
                    b: 0.725922,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.12549,
                    g: 0.698039,
                    b: 0.666667,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.307919,
                    g: 0.685515,
                    b: 0.658414,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.413682,
                    g: 0.672082,
                    b: 0.650223,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.496512,
                    g: 0.657656,
                    b: 0.642096,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.567376,
                    g: 0.642137,
                    b: 0.634036,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.626591,
                    g: 0.626591,
                    b: 0.626591,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.626591,
                    g: 0.626591,
                    b: 0.626591,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.626591,
                    g: 0.626591,
                    b: 0.626591,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.12549,
                    g: 0.698039,
                    b: 0.666667,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.161119,
                    g: 0.615718,
                    b: 0.586372,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.375049,
                    g: 0.535139,
                    b: 0.508053,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.477977,
                    g: 0.456407,
                    b: 0.431872,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.492702,
                    g: 0.379639,
                    b: 0.358027,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.442024,
                    g: 0.304962,
                    b: 0.286765,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.348741,
                    g: 0.232515,
                    b: 0.218403,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.277016,
                    g: 0.166229,
                    b: 0.153134,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.12549,
                    g: 0.698039,
                    b: 0.666667,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.256407,
                    g: 0.782009,
                    b: 0.748801,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.359774,
                    g: 0.867543,
                    b: 0.832657,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.455295,
                    g: 0.954567,
                    b: 0.918136,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.547776,
                    g: 1.043011,
                    b: 1.005149,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.639113,
                    g: 1.132815,
                    b: 1.09362,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.730217,
                    g: 1.223922,
                    b: 1.18348,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.821579,
                    g: 1.316281,
                    b: 1.274667,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.605716,
                    g: 0.900907,
                    b: 0.886615,
                    a: 1,
                },
                {
                    r: 0.365603,
                    g: 0.799473,
                    b: 0.776641,
                    a: 1,
                },
                {
                    r: 0.12549,
                    g: 0.698039,
                    b: 0.666667,
                    a: 1,
                },
                {
                    r: 0.062745,
                    g: 0.509973,
                    b: 0.482765,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.321907,
                    b: 0.298862,
                    a: 1,
                },
            ],
        },
        {
            name: "lightskyblue",
            hexRGBString: "#87cefa",
            hexRGBAString: "#87cefaff",
            hexARGBString: "#ff87cefa",
            webRGBString: "rgb(135,206,250)",
            webRGBAString: "rgba(135,206,250,1)",
            lum: 0.561956,
            temp: 40000,
            rgba: {
                r: 0.529412,
                g: 0.807843,
                b: 0.980392,
                a: 1,
            },
            hsl: {
                h: 202.956539,
                s: 0.919999,
                l: 0.754902,
            },
            hsv: {
                h: 202.956539,
                s: 0.46,
                v: 0.980392,
            },
            xyz: {
                x: 0.493122,
                y: 0.56192,
                z: 0.986715,
            },
            lab: {
                l: 79.722995,
                a: -10.831104,
                b: -28.501778,
            },
            lch: {
                l: 79.722995,
                c: 30.490394,
                h: 249.192456,
            },
            lchToLabResult: {
                l: 79.722995,
                a: -10.831104,
                b: -28.501777,
            },
            labToLCHResult: {
                l: 79.722995,
                c: 30.490395,
                h: 249.192457,
            },
            labToXYZResult: {
                x: 0.493122,
                y: 0.56192,
                z: 0.986715,
            },
            xyzToLABResult: {
                l: 79.722967,
                a: -10.831013,
                b: -28.501802,
            },
            rgbToXYZResult: {
                x: 0.493122,
                y: 0.56192,
                z: 0.986715,
            },
            xyzToRGBResult: {
                r: 0.529413,
                g: 0.807843,
                b: 0.980392,
                a: 1,
            },
            rgbToLABResult: {
                l: 79.722995,
                a: -10.831104,
                b: -28.501778,
            },
            labToRGBResult: {
                r: 0.529412,
                g: 0.807843,
                b: 0.980392,
                a: 1,
            },
            rgbToLCHResult: {
                l: 79.722995,
                c: 30.490394,
                h: 249.192456,
            },
            lchToRGBResult: {
                r: 0.529412,
                g: 0.807843,
                b: 0.980392,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.529412,
                    g: 0.807843,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.427217,
                    g: 0.816215,
                    b: 1.032872,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.270354,
                    g: 0.824601,
                    b: 1.08559,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.489588,
                    g: 0.833008,
                    b: 1.138562,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.799945,
                    g: 0.841443,
                    b: 1.191802,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -3.165523,
                    g: 0.849912,
                    b: 1.245319,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -4.588334,
                    g: 0.85842,
                    b: 1.29912,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -6.07039,
                    g: 0.866972,
                    b: 1.353209,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.529412,
                    g: 0.807843,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.608167,
                    g: 0.799479,
                    b: 0.928128,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.673039,
                    g: 0.791115,
                    b: 0.876051,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.728462,
                    g: 0.782744,
                    b: 0.824123,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.774756,
                    g: 0.774756,
                    b: 0.774756,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.774756,
                    g: 0.774756,
                    b: 0.774756,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.774756,
                    g: 0.774756,
                    b: 0.774756,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.774756,
                    g: 0.774756,
                    b: 0.774756,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.529412,
                    g: 0.807843,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.442366,
                    g: 0.724427,
                    b: 0.893508,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.354309,
                    g: 0.64276,
                    b: 0.808151,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.262815,
                    g: 0.562964,
                    b: 0.724406,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.160198,
                    g: 0.48518,
                    b: 0.64237,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.014001,
                    g: 0.409581,
                    b: 0.562153,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.193106,
                    g: 0.336375,
                    b: 0.483884,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.275494,
                    g: 0.26583,
                    b: 0.407716,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.529412,
                    g: 0.807843,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.616476,
                    g: 0.892905,
                    b: 1.068728,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.70406,
                    g: 0.979522,
                    b: 1.158449,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.792427,
                    g: 1.067615,
                    b: 1.249494,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.881717,
                    g: 1.157113,
                    b: 1.341808,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.972006,
                    g: 1.247952,
                    b: 1.435343,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.06333,
                    g: 1.340076,
                    b: 1.530051,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.155705,
                    g: 1.433433,
                    b: 1.625893,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.772866,
                    g: 0.937046,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.651139,
                    g: 0.872444,
                    b: 0.990196,
                    a: 1,
                },
                {
                    r: 0.529412,
                    g: 0.807843,
                    b: 0.980392,
                    a: 1,
                },
                {
                    r: 0.264706,
                    g: 0.598925,
                    b: 0.777166,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.390008,
                    b: 0.573941,
                    a: 1,
                },
            ],
        },
        {
            name: "lightslategray",
            hexRGBString: "#778899",
            hexRGBAString: "#778899ff",
            hexARGBString: "#ff778899",
            webRGBString: "rgb(119,136,153)",
            webRGBAString: "rgba(119,136,153,1)",
            lum: 0.238301,
            temp: 10781,
            rgba: {
                r: 0.466667,
                g: 0.533333,
                b: 0.6,
                a: 1,
            },
            hsl: {
                h: 210.000225,
                s: 0.142857,
                l: 0.533334,
            },
            hsv: {
                h: 210.000225,
                s: 0.222222,
                v: 0.6,
            },
            xyz: {
                x: 0.221601,
                y: 0.238295,
                z: 0.335628,
            },
            lab: {
                l: 55.916699,
                a: -2.24761,
                b: -11.107994,
            },
            lch: {
                l: 55.916699,
                c: 11.333105,
                h: 258.561117,
            },
            lchToLabResult: {
                l: 55.916699,
                a: -2.24761,
                b: -11.107993,
            },
            labToLCHResult: {
                l: 55.916699,
                c: 11.333106,
                h: 258.561119,
            },
            labToXYZResult: {
                x: 0.221601,
                y: 0.238295,
                z: 0.335628,
            },
            xyzToLABResult: {
                l: 55.91668,
                a: -2.247707,
                b: -11.10801,
            },
            rgbToXYZResult: {
                x: 0.221601,
                y: 0.238295,
                z: 0.335628,
            },
            xyzToRGBResult: {
                r: 0.466666,
                g: 0.533333,
                b: 0.6,
                a: 1,
            },
            rgbToLABResult: {
                l: 55.916699,
                a: -2.24761,
                b: -11.107994,
            },
            labToRGBResult: {
                r: 0.466667,
                g: 0.533333,
                b: 0.6,
                a: 1,
            },
            rgbToLCHResult: {
                l: 55.916699,
                c: 11.333105,
                h: 258.561117,
            },
            lchToRGBResult: {
                r: 0.466667,
                g: 0.533333,
                b: 0.6,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.415681,
                    g: 0.538934,
                    b: 0.650988,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.35013,
                    g: 0.5447,
                    b: 0.702228,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.256707,
                    g: 0.550637,
                    b: 0.753772,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.03978,
                    g: 0.556754,
                    b: 0.805654,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.661359,
                    g: 0.563055,
                    b: 0.857898,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.41315,
                    g: 0.569546,
                    b: 0.910521,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -2.217875,
                    g: 0.576232,
                    b: 0.963533,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.508283,
                    g: 0.527889,
                    b: 0.54919,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.390554,
                    g: 0.456383,
                    b: 0.521183,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.316606,
                    g: 0.381691,
                    b: 0.444449,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.244941,
                    g: 0.309485,
                    b: 0.369983,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.175606,
                    g: 0.240054,
                    b: 0.298011,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.108328,
                    g: 0.173781,
                    b: 0.228817,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.041099,
                    g: 0.111203,
                    b: 0.162777,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.045619,
                    g: 0.038459,
                    b: 0.101826,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.544815,
                    g: 0.612359,
                    b: 0.680749,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.624873,
                    g: 0.693308,
                    b: 0.7633,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.706729,
                    g: 0.776052,
                    b: 0.847544,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.790281,
                    g: 0.86048,
                    b: 0.933385,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.875439,
                    g: 0.946499,
                    b: 1.020737,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.962122,
                    g: 1.034023,
                    b: 1.109528,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.050256,
                    g: 1.122979,
                    b: 1.19969,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.765804,
                    g: 0.832691,
                    b: 0.896598,
                    a: 1,
                },
                {
                    r: 0.616235,
                    g: 0.683012,
                    b: 0.748299,
                    a: 1,
                },
                {
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    r: 0.233334,
                    g: 0.366179,
                    b: 0.475259,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.199025,
                    b: 0.350518,
                    a: 1,
                },
            ],
        },
        {
            name: "lightslategrey",
            hexRGBString: "#778899",
            hexRGBAString: "#778899ff",
            hexARGBString: "#ff778899",
            webRGBString: "rgb(119,136,153)",
            webRGBAString: "rgba(119,136,153,1)",
            lum: 0.238301,
            temp: 10781,
            rgba: {
                r: 0.466667,
                g: 0.533333,
                b: 0.6,
                a: 1,
            },
            hsl: {
                h: 210.000225,
                s: 0.142857,
                l: 0.533334,
            },
            hsv: {
                h: 210.000225,
                s: 0.222222,
                v: 0.6,
            },
            xyz: {
                x: 0.221601,
                y: 0.238295,
                z: 0.335628,
            },
            lab: {
                l: 55.916699,
                a: -2.24761,
                b: -11.107994,
            },
            lch: {
                l: 55.916699,
                c: 11.333105,
                h: 258.561117,
            },
            lchToLabResult: {
                l: 55.916699,
                a: -2.24761,
                b: -11.107993,
            },
            labToLCHResult: {
                l: 55.916699,
                c: 11.333106,
                h: 258.561119,
            },
            labToXYZResult: {
                x: 0.221601,
                y: 0.238295,
                z: 0.335628,
            },
            xyzToLABResult: {
                l: 55.91668,
                a: -2.247707,
                b: -11.10801,
            },
            rgbToXYZResult: {
                x: 0.221601,
                y: 0.238295,
                z: 0.335628,
            },
            xyzToRGBResult: {
                r: 0.466666,
                g: 0.533333,
                b: 0.6,
                a: 1,
            },
            rgbToLABResult: {
                l: 55.916699,
                a: -2.24761,
                b: -11.107994,
            },
            labToRGBResult: {
                r: 0.466667,
                g: 0.533333,
                b: 0.6,
                a: 1,
            },
            rgbToLCHResult: {
                l: 55.916699,
                c: 11.333105,
                h: 258.561117,
            },
            lchToRGBResult: {
                r: 0.466667,
                g: 0.533333,
                b: 0.6,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.415681,
                    g: 0.538934,
                    b: 0.650988,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.35013,
                    g: 0.5447,
                    b: 0.702228,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.256707,
                    g: 0.550637,
                    b: 0.753772,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.03978,
                    g: 0.556754,
                    b: 0.805654,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.661359,
                    g: 0.563055,
                    b: 0.857898,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.41315,
                    g: 0.569546,
                    b: 0.910521,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -2.217875,
                    g: 0.576232,
                    b: 0.963533,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.508283,
                    g: 0.527889,
                    b: 0.54919,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.525386,
                    g: 0.525386,
                    b: 0.525386,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.390554,
                    g: 0.456383,
                    b: 0.521183,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.316606,
                    g: 0.381691,
                    b: 0.444449,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.244941,
                    g: 0.309485,
                    b: 0.369983,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.175606,
                    g: 0.240054,
                    b: 0.298011,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.108328,
                    g: 0.173781,
                    b: 0.228817,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.041099,
                    g: 0.111203,
                    b: 0.162777,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.045619,
                    g: 0.038459,
                    b: 0.101826,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.544815,
                    g: 0.612359,
                    b: 0.680749,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.624873,
                    g: 0.693308,
                    b: 0.7633,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.706729,
                    g: 0.776052,
                    b: 0.847544,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.790281,
                    g: 0.86048,
                    b: 0.933385,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.875439,
                    g: 0.946499,
                    b: 1.020737,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.962122,
                    g: 1.034023,
                    b: 1.109528,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.050256,
                    g: 1.122979,
                    b: 1.19969,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.765804,
                    g: 0.832691,
                    b: 0.896598,
                    a: 1,
                },
                {
                    r: 0.616235,
                    g: 0.683012,
                    b: 0.748299,
                    a: 1,
                },
                {
                    r: 0.466667,
                    g: 0.533333,
                    b: 0.6,
                    a: 1,
                },
                {
                    r: 0.233334,
                    g: 0.366179,
                    b: 0.475259,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.199025,
                    b: 0.350518,
                    a: 1,
                },
            ],
        },
        {
            name: "lightsteelblue",
            hexRGBString: "#b0c4de",
            hexRGBAString: "#b0c4deff",
            hexARGBString: "#ffb0c4de",
            webRGBString: "rgb(176,196,222)",
            webRGBAString: "rgba(176,196,222,1)",
            lum: 0.539838,
            temp: 10227,
            rgba: {
                r: 0.690196,
                g: 0.768627,
                b: 0.870588,
                a: 1,
            },
            hsl: {
                h: 213.913145,
                s: 0.410714,
                l: 0.780392,
            },
            hsv: {
                h: 213.913145,
                s: 0.207207,
                v: 0.870588,
            },
            xyz: {
                x: 0.508258,
                y: 0.539825,
                z: 0.768349,
            },
            lab: {
                l: 78.451546,
                a: -1.281542,
                b: -15.211014,
            },
            lch: {
                l: 78.451546,
                c: 15.264904,
                h: 265.184151,
            },
            lchToLabResult: {
                l: 78.451546,
                a: -1.281542,
                b: -15.211014,
            },
            labToLCHResult: {
                l: 78.451546,
                c: 15.264904,
                h: 265.184151,
            },
            labToXYZResult: {
                x: 0.508258,
                y: 0.539825,
                z: 0.768349,
            },
            xyzToLABResult: {
                l: 78.451528,
                a: -1.281372,
                b: -15.21108,
            },
            rgbToXYZResult: {
                x: 0.508258,
                y: 0.539825,
                z: 0.768349,
            },
            xyzToRGBResult: {
                r: 0.690197,
                g: 0.768626,
                b: 0.870588,
                a: 1,
            },
            rgbToLABResult: {
                l: 78.451546,
                a: -1.281542,
                b: -15.211014,
            },
            labToRGBResult: {
                r: 0.690196,
                g: 0.768627,
                b: 0.870588,
                a: 1,
            },
            rgbToLCHResult: {
                l: 78.451546,
                c: 15.264904,
                h: 265.184151,
            },
            lchToRGBResult: {
                r: 0.690196,
                g: 0.768627,
                b: 0.870588,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.690196,
                    g: 0.768627,
                    b: 0.870588,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.645686,
                    g: 0.77276,
                    b: 0.926143,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.592968,
                    g: 0.777088,
                    b: 0.98189,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.528801,
                    g: 0.781616,
                    b: 1.037868,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.446891,
                    g: 0.786349,
                    b: 1.094106,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.331107,
                    g: 0.791291,
                    b: 1.150626,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.069082,
                    g: 0.796446,
                    b: 1.207446,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.075109,
                    g: 0.801818,
                    b: 1.264575,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.690196,
                    g: 0.768627,
                    b: 0.870588,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.728432,
                    g: 0.764684,
                    b: 0.815173,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.761002,
                    g: 0.761002,
                    b: 0.761002,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.761002,
                    g: 0.761002,
                    b: 0.761002,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.761002,
                    g: 0.761002,
                    b: 0.761002,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.761002,
                    g: 0.761002,
                    b: 0.761002,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.761002,
                    g: 0.761002,
                    b: 0.761002,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.761002,
                    g: 0.761002,
                    b: 0.761002,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.690196,
                    g: 0.768627,
                    b: 0.870588,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.608316,
                    g: 0.686058,
                    b: 0.785856,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.528186,
                    g: 0.605298,
                    b: 0.702783,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.449893,
                    g: 0.526478,
                    b: 0.621474,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.37352,
                    g: 0.449752,
                    b: 0.542051,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.299122,
                    g: 0.375311,
                    b: 0.464658,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.226659,
                    g: 0.303389,
                    b: 0.389463,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.155794,
                    g: 0.234286,
                    b: 0.316677,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.690196,
                    g: 0.768627,
                    b: 0.870588,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.773738,
                    g: 0.852892,
                    b: 0.956888,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.858863,
                    g: 0.938757,
                    b: 1.044676,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.945495,
                    g: 1.026136,
                    b: 1.133879,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.033566,
                    g: 1.114955,
                    b: 1.224435,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.123014,
                    g: 1.205146,
                    b: 1.316284,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.213782,
                    g: 1.29665,
                    b: 1.409375,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.305818,
                    g: 1.389412,
                    b: 1.503661,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.853319,
                    g: 0.918181,
                    b: 0.998683,
                    a: 1,
                },
                {
                    r: 0.771758,
                    g: 0.843404,
                    b: 0.934636,
                    a: 1,
                },
                {
                    r: 0.690196,
                    g: 0.768627,
                    b: 0.870588,
                    a: 1,
                },
                {
                    r: 0.380498,
                    g: 0.562835,
                    b: 0.695949,
                    a: 1,
                },
                {
                    r: 0.070799,
                    g: 0.357043,
                    b: 0.52131,
                    a: 1,
                },
            ],
        },
        {
            name: "lightyellow",
            hexRGBString: "#ffffe0",
            hexRGBAString: "#ffffe0ff",
            hexARGBString: "#ffffffe0",
            webRGBString: "rgb(255,255,224)",
            webRGBAString: "rgba(255,255,224,1)",
            lum: 0.981618,
            temp: 5535,
            rgba: {
                r: 1,
                g: 1,
                b: 0.878431,
                a: 1,
            },
            hsl: {
                h: 60,
                s: 1,
                l: 0.939216,
            },
            hsv: {
                h: 60,
                s: 0.121569,
                v: 1,
            },
            xyz: {
                x: 0.904531,
                y: 0.981625,
                z: 0.846886,
            },
            lab: {
                l: 99.285087,
                a: -5.107308,
                b: 14.837802,
            },
            lch: {
                l: 99.285087,
                c: 15.692194,
                h: 108.993934,
            },
            lchToLabResult: {
                l: 99.285087,
                a: -5.107308,
                b: 14.837802,
            },
            labToLCHResult: {
                l: 99.285087,
                c: 15.692194,
                h: 108.993934,
            },
            labToXYZResult: {
                x: 0.904531,
                y: 0.981625,
                z: 0.846886,
            },
            xyzToLABResult: {
                l: 99.285103,
                a: -5.10742,
                b: 14.837822,
            },
            rgbToXYZResult: {
                x: 0.904531,
                y: 0.981625,
                z: 0.846886,
            },
            xyzToRGBResult: {
                r: 0.999999,
                g: 1.000001,
                b: 0.878431,
                a: 1,
            },
            rgbToLABResult: {
                l: 99.285087,
                a: -5.107308,
                b: 14.837802,
            },
            labToRGBResult: {
                r: 1,
                g: 1,
                b: 0.878431,
                a: 1,
            },
            rgbToLCHResult: {
                l: 99.285087,
                c: 15.692194,
                h: 108.993934,
            },
            lchToRGBResult: {
                r: 1,
                g: 1,
                b: 0.878431,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 1,
                    b: 0.878431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.001582,
                    g: 1.004093,
                    b: 0.82228,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.001684,
                    g: 1.008243,
                    b: 0.76568,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.000375,
                    g: 1.012444,
                    b: 0.708418,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.997717,
                    g: 1.01669,
                    b: 0.650195,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.993763,
                    g: 1.020974,
                    b: 0.590581,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.988563,
                    g: 1.025291,
                    b: 0.528927,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.982161,
                    g: 1.029635,
                    b: 0.464192,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 1,
                    b: 0.878431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.99686,
                    g: 0.995971,
                    b: 0.934291,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.992073,
                    g: 0.992013,
                    b: 0.989978,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.991879,
                    g: 0.991879,
                    b: 0.991879,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.991879,
                    g: 0.991879,
                    b: 0.991879,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.991879,
                    g: 0.991879,
                    b: 0.991879,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.991879,
                    g: 0.991879,
                    b: 0.991879,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.991879,
                    g: 0.991879,
                    b: 0.991879,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 1,
                    b: 0.878431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.912806,
                    g: 0.913051,
                    b: 0.793528,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.827122,
                    g: 0.827639,
                    b: 0.71027,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.743031,
                    g: 0.743852,
                    b: 0.62876,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.660627,
                    g: 0.661791,
                    b: 0.549116,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.580017,
                    g: 0.581571,
                    b: 0.471474,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.501324,
                    g: 0.503331,
                    b: 0.395996,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.424692,
                    g: 0.427232,
                    b: 0.322877,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 1,
                    b: 0.878431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.088632,
                    g: 1.088409,
                    b: 0.964891,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.178635,
                    g: 1.178208,
                    b: 1.052829,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.269951,
                    g: 1.269336,
                    b: 1.142174,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.362525,
                    g: 1.361738,
                    b: 1.232863,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.45631,
                    g: 1.455361,
                    b: 1.324841,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.551261,
                    g: 1.550162,
                    b: 1.418054,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.647336,
                    g: 1.646096,
                    b: 1.512456,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 1,
                    b: 0.909617,
                    a: 1,
                },
                {
                    r: 1,
                    g: 1,
                    b: 0.894024,
                    a: 1,
                },
                {
                    r: 1,
                    g: 1,
                    b: 0.878431,
                    a: 1,
                },
                {
                    r: 0.74306,
                    g: 0.748781,
                    b: 0.591507,
                    a: 1,
                },
                {
                    r: 0.486119,
                    g: 0.497561,
                    b: 0.304582,
                    a: 1,
                },
            ],
        },
        {
            name: "lime",
            hexRGBString: "#00ff00",
            hexRGBAString: "#00ff00ff",
            hexARGBString: "#ff00ff00",
            webRGBString: "rgb(0,255,0)",
            webRGBAString: "rgba(0,255,0,1)",
            lum: 0.7152,
            temp: 40000,
            rgba: {
                r: 0,
                g: 1,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 120,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 120,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.357576,
                y: 0.715152,
                z: 0.119192,
            },
            lab: {
                l: 87.734722,
                a: -86.182716,
                b: 83.179321,
            },
            lch: {
                l: 87.734722,
                c: 119.775874,
                h: 136.015953,
            },
            lchToLabResult: {
                l: 87.734722,
                a: -86.182716,
                b: 83.179321,
            },
            labToLCHResult: {
                l: 87.734722,
                c: 119.775874,
                h: 136.015953,
            },
            labToXYZResult: {
                x: 0.357576,
                y: 0.715152,
                z: 0.119192,
            },
            xyzToLABResult: {
                l: 87.734713,
                a: -86.182708,
                b: 83.179304,
            },
            rgbToXYZResult: {
                x: 0.357576,
                y: 0.715152,
                z: 0.119192,
            },
            xyzToRGBResult: {
                r: 0,
                g: 1,
                b: 0,
                a: 1,
            },
            rgbToLABResult: {
                l: 87.734722,
                a: -86.182716,
                b: 83.179321,
            },
            labToRGBResult: {
                r: 0.000001,
                g: 1,
                b: 0,
                a: 1,
            },
            rgbToLCHResult: {
                l: 87.734722,
                c: 119.775874,
                h: 136.015953,
            },
            lchToRGBResult: {
                r: 0,
                g: 1,
                b: 0,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.558204,
                    g: 1.006547,
                    b: -0.270144,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -1.109128,
                    g: 1.012867,
                    b: -0.511015,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -1.65229,
                    g: 1.018966,
                    b: -0.724334,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -2.187206,
                    g: 1.02485,
                    b: -0.911821,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -2.713395,
                    g: 1.030525,
                    b: -1.075198,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -3.230375,
                    g: 1.035997,
                    b: -1.216185,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -3.737663,
                    g: 1.041271,
                    b: -1.336502,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.231362,
                    g: 0.993219,
                    b: 0.165315,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.328136,
                    g: 0.986196,
                    b: 0.245639,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.399649,
                    g: 0.978924,
                    b: 0.308762,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.458606,
                    g: 0.971395,
                    b: 0.363897,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.509744,
                    g: 0.963599,
                    b: 0.414409,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.555423,
                    g: 0.955527,
                    b: 0.461943,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.597018,
                    g: 0.947168,
                    b: 0.507436,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.551351,
                    g: 0.910242,
                    b: -0.263616,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.923521,
                    g: 0.821746,
                    b: -0.410704,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -1.13931,
                    g: 0.734547,
                    b: -0.464063,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.221517,
                    g: 0.648678,
                    b: -0.446494,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.178318,
                    g: 0.564077,
                    b: -0.411808,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.020124,
                    g: 0.480608,
                    b: -0.409078,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.781979,
                    g: 0.398191,
                    b: -0.435135,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 1,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.267828,
                    g: 1.090983,
                    b: 0.193739,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.401629,
                    g: 1.183155,
                    b: 0.30338,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.51572,
                    g: 1.27648,
                    b: 0.400149,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.621872,
                    g: 1.370926,
                    b: 0.492429,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.724156,
                    g: 1.466459,
                    b: 0.583005,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.824452,
                    g: 1.563049,
                    b: 0.673111,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.923769,
                    g: 1.660667,
                    b: 0.763372,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.591056,
                    g: 1,
                    b: 0.598166,
                    a: 1,
                },
                {
                    r: 0.295528,
                    g: 1,
                    b: 0.299083,
                    a: 1,
                },
                {
                    r: 0,
                    g: 1,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.750179,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.500358,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "limegreen",
            hexRGBString: "#32cd32",
            hexRGBAString: "#32cd32ff",
            hexARGBString: "#ff32cd32",
            webRGBString: "rgb(50,205,50)",
            webRGBAString: "rgba(50,205,50,1)",
            lum: 0.445711,
            temp: 6650,
            rgba: {
                r: 0.196078,
                g: 0.803922,
                b: 0.196078,
                a: 1,
            },
            hsl: {
                h: 120,
                s: 0.607844,
                l: 0.5,
            },
            hsv: {
                h: 120,
                s: 0.756098,
                v: 0.803922,
            },
            xyz: {
                x: 0.23721,
                y: 0.445683,
                z: 0.103694,
            },
            lab: {
                l: 72.606741,
                a: -67.125605,
                b: 61.437289,
            },
            lch: {
                l: 72.606741,
                c: 90.996634,
                h: 137.533422,
            },
            lchToLabResult: {
                l: 72.606741,
                a: -67.125605,
                b: 61.437289,
            },
            labToLCHResult: {
                l: 72.606741,
                c: 90.996634,
                h: 137.533422,
            },
            labToXYZResult: {
                x: 0.23721,
                y: 0.445683,
                z: 0.103694,
            },
            xyzToLABResult: {
                l: 72.606724,
                a: -67.125432,
                b: 61.437188,
            },
            rgbToXYZResult: {
                x: 0.23721,
                y: 0.445683,
                z: 0.103694,
            },
            xyzToRGBResult: {
                r: 0.196081,
                g: 0.803922,
                b: 0.196079,
                a: 1,
            },
            rgbToLABResult: {
                l: 72.606741,
                a: -67.125605,
                b: 61.437289,
            },
            labToRGBResult: {
                r: 0.196078,
                g: 0.803922,
                b: 0.196078,
                a: 1,
            },
            rgbToLCHResult: {
                l: 72.606741,
                c: 90.996634,
                h: 137.533422,
            },
            lchToRGBResult: {
                r: 0.196078,
                g: 0.803922,
                b: 0.196078,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.196078,
                    g: 0.803922,
                    b: 0.196078,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.008932,
                    g: 0.810655,
                    b: 0.120409,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.423129,
                    g: 0.817107,
                    b: -0.037197,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.830103,
                    g: 0.823289,
                    b: -0.223842,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.229465,
                    g: 0.829209,
                    b: -0.387262,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.620822,
                    g: 0.834877,
                    b: -0.52904,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -2.003784,
                    g: 0.840302,
                    b: -0.650757,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -2.377959,
                    g: 0.845491,
                    b: -0.753995,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.196078,
                    g: 0.803922,
                    b: 0.196078,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.282739,
                    g: 0.796897,
                    b: 0.253944,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.346713,
                    g: 0.789567,
                    b: 0.30419,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.399513,
                    g: 0.781921,
                    b: 0.350201,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.445385,
                    g: 0.773943,
                    b: 0.393567,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.486439,
                    g: 0.765619,
                    b: 0.435168,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.523893,
                    g: 0.756932,
                    b: 0.475542,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.558527,
                    g: 0.747864,
                    b: 0.515045,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.196078,
                    g: 0.803922,
                    b: 0.196078,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.046453,
                    g: 0.718229,
                    b: 0.090588,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.350515,
                    g: 0.634011,
                    b: -0.073845,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.522893,
                    g: 0.551325,
                    b: -0.166498,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.585265,
                    g: 0.470217,
                    b: -0.19171,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.537958,
                    g: 0.390514,
                    b: -0.219944,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.404259,
                    g: 0.312037,
                    b: -0.272963,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.261495,
                    g: 0.237107,
                    b: -0.348045,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.196078,
                    g: 0.803922,
                    b: 0.196078,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.315423,
                    g: 0.891034,
                    b: 0.284646,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.417965,
                    g: 0.979512,
                    b: 0.369202,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.514553,
                    g: 1.069305,
                    b: 0.452838,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.608641,
                    g: 1.160365,
                    b: 0.536709,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.701741,
                    g: 1.252648,
                    b: 0.621329,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.794629,
                    g: 1.346112,
                    b: 0.706942,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.887738,
                    g: 1.440718,
                    b: 0.793668,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.669251,
                    g: 0.936091,
                    b: 0.672911,
                    a: 1,
                },
                {
                    r: 0.432665,
                    g: 0.870006,
                    b: 0.434495,
                    a: 1,
                },
                {
                    r: 0.196078,
                    g: 0.803922,
                    b: 0.196078,
                    a: 1,
                },
                {
                    r: 0.098039,
                    g: 0.593307,
                    b: 0.098039,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.382692,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "linen",
            hexRGBString: "#faf0e6",
            hexRGBAString: "#faf0e6ff",
            hexARGBString: "#fffaf0e6",
            webRGBString: "rgb(250,240,230)",
            webRGBAString: "rgba(250,240,230,1)",
            lum: 0.883573,
            temp: 5857,
            rgba: {
                r: 0.980392,
                g: 0.941176,
                b: 0.901961,
                a: 1,
            },
            hsl: {
                h: 29.999617,
                s: 0.666664,
                l: 0.941177,
            },
            hsv: {
                h: 29.999617,
                s: 0.08,
                v: 0.980392,
            },
            xyz: {
                x: 0.848657,
                y: 0.883581,
                z: 0.874317,
            },
            lab: {
                l: 95.311516,
                a: 1.677501,
                b: 6.022045,
            },
            lch: {
                l: 95.311516,
                c: 6.251323,
                h: 74.43429,
            },
            lchToLabResult: {
                l: 95.311516,
                a: 1.677501,
                b: 6.022045,
            },
            labToLCHResult: {
                l: 95.311516,
                c: 6.251323,
                h: 74.434289,
            },
            labToXYZResult: {
                x: 0.848657,
                y: 0.883581,
                z: 0.874317,
            },
            xyzToLABResult: {
                l: 95.31152,
                a: 1.677526,
                b: 6.022026,
            },
            rgbToXYZResult: {
                x: 0.848657,
                y: 0.883581,
                z: 0.874317,
            },
            xyzToRGBResult: {
                r: 0.980392,
                g: 0.941176,
                b: 0.901961,
                a: 1,
            },
            rgbToLABResult: {
                l: 95.311516,
                a: 1.677501,
                b: 6.022045,
            },
            labToRGBResult: {
                r: 0.980392,
                g: 0.941176,
                b: 0.901961,
                a: 1,
            },
            rgbToLCHResult: {
                l: 95.311516,
                c: 6.251323,
                h: 74.43429,
            },
            lchToRGBResult: {
                r: 0.980392,
                g: 0.941176,
                b: 0.901961,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.941176,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.018159,
                    g: 0.934071,
                    b: 0.84637,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.052631,
                    g: 0.927012,
                    b: 0.790631,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.084268,
                    g: 0.919993,
                    b: 0.734613,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.113438,
                    g: 0.913009,
                    b: 0.678134,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.140441,
                    g: 0.906054,
                    b: 0.620941,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.165531,
                    g: 0.899122,
                    b: 0.562664,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.188919,
                    g: 0.892205,
                    b: 0.502748,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.941176,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.946971,
                    g: 0.946971,
                    b: 0.946971,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.946971,
                    g: 0.946971,
                    b: 0.946971,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.946971,
                    g: 0.946971,
                    b: 0.946971,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.946971,
                    g: 0.946971,
                    b: 0.946971,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.946971,
                    g: 0.946971,
                    b: 0.946971,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.946971,
                    g: 0.946971,
                    b: 0.946971,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.946971,
                    g: 0.946971,
                    b: 0.946971,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.941176,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.893665,
                    g: 0.855246,
                    b: 0.816727,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.808482,
                    g: 0.770909,
                    b: 0.733126,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.724929,
                    g: 0.688263,
                    b: 0.651261,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.643108,
                    g: 0.607418,
                    b: 0.57125,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.563133,
                    g: 0.528502,
                    b: 0.49323,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.485141,
                    g: 0.45167,
                    b: 0.417367,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.409292,
                    g: 0.377106,
                    b: 0.343862,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.980392,
                    g: 0.941176,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.068584,
                    g: 1.028617,
                    b: 0.988741,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.158173,
                    g: 1.117493,
                    b: 1.076987,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.249096,
                    g: 1.207738,
                    b: 1.166631,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.341297,
                    g: 1.299293,
                    b: 1.257609,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.434726,
                    g: 1.392103,
                    b: 1.349866,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.529336,
                    g: 1.48612,
                    b: 1.443351,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.625085,
                    g: 1.581299,
                    b: 1.538017,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.972529,
                    b: 0.917914,
                    a: 1,
                },
                {
                    r: 0.990196,
                    g: 0.956852,
                    b: 0.909938,
                    a: 1,
                },
                {
                    r: 0.980392,
                    g: 0.941176,
                    b: 0.901961,
                    a: 1,
                },
                {
                    r: 0.756803,
                    g: 0.691806,
                    b: 0.612892,
                    a: 1,
                },
                {
                    r: 0.533214,
                    g: 0.442436,
                    b: 0.323822,
                    a: 1,
                },
            ],
        },
        {
            name: "magenta",
            hexRGBString: "#ff00ff",
            hexRGBAString: "#ff00ffff",
            hexARGBString: "#ffff00ff",
            webRGBString: "rgb(255,0,255)",
            webRGBAString: "rgba(255,0,255,1)",
            lum: 0.2848,
            temp: 6650,
            rgba: {
                r: 1,
                g: 0,
                b: 1,
                a: 1,
            },
            hsl: {
                h: 300,
                s: 1,
                l: 0.5,
            },
            hsv: {
                h: 300,
                s: 1,
                v: 1,
            },
            xyz: {
                x: 0.592894,
                y: 0.284848,
                z: 0.969638,
            },
            lab: {
                l: 60.324212,
                a: 98.234312,
                b: -60.824892,
            },
            lch: {
                l: 60.324212,
                c: 115.540675,
                h: 328.234965,
            },
            lchToLabResult: {
                l: 60.324212,
                a: 98.234312,
                b: -60.824892,
            },
            labToLCHResult: {
                l: 60.324212,
                c: 115.540675,
                h: 328.234965,
            },
            labToXYZResult: {
                x: 0.592894,
                y: 0.284848,
                z: 0.969638,
            },
            xyzToLABResult: {
                l: 60.324221,
                a: 98.234297,
                b: -60.824877,
            },
            rgbToXYZResult: {
                x: 0.592894,
                y: 0.284848,
                z: 0.969638,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.000003,
                b: 1,
                a: 1,
            },
            rgbToLABResult: {
                l: 60.324212,
                a: 98.234312,
                b: -60.824892,
            },
            labToRGBResult: {
                r: 1,
                g: 0.000001,
                b: 1,
                a: 1,
            },
            rgbToLCHResult: {
                l: 60.324212,
                c: 115.540675,
                h: 328.234965,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.000001,
                b: 1,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.000001,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.02533,
                    g: -0.313574,
                    b: 1.029247,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.050448,
                    g: -0.63639,
                    b: 1.05859,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.075372,
                    g: -0.968579,
                    b: 1.08803,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.100118,
                    g: -1.310271,
                    b: 1.117569,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.1247,
                    g: -1.661599,
                    b: 1.147207,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.149133,
                    g: -2.022694,
                    b: 1.176947,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.173428,
                    g: -2.393689,
                    b: 1.206788,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.000001,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.974437,
                    g: 0.166328,
                    b: 0.970846,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.948618,
                    g: 0.238614,
                    b: 0.941783,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.922517,
                    g: 0.290499,
                    b: 0.912808,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.896105,
                    g: 0.332071,
                    b: 0.883916,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.869347,
                    g: 0.367125,
                    b: 0.855105,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.842205,
                    g: 0.397576,
                    b: 0.826368,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.814633,
                    g: 0.424546,
                    b: 0.797699,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.000001,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.905668,
                    g: -0.387446,
                    b: 0.911598,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.812206,
                    g: -0.629453,
                    b: 0.824606,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.719577,
                    g: -0.748818,
                    b: 0.739093,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.627725,
                    g: -0.76834,
                    b: 0.655137,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.536549,
                    g: -0.71082,
                    b: 0.572829,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.445887,
                    g: -0.599057,
                    b: 0.492277,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.355777,
                    g: -0.458917,
                    b: 0.413652,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.000001,
                    b: 1,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.095219,
                    g: 0.229385,
                    b: 1.089751,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.191334,
                    g: 0.350545,
                    b: 1.180794,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.288345,
                    g: 0.455518,
                    b: 1.273081,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.386248,
                    g: 0.554329,
                    b: 1.366565,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.485036,
                    g: 0.65039,
                    b: 1.461203,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.584699,
                    g: 0.745248,
                    b: 1.556957,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.685226,
                    g: 0.839717,
                    b: 1.65379,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.611883,
                    b: 1,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.305942,
                    b: 1,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.767057,
                    g: 0,
                    b: 0.771258,
                    a: 1,
                },
                {
                    r: 0.534114,
                    g: 0,
                    b: 0.542516,
                    a: 1,
                },
            ],
        },
        {
            name: "maroon",
            hexRGBString: "#800000",
            hexRGBAString: "#800000ff",
            hexARGBString: "#ff800000",
            webRGBString: "rgb(128,0,0)",
            webRGBAString: "rgba(128,0,0,1)",
            lum: 0.045892,
            temp: 1000,
            rgba: {
                r: 0.501961,
                g: 0,
                b: 0,
                a: 1,
            },
            hsl: {
                h: 0,
                s: 1,
                l: 0.250981,
            },
            hsv: {
                h: 0,
                s: 1,
                v: 0.501961,
            },
            xyz: {
                x: 0.089033,
                y: 0.045908,
                z: 0.004173,
            },
            lab: {
                l: 25.535544,
                a: 48.045143,
                b: 38.057337,
            },
            lch: {
                l: 25.535544,
                c: 61.291898,
                h: 38.383316,
            },
            lchToLabResult: {
                l: 25.535544,
                a: 48.045143,
                b: 38.057338,
            },
            labToLCHResult: {
                l: 25.535544,
                c: 61.291897,
                h: 38.383316,
            },
            labToXYZResult: {
                x: 0.089033,
                y: 0.045908,
                z: 0.004173,
            },
            xyzToLABResult: {
                l: 25.535628,
                a: 48.044672,
                b: 38.058096,
            },
            rgbToXYZResult: {
                x: 0.089033,
                y: 0.045908,
                z: 0.004173,
            },
            xyzToRGBResult: {
                r: 0.50196,
                g: 0.000008,
                b: -0.000007,
                a: 1,
            },
            rgbToLABResult: {
                l: 25.535544,
                a: 48.045143,
                b: 38.057337,
            },
            labToRGBResult: {
                r: 0.501961,
                g: 0,
                b: 0,
                a: 1,
            },
            rgbToLCHResult: {
                l: 25.535544,
                c: 61.291898,
                h: 38.383316,
            },
            lchToRGBResult: {
                r: 0.501961,
                g: 0,
                b: 0,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.528322,
                    g: -0.093264,
                    b: -0.040492,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.554309,
                    g: -0.191398,
                    b: -0.080704,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.579988,
                    g: -0.294529,
                    b: -0.120629,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.605414,
                    g: -0.402783,
                    b: -0.16026,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.630631,
                    g: -0.516286,
                    b: -0.199589,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.655677,
                    g: -0.635165,
                    b: -0.23861,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.680582,
                    g: -0.759546,
                    b: -0.277315,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.475143,
                    g: 0.07728,
                    b: 0.040758,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.44773,
                    g: 0.119651,
                    b: 0.073464,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.419171,
                    g: 0.149637,
                    b: 0.101975,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.388984,
                    g: 0.173345,
                    b: 0.129603,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.356603,
                    g: 0.193072,
                    b: 0.156882,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.321176,
                    g: 0.209986,
                    b: 0.184076,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.281306,
                    g: 0.224777,
                    b: 0.211328,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.415345,
                    g: -0.095385,
                    b: -0.095538,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.33483,
                    g: -0.125684,
                    b: -0.204441,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.268533,
                    g: -0.14508,
                    b: -0.319738,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.23581,
                    g: -0.237277,
                    b: -0.431118,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.211612,
                    g: -0.347616,
                    b: -0.541457,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.183867,
                    g: -0.457955,
                    b: -0.651796,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.150661,
                    g: -0.568293,
                    b: -0.762135,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.501961,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.5927,
                    g: 0.123831,
                    b: 0.075669,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.684815,
                    g: 0.211805,
                    b: 0.142228,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.777791,
                    g: 0.293645,
                    b: 0.210404,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.871641,
                    g: 0.374323,
                    b: 0.280882,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.966372,
                    g: 0.45534,
                    b: 0.353698,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.061989,
                    g: 0.537281,
                    b: 0.428748,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.158491,
                    g: 0.620396,
                    b: 0.505902,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.858134,
                    g: 0.612944,
                    b: 0.614994,
                    a: 1,
                },
                {
                    r: 0.680048,
                    g: 0.306472,
                    b: 0.307497,
                    a: 1,
                },
                {
                    r: 0.501961,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.370394,
                    g: 0,
                    b: 0,
                    a: 1,
                },
                {
                    r: 0.238826,
                    g: 0,
                    b: 0,
                    a: 1,
                },
            ],
        },
        {
            name: "mediumaquamarine",
            hexRGBString: "#66cdaa",
            hexRGBAString: "#66cdaaff",
            hexARGBString: "#ff66cdaa",
            webRGBString: "rgb(102,205,170)",
            webRGBAString: "rgba(102,205,170,1)",
            lum: 0.493898,
            temp: 40000,
            rgba: {
                r: 0.4,
                g: 0.803922,
                b: 0.666667,
                a: 1,
            },
            hsl: {
                h: 159.611658,
                s: 0.50739,
                l: 0.601961,
            },
            hsv: {
                h: 159.611658,
                s: 0.502439,
                v: 0.803922,
            },
            xyz: {
                x: 0.345633,
                y: 0.493868,
                z: 0.457337,
            },
            lab: {
                l: 75.691336,
                a: -38.335672,
                b: 8.307995,
            },
            lch: {
                l: 75.691336,
                c: 39.225585,
                h: 167.772119,
            },
            lchToLabResult: {
                l: 75.691336,
                a: -38.335672,
                b: 8.307994,
            },
            labToLCHResult: {
                l: 75.691336,
                c: 39.225585,
                h: 167.772118,
            },
            labToXYZResult: {
                x: 0.345633,
                y: 0.493868,
                z: 0.457337,
            },
            xyzToLABResult: {
                l: 75.691333,
                a: -38.335737,
                b: 8.307956,
            },
            rgbToXYZResult: {
                x: 0.345633,
                y: 0.493868,
                z: 0.457337,
            },
            xyzToRGBResult: {
                r: 0.399999,
                g: 0.803922,
                b: 0.666667,
                a: 1,
            },
            rgbToLABResult: {
                l: 75.691336,
                a: -38.335672,
                b: 8.307995,
            },
            labToRGBResult: {
                r: 0.4,
                g: 0.803922,
                b: 0.666667,
                a: 1,
            },
            rgbToLCHResult: {
                l: 75.691336,
                c: 39.225585,
                h: 167.772119,
            },
            lchToRGBResult: {
                r: 0.4,
                g: 0.803922,
                b: 0.666667,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.4,
                    g: 0.803922,
                    b: 0.666667,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.294936,
                    g: 0.815635,
                    b: 0.653909,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.108656,
                    g: 0.826642,
                    b: 0.64113,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.584052,
                    g: 0.83699,
                    b: 0.628326,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.281381,
                    g: 0.84672,
                    b: 0.615494,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.945249,
                    g: 0.855869,
                    b: 0.602631,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -2.576452,
                    g: 0.864471,
                    b: 0.589731,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -3.175784,
                    g: 0.872556,
                    b: 0.576791,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.4,
                    g: 0.803922,
                    b: 0.666667,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.482067,
                    g: 0.791453,
                    b: 0.679406,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.552281,
                    g: 0.77817,
                    b: 0.69213,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.615109,
                    g: 0.764006,
                    b: 0.70484,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.67285,
                    g: 0.748887,
                    b: 0.717538,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.726864,
                    g: 0.732725,
                    b: 0.730228,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.731304,
                    g: 0.731304,
                    b: 0.731304,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.731304,
                    g: 0.731304,
                    b: 0.731304,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.4,
                    g: 0.803922,
                    b: 0.666667,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.312378,
                    g: 0.719546,
                    b: 0.58625,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.220081,
                    g: 0.636797,
                    b: 0.50779,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.110199,
                    g: 0.555765,
                    b: 0.431443,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.081893,
                    g: 0.476554,
                    b: 0.357397,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.208115,
                    g: 0.399275,
                    b: 0.285886,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.25057,
                    g: 0.324056,
                    b: 0.217205,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.232057,
                    g: 0.251032,
                    b: 0.151737,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.4,
                    g: 0.803922,
                    b: 0.666667,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.48624,
                    g: 0.889843,
                    b: 0.748907,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.572379,
                    g: 0.977235,
                    b: 0.832859,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.659011,
                    g: 1.066032,
                    b: 0.918422,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.746435,
                    g: 1.156174,
                    b: 1.005513,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.834809,
                    g: 1.247605,
                    b: 1.094053,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.924213,
                    g: 1.340276,
                    b: 1.183977,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.014686,
                    g: 1.434141,
                    b: 1.275222,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.724278,
                    g: 0.940154,
                    b: 0.869104,
                    a: 1,
                },
                {
                    r: 0.562139,
                    g: 0.872038,
                    b: 0.767885,
                    a: 1,
                },
                {
                    r: 0.4,
                    g: 0.803922,
                    b: 0.666667,
                    a: 1,
                },
                {
                    r: 0.2,
                    g: 0.597475,
                    b: 0.459633,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.391027,
                    b: 0.252599,
                    a: 1,
                },
            ],
        },
        {
            name: "mediumblue",
            hexRGBString: "#0000cd",
            hexRGBAString: "#0000cdff",
            hexARGBString: "#ff0000cd",
            webRGBString: "rgb(0,0,205)",
            webRGBAString: "rgba(0,0,205,1)",
            lum: 0.044078,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0,
                b: 0.803922,
                a: 1,
            },
            hsl: {
                h: 240,
                s: 1,
                l: 0.401961,
            },
            hsv: {
                h: 240,
                s: 1,
                v: 0.803922,
            },
            xyz: {
                x: 0.110156,
                y: 0.044063,
                z: 0.580157,
            },
            lab: {
                l: 24.971444,
                a: 67.176559,
                b: -91.500208,
            },
            lch: {
                l: 24.971444,
                c: 113.512018,
                h: 306.284938,
            },
            lchToLabResult: {
                l: 24.971444,
                a: 67.176559,
                b: -91.500208,
            },
            labToLCHResult: {
                l: 24.971444,
                c: 113.512018,
                h: 306.284938,
            },
            labToXYZResult: {
                x: 0.110156,
                y: 0.044063,
                z: 0.580157,
            },
            xyzToLABResult: {
                l: 24.971577,
                a: 67.175671,
                b: -91.499965,
            },
            rgbToXYZResult: {
                x: 0.110156,
                y: 0.044063,
                z: 0.580157,
            },
            xyzToRGBResult: {
                r: -0.000025,
                g: 0.000016,
                b: 0.803922,
                a: 1,
            },
            rgbToLABResult: {
                l: 24.971444,
                a: 67.176559,
                b: -91.500208,
            },
            labToRGBResult: {
                r: 0,
                g: 0,
                b: 0.803922,
                a: 1,
            },
            rgbToLCHResult: {
                l: 24.971444,
                c: 113.512018,
                h: 306.284938,
            },
            lchToRGBResult: {
                r: 0,
                g: 0,
                b: 0.803922,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.182649,
                    g: -0.041733,
                    b: 0.845674,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.389654,
                    g: -0.083568,
                    b: 0.887783,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.622098,
                    g: -0.125455,
                    b: 0.930243,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.881064,
                    g: -0.167343,
                    b: 0.973046,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.167635,
                    g: -0.20918,
                    b: 1.016187,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.482894,
                    g: -0.250916,
                    b: 1.059658,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.827924,
                    g: -0.2925,
                    b: 1.103454,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.114007,
                    g: 0.041551,
                    b: 0.762534,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.163915,
                    g: 0.073747,
                    b: 0.721516,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.196217,
                    g: 0.09726,
                    b: 0.680875,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.219106,
                    g: 0.116414,
                    b: 0.640617,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.23571,
                    g: 0.132824,
                    b: 0.600746,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.247619,
                    g: 0.147297,
                    b: 0.561267,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.255768,
                    g: 0.160304,
                    b: 0.522181,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.388184,
                    g: -0.076354,
                    b: 0.717692,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.62135,
                    g: -0.089753,
                    b: 0.633031,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.690398,
                    g: -0.10193,
                    b: 0.550386,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.571258,
                    g: -0.192885,
                    b: 0.470721,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.380412,
                    g: -0.327159,
                    b: 0.394521,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.273131,
                    g: -0.455638,
                    b: 0.322357,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.242464,
                    g: -0.577731,
                    b: 0.255525,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.803922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.231572,
                    g: 0.115207,
                    b: 0.89162,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.354438,
                    g: 0.201251,
                    b: 0.980704,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.461084,
                    g: 0.281937,
                    b: 1.071109,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.561513,
                    g: 0.361811,
                    b: 1.162776,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.659122,
                    g: 0.442218,
                    b: 1.255655,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.755454,
                    g: 0.523667,
                    b: 1.3497,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.851324,
                    g: 0.606371,
                    b: 1.444871,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.619607,
                    g: 0.625956,
                    b: 0.968611,
                    a: 1,
                },
                {
                    r: 0.309804,
                    g: 0.312978,
                    b: 0.886267,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.803922,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.632272,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.460623,
                    a: 1,
                },
            ],
        },
        {
            name: "mediumorchid",
            hexRGBString: "#ba55d3",
            hexRGBAString: "#ba55d3ff",
            hexARGBString: "#ffba55d3",
            webRGBString: "rgb(186,85,211)",
            webRGBAString: "rgba(186,85,211,1)",
            lum: 0.216392,
            temp: 8032,
            rgba: {
                r: 0.729412,
                g: 0.333333,
                b: 0.827451,
                a: 1,
            },
            hsl: {
                h: 288.095273,
                s: 0.588785,
                l: 0.580392,
            },
            hsv: {
                h: 288.095273,
                s: 0.597157,
                v: 0.827451,
            },
            xyz: {
                x: 0.352546,
                y: 0.216408,
                z: 0.639354,
            },
            lab: {
                l: 53.643754,
                a: 59.06046,
                b: -47.402341,
            },
            lch: {
                l: 53.643754,
                c: 75.730574,
                h: 321.249227,
            },
            lchToLabResult: {
                l: 53.643754,
                a: 59.06046,
                b: -47.402341,
            },
            labToLCHResult: {
                l: 53.643754,
                c: 75.730574,
                h: 321.249227,
            },
            labToXYZResult: {
                x: 0.352546,
                y: 0.216408,
                z: 0.639354,
            },
            xyzToLABResult: {
                l: 53.643795,
                a: 59.060419,
                b: -47.402235,
            },
            rgbToXYZResult: {
                x: 0.352546,
                y: 0.216408,
                z: 0.639354,
            },
            xyzToRGBResult: {
                r: 0.729413,
                g: 0.333334,
                b: 0.827451,
                a: 1,
            },
            rgbToLABResult: {
                l: 53.643754,
                a: 59.06046,
                b: -47.402341,
            },
            labToRGBResult: {
                r: 0.729412,
                g: 0.333333,
                b: 0.827451,
                a: 1,
            },
            rgbToLCHResult: {
                l: 53.643754,
                c: 75.730574,
                h: 321.249227,
            },
            lchToRGBResult: {
                r: 0.729412,
                g: 0.333333,
                b: 0.827451,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.729412,
                    g: 0.333333,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.749029,
                    g: 0.305022,
                    b: 0.861077,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.768196,
                    g: 0.272176,
                    b: 0.894843,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.786943,
                    g: 0.232681,
                    b: 0.928755,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.805293,
                    g: 0.18197,
                    b: 0.962815,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.823268,
                    g: 0.105163,
                    b: 0.997027,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.840889,
                    g: -0.084603,
                    b: 1.031392,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.858173,
                    g: -0.315463,
                    b: 1.065912,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.729412,
                    g: 0.333333,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.709312,
                    g: 0.358293,
                    b: 0.79396,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.688693,
                    g: 0.380642,
                    b: 0.760597,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.667508,
                    g: 0.400878,
                    b: 0.727353,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.645708,
                    g: 0.419357,
                    b: 0.694215,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.62323,
                    g: 0.436343,
                    b: 0.66117,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.600001,
                    g: 0.452038,
                    b: 0.6282,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.575932,
                    g: 0.4666,
                    b: 0.595282,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.729412,
                    g: 0.333333,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.643011,
                    g: 0.249949,
                    b: 0.742531,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.557842,
                    g: 0.161833,
                    b: 0.659217,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.473863,
                    g: 0.048588,
                    b: 0.577603,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.390963,
                    g: -0.087585,
                    b: 0.497796,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.308886,
                    g: -0.143393,
                    b: 0.419926,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.227102,
                    g: -0.141454,
                    b: 0.344158,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.162334,
                    g: -0.172207,
                    b: 0.272005,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.729412,
                    g: 0.333333,
                    b: 0.827451,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.817054,
                    g: 0.415723,
                    b: 0.913894,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.905925,
                    g: 0.4984,
                    b: 1.001786,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.996007,
                    g: 0.5819,
                    b: 1.091063,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.087273,
                    g: 0.66647,
                    b: 1.181664,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.179696,
                    g: 0.752221,
                    b: 1.273538,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.273245,
                    g: 0.8392,
                    b: 1.366634,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.367892,
                    g: 0.927415,
                    b: 1.460908,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.920435,
                    g: 0.741229,
                    b: 0.966368,
                    a: 1,
                },
                {
                    r: 0.824924,
                    g: 0.537281,
                    b: 0.896909,
                    a: 1,
                },
                {
                    r: 0.729412,
                    g: 0.333333,
                    b: 0.827451,
                    a: 1,
                },
                {
                    r: 0.545513,
                    g: 0.174595,
                    b: 0.640463,
                    a: 1,
                },
                {
                    r: 0.361614,
                    g: 0.015857,
                    b: 0.453474,
                    a: 1,
                },
            ],
        },
        {
            name: "mediumpurple",
            hexRGBString: "#9370db",
            hexRGBAString: "#9370dbff",
            hexARGBString: "#ff9370db",
            webRGBString: "rgb(147,112,219)",
            webRGBAString: "rgba(147,112,219,1)",
            lum: 0.229059,
            temp: 18360,
            rgba: {
                r: 0.576471,
                g: 0.439216,
                b: 0.858824,
                a: 1,
            },
            hsl: {
                h: 259.626175,
                s: 0.597766,
                l: 0.64902,
            },
            hsv: {
                h: 259.626175,
                s: 0.488584,
                v: 0.858824,
            },
            xyz: {
                x: 0.306098,
                y: 0.229055,
                z: 0.698127,
            },
            lab: {
                l: 54.974838,
                a: 36.797772,
                b: -50.089478,
            },
            lch: {
                l: 54.974838,
                c: 62.153293,
                h: 306.30252,
            },
            lchToLabResult: {
                l: 54.974838,
                a: 36.797772,
                b: -50.089478,
            },
            labToLCHResult: {
                l: 54.974838,
                c: 62.153293,
                h: 306.30252,
            },
            labToXYZResult: {
                x: 0.306098,
                y: 0.229055,
                z: 0.698127,
            },
            xyzToLABResult: {
                l: 54.974866,
                a: 36.797469,
                b: -50.089435,
            },
            rgbToXYZResult: {
                x: 0.306098,
                y: 0.229055,
                z: 0.698127,
            },
            xyzToRGBResult: {
                r: 0.576469,
                g: 0.439217,
                b: 0.858824,
                a: 1,
            },
            rgbToLABResult: {
                l: 54.974838,
                a: 36.797772,
                b: -50.089478,
            },
            labToRGBResult: {
                r: 0.576471,
                g: 0.439216,
                b: 0.858824,
                a: 1,
            },
            rgbToLCHResult: {
                l: 54.974838,
                c: 62.153293,
                h: 306.30252,
            },
            lchToRGBResult: {
                r: 0.576471,
                g: 0.439216,
                b: 0.858824,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.576471,
                    g: 0.439216,
                    b: 0.858824,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.577528,
                    g: 0.427891,
                    b: 0.902213,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.577018,
                    g: 0.416065,
                    b: 0.945846,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.574859,
                    g: 0.403693,
                    b: 0.989729,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.570951,
                    g: 0.390719,
                    b: 1.033866,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.565171,
                    g: 0.377081,
                    b: 1.078262,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.557364,
                    g: 0.362699,
                    b: 1.122917,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.547341,
                    g: 0.347475,
                    b: 1.167832,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.576471,
                    g: 0.439216,
                    b: 0.858824,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.573911,
                    g: 0.450078,
                    b: 0.815669,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.5699,
                    g: 0.460509,
                    b: 0.772736,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.564475,
                    g: 0.470539,
                    b: 0.730008,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.557662,
                    g: 0.480193,
                    b: 0.687462,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.549476,
                    g: 0.489491,
                    b: 0.645068,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.53992,
                    g: 0.498453,
                    b: 0.602784,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.528984,
                    g: 0.507096,
                    b: 0.560556,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.576471,
                    g: 0.439216,
                    b: 0.858824,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.492787,
                    g: 0.363376,
                    b: 0.773321,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.409964,
                    g: 0.289623,
                    b: 0.689392,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.327509,
                    g: 0.217987,
                    b: 0.607128,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.244244,
                    g: 0.14828,
                    b: 0.526632,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.156712,
                    g: 0.079406,
                    b: 0.448027,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.045972,
                    g: 0.012108,
                    b: 0.371465,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.036217,
                    g: -0.063943,
                    b: 0.297998,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.576471,
                    g: 0.439216,
                    b: 0.858824,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.661239,
                    g: 0.517052,
                    b: 0.945822,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.747191,
                    g: 0.596781,
                    b: 1.034244,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.834367,
                    g: 0.678301,
                    b: 1.124028,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.922773,
                    g: 0.761517,
                    b: 1.215116,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.012399,
                    g: 0.846341,
                    b: 1.307457,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.103225,
                    g: 0.932695,
                    b: 1.401003,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.195224,
                    g: 1.020506,
                    b: 1.495711,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.849564,
                    g: 0.785359,
                    b: 0.986462,
                    a: 1,
                },
                {
                    r: 0.713017,
                    g: 0.612287,
                    b: 0.922643,
                    a: 1,
                },
                {
                    r: 0.576471,
                    g: 0.439216,
                    b: 0.858824,
                    a: 1,
                },
                {
                    r: 0.393557,
                    g: 0.274074,
                    b: 0.675353,
                    a: 1,
                },
                {
                    r: 0.210643,
                    g: 0.108933,
                    b: 0.491882,
                    a: 1,
                },
            ],
        },
        {
            name: "mediumseagreen",
            hexRGBString: "#3cb371",
            hexRGBAString: "#3cb371ff",
            hexARGBString: "#ff3cb371",
            webRGBString: "rgb(60,179,113)",
            webRGBAString: "rgba(60,179,113,1)",
            lum: 0.343931,
            temp: 40000,
            rgba: {
                r: 0.235294,
                g: 0.701961,
                b: 0.443137,
                a: 1,
            },
            hsl: {
                h: 146.722652,
                s: 0.497908,
                l: 0.468628,
            },
            hsv: {
                h: 146.722652,
                s: 0.664805,
                v: 0.701961,
            },
            xyz: {
                x: 0.209624,
                y: 0.343909,
                z: 0.211529,
            },
            lab: {
                l: 65.271662,
                a: -48.21823,
                b: 24.290237,
            },
            lch: {
                l: 65.271662,
                c: 53.990863,
                h: 153.263032,
            },
            lchToLabResult: {
                l: 65.271662,
                a: -48.21823,
                b: 24.290237,
            },
            labToLCHResult: {
                l: 65.271662,
                c: 53.990863,
                h: 153.263032,
            },
            labToXYZResult: {
                x: 0.209624,
                y: 0.343909,
                z: 0.211529,
            },
            xyzToLABResult: {
                l: 65.271667,
                a: -48.218087,
                b: 24.290306,
            },
            rgbToXYZResult: {
                x: 0.209624,
                y: 0.343909,
                z: 0.211529,
            },
            xyzToRGBResult: {
                r: 0.235297,
                g: 0.701961,
                b: 0.443137,
                a: 1,
            },
            rgbToLABResult: {
                l: 65.271662,
                a: -48.21823,
                b: 24.290237,
            },
            labToRGBResult: {
                r: 0.235294,
                g: 0.701961,
                b: 0.443137,
                a: 1,
            },
            rgbToLCHResult: {
                l: 65.271662,
                c: 53.990863,
                h: 153.263032,
            },
            lchToRGBResult: {
                r: 0.235294,
                g: 0.701961,
                b: 0.443137,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.235294,
                    g: 0.701961,
                    b: 0.443137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.092934,
                    g: 0.710857,
                    b: 0.416662,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.332608,
                    g: 0.719223,
                    b: 0.389702,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.761753,
                    g: 0.727089,
                    b: 0.362121,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.172063,
                    g: 0.734484,
                    b: 0.333734,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.563943,
                    g: 0.741436,
                    b: 0.30428,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -1.937797,
                    g: 0.747968,
                    b: 0.273377,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -2.29403,
                    g: 0.754102,
                    b: 0.240426,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.235294,
                    g: 0.701961,
                    b: 0.443137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.318928,
                    g: 0.692498,
                    b: 0.46923,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.38459,
                    g: 0.682429,
                    b: 0.495022,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.440824,
                    g: 0.671711,
                    b: 0.520575,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.491125,
                    g: 0.660292,
                    b: 0.54594,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.537311,
                    g: 0.648117,
                    b: 0.571156,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.580466,
                    g: 0.635121,
                    b: 0.596259,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.621245,
                    g: 0.621245,
                    b: 0.621245,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.235294,
                    g: 0.701961,
                    b: 0.443137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.121435,
                    g: 0.619051,
                    b: 0.367634,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.092218,
                    g: 0.537817,
                    b: 0.294318,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.245772,
                    g: 0.458346,
                    b: 0.223278,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.306755,
                    g: 0.380735,
                    b: 0.154471,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.297966,
                    g: 0.305083,
                    b: 0.087258,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.239298,
                    g: 0.231439,
                    b: 0.014219,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.232455,
                    g: 0.168598,
                    b: -0.080566,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.235294,
                    g: 0.701961,
                    b: 0.443137,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.330311,
                    g: 0.786463,
                    b: 0.520703,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.420036,
                    g: 0.872484,
                    b: 0.600209,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.508006,
                    g: 0.959953,
                    b: 0.681542,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.595621,
                    g: 1.04881,
                    b: 0.764598,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.683544,
                    g: 1.138996,
                    b: 0.849284,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.772119,
                    g: 1.23046,
                    b: 0.935516,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.861531,
                    g: 1.323153,
                    b: 1.02322,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.671693,
                    g: 0.900879,
                    b: 0.776562,
                    a: 1,
                },
                {
                    r: 0.453493,
                    g: 0.80142,
                    b: 0.609849,
                    a: 1,
                },
                {
                    r: 0.235294,
                    g: 0.701961,
                    b: 0.443137,
                    a: 1,
                },
                {
                    r: 0.117647,
                    g: 0.511089,
                    b: 0.260013,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.320216,
                    b: 0.076888,
                    a: 1,
                },
            ],
        },
        {
            name: "mediumslateblue",
            hexRGBString: "#7b68ee",
            hexRGBAString: "#7b68eeff",
            hexARGBString: "#ff7b68ee",
            webRGBString: "rgb(123,104,238)",
            webRGBAString: "rgba(123,104,238,1)",
            lum: 0.202846,
            temp: 40000,
            rgba: {
                r: 0.482353,
                g: 0.407843,
                b: 0.933333,
                a: 1,
            },
            hsl: {
                h: 248.507488,
                s: 0.797618,
                l: 0.670588,
            },
            hsv: {
                h: 248.507488,
                s: 0.563025,
                v: 0.933333,
            },
            xyz: {
                x: 0.285467,
                y: 0.202833,
                z: 0.832832,
            },
            lab: {
                l: 52.155975,
                a: 41.068385,
                b: -65.396163,
            },
            lch: {
                l: 52.155975,
                c: 77.222214,
                h: 302.128566,
            },
            lchToLabResult: {
                l: 52.155975,
                a: 41.068385,
                b: -65.396163,
            },
            labToLCHResult: {
                l: 52.155975,
                c: 77.222214,
                h: 302.128566,
            },
            labToXYZResult: {
                x: 0.285467,
                y: 0.202833,
                z: 0.832832,
            },
            xyzToLABResult: {
                l: 52.156016,
                a: 41.068057,
                b: -65.396113,
            },
            rgbToXYZResult: {
                x: 0.285467,
                y: 0.202833,
                z: 0.832832,
            },
            xyzToRGBResult: {
                r: 0.482351,
                g: 0.407845,
                b: 0.933333,
                a: 1,
            },
            rgbToLABResult: {
                l: 52.155975,
                a: 41.068385,
                b: -65.396163,
            },
            labToRGBResult: {
                r: 0.482353,
                g: 0.407843,
                b: 0.933333,
                a: 1,
            },
            rgbToLCHResult: {
                l: 52.155975,
                c: 77.222214,
                h: 302.128566,
            },
            lchToRGBResult: {
                r: 0.482353,
                g: 0.407843,
                b: 0.933333,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.482353,
                    g: 0.407843,
                    b: 0.933333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.46892,
                    g: 0.398728,
                    b: 0.979202,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.451997,
                    g: 0.389381,
                    b: 1.025367,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.430939,
                    g: 0.379794,
                    b: 1.071828,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.404807,
                    g: 0.369957,
                    b: 1.118587,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.372142,
                    g: 0.359857,
                    b: 1.165644,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.330437,
                    g: 0.349481,
                    b: 1.212997,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.274652,
                    g: 0.338812,
                    b: 1.260645,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.482353,
                    g: 0.407843,
                    b: 0.933333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.49276,
                    g: 0.416735,
                    b: 0.887755,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.500486,
                    g: 0.42541,
                    b: 0.842463,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.505793,
                    g: 0.433876,
                    b: 0.797448,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.508887,
                    g: 0.442136,
                    b: 0.752698,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.509927,
                    g: 0.450196,
                    b: 0.708195,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.509038,
                    g: 0.458061,
                    b: 0.663916,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.506316,
                    g: 0.465733,
                    b: 0.619828,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.482353,
                    g: 0.407843,
                    b: 0.933333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.392153,
                    g: 0.333256,
                    b: 0.846017,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.298766,
                    g: 0.260963,
                    b: 0.76017,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.196055,
                    g: 0.191102,
                    b: 0.67587,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.04437,
                    g: 0.123715,
                    b: 0.593208,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.186783,
                    g: 0.058333,
                    b: 0.512295,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.300769,
                    g: 0.00157,
                    b: 0.433324,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.255849,
                    g: -0.097807,
                    b: 0.357617,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.482353,
                    g: 0.407843,
                    b: 0.933333,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.571508,
                    g: 0.484575,
                    b: 1.022049,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.660577,
                    g: 0.563311,
                    b: 1.112104,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.750048,
                    g: 0.643925,
                    b: 1.203442,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.840186,
                    g: 0.726306,
                    b: 1.296014,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.93114,
                    g: 0.810354,
                    b: 1.389775,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.022997,
                    g: 0.895981,
                    b: 1.484682,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.115801,
                    g: 0.983109,
                    b: 1.580696,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.807014,
                    g: 0.775605,
                    b: 1,
                    a: 1,
                },
                {
                    r: 0.644683,
                    g: 0.591724,
                    b: 0.966667,
                    a: 1,
                },
                {
                    r: 0.482353,
                    g: 0.407843,
                    b: 0.933333,
                    a: 1,
                },
                {
                    r: 0.291787,
                    g: 0.256252,
                    b: 0.736008,
                    a: 1,
                },
                {
                    r: 0.101221,
                    g: 0.104662,
                    b: 0.538683,
                    a: 1,
                },
            ],
        },
        {
            name: "mediumspringgreen",
            hexRGBString: "#00fa9a",
            hexRGBAString: "#00fa9aff",
            hexARGBString: "#ff00fa9a",
            webRGBString: "rgb(0,250,154)",
            webRGBAString: "rgba(0,250,154,1)",
            lum: 0.707043,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0.980392,
                b: 0.603922,
                a: 1,
            },
            hsl: {
                h: 156.960032,
                s: 1,
                l: 0.490196,
            },
            hsv: {
                h: 156.960032,
                s: 1,
                v: 0.980392,
            },
            xyz: {
                x: 0.40014,
                y: 0.706989,
                z: 0.421029,
            },
            lab: {
                l: 87.338518,
                a: -70.686434,
                b: 32.462768,
            },
            lch: {
                l: 87.338518,
                c: 77.784338,
                h: 155.333031,
            },
            lchToLabResult: {
                l: 87.338518,
                a: -70.686434,
                b: 32.462768,
            },
            labToLCHResult: {
                l: 87.338518,
                c: 77.784338,
                h: 155.333031,
            },
            labToXYZResult: {
                x: 0.40014,
                y: 0.706989,
                z: 0.421029,
            },
            xyzToLABResult: {
                l: 87.338513,
                a: -70.686521,
                b: 32.462775,
            },
            rgbToXYZResult: {
                x: 0.40014,
                y: 0.706989,
                z: 0.421029,
            },
            xyzToRGBResult: {
                r: -0.000011,
                g: 0.980392,
                b: 0.603922,
                a: 1,
            },
            rgbToLABResult: {
                l: 87.338518,
                a: -70.686434,
                b: 32.462768,
            },
            labToRGBResult: {
                r: 0.000001,
                g: 0.980392,
                b: 0.603922,
                a: 1,
            },
            rgbToLCHResult: {
                l: 87.338518,
                c: 77.784338,
                h: 155.333031,
            },
            lchToRGBResult: {
                r: 0.000001,
                g: 0.980392,
                b: 0.603922,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.980392,
                    b: 0.603922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.746887,
                    g: 0.989465,
                    b: 0.577631,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -1.467025,
                    g: 0.998098,
                    b: 0.550977,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -2.160896,
                    g: 1.006313,
                    b: 0.523888,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -2.828981,
                    g: 1.01413,
                    b: 0.496276,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -3.471763,
                    g: 1.021565,
                    b: 0.468026,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -4.089725,
                    g: 1.028636,
                    b: 0.438993,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -4.68335,
                    g: 1.035357,
                    b: 0.40898,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.980392,
                    b: 0.603922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.27151,
                    g: 0.970858,
                    b: 0.629909,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.384073,
                    g: 0.960838,
                    b: 0.655641,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.46872,
                    g: 0.950306,
                    b: 0.681157,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.539741,
                    g: 0.939232,
                    b: 0.706491,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.602444,
                    g: 0.927585,
                    b: 0.731672,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.659469,
                    g: 0.91533,
                    b: 0.756724,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.712345,
                    g: 0.902427,
                    b: 0.781668,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.980392,
                    b: 0.603922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.483009,
                    g: 0.891424,
                    b: 0.523634,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.802474,
                    g: 0.803783,
                    b: 0.445126,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.981195,
                    g: 0.717517,
                    b: 0.368448,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -1.041969,
                    g: 0.632677,
                    b: 0.293594,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -1.007598,
                    g: 0.549313,
                    b: 0.220396,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.900881,
                    g: 0.467476,
                    b: 0.148178,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.744617,
                    g: 0.387211,
                    b: 0.074054,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.000001,
                    g: 0.980392,
                    b: 0.603922,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.252315,
                    g: 1.070641,
                    b: 0.685919,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.380793,
                    g: 1.162127,
                    b: 0.769552,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.490939,
                    g: 1.254808,
                    b: 0.854746,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.593849,
                    g: 1.348646,
                    b: 0.941432,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.693339,
                    g: 1.443604,
                    b: 1.029545,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.79116,
                    g: 1.539648,
                    b: 1.119027,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.888248,
                    g: 1.636745,
                    b: 1.209821,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.56554,
                    g: 1,
                    b: 0.841675,
                    a: 1,
                },
                {
                    r: 0.28277,
                    g: 0.990196,
                    b: 0.722799,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.980392,
                    b: 0.603922,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.736859,
                    b: 0.392334,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.493326,
                    b: 0.180746,
                    a: 1,
                },
            ],
        },
        {
            name: "mediumturquoise",
            hexRGBString: "#48d1cc",
            hexRGBAString: "#48d1ccff",
            hexARGBString: "#ff48d1cc",
            webRGBString: "rgb(72,209,204)",
            webRGBAString: "rgba(72,209,204,1)",
            lum: 0.513383,
            temp: 40000,
            rgba: {
                r: 0.282353,
                g: 0.819608,
                b: 0.8,
                a: 1,
            },
            hsl: {
                h: 177.810202,
                s: 0.598254,
                l: 0.550981,
            },
            hsv: {
                h: 177.810202,
                s: 0.655502,
                v: 0.819608,
            },
            xyz: {
                x: 0.363671,
                y: 0.513342,
                z: 0.651069,
            },
            lab: {
                l: 76.881017,
                a: -37.360203,
                b: -8.354779,
            },
            lch: {
                l: 76.881017,
                c: 38.282987,
                h: 192.605527,
            },
            lchToLabResult: {
                l: 76.881017,
                a: -37.360203,
                b: -8.354779,
            },
            labToLCHResult: {
                l: 76.881017,
                c: 38.282987,
                h: 192.605527,
            },
            labToXYZResult: {
                x: 0.363671,
                y: 0.513342,
                z: 0.651069,
            },
            xyzToLABResult: {
                l: 76.881008,
                a: -37.360209,
                b: -8.354796,
            },
            rgbToXYZResult: {
                x: 0.363671,
                y: 0.513342,
                z: 0.651069,
            },
            xyzToRGBResult: {
                r: 0.282353,
                g: 0.819608,
                b: 0.8,
                a: 1,
            },
            rgbToLABResult: {
                l: 76.881017,
                a: -37.360203,
                b: -8.354779,
            },
            labToRGBResult: {
                r: 0.282353,
                g: 0.819608,
                b: 0.8,
                a: 1,
            },
            rgbToLCHResult: {
                l: 76.881017,
                c: 38.282987,
                h: 192.605527,
            },
            lchToRGBResult: {
                r: 0.282353,
                g: 0.819608,
                b: 0.8,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.282353,
                    g: 0.819608,
                    b: 0.8,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.217528,
                    g: 0.832226,
                    b: 0.81146,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -1.236371,
                    g: 0.844116,
                    b: 0.822977,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -2.220111,
                    g: 0.855329,
                    b: 0.834549,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -3.169589,
                    g: 0.865906,
                    b: 0.846174,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -4.085643,
                    g: 0.875888,
                    b: 0.85785,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -4.969115,
                    g: 0.885311,
                    b: 0.869573,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -5.820843,
                    g: 0.894206,
                    b: 0.881343,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.282353,
                    g: 0.819608,
                    b: 0.8,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.422638,
                    g: 0.806209,
                    b: 0.7886,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.523753,
                    g: 0.791965,
                    b: 0.777264,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.607242,
                    g: 0.776808,
                    b: 0.765993,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.680328,
                    g: 0.760655,
                    b: 0.754791,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.744077,
                    g: 0.744077,
                    b: 0.744077,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.744077,
                    g: 0.744077,
                    b: 0.744077,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.744077,
                    g: 0.744077,
                    b: 0.744077,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.282353,
                    g: 0.819608,
                    b: 0.8,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.157612,
                    g: 0.734943,
                    b: 0.716791,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.119254,
                    g: 0.651888,
                    b: 0.635347,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.372755,
                    g: 0.570534,
                    b: 0.555791,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.506818,
                    g: 0.490981,
                    b: 0.478268,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.544242,
                    g: 0.413339,
                    b: 0.402953,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.507827,
                    g: 0.337733,
                    b: 0.330058,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.420373,
                    g: 0.264298,
                    b: 0.259854,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.282353,
                    g: 0.819608,
                    b: 0.8,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.385222,
                    g: 0.905804,
                    b: 0.884867,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.481132,
                    g: 0.993459,
                    b: 0.971302,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.57424,
                    g: 1.082508,
                    b: 1.059221,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.666271,
                    g: 1.17289,
                    b: 1.148555,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.758077,
                    g: 1.264553,
                    b: 1.239239,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.850123,
                    g: 1.357447,
                    b: 1.331214,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.94268,
                    g: 1.451527,
                    b: 1.424429,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.664836,
                    g: 0.946181,
                    b: 0.937462,
                    a: 1,
                },
                {
                    r: 0.473594,
                    g: 0.882895,
                    b: 0.868731,
                    a: 1,
                },
                {
                    r: 0.282353,
                    g: 0.819608,
                    b: 0.8,
                    a: 1,
                },
                {
                    r: 0.141177,
                    g: 0.610951,
                    b: 0.595925,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.402295,
                    b: 0.39185,
                    a: 1,
                },
            ],
        },
        {
            name: "mediumvioletred",
            hexRGBString: "#c71585",
            hexRGBAString: "#c71585ff",
            hexARGBString: "#ffc71585",
            webRGBString: "rgb(199,21,133)",
            webRGBAString: "rgba(199,21,133,1)",
            lum: 0.143719,
            temp: 4151,
            rgba: {
                r: 0.780392,
                g: 0.082353,
                b: 0.521569,
                a: 1,
            },
            hsl: {
                h: 322.247152,
                s: 0.809091,
                l: 0.431373,
            },
            hsv: {
                h: 322.247152,
                s: 0.894472,
                v: 0.780392,
            },
            xyz: {
                x: 0.280567,
                y: 0.143754,
                z: 0.234831,
            },
            lab: {
                l: 44.766612,
                a: 70.992114,
                b: -15.169288,
            },
            lch: {
                l: 44.766612,
                c: 72.59468,
                h: 347.938666,
            },
            lchToLabResult: {
                l: 44.766612,
                a: 70.992114,
                b: -15.169287,
            },
            labToLCHResult: {
                l: 44.766612,
                c: 72.59468,
                h: 347.938665,
            },
            labToXYZResult: {
                x: 0.280567,
                y: 0.143754,
                z: 0.234831,
            },
            xyzToLABResult: {
                l: 44.766558,
                a: 70.992251,
                b: -15.169447,
            },
            rgbToXYZResult: {
                x: 0.280567,
                y: 0.143754,
                z: 0.234831,
            },
            xyzToRGBResult: {
                r: 0.780392,
                g: 0.08235,
                b: 0.521569,
                a: 1,
            },
            rgbToLABResult: {
                l: 44.766612,
                a: 70.992114,
                b: -15.169288,
            },
            labToRGBResult: {
                r: 0.780392,
                g: 0.082354,
                b: 0.521569,
                a: 1,
            },
            rgbToLCHResult: {
                l: 44.766612,
                c: 72.59468,
                h: 347.938666,
            },
            lchToRGBResult: {
                r: 0.780392,
                g: 0.082354,
                b: 0.521569,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.780392,
                    g: 0.082354,
                    b: 0.521569,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.814996,
                    g: -0.142264,
                    b: 0.532915,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.849267,
                    g: -0.392349,
                    b: 0.544275,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.88326,
                    g: -0.653609,
                    b: 0.555651,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.917023,
                    g: -0.926287,
                    b: 0.567042,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.950593,
                    g: -1.210628,
                    b: 0.57845,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.984004,
                    g: -1.506874,
                    b: 0.589876,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.017284,
                    g: -1.815269,
                    b: 0.601321,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.780392,
                    g: 0.082354,
                    b: 0.521569,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.745388,
                    g: 0.172531,
                    b: 0.510235,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.709902,
                    g: 0.226741,
                    b: 0.498913,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.673832,
                    g: 0.267445,
                    b: 0.4876,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.63705,
                    g: 0.300438,
                    b: 0.476295,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.599392,
                    g: 0.328258,
                    b: 0.464996,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.56064,
                    g: 0.352286,
                    b: 0.453701,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.520504,
                    g: 0.373369,
                    b: 0.442408,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.780392,
                    g: 0.082354,
                    b: 0.521569,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.689887,
                    g: -0.155118,
                    b: 0.444681,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.60036,
                    g: -0.293996,
                    b: 0.370036,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.511767,
                    g: -0.342546,
                    b: 0.297851,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.424035,
                    g: -0.323567,
                    b: 0.2284,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.337441,
                    g: -0.263409,
                    b: 0.162164,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.264128,
                    g: -0.262149,
                    b: 0.103808,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.222773,
                    g: -0.343399,
                    b: 0.025254,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.780392,
                    g: 0.082354,
                    b: 0.521569,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.871896,
                    g: 0.21367,
                    b: 0.600521,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.964406,
                    g: 0.31299,
                    b: 0.681389,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.057921,
                    g: 0.404716,
                    b: 0.764047,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.152434,
                    g: 0.493829,
                    b: 0.848387,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.247933,
                    g: 0.582169,
                    b: 0.934315,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.344404,
                    g: 0.67058,
                    b: 1.021748,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.441831,
                    g: 0.759496,
                    b: 1.110613,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.951376,
                    g: 0.642622,
                    b: 0.839473,
                    a: 1,
                },
                {
                    r: 0.865884,
                    g: 0.362488,
                    b: 0.680521,
                    a: 1,
                },
                {
                    r: 0.780392,
                    g: 0.082353,
                    b: 0.521569,
                    a: 1,
                },
                {
                    r: 0.602104,
                    g: 0.041177,
                    b: 0.364523,
                    a: 1,
                },
                {
                    r: 0.423817,
                    g: 0,
                    b: 0.207476,
                    a: 1,
                },
            ],
        },
        {
            name: "midnightblue",
            hexRGBString: "#191970",
            hexRGBAString: "#191970ff",
            hexARGBString: "#ff191970",
            webRGBString: "rgb(25,25,112)",
            webRGBAString: "rgba(25,25,112,1)",
            lum: 0.020718,
            temp: 40000,
            rgba: {
                r: 0.098039,
                g: 0.098039,
                b: 0.439216,
                a: 1,
            },
            hsl: {
                h: 240,
                s: 0.635037,
                l: 0.268628,
            },
            hsv: {
                h: 240,
                s: 0.776786,
                v: 0.439216,
            },
            xyz: {
                x: 0.036722,
                y: 0.020714,
                z: 0.155324,
            },
            lab: {
                l: 15.857594,
                a: 31.713401,
                b: -49.574697,
            },
            lch: {
                l: 15.857594,
                c: 58.850577,
                h: 302.60743,
            },
            lchToLabResult: {
                l: 15.857594,
                a: 31.713401,
                b: -49.574698,
            },
            labToLCHResult: {
                l: 15.857594,
                c: 58.850577,
                h: 302.607431,
            },
            labToXYZResult: {
                x: 0.036722,
                y: 0.020714,
                z: 0.155324,
            },
            xyzToLABResult: {
                l: 15.85757,
                a: 31.713738,
                b: -49.574727,
            },
            rgbToXYZResult: {
                x: 0.036722,
                y: 0.020714,
                z: 0.155324,
            },
            xyzToRGBResult: {
                r: 0.098043,
                g: 0.098037,
                b: 0.439216,
                a: 1,
            },
            rgbToLABResult: {
                l: 15.857594,
                a: 31.713401,
                b: -49.574697,
            },
            labToRGBResult: {
                r: 0.098039,
                g: 0.098039,
                b: 0.439216,
                a: 1,
            },
            rgbToLCHResult: {
                l: 15.857594,
                c: 58.850577,
                h: 302.60743,
            },
            lchToRGBResult: {
                r: 0.098039,
                g: 0.098039,
                b: 0.439216,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.098039,
                    g: 0.098039,
                    b: 0.439216,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.043253,
                    g: 0.088361,
                    b: 0.478597,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.057818,
                    g: 0.077883,
                    b: 0.518485,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.179239,
                    g: 0.066396,
                    b: 0.558868,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.322212,
                    g: 0.053556,
                    b: 0.599736,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.488042,
                    g: 0.038715,
                    b: 0.641076,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.678036,
                    g: 0.023009,
                    b: 0.682877,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.893499,
                    g: 0.008044,
                    b: 0.725126,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.098039,
                    g: 0.098039,
                    b: 0.439216,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.126929,
                    g: 0.107053,
                    b: 0.40035,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.14491,
                    g: 0.115495,
                    b: 0.362004,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.156086,
                    g: 0.123434,
                    b: 0.324176,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.162284,
                    g: 0.130918,
                    b: 0.286856,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.164487,
                    g: 0.137983,
                    b: 0.250013,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.163268,
                    g: 0.144658,
                    b: 0.213583,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.158959,
                    g: 0.150963,
                    b: 0.177437,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.098039,
                    g: 0.098039,
                    b: 0.439216,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.047173,
                    g: 0.035603,
                    b: 0.362962,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.080838,
                    g: -0.056545,
                    b: 0.289995,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.072977,
                    g: -0.176737,
                    b: 0.222181,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.125226,
                    g: -0.291918,
                    b: 0.161563,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.223999,
                    g: -0.40322,
                    b: 0.111655,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.334338,
                    g: -0.513559,
                    b: 0.043638,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.444677,
                    g: -0.623898,
                    b: -0.06657,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.098039,
                    g: 0.098039,
                    b: 0.439216,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.196401,
                    g: 0.162988,
                    b: 0.517538,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.282635,
                    g: 0.230787,
                    b: 0.597771,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.366046,
                    g: 0.3013,
                    b: 0.679791,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.449039,
                    g: 0.37432,
                    b: 0.76349,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.532526,
                    g: 0.449651,
                    b: 0.848776,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.616908,
                    g: 0.527118,
                    b: 0.935569,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.702374,
                    g: 0.606572,
                    b: 1.023798,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.659803,
                    g: 0.662731,
                    b: 0.834108,
                    a: 1,
                },
                {
                    r: 0.378921,
                    g: 0.380385,
                    b: 0.636662,
                    a: 1,
                },
                {
                    r: 0.098039,
                    g: 0.098039,
                    b: 0.439216,
                    a: 1,
                },
                {
                    r: 0.04902,
                    g: 0.057869,
                    b: 0.340618,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0.0177,
                    b: 0.24202,
                    a: 1,
                },
            ],
        },
        {
            name: "mintcream",
            hexRGBString: "#f5fffa",
            hexRGBAString: "#f5fffaff",
            hexARGBString: "#fff5fffa",
            webRGBString: "rgb(245,255,250)",
            webRGBAString: "rgba(245,255,250,1)",
            lum: 0.978346,
            temp: 6811,
            rgba: {
                r: 0.960784,
                g: 1,
                b: 0.980392,
                a: 1,
            },
            hsl: {
                h: 150,
                s: 1,
                l: 0.980392,
            },
            hsv: {
                h: 150,
                s: 0.039216,
                v: 1,
            },
            xyz: {
                x: 0.906683,
                y: 0.978341,
                z: 1.045311,
            },
            lab: {
                l: 99.156389,
                a: -4.162971,
                b: 1.246392,
            },
            lch: {
                l: 99.156389,
                c: 4.345552,
                h: 163.332325,
            },
            lchToLabResult: {
                l: 99.156389,
                a: -4.162971,
                b: 1.246392,
            },
            labToLCHResult: {
                l: 99.156389,
                c: 4.345552,
                h: 163.332319,
            },
            labToXYZResult: {
                x: 0.906683,
                y: 0.978341,
                z: 1.045311,
            },
            xyzToLABResult: {
                l: 99.156399,
                a: -4.162939,
                b: 1.246397,
            },
            rgbToXYZResult: {
                x: 0.906683,
                y: 0.978341,
                z: 1.045311,
            },
            xyzToRGBResult: {
                r: 0.960784,
                g: 1,
                b: 0.980392,
                a: 1,
            },
            rgbToLABResult: {
                l: 99.156389,
                a: -4.162971,
                b: 1.246392,
            },
            labToRGBResult: {
                r: 0.960784,
                g: 1,
                b: 0.980392,
                a: 1,
            },
            rgbToLCHResult: {
                l: 99.156389,
                c: 4.345552,
                h: 163.332325,
            },
            lchToRGBResult: {
                r: 0.960784,
                g: 1,
                b: 0.980392,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.960784,
                    g: 1,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.906367,
                    g: 1.016329,
                    b: 0.962576,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.849181,
                    g: 1.031836,
                    b: 0.944736,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.788511,
                    g: 1.046576,
                    b: 0.926866,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.723321,
                    g: 1.060596,
                    b: 0.908964,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.652011,
                    g: 1.07394,
                    b: 0.891025,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.571885,
                    g: 1.086646,
                    b: 0.873044,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.477735,
                    g: 1.09875,
                    b: 0.855016,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.960784,
                    g: 1,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.990418,
                    g: 0.990418,
                    b: 0.990418,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.990418,
                    g: 0.990418,
                    b: 0.990418,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.990418,
                    g: 0.990418,
                    b: 0.990418,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.990418,
                    g: 0.990418,
                    b: 0.990418,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.990418,
                    g: 0.990418,
                    b: 0.990418,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.990418,
                    g: 0.990418,
                    b: 0.990418,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.990418,
                    g: 0.990418,
                    b: 0.990418,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0.960784,
                    g: 1,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.874474,
                    g: 0.913031,
                    b: 0.89377,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.789735,
                    g: 0.827597,
                    b: 0.808702,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.706659,
                    g: 0.743785,
                    b: 0.725279,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.625351,
                    g: 0.661695,
                    b: 0.643605,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.545935,
                    g: 0.581444,
                    b: 0.563799,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.468555,
                    g: 0.503166,
                    b: 0.486004,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.393385,
                    g: 0.427024,
                    b: 0.410388,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0.960784,
                    g: 1,
                    b: 0.980392,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.048583,
                    g: 1.088427,
                    b: 1.06849,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.137799,
                    g: 1.178243,
                    b: 1.157992,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.228368,
                    g: 1.269387,
                    b: 1.248836,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.320233,
                    g: 1.361802,
                    b: 1.340964,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.413339,
                    g: 1.455439,
                    b: 1.434325,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.507641,
                    g: 1.550252,
                    b: 1.528872,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.603093,
                    g: 1.646197,
                    b: 1.624562,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.94174,
                    g: 1,
                    b: 0.97835,
                    a: 1,
                },
                {
                    r: 0.951262,
                    g: 1,
                    b: 0.979371,
                    a: 1,
                },
                {
                    r: 0.960784,
                    g: 1,
                    b: 0.980392,
                    a: 1,
                },
                {
                    r: 0.652627,
                    g: 0.757685,
                    b: 0.713376,
                    a: 1,
                },
                {
                    r: 0.344469,
                    g: 0.515369,
                    b: 0.446359,
                    a: 1,
                },
            ],
        },
        {
            name: "mistyrose",
            hexRGBString: "#ffe4e1",
            hexRGBAString: "#ffe4e1ff",
            hexARGBString: "#ffffe4e1",
            webRGBString: "rgb(255,228,225)",
            webRGBAString: "rgba(255,228,225,1)",
            lum: 0.821831,
            temp: 5565,
            rgba: {
                r: 1,
                g: 0.894118,
                b: 0.882353,
                a: 1,
            },
            hsl: {
                h: 6.000153,
                s: 1,
                l: 0.941177,
            },
            hsv: {
                h: 6.000153,
                s: 0.117647,
                v: 1,
            },
            xyz: {
                x: 0.825731,
                y: 0.821848,
                z: 0.82733,
            },
            lab: {
                l: 92.65636,
                a: 8.747038,
                b: 4.835742,
            },
            lch: {
                l: 92.65636,
                c: 9.994753,
                h: 28.935721,
            },
            lchToLabResult: {
                l: 92.65636,
                a: 8.747039,
                b: 4.835742,
            },
            labToLCHResult: {
                l: 92.65636,
                c: 9.994752,
                h: 28.935721,
            },
            labToXYZResult: {
                x: 0.825731,
                y: 0.821848,
                z: 0.82733,
            },
            xyzToLABResult: {
                l: 92.656361,
                a: 8.747002,
                b: 4.835742,
            },
            rgbToXYZResult: {
                x: 0.825731,
                y: 0.821848,
                z: 0.82733,
            },
            xyzToRGBResult: {
                r: 1,
                g: 0.894118,
                b: 0.882353,
                a: 1,
            },
            rgbToLABResult: {
                l: 92.65636,
                a: 8.747038,
                b: 4.835742,
            },
            labToRGBResult: {
                r: 1,
                g: 0.894118,
                b: 0.882353,
                a: 1,
            },
            rgbToLCHResult: {
                l: 92.65636,
                c: 9.994753,
                h: 28.935721,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.894118,
                b: 0.882353,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.882353,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.059198,
                    g: 0.875237,
                    b: 0.855575,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.115146,
                    g: 0.855322,
                    b: 0.828889,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.168405,
                    g: 0.834272,
                    b: 0.802297,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.219405,
                    g: 0.811968,
                    b: 0.7758,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.26848,
                    g: 0.788266,
                    b: 0.749397,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.315897,
                    g: 0.762996,
                    b: 0.723089,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.361872,
                    g: 0.735946,
                    b: 0.696878,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.882353,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.936787,
                    g: 0.912053,
                    b: 0.909224,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.917185,
                    g: 0.917185,
                    b: 0.917185,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.917185,
                    g: 0.917185,
                    b: 0.917185,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.917185,
                    g: 0.917185,
                    b: 0.917185,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.917185,
                    g: 0.917185,
                    b: 0.917185,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.917185,
                    g: 0.917185,
                    b: 0.917185,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.917185,
                    g: 0.917185,
                    b: 0.917185,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.882353,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.912715,
                    g: 0.808983,
                    b: 0.797496,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.826931,
                    g: 0.725485,
                    b: 0.714297,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.742729,
                    g: 0.643725,
                    b: 0.63286,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.660199,
                    g: 0.563821,
                    b: 0.55331,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.579447,
                    g: 0.48591,
                    b: 0.47579,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.50059,
                    g: 0.410155,
                    b: 0.400473,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.423768,
                    g: 0.336755,
                    b: 0.327573,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.882353,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.088714,
                    g: 0.980801,
                    b: 0.968776,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.178794,
                    g: 1.068954,
                    b: 1.056683,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.27018,
                    g: 1.158506,
                    b: 1.146005,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.362819,
                    g: 1.249396,
                    b: 1.236675,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.456665,
                    g: 1.341567,
                    b: 1.328637,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.551672,
                    g: 1.434967,
                    b: 1.421838,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.6478,
                    g: 1.529551,
                    b: 1.516231,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.945968,
                    b: 0.934467,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.920043,
                    b: 0.90841,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.894118,
                    b: 0.882353,
                    a: 1,
                },
                {
                    r: 0.791664,
                    g: 0.639349,
                    b: 0.625502,
                    a: 1,
                },
                {
                    r: 0.583328,
                    g: 0.384579,
                    b: 0.368651,
                    a: 1,
                },
            ],
        },
        {
            name: "moccasin",
            hexRGBString: "#ffe4b5",
            hexRGBAString: "#ffe4b5ff",
            hexARGBString: "#ffffe4b5",
            webRGBString: "rgb(255,228,181)",
            webRGBAString: "rgba(255,228,181,1)",
            lum: 0.800831,
            temp: 4393,
            rgba: {
                r: 1,
                g: 0.894118,
                b: 0.709804,
                a: 1,
            },
            hsl: {
                h: 38.108175,
                s: 1,
                l: 0.854902,
            },
            hsv: {
                h: 38.108175,
                s: 0.290196,
                v: 1,
            },
            xyz: {
                x: 0.773248,
                y: 0.800855,
                z: 0.55092,
            },
            lab: {
                l: 91.7232,
                a: 2.439304,
                b: 26.359853,
            },
            lch: {
                l: 91.7232,
                c: 26.472477,
                h: 84.712987,
            },
            lchToLabResult: {
                l: 91.7232,
                a: 2.439303,
                b: 26.359853,
            },
            labToLCHResult: {
                l: 91.7232,
                c: 26.472477,
                h: 84.712986,
            },
            labToXYZResult: {
                x: 0.773248,
                y: 0.800855,
                z: 0.55092,
            },
            xyzToLABResult: {
                l: 91.72321,
                a: 2.439226,
                b: 26.359828,
            },
            rgbToXYZResult: {
                x: 0.773248,
                y: 0.800855,
                z: 0.55092,
            },
            xyzToRGBResult: {
                r: 0.999999,
                g: 0.894118,
                b: 0.709804,
                a: 1,
            },
            rgbToLABResult: {
                l: 91.7232,
                a: 2.439304,
                b: 26.359853,
            },
            labToRGBResult: {
                r: 1,
                g: 0.894118,
                b: 0.709804,
                a: 1,
            },
            rgbToLCHResult: {
                l: 91.7232,
                c: 26.472477,
                h: 84.712987,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.894118,
                b: 0.709804,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.709804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.021366,
                    g: 0.890754,
                    b: 0.651537,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.04065,
                    g: 0.887525,
                    b: 0.592399,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.058076,
                    g: 0.884423,
                    b: 0.531918,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.073833,
                    g: 0.881443,
                    b: 0.469353,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.088089,
                    g: 0.878579,
                    b: 0.403449,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.100991,
                    g: 0.875825,
                    b: 0.331823,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.11267,
                    g: 0.873172,
                    b: 0.24897,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.709804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.976291,
                    g: 0.897622,
                    b: 0.767516,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.949924,
                    g: 0.901271,
                    b: 0.824894,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.920512,
                    g: 0.905071,
                    b: 0.882095,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.90676,
                    g: 0.90676,
                    b: 0.90676,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.90676,
                    g: 0.90676,
                    b: 0.90676,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.90676,
                    g: 0.90676,
                    b: 0.90676,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.90676,
                    g: 0.90676,
                    b: 0.90676,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.709804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.911774,
                    g: 0.809109,
                    b: 0.62797,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.824958,
                    g: 0.725751,
                    b: 0.547944,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.739618,
                    g: 0.644151,
                    b: 0.469842,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.655825,
                    g: 0.56443,
                    b: 0.393795,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.573655,
                    g: 0.486734,
                    b: 0.319942,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.493195,
                    g: 0.411234,
                    b: 0.248424,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.414537,
                    g: 0.338143,
                    b: 0.179328,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.894118,
                    b: 0.709804,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.089578,
                    g: 0.980688,
                    b: 0.793341,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.180455,
                    g: 1.068738,
                    b: 0.878489,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.272579,
                    g: 1.158198,
                    b: 0.965166,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.365907,
                    g: 1.249002,
                    b: 1.053297,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.460395,
                    g: 1.341093,
                    b: 1.142818,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.556004,
                    g: 1.434421,
                    b: 1.233667,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.652699,
                    g: 1.528936,
                    b: 1.32579,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.958421,
                    b: 0.845091,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.926269,
                    b: 0.777447,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.894118,
                    b: 0.709804,
                    a: 1,
                },
                {
                    r: 0.75987,
                    g: 0.657671,
                    b: 0.441667,
                    a: 1,
                },
                {
                    r: 0.51974,
                    g: 0.421224,
                    b: 0.17353,
                    a: 1,
                },
            ],
        },
        {
            name: "navajowhite",
            hexRGBString: "#ffdead",
            hexRGBAString: "#ffdeadff",
            hexARGBString: "#ffffdead",
            webRGBString: "rgb(255,222,173)",
            webRGBAString: "rgba(255,222,173,1)",
            lum: 0.765196,
            temp: 4208,
            rgba: {
                r: 1,
                g: 0.870588,
                b: 0.678431,
                a: 1,
            },
            hsl: {
                h: 35.853643,
                s: 1,
                l: 0.839216,
            },
            hsv: {
                h: 35.853643,
                s: 0.321569,
                v: 1,
            },
            xyz: {
                x: 0.749054,
                y: 0.765224,
                z: 0.503516,
            },
            lab: {
                l: 90.101336,
                a: 4.51015,
                b: 28.272215,
            },
            lch: {
                l: 90.101336,
                c: 28.629698,
                h: 80.936212,
            },
            lchToLabResult: {
                l: 90.101336,
                a: 4.51015,
                b: 28.272215,
            },
            labToLCHResult: {
                l: 90.101336,
                c: 28.629698,
                h: 80.936212,
            },
            labToXYZResult: {
                x: 0.749054,
                y: 0.765224,
                z: 0.503516,
            },
            xyzToLABResult: {
                l: 90.101335,
                a: 4.510236,
                b: 28.272249,
            },
            rgbToXYZResult: {
                x: 0.749054,
                y: 0.765224,
                z: 0.503516,
            },
            xyzToRGBResult: {
                r: 1.000001,
                g: 0.870588,
                b: 0.678431,
                a: 1,
            },
            rgbToLABResult: {
                l: 90.101336,
                a: 4.51015,
                b: 28.272215,
            },
            labToRGBResult: {
                r: 1,
                g: 0.870588,
                b: 0.678431,
                a: 1,
            },
            rgbToLCHResult: {
                l: 90.101336,
                c: 28.629698,
                h: 80.936212,
            },
            lchToRGBResult: {
                r: 1,
                g: 0.870588,
                b: 0.678431,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.870588,
                    b: 0.678431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.02359,
                    g: 0.865985,
                    b: 0.620798,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.045082,
                    g: 0.861488,
                    b: 0.562216,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.064711,
                    g: 0.857092,
                    b: 0.502164,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.082679,
                    g: 0.85279,
                    b: 0.439802,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.099162,
                    g: 0.848576,
                    b: 0.37367,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.114312,
                    g: 0.844444,
                    b: 0.30086,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.128268,
                    g: 0.840387,
                    b: 0.213996,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.870588,
                    b: 0.678431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.974032,
                    g: 0.875303,
                    b: 0.735459,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.945346,
                    g: 0.880136,
                    b: 0.792121,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.913524,
                    g: 0.885092,
                    b: 0.848585,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.888694,
                    g: 0.888694,
                    b: 0.888694,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.888694,
                    g: 0.888694,
                    b: 0.888694,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.888694,
                    g: 0.888694,
                    b: 0.888694,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.888694,
                    g: 0.888694,
                    b: 0.888694,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.870588,
                    b: 0.678431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.911463,
                    g: 0.786017,
                    b: 0.597199,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.824309,
                    g: 0.703125,
                    b: 0.517804,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.738598,
                    g: 0.62202,
                    b: 0.440361,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.654395,
                    g: 0.542831,
                    b: 0.364998,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.57177,
                    g: 0.465707,
                    b: 0.291841,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.4908,
                    g: 0.390832,
                    b: 0.220989,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.411567,
                    g: 0.318429,
                    b: 0.152412,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 1,
                    g: 0.870588,
                    b: 0.678431,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.089865,
                    g: 0.956743,
                    b: 0.761394,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.181006,
                    g: 1.044398,
                    b: 0.845993,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.273378,
                    g: 1.133481,
                    b: 0.932146,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.366936,
                    g: 1.223925,
                    b: 1.019775,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.46164,
                    g: 1.315672,
                    b: 1.108812,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.557452,
                    g: 1.408668,
                    b: 1.199198,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.654338,
                    g: 1.502864,
                    b: 1.290874,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 1,
                    g: 0.948792,
                    b: 0.833836,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.90969,
                    b: 0.756133,
                    a: 1,
                },
                {
                    r: 1,
                    g: 0.870588,
                    b: 0.678431,
                    a: 1,
                },
                {
                    r: 0.761905,
                    g: 0.637351,
                    b: 0.414267,
                    a: 1,
                },
                {
                    r: 0.52381,
                    g: 0.404115,
                    b: 0.150103,
                    a: 1,
                },
            ],
        },
        {
            name: "navy",
            hexRGBString: "#000080",
            hexRGBAString: "#000080ff",
            hexARGBString: "#ff000080",
            webRGBString: "rgb(0,0,128)",
            webRGBAString: "rgba(0,0,128,1)",
            lum: 0.015585,
            temp: 40000,
            rgba: {
                r: 0,
                g: 0,
                b: 0.501961,
                a: 1,
            },
            hsl: {
                h: 240,
                s: 1,
                l: 0.250981,
            },
            hsv: {
                h: 240,
                s: 1,
                v: 0.501961,
            },
            xyz: {
                x: 0.038949,
                y: 0.01558,
                z: 0.205133,
            },
            lab: {
                l: 12.971976,
                a: 47.502296,
                b: -64.702182,
            },
            lch: {
                l: 12.971976,
                c: 80.267307,
                h: 306.284938,
            },
            lchToLabResult: {
                l: 12.971976,
                a: 47.502296,
                b: -64.702183,
            },
            labToLCHResult: {
                l: 12.971976,
                c: 80.267306,
                h: 306.284938,
            },
            labToXYZResult: {
                x: 0.038949,
                y: 0.01558,
                z: 0.205133,
            },
            xyzToLABResult: {
                l: 12.972133,
                a: 47.501079,
                b: -64.701853,
            },
            rgbToXYZResult: {
                x: 0.038949,
                y: 0.01558,
                z: 0.205133,
            },
            xyzToRGBResult: {
                r: -0.000018,
                g: 0.000011,
                b: 0.501961,
                a: 1,
            },
            rgbToLABResult: {
                l: 12.971976,
                a: 47.502296,
                b: -64.702182,
            },
            labToRGBResult: {
                r: 0,
                g: 0,
                b: 0.501961,
                a: 1,
            },
            rgbToLCHResult: {
                l: 12.971976,
                c: 80.267307,
                h: 306.284938,
            },
            lchToRGBResult: {
                r: 0,
                g: 0,
                b: 0.501961,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.09383,
                    g: -0.020879,
                    b: 0.540316,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.205199,
                    g: -0.041816,
                    b: 0.579131,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.335192,
                    g: -0.062759,
                    b: 0.618393,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.48489,
                    g: -0.083659,
                    b: 0.65809,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.655378,
                    g: -0.104462,
                    b: 0.698211,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.847737,
                    g: -0.12512,
                    b: 0.738744,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -1.063051,
                    g: -0.145579,
                    b: 0.779679,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.070066,
                    g: 0.02077,
                    b: 0.464078,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.104821,
                    g: 0.041359,
                    b: 0.426678,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.125678,
                    g: 0.058871,
                    b: 0.389774,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.138879,
                    g: 0.073075,
                    b: 0.353373,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.146808,
                    g: 0.085179,
                    b: 0.317482,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.150663,
                    g: 0.095784,
                    b: 0.282099,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.151124,
                    g: 0.105238,
                    b: 0.247211,
                    a: 1,
                },
            ],
            darkenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: -0.170963,
                    g: -0.039287,
                    b: 0.423271,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: -0.166622,
                    g: -0.129052,
                    b: 0.347996,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: -0.105139,
                    g: -0.253586,
                    b: 0.277199,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: -0.112624,
                    g: -0.372498,
                    b: 0.212187,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: -0.177289,
                    g: -0.486644,
                    b: 0.155919,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: -0.282365,
                    g: -0.597422,
                    b: 0.109666,
                    a: 1,
                },
                {
                    factor: 3,
                    r: -0.392703,
                    g: -0.70776,
                    b: 0.03939,
                    a: 1,
                },
            ],
            lightenViaLAB: [
                {
                    factor: 0,
                    r: 0,
                    g: 0,
                    b: 0.501961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.165982,
                    g: 0.079323,
                    b: 0.582647,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 0.268161,
                    g: 0.15458,
                    b: 0.665095,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 0.360241,
                    g: 0.227873,
                    b: 0.749193,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 0.449142,
                    g: 0.302013,
                    b: 0.834848,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 0.537102,
                    g: 0.377694,
                    b: 0.92198,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 0.625082,
                    g: 0.455104,
                    b: 1.01052,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 0.713559,
                    g: 0.534267,
                    b: 1.100406,
                    a: 1,
                },
            ],
            palette: [
                {
                    r: 0.62213,
                    g: 0.626306,
                    b: 0.856861,
                    a: 1,
                },
                {
                    r: 0.311065,
                    g: 0.313153,
                    b: 0.679411,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.501961,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.38619,
                    a: 1,
                },
                {
                    r: 0,
                    g: 0,
                    b: 0.27042,
                    a: 1,
                },
            ],
        },
        {
            name: "oldlace",
            hexRGBString: "#fdf5e6",
            hexRGBAString: "#fdf5e6ff",
            hexARGBString: "#fffdf5e6",
            webRGBString: "rgb(253,245,230)",
            webRGBAString: "rgba(253,245,230,1)",
            lum: 0.919006,
            temp: 5771,
            rgba: {
                r: 0.992157,
                g: 0.960784,
                b: 0.901961,
                a: 1,
            },
            hsl: {
                h: 39.130117,
                s: 0.851854,
                l: 0.947059,
            },
            hsv: {
                h: 39.130117,
                s: 0.090909,
                v: 0.992157,
            },
            xyz: {
                x: 0.874418,
                y: 0.919014,
                z: 0.879799,
            },
            lab: {
                l: 96.77999,
                a: 0.171017,
                b: 8.166173,
            },
            lch: {
                l: 96.77999,
                c: 8.167964,
                h: 88.800279,
            },
            lchToLabResult: {
                l: 96.77999,
                a: 0.171017,
                b: 8.166173,
            },
            labToLCHResult: {
                l: 96.77999,
                c: 8.167964,
                h: 88.80028,
            },
            labToXYZResult: {
                x: 0.874418,
                y: 0.919014,
                z: 0.879799,
            },
            xyzToLABResult: {
                l: 96.779985,
                a: 0.17112,
                b: 8.16615,
            },
            rgbToXYZResult: {
                x: 0.874418,
                y: 0.919014,
                z: 0.879799,
            },
            xyzToRGBResult: {
                r: 0.992158,
                g: 0.960784,
                b: 0.901961,
                a: 1,
            },
            rgbToLABResult: {
                l: 96.77999,
                a: 0.171017,
                b: 8.166173,
            },
            labToRGBResult: {
                r: 0.992157,
                g: 0.960784,
                b: 0.901961,
                a: 1,
            },
            rgbToLCHResult: {
                l: 96.77999,
                c: 8.167964,
                h: 88.800279,
            },
            lchToRGBResult: {
                r: 0.992157,
                g: 0.960784,
                b: 0.901961,
                a: 1,
            },
            saturateViaLCH: [
                {
                    factor: 0,
                    r: 0.992157,
                    g: 0.960784,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 1.016234,
                    g: 0.958369,
                    b: 0.843682,
                    a: 1,
                },
                {
                    factor: 0.857143,
                    r: 1.03777,
                    g: 0.956115,
                    b: 0.785135,
                    a: 1,
                },
                {
                    factor: 1.285714,
                    r: 1.05704,
                    g: 0.954014,
                    b: 0.726138,
                    a: 1,
                },
                {
                    factor: 1.714286,
                    r: 1.074277,
                    g: 0.952061,
                    b: 0.666439,
                    a: 1,
                },
                {
                    factor: 2.142857,
                    r: 1.08968,
                    g: 0.950251,
                    b: 0.605677,
                    a: 1,
                },
                {
                    factor: 2.571429,
                    r: 1.10342,
                    g: 0.948576,
                    b: 0.54331,
                    a: 1,
                },
                {
                    factor: 3,
                    r: 1.115649,
                    g: 0.947031,
                    b: 0.478475,
                    a: 1,
                },
            ],
            desaturateViaLCH: [
                {
                    factor: 0,
                    r: 0.992157,
                    g: 0.960784,
                    b: 0.901961,
                    a: 1,
                },
                {
                    factor: 0.428571,
                    r: 0.965204,
                    g: 0.963364,
                    b: 0.960104,
                    a: 1,
                },
      