/*
 * nghttp3
 *
 * Copyright (c) 2020 nghttp3 contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "nghttp3_conv_test.h"

#include <assert.h>

#include <CUnit/CUnit.h>

#include "nghttp3_conv.h"
#include "nghttp3_test_helper.h"

void test_nghttp3_pri_to_uint8(void) {
  {
    nghttp3_pri pri = {1, 0};
    CU_ASSERT(1 == nghttp3_pri_to_uint8(&pri));
  }
  {
    nghttp3_pri pri = {1, 1};
    CU_ASSERT((0x80 | 1) == nghttp3_pri_to_uint8(&pri));
  }
  {
    nghttp3_pri pri = {7, 1};
    CU_ASSERT((0x80 | 7) == nghttp3_pri_to_uint8(&pri));
  }
  {
    nghttp3_pri pri = {7, 0};
    CU_ASSERT(7 == nghttp3_pri_to_uint8(&pri));
  }
}
