/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 639 language definitions, lookup functions

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// -----------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso639_list" rake target.
// -----------------------------------------------------------------------

#include "common/iso639_types.h"

using namespace std::string_literals;

namespace mtx::iso639 {

std::vector<language_t> g_languages;

struct language_init_t {
  char const *english_name, *alpha_3_code, *alpha_2_code, *terminology_abbrev;
  bool is_part_of_iso639_2, is_deprecated;
};

static language_init_t const s_languages_init[] = {
  { u8"'Are'are",                                                   "alu",     "",   "",    false, false },
  { u8"'Auhelawa",                                                  "kud",     "",   "",    false, false },
  { u8"A'ou",                                                       "aou",     "",   "",    false, false },
  { u8"A-Pucikwar",                                                 "apq",     "",   "",    false, false },
  { u8"Aari",                                                       "aiw",     "",   "",    false, false },
  { u8"Aasáx",                                                      "aas",     "",   "",    false, false },
  { u8"Abadi",                                                      "kbt",     "",   "",    false, false },
  { u8"Abaga",                                                      "abg",     "",   "",    false, false },
  { u8"Abai Sungai",                                                "abf",     "",   "",    false, false },
  { u8"Abanyom",                                                    "abm",     "",   "",    false, false },
  { u8"Abar",                                                       "mij",     "",   "",    false, false },
  { u8"Abau",                                                       "aau",     "",   "",    false, false },
  { u8"Abaza",                                                      "abq",     "",   "",    false, false },
  { u8"Abellen Ayta",                                               "abp",     "",   "",    false, false },
  { u8"Abidji",                                                     "abi",     "",   "",    false, false },
  { u8"Abinomn",                                                    "bsa",     "",   "",    false, false },
  { u8"Abipon",                                                     "axb",     "",   "",    false, false },
  { u8"Abishira",                                                   "ash",     "",   "",    false, false },
  { u8"Abkhazian",                                                  "abk",     "ab", "",    true,  false },
  { u8"Abom",                                                       "aob",     "",   "",    false, false },
  { u8"Abon",                                                       "abo",     "",   "",    false, false },
  { u8"Abron",                                                      "abr",     "",   "",    false, false },
  { u8"Abu",                                                        "ado",     "",   "",    false, false },
  { u8"Abu' Arapesh",                                               "aah",     "",   "",    false, false },
  { u8"Abua",                                                       "abn",     "",   "",    false, false },
  { u8"Abui",                                                       "abz",     "",   "",    false, false },
  { u8"Abun",                                                       "kgr",     "",   "",    false, false },
  { u8"Abure",                                                      "abu",     "",   "",    false, false },
  { u8"Abureni",                                                    "mgj",     "",   "",    false, false },
  { u8"Abé",                                                        "aba",     "",   "",    false, false },
  { u8"Acatepec Me'phaa",                                           "tpx",     "",   "",    false, false },
  { u8"Achagua",                                                    "aca",     "",   "",    false, false },
  { u8"Achang",                                                     "acn",     "",   "",    false, false },
  { u8"Ache",                                                       "yif",     "",   "",    false, false },
  { u8"Acheron",                                                    "acz",     "",   "",    false, false },
  { u8"Achi",                                                       "acr",     "",   "",    false, false },
  { u8"Achinese",                                                   "ace",     "",   "",    true,  false },
  { u8"Achterhoeks",                                                "act",     "",   "",    false, false },
  { u8"Achuar-Shiwiar",                                             "acu",     "",   "",    false, false },
  { u8"Achumawi",                                                   "acv",     "",   "",    false, false },
  { u8"Aché",                                                       "guq",     "",   "",    false, false },
  { u8"Acoli",                                                      "ach",     "",   "",    true,  false },
  { u8"Acroá",                                                      "acs",     "",   "",    false, false },
  { u8"Adai",                                                       "xad",     "",   "",    false, false },
  { u8"Adamawa Fulfulde",                                           "fub",     "",   "",    false, false },
  { u8"Adamorobe Sign Language",                                    "ads",     "",   "",    false, false },
  { u8"Adang",                                                      "adn",     "",   "",    false, false },
  { u8"Adangbe",                                                    "adq",     "",   "",    false, false },
  { u8"Adangme",                                                    "ada",     "",   "",    true,  false },
  { u8"Adap",                                                       "adp",     "",   "",    false, true  },
  { u8"Adara",                                                      "kad",     "",   "",    false, false },
  { u8"Adasen",                                                     "tiu",     "",   "",    false, false },
  { u8"Adele",                                                      "ade",     "",   "",    false, false },
  { u8"Adhola",                                                     "adh",     "",   "",    false, false },
  { u8"Adi",                                                        "adi",     "",   "",    false, false },
  { u8"Adilabad Gondi",                                             "wsg",     "",   "",    false, false },
  { u8"Adioukrou",                                                  "adj",     "",   "",    false, false },
  { u8"Adithinngithigh",                                            "dth",     "",   "",    false, false },
  { u8"Adivasi Oriya",                                              "ort",     "",   "",    false, false },
  { u8"Adiwasi Garasia",                                            "gas",     "",   "",    false, false },
  { u8"Adnyamathanha",                                              "adt",     "",   "",    false, false },
  { u8"Adonara",                                                    "adr",     "",   "",    false, false },
  { u8"Aduge",                                                      "adu",     "",   "",    false, false },
  { u8"Adyghe",                                                     "ady",     "",   "",    true,  false },
  { u8"Adzera",                                                     "adz",     "",   "",    false, false },
  { u8"Aeka",                                                       "aez",     "",   "",    false, false },
  { u8"Aekyom",                                                     "awi",     "",   "",    false, false },
  { u8"Aequian",                                                    "xae",     "",   "",    false, false },
  { u8"Aer",                                                        "aeq",     "",   "",    false, false },
  { u8"Afade",                                                      "aal",     "",   "",    false, false },
  { u8"Afar",                                                       "aar",     "aa", "",    true,  false },
  { u8"Afghan Sign Language",                                       "afg",     "",   "",    false, false },
  { u8"Afitti",                                                     "aft",     "",   "",    false, false },
  { u8"Afrihili",                                                   "afh",     "",   "",    true,  false },
  { u8"Afrikaans",                                                  "afr",     "af", "",    true,  false },
  { u8"Afro-Asiatic languages",                                     "afa",     "",   "",    true,  false },
  { u8"Afro-Seminole Creole",                                       "afs",     "",   "",    false, false },
  { u8"Agarabi",                                                    "agd",     "",   "",    false, false },
  { u8"Agariya",                                                    "agi",     "",   "",    false, false },
  { u8"Agatu",                                                      "agc",     "",   "",    false, false },
  { u8"Agavotaguerra",                                              "avo",     "",   "",    false, false },
  { u8"Aghem",                                                      "agq",     "",   "",    false, false },
  { u8"Aghu Tharnggalu",                                            "ggr",     "",   "",    false, true  },
  { u8"Aghu",                                                       "ahh",     "",   "",    false, false },
  { u8"Aghu-Tharnggala",                                            "gtu",     "",   "",    false, false },
  { u8"Aghul",                                                      "agx",     "",   "",    false, false },
  { u8"Aghwan",                                                     "xag",     "",   "",    false, false },
  { u8"Agi",                                                        "aif",     "",   "",    false, false },
  { u8"Agob",                                                       "kit",     "",   "",    false, false },
  { u8"Agoi",                                                       "ibm",     "",   "",    false, false },
  { u8"Aguacateco",                                                 "agu",     "",   "",    false, false },
  { u8"Aguano",                                                     "aga",     "",   "",    false, false },
  { u8"Aguaruna",                                                   "agr",     "",   "",    false, false },
  { u8"Aguna",                                                      "aug",     "",   "",    false, false },
  { u8"Agusan Manobo",                                              "msm",     "",   "",    false, false },
  { u8"Agutaynen",                                                  "agn",     "",   "",    false, false },
  { u8"Agwagwune",                                                  "yay",     "",   "",    false, false },
  { u8"Ahanta",                                                     "aha",     "",   "",    false, false },
  { u8"Aheri Gondi",                                                "esg",     "",   "",    false, false },
  { u8"Aheu",                                                       "thm",     "",   "",    false, false },
  { u8"Ahirani",                                                    "ahr",     "",   "",    false, false },
  { u8"Ahom",                                                       "aho",     "",   "",    false, false },
  { u8"Ahtena",                                                     "aht",     "",   "",    false, false },
  { u8"Ahwai",                                                      "nfd",     "",   "",    false, false },
  { u8"Ai-Cham",                                                    "aih",     "",   "",    false, false },
  { u8"Aighon",                                                     "aix",     "",   "",    false, false },
  { u8"Aikanã",                                                     "tba",     "",   "",    false, false },
  { u8"Aiklep",                                                     "mwg",     "",   "",    false, false },
  { u8"Aimaq",                                                      "aiq",     "",   "",    false, false },
  { u8"Aimele",                                                     "ail",     "",   "",    false, false },
  { u8"Aimol",                                                      "aim",     "",   "",    false, false },
  { u8"Ainbai",                                                     "aic",     "",   "",    false, false },
  { u8"Ainu (China)",                                               "aib",     "",   "",    false, false },
  { u8"Ainu (Japan)",                                               "ain",     "",   "",    true,  false },
  { u8"Aiome",                                                      "aki",     "",   "",    false, false },
  { u8"Airoran",                                                    "air",     "",   "",    false, false },
  { u8"Aiton",                                                      "aio",     "",   "",    false, false },
  { u8"Aja (Benin)",                                                "ajg",     "",   "",    false, false },
  { u8"Aja (South Sudan)",                                          "aja",     "",   "",    false, false },
  { u8"Ajawa",                                                      "ajw",     "",   "",    false, false },
  { u8"Ajië",                                                       "aji",     "",   "",    false, false },
  { u8"Ajumbu",                                                     "muc",     "",   "",    false, false },
  { u8"Ajyíninka Apurucayali",                                      "cpc",     "",   "",    false, false },
  { u8"Ak",                                                         "akq",     "",   "",    false, false },
  { u8"Aka",                                                        "soh",     "",   "",    false, false },
  { u8"Aka-Bea",                                                    "abj",     "",   "",    false, false },
  { u8"Aka-Bo",                                                     "akm",     "",   "",    false, false },
  { u8"Aka-Cari",                                                   "aci",     "",   "",    false, false },
  { u8"Aka-Jeru",                                                   "akj",     "",   "",    false, false },
  { u8"Aka-Kede",                                                   "akx",     "",   "",    false, false },
  { u8"Aka-Kol",                                                    "aky",     "",   "",    false, false },
  { u8"Aka-Kora",                                                   "ack",     "",   "",    false, false },
  { u8"Akan",                                                       "aka",     "ak", "",    true,  false },
  { u8"Akar-Bale",                                                  "acl",     "",   "",    false, false },
  { u8"Akaselem",                                                   "aks",     "",   "",    false, false },
  { u8"Akawaio",                                                    "ake",     "",   "",    false, false },
  { u8"Ake",                                                        "aik",     "",   "",    false, false },
  { u8"Akebu",                                                      "keu",     "",   "",    false, false },
  { u8"Akei",                                                       "tsr",     "",   "",    false, false },
  { u8"Akeu",                                                       "aeu",     "",   "",    false, false },
  { u8"Akha",                                                       "ahk",     "",   "",    false, false },
  { u8"Akhvakh",                                                    "akv",     "",   "",    false, false },
  { u8"Akkadian",                                                   "akk",     "",   "",    true,  false },
  { u8"Akkala Sami",                                                "sia",     "",   "",    false, false },
  { u8"Aklanon",                                                    "akl",     "",   "",    false, false },
  { u8"Akolet",                                                     "akt",     "",   "",    false, false },
  { u8"Akoose",                                                     "bss",     "",   "",    false, false },
  { u8"Akoye",                                                      "miw",     "",   "",    false, false },
  { u8"Akpa",                                                       "akf",     "",   "",    false, false },
  { u8"Akpes",                                                      "ibe",     "",   "",    false, false },
  { u8"Akrukay",                                                    "afi",     "",   "",    false, false },
  { u8"Akukem",                                                     "spm",     "",   "",    false, false },
  { u8"Akuku",                                                      "ayk",     "",   "",    false, false },
  { u8"Akum",                                                       "aku",     "",   "",    false, false },
  { u8"Akuntsu",                                                    "aqz",     "",   "",    false, false },
  { u8"Akurio",                                                     "ako",     "",   "",    false, false },
  { u8"Akwa",                                                       "akw",     "",   "",    false, false },
  { u8"Akyaung Ari Naga",                                           "nqy",     "",   "",    false, false },
  { u8"Al-Sayyid Bedouin Sign Language",                            "syy",     "",   "",    false, false },
  { u8"Alaba-K’abeena",                                             "alw",     "",   "",    false, false },
  { u8"Alabama",                                                    "akz",     "",   "",    false, false },
  { u8"Alabat Island Agta",                                         "dul",     "",   "",    false, false },
  { u8"Alacalufan languages",                                       "aqa",     "",   "",    false, false },
  { u8"Alacatlatzala Mixtec",                                       "mim",     "",   "",    false, false },
  { u8"Alago",                                                      "ala",     "",   "",    false, false },
  { u8"Alagwa",                                                     "wbj",     "",   "",    false, false },
  { u8"Alak",                                                       "alk",     "",   "",    false, false },
  { u8"Alamblak",                                                   "amp",     "",   "",    false, false },
  { u8"Alangan",                                                    "alj",     "",   "",    false, false },
  { u8"Alanic",                                                     "xln",     "",   "",    false, false },
  { u8"Alapmunte",                                                  "apv",     "",   "",    false, false },
  { u8"Alawa",                                                      "alh",     "",   "",    false, false },
  { u8"Albanian Sign Language",                                     "sqk",     "",   "",    false, false },
  { u8"Albanian languages",                                         "sqj",     "",   "",    false, false },
  { u8"Albanian",                                                   "alb",     "sq", "sqi", true,  false },
  { u8"Albarradas Sign Language",                                   "lsc",     "",   "",    false, false },
  { u8"Albay Bicolano",                                             "bhk",     "",   "",    false, true  },
  { u8"Alcozauca Mixtec",                                           "xta",     "",   "",    false, false },
  { u8"Alege",                                                      "alf",     "",   "",    false, false },
  { u8"Alekano",                                                    "gah",     "",   "",    false, false },
  { u8"Aleut",                                                      "ale",     "",   "",    true,  false },
  { u8"Algerian Arabic",                                            "arq",     "",   "",    false, false },
  { u8"Algerian Jewish Sign Language",                              "ajs",     "",   "",    false, false },
  { u8"Algerian Saharan Arabic",                                    "aao",     "",   "",    false, false },
  { u8"Algerian Sign Language",                                     "asp",     "",   "",    false, false },
  { u8"Algic languages",                                            "aql",     "",   "",    false, false },
  { u8"Algonquian languages",                                       "alg",     "",   "",    true,  false },
  { u8"Algonquin",                                                  "alq",     "",   "",    false, false },
  { u8"Ali",                                                        "aiy",     "",   "",    false, false },
  { u8"Alladian",                                                   "ald",     "",   "",    false, false },
  { u8"Allar",                                                      "all",     "",   "",    false, false },
  { u8"Alngith",                                                    "aid",     "",   "",    false, false },
  { u8"Alo Phola",                                                  "ypo",     "",   "",    false, false },
  { u8"Alor",                                                       "aol",     "",   "",    false, false },
  { u8"Aloápam Zapotec",                                            "zaq",     "",   "",    false, false },
  { u8"Alsea",                                                      "aes",     "",   "",    false, false },
  { u8"Altaic languages",                                           "tut",     "",   "",    true,  false },
  { u8"Alu Kurumba",                                                "xua",     "",   "",    false, false },
  { u8"Alugu",                                                      "aub",     "",   "",    false, false },
  { u8"Alumu-Tesu",                                                 "aab",     "",   "",    false, false },
  { u8"Alune",                                                      "alp",     "",   "",    false, false },
  { u8"Aluo",                                                       "yna",     "",   "",    false, false },
  { u8"Alur",                                                       "alz",     "",   "",    false, false },
  { u8"Alutor",                                                     "alr",     "",   "",    false, false },
  { u8"Alviri-Vidari",                                              "avd",     "",   "",    false, false },
  { u8"Alyawarr",                                                   "aly",     "",   "",    false, false },
  { u8"Ama (Papua New Guinea)",                                     "amm",     "",   "",    false, false },
  { u8"Ama (Sudan)",                                                "nyi",     "",   "",    false, false },
  { u8"Amahai",                                                     "amq",     "",   "",    false, false },
  { u8"Amahuaca",                                                   "amc",     "",   "",    false, false },
  { u8"Amaimon",                                                    "ali",     "",   "",    false, false },
  { u8"Amal",                                                       "aad",     "",   "",    false, false },
  { u8"Amami Koniya Sign Language",                                 "jks",     "",   "",    false, false },
  { u8"Amanab",                                                     "amn",     "",   "",    false, false },
  { u8"Amanayé",                                                    "ama",     "",   "",    false, false },
  { u8"Amara",                                                      "aie",     "",   "",    false, false },
  { u8"Amarakaeri",                                                 "amr",     "",   "",    false, false },
  { u8"Amarasi",                                                    "aaz",     "",   "",    false, false },
  { u8"Amatlán Zapotec",                                            "zpo",     "",   "",    false, false },
  { u8"Amba (Solomon Islands)",                                     "utp",     "",   "",    false, false },
  { u8"Amba (Uganda)",                                              "rwm",     "",   "",    false, false },
  { u8"Ambai",                                                      "amk",     "",   "",    false, false },
  { u8"Ambakich",                                                   "aew",     "",   "",    false, false },
  { u8"Ambala Ayta",                                                "abc",     "",   "",    false, false },
  { u8"Ambelau",                                                    "amv",     "",   "",    false, false },
  { u8"Ambele",                                                     "ael",     "",   "",    false, false },
  { u8"Amblong",                                                    "alm",     "",   "",    false, false },
  { u8"Ambo",                                                       "amb",     "",   "",    false, false },
  { u8"Ambo-Pasco Quechua",                                         "qva",     "",   "",    false, false },
  { u8"Ambonese Malay",                                             "abs",     "",   "",    false, false },
  { u8"Ambrak",                                                     "aag",     "",   "",    false, false },
  { u8"Ambul",                                                      "apo",     "",   "",    false, false },
  { u8"Ambulas",                                                    "abt",     "",   "",    false, false },
  { u8"Amdang",                                                     "amj",     "",   "",    false, false },
  { u8"Amdo Tibetan",                                               "adx",     "",   "",    false, false },
  { u8"Amele",                                                      "aey",     "",   "",    false, false },
  { u8"American Sign Language",                                     "ase",     "",   "",    false, false },
  { u8"Amganad Ifugao",                                             "ifa",     "",   "",    false, false },
  { u8"Amharic",                                                    "amh",     "am", "",    true,  false },
  { u8"Ami",                                                        "amy",     "",   "",    false, false },
  { u8"Amis",                                                       "ami",     "",   "",    false, false },
  { u8"Amo",                                                        "amo",     "",   "",    false, false },
  { u8"Amol",                                                       "alx",     "",   "",    false, false },
  { u8"Amoltepec Mixtec",                                           "mbz",     "",   "",    false, false },
  { u8"Ampanang",                                                   "apg",     "",   "",    false, false },
  { u8"Ampari Dogon",                                               "aqd",     "",   "",    false, false },
  { u8"Amri Karbi",                                                 "ajz",     "",   "",    false, false },
  { u8"Amto",                                                       "amt",     "",   "",    false, false },
  { u8"Amundava",                                                   "adw",     "",   "",    false, false },
  { u8"Amurdak",                                                    "amg",     "",   "",    false, false },
  { u8"Ana Tinga Dogon",                                            "dti",     "",   "",    false, false },
  { u8"Anaang",                                                     "anw",     "",   "",    false, false },
  { u8"Anakalangu",                                                 "akg",     "",   "",    false, false },
  { u8"Anal",                                                       "anm",     "",   "",    false, false },
  { u8"Anam",                                                       "pda",     "",   "",    false, false },
  { u8"Anambé",                                                     "aan",     "",   "",    false, false },
  { u8"Anamgura",                                                   "imi",     "",   "",    false, false },
  { u8"Anasi",                                                      "bpo",     "",   "",    false, false },
  { u8"Ancient Hebrew",                                             "hbo",     "",   "",    false, false },
  { u8"Ancient Macedonian",                                         "xmk",     "",   "",    false, false },
  { u8"Ancient North Arabian",                                      "xna",     "",   "",    false, false },
  { u8"Ancient Zapotec",                                            "xzp",     "",   "",    false, false },
  { u8"Andaandi",                                                   "dgl",     "",   "",    false, false },
  { u8"Andai",                                                      "afd",     "",   "",    false, false },
  { u8"Andajin",                                                    "ajn",     "",   "",    false, false },
  { u8"Andalusian Arabic",                                          "xaa",     "",   "",    false, false },
  { u8"Andaman Creole Hindi",                                       "hca",     "",   "",    false, false },
  { u8"Andaqui",                                                    "ana",     "",   "",    false, false },
  { u8"Andarum",                                                    "aod",     "",   "",    false, false },
  { u8"Andegerebinha",                                              "adg",     "",   "",    false, false },
  { u8"Andh",                                                       "anr",     "",   "",    false, false },
  { u8"Andi",                                                       "ani",     "",   "",    false, false },
  { u8"Andio",                                                      "bzb",     "",   "",    false, false },
  { u8"Andoa",                                                      "anb",     "",   "",    false, false },
  { u8"Andoque",                                                    "ano",     "",   "",    false, false },
  { u8"Andra-Hus",                                                  "anx",     "",   "",    false, false },
  { u8"Aneityum",                                                   "aty",     "",   "",    false, false },
  { u8"Anem",                                                       "anz",     "",   "",    false, false },
  { u8"Aneme Wake",                                                 "aby",     "",   "",    false, false },
  { u8"Anfillo",                                                    "myo",     "",   "",    false, false },
  { u8"Angaataha",                                                  "agm",     "",   "",    false, false },
  { u8"Angaité",                                                    "aqt",     "",   "",    false, false },
  { u8"Angal Enen",                                                 "aoe",     "",   "",    false, false },
  { u8"Angal Heneng",                                               "akh",     "",   "",    false, false },
  { u8"Angal",                                                      "age",     "",   "",    false, false },
  { u8"Angami Naga",                                                "njm",     "",   "",    false, false },
  { u8"Angguruk Yali",                                              "yli",     "",   "",    false, false },
  { u8"Angika",                                                     "anp",     "",   "",    true,  false },
  { u8"Angkamuthi",                                                 "avm",     "",   "",    false, false },
  { u8"Anglo-Norman",                                               "xno",     "",   "",    false, false },
  { u8"Angloromani",                                                "rme",     "",   "",    false, false },
  { u8"Angolar",                                                    "aoa",     "",   "",    false, false },
  { u8"Angor",                                                      "agg",     "",   "",    false, false },
  { u8"Angoram",                                                    "aog",     "",   "",    false, false },
  { u8"Angosturas Tunebo",                                          "tnd",     "",   "",    false, false },
  { u8"Anguthimri",                                                 "awg",     "",   "",    false, false },
  { u8"Ani Phowa",                                                  "ypn",     "",   "",    false, false },
  { u8"Anii",                                                       "blo",     "",   "",    false, false },
  { u8"Animere",                                                    "anf",     "",   "",    false, false },
  { u8"Anindilyakwa",                                               "aoi",     "",   "",    false, false },
  { u8"Aninka",                                                     "aqk",     "",   "",    false, false },
  { u8"Anjam",                                                      "boj",     "",   "",    false, false },
  { u8"Ankave",                                                     "aak",     "",   "",    false, false },
  { u8"Anmatyerre",                                                 "amx",     "",   "",    false, false },
  { u8"Anong",                                                      "nun",     "",   "",    false, false },
  { u8"Anor",                                                       "anj",     "",   "",    false, false },
  { u8"Anserma",                                                    "ans",     "",   "",    false, false },
  { u8"Ansus",                                                      "and",     "",   "",    false, false },
  { u8"Antakarinya",                                                "ant",     "",   "",    false, false },
  { u8"Antankarana Malagasy",                                       "xmv",     "",   "",    false, false },
  { u8"Antigua and Barbuda Creole English",                         "aig",     "",   "",    false, false },
  { u8"Anu-Hkongso Chin",                                           "anl",     "",   "",    false, false },
  { u8"Anuak",                                                      "anu",     "",   "",    false, false },
  { u8"Anufo",                                                      "cko",     "",   "",    false, false },
  { u8"Anuki",                                                      "aui",     "",   "",    false, false },
  { u8"Anus",                                                       "auq",     "",   "",    false, false },
  { u8"Anuta",                                                      "aud",     "",   "",    false, false },
  { u8"Anyin Morofo",                                               "mtb",     "",   "",    false, false },
  { u8"Anyin",                                                      "any",     "",   "",    false, false },
  { u8"Ao Naga",                                                    "njo",     "",   "",    false, false },
  { u8"Aoheng",                                                     "pni",     "",   "",    false, false },
  { u8"Aore",                                                       "aor",     "",   "",    false, false },
  { u8"Ap Ma",                                                      "kbx",     "",   "",    false, false },
  { u8"Apache languages",                                           "apa",     "",   "",    true,  false },
  { u8"Apalachee",                                                  "xap",     "",   "",    false, false },
  { u8"Apalaí",                                                     "apy",     "",   "",    false, false },
  { u8"Apali",                                                      "ena",     "",   "",    false, false },
  { u8"Apasco-Apoala Mixtec",                                       "mip",     "",   "",    false, false },
  { u8"Apatani",                                                    "apt",     "",   "",    false, false },
  { u8"Apiaká",                                                     "api",     "",   "",    false, false },
  { u8"Apinayé",                                                    "apn",     "",   "",    false, false },
  { u8"Apma",                                                       "app",     "",   "",    false, false },
  { u8"Aproumu Aizi",                                               "ahp",     "",   "",    false, false },
  { u8"Apurinã",                                                    "apu",     "",   "",    false, false },
  { u8"Aputai",                                                     "apx",     "",   "",    false, false },
  { u8"Aquitanian",                                                 "xaq",     "",   "",    false, false },
  { u8"Arabana",                                                    "ard",     "",   "",    false, false },
  { u8"Arabela",                                                    "arl",     "",   "",    false, false },
  { u8"Arabic",                                                     "ara",     "ar", "",    true,  false },
  { u8"Aragonese",                                                  "arg",     "an", "",    true,  false },
  { u8"Araki",                                                      "akr",     "",   "",    false, false },
  { u8"Arakwal",                                                    "rkw",     "",   "",    false, false },
  { u8"Aralle-Tabulahan",                                           "atq",     "",   "",    false, false },
  { u8"Aramanik",                                                   "aam",     "",   "",    false, true  },
  { u8"Arammba",                                                    "stk",     "",   "",    false, false },
  { u8"Aranadan",                                                   "aaf",     "",   "",    false, false },
  { u8"Aranama-Tamique",                                            "xrt",     "",   "",    false, false },
  { u8"Arandai",                                                    "jbj",     "",   "",    false, false },
  { u8"Araona",                                                     "aro",     "",   "",    false, false },
  { u8"Arapaho",                                                    "arp",     "",   "",    true,  false },
  { u8"Arapaso",                                                    "arj",     "",   "",    false, false },
  { u8"Ararandewára",                                               "xaj",     "",   "",    false, false },
  { u8"Arauan languages",                                           "auf",     "",   "",    false, false },
  { u8"Arawak",                                                     "arw",     "",   "",    true,  false },
  { u8"Arawakan languages",                                         "awd",     "",   "",    false, false },
  { u8"Araweté",                                                    "awt",     "",   "",    false, false },
  { u8"Arawum",                                                     "awm",     "",   "",    false, false },
  { u8"Arbore",                                                     "arv",     "",   "",    false, false },
  { u8"Arbëreshë Albanian",                                         "aae",     "",   "",    false, false },
  { u8"Archi",                                                      "aqc",     "",   "",    false, false },
  { u8"Ardhamāgadhī Prākrit",                                       "pka",     "",   "",    false, false },
  { u8"Are",                                                        "mwc",     "",   "",    false, false },
  { u8"Areba",                                                      "aea",     "",   "",    false, false },
  { u8"Arem",                                                       "aem",     "",   "",    false, false },
  { u8"Arequipa-La Unión Quechua",                                  "qxu",     "",   "",    false, false },
  { u8"Argentine Sign Language",                                    "aed",     "",   "",    false, false },
  { u8"Argobba",                                                    "agj",     "",   "",    false, false },
  { u8"Arguni",                                                     "agf",     "",   "",    false, false },
  { u8"Arhuaco",                                                    "arh",     "",   "",    false, false },
  { u8"Arhâ",                                                       "aqr",     "",   "",    false, false },
  { u8"Arhö",                                                       "aok",     "",   "",    false, false },
  { u8"Ari",                                                        "aac",     "",   "",    false, false },
  { u8"Aribwatsa",                                                  "laz",     "",   "",    false, false },
  { u8"Aribwaung",                                                  "ylu",     "",   "",    false, false },
  { u8"Arifama-Miniafia",                                           "aai",     "",   "",    false, false },
  { u8"Arigidi",                                                    "aqg",     "",   "",    false, false },
  { u8"Arikapú",                                                    "ark",     "",   "",    false, false },
  { u8"Arikara",                                                    "ari",     "",   "",    false, false },
  { u8"Arikem",                                                     "ait",     "",   "",    false, false },
  { u8"Arin",                                                       "xrn",     "",   "",    false, false },
  { u8"Aringa",                                                     "luc",     "",   "",    false, false },
  { u8"Arma",                                                       "aoh",     "",   "",    false, true  },
  { u8"Armazic",                                                    "xrm",     "",   "",    false, false },
  { u8"Armenian (family)",                                          "hyx",     "",   "",    false, false },
  { u8"Armenian Sign Language",                                     "aen",     "",   "",    false, false },
  { u8"Armenian",                                                   "arm",     "hy", "hye", true,  false },
  { u8"Arop-Lokep",                                                 "apr",     "",   "",    false, false },
  { u8"Arop-Sissano",                                               "aps",     "",   "",    false, false },
  { u8"Arosi",                                                      "aia",     "",   "",    false, false },
  { u8"Arpitan",                                                    "frp",     "",   "",    false, false },
  { u8"Arritinngithigh",                                            "rrt",     "",   "",    false, false },
  { u8"Arta",                                                       "atz",     "",   "",    false, false },
  { u8"Artificial languages",                                       "art",     "",   "",    true,  false },
  { u8"Aruamu",                                                     "msy",     "",   "",    false, false },
  { u8"Aruek",                                                      "aur",     "",   "",    false, false },
  { u8"Aruop",                                                      "lsr",     "",   "",    false, false },
  { u8"Arutani",                                                    "atx",     "",   "",    false, false },
  { u8"Aruá (Amazonas State)",                                      "aru",     "",   "",    false, false },
  { u8"Aruá (Rodonia State)",                                       "arx",     "",   "",    false, false },
  { u8"Arvanitika Albanian",                                        "aat",     "",   "",    false, false },
  { u8"As",                                                         "asz",     "",   "",    false, false },
  { u8"Asaro'o",                                                    "mtv",     "",   "",    false, false },
  { u8"Asas",                                                       "asd",     "",   "",    false, true  },
  { u8"Ashe",                                                       "ahs",     "",   "",    false, false },
  { u8"Ashkun",                                                     "ask",     "",   "",    false, false },
  { u8"Asho Chin",                                                  "csh",     "",   "",    false, false },
  { u8"Ashtiani",                                                   "atn",     "",   "",    false, false },
  { u8"Asháninka",                                                  "cni",     "",   "",    false, false },
  { u8"Ashéninka Pajonal",                                          "cjo",     "",   "",    false, false },
  { u8"Ashéninka Perené",                                           "prq",     "",   "",    false, false },
  { u8"Asilulu",                                                    "asl",     "",   "",    false, false },
  { u8"Askopan",                                                    "eiv",     "",   "",    false, false },
  { u8"Asoa",                                                       "asv",     "",   "",    false, false },
  { u8"Assamese",                                                   "asm",     "as", "",    true,  false },
  { u8"Assan",                                                      "xss",     "",   "",    false, false },
  { u8"Assangori",                                                  "sjg",     "",   "",    false, false },
  { u8"Assiniboine",                                                "asb",     "",   "",    false, false },
  { u8"Assyrian Neo-Aramaic",                                       "aii",     "",   "",    false, false },
  { u8"Asturian",                                                   "ast",     "",   "",    true,  false },
  { u8"Asu (Nigeria)",                                              "aum",     "",   "",    false, false },
  { u8"Asu (Tanzania)",                                             "asa",     "",   "",    false, false },
  { u8"Asue Awyu",                                                  "psa",     "",   "",    false, false },
  { u8"Asumboa",                                                    "aua",     "",   "",    false, false },
  { u8"Asunción Mixtepec Zapotec",                                  "zoo",     "",   "",    false, false },
  { u8"Asuri",                                                      "asr",     "",   "",    false, false },
  { u8"Ata Manobo",                                                 "atd",     "",   "",    false, false },
  { u8"Ata",                                                        "atm",     "",   "",    false, false },
  { u8"Atakapa",                                                    "aqp",     "",   "",    false, false },
  { u8"Atampaya",                                                   "amz",     "",   "",    false, false },
  { u8"Atatláhuca Mixtec",                                          "mib",     "",   "",    false, false },
  { u8"Atauran",                                                    "adb",     "",   "",    false, false },
  { u8"Atayal",                                                     "tay",     "",   "",    false, false },
  { u8"Atemble",                                                    "ate",     "",   "",    false, false },
  { u8"Athapascan languages",                                       "ath",     "",   "",    true,  false },
  { u8"Athpariya",                                                  "aph",     "",   "",    false, false },
  { u8"Ati",                                                        "atk",     "",   "",    false, false },
  { u8"Atikamekw",                                                  "atj",     "",   "",    false, false },
  { u8"Atlantic-Congo languages",                                   "alv",     "",   "",    false, false },
  { u8"Atohwaim",                                                   "aqm",     "",   "",    false, false },
  { u8"Atong (Cameroon)",                                           "ato",     "",   "",    false, false },
  { u8"Atong (India)",                                              "aot",     "",   "",    false, false },
  { u8"Atorada",                                                    "aox",     "",   "",    false, false },
  { u8"Atsahuaca",                                                  "atc",     "",   "",    false, false },
  { u8"Atsam",                                                      "cch",     "",   "",    false, false },
  { u8"Atsugewi",                                                   "atw",     "",   "",    false, false },
  { u8"Attapady Kurumba",                                           "pkr",     "",   "",    false, false },
  { u8"Attié",                                                      "ati",     "",   "",    false, false },
  { u8"Atzingo Matlatzinca",                                        "ocu",     "",   "",    false, false },
  { u8"Au",                                                         "avt",     "",   "",    false, false },
  { u8"Aulua",                                                      "aul",     "",   "",    false, false },
  { u8"Aurá",                                                       "aux",     "",   "",    false, false },
  { u8"Aushi",                                                      "auh",     "",   "",    false, false },
  { u8"Aushiri",                                                    "avs",     "",   "",    false, false },
  { u8"Auslan",                                                     "asf",     "",   "",    false, false },
  { u8"Austral",                                                    "aut",     "",   "",    false, false },
  { u8"Australian Aborigines Sign Language",                        "asw",     "",   "",    false, false },
  { u8"Australian languages",                                       "aus",     "",   "",    true,  false },
  { u8"Austrian Sign Language",                                     "asq",     "",   "",    false, false },
  { u8"Austro-Asiatic languages",                                   "aav",     "",   "",    false, false },
  { u8"Austronesian languages",                                     "map",     "",   "",    true,  false },
  { u8"Auwe",                                                       "smf",     "",   "",    false, false },
  { u8"Auye",                                                       "auu",     "",   "",    false, false },
  { u8"Auyokawa",                                                   "auo",     "",   "",    false, false },
  { u8"Avaric",                                                     "ava",     "av", "",    true,  false },
  { u8"Avatime",                                                    "avn",     "",   "",    false, false },
  { u8"Avau",                                                       "avb",     "",   "",    false, false },
  { u8"Avestan",                                                    "ave",     "ae", "",    true,  false },
  { u8"Avikam",                                                     "avi",     "",   "",    false, false },
  { u8"Avokaya",                                                    "avu",     "",   "",    false, false },
  { u8"Avá-Canoeiro",                                               "avv",     "",   "",    false, false },
  { u8"Awa (China)",                                                "vwa",     "",   "",    false, false },
  { u8"Awa (Papua New Guinea)",                                     "awb",     "",   "",    false, false },
  { u8"Awa-Cuaiquer",                                               "kwi",     "",   "",    false, false },
  { u8"Awabakal",                                                   "awk",     "",   "",    false, false },
  { u8"Awad Bing",                                                  "bcu",     "",   "",    false, false },
  { u8"Awadhi",                                                     "awa",     "",   "",    true,  false },
  { u8"Awak",                                                       "awo",     "",   "",    false, false },
  { u8"Awar",                                                       "aya",     "",   "",    false, false },
  { u8"Awara",                                                      "awx",     "",   "",    false, false },
  { u8"Awbono",                                                     "awh",     "",   "",    false, false },
  { u8"Aweer",                                                      "bob",     "",   "",    false, false },
  { u8"Awera",                                                      "awr",     "",   "",    false, false },
  { u8"Awetí",                                                      "awe",     "",   "",    false, false },
  { u8"Awing",                                                      "azo",     "",   "",    false, false },
  { u8"Awiyaana",                                                   "auy",     "",   "",    false, false },
  { u8"Awjilah",                                                    "auj",     "",   "",    false, false },
  { u8"Awngi",                                                      "awn",     "",   "",    false, false },
  { u8"Awngthim",                                                   "gwm",     "",   "",    false, false },
  { u8"Awtuw",                                                      "kmn",     "",   "",    false, false },
  { u8"Awu",                                                        "yiu",     "",   "",    false, false },
  { u8"Awun",                                                       "aww",     "",   "",    false, false },
  { u8"Awutu",                                                      "afu",     "",   "",    false, false },
  { u8"Awyi",                                                       "auw",     "",   "",    false, false },
  { u8"Axamb",                                                      "ahb",     "",   "",    false, false },
  { u8"Axi Yi",                                                     "yix",     "",   "",    false, false },
  { u8"Ayabadhu",                                                   "ayd",     "",   "",    false, false },
  { u8"Ayacucho Quechua",                                           "quy",     "",   "",    false, false },
  { u8"Ayautla Mazatec",                                            "vmy",     "",   "",    false, false },
  { u8"Ayere",                                                      "aye",     "",   "",    false, false },
  { u8"Ayerrerenge",                                                "axe",     "",   "",    false, false },
  { u8"Ayi (China)",                                                "ayx",     "",   "",    false, true  },
  { u8"Ayi (Papua New Guinea)",                                     "ayq",     "",   "",    false, false },
  { u8"Ayiwo",                                                      "nfl",     "",   "",    false, false },
  { u8"Ayizi",                                                      "yyz",     "",   "",    false, false },
  { u8"Ayizo Gbe",                                                  "ayb",     "",   "",    false, false },
  { u8"Aymara",                                                     "aym",     "ay", "",    true,  false },
  { u8"Ayoquesco Zapotec",                                          "zaf",     "",   "",    false, false },
  { u8"Ayoreo",                                                     "ayo",     "",   "",    false, false },
  { u8"Ayu",                                                        "ayu",     "",   "",    false, false },
  { u8"Ayutla Mixtec",                                              "miy",     "",   "",    false, false },
  { u8"Azerbaijani",                                                "aze",     "az", "",    true,  false },
  { u8"Azha",                                                       "aza",     "",   "",    false, false },
  { u8"Azhe",                                                       "yiz",     "",   "",    false, false },
  { u8"Azoyú Me'phaa",                                              "tpc",     "",   "",    false, false },
  { u8"Baan",                                                       "bvj",     "",   "",    false, false },
  { u8"Baangi",                                                     "bqx",     "",   "",    false, false },
  { u8"Baatonum",                                                   "bba",     "",   "",    false, false },
  { u8"Baba Malay",                                                 "mbf",     "",   "",    false, false },
  { u8"Baba",                                                       "bbw",     "",   "",    false, false },
  { u8"Babalia Creole Arabic",                                      "bbz",     "",   "",    false, true  },
  { u8"Babango",                                                    "bbm",     "",   "",    false, false },
  { u8"Babanki",                                                    "bbk",     "",   "",    false, false },
  { u8"Babatana",                                                   "baa",     "",   "",    false, false },
  { u8"Babine",                                                     "bcr",     "",   "",    false, false },
  { u8"Babuza",                                                     "bzg",     "",   "",    false, false },
  { u8"Bacama",                                                     "bcy",     "",   "",    false, false },
  { u8"Bacanese Malay",                                             "btj",     "",   "",    false, false },
  { u8"Bactrian",                                                   "xbc",     "",   "",    false, false },
  { u8"Bada (Indonesia)",                                           "bhz",     "",   "",    false, false },
  { u8"Bada (Nigeria)",                                             "bau",     "",   "",    false, false },
  { u8"Badaga",                                                     "bfq",     "",   "",    false, false },
  { u8"Bade",                                                       "bde",     "",   "",    false, false },
  { u8"Badeshi",                                                    "bdz",     "",   "",    false, false },
  { u8"Badimaya",                                                   "bia",     "",   "",    false, false },
  { u8"Badjiri",                                                    "jbi",     "",   "",    false, false },
  { u8"Badui",                                                      "bac",     "",   "",    false, false },
  { u8"Badyara",                                                    "pbp",     "",   "",    false, false },
  { u8"Baeggu",                                                     "bvd",     "",   "",    false, false },
  { u8"Baelelea",                                                   "bvc",     "",   "",    false, false },
  { u8"Baetora",                                                    "btr",     "",   "",    false, false },
  { u8"Bafanji",                                                    "bfj",     "",   "",    false, false },
  { u8"Bafaw-Balong",                                               "bwt",     "",   "",    false, false },
  { u8"Bafia",                                                      "ksf",     "",   "",    false, false },
  { u8"Bafut",                                                      "bfd",     "",   "",    false, false },
  { u8"Baga Kaloum",                                                "bqf",     "",   "",    false, false },
  { u8"Baga Koga",                                                  "bgo",     "",   "",    false, false },
  { u8"Baga Manduri",                                               "bmd",     "",   "",    false, false },
  { u8"Baga Mboteni",                                               "bgm",     "",   "",    false, true  },
  { u8"Baga Pokur",                                                 "bcg",     "",   "",    false, false },
  { u8"Baga Sitemu",                                                "bsp",     "",   "",    false, false },
  { u8"Baga Sobané",                                                "bsv",     "",   "",    false, false },
  { u8"Bagheli",                                                    "bfy",     "",   "",    false, false },
  { u8"Bagirmi Fulfulde",                                           "fui",     "",   "",    false, false },
  { u8"Bagirmi",                                                    "bmi",     "",   "",    false, false },
  { u8"Bago-Kusuntu",                                               "bqg",     "",   "",    false, false },
  { u8"Bagri",                                                      "bgq",     "",   "",    false, false },
  { u8"Bagupi",                                                     "bpi",     "",   "",    false, false },
  { u8"Bagusa",                                                     "bqb",     "",   "",    false, false },
  { u8"Bagvalal",                                                   "kva",     "",   "",    false, false },
  { u8"Baha Buyang",                                                "yha",     "",   "",    false, false },
  { u8"Baham",                                                      "bdw",     "",   "",    false, false },
  { u8"Bahamas Creole English",                                     "bah",     "",   "",    false, false },
  { u8"Baharna Arabic",                                             "abv",     "",   "",    false, false },
  { u8"Bahau",                                                      "bhv",     "",   "",    false, false },
  { u8"Bahinemo",                                                   "bjh",     "",   "",    false, false },
  { u8"Bahing",                                                     "bhj",     "",   "",    false, false },
  { u8"Bahnar",                                                     "bdq",     "",   "",    false, false },
  { u8"Bahonsuai",                                                  "bsu",     "",   "",    false, false },
  { u8"Bai (South Sudan)",                                          "bdj",     "",   "",    false, false },
  { u8"Baibai",                                                     "bbf",     "",   "",    false, false },
  { u8"Baikeno",                                                    "bkx",     "",   "",    false, false },
  { u8"Baima",                                                      "bqh",     "",   "",    false, false },
  { u8"Baimak",                                                     "bmx",     "",   "",    false, false },
  { u8"Bainouk-Gunyaamolo",                                         "bcz",     "",   "",    false, false },
  { u8"Bainouk-Gunyuño",                                            "bab",     "",   "",    false, false },
  { u8"Bainouk-Samik",                                              "bcb",     "",   "",    false, false },
  { u8"Baiso",                                                      "bsw",     "",   "",    false, false },
  { u8"Baissa Fali",                                                "fah",     "",   "",    false, false },
  { u8"Bajan",                                                      "bjs",     "",   "",    false, false },
  { u8"Bajelani",                                                   "bjm",     "",   "",    false, false },
  { u8"Baka (Cameroon)",                                            "bkc",     "",   "",    false, false },
  { u8"Baka (South Sudan)",                                         "bdh",     "",   "",    false, false },
  { u8"Bakairí",                                                    "bkq",     "",   "",    false, false },
  { u8"Bakaka",                                                     "bqz",     "",   "",    false, false },
  { u8"Bakhtiari",                                                  "bqi",     "",   "",    false, false },
  { u8"Baki",                                                       "bki",     "",   "",    false, false },
  { u8"Bakoko",                                                     "bkh",     "",   "",    false, false },
  { u8"Bakole",                                                     "kme",     "",   "",    false, false },
  { u8"Bakpinka",                                                   "bbs",     "",   "",    false, false },
  { u8"Bakumpai",                                                   "bkr",     "",   "",    false, false },
  { u8"Bakwé",                                                      "bjw",     "",   "",    false, false },
  { u8"Balaesang",                                                  "bls",     "",   "",    false, false },
  { u8"Balaibalan",                                                 "zba",     "",   "",    false, false },
  { u8"Balangao",                                                   "blw",     "",   "",    false, false },
  { u8"Balangingi",                                                 "sse",     "",   "",    false, false },
  { u8"Balanta-Ganja",                                              "bjt",     "",   "",    false, false },
  { u8"Balanta-Kentohe",                                            "ble",     "",   "",    false, false },
  { u8"Balantak",                                                   "blz",     "",   "",    false, false },
  { u8"Balau",                                                      "blg",     "",   "",    false, true  },
  { u8"Baldemu",                                                    "bdn",     "",   "",    false, false },
  { u8"Bali (Democratic Republic of Congo)",                        "bcp",     "",   "",    false, false },
  { u8"Bali (Nigeria)",                                             "bcn",     "",   "",    false, false },
  { u8"Balinese Malay",                                             "mhp",     "",   "",    false, false },
  { u8"Balinese",                                                   "ban",     "",   "",    true,  false },
  { u8"Balkan Gagauz Turkish",                                      "bgx",     "",   "",    false, false },
  { u8"Balkan Romani",                                              "rmn",     "",   "",    false, false },
  { u8"Balo",                                                       "bqo",     "",   "",    false, false },
  { u8"Baloi",                                                      "biz",     "",   "",    false, false },
  { u8"Balti",                                                      "bft",     "",   "",    false, false },
  { u8"Baltic Romani",                                              "rml",     "",   "",    false, false },
  { u8"Baltic languages",                                           "bat",     "",   "",    true,  false },
  { u8"Baluan-Pam",                                                 "blq",     "",   "",    false, false },
  { u8"Baluchi",                                                    "bal",     "",   "",    true,  false },
  { u8"Bamako Sign Language",                                       "bog",     "",   "",    false, false },
  { u8"Bamali",                                                     "bbq",     "",   "",    false, false },
  { u8"Bambalang",                                                  "bmo",     "",   "",    false, false },
  { u8"Bambam",                                                     "ptu",     "",   "",    false, false },
  { u8"Bambara",                                                    "bam",     "bm", "",    true,  false },
  { u8"Bambassi",                                                   "myf",     "",   "",    false, false },
  { u8"Bambili-Bambui",                                             "baw",     "",   "",    false, false },
  { u8"Bamenyam",                                                   "bce",     "",   "",    false, false },
  { u8"Bamileke languages",                                         "bai",     "",   "",    true,  false },
  { u8"Bamu",                                                       "bcf",     "",   "",    false, false },
  { u8"Bamukumbit",                                                 "bqt",     "",   "",    false, false },
  { u8"Bamun",                                                      "bax",     "",   "",    false, false },
  { u8"Bamunka",                                                    "bvm",     "",   "",    false, false },
  { u8"Bamwe",                                                      "bmg",     "",   "",    false, false },
  { u8"Ban Khor Sign Language",                                     "bfk",     "",   "",    false, false },
  { u8"Bana",                                                       "bcw",     "",   "",    false, false },
  { u8"Banao Itneg",                                                "bjx",     "",   "",    false, false },
  { u8"Banaro",                                                     "byz",     "",   "",    false, false },
  { u8"Banda (Indonesia)",                                          "bnd",     "",   "",    false, false },
  { u8"Banda Malay",                                                "bpq",     "",   "",    false, false },
  { u8"Banda languages",                                            "bad",     "",   "",    true,  false },
  { u8"Banda-Bambari",                                              "liy",     "",   "",    false, false },
  { u8"Banda-Banda",                                                "bpd",     "",   "",    false, false },
  { u8"Banda-Mbrès",                                                "bqk",     "",   "",    false, false },
  { u8"Banda-Ndélé",                                                "bfl",     "",   "",    false, false },
  { u8"Banda-Yangere",                                              "yaj",     "",   "",    false, false },
  { u8"Bandi",                                                      "bza",     "",   "",    false, false },
  { u8"Bandial",                                                    "bqj",     "",   "",    false, false },
  { u8"Bandjalang",                                                 "bdy",     "",   "",    false, false },
  { u8"Bandjigali",                                                 "bjd",     "",   "",    false, true  },
  { u8"Bangala",                                                    "bxg",     "",   "",    false, false },
  { u8"Bangandu",                                                   "bgf",     "",   "",    false, false },
  { u8"Bangba",                                                     "bbe",     "",   "",    false, false },
  { u8"Banggai",                                                    "bgz",     "",   "",    false, false },
  { u8"Banggarla",                                                  "bjb",     "",   "",    false, false },
  { u8"Bangi",                                                      "bni",     "",   "",    false, false },
  { u8"Bangime",                                                    "dba",     "",   "",    false, false },
  { u8"Bangka",                                                     "mfb",     "",   "",    false, false },
  { u8"Bangolan",                                                   "bgj",     "",   "",    false, false },
  { u8"Bangubangu",                                                 "bnx",     "",   "",    false, false },
  { u8"Bangwinji",                                                  "bsj",     "",   "",    false, false },
  { u8"Baniva",                                                     "bvv",     "",   "",    false, false },
  { u8"Baniwa",                                                     "bwi",     "",   "",    false, false },
  { u8"Banjar",                                                     "bjn",     "",   "",    false, false },
  { u8"Bankagooma",                                                 "bxw",     "",   "",    false, false },
  { u8"Bankal",                                                     "jjr",     "",   "",    false, false },
  { u8"Bankan Tey Dogon",                                           "dbw",     "",   "",    false, false },
  { u8"Bankon",                                                     "abb",     "",   "",    false, false },
  { u8"Bannoni",                                                    "bcm",     "",   "",    false, false },
  { u8"Bantawa",                                                    "bap",     "",   "",    false, false },
  { u8"Bantayanon",                                                 "bfx",     "",   "",    false, false },
  { u8"Bantik",                                                     "bnq",     "",   "",    false, false },
  { u8"Bantoanon",                                                  "bno",     "",   "",    false, false },
  { u8"Bantu languages",                                            "bnt",     "",   "",    true,  false },
  { u8"Banyjima",                                                   "pnw",     "",   "",    false, false },
  { u8"Baoulé",                                                     "bci",     "",   "",    false, false },
  { u8"Bara Malagasy",                                              "bhr",     "",   "",    false, false },
  { u8"Baraamu",                                                    "brd",     "",   "",    false, false },
  { u8"Barababaraba",                                               "rbp",     "",   "",    false, false },
  { u8"Barai",                                                      "bbb",     "",   "",    false, false },
  { u8"Barakai",                                                    "baj",     "",   "",    false, false },
  { u8"Baram Kayan",                                                "kys",     "",   "",    false, false },
  { u8"Barama",                                                     "bbg",     "",   "",    false, false },
  { u8"Barambu",                                                    "brm",     "",   "",    false, false },
  { u8"Baramu",                                                     "bmz",     "",   "",    false, false },
  { u8"Barapasi",                                                   "brp",     "",   "",    false, false },
  { u8"Baras",                                                      "brs",     "",   "",    false, false },
  { u8"Barasana-Eduria",                                            "bsn",     "",   "",    false, false },
  { u8"Barbacoas",                                                  "bpb",     "",   "",    false, true  },
  { u8"Barbaram",                                                   "vmb",     "",   "",    false, false },
  { u8"Barbareño",                                                  "boi",     "",   "",    false, false },
  { u8"Barclayville Grebo",                                         "gry",     "",   "",    false, false },
  { u8"Bardi",                                                      "bcj",     "",   "",    false, false },
  { u8"Barein",                                                     "bva",     "",   "",    false, false },
  { u8"Bargam",                                                     "mlp",     "",   "",    false, false },
  { u8"Bari",                                                       "bfa",     "",   "",    false, false },
  { u8"Bariai",                                                     "bch",     "",   "",    false, false },
  { u8"Bariji",                                                     "bjc",     "",   "",    false, false },
  { u8"Barikanchi",                                                 "bxo",     "",   "",    false, false },
  { u8"Barikewa",                                                   "jbk",     "",   "",    false, false },
  { u8"Barok",                                                      "bjk",     "",   "",    false, false },
  { u8"Barombi",                                                    "bbi",     "",   "",    false, false },
  { u8"Barro Negro Tunebo",                                         "tbn",     "",   "",    false, false },
  { u8"Barrow Point",                                               "bpt",     "",   "",    false, false },
  { u8"Baruga",                                                     "bjz",     "",   "",    false, false },
  { u8"Baruya",                                                     "byr",     "",   "",    false, false },
  { u8"Barwe",                                                      "bwg",     "",   "",    false, false },
  { u8"Barzani Jewish Neo-Aramaic",                                 "bjf",     "",   "",    false, false },
  { u8"Baré",                                                       "bae",     "",   "",    false, false },
  { u8"Barí",                                                       "mot",     "",   "",    false, false },
  { u8"Basa (Cameroon)",                                            "bas",     "",   "",    true,  false },
  { u8"Basa (Nigeria)",                                             "bzw",     "",   "",    false, false },
  { u8"Basa-Gumna",                                                 "bsl",     "",   "",    false, false },
  { u8"Basa-Gurmana",                                               "buj",     "",   "",    false, false },
  { u8"Basap",                                                      "bdb",     "",   "",    false, false },
  { u8"Basay",                                                      "byq",     "",   "",    false, false },
  { u8"Bashkardi",                                                  "bsg",     "",   "",    false, false },
  { u8"Bashkir",                                                    "bak",     "ba", "",    true,  false },
  { u8"Basketo",                                                    "bst",     "",   "",    false, false },
  { u8"Basque (family)",                                            "euq",     "",   "",    false, false },
  { u8"Basque",                                                     "baq",     "eu", "eus", true,  false },
  { u8"Bassa",                                                      "bsq",     "",   "",    false, false },
  { u8"Bassa-Kontagora",                                            "bsr",     "",   "",    false, false },
  { u8"Bassari",                                                    "bsc",     "",   "",    false, false },
  { u8"Bassossi",                                                   "bsi",     "",   "",    false, false },
  { u8"Bata",                                                       "bta",     "",   "",    false, false },
  { u8"Batad Ifugao",                                               "ifb",     "",   "",    false, false },
  { u8"Batak Alas-Kluet",                                           "btz",     "",   "",    false, false },
  { u8"Batak Angkola",                                              "akb",     "",   "",    false, false },
  { u8"Batak Dairi",                                                "btd",     "",   "",    false, false },
  { u8"Batak Karo",                                                 "btx",     "",   "",    false, false },
  { u8"Batak Mandailing",                                           "btm",     "",   "",    false, false },
  { u8"Batak Simalungun",                                           "bts",     "",   "",    false, false },
  { u8"Batak Toba",                                                 "bbc",     "",   "",    false, false },
  { u8"Batak languages",                                            "btk",     "",   "",    true,  false },
  { u8"Batak",                                                      "bya",     "",   "",    false, false },
  { u8"Batanga",                                                    "bnm",     "",   "",    false, false },
  { u8"Batek",                                                      "btq",     "",   "",    false, false },
  { u8"Bateri",                                                     "btv",     "",   "",    false, false },
  { u8"Bathari",                                                    "bhm",     "",   "",    false, false },
  { u8"Bati (Cameroon)",                                            "btc",     "",   "",    false, false },
  { u8"Bati (Indonesia)",                                           "bvt",     "",   "",    false, false },
  { u8"Batjala",                                                    "xby",     "",   "",    false, false },
  { u8"Bats",                                                       "bbl",     "",   "",    false, false },
  { u8"Batu",                                                       "btu",     "",   "",    false, false },
  { u8"Batui",                                                      "zbt",     "",   "",    false, false },
  { u8"Batuley",                                                    "bay",     "",   "",    false, false },
  { u8"Bau Bidayuh",                                                "sne",     "",   "",    false, false },
  { u8"Bau",                                                        "bbd",     "",   "",    false, false },
  { u8"Bauchi",                                                     "bsf",     "",   "",    false, false },
  { u8"Bauni",                                                      "bpe",     "",   "",    false, false },
  { u8"Baure",                                                      "brg",     "",   "",    false, false },
  { u8"Bauria",                                                     "bge",     "",   "",    false, false },
  { u8"Bauwaki",                                                    "bwk",     "",   "",    false, false },
  { u8"Bauzi",                                                      "bvz",     "",   "",    false, false },
  { u8"Bavarian",                                                   "bar",     "",   "",    false, false },
  { u8"Bawm Chin",                                                  "bgr",     "",   "",    false, false },
  { u8"Bay Miwok",                                                  "mkq",     "",   "",    false, false },
  { u8"Bayali",                                                     "bjy",     "",   "",    false, false },
  { u8"Baybayanon",                                                 "bvy",     "",   "",    false, false },
  { u8"Baygo",                                                      "byg",     "",   "",    false, false },
  { u8"Bayono",                                                     "byl",     "",   "",    false, false },
  { u8"Bayot",                                                      "bda",     "",   "",    false, false },
  { u8"Bayungu",                                                    "bxj",     "",   "",    false, false },
  { u8"Bazigar",                                                    "bfr",     "",   "",    false, false },
  { u8"Beami",                                                      "beo",     "",   "",    false, false },
  { u8"Beaver",                                                     "bea",     "",   "",    false, false },
  { u8"Beba",                                                       "bfp",     "",   "",    false, false },
  { u8"Bebele",                                                     "beb",     "",   "",    false, false },
  { u8"Bebeli",                                                     "bek",     "",   "",    false, false },
  { u8"Bebil",                                                      "bxp",     "",   "",    false, false },
  { u8"Bedjond",                                                    "bjv",     "",   "",    false, false },
  { u8"Bedoanas",                                                   "bed",     "",   "",    false, false },
  { u8"Beeke",                                                      "bkf",     "",   "",    false, false },
  { u8"Beele",                                                      "bxq",     "",   "",    false, false },
  { u8"Beembe",                                                     "beq",     "",   "",    false, false },
  { u8"Beezen",                                                     "bnz",     "",   "",    false, false },
  { u8"Befang",                                                     "bby",     "",   "",    false, false },
  { u8"Beginci",                                                    "ebc",     "",   "",    false, false },
  { u8"Beja",                                                       "bej",     "",   "",    true,  false },
  { u8"Bekati'",                                                    "bei",     "",   "",    false, false },
  { u8"Bekwarra",                                                   "bkv",     "",   "",    false, false },
  { u8"Bekwel",                                                     "bkw",     "",   "",    false, false },
  { u8"Belait",                                                     "beg",     "",   "",    false, false },
  { u8"Belanda Bor",                                                "bxb",     "",   "",    false, false },
  { u8"Belanda Viri",                                               "bvi",     "",   "",    false, false },
  { u8"Belarusian",                                                 "bel",     "be", "",    true,  false },
  { u8"Belhariya",                                                  "byw",     "",   "",    false, false },
  { u8"Beli (Papua New Guinea)",                                    "bey",     "",   "",    false, false },
  { u8"Beli (South Sudan)",                                         "blm",     "",   "",    false, false },
  { u8"Belize Kriol English",                                       "bzj",     "",   "",    false, false },
  { u8"Bella Coola",                                                "blc",     "",   "",    false, false },
  { u8"Bellari",                                                    "brw",     "",   "",    false, false },
  { u8"Belning",                                                    "glb",     "",   "",    false, false },
  { u8"Bemba (Democratic Republic of Congo)",                       "bmy",     "",   "",    false, true  },
  { u8"Bemba (Zambia)",                                             "bem",     "",   "",    true,  false },
  { u8"Bembe",                                                      "bmb",     "",   "",    false, false },
  { u8"Ben Tey Dogon",                                              "dbt",     "",   "",    false, false },
  { u8"Bena (Nigeria)",                                             "yun",     "",   "",    false, false },
  { u8"Bena (Tanzania)",                                            "bez",     "",   "",    false, false },
  { u8"Benabena",                                                   "bef",     "",   "",    false, false },
  { u8"Benamanga",                                                  "egm",     "",   "",    false, false },
  { u8"Bench",                                                      "bcq",     "",   "",    false, false },
  { u8"Bende",                                                      "bdp",     "",   "",    false, false },
  { u8"Bendi",                                                      "bct",     "",   "",    false, false },
  { u8"Beng",                                                       "nhb",     "",   "",    false, false },
  { u8"Benga",                                                      "bng",     "",   "",    false, false },
  { u8"Bengali",                                                    "ben",     "bn", "",    true,  false },
  { u8"Benggoi",                                                    "bgy",     "",   "",    false, false },
  { u8"Bengkala Sign Language",                                     "bqy",     "",   "",    false, false },
  { u8"Bentong",                                                    "bnu",     "",   "",    false, false },
  { u8"Benyadu'",                                                   "byd",     "",   "",    false, false },
  { u8"Beothuk",                                                    "bue",     "",   "",    false, false },
  { u8"Bepour",                                                     "bie",     "",   "",    false, false },
  { u8"Berakou",                                                    "bxv",     "",   "",    false, false },
  { u8"Berau Malay",                                                "bve",     "",   "",    false, false },
  { u8"Berber languages",                                           "ber",     "",   "",    true,  false },
  { u8"Berbice Creole Dutch",                                       "brc",     "",   "",    false, false },
  { u8"Berik",                                                      "bkl",     "",   "",    false, false },
  { u8"Berinomo",                                                   "bit",     "",   "",    false, false },
  { u8"Berom",                                                      "bom",     "",   "",    false, false },
  { u8"Berta",                                                      "wti",     "",   "",    false, false },
  { u8"Berti",                                                      "byt",     "",   "",    false, false },
  { u8"Besisi",                                                     "mhe",     "",   "",    false, false },
  { u8"Besme",                                                      "bes",     "",   "",    false, false },
  { u8"Besoa",                                                      "bep",     "",   "",    false, false },
  { u8"Betaf",                                                      "bfe",     "",   "",    false, false },
  { u8"Betawi",                                                     "bew",     "",   "",    false, false },
  { u8"Bete",                                                       "byf",     "",   "",    false, false },
  { u8"Bete-Bendi",                                                 "btt",     "",   "",    false, false },
  { u8"Beti (Cameroon)",                                            "btb",     "",   "",    false, true  },
  { u8"Beti (Côte d'Ivoire)",                                       "eot",     "",   "",    false, false },
  { u8"Betta Kurumba",                                              "xub",     "",   "",    false, false },
  { u8"Bezhta",                                                     "kap",     "",   "",    false, false },
  { u8"Bhadrawahi",                                                 "bhd",     "",   "",    false, false },
  { u8"Bhalay",                                                     "bhx",     "",   "",    false, false },
  { u8"Bharia",                                                     "bha",     "",   "",    false, false },
  { u8"Bhatola",                                                    "btl",     "",   "",    false, true  },
  { u8"Bhatri",                                                     "bgw",     "",   "",    false, false },
  { u8"Bhattiyali",                                                 "bht",     "",   "",    false, false },
  { u8"Bhaya",                                                      "bhe",     "",   "",    false, false },
  { u8"Bhele",                                                      "bhy",     "",   "",    false, false },
  { u8"Bhilali",                                                    "bhi",     "",   "",    false, false },
  { u8"Bhili",                                                      "bhb",     "",   "",    false, false },
  { u8"Bhojpuri",                                                   "bho",     "",   "",    true,  false },
  { u8"Bhoti Kinnauri",                                             "nes",     "",   "",    false, false },
  { u8"Bhujel",                                                     "byh",     "",   "",    false, false },
  { u8"Bhunjia",                                                    "bhu",     "",   "",    false, false },
  { u8"Biafada",                                                    "bif",     "",   "",    false, false },
  { u8"Biage",                                                      "bdf",     "",   "",    false, false },
  { u8"Biak",                                                       "bhw",     "",   "",    false, false },
  { u8"Biali",                                                      "beh",     "",   "",    false, false },
  { u8"Bian Marind",                                                "bpv",     "",   "",    false, false },
  { u8"Biangai",                                                    "big",     "",   "",    false, false },
  { u8"Biao Mon",                                                   "bmt",     "",   "",    false, false },
  { u8"Biao",                                                       "byk",     "",   "",    false, false },
  { u8"Biao-Jiao Mien",                                             "bje",     "",   "",    false, false },
  { u8"Biatah Bidayuh",                                             "bth",     "",   "",    false, false },
  { u8"Bibbulman",                                                  "xbp",     "",   "",    false, false },
  { u8"Bidhawal",                                                   "ihw",     "",   "",    false, false },
  { u8"Bidiyo",                                                     "bid",     "",   "",    false, false },
  { u8"Bidjara",                                                    "bym",     "",   "",    false, false },
  { u8"Bidyogo",                                                    "bjg",     "",   "",    false, false },
  { u8"Biem",                                                       "bmc",     "",   "",    false, false },
  { u8"Bierebo",                                                    "bnk",     "",   "",    false, false },
  { u8"Bieria",                                                     "brj",     "",   "",    false, false },
  { u8"Biete",                                                      "biu",     "",   "",    false, false },
  { u8"Big Nambas",                                                 "nmb",     "",   "",    false, false },
  { u8"Biga",                                                       "bhc",     "",   "",    false, false },
  { u8"Bigambal",                                                   "xbe",     "",   "",    false, false },
  { u8"Bih",                                                        "ibh",     "",   "",    false, false },
  { u8"Bihari languages",                                           "bih",     "bh", "",    true,  false },
  { u8"Bijim",                                                      "jbm",     "",   "",    false, false },
  { u8"Bijori",                                                     "bix",     "",   "",    false, false },
  { u8"Bikaru",                                                     "bic",     "",   "",    false, true  },
  { u8"Bikol",                                                      "bik",     "",   "",    true,  false },
  { u8"Bikya",                                                      "byb",     "",   "",    false, false },
  { u8"Bila",                                                       "bip",     "",   "",    false, false },
  { u8"Bilakura",                                                   "bql",     "",   "",    false, false },
  { u8"Bilaspuri",                                                  "kfs",     "",   "",    false, false },
  { u8"Bilba",                                                      "bpz",     "",   "",    false, false },
  { u8"Bilbil",                                                     "brz",     "",   "",    false, false },
  { u8"Bile",                                                       "bil",     "",   "",    false, false },
  { u8"Bilin",                                                      "byn",     "",   "",    true,  false },
  { u8"Bilma Kanuri",                                               "bms",     "",   "",    false, false },
  { u8"Biloxi",                                                     "bll",     "",   "",    false, false },
  { u8"Bilua",                                                      "blb",     "",   "",    false, false },
  { u8"Bilur",                                                      "bxf",     "",   "",    false, false },
  { u8"Bima",                                                       "bhp",     "",   "",    false, false },
  { u8"Bimin",                                                      "bhl",     "",   "",    false, false },
  { u8"Bimoba",                                                     "bim",     "",   "",    false, false },
  { u8"Bina (Nigeria)",                                             "byj",     "",   "",    false, false },
  { u8"Bina (Papua New Guinea)",                                    "bmn",     "",   "",    false, false },
  { u8"Binahari",                                                   "bxz",     "",   "",    false, false },
  { u8"Binandere",                                                  "bhg",     "",   "",    false, false },
  { u8"Bindal",                                                     "xbd",     "",   "",    false, false },
  { u8"Bine",                                                       "bon",     "",   "",    false, false },
  { u8"Bini",                                                       "bin",     "",   "",    true,  false },
  { u8"Binji",                                                      "bpj",     "",   "",    false, false },
  { u8"Binongan Itneg",                                             "itb",     "",   "",    false, false },
  { u8"Bintauna",                                                   "bne",     "",   "",    false, false },
  { u8"Bintulu",                                                    "bny",     "",   "",    false, false },
  { u8"Binukid",                                                    "bkd",     "",   "",    false, false },
  { u8"Binumarien",                                                 "bjr",     "",   "",    false, false },
  { u8"Bipi",                                                       "biq",     "",   "",    false, false },
  { u8"Bira",                                                       "brf",     "",   "",    false, false },
  { u8"Birale",                                                     "bxe",     "",   "",    false, false },
  { u8"Birao",                                                      "brr",     "",   "",    false, false },
  { u8"Birgit",                                                     "btf",     "",   "",    false, false },
  { u8"Birhor",                                                     "biy",     "",   "",    false, false },
  { u8"Biri",                                                       "bzr",     "",   "",    false, false },
  { u8"Biritai",                                                    "bqq",     "",   "",    false, false },
  { u8"Birked",                                                     "brk",     "",   "",    false, false },
  { u8"Birri",                                                      "bvq",     "",   "",    false, false },
  { u8"Birrpayi",                                                   "xbj",     "",   "",    false, false },
  { u8"Birwa",                                                      "brl",     "",   "",    false, false },
  { u8"Biseni",                                                     "ije",     "",   "",    false, false },
  { u8"Bishnupriya",                                                "bpy",     "",   "",    false, false },
  { u8"Bishuo",                                                     "bwh",     "",   "",    false, false },
  { u8"Bisis",                                                      "bnw",     "",   "",    false, false },
  { u8"Bislama",                                                    "bis",     "bi", "",    true,  false },
  { u8"Bisorio",                                                    "bir",     "",   "",    false, false },
  { u8"Bissa",                                                      "bib",     "",   "",    false, false },
  { u8"Bisu",                                                       "bzi",     "",   "",    false, false },
  { u8"Bit",                                                        "bgk",     "",   "",    false, false },
  { u8"Bitare",                                                     "brt",     "",   "",    false, false },
  { u8"Bitur",                                                      "mcc",     "",   "",    false, false },
  { u8"Biwat",                                                      "bwm",     "",   "",    false, false },
  { u8"Biyo",                                                       "byo",     "",   "",    false, false },
  { u8"Biyom",                                                      "bpm",     "",   "",    false, false },
  { u8"Blablanga",                                                  "blp",     "",   "",    false, false },
  { u8"Blafe",                                                      "bfh",     "",   "",    false, false },
  { u8"Blagar",                                                     "beu",     "",   "",    false, false },
  { u8"Blang",                                                      "blr",     "",   "",    false, false },
  { u8"Blissymbols",                                                "zbl",     "",   "",    true,  false },
  { u8"Bo (Laos)",                                                  "bgl",     "",   "",    false, false },
  { u8"Bo (Papua New Guinea)",                                      "bpw",     "",   "",    false, false },
  { u8"Bo-Rukul",                                                   "mae",     "",   "",    false, false },
  { u8"Bo-Ung",                                                     "mux",     "",   "",    false, false },
  { u8"Boano (Maluku)",                                             "bzn",     "",   "",    false, false },
  { u8"Boano (Sulawesi)",                                           "bzl",     "",   "",    false, false },
  { u8"Bobongko",                                                   "bgb",     "",   "",    false, false },
  { u8"Bobot",                                                      "bty",     "",   "",    false, false },
  { u8"Bodo (Central African Republic)",                            "boy",     "",   "",    false, false },
  { u8"Bodo (India)",                                               "brx",     "",   "",    false, false },
  { u8"Bodo Gadaba",                                                "gbj",     "",   "",    false, false },
  { u8"Bodo Parja",                                                 "bdv",     "",   "",    false, false },
  { u8"Bofi",                                                       "bff",     "",   "",    false, false },
  { u8"Boga",                                                       "bvw",     "",   "",    false, false },
  { u8"Bogaya",                                                     "boq",     "",   "",    false, false },
  { u8"Boghom",                                                     "bux",     "",   "",    false, false },
  { u8"Boguru",                                                     "bqu",     "",   "",    false, false },
  { u8"Bohtan Neo-Aramaic",                                         "bhn",     "",   "",    false, false },
  { u8"Boikin",                                                     "bzf",     "",   "",    false, false },
  { u8"Bokha",                                                      "ybk",     "",   "",    false, false },
  { u8"Boko (Benin)",                                               "bqc",     "",   "",    false, false },
  { u8"Boko (Democratic Republic of Congo)",                        "bkp",     "",   "",    false, false },
  { u8"Bokobaru",                                                   "bus",     "",   "",    false, false },
  { u8"Bokoto",                                                     "bdt",     "",   "",    false, false },
  { u8"Bokyi",                                                      "bky",     "",   "",    false, false },
  { u8"Bola",                                                       "bnp",     "",   "",    false, false },
  { u8"Bolango",                                                    "bld",     "",   "",    false, false },
  { u8"Bole",                                                       "bol",     "",   "",    false, false },
  { u8"Bolgarian",                                                  "xbo",     "",   "",    false, false },
  { u8"Bolgo",                                                      "bvo",     "",   "",    false, false },
  { u8"Bolia",                                                      "bli",     "",   "",    false, false },
  { u8"Bolinao",                                                    "smk",     "",   "",    false, false },
  { u8"Bolivian Sign Language",                                     "bvl",     "",   "",    false, false },
  { u8"Boloki",                                                     "bkt",     "",   "",    false, false },
  { u8"Bolon",                                                      "bof",     "",   "",    false, false },
  { u8"Bolondo",                                                    "bzm",     "",   "",    false, false },
  { u8"Bolongan",                                                   "blj",     "",   "",    false, false },
  { u8"Bolyu",                                                      "ply",     "",   "",    false, false },
  { u8"Bom-Kim",                                                    "bmf",     "",   "",    false, false },
  { u8"Boma",                                                       "boh",     "",   "",    false, false },
  { u8"Bomboli",                                                    "bml",     "",   "",    false, false },
  { u8"Bomboma",                                                    "bws",     "",   "",    false, false },
  { u8"Bomitaba",                                                   "zmx",     "",   "",    false, false },
  { u8"Bomu",                                                       "bmq",     "",   "",    false, false },
  { u8"Bomwali",                                                    "bmw",     "",   "",    false, false },
  { u8"Bon Gula",                                                   "glc",     "",   "",    false, false },
  { u8"Bonan",                                                      "peh",     "",   "",    false, false },
  { u8"Bondei",                                                     "bou",     "",   "",    false, false },
  { u8"Bondo",                                                      "bfw",     "",   "",    false, false },
  { u8"Bondoukou Kulango",                                          "kzc",     "",   "",    false, false },
  { u8"Bondum Dom Dogon",                                           "dbu",     "",   "",    false, false },
  { u8"Bonerate",                                                   "bna",     "",   "",    false, false },
  { u8"Bonerif",                                                    "bnv",     "",   "",    false, false },
  { u8"Bonggi",                                                     "bdg",     "",   "",    false, false },
  { u8"Bonggo",                                                     "bpg",     "",   "",    false, false },
  { u8"Bongili",                                                    "bui",     "",   "",    false, false },
  { u8"Bongo",                                                      "bot",     "",   "",    false, false },
  { u8"Bongu",                                                      "bpu",     "",   "",    false, false },
  { u8"Bonjo",                                                      "bok",     "",   "",    false, false },
  { u8"Bonkeng",                                                    "bvg",     "",   "",    false, false },
  { u8"Bonkiman",                                                   "bop",     "",   "",    false, false },
  { u8"Bontok",                                                     "bnc",     "",   "",    false, false },
  { u8"Bookan",                                                     "bnb",     "",   "",    false, false },
  { u8"Boon",                                                       "bnl",     "",   "",    false, false },
  { u8"Boor",                                                       "bvf",     "",   "",    false, false },
  { u8"Bora",                                                       "boa",     "",   "",    false, false },
  { u8"Borana-Arsi-Guji Oromo",                                     "gax",     "",   "",    false, false },
  { u8"Border Kuna",                                                "kvn",     "",   "",    false, false },
  { u8"Borei",                                                      "gai",     "",   "",    false, false },
  { u8"Borgu Fulfulde",                                             "fue",     "",   "",    false, false },
  { u8"Borna (Democratic Republic of Congo)",                       "bxx",     "",   "",    false, true  },
  { u8"Boro (Ethiopia)",                                            "bwo",     "",   "",    false, false },
  { u8"Boro (Ghana)",                                               "xxb",     "",   "",    false, false },
  { u8"Borong",                                                     "ksr",     "",   "",    false, false },
  { u8"Boruca",                                                     "brn",     "",   "",    false, false },
  { u8"Borôro",                                                     "bor",     "",   "",    false, false },
  { u8"Boselewa",                                                   "bwf",     "",   "",    false, false },
  { u8"Bosngun",                                                    "bqs",     "",   "",    false, false },
  { u8"Bosnian",                                                    "bos",     "bs", "",    true,  false },
  { u8"Bote-Majhi",                                                 "bmj",     "",   "",    false, false },
  { u8"Botlikh",                                                    "bph",     "",   "",    false, false },
  { u8"Botolan Sambal",                                             "sbl",     "",   "",    false, false },
  { u8"Bouna Kulango",                                              "nku",     "",   "",    false, false },
  { u8"Bouni",                                                      "suo",     "",   "",    false, false },
  { u8"Bouyei",                                                     "pcc",     "",   "",    false, false },
  { u8"Bozaba",                                                     "bzo",     "",   "",    false, false },
  { u8"Bragat",                                                     "aof",     "",   "",    false, false },
  { u8"Brahui",                                                     "brh",     "",   "",    false, false },
  { u8"Braj",                                                       "bra",     "",   "",    true,  false },
  { u8"Brao",                                                       "brb",     "",   "",    false, false },
  { u8"Brazilian Sign Language",                                    "bzs",     "",   "",    false, false },
  { u8"Brem",                                                       "buq",     "",   "",    false, false },
  { u8"Breri",                                                      "brq",     "",   "",    false, false },
  { u8"Breton",                                                     "bre",     "br", "",    true,  false },
  { u8"Bribri Sign Language",                                       "rib",     "",   "",    false, false },
  { u8"Bribri",                                                     "bzd",     "",   "",    false, false },
  { u8"Brithenig",                                                  "bzt",     "",   "",    false, false },
  { u8"British Sign Language",                                      "bfi",     "",   "",    false, false },
  { u8"Brokkat",                                                    "bro",     "",   "",    false, false },
  { u8"Brokpake",                                                   "sgt",     "",   "",    false, false },
  { u8"Brokskat",                                                   "bkk",     "",   "",    false, false },
  { u8"Brooke's Point Palawano",                                    "plw",     "",   "",    false, false },
  { u8"Broome Pearling Lugger Pidgin",                              "bpl",     "",   "",    false, false },
  { u8"Brunca Sign Language",                                       "rnb",     "",   "",    false, false },
  { u8"Brunei Bisaya",                                              "bsb",     "",   "",    false, false },
  { u8"Brunei",                                                     "kxd",     "",   "",    false, false },
  { u8"Bruny Island Tasmanian",                                     "xpz",     "",   "",    false, false },
  { u8"Bu (Bauchi State)",                                          "zbu",     "",   "",    false, false },
  { u8"Bu (Kaduna State)",                                          "jid",     "",   "",    false, false },
  { u8"Bu-Nao Bunu",                                                "bwx",     "",   "",    false, false },
  { u8"Bua",                                                        "bub",     "",   "",    false, false },
  { u8"Bualkhaw Chin",                                              "cbl",     "",   "",    false, false },
  { u8"Buamu",                                                      "box",     "",   "",    false, false },
  { u8"Bube",                                                       "bvb",     "",   "",    false, false },
  { u8"Bubi",                                                       "buw",     "",   "",    false, false },
  { u8"Bubia",                                                      "bbx",     "",   "",    false, false },
  { u8"Budeh Stieng",                                               "stt",     "",   "",    false, false },
  { u8"Budibud",                                                    "btp",     "",   "",    false, false },
  { u8"Budong-Budong",                                              "bdx",     "",   "",    false, false },
  { u8"Budu",                                                       "buu",     "",   "",    false, false },
  { u8"Budukh",                                                     "bdk",     "",   "",    false, false },
  { u8"Buduma",                                                     "bdm",     "",   "",    false, false },
  { u8"Budza",                                                      "bja",     "",   "",    false, false },
  { u8"Bugan",                                                      "bbh",     "",   "",    false, false },
  { u8"Bugawac",                                                    "buk",     "",   "",    false, false },
  { u8"Bughotu",                                                    "bgt",     "",   "",    false, false },
  { u8"Buginese",                                                   "bug",     "",   "",    true,  false },
  { u8"Buglere",                                                    "sab",     "",   "",    false, false },
  { u8"Bugun",                                                      "bgg",     "",   "",    false, false },
  { u8"Buhi'non Bikol",                                             "ubl",     "",   "",    false, false },
  { u8"Buhid",                                                      "bku",     "",   "",    false, false },
  { u8"Buhutu",                                                     "bxh",     "",   "",    false, false },
  { u8"Bukar-Sadung Bidayuh",                                       "sdo",     "",   "",    false, false },
  { u8"Bukat",                                                      "bvk",     "",   "",    false, false },
  { u8"Bukharic",                                                   "bhh",     "",   "",    false, false },
  { u8"Bukit Malay",                                                "bvu",     "",   "",    false, false },
  { u8"Bukitan",                                                    "bkn",     "",   "",    false, false },
  { u8"Bukiyip",                                                    "ape",     "",   "",    false, false },
  { u8"Buksa",                                                      "tkb",     "",   "",    false, false },
  { u8"Bukusu",                                                     "bxk",     "",   "",    false, false },
  { u8"Bukwen",                                                     "buz",     "",   "",    false, false },
  { u8"Bulgarian Sign Language",                                    "bqn",     "",   "",    false, false },
  { u8"Bulgarian",                                                  "bul",     "bg", "",    true,  false },
  { u8"Bulgebi",                                                    "bmp",     "",   "",    false, false },
  { u8"Buli (Ghana)",                                               "bwu",     "",   "",    false, false },
  { u8"Buli (Indonesia)",                                           "bzq",     "",   "",    false, false },
  { u8"Bullom So",                                                  "buy",     "",   "",    false, false },
  { u8"Bulo Stieng",                                                "sti",     "",   "",    false, false },
  { u8"Bulu (Cameroon)",                                            "bum",     "",   "",    false, false },
  { u8"Bulu (Papua New Guinea)",                                    "bjl",     "",   "",    false, false },
  { u8"Bum",                                                        "bmv",     "",   "",    false, false },
  { u8"Bumaji",                                                     "byp",     "",   "",    false, false },
  { u8"Bumang",                                                     "bvp",     "",   "",    false, false },
  { u8"Bumbita Arapesh",                                            "aon",     "",   "",    false, false },
  { u8"Bumthangkha",                                                "kjz",     "",   "",    false, false },
  { u8"Bun",                                                        "buv",     "",   "",    false, false },
  { u8"Buna",                                                       "bvn",     "",   "",    false, false },
  { u8"Bunak",                                                      "bfn",     "",   "",    false, false },
  { u8"Bunama",                                                     "bdd",     "",   "",    false, false },
  { u8"Bundeli",                                                    "bns",     "",   "",    false, false },
  { u8"Bung",                                                       "bqd",     "",   "",    false, false },
  { u8"Bungain",                                                    "but",     "",   "",    false, false },
  { u8"Bunganditj",                                                 "xbg",     "",   "",    false, false },
  { u8"Bungku",                                                     "bkz",     "",   "",    false, false },
  { u8"Bungu",                                                      "wun",     "",   "",    false, false },
  { u8"Bunoge Dogon",                                               "dgb",     "",   "",    false, false },
  { u8"Bunuba",                                                     "bck",     "",   "",    false, false },
  { u8"Bunun",                                                      "bnn",     "",   "",    false, false },
  { u8"Buol",                                                       "blf",     "",   "",    false, false },
  { u8"Bura-Pabir",                                                 "bwr",     "",   "",    false, false },
  { u8"Burak",                                                      "bys",     "",   "",    false, false },
  { u8"Buraka",                                                     "bkg",     "",   "",    false, false },
  { u8"Burarra",                                                    "bvr",     "",   "",    false, false },
  { u8"Burate",                                                     "bti",     "",   "",    false, false },
  { u8"Burduna",                                                    "bxn",     "",   "",    false, false },
  { u8"Bure",                                                       "bvh",     "",   "",    false, false },
  { u8"Buriat",                                                     "bua",     "",   "",    true,  false },
  { u8"Burji",                                                      "bji",     "",   "",    false, false },
  { u8"Burmbar",                                                    "vrt",     "",   "",    false, false },
  { u8"Burmese",                                                    "bur",     "my", "mya", true,  false },
  { u8"Burmeso",                                                    "bzu",     "",   "",    false, false },
  { u8"Buru (Indonesia)",                                           "mhs",     "",   "",    false, false },
  { u8"Buru (Nigeria)",                                             "bqw",     "",   "",    false, false },
  { u8"Burui",                                                      "bry",     "",   "",    false, false },
  { u8"Burumakok",                                                  "aip",     "",   "",    false, false },
  { u8"Burun",                                                      "bdi",     "",   "",    false, false },
  { u8"Burundian Sign Language",                                    "lsb",     "",   "",    false, false },
  { u8"Burunge",                                                    "bds",     "",   "",    false, false },
  { u8"Burushaski",                                                 "bsk",     "",   "",    false, false },
  { u8"Burusu",                                                     "bqr",     "",   "",    false, false },
  { u8"Buruwai",                                                    "asi",     "",   "",    false, false },
  { u8"Busa",                                                       "bqp",     "",   "",    false, false },
  { u8"Busam",                                                      "bxs",     "",   "",    false, false },
  { u8"Busami",                                                     "bsm",     "",   "",    false, false },
  { u8"Busang Kayan",                                               "bfg",     "",   "",    false, false },
  { u8"Bushi",                                                      "buc",     "",   "",    false, false },
  { u8"Bushoong",                                                   "buf",     "",   "",    false, false },
  { u8"Buso",                                                       "bso",     "",   "",    false, false },
  { u8"Busoa",                                                      "bup",     "",   "",    false, false },
  { u8"Bussa",                                                      "dox",     "",   "",    false, false },
  { u8"Busuu",                                                      "bju",     "",   "",    false, false },
  { u8"Butbut Kalinga",                                             "kyb",     "",   "",    false, false },
  { u8"Butmas-Tur",                                                 "bnr",     "",   "",    false, false },
  { u8"Butuanon",                                                   "btw",     "",   "",    false, false },
  { u8"Buwal",                                                      "bhs",     "",   "",    false, false },
  { u8"Buya",                                                       "byy",     "",   "",    false, true  },
  { u8"Buyu",                                                       "byi",     "",   "",    false, false },
  { u8"Buyuan Jinuo",                                               "jiy",     "",   "",    false, false },
  { u8"Bwa",                                                        "bww",     "",   "",    false, false },
  { u8"Bwaidoka",                                                   "bwd",     "",   "",    false, false },
  { u8"Bwanabwana",                                                 "tte",     "",   "",    false, false },
  { u8"Bwatoo",                                                     "bwa",     "",   "",    false, false },
  { u8"Bwe Karen",                                                  "bwe",     "",   "",    false, false },
  { u8"Bwela",                                                      "bwl",     "",   "",    false, false },
  { u8"Bwile",                                                      "bwc",     "",   "",    false, false },
  { u8"Bwisi",                                                      "bwz",     "",   "",    false, false },
  { u8"Byangsi",                                                    "bee",     "",   "",    false, false },
  { u8"Byep",                                                       "mkk",     "",   "",    false, false },
  { u8"Bädi Kanum",                                                 "khd",     "",   "",    false, false },
  { u8"C'Lela",                                                     "dri",     "",   "",    false, false },
  { u8"Caac",                                                       "msq",     "",   "",    false, false },
  { u8"Cabiyarí",                                                   "cbb",     "",   "",    false, false },
  { u8"Cabécar",                                                    "cjp",     "",   "",    false, false },
  { u8"Cacaloxtepec Mixtec",                                        "miu",     "",   "",    false, false },
  { u8"Cacaopera",                                                  "ccr",     "",   "",    false, false },
  { u8"Cacgia Roglai",                                              "roc",     "",   "",    false, false },
  { u8"Cacua",                                                      "cbv",     "",   "",    false, false },
  { u8"Caddo",                                                      "cad",     "",   "",    true,  false },
  { u8"Caddoan languages",                                          "cdd",     "",   "",    false, false },
  { u8"Cafundo Creole",                                             "ccd",     "",   "",    false, false },
  { u8"Cagua",                                                      "cbh",     "",   "",    false, true  },
  { u8"Cahuarano",                                                  "cah",     "",   "",    false, false },
  { u8"Cahuilla",                                                   "chl",     "",   "",    false, false },
  { u8"Cajamarca Quechua",                                          "qvc",     "",   "",    false, false },
  { u8"Cajatambo North Lima Quechua",                               "qvl",     "",   "",    false, false },
  { u8"Cajonos Zapotec",                                            "zad",     "",   "",    false, false },
  { u8"Cajun French",                                               "frc",     "",   "",    false, false },
  { u8"Caka",                                                       "ckx",     "",   "",    false, false },
  { u8"Cakchiquel-Quiché Mixed Language",                           "ckz",     "",   "",    false, false },
  { u8"Cakfem-Mushere",                                             "cky",     "",   "",    false, false },
  { u8"Calamian Tagbanwa",                                          "tbk",     "",   "",    false, false },
  { u8"Calderón Highland Quichua",                                  "qud",     "",   "",    false, false },
  { u8"Callawalla",                                                 "caw",     "",   "",    false, false },
  { u8"Caluyanun",                                                  "clu",     "",   "",    false, false },
  { u8"Caló",                                                       "rmq",     "",   "",    false, false },
  { u8"Caló",                                                       "rmr",     "",   "",    false, true  },
  { u8"Cambodian Sign Language",                                    "csx",     "",   "",    false, false },
  { u8"Cameroon Mambila",                                           "mcu",     "",   "",    false, false },
  { u8"Cameroon Pidgin",                                            "wes",     "",   "",    false, false },
  { u8"Camling",                                                    "rab",     "",   "",    false, false },
  { u8"Campalagian",                                                "cml",     "",   "",    false, false },
  { u8"Campidanese Sardinian",                                      "sro",     "",   "",    false, false },
  { u8"Camsá",                                                      "kbh",     "",   "",    false, false },
  { u8"Camtho",                                                     "cmt",     "",   "",    false, false },
  { u8"Camunic",                                                    "xcc",     "",   "",    false, false },
  { u8"Candoshi-Shapra",                                            "cbu",     "",   "",    false, false },
  { u8"Canela",                                                     "ram",     "",   "",    false, false },
  { u8"Canichana",                                                  "caz",     "",   "",    false, false },
  { u8"Cao Lan",                                                    "mlc",     "",   "",    false, false },
  { u8"Cao Miao",                                                   "cov",     "",   "",    false, false },
  { u8"Capanahua",                                                  "kaq",     "",   "",    false, false },
  { u8"Capiznon",                                                   "cps",     "",   "",    false, false },
  { u8"Cappadocian Greek",                                          "cpg",     "",   "",    false, false },
  { u8"Caquinte",                                                   "cot",     "",   "",    false, false },
  { u8"Car Nicobarese",                                             "caq",     "",   "",    false, false },
  { u8"Cara",                                                       "cfd",     "",   "",    false, false },
  { u8"Carabayo",                                                   "cby",     "",   "",    false, false },
  { u8"Caramanta",                                                  "crf",     "",   "",    false, false },
  { u8"Carapana",                                                   "cbc",     "",   "",    false, false },
  { u8"Carian",                                                     "xcr",     "",   "",    false, false },
  { u8"Caribbean Hindustani",                                       "hns",     "",   "",    false, false },
  { u8"Caribbean Javanese",                                         "jvn",     "",   "",    false, false },
  { u8"Carijona",                                                   "cbd",     "",   "",    false, false },
  { u8"Carolina Algonquian",                                        "crr",     "",   "",    false, false },
  { u8"Carolinian",                                                 "cal",     "",   "",    false, false },
  { u8"Carpathian Romani",                                          "rmc",     "",   "",    false, false },
  { u8"Carrier",                                                    "crx",     "",   "",    false, false },
  { u8"Cashibo-Cacataibo",                                          "cbr",     "",   "",    false, false },
  { u8"Cashinahua",                                                 "cbs",     "",   "",    false, false },
  { u8"Casiguran Dumagat Agta",                                     "dgc",     "",   "",    false, false },
  { u8"Casuarina Coast Asmat",                                      "asc",     "",   "",    false, false },
  { u8"Cataelano Mandaya",                                          "mst",     "",   "",    false, true  },
  { u8"Catalan Sign Language",                                      "csc",     "",   "",    false, false },
  { u8"Catalan",                                                    "cat",     "ca", "",    true,  false },
  { u8"Catawba",                                                    "chc",     "",   "",    false, false },
  { u8"Cauca",                                                      "cca",     "",   "",    false, true  },
  { u8"Caucasian languages",                                        "cau",     "",   "",    true,  false },
  { u8"Cavineña",                                                   "cav",     "",   "",    false, false },
  { u8"Cayubaba",                                                   "cyb",     "",   "",    false, false },
  { u8"Cayuga",                                                     "cay",     "",   "",    false, false },
  { u8"Cayuse",                                                     "xcy",     "",   "",    false, false },
  { u8"Cañar Highland Quichua",                                     "qxr",     "",   "",    false, false },
  { u8"Ca̱hungwa̱rya̱",                                             "nat",     "",   "",    false, false },
  { u8"Cebaara Senoufo",                                            "sef",     "",   "",    false, false },
  { u8"Cebuano",                                                    "ceb",     "",   "",    true,  false },
  { u8"Celtiberian",                                                "xce",     "",   "",    false, false },
  { u8"Celtic languages",                                           "cel",     "",   "",    true,  false },
  { u8"Cemuhî",                                                     "cam",     "",   "",    false, false },
  { u8"Cen",                                                        "cen",     "",   "",    false, false },
  { u8"Central American Indian languages",                          "cai",     "",   "",    true,  false },
  { u8"Central Asmat",                                              "cns",     "",   "",    false, false },
  { u8"Central Atlas Tamazight",                                    "tzm",     "",   "",    false, false },
  { u8"Central Awyu",                                               "awu",     "",   "",    false, false },
  { u8"Central Aymara",                                             "ayr",     "",   "",    false, false },
  { u8"Central Bai",                                                "bca",     "",   "",    false, false },
  { u8"Central Berawan",                                            "zbc",     "",   "",    false, false },
  { u8"Central Bikol",                                              "bcl",     "",   "",    false, false },
  { u8"Central Bontok",                                             "lbk",     "",   "",    false, false },
  { u8"Central Cagayan Agta",                                       "agt",     "",   "",    false, false },
  { u8"Central Grebo",                                              "grv",     "",   "",    false, false },
  { u8"Central Hongshuihe Zhuang",                                  "zch",     "",   "",    false, false },
  { u8"Central Huasteca Nahuatl",                                   "nch",     "",   "",    false, false },
  { u8"Central Huishui Hmong",                                      "hmc",     "",   "",    false, false },
  { u8"Central Kanuri",                                             "knc",     "",   "",    false, false },
  { u8"Central Kurdish",                                            "ckb",     "",   "",    false, false },
  { u8"Central Maewo",                                              "mwo",     "",   "",    false, false },
  { u8"Central Malay",                                              "pse",     "",   "",    false, false },
  { u8"Central Malayo-Polynesian languages",                        "plf",     "",   "",    false, false },
  { u8"Central Masela",                                             "mxz",     "",   "",    false, false },
  { u8"Central Mashan Hmong",                                       "hmm",     "",   "",    false, false },
  { u8"Central Mazahua",                                            "maz",     "",   "",    false, false },
  { u8"Central Melanau",                                            "mel",     "",   "",    false, false },
  { u8"Central Mnong",                                              "cmo",     "",   "",    false, false },
  { u8"Central Nahuatl",                                            "nhn",     "",   "",    false, false },
  { u8"Central Nicobarese",                                         "ncb",     "",   "",    false, false },
  { u8"Central Ojibwa",                                             "ojc",     "",   "",    false, false },
  { u8"Central Okinawan",                                           "ryu",     "",   "",    false, false },
  { u8"Central Palawano",                                           "plc",     "",   "",    false, false },
  { u8"Central Pame",                                               "pbs",     "",   "",    false, false },
  { u8"Central Pashto",                                             "pst",     "",   "",    false, false },
  { u8"Central Pomo",                                               "poo",     "",   "",    false, false },
  { u8"Central Puebla Nahuatl",                                     "ncx",     "",   "",    false, false },
  { u8"Central Sama",                                               "sml",     "",   "",    false, false },
  { u8"Central Siberian Yupik",                                     "ess",     "",   "",    false, false },
  { u8"Central Sierra Miwok",                                       "csm",     "",   "",    false, false },
  { u8"Central Subanen",                                            "syb",     "",   "",    false, false },
  { u8"Central Sudanic languages",                                  "csu",     "",   "",    false, false },
  { u8"Central Tagbanwa",                                           "tgt",     "",   "",    false, false },
  { u8"Central Tarahumara",                                         "tar",     "",   "",    false, false },
  { u8"Central Tunebo",                                             "tuf",     "",   "",    false, false },
  { u8"Central Yupik",                                              "esu",     "",   "",    false, false },
  { u8"Central-Eastern Niger Fulfulde",                             "fuq",     "",   "",    false, false },
  { u8"Centúúm",                                                    "cet",     "",   "",    false, false },
  { u8"Cerma",                                                      "cme",     "",   "",    false, false },
  { u8"Chabu",                                                      "sbf",     "",   "",    false, false },
  { u8"Chachapoyas Quechua",                                        "quk",     "",   "",    false, false },
  { u8"Chachi",                                                     "cbi",     "",   "",    false, false },
  { u8"Chadian Arabic",                                             "shu",     "",   "",    false, false },
  { u8"Chadian Sign Language",                                      "cds",     "",   "",    false, false },
  { u8"Chadic languages",                                           "cdc",     "",   "",    false, false },
  { u8"Chadong",                                                    "cdy",     "",   "",    false, false },
  { u8"Chagatai",                                                   "chg",     "",   "",    true,  false },
  { u8"Chaima",                                                     "ciy",     "",   "",    false, false },
  { u8"Chak",                                                       "ckh",     "",   "",    false, false },
  { u8"Chakali",                                                    "cli",     "",   "",    false, false },
  { u8"Chakavian",                                                  "ckm",     "",   "",    false, false },
  { u8"Chakma",                                                     "ccp",     "",   "",    false, false },
  { u8"Chala",                                                      "cll",     "",   "",    false, false },
  { u8"Chaldean Neo-Aramaic",                                       "cld",     "",   "",    false, false },
  { u8"Chalikha",                                                   "tgf",     "",   "",    false, false },
  { u8"Chamacoco",                                                  "ceg",     "",   "",    false, false },
  { u8"Chamalal",                                                   "cji",     "",   "",    false, false },
  { u8"Chamari",                                                    "cdg",     "",   "",    false, true  },
  { u8"Chambeali",                                                  "cdh",     "",   "",    false, false },
  { u8"Chambri",                                                    "can",     "",   "",    false, false },
  { u8"Chamic languages",                                           "cmc",     "",   "",    true,  false },
  { u8"Chamicuro",                                                  "ccc",     "",   "",    false, false },
  { u8"Chamorro",                                                   "cha",     "ch", "",    true,  false },
  { u8"Chang Naga",                                                 "nbc",     "",   "",    false, false },
  { u8"Changriwa",                                                  "cga",     "",   "",    false, false },
  { u8"Changthang",                                                 "cna",     "",   "",    false, false },
  { u8"Chantyal",                                                   "chx",     "",   "",    false, false },
  { u8"Chané",                                                      "caj",     "",   "",    false, false },
  { u8"Chara",                                                      "cra",     "",   "",    false, false },
  { u8"Chaudangsi",                                                 "cdn",     "",   "",    false, false },
  { u8"Chaungtha",                                                  "ccq",     "",   "",    false, true  },
  { u8"Chaura",                                                     "crv",     "",   "",    false, false },
  { u8"Chavacano",                                                  "cbk",     "",   "",    false, false },
  { u8"Chayahuita",                                                 "cbt",     "",   "",    false, false },
  { u8"Chayuco Mixtec",                                             "mih",     "",   "",    false, false },
  { u8"Chazumba Mixtec",                                            "xtb",     "",   "",    false, false },
  { u8"Che",                                                        "ruk",     "",   "",    false, false },
  { u8"Chechen",                                                    "che",     "ce", "",    true,  false },
  { u8"Cheke Holo",                                                 "mrn",     "",   "",    false, false },
  { u8"Chemakum",                                                   "xch",     "",   "",    false, false },
  { u8"Chenapian",                                                  "cjn",     "",   "",    false, false },
  { u8"Chenchu",                                                    "cde",     "",   "",    false, false },
  { u8"Chenoua",                                                    "cnu",     "",   "",    false, false },
  { u8"Chepang",                                                    "cdm",     "",   "",    false, false },
  { u8"Chepya",                                                     "ycp",     "",   "",    false, false },
  { u8"Cherepon",                                                   "cpn",     "",   "",    false, false },
  { u8"Cherokee",                                                   "chr",     "",   "",    true,  false },
  { u8"Chesu",                                                      "ych",     "",   "",    false, false },
  { u8"Chetco",                                                     "ctc",     "",   "",    false, false },
  { u8"Chewong",                                                    "cwg",     "",   "",    false, false },
  { u8"Cheyenne",                                                   "chy",     "",   "",    true,  false },
  { u8"Chhattisgarhi",                                              "hne",     "",   "",    false, false },
  { u8"Chhintange",                                                 "ctn",     "",   "",    false, false },
  { u8"Chhulung",                                                   "cur",     "",   "",    false, false },
  { u8"Chiangmai Sign Language",                                    "csd",     "",   "",    false, false },
  { u8"Chiapanec",                                                  "cip",     "",   "",    false, false },
  { u8"Chibcha",                                                    "chb",     "",   "",    true,  false },
  { u8"Chibchan languages",                                         "cba",     "",   "",    false, false },
  { u8"Chicahuaxtla Triqui",                                        "trs",     "",   "",    false, false },
  { u8"Chichicapan Zapotec",                                        "zpv",     "",   "",    false, false },
  { u8"Chichimeca-Jonaz",                                           "pei",     "",   "",    false, false },
  { u8"Chickasaw",                                                  "cic",     "",   "",    false, false },
  { u8"Chicomuceltec",                                              "cob",     "",   "",    false, false },
  { u8"Chiga",                                                      "cgg",     "",   "",    false, false },
  { u8"Chigmecatitlán Mixtec",                                      "mii",     "",   "",    false, false },
  { u8"Chilcotin",                                                  "clc",     "",   "",    false, false },
  { u8"Chilean Quechua",                                            "cqu",     "",   "",    false, true  },
  { u8"Chilean Sign Language",                                      "csg",     "",   "",    false, false },
  { u8"Chilisso",                                                   "clh",     "",   "",    false, false },
  { u8"Chiltepec Chinantec",                                        "csa",     "",   "",    false, false },
  { u8"Chimakum",                                                   "cmk",     "",   "",    false, true  },
  { u8"Chimalapa Zoque",                                            "zoh",     "",   "",    false, false },
  { u8"Chimariko",                                                  "cid",     "",   "",    false, false },
  { u8"Chimborazo Highland Quichua",                                "qug",     "",   "",    false, false },
  { u8"Chimila",                                                    "cbg",     "",   "",    false, false },
  { u8"China Buriat",                                               "bxu",     "",   "",    false, false },
  { u8"Chinali",                                                    "cih",     "",   "",    false, false },
  { u8"Chinbon Chin",                                               "cnb",     "",   "",    false, false },
  { u8"Chincha Quechua",                                            "qxc",     "",   "",    false, false },
  { u8"Chinese (family)",                                           "zhx",     "",   "",    false, false },
  { u8"Chinese Pidgin English",                                     "cpi",     "",   "",    false, false },
  { u8"Chinese Sign Language",                                      "csl",     "",   "",    false, false },
  { u8"Chinese",                                                    "chi",     "zh", "zho", true,  false },
  { u8"Chinook jargon",                                             "chn",     "",   "",    true,  false },
  { u8"Chinook",                                                    "chh",     "",   "",    false, false },
  { u8"Chipaya",                                                    "cap",     "",   "",    false, false },
  { u8"Chipewyan",                                                  "chp",     "",   "",    true,  false },
  { u8"Chipiajes",                                                  "cbe",     "",   "",    false, true  },
  { u8"Chippewa",                                                   "ciw",     "",   "",    false, false },
  { u8"Chiquihuitlán Mazatec",                                      "maq",     "",   "",    false, false },
  { u8"Chiquitano",                                                 "cax",     "",   "",    false, false },
  { u8"Chiquián Ancash Quechua",                                    "qxa",     "",   "",    false, false },
  { u8"Chiripá",                                                    "nhd",     "",   "",    false, false },
  { u8"Chiru",                                                      "cdf",     "",   "",    false, false },
  { u8"Chitimacha",                                                 "ctm",     "",   "",    false, false },
  { u8"Chitkuli Kinnauri",                                          "cik",     "",   "",    false, false },
  { u8"Chittagonian",                                               "ctg",     "",   "",    false, false },
  { u8"Chitwania Tharu",                                            "the",     "",   "",    false, false },
  { u8"Choapan Zapotec",                                            "zpc",     "",   "",    false, false },
  { u8"Chocangacakha",                                              "cgk",     "",   "",    false, false },
  { u8"Chochotec",                                                  "coz",     "",   "",    false, false },
  { u8"Choctaw",                                                    "cho",     "",   "",    true,  false },
  { u8"Chodri",                                                     "cdi",     "",   "",    false, false },
  { u8"Chokri Naga",                                                "nri",     "",   "",    false, false },
  { u8"Chokwe",                                                     "cjk",     "",   "",    false, false },
  { u8"Chol",                                                       "ctu",     "",   "",    false, false },
  { u8"Cholón",                                                     "cht",     "",   "",    false, false },
  { u8"Chong",                                                      "cog",     "",   "",    false, false },
  { u8"Choni",                                                      "cda",     "",   "",    false, false },
  { u8"Chonyi-Dzihana-Kauma",                                       "coh",     "",   "",    false, false },
  { u8"Chopi",                                                      "cce",     "",   "",    false, false },
  { u8"Chorasmian",                                                 "xco",     "",   "",    false, false },
  { u8"Chorotega",                                                  "cjr",     "",   "",    false, true  },
  { u8"Chortí",                                                     "caa",     "",   "",    false, false },
  { u8"Chothe Naga",                                                "nct",     "",   "",    false, false },
  { u8"Chrau",                                                      "crw",     "",   "",    false, false },
  { u8"Chru",                                                       "cje",     "",   "",    false, false },
  { u8"Chuanqiandian Cluster Miao",                                 "cqd",     "",   "",    false, false },
  { u8"Chuave",                                                     "cjv",     "",   "",    false, false },
  { u8"Chug",                                                       "cvg",     "",   "",    false, false },
  { u8"Chuj",                                                       "cac",     "",   "",    false, false },
  { u8"Chuka",                                                      "cuh",     "",   "",    false, false },
  { u8"Chukot",                                                     "ckt",     "",   "",    false, false },
  { u8"Chukwa",                                                     "cuw",     "",   "",    false, false },
  { u8"Chulym",                                                     "clw",     "",   "",    false, false },
  { u8"Chumburung",                                                 "ncu",     "",   "",    false, false },
  { u8"Chung",                                                      "cnq",     "",   "",    false, false },
  { u8"Churahi",                                                    "cdj",     "",   "",    false, false },
  { u8"Church Slavic",                                              "chu",     "cu", "",    true,  false },
  { u8"Chut",                                                       "scb",     "",   "",    false, false },
  { u8"Chuukese",                                                   "chk",     "",   "",    true,  false },
  { u8"Chuvantsy",                                                  "xcv",     "",   "",    false, false },
  { u8"Chuvash",                                                    "chv",     "cv", "",    true,  false },
  { u8"Chuwabu",                                                    "chw",     "",   "",    false, false },
  { u8"Chácobo",                                                    "cao",     "",   "",    false, false },
  { u8"Ci Gbe",                                                     "cib",     "",   "",    false, false },
  { u8"Cia-Cia",                                                    "cia",     "",   "",    false, false },
  { u8"Cibak",                                                      "ckl",     "",   "",    false, false },
  { u8"Cicipu",                                                     "awc",     "",   "",    false, false },
  { u8"Cimbrian",                                                   "cim",     "",   "",    false, false },
  { u8"Cinda-Regi-Tiyal",                                           "cdr",     "",   "",    false, false },
  { u8"Cineni",                                                     "cie",     "",   "",    false, false },
  { u8"Cinta Larga",                                                "cin",     "",   "",    false, false },
  { u8"Cisalpine Gaulish",                                          "xcg",     "",   "",    false, false },
  { u8"Cishingini",                                                 "asg",     "",   "",    false, false },
  { u8"Citak",                                                      "txt",     "",   "",    false, false },
  { u8"Ciwogai",                                                    "tgd",     "",   "",    false, false },
  { u8"Clallam",                                                    "clm",     "",   "",    false, false },
  { u8"Classical Armenian",                                         "xcl",     "",   "",    false, false },
  { u8"Classical Mandaic",                                          "myz",     "",   "",    false, false },
  { u8"Classical Mongolian",                                        "cmg",     "",   "",    false, false },
  { u8"Classical Nahuatl",                                          "nci",     "",   "",    false, false },
  { u8"Classical Newari",                                           "nwc",     "",   "",    true,  false },
  { u8"Classical Quechua",                                          "qwc",     "",   "",    false, false },
  { u8"Classical Syriac",                                           "syc",     "",   "",    true,  false },
  { u8"Classical Tibetan",                                          "xct",     "",   "",    false, false },
  { u8"Coahuilteco",                                                "xcw",     "",   "",    false, false },
  { u8"Coast Miwok",                                                "csi",     "",   "",    false, false },
  { u8"Coastal Kadazan",                                            "kzj",     "",   "",    false, true  },
  { u8"Coastal Konjo",                                              "kjc",     "",   "",    false, false },
  { u8"Coatecas Altas Zapotec",                                     "zca",     "",   "",    false, false },
  { u8"Coatepec Nahuatl",                                           "naz",     "",   "",    false, false },
  { u8"Coatlán Mixe",                                               "mco",     "",   "",    false, false },
  { u8"Coatlán Zapotec",                                            "zps",     "",   "",    false, false },
  { u8"Coatzospan Mixtec",                                          "miz",     "",   "",    false, false },
  { u8"Cocama-Cocamilla",                                           "cod",     "",   "",    false, false },
  { u8"Cochimi",                                                    "coj",     "",   "",    false, false },
  { u8"Cocopa",                                                     "coc",     "",   "",    false, false },
  { u8"Cocos Islands Malay",                                        "coa",     "",   "",    false, false },
  { u8"Coeur d'Alene",                                              "crd",     "",   "",    false, false },
  { u8"Cofán",                                                      "con",     "",   "",    false, false },
  { u8"Cogui",                                                      "kog",     "",   "",    false, false },
  { u8"Col",                                                        "liw",     "",   "",    false, false },
  { u8"Colombian Sign Language",                                    "csn",     "",   "",    false, false },
  { u8"Colonia Tovar German",                                       "gct",     "",   "",    false, false },
  { u8"Colorado",                                                   "cof",     "",   "",    false, false },
  { u8"Columbia-Wenatchi",                                          "col",     "",   "",    false, false },
  { u8"Comaltepec Chinantec",                                       "cco",     "",   "",    false, false },
  { u8"Comanche",                                                   "com",     "",   "",    false, false },
  { u8"Comecrudo",                                                  "xcm",     "",   "",    false, false },
  { u8"Como Karim",                                                 "cfg",     "",   "",    false, false },
  { u8"Comox",                                                      "coo",     "",   "",    false, false },
  { u8"Con",                                                        "cno",     "",   "",    false, false },
  { u8"Congo Swahili",                                              "swc",     "",   "",    false, false },
  { u8"Coos",                                                       "csz",     "",   "",    false, false },
  { u8"Copainalá Zoque",                                            "zoc",     "",   "",    false, false },
  { u8"Copala Triqui",                                              "trc",     "",   "",    false, false },
  { u8"Coptic",                                                     "cop",     "",   "",    true,  false },
  { u8"Coquille",                                                   "coq",     "",   "",    false, false },
  { u8"Cori",                                                       "cry",     "",   "",    false, false },
  { u8"Cornish",                                                    "cor",     "kw", "",    true,  false },
  { u8"Corongo Ancash Quechua",                                     "qwa",     "",   "",    false, false },
  { u8"Corsican",                                                   "cos",     "co", "",    true,  false },
  { u8"Costa Rican Sign Language",                                  "csr",     "",   "",    false, false },
  { u8"Cotabato Manobo",                                            "mta",     "",   "",    false, false },
  { u8"Cotoname",                                                   "xcn",     "",   "",    false, false },
  { u8"Cowlitz",                                                    "cow",     "",   "",    false, false },
  { u8"Coxima",                                                     "kox",     "",   "",    false, true  },
  { u8"Coyaima",                                                    "coy",     "",   "",    false, true  },
  { u8"Coyotepec Popoloca",                                         "pbf",     "",   "",    false, false },
  { u8"Coyutla Totonac",                                            "toc",     "",   "",    false, false },
  { u8"Cree",                                                       "cre",     "cr", "",    true,  false },
  { u8"Creek",                                                      "mus",     "",   "",    true,  false },
  { u8"Creoles and pidgins",                                        "crp",     "",   "",    true,  false },
  { u8"Creoles and pidgins, English based",                         "cpe",     "",   "",    true,  false },
  { u8"Creoles and pidgins, French-based",                          "cpf",     "",   "",    true,  false },
  { u8"Creoles and pidgins, Portuguese-based",                      "cpp",     "",   "",    true,  false },
  { u8"Crimean Tatar",                                              "crh",     "",   "",    true,  false },
  { u8"Croatia Sign Language",                                      "csq",     "",   "",    false, false },
  { u8"Croatian",                                                   "hrv",     "hr", "",    true,  false },
  { u8"Cross River Mbembe",                                         "mfn",     "",   "",    false, false },
  { u8"Crow",                                                       "cro",     "",   "",    false, false },
  { u8"Cruzeño",                                                    "crz",     "",   "",    false, false },
  { u8"Cua",                                                        "cua",     "",   "",    false, false },
  { u8"Cuba Sign Language",                                         "csf",     "",   "",    false, false },
  { u8"Cubeo",                                                      "cub",     "",   "",    false, false },
  { u8"Cuiba",                                                      "cui",     "",   "",    false, false },
  { u8"Cuitlatec",                                                  "cuy",     "",   "",    false, false },
  { u8"Culina",                                                     "cul",     "",   "",    false, false },
  { u8"Cumanagoto",                                                 "cuo",     "",   "",    false, false },
  { u8"Cumbric",                                                    "xcb",     "",   "",    false, false },
  { u8"Cumeral",                                                    "cum",     "",   "",    false, true  },
  { u8"Cun",                                                        "cuq",     "",   "",    false, false },
  { u8"Cuneiform Luwian",                                           "xlu",     "",   "",    false, false },
  { u8"Cung",                                                       "cug",     "",   "",    false, true  },
  { u8"Cupeño",                                                     "cup",     "",   "",    false, false },
  { u8"Curonian",                                                   "xcu",     "",   "",    false, false },
  { u8"Curripaco",                                                  "kpc",     "",   "",    false, false },
  { u8"Cusco Quechua",                                              "quz",     "",   "",    false, false },
  { u8"Cushitic languages",                                         "cus",     "",   "",    true,  false },
  { u8"Cutchi-Swahili",                                             "ccl",     "",   "",    false, false },
  { u8"Cuvok",                                                      "cuv",     "",   "",    false, false },
  { u8"Cuyamecalco Mixtec",                                         "xtu",     "",   "",    false, false },
  { u8"Cuyonon",                                                    "cyo",     "",   "",    false, false },
  { u8"Cwi Bwamu",                                                  "bwy",     "",   "",    false, false },
  { u8"Cypriot Arabic",                                             "acy",     "",   "",    false, false },
  { u8"Czech Sign Language",                                        "cse",     "",   "",    false, false },
  { u8"Czech",                                                      "cze",     "cs", "ces", true,  false },
  { u8"Côông",                                                      "cnc",     "",   "",    false, false },
  { u8"Da'a Kaili",                                                 "kzf",     "",   "",    false, false },
  { u8"Daai Chin",                                                  "dao",     "",   "",    false, false },
  { u8"Daakaka",                                                    "bpa",     "",   "",    false, false },
  { u8"Daantanai'",                                                 "lni",     "",   "",    false, false },
  { u8"Daasanach",                                                  "dsh",     "",   "",    false, false },
  { u8"Daatsʼíin",                                                 "dtn",     "",   "",    false, false },
  { u8"Daba",                                                       "dbq",     "",   "",    false, false },
  { u8"Dabarre",                                                    "dbr",     "",   "",    false, false },
  { u8"Dabe",                                                       "dbe",     "",   "",    false, false },
  { u8"Dacian",                                                     "xdc",     "",   "",    false, false },
  { u8"Dadi Dadi",                                                  "dda",     "",   "",    false, false },
  { u8"Dadibi",                                                     "mps",     "",   "",    false, false },
  { u8"Dadiya",                                                     "dbd",     "",   "",    false, false },
  { u8"Daga",                                                       "dgz",     "",   "",    false, false },
  { u8"Dagaari Dioula",                                             "dgd",     "",   "",    false, false },
  { u8"Dagba",                                                      "dgk",     "",   "",    false, false },
  { u8"Dagbani",                                                    "dag",     "",   "",    false, false },
  { u8"Dagik",                                                      "dec",     "",   "",    false, false },
  { u8"Dagoman",                                                    "dgn",     "",   "",    false, false },
  { u8"Dahalik",                                                    "dlk",     "",   "",    false, false },
  { u8"Dahalo",                                                     "dal",     "",   "",    false, false },
  { u8"Daho-Doo",                                                   "das",     "",   "",    false, false },
  { u8"Dai Zhuang",                                                 "zhd",     "",   "",    false, false },
  { u8"Dai",                                                        "dij",     "",   "",    false, false },
  { u8"Dair",                                                       "drb",     "",   "",    false, false },
  { u8"Dakka",                                                      "dkk",     "",   "",    false, false },
  { u8"Dakota",                                                     "dak",     "",   "",    true,  false },
  { u8"Dakpakha",                                                   "dka",     "",   "",    false, false },
  { u8"Dalabon",                                                    "ngk",     "",   "",    false, false },
  { u8"Dalmatian",                                                  "dlm",     "",   "",    false, false },
  { u8"Daloa Bété",                                                 "bev",     "",   "",    false, false },
  { u8"Dama",                                                       "dmm",     "",   "",    false, false },
  { u8"Damakawa",                                                   "dam",     "",   "",    false, false },
  { u8"Damal",                                                      "uhn",     "",   "",    false, false },
  { u8"Dambi",                                                      "dac",     "",   "",    false, false },
  { u8"Dameli",                                                     "dml",     "",   "",    false, false },
  { u8"Dampelas",                                                   "dms",     "",   "",    false, false },
  { u8"Dan",                                                        "daf",     "",   "",    false, true  },
  { u8"Dan",                                                        "dnj",     "",   "",    false, false },
  { u8"Danaru",                                                     "dnr",     "",   "",    false, false },
  { u8"Danau",                                                      "dnu",     "",   "",    false, false },
  { u8"Dandami Maria",                                              "daq",     "",   "",    false, false },
  { u8"Dangaléat",                                                  "daa",     "",   "",    false, false },
  { u8"Dangaura Tharu",                                             "thl",     "",   "",    false, false },
  { u8"Danish Sign Language",                                       "dsl",     "",   "",    false, false },
  { u8"Danish",                                                     "dan",     "da", "",    true,  false },
  { u8"Dano",                                                       "aso",     "",   "",    false, false },
  { u8"Danu",                                                       "dnv",     "",   "",    false, false },
  { u8"Dao",                                                        "daz",     "",   "",    false, false },
  { u8"Daonda",                                                     "dnd",     "",   "",    false, false },
  { u8"Dar Daju Daju",                                              "djc",     "",   "",    false, false },
  { u8"Dar Fur Daju",                                               "daj",     "",   "",    false, false },
  { u8"Dar Sila Daju",                                              "dau",     "",   "",    false, false },
  { u8"Darai",                                                      "dry",     "",   "",    false, false },
  { u8"Dargwa",                                                     "dar",     "",   "",    true,  false },
  { u8"Dari",                                                       "prs",     "",   "",    false, false },
  { u8"Darkhat",                                                    "drh",     "",   "",    false, true  },
  { u8"Darkinyung",                                                 "xda",     "",   "",    false, false },
  { u8"Darlong",                                                    "dln",     "",   "",    false, false },
  { u8"Darmiya",                                                    "drd",     "",   "",    false, false },
  { u8"Daro-Matu Melanau",                                          "dro",     "",   "",    false, false },
  { u8"Darwazi",                                                    "drw",     "",   "",    false, true  },
  { u8"Dass",                                                       "dot",     "",   "",    false, false },
  { u8"Datooga",                                                    "tcc",     "",   "",    false, false },
  { u8"Daungwurrung",                                               "dgw",     "",   "",    false, false },
  { u8"Daur",                                                       "dta",     "",   "",    false, false },
  { u8"Davawenyo",                                                  "daw",     "",   "",    false, false },
  { u8"Dawawa",                                                     "dww",     "",   "",    false, false },
  { u8"Dawera-Daweloor",                                            "ddw",     "",   "",    false, false },
  { u8"Dawik Kui",                                                  "dwk",     "",   "",    false, false },
  { u8"Dawro",                                                      "dwr",     "",   "",    false, false },
  { u8"Day",                                                        "dai",     "",   "",    false, false },
  { u8"Dayi",                                                       "dax",     "",   "",    false, false },
  { u8"Daza",                                                       "dzd",     "",   "",    false, true  },
  { u8"Dazaga",                                                     "dzg",     "",   "",    false, false },
  { u8"Deccan",                                                     "dcc",     "",   "",    false, false },
  { u8"Dedua",                                                      "ded",     "",   "",    false, false },
  { u8"Defaka",                                                     "afn",     "",   "",    false, false },
  { u8"Defi Gbe",                                                   "gbh",     "",   "",    false, false },
  { u8"Deg",                                                        "mzw",     "",   "",    false, false },
  { u8"Degaru",                                                     "dgu",     "",   "",    false, true  },
  { u8"Degema",                                                     "deg",     "",   "",    false, false },
  { u8"Degenan",                                                    "dge",     "",   "",    false, false },
  { u8"Degexit'an",                                                 "ing",     "",   "",    false, false },
  { u8"Dehu",                                                       "dhv",     "",   "",    false, false },
  { u8"Dehwari",                                                    "deh",     "",   "",    false, false },
  { u8"Dek",                                                        "dek",     "",   "",    false, false },
  { u8"Dela-Oenale",                                                "row",     "",   "",    false, false },
  { u8"Delaware",                                                   "del",     "",   "",    true,  false },
  { u8"Delo",                                                       "ntr",     "",   "",    false, false },
  { u8"Dem",                                                        "dem",     "",   "",    false, false },
  { u8"Dema",                                                       "dmx",     "",   "",    false, false },
  { u8"Demisa",                                                     "dei",     "",   "",    false, false },
  { u8"Demta",                                                      "dmy",     "",   "",    false, false },
  { u8"Dendi (Benin)",                                              "ddn",     "",   "",    false, false },
  { u8"Dendi (Central African Republic)",                           "deq",     "",   "",    false, false },
  { u8"Dengese",                                                    "dez",     "",   "",    false, false },
  { u8"Dengka",                                                     "dnk",     "",   "",    false, false },
  { u8"Deno",                                                       "dbb",     "",   "",    false, false },
  { u8"Denya",                                                      "anv",     "",   "",    false, false },
  { u8"Dení",                                                       "dny",     "",   "",    false, false },
  { u8"Deori",                                                      "der",     "",   "",    false, false },
  { u8"Dera (Indonesia)",                                           "kbv",     "",   "",    false, false },
  { u8"Dera (Nigeria)",                                             "kna",     "",   "",    false, false },
  { u8"Desano",                                                     "des",     "",   "",    false, false },
  { u8"Desiya",                                                     "dso",     "",   "",    false, false },
  { u8"Dewas Rai",                                                  "dwz",     "",   "",    false, false },
  { u8"Dewoin",                                                     "dee",     "",   "",    false, false },
  { u8"Dezfuli",                                                    "def",     "",   "",    false, false },
  { u8"Dghwede",                                                    "dgh",     "",   "",    false, false },
  { u8"Dhaiso",                                                     "dhs",     "",   "",    false, false },
  { u8"Dhalandji",                                                  "dhl",     "",   "",    false, false },
  { u8"Dhangu-Djangu",                                              "dhg",     "",   "",    false, false },
  { u8"Dhanki",                                                     "dhn",     "",   "",    false, false },
  { u8"Dhanwar (India)",                                            "dha",     "",   "",    false, true  },
  { u8"Dhanwar (Nepal)",                                            "dhw",     "",   "",    false, false },
  { u8"Dhao",                                                       "nfa",     "",   "",    false, false },
  { u8"Dharawal",                                                   "tbh",     "",   "",    false, false },
  { u8"Dhargari",                                                   "dhr",     "",   "",    false, false },
  { u8"Dharuk",                                                     "xdk",     "",   "",    false, false },
  { u8"Dharumbal",                                                  "xgm",     "",   "",    false, false },
  { u8"Dhatki",                                                     "mki",     "",   "",    false, false },
  { u8"Dhimal",                                                     "dhi",     "",   "",    false, false },
  { u8"Dhivehi",                                                    "div",     "dv", "",    true,  false },
  { u8"Dhodia",                                                     "dho",     "",   "",    false, false },
  { u8"Dhofari Arabic",                                             "adf",     "",   "",    false, false },
  { u8"Dhudhuroa",                                                  "ddr",     "",   "",    false, false },
  { u8"Dhundari",                                                   "dhd",     "",   "",    false, false },
  { u8"Dhungaloo",                                                  "dhx",     "",   "",    false, false },
  { u8"Dhurga",                                                     "dhu",     "",   "",    false, false },
  { u8"Dhuwal",                                                     "duj",     "",   "",    false, true  },
  { u8"Dhuwal",                                                     "dwu",     "",   "",    false, false },
  { u8"Dhuwaya",                                                    "dwy",     "",   "",    false, false },
  { u8"Dia",                                                        "dia",     "",   "",    false, false },
  { u8"Dibabawon Manobo",                                           "mbd",     "",   "",    false, false },
  { u8"Dibiyaso",                                                   "dby",     "",   "",    false, false },
  { u8"Dibo",                                                       "dio",     "",   "",    false, false },
  { u8"Dibole",                                                     "bvx",     "",   "",    false, false },
  { u8"Dicamay Agta",                                               "duy",     "",   "",    false, false },
  { u8"Didinga",                                                    "did",     "",   "",    false, false },
  { u8"Dido",                                                       "ddo",     "",   "",    false, false },
  { u8"Dieri",                                                      "dif",     "",   "",    false, false },
  { u8"Digaro-Mishmi",                                              "mhu",     "",   "",    false, false },
  { u8"Digo",                                                       "dig",     "",   "",    false, false },
  { u8"Dii",                                                        "dur",     "",   "",    false, false },
  { u8"Dijim-Bwilim",                                               "cfa",     "",   "",    false, false },
  { u8"Dilling",                                                    "dil",     "",   "",    false, false },
  { u8"Dima",                                                       "jma",     "",   "",    false, false },
  { u8"Dimasa",                                                     "dis",     "",   "",    false, false },
  { u8"Dimbong",                                                    "dii",     "",   "",    false, false },
  { u8"Dime",                                                       "dim",     "",   "",    false, false },
  { u8"Dimli (individual language)",                                "diq",     "",   "",    false, false },
  { u8"Ding",                                                       "diz",     "",   "",    false, false },
  { u8"Dinka",                                                      "din",     "",   "",    true,  false },
  { u8"Dirari",                                                     "dit",     "",   "",    false, true  },
  { u8"Dirasha",                                                    "gdl",     "",   "",    false, false },
  { u8"Diri",                                                       "dwa",     "",   "",    false, false },
  { u8"Diriku",                                                     "diu",     "",   "",    false, false },
  { u8"Dirim",                                                      "dir",     "",   "",    false, false },
  { u8"Disa",                                                       "dsi",     "",   "",    false, false },
  { u8"Ditammari",                                                  "tbz",     "",   "",    false, false },
  { u8"Ditidaht",                                                   "dtd",     "",   "",    false, false },
  { u8"Diuwe",                                                      "diy",     "",   "",    false, false },
  { u8"Diuxi-Tilantongo Mixtec",                                    "xtd",     "",   "",    false, false },
  { u8"Dixon Reef",                                                 "dix",     "",   "",    false, false },
  { u8"Dizin",                                                      "mdx",     "",   "",    false, false },
  { u8"Djabugay",                                                   "dyy",     "",   "",    false, false },
  { u8"Djabwurrung",                                                "tjw",     "",   "",    false, false },
  { u8"Djadjawurrung",                                              "dja",     "",   "",    false, false },
  { u8"Djambarrpuyngu",                                             "djr",     "",   "",    false, false },
  { u8"Djamindjung",                                                "djd",     "",   "",    false, false },
  { u8"Djangun",                                                    "djf",     "",   "",    false, false },
  { u8"Djawi",                                                      "djw",     "",   "",    false, false },
  { u8"Djeebbana",                                                  "djj",     "",   "",    false, false },
  { u8"Djimini Senoufo",                                            "dyi",     "",   "",    false, false },
  { u8"Djinang",                                                    "dji",     "",   "",    false, false },
  { u8"Djinba",                                                     "djb",     "",   "",    false, false },
  { u8"Djiwarli",                                                   "djl",     "",   "",    false, true  },
  { u8"Djiwarli",                                                   "dze",     "",   "",    false, false },
  { u8"Dobel",                                                      "kvo",     "",   "",    false, false },
  { u8"Dobu",                                                       "dob",     "",   "",    false, false },
  { u8"Doe",                                                        "doe",     "",   "",    false, false },
  { u8"Doga",                                                       "dgg",     "",   "",    false, false },
  { u8"Doghoro",                                                    "dgx",     "",   "",    false, false },
  { u8"Dogoso",                                                     "dgs",     "",   "",    false, false },
  { u8"Dogosé",                                                     "dos",     "",   "",    false, false },
  { u8"Dogri (individual language)",                                "dgo",     "",   "",    false, false },
  { u8"Dogri (macrolanguage)",                                      "doi",     "",   "",    true,  false },
  { u8"Dogrib",                                                     "dgr",     "",   "",    true,  false },
  { u8"Dogul Dom Dogon",                                            "dbg",     "",   "",    false, false },
  { u8"Doka",                                                       "dbi",     "",   "",    false, false },
  { u8"Doko-Uyanga",                                                "uya",     "",   "",    false, false },
  { u8"Dolgan",                                                     "dlg",     "",   "",    false, false },
  { u8"Dolpo",                                                      "dre",     "",   "",    false, false },
  { u8"Dom",                                                        "doa",     "",   "",    false, false },
  { u8"Domaaki",                                                    "dmk",     "",   "",    false, false },
  { u8"Domari",                                                     "rmt",     "",   "",    false, false },
  { u8"Dombe",                                                      "dov",     "",   "",    false, false },
  { u8"Dominican Sign Language",                                    "doq",     "",   "",    false, false },
  { u8"Dompo",                                                      "doy",     "",   "",    false, false },
  { u8"Domu",                                                       "dof",     "",   "",    false, false },
  { u8"Domung",                                                     "dev",     "",   "",    false, false },
  { u8"Dondo",                                                      "dok",     "",   "",    false, false },
  { u8"Dong",                                                       "doh",     "",   "",    false, false },
  { u8"Dongo",                                                      "doo",     "",   "",    false, false },
  { u8"Dongotono",                                                  "ddd",     "",   "",    false, false },
  { u8"Dongshanba Lalo",                                            "yik",     "",   "",    false, false },
  { u8"Dongxiang",                                                  "sce",     "",   "",    false, false },
  { u8"Donno So Dogon",                                             "dds",     "",   "",    false, false },
  { u8"Doondo",                                                     "dde",     "",   "",    false, false },
  { u8"Dori'o",                                                     "dor",     "",   "",    false, false },
  { u8"Doromu-Koki",                                                "kqc",     "",   "",    false, false },
  { u8"Dororo",                                                     "drr",     "",   "",    false, true  },
  { u8"Dorze",                                                      "doz",     "",   "",    false, false },
  { u8"Doso",                                                       "dol",     "",   "",    false, false },
  { u8"Dotyali",                                                    "dty",     "",   "",    false, false },
  { u8"Doutai",                                                     "tds",     "",   "",    false, false },
  { u8"Doyayo",                                                     "dow",     "",   "",    false, false },
  { u8"Dravidian languages",                                        "dra",     "",   "",    true,  false },
  { u8"Drents",                                                     "drt",     "",   "",    false, false },
  { u8"Drung",                                                      "duu",     "",   "",    false, false },
  { u8"Duala",                                                      "dua",     "",   "",    true,  false },
  { u8"Duano",                                                      "dup",     "",   "",    false, false },
  { u8"Duau",                                                       "dva",     "",   "",    false, false },
  { u8"Dubli",                                                      "dub",     "",   "",    false, false },
  { u8"Dubu",                                                       "dmu",     "",   "",    false, false },
  { u8"Dugun",                                                      "ndu",     "",   "",    false, false },
  { u8"Duguri",                                                     "dbm",     "",   "",    false, false },
  { u8"Dugwor",                                                     "dme",     "",   "",    false, false },
  { u8"Duhwa",                                                      "kbz",     "",   "",    false, false },
  { u8"Duke",                                                       "nke",     "",   "",    false, false },
  { u8"Dulbu",                                                      "dbo",     "",   "",    false, false },
  { u8"Duli-Gey",                                                   "duz",     "",   "",    false, false },
  { u8"Duma",                                                       "dma",     "",   "",    false, false },
  { u8"Dumbea",                                                     "duf",     "",   "",    false, false },
  { u8"Dumi",                                                       "dus",     "",   "",    false, false },
  { u8"Dumpas",                                                     "dmv",     "",   "",    false, false },
  { u8"Dumun",                                                      "dui",     "",   "",    false, false },
  { u8"Duna",                                                       "duc",     "",   "",    false, false },
  { u8"Dungan",                                                     "dng",     "",   "",    false, false },
  { u8"Dungmali",                                                   "raa",     "",   "",    false, false },
  { u8"Dungra Bhil",                                                "duh",     "",   "",    false, false },
  { u8"Dungu",                                                      "dbv",     "",   "",    false, false },
  { u8"Dupaninan Agta",                                             "duo",     "",   "",    false, false },
  { u8"Dura",                                                       "drq",     "",   "",    false, false },
  { u8"Durango Nahuatl",                                            "nln",     "",   "",    false, true  },
  { u8"Duri",                                                       "mvp",     "",   "",    false, false },
  { u8"Duriankere",                                                 "dbn",     "",   "",    false, false },
  { u8"Duruma",                                                     "dug",     "",   "",    false, false },
  { u8"Duruwa",                                                     "pci",     "",   "",    false, false },
  { u8"Dusner",                                                     "dsn",     "",   "",    false, false },
  { u8"Dusun Deyah",                                                "dun",     "",   "",    false, false },
  { u8"Dusun Malang",                                               "duq",     "",   "",    false, false },
  { u8"Dusun Witu",                                                 "duw",     "",   "",    false, false },
  { u8"Dutch Sign Language",                                        "dse",     "",   "",    false, false },
  { u8"Dutch",                                                      "dut",     "nl", "nld", true,  false },
  { u8"Dutton World Speedwords",                                    "dws",     "",   "",    false, false },
  { u8"Duungooma",                                                  "dux",     "",   "",    false, false },
  { u8"Duupa",                                                      "dae",     "",   "",    false, false },
  { u8"Duvle",                                                      "duv",     "",   "",    false, false },
  { u8"Duwai",                                                      "dbp",     "",   "",    false, false },
  { u8"Duwet",                                                      "gve",     "",   "",    false, false },
  { u8"Dũya",                                                      "ldb",     "",   "",    false, false },
  { u8"Dwang",                                                      "nnu",     "",   "",    false, false },
  { u8"Dyaberdyaber",                                               "dyb",     "",   "",    false, false },
  { u8"Dyan",                                                       "dya",     "",   "",    false, false },
  { u8"Dyangadi",                                                   "dyn",     "",   "",    false, false },
  { u8"Dyirbal",                                                    "dbl",     "",   "",    false, false },
  { u8"Dyugun",                                                     "dyd",     "",   "",    false, false },
  { u8"Dyula",                                                      "dyu",     "",   "",    true,  false },
  { u8"Dza",                                                        "jen",     "",   "",    false, false },
  { u8"Dzalakha",                                                   "dzl",     "",   "",    false, false },
  { u8"Dzando",                                                     "dzn",     "",   "",    false, false },
  { u8"Dzao Min",                                                   "bpn",     "",   "",    false, false },
  { u8"Dzongkha",                                                   "dzo",     "dz", "",    true,  false },
  { u8"Dzùùngoo",                                                   "dnn",     "",   "",    false, false },
  { u8"Dâw",                                                        "kwa",     "",   "",    false, false },
  { u8"E",                                                          "eee",     "",   "",    false, false },
  { u8"E'ma Buyang",                                                "yzg",     "",   "",    false, false },
  { u8"E'ñapa Woromaipu",                                           "pbh",     "",   "",    false, false },
  { u8"Early Tripuri",                                              "xtr",     "",   "",    false, false },
  { u8"East Ambae",                                                 "omb",     "",   "",    false, false },
  { u8"East Berawan",                                               "zbe",     "",   "",    false, false },
  { u8"East Damar",                                                 "dmr",     "",   "",    false, false },
  { u8"East Futuna",                                                "fud",     "",   "",    false, false },
  { u8"East Germanic languages",                                    "gme",     "",   "",    false, false },
  { u8"East Kewa",                                                  "kjs",     "",   "",    false, false },
  { u8"East Limba",                                                 "lma",     "",   "",    false, false },
  { u8"East Makian",                                                "mky",     "",   "",    false, false },
  { u8"East Masela",                                                "vme",     "",   "",    false, false },
  { u8"East Nyala",                                                 "nle",     "",   "",    false, false },
  { u8"East Slavic languages",                                      "zle",     "",   "",    false, false },
  { u8"East Tarangan",                                              "tre",     "",   "",    false, false },
  { u8"East Yugur",                                                 "yuy",     "",   "",    false, false },
  { u8"Eastern Abnaki",                                             "aaq",     "",   "",    false, false },
  { u8"Eastern Acipa",                                              "acp",     "",   "",    false, false },
  { u8"Eastern Apurímac Quechua",                                   "qve",     "",   "",    false, false },
  { u8"Eastern Arrernte",                                           "aer",     "",   "",    false, false },
  { u8"Eastern Balochi",                                            "bgp",     "",   "",    false, false },
  { u8"Eastern Bolivian Guaraní",                                   "gui",     "",   "",    false, false },
  { u8"Eastern Bontok",                                             "ebk",     "",   "",    false, false },
  { u8"Eastern Bru",                                                "bru",     "",   "",    false, false },
  { u8"Eastern Canadian Inuktitut",                                 "ike",     "",   "",    false, false },
  { u8"Eastern Cham",                                               "cjm",     "",   "",    false, false },
  { u8"Eastern Durango Nahuatl",                                    "azd",     "",   "",    false, false },
  { u8"Eastern Egyptian Bedawi Arabic",                             "avl",     "",   "",    false, false },
  { u8"Eastern Frisian",                                            "frs",     "",   "",    true,  false },
  { u8"Eastern Gorkha Tamang",                                      "tge",     "",   "",    false, false },
  { u8"Eastern Gurung",                                             "ggn",     "",   "",    false, true  },
  { u8"Eastern Highland Chatino",                                   "cly",     "",   "",    false, false },
  { u8"Eastern Highland Otomi",                                     "otm",     "",   "",    false, false },
  { u8"Eastern Hongshuihe Zhuang",                                  "zeh",     "",   "",    false, false },
  { u8"Eastern Huasteca Nahuatl",                                   "nhe",     "",   "",    false, false },
  { u8"Eastern Huishui Hmong",                                      "hme",     "",   "",    false, false },
  { u8"Eastern Karaboro",                                           "xrb",     "",   "",    false, false },
  { u8"Eastern Karnic",                                             "ekc",     "",   "",    false, true  },
  { u8"Eastern Katu",                                               "ktv",     "",   "",    false, false },
  { u8"Eastern Kayah",                                              "eky",     "",   "",    false, false },
  { u8"Eastern Keres",                                              "kee",     "",   "",    false, false },
  { u8"Eastern Khumi Chin",                                         "cek",     "",   "",    false, false },
  { u8"Eastern Krahn",                                              "kqo",     "",   "",    false, false },
  { u8"Eastern Lalu",                                               "yit",     "",   "",    false, false },
  { u8"Eastern Lawa",                                               "lwl",     "",   "",    false, false },
  { u8"Eastern Magar",                                              "mgp",     "",   "",    false, false },
  { u8"Eastern Malayo-Polynesian languages",                        "pqe",     "",   "",    false, false },
  { u8"Eastern Maninkakan",                                         "emk",     "",   "",    false, false },
  { u8"Eastern Mari",                                               "mhr",     "",   "",    false, false },
  { u8"Eastern Maroon Creole",                                      "djk",     "",   "",    false, false },
  { u8"Eastern Meohang",                                            "emg",     "",   "",    false, false },
  { u8"Eastern Minyag",                                             "emq",     "",   "",    false, false },
  { u8"Eastern Mnong",                                              "mng",     "",   "",    false, false },
  { u8"Eastern Muria",                                              "emu",     "",   "",    false, false },
  { u8"Eastern Ngad'a",                                             "nea",     "",   "",    false, false },
  { u8"Eastern Nisu",                                               "nos",     "",   "",    false, false },
  { u8"Eastern Ojibwa",                                             "ojg",     "",   "",    false, false },
  { u8"Eastern Oromo",                                              "hae",     "",   "",    false, false },
  { u8"Eastern Parbate Kham",                                       "kif",     "",   "",    false, false },
  { u8"Eastern Penan",                                              "pez",     "",   "",    false, false },
  { u8"Eastern Pomo",                                               "peb",     "",   "",    false, false },
  { u8"Eastern Qiandong Miao",                                      "hmq",     "",   "",    false, false },
  { u8"Eastern Subanen",                                            "sfe",     "",   "",    false, false },
  { u8"Eastern Sudanic languages",                                  "sdv",     "",   "",    false, false },
  { u8"Eastern Tamang",                                             "taj",     "",   "",    false, false },
  { u8"Eastern Tawbuid",                                            "bnj",     "",   "",    false, false },
  { u8"Eastern Xiangxi Miao",                                       "muq",     "",   "",    false, false },
  { u8"Eastern Xwla Gbe",                                           "gbx",     "",   "",    false, false },
  { u8"Eastern Yiddish",                                            "ydd",     "",   "",    false, false },
  { u8"Ebira",                                                      "igb",     "",   "",    false, false },
  { u8"Eblan",                                                      "xeb",     "",   "",    false, false },
  { u8"Ebrié",                                                      "ebr",     "",   "",    false, false },
  { u8"Ebughu",                                                     "ebg",     "",   "",    false, false },
  { u8"Ecuadorian Sign Language",                                   "ecs",     "",   "",    false, false },
  { u8"Ede Cabe",                                                   "cbj",     "",   "",    false, false },
  { u8"Ede Ica",                                                    "ica",     "",   "",    false, false },
  { u8"Ede Idaca",                                                  "idd",     "",   "",    false, false },
  { u8"Ede Ije",                                                    "ijj",     "",   "",    false, false },
  { u8"Edera Awyu",                                                 "awy",     "",   "",    false, false },
  { u8"Edolo",                                                      "etr",     "",   "",    false, false },
  { u8"Edomite",                                                    "xdm",     "",   "",    false, false },
  { u8"Edopi",                                                      "dbf",     "",   "",    false, false },
  { u8"Efai",                                                       "efa",     "",   "",    false, false },
  { u8"Efe",                                                        "efe",     "",   "",    false, false },
  { u8"Efik",                                                       "efi",     "",   "",    true,  false },
  { u8"Efutop",                                                     "ofu",     "",   "",    false, false },
  { u8"Ega",                                                        "ega",     "",   "",    false, false },
  { u8"Eggon",                                                      "ego",     "",   "",    false, false },
  { u8"Egypt Sign Language",                                        "esl",     "",   "",    false, false },
  { u8"Egyptian (Ancient)",                                         "egy",     "",   "",    true,  false },
  { u8"Egyptian Arabic",                                            "arz",     "",   "",    false, false },
  { u8"Egyptian languages",                                         "egx",     "",   "",    false, false },
  { u8"Ehueun",                                                     "ehu",     "",   "",    false, false },
  { u8"Eipomek",                                                    "eip",     "",   "",    false, false },
  { u8"Eitiep",                                                     "eit",     "",   "",    false, false },
  { u8"Ejagham",                                                    "etu",     "",   "",    false, false },
  { u8"Ejamat",                                                     "eja",     "",   "",    false, false },
  { u8"Ekai Chin",                                                  "cey",     "",   "",    false, false },
  { u8"Ekajuk",                                                     "eka",     "",   "",    true,  false },
  { u8"Ekari",                                                      "ekg",     "",   "",    false, false },
  { u8"Eki",                                                        "eki",     "",   "",    false, false },
  { u8"Ekit",                                                       "eke",     "",   "",    false, false },
  { u8"Ekpeye",                                                     "ekp",     "",   "",    false, false },
  { u8"El Alto Zapotec",                                            "zpp",     "",   "",    false, false },
  { u8"El Hugeirat",                                                "elh",     "",   "",    false, false },
  { u8"El Molo",                                                    "elo",     "",   "",    false, false },
  { u8"El Nayar Cora",                                              "crn",     "",   "",    false, false },
  { u8"Elamite",                                                    "elx",     "",   "",    true,  false },
  { u8"Eleme",                                                      "elm",     "",   "",    false, false },
  { u8"Elepi",                                                      "ele",     "",   "",    false, false },
  { u8"Elfdalian",                                                  "ovd",     "",   "",    false, false },
  { u8"Elip",                                                       "ekm",     "",   "",    false, false },
  { u8"Elkei",                                                      "elk",     "",   "",    false, false },
  { u8"Elotepec Zapotec",                                           "zte",     "",   "",    false, false },
  { u8"Eloyi",                                                      "afo",     "",   "",    false, false },
  { u8"Elpaputih",                                                  "elp",     "",   "",    false, true  },
  { u8"Elseng",                                                     "mrf",     "",   "",    false, false },
  { u8"Elu",                                                        "elu",     "",   "",    false, false },
  { u8"Elymian",                                                    "xly",     "",   "",    false, false },
  { u8"Emae",                                                       "mmw",     "",   "",    false, false },
  { u8"Emai-Iuleha-Ora",                                            "ema",     "",   "",    false, false },
  { u8"Eman",                                                       "emn",     "",   "",    false, false },
  { u8"Embaloh",                                                    "emb",     "",   "",    false, false },
  { u8"Emberá-Baudó",                                               "bdc",     "",   "",    false, false },
  { u8"Emberá-Catío",                                               "cto",     "",   "",    false, false },
  { u8"Emberá-Chamí",                                               "cmi",     "",   "",    false, false },
  { u8"Emberá-Tadó",                                                "tdc",     "",   "",    false, false },
  { u8"Embu",                                                       "ebu",     "",   "",    false, false },
  { u8"Emerillon",                                                  "eme",     "",   "",    false, false },
  { u8"Emilian",                                                    "egl",     "",   "",    false, false },
  { u8"Emok",                                                       "emo",     "",   "",    false, true  },
  { u8"Emplawas",                                                   "emw",     "",   "",    false, false },
  { u8"Emumu",                                                      "enr",     "",   "",    false, false },
  { u8"En",                                                         "enc",     "",   "",    false, false },
  { u8"Enawené-Nawé",                                               "unk",     "",   "",    false, false },
  { u8"Ende",                                                       "end",     "",   "",    false, false },
  { u8"Enga",                                                       "enq",     "",   "",    false, false },
  { u8"Engdewu",                                                    "ngr",     "",   "",    false, false },
  { u8"Engenni",                                                    "enn",     "",   "",    false, false },
  { u8"Enggano",                                                    "eno",     "",   "",    false, false },
  { u8"English",                                                    "eng",     "en", "",    true,  false },
  { u8"Enlhet",                                                     "enl",     "",   "",    false, false },
  { u8"Enrekang",                                                   "ptt",     "",   "",    false, false },
  { u8"Enu",                                                        "enu",     "",   "",    false, false },
  { u8"Enwan (Akwa Ibom State)",                                    "enw",     "",   "",    false, false },
  { u8"Enwan (Edo State)",                                          "env",     "",   "",    false, false },
  { u8"Enxet",                                                      "enx",     "",   "",    false, false },
  { u8"Enya",                                                       "gey",     "",   "",    false, false },
  { u8"Epena",                                                      "sja",     "",   "",    false, false },
  { u8"Epi-Olmec",                                                  "xep",     "",   "",    false, false },
  { u8"Epie",                                                       "epi",     "",   "",    false, false },
  { u8"Epigraphic Mayan",                                           "emy",     "",   "",    false, false },
  { u8"Eravallan",                                                  "era",     "",   "",    false, false },
  { u8"Erave",                                                      "kjy",     "",   "",    false, false },
  { u8"Ere",                                                        "twp",     "",   "",    false, false },
  { u8"Eritai",                                                     "ert",     "",   "",    false, false },
  { u8"Erokwanas",                                                  "erw",     "",   "",    false, false },
  { u8"Erre",                                                       "err",     "",   "",    false, false },
  { u8"Erromintxela",                                               "emx",     "",   "",    false, false },
  { u8"Ersu",                                                       "ers",     "",   "",    false, false },
  { u8"Eruwa",                                                      "erh",     "",   "",    false, false },
  { u8"Erzya",                                                      "myv",     "",   "",    true,  false },
  { u8"Esan",                                                       "ish",     "",   "",    false, false },
  { u8"Ese Ejja",                                                   "ese",     "",   "",    false, false },
  { u8"Ese",                                                        "mcq",     "",   "",    false, false },
  { u8"Eshtehardi",                                                 "esh",     "",   "",    false, false },
  { u8"Esimbi",                                                     "ags",     "",   "",    false, false },
  { u8"Eskayan",                                                    "esy",     "",   "",    false, false },
  { u8"Eskimo-Aleut languages",                                     "esx",     "",   "",    false, false },
  { u8"Esperanto",                                                  "epo",     "eo", "",    true,  false },
  { u8"Esselen",                                                    "esq",     "",   "",    false, false },
  { u8"Estado de México Otomi",                                     "ots",     "",   "",    false, false },
  { u8"Estonian Sign Language",                                     "eso",     "",   "",    false, false },
  { u8"Estonian",                                                   "est",     "et", "",    true,  false },
  { u8"Esuma",                                                      "esm",     "",   "",    false, false },
  { u8"Etchemin",                                                   "etc",     "",   "",    false, false },
  { u8"Etebi",                                                      "etb",     "",   "",    false, false },
  { u8"Eten",                                                       "etx",     "",   "",    false, false },
  { u8"Eteocretan",                                                 "ecr",     "",   "",    false, false },
  { u8"Eteocypriot",                                                "ecy",     "",   "",    false, false },
  { u8"Ethiopian Sign Language",                                    "eth",     "",   "",    false, false },
  { u8"Etkywan",                                                    "ich",     "",   "",    false, false },
  { u8"Eton (Cameroon)",                                            "eto",     "",   "",    false, false },
  { u8"Eton (Vanuatu)",                                             "etn",     "",   "",    false, false },
  { u8"Etruscan",                                                   "ett",     "",   "",    false, false },
  { u8"Etulo",                                                      "utr",     "",   "",    false, false },
  { u8"Evant",                                                      "bzz",     "",   "",    false, false },
  { u8"Even",                                                       "eve",     "",   "",    false, false },
  { u8"Evenki",                                                     "evn",     "",   "",    false, false },
  { u8"Eviya",                                                      "gev",     "",   "",    false, false },
  { u8"Ewage-Notu",                                                 "nou",     "",   "",    false, false },
  { u8"Ewe",                                                        "ewe",     "ee", "",    true,  false },
  { u8"Ewondo",                                                     "ewo",     "",   "",    true,  false },
  { u8"Extremaduran",                                               "ext",     "",   "",    false, false },
  { u8"Eyak",                                                       "eya",     "",   "",    false, false },
  { u8"Ezaa",                                                       "eza",     "",   "",    false, false },
  { u8"Fa d'Ambu",                                                  "fab",     "",   "",    false, false },
  { u8"Fagani",                                                     "faf",     "",   "",    false, false },
  { u8"Faifi",                                                      "fif",     "",   "",    false, false },
  { u8"Faire Atta",                                                 "azt",     "",   "",    false, false },
  { u8"Faita",                                                      "faj",     "",   "",    false, false },
  { u8"Faiwol",                                                     "fai",     "",   "",    false, false },
  { u8"Fala",                                                       "fax",     "",   "",    false, false },
  { u8"Falam Chin",                                                 "cfm",     "",   "",    false, false },
  { u8"Fali",                                                       "fli",     "",   "",    false, false },
  { u8"Faliscan",                                                   "xfa",     "",   "",    false, false },
  { u8"Fam",                                                        "fam",     "",   "",    false, false },
  { u8"Fanagalo",                                                   "fng",     "",   "",    false, false },
  { u8"Fanamaket",                                                  "bjp",     "",   "",    false, false },
  { u8"Fanbak",                                                     "fnb",     "",   "",    false, false },
  { u8"Fang (Cameroon)",                                            "fak",     "",   "",    false, false },
  { u8"Fang (Equatorial Guinea)",                                   "fan",     "",   "",    true,  false },
  { u8"Fania",                                                      "fni",     "",   "",    false, false },
  { u8"Fanti",                                                      "fat",     "",   "",    true,  false },
  { u8"Far Western Muria",                                          "fmu",     "",   "",    false, false },
  { u8"Farefare",                                                   "gur",     "",   "",    false, false },
  { u8"Faroese",                                                    "fao",     "fo", "",    true,  false },
  { u8"Fas",                                                        "fqs",     "",   "",    false, false },
  { u8"Fasu",                                                       "faa",     "",   "",    false, false },
  { u8"Fataleka",                                                   "far",     "",   "",    false, false },
  { u8"Fataluku",                                                   "ddg",     "",   "",    false, false },
  { u8"Fayu",                                                       "fau",     "",   "",    false, false },
  { u8"Fe'fe'",                                                     "fmp",     "",   "",    false, false },
  { u8"Fembe",                                                      "agl",     "",   "",    false, false },
  { u8"Fernando Po Creole English",                                 "fpe",     "",   "",    false, false },
  { u8"Feroge",                                                     "fer",     "",   "",    false, false },
  { u8"Fiji Hindi",                                                 "hif",     "",   "",    false, false },
  { u8"Fijian",                                                     "fij",     "fj", "",    true,  false },
  { u8"Filipino",                                                   "fil",     "",   "",    true,  false },
  { u8"Filomena Mata-Coahuitlán Totonac",                           "tlp",     "",   "",    false, false },
  { u8"Finallig",                                                   "bkb",     "",   "",    false, true  },
  { u8"Finland-Swedish Sign Language",                              "fss",     "",   "",    false, false },
  { u8"Finnish Sign Language",                                      "fse",     "",   "",    false, false },
  { u8"Finnish",                                                    "fin",     "fi", "",    true,  false },
  { u8"Finno-Ugrian languages",                                     "fiu",     "",   "",    true,  false },
  { u8"Finongan",                                                   "fag",     "",   "",    false, false },
  { u8"Fipa",                                                       "fip",     "",   "",    false, false },
  { u8"Firan",                                                      "fir",     "",   "",    false, false },
  { u8"Fiwaga",                                                     "fiw",     "",   "",    false, false },
  { u8"Flaaitaal",                                                  "fly",     "",   "",    false, false },
  { u8"Flinders Island",                                            "fln",     "",   "",    false, false },
  { u8"Foau",                                                       "flh",     "",   "",    false, false },
  { u8"Foi",                                                        "foi",     "",   "",    false, false },
  { u8"Foia Foia",                                                  "ffi",     "",   "",    false, false },
  { u8"Folopa",                                                     "ppo",     "",   "",    false, false },
  { u8"Foma",                                                       "fom",     "",   "",    false, false },
  { u8"Fon",                                                        "fon",     "",   "",    true,  false },
  { u8"Fongoro",                                                    "fgr",     "",   "",    false, false },
  { u8"Foodo",                                                      "fod",     "",   "",    false, false },
  { u8"Forak",                                                      "frq",     "",   "",    false, false },
  { u8"Fordata",                                                    "frd",     "",   "",    false, false },
  { u8"Fore",                                                       "for",     "",   "",    false, false },
  { u8"Forest Enets",                                               "enf",     "",   "",    false, false },
  { u8"Forest Maninka",                                             "myq",     "",   "",    false, true  },
  { u8"Formosan languages",                                         "fox",     "",   "",    false, false },
  { u8"Fortsenal",                                                  "frt",     "",   "",    false, false },
  { u8"Francisco León Zoque",                                       "zos",     "",   "",    false, false },
  { u8"Frankish",                                                   "frk",     "",   "",    false, false },
  { u8"French Sign Language",                                       "fsl",     "",   "",    false, false },
  { u8"French",                                                     "fre",     "fr", "fra", true,  false },
  { u8"Friulian",                                                   "fur",     "",   "",    true,  false },
  { u8"Fulah",                                                      "ful",     "ff", "",    true,  false },
  { u8"Fuliiru",                                                    "flr",     "",   "",    false, false },
  { u8"Fulniô",                                                     "fun",     "",   "",    false, false },
  { u8"Fum",                                                        "fum",     "",   "",    false, false },
  { u8"Fungwa",                                                     "ula",     "",   "",    false, false },
  { u8"Fur",                                                        "fvr",     "",   "",    false, false },
  { u8"Furu",                                                       "fuu",     "",   "",    false, false },
  { u8"Futuna-Aniwa",                                               "fut",     "",   "",    false, false },
  { u8"Fuyug",                                                      "fuy",     "",   "",    false, false },
  { u8"Fwe",                                                        "fwe",     "",   "",    false, false },
  { u8"Fwâi",                                                       "fwa",     "",   "",    false, false },
  { u8"Fyam",                                                       "pym",     "",   "",    false, false },
  { u8"Fyer",                                                       "fie",     "",   "",    false, false },
  { u8"Ga",                                                         "gaa",     "",   "",    true,  false },
  { u8"Ga'anda",                                                    "gqa",     "",   "",    false, false },
  { u8"Ga'dang",                                                    "gdg",     "",   "",    false, false },
  { u8"Gaa",                                                        "ttb",     "",   "",    false, false },
  { u8"Gaam",                                                       "tbi",     "",   "",    false, false },
  { u8"Gabi-Gabi",                                                  "gbw",     "",   "",    false, false },
  { u8"Gabri",                                                      "gab",     "",   "",    false, false },
  { u8"Gabrielino-Fernandeño",                                      "xgf",     "",   "",    false, false },
  { u8"Gabutamon",                                                  "gav",     "",   "",    false, true  },
  { u8"Gadang",                                                     "gdk",     "",   "",    false, false },
  { u8"Gaddang",                                                    "gad",     "",   "",    false, false },
  { u8"Gaddi",                                                      "gbk",     "",   "",    false, false },
  { u8"Gade Lohar",                                                 "gda",     "",   "",    false, false },
  { u8"Gade",                                                       "ged",     "",   "",    false, false },
  { u8"Gadjerawang",                                                "gdh",     "",   "",    false, false },
  { u8"Gadsup",                                                     "gaj",     "",   "",    false, false },
  { u8"Gafat",                                                      "gft",     "",   "",    false, false },
  { u8"Gagadu",                                                     "gbu",     "",   "",    false, false },
  { u8"Gagauz",                                                     "gag",     "",   "",    false, false },
  { u8"Gagnoa Bété",                                                "btg",     "",   "",    false, false },
  { u8"Gagu",                                                       "ggu",     "",   "",    false, false },
  { u8"Gahri",                                                      "bfu",     "",   "",    false, false },
  { u8"Gaikundi",                                                   "gbf",     "",   "",    false, false },
  { u8"Gail",                                                       "gic",     "",   "",    false, false },
  { u8"Gaina",                                                      "gcn",     "",   "",    false, false },
  { u8"Gal",                                                        "gap",     "",   "",    false, false },
  { u8"Galambu",                                                    "glo",     "",   "",    false, false },
  { u8"Galatian",                                                   "xga",     "",   "",    false, false },
  { u8"Galela",                                                     "gbi",     "",   "",    false, false },
  { u8"Galeya",                                                     "gar",     "",   "",    false, false },
  { u8"Galibi Carib",                                               "car",     "",   "",    true,  false },
  { u8"Galice",                                                     "gce",     "",   "",    false, false },
  { u8"Galician",                                                   "glg",     "gl", "",    true,  false },
  { u8"Galindan",                                                   "xgl",     "",   "",    false, false },
  { u8"Gallurese Sardinian",                                        "sdn",     "",   "",    false, false },
  { u8"Galo",                                                       "adl",     "",   "",    false, false },
  { u8"Galolen",                                                    "gal",     "",   "",    false, false },
  { u8"Gamale Kham",                                                "kgj",     "",   "",    false, false },
  { u8"Gambera",                                                    "gma",     "",   "",    false, false },
  { u8"Gambian Wolof",                                              "wof",     "",   "",    false, false },
  { u8"Gamilaraay",                                                 "kld",     "",   "",    false, false },
  { u8"Gamit",                                                      "gbl",     "",   "",    false, false },
  { u8"Gamkonora",                                                  "gak",     "",   "",    false, false },
  { u8"Gamo",                                                       "gmv",     "",   "",    false, false },
  { u8"Gamo-Ningi",                                                 "bte",     "",   "",    false, false },
  { u8"Gan Chinese",                                                "gan",     "",   "",    false, false },
  { u8"Gana",                                                       "gnq",     "",   "",    false, false },
  { u8"Ganang",                                                     "gne",     "",   "",    false, false },
  { u8"Ganda",                                                      "lug",     "lg", "",    true,  false },
  { u8"Gane",                                                       "gzn",     "",   "",    false, false },
  { u8"Ganggalida",                                                 "gcd",     "",   "",    false, false },
  { u8"Ganglau",                                                    "ggl",     "",   "",    false, false },
  { u8"Gangte",                                                     "gnb",     "",   "",    false, false },
  { u8"Gangulu",                                                    "gnl",     "",   "",    false, false },
  { u8"Gants",                                                      "gao",     "",   "",    false, false },
  { u8"Ganza",                                                      "gza",     "",   "",    false, false },
  { u8"Ganzi",                                                      "gnz",     "",   "",    false, false },
  { u8"Gao",                                                        "gga",     "",   "",    false, false },
  { u8"Gapapaiwa",                                                  "pwg",     "",   "",    false, false },
  { u8"Garawa",                                                     "gbc",     "",   "",    false, true  },
  { u8"Garhwali",                                                   "gbm",     "",   "",    false, false },
  { u8"Garifuna",                                                   "cab",     "",   "",    false, false },
  { u8"Garig-Ilgar",                                                "ilg",     "",   "",    false, false },
  { u8"Garingbal",                                                  "xgi",     "",   "",    false, false },
  { u8"Garlali",                                                    "gll",     "",   "",    false, false },
  { u8"Garo",                                                       "grt",     "",   "",    false, false },
  { u8"Garre",                                                      "gex",     "",   "",    false, false },
  { u8"Garrwa",                                                     "wrk",     "",   "",    false, false },
  { u8"Garus",                                                      "gyb",     "",   "",    false, false },
  { u8"Garza",                                                      "xgr",     "",   "",    false, false },
  { u8"Gata'",                                                      "gaq",     "",   "",    false, false },
  { u8"Gavak",                                                      "dmc",     "",   "",    false, false },
  { u8"Gavar",                                                      "gou",     "",   "",    false, false },
  { u8"Gavião Do Jiparaná",                                         "gvo",     "",   "",    false, false },
  { u8"Gawar-Bati",                                                 "gwt",     "",   "",    false, false },
  { u8"Gawri",                                                      "gwc",     "",   "",    false, false },
  { u8"Gawwada",                                                    "gwd",     "",   "",    false, false },
  { u8"Gayil",                                                      "gyl",     "",   "",    false, false },
  { u8"Gayo",                                                       "gay",     "",   "",    true,  false },
  { u8"Gazi",                                                       "gzi",     "",   "",    false, false },
  { u8"Gaɓogbo",                                                    "gie",     "",   "",    false, false },
  { u8"Gbagyi",                                                     "gbr",     "",   "",    false, false },
  { u8"Gbanu",                                                      "gbv",     "",   "",    false, false },
  { u8"Gbanziri",                                                   "gbg",     "",   "",    false, false },
  { u8"Gbari",                                                      "gby",     "",   "",    false, false },
  { u8"Gbati-ri",                                                   "gti",     "",   "",    false, true  },
  { u8"Gbaya (Central African Republic)",                           "gba",     "",   "",    true,  false },
  { u8"Gbaya (Sudan)",                                              "krs",     "",   "",    false, false },
  { u8"Gbaya-Bossangoa",                                            "gbp",     "",   "",    false, false },
  { u8"Gbaya-Bozoum",                                               "gbq",     "",   "",    false, false },
  { u8"Gbaya-Mbodomo",                                              "gmm",     "",   "",    false, false },
  { u8"Gbayi",                                                      "gyg",     "",   "",    false, false },
  { u8"Gbesi Gbe",                                                  "gbs",     "",   "",    false, false },
  { u8"Gbii",                                                       "ggb",     "",   "",    false, false },
  { u8"Gbin",                                                       "xgb",     "",   "",    false, false },
  { u8"Gbiri-Niragu",                                               "grh",     "",   "",    false, false },
  { u8"Gboloo Grebo",                                               "gec",     "",   "",    false, false },
  { u8"Ge",                                                         "hmj",     "",   "",    false, false },
  { u8"Geba Karen",                                                 "kvq",     "",   "",    false, false },
  { u8"Gebe",                                                       "gei",     "",   "",    false, false },
  { u8"Gedaged",                                                    "gdd",     "",   "",    false, false },
  { u8"Gedeo",                                                      "drs",     "",   "",    false, false },
  { u8"Geez",                                                       "gez",     "",   "",    true,  false },
  { u8"Geji",                                                       "gji",     "",   "",    false, true  },
  { u8"Geji",                                                       "gyz",     "",   "",    false, false },
  { u8"Geko Karen",                                                 "ghk",     "",   "",    false, false },
  { u8"Gela",                                                       "nlg",     "",   "",    false, false },
  { u8"Gelao",                                                      "gio",     "",   "",    false, true  },
  { u8"Geme",                                                       "geq",     "",   "",    false, false },
  { u8"Gen",                                                        "gej",     "",   "",    false, false },
  { u8"Gende",                                                      "gaf",     "",   "",    false, false },
  { u8"Gengle",                                                     "geg",     "",   "",    false, false },
  { u8"Georgian",                                                   "geo",     "ka", "kat", true,  false },
  { u8"Gepo",                                                       "ygp",     "",   "",    false, false },
  { u8"Gera",                                                       "gew",     "",   "",    false, false },
  { u8"Gerai",                                                      "gef",     "",   "",    false, false },
  { u8"German Sign Language",                                       "gsg",     "",   "",    false, false },
  { u8"German",                                                     "ger",     "de", "deu", true,  false },
  { u8"Germanic languages",                                         "gem",     "",   "",    true,  false },
  { u8"Geruma",                                                     "gea",     "",   "",    false, false },
  { u8"Geser-Gorom",                                                "ges",     "",   "",    false, false },
  { u8"Gey",                                                        "guv",     "",   "",    false, true  },
  { u8"Ghadamès",                                                   "gha",     "",   "",    false, false },
  { u8"Ghanaian Pidgin English",                                    "gpe",     "",   "",    false, false },
  { u8"Ghanaian Sign Language",                                     "gse",     "",   "",    false, false },
  { u8"Ghandruk Sign Language",                                     "gds",     "",   "",    false, false },
  { u8"Ghanongga",                                                  "ghn",     "",   "",    false, false },
  { u8"Ghari",                                                      "gri",     "",   "",    false, false },
  { u8"Ghayavi",                                                    "bmk",     "",   "",    false, false },
  { u8"Gheg Albanian",                                              "aln",     "",   "",    false, false },
  { u8"Ghera",                                                      "ghr",     "",   "",    false, false },
  { u8"Ghodoberi",                                                  "gdo",     "",   "",    false, false },
  { u8"Ghomara",                                                    "gho",     "",   "",    false, false },
  { u8"Ghomálá'",                                                   "bbj",     "",   "",    false, false },
  { u8"Ghotuo",                                                     "aaa",     "",   "",    false, false },
  { u8"Ghulfan",                                                    "ghl",     "",   "",    false, false },
  { u8"Giangan",                                                    "bgi",     "",   "",    false, false },
  { u8"Gibanawa",                                                   "gib",     "",   "",    false, false },
  { u8"Gidar",                                                      "gid",     "",   "",    false, false },
  { u8"Giiwo",                                                      "kks",     "",   "",    false, false },
  { u8"Gikyode",                                                    "acd",     "",   "",    false, false },
  { u8"Gilaki",                                                     "glk",     "",   "",    false, false },
  { u8"Gilbertese",                                                 "gil",     "",   "",    true,  false },
  { u8"Gilima",                                                     "gix",     "",   "",    false, false },
  { u8"Gilyak",                                                     "niv",     "",   "",    false, false },
  { u8"Gimi (Eastern Highlands)",                                   "gim",     "",   "",    false, false },
  { u8"Gimi (West New Britain)",                                    "gip",     "",   "",    false, false },
  { u8"Gimme",                                                      "kmp",     "",   "",    false, false },
  { u8"Gimnime",                                                    "gmn",     "",   "",    false, false },
  { u8"Ginuman",                                                    "gnm",     "",   "",    false, false },
  { u8"Ginyanga",                                                   "ayg",     "",   "",    false, false },
  { u8"Girawa",                                                     "bbr",     "",   "",    false, false },
  { u8"Girirra",                                                    "gii",     "",   "",    false, false },
  { u8"Giryama",                                                    "nyf",     "",   "",    false, false },
  { u8"Githabul",                                                   "gih",     "",   "",    false, false },
  { u8"Gitonga",                                                    "toh",     "",   "",    false, false },
  { u8"Gitua",                                                      "ggt",     "",   "",    false, false },
  { u8"Gitxsan",                                                    "git",     "",   "",    false, false },
  { u8"Giyug",                                                      "giy",     "",   "",    false, false },
  { u8"Gizrra",                                                     "tof",     "",   "",    false, false },
  { u8"Glaro-Twabo",                                                "glr",     "",   "",    false, false },
  { u8"Glavda",                                                     "glw",     "",   "",    false, false },
  { u8"Glio-Oubi",                                                  "oub",     "",   "",    false, false },
  { u8"Gnau",                                                       "gnu",     "",   "",    false, false },
  { u8"Goan Konkani",                                               "gom",     "",   "",    false, false },
  { u8"Goaria",                                                     "gig",     "",   "",    false, false },
  { u8"Gobasi",                                                     "goi",     "",   "",    false, false },
  { u8"Gobu",                                                       "gox",     "",   "",    false, false },
  { u8"Godié",                                                      "god",     "",   "",    false, false },
  { u8"Godwari",                                                    "gdx",     "",   "",    false, false },
  { u8"Goemai",                                                     "ank",     "",   "",    false, false },
  { u8"Gofa",                                                       "gof",     "",   "",    false, false },
  { u8"Gogo",                                                       "gog",     "",   "",    false, false },
  { u8"Gogodala",                                                   "ggw",     "",   "",    false, false },
  { u8"Gokana",                                                     "gkn",     "",   "",    false, false },
  { u8"Gola",                                                       "gol",     "",   "",    false, false },
  { u8"Golin",                                                      "gvf",     "",   "",    false, false },
  { u8"Golpa",                                                      "lja",     "",   "",    false, false },
  { u8"Gondi",                                                      "gon",     "",   "",    true,  false },
  { u8"Gone Dau",                                                   "goo",     "",   "",    false, false },
  { u8"Gongduk",                                                    "goe",     "",   "",    false, false },
  { u8"Gonja",                                                      "gjn",     "",   "",    false, false },
  { u8"Goo",                                                        "gov",     "",   "",    false, false },
  { u8"Gooniyandi",                                                 "gni",     "",   "",    false, false },
  { u8"Gor",                                                        "gqr",     "",   "",    false, false },
  { u8"Gorakor",                                                    "goc",     "",   "",    false, false },
  { u8"Gorap",                                                      "goq",     "",   "",    false, false },
  { u8"Goreng",                                                     "xgg",     "",   "",    false, false },
  { u8"Gorontalo",                                                  "gor",     "",   "",    true,  false },
  { u8"Gorovu",                                                     "grq",     "",   "",    false, false },
  { u8"Gorowa",                                                     "gow",     "",   "",    false, false },
  { u8"Gothic",                                                     "got",     "",   "",    true,  false },
  { u8"Goundo",                                                     "goy",     "",   "",    false, false },
  { u8"Gourmanchéma",                                               "gux",     "",   "",    false, false },
  { u8"Gowlan",                                                     "goj",     "",   "",    false, false },
  { u8"Gowli",                                                      "gok",     "",   "",    false, false },
  { u8"Gowro",                                                      "gwf",     "",   "",    false, false },
  { u8"Gozarkhani",                                                 "goz",     "",   "",    false, false },
  { u8"Grangali",                                                   "nli",     "",   "",    false, false },
  { u8"Grass Koiari",                                               "kbk",     "",   "",    false, false },
  { u8"Grebo",                                                      "grb",     "",   "",    true,  false },
  { u8"Greek (ancient, -1453)",                                     "grc",     "",   "",    true,  false },
  { u8"Greek (modern, 1453-)",                                      "gre",     "el", "ell", true,  false },
  { u8"Greek Sign Language",                                        "gss",     "",   "",    false, false },
  { u8"Greek languages",                                            "grk",     "",   "",    false, false },
  { u8"Green Gelao",                                                "giq",     "",   "",    false, false },
  { u8"Grenadian Creole English",                                   "gcl",     "",   "",    false, false },
  { u8"Gresi",                                                      "grs",     "",   "",    false, false },
  { u8"Groma",                                                      "gro",     "",   "",    false, false },
  { u8"Gronings",                                                   "gos",     "",   "",    false, false },
  { u8"Gros Ventre",                                                "ats",     "",   "",    false, false },
  { u8"Gua",                                                        "gwx",     "",   "",    false, false },
  { u8"Guadeloupean Creole French",                                 "gcf",     "",   "",    false, false },
  { u8"Guahibo",                                                    "guh",     "",   "",    false, false },
  { u8"Guajajára",                                                  "gub",     "",   "",    false, false },
  { u8"Guajá",                                                      "gvj",     "",   "",    false, false },
  { u8"Guambiano",                                                  "gum",     "",   "",    false, false },
  { u8"Guana (Brazil)",                                             "gqn",     "",   "",    false, false },
  { u8"Guana (Paraguay)",                                           "gva",     "",   "",    false, false },
  { u8"Guanano",                                                    "gvc",     "",   "",    false, false },
  { u8"Guanche",                                                    "gnc",     "",   "",    false, false },
  { u8"Guanyinqiao",                                                "jiq",     "",   "",    false, false },
  { u8"Guarani",                                                    "grn",     "gn", "",    true,  false },
  { u8"Guarayu",                                                    "gyr",     "",   "",    false, false },
  { u8"Guarequena",                                                 "gae",     "",   "",    false, false },
  { u8"Guatemalan Sign Language",                                   "gsm",     "",   "",    false, false },
  { u8"Guató",                                                      "gta",     "",   "",    false, false },
  { u8"Guayabero",                                                  "guo",     "",   "",    false, false },
  { u8"Gudang",                                                     "xgd",     "",   "",    false, false },
  { u8"Gudanji",                                                    "nji",     "",   "",    false, false },
  { u8"Gude",                                                       "gde",     "",   "",    false, false },
  { u8"Gudu",                                                       "gdu",     "",   "",    false, false },
  { u8"Guduf-Gava",                                                 "gdf",     "",   "",    false, false },
  { u8"Guerrero Amuzgo",                                            "amu",     "",   "",    false, false },
  { u8"Guerrero Nahuatl",                                           "ngu",     "",   "",    false, false },
  { u8"Guevea De Humboldt Zapotec",                                 "zpg",     "",   "",    false, false },
  { u8"Gugadj",                                                     "ggd",     "",   "",    false, false },
  { u8"Gugu Badhun",                                                "gdc",     "",   "",    false, false },
  { u8"Gugu Warra",                                                 "wrw",     "",   "",    false, false },
  { u8"Gugubera",                                                   "kkp",     "",   "",    false, false },
  { u8"Guhu-Samane",                                                "ghs",     "",   "",    false, false },
  { u8"Guianese Creole French",                                     "gcr",     "",   "",    false, false },
  { u8"Guibei Zhuang",                                              "zgb",     "",   "",    false, false },
  { u8"Guiberoua Béte",                                             "bet",     "",   "",    false, false },
  { u8"Guibian Zhuang",                                             "zgn",     "",   "",    false, false },
  { u8"Guinea Kpelle",                                              "gkp",     "",   "",    false, false },
  { u8"Guinean Sign Language",                                      "gus",     "",   "",    false, false },
  { u8"Guiqiong",                                                   "gqi",     "",   "",    false, false },
  { u8"Gujarati",                                                   "guj",     "gu", "",    true,  false },
  { u8"Gujari",                                                     "gju",     "",   "",    false, false },
  { u8"Gula (Central African Republic)",                            "kcm",     "",   "",    false, false },
  { u8"Gula (Chad)",                                                "glu",     "",   "",    false, false },
  { u8"Gula Iro",                                                   "glj",     "",   "",    false, false },
  { u8"Gula'alaa",                                                  "gmb",     "",   "",    false, false },
  { u8"Gulay",                                                      "gvl",     "",   "",    false, false },
  { u8"Gule",                                                       "gly",     "",   "",    false, false },
  { u8"Gulf Arabic",                                                "afb",     "",   "",    false, false },
  { u8"Guliguli",                                                   "gli",     "",   "",    false, true  },
  { u8"Gumalu",                                                     "gmu",     "",   "",    false, false },
  { u8"Gumatj",                                                     "gnn",     "",   "",    false, false },
  { u8"Gumawana",                                                   "gvs",     "",   "",    false, false },
  { u8"Gumuz",                                                      "guk",     "",   "",    false, false },
  { u8"Gun",                                                        "guw",     "",   "",    false, false },
  { u8"Gundi",                                                      "gdi",     "",   "",    false, false },
  { u8"Gunditjmara",                                                "gjm",     "",   "",    false, false },
  { u8"Gundungurra",                                                "xrd",     "",   "",    false, false },
  { u8"Gungabula",                                                  "gyf",     "",   "",    false, false },
  { u8"Gungu",                                                      "rub",     "",   "",    false, false },
  { u8"Guntai",                                                     "gnt",     "",   "",    false, false },
  { u8"Gunwinggu",                                                  "gup",     "",   "",    false, false },
  { u8"Gunya",                                                      "gyy",     "",   "",    false, false },
  { u8"Gupa-Abawa",                                                 "gpa",     "",   "",    false, false },
  { u8"Gupapuyngu",                                                 "guf",     "",   "",    false, false },
  { u8"Guramalum",                                                  "grz",     "",   "",    false, false },
  { u8"Gurani",                                                     "hac",     "",   "",    false, false },
  { u8"Gurdjar",                                                    "gdj",     "",   "",    false, false },
  { u8"Gureng Gureng",                                              "gnr",     "",   "",    false, false },
  { u8"Gurgula",                                                    "ggg",     "",   "",    false, false },
  { u8"Guriaso",                                                    "grx",     "",   "",    false, false },
  { u8"Gurindji Kriol",                                             "gjr",     "",   "",    false, false },
  { u8"Gurindji",                                                   "gue",     "",   "",    false, false },
  { u8"Gurmana",                                                    "gvm",     "",   "",    false, false },
  { u8"Guro",                                                       "goa",     "",   "",    false, false },
  { u8"Gurr-goni",                                                  "gge",     "",   "",    false, false },
  { u8"Gurung",                                                     "gvr",     "",   "",    false, false },
  { u8"Guruntum-Mbaaru",                                            "grd",     "",   "",    false, false },
  { u8"Gusii",                                                      "guz",     "",   "",    false, false },
  { u8"Gusilay",                                                    "gsl",     "",   "",    false, false },
  { u8"Guugu Yimidhirr",                                            "kky",     "",   "",    false, false },
  { u8"Guwa",                                                       "xgw",     "",   "",    false, false },
  { u8"Guwamu",                                                     "gwu",     "",   "",    false, false },
  { u8"Guya",                                                       "gka",     "",   "",    false, false },
  { u8"Guyanese Creole English",                                    "gyn",     "",   "",    false, false },
  { u8"Guyani",                                                     "gvy",     "",   "",    false, false },
  { u8"Gvoko",                                                      "ngs",     "",   "",    false, false },
  { u8"Gwa",                                                        "gwb",     "",   "",    false, false },
  { u8"Gwahatike",                                                  "dah",     "",   "",    false, false },
  { u8"Gwak",                                                       "jgk",     "",   "",    false, false },
  { u8"Gwamhi-Wuri",                                                "bga",     "",   "",    false, false },
  { u8"Gwandara",                                                   "gwn",     "",   "",    false, false },
  { u8"Gweda",                                                      "grw",     "",   "",    false, false },
  { u8"Gweno",                                                      "gwe",     "",   "",    false, false },
  { u8"Gwere",                                                      "gwr",     "",   "",    false, false },
  { u8"Gwichʼin",                                                   "gwi",     "",   "",    true,  false },
  { u8"Gyalsumdo",                                                  "gyo",     "",   "",    false, false },
  { u8"Gyele",                                                      "gyi",     "",   "",    false, false },
  { u8"Gyem",                                                       "gye",     "",   "",    false, false },
  { u8"Güilá Zapotec",                                              "ztu",     "",   "",    false, false },
  { u8"Gāndhārī",                                                   "pgd",     "",   "",    false, false },
  { u8"Ha",                                                         "haq",     "",   "",    false, false },
  { u8"Habu",                                                       "hbu",     "",   "",    false, false },
  { u8"Hadiyya",                                                    "hdy",     "",   "",    false, false },
  { u8"Hadothi",                                                    "hoj",     "",   "",    false, false },
  { u8"Hadrami Arabic",                                             "ayh",     "",   "",    false, false },
  { u8"Hadrami",                                                    "xhd",     "",   "",    false, false },
  { u8"Hadza",                                                      "hts",     "",   "",    false, false },
  { u8"Haeke",                                                      "aek",     "",   "",    false, false },
  { u8"Hahon",                                                      "hah",     "",   "",    false, false },
  { u8"Haida",                                                      "hai",     "",   "",    true,  false },
  { u8"Haigwai",                                                    "hgw",     "",   "",    false, false },
  { u8"Haiphong Sign Language",                                     "haf",     "",   "",    false, false },
  { u8"Haisla",                                                     "has",     "",   "",    false, false },
  { u8"Haitian Vodoun Culture Language",                            "hvc",     "",   "",    false, false },
  { u8"Haitian",                                                    "hat",     "ht", "",    true,  false },
  { u8"Haiǁom",                                                     "hgm",     "",   "",    false, false },
  { u8"Haji",                                                       "hji",     "",   "",    false, false },
  { u8"Hajong",                                                     "haj",     "",   "",    false, false },
  { u8"Hakha Chin",                                                 "cnh",     "",   "",    false, false },
  { u8"Hakka Chinese",                                              "hak",     "",   "",    false, false },
  { u8"Hakö",                                                       "hao",     "",   "",    false, false },
  { u8"Halang Doan",                                                "hld",     "",   "",    false, false },
  { u8"Halang",                                                     "hal",     "",   "",    false, false },
  { u8"Halbi",                                                      "hlb",     "",   "",    false, false },
  { u8"Halh Mongolian",                                             "khk",     "",   "",    false, false },
  { u8"Halia",                                                      "hla",     "",   "",    false, false },
  { u8"Halkomelem",                                                 "hur",     "",   "",    false, false },
  { u8"Hamap",                                                      "hmu",     "",   "",    false, false },
  { u8"Hamba",                                                      "hba",     "",   "",    false, false },
  { u8"Hamer-Banna",                                                "amf",     "",   "",    false, false },
  { u8"Hamtai",                                                     "hmt",     "",   "",    false, false },
  { u8"Han",                                                        "haa",     "",   "",    false, false },
  { u8"Hanga Hundi",                                                "wos",     "",   "",    false, false },
  { u8"Hanga",                                                      "hag",     "",   "",    false, false },
  { u8"Hangaza",                                                    "han",     "",   "",    false, false },
  { u8"Hani",                                                       "hni",     "",   "",    false, false },
  { u8"Hano",                                                       "lml",     "",   "",    false, false },
  { u8"Hanoi Sign Language",                                        "hab",     "",   "",    false, false },
  { u8"Hanunoo",                                                    "hnn",     "",   "",    false, false },
  { u8"Harami",                                                     "xha",     "",   "",    false, false },
  { u8"Harari",                                                     "har",     "",   "",    false, false },
  { u8"Harijan Kinnauri",                                           "kjo",     "",   "",    false, false },
  { u8"Haroi",                                                      "hro",     "",   "",    false, false },
  { u8"Harsusi",                                                    "hss",     "",   "",    false, false },
  { u8"Haruai",                                                     "tmd",     "",   "",    false, false },
  { u8"Haruku",                                                     "hrk",     "",   "",    false, false },
  { u8"Haryanvi",                                                   "bgc",     "",   "",    false, false },
  { u8"Harzani",                                                    "hrz",     "",   "",    false, false },
  { u8"Hasha",                                                      "ybj",     "",   "",    false, false },
  { u8"Hassaniyya",                                                 "mey",     "",   "",    false, false },
  { u8"Hatam",                                                      "had",     "",   "",    false, false },
  { u8"Hattic",                                                     "xht",     "",   "",    false, false },
  { u8"Hausa Sign Language",                                        "hsl",     "",   "",    false, false },
  { u8"Hausa",                                                      "hau",     "ha", "",    true,  false },
  { u8"Havasupai-Walapai-Yavapai",                                  "yuf",     "",   "",    false, false },
  { u8"Haveke",                                                     "hvk",     "",   "",    false, false },
  { u8"Havu",                                                       "hav",     "",   "",    false, false },
  { u8"Hawai'i Creole English",                                     "hwc",     "",   "",    false, false },
  { u8"Hawai'i Sign Language (HSL)",                                "hps",     "",   "",    false, false },
  { u8"Hawaiian",                                                   "haw",     "",   "",    true,  false },
  { u8"Haya",                                                       "hay",     "",   "",    false, false },
  { u8"Hazaragi",                                                   "haz",     "",   "",    false, false },
  { u8"Hdi",                                                        "xed",     "",   "",    false, false },
  { u8"Hebrew",                                                     "heb",     "he", "",    true,  false },
  { u8"Hehe",                                                       "heh",     "",   "",    false, false },
  { u8"Heiban",                                                     "hbn",     "",   "",    false, false },
  { u8"Heiltsuk",                                                   "hei",     "",   "",    false, false },
  { u8"Helong",                                                     "heg",     "",   "",    false, false },
  { u8"Hema",                                                       "nix",     "",   "",    false, false },
  { u8"Hemba",                                                      "hem",     "",   "",    false, false },
  { u8"Herdé",                                                      "hed",     "",   "",    false, false },
  { u8"Herero",                                                     "her",     "hz", "",    true,  false },
  { u8"Hermit",                                                     "llf",     "",   "",    false, false },
  { u8"Hernican",                                                   "xhr",     "",   "",    false, false },
  { u8"Hewa",                                                       "ham",     "",   "",    false, false },
  { u8"Heyo",                                                       "auk",     "",   "",    false, false },
  { u8"Hiberno-Scottish Gaelic",                                    "ghc",     "",   "",    false, false },
  { u8"Hibito",                                                     "hib",     "",   "",    false, false },
  { u8"Hidatsa",                                                    "hid",     "",   "",    false, false },
  { u8"Hieroglyphic Luwian",                                        "hlu",     "",   "",    false, false },
  { u8"Higaonon",                                                   "mba",     "",   "",    false, false },
  { u8"Highland Konjo",                                             "kjk",     "",   "",    false, false },
  { u8"Highland Oaxaca Chontal",                                    "chd",     "",   "",    false, false },
  { u8"Highland Popoluca",                                          "poi",     "",   "",    false, false },
  { u8"Highland Puebla Nahuatl",                                    "azz",     "",   "",    false, false },
  { u8"Highland Totonac",                                           "tos",     "",   "",    false, false },
  { u8"Hijazi Arabic",                                              "acw",     "",   "",    false, false },
  { u8"Hijuk",                                                      "hij",     "",   "",    false, false },
  { u8"Hiligaynon",                                                 "hil",     "",   "",    true,  false },
  { u8"Himachali languages; Western Pahari languages",              "him",     "",   "",    true,  false },
  { u8"Himarimã",                                                   "hir",     "",   "",    false, false },
  { u8"Hindi",                                                      "hin",     "hi", "",    true,  false },
  { u8"Hinduri",                                                    "hii",     "",   "",    false, false },
  { u8"Hinukh",                                                     "gin",     "",   "",    false, false },
  { u8"Hiri Motu",                                                  "hmo",     "ho", "",    true,  false },
  { u8"Hittite",                                                    "hit",     "",   "",    true,  false },
  { u8"Hitu",                                                       "htu",     "",   "",    false, false },
  { u8"Hiw",                                                        "hiw",     "",   "",    false, false },
  { u8"Hixkaryána",                                                 "hix",     "",   "",    false, false },
  { u8"Hlai",                                                       "lic",     "",   "",    false, false },
  { u8"Hlepho Phowa",                                               "yhl",     "",   "",    false, false },
  { u8"Hlersu",                                                     "hle",     "",   "",    false, false },
  { u8"Hmar",                                                       "hmr",     "",   "",    false, false },
  { u8"Hmong Daw",                                                  "mww",     "",   "",    false, false },
  { u8"Hmong Don",                                                  "hmf",     "",   "",    false, false },
  { u8"Hmong Dô",                                                   "hmv",     "",   "",    false, false },
  { u8"Hmong Njua",                                                 "hnj",     "",   "",    false, false },
  { u8"Hmong Shua",                                                 "hmz",     "",   "",    false, false },
  { u8"Hmong",                                                      "hmn",     "",   "",    true,  false },
  { u8"Hmong-Mien languages",                                       "hmx",     "",   "",    false, false },
  { u8"Hmwaveke",                                                   "mrk",     "",   "",    false, false },
  { u8"Ho Chi Minh City Sign Language",                             "hos",     "",   "",    false, false },
  { u8"Ho",                                                         "hoc",     "",   "",    false, false },
  { u8"Ho-Chunk",                                                   "win",     "",   "",    false, false },
  { u8"Hoava",                                                      "hoa",     "",   "",    false, false },
  { u8"Hobyót",                                                     "hoh",     "",   "",    false, false },
  { u8"Hoia Hoia",                                                  "hhi",     "",   "",    false, false },
  { u8"Hokan languages",                                            "hok",     "",   "",    false, false },
  { u8"Holikachuk",                                                 "hoi",     "",   "",    false, false },
  { u8"Holiya",                                                     "hoy",     "",   "",    false, false },
  { u8"Holma",                                                      "hod",     "",   "",    false, false },
  { u8"Holoholo",                                                   "hoo",     "",   "",    false, false },
  { u8"Holu",                                                       "hol",     "",   "",    false, false },
  { u8"Homa",                                                       "hom",     "",   "",    false, false },
  { u8"Honduras Sign Language",                                     "hds",     "",   "",    false, false },
  { u8"Hong Kong Sign Language",                                    "hks",     "",   "",    false, false },
  { u8"Honi",                                                       "how",     "",   "",    false, false },
  { u8"Hopi",                                                       "hop",     "",   "",    false, false },
  { u8"Horned Miao",                                                "hrm",     "",   "",    false, false },
  { u8"Horo",                                                       "hor",     "",   "",    false, false },
  { u8"Horom",                                                      "hoe",     "",   "",    false, false },
  { u8"Horpa",                                                      "ero",     "",   "",    false, false },
  { u8"Horuru",                                                     "hrr",     "",   "",    false, true  },
  { u8"Hote",                                                       "hot",     "",   "",    false, false },
  { u8"Hoti",                                                       "hti",     "",   "",    false, false },
  { u8"Hovongan",                                                   "hov",     "",   "",    false, false },
  { u8"Hoyahoya",                                                   "hhy",     "",   "",    false, false },
  { u8"Hozo",                                                       "hoz",     "",   "",    false, false },
  { u8"Hpon",                                                       "hpo",     "",   "",    false, false },
  { u8"Hrangkhol",                                                  "hra",     "",   "",    false, false },
  { u8"Hre",                                                        "hre",     "",   "",    false, false },
  { u8"Hruso",                                                      "hru",     "",   "",    false, false },
  { u8"Hu",                                                         "huo",     "",   "",    false, false },
  { u8"Huachipaeri",                                                "hug",     "",   "",    false, false },
  { u8"Huallaga Huánuco Quechua",                                   "qub",     "",   "",    false, false },
  { u8"Huamalíes-Dos de Mayo Huánuco Quechua",                      "qvh",     "",   "",    false, false },
  { u8"Huambisa",                                                   "hub",     "",   "",    false, false },
  { u8"Huarijio",                                                   "var",     "",   "",    false, false },
  { u8"Huastec",                                                    "hus",     "",   "",    false, false },
  { u8"Huaulu",                                                     "hud",     "",   "",    false, false },
  { u8"Huautla Mazatec",                                            "mau",     "",   "",    false, false },
  { u8"Huaxcaleca Nahuatl",                                         "nhq",     "",   "",    false, false },
  { u8"Huaylas Ancash Quechua",                                     "qwh",     "",   "",    false, false },
  { u8"Huaylla Wanca Quechua",                                      "qvw",     "",   "",    false, false },
  { u8"Huba",                                                       "hbb",     "",   "",    false, false },
  { u8"Huehuetla Tepehua",                                          "tee",     "",   "",    false, false },
  { u8"Huichol",                                                    "hch",     "",   "",    false, false },
  { u8"Huilliche",                                                  "huh",     "",   "",    false, false },
  { u8"Huitepec Mixtec",                                            "mxs",     "",   "",    false, false },
  { u8"Huizhou Chinese",                                            "czh",     "",   "",    false, false },
  { u8"Hukumina",                                                   "huw",     "",   "",    false, false },
  { u8"Hula",                                                       "hul",     "",   "",    false, false },
  { u8"Hulaulá",                                                    "huy",     "",   "",    false, false },
  { u8"Huli",                                                       "hui",     "",   "",    false, false },
  { u8"Hulung",                                                     "huk",     "",   "",    false, false },
  { u8"Humburi Senni Songhay",                                      "hmb",     "",   "",    false, false },
  { u8"Humene",                                                     "huf",     "",   "",    false, false },
  { u8"Humla",                                                      "hut",     "",   "",    false, false },
  { u8"Hun-Saare",                                                  "dud",     "",   "",    false, true  },
  { u8"Hunde",                                                      "hke",     "",   "",    false, false },
  { u8"Hung",                                                       "hnu",     "",   "",    false, false },
  { u8"Hungana",                                                    "hum",     "",   "",    false, false },
  { u8"Hungarian Sign Language",                                    "hsh",     "",   "",    false, false },
  { u8"Hungarian",                                                  "hun",     "hu", "",    true,  false },
  { u8"Hungu",                                                      "hng",     "",   "",    false, false },
  { u8"Hunjara-Kaina Ke",                                           "hkk",     "",   "",    false, false },
  { u8"Hunnic",                                                     "xhc",     "",   "",    false, false },
  { u8"Hunsrik",                                                    "hrx",     "",   "",    false, false },
  { u8"Hunzib",                                                     "huz",     "",   "",    false, false },
  { u8"Hupa",                                                       "hup",     "",   "",    true,  false },
  { u8"Hupdë",                                                      "jup",     "",   "",    false, false },
  { u8"Hupla",                                                      "hap",     "",   "",    false, false },
  { u8"Hurrian",                                                    "xhu",     "",   "",    false, false },
  { u8"Hutterite German",                                           "geh",     "",   "",    false, false },
  { u8"Hwana",                                                      "hwo",     "",   "",    false, false },
  { u8"Hya",                                                        "hya",     "",   "",    false, false },
  { u8"Hyam",                                                       "jab",     "",   "",    false, false },
  { u8"Hyolmo",                                                     "scp",     "",   "",    false, false },
  { u8"Hértevin",                                                   "hrt",     "",   "",    false, false },
  { u8"Hõne",                                                       "juh",     "",   "",    false, false },
  { u8"I-Wak",                                                      "iwk",     "",   "",    false, false },
  { u8"Iaai",                                                       "iai",     "",   "",    false, false },
  { u8"Iamalele",                                                   "yml",     "",   "",    false, false },
  { u8"Iapama",                                                     "iap",     "",   "",    false, true  },
  { u8"Iatmul",                                                     "ian",     "",   "",    false, false },
  { u8"Iau",                                                        "tmu",     "",   "",    false, false },
  { u8"Ibali Teke",                                                 "tek",     "",   "",    false, false },
  { u8"Ibaloi",                                                     "ibl",     "",   "",    false, false },
  { u8"Iban",                                                       "iba",     "",   "",    true,  false },
  { u8"Ibanag",                                                     "ibg",     "",   "",    false, false },
  { u8"Ibani",                                                      "iby",     "",   "",    false, false },
  { u8"Ibatan",                                                     "ivb",     "",   "",    false, false },
  { u8"Iberian",                                                    "xib",     "",   "",    false, false },
  { u8"Ibibio",                                                     "ibb",     "",   "",    false, false },
  { u8"Ibilo",                                                      "ibi",     "",   "",    false, true  },
  { u8"Ibino",                                                      "ibn",     "",   "",    false, false },
  { u8"Ibu",                                                        "ibu",     "",   "",    false, false },
  { u8"Ibuoro",                                                     "ibr",     "",   "",    false, false },
  { u8"Icelandic Sign Language",                                    "icl",     "",   "",    false, false },
  { u8"Icelandic",                                                  "ice",     "is", "isl", true,  false },
  { u8"Iceve-Maci",                                                 "bec",     "",   "",    false, false },
  { u8"Ida'an",                                                     "dbj",     "",   "",    false, false },
  { u8"Idakho-Isukha-Tiriki",                                       "ida",     "",   "",    false, false },
  { u8"Idaté",                                                      "idt",     "",   "",    false, false },
  { u8"Idere",                                                      "ide",     "",   "",    false, false },
  { u8"Idesa",                                                      "ids",     "",   "",    false, false },
  { u8"Idi",                                                        "idi",     "",   "",    false, false },
  { u8"Ido",                                                        "ido",     "io", "",    true,  false },
  { u8"Idoma",                                                      "idu",     "",   "",    false, false },
  { u8"Idon",                                                       "idc",     "",   "",    false, false },
  { u8"Idu-Mishmi",                                                 "clk",     "",   "",    false, false },
  { u8"Iduna",                                                      "viv",     "",   "",    false, false },
  { u8"Ifo",                                                        "iff",     "",   "",    false, false },
  { u8"Ifè",                                                        "ife",     "",   "",    false, false },
  { u8"Igala",                                                      "igl",     "",   "",    false, false },
  { u8"Igana",                                                      "igg",     "",   "",    false, false },
  { u8"Igbo",                                                       "ibo",     "ig", "",    true,  false },
  { u8"Igede",                                                      "ige",     "",   "",    false, false },
  { u8"Ignaciano",                                                  "ign",     "",   "",    false, false },
  { u8"Igo",                                                        "ahl",     "",   "",    false, false },
  { u8"Iguta",                                                      "nar",     "",   "",    false, false },
  { u8"Igwe",                                                       "igw",     "",   "",    false, false },
  { u8"Iha Based Pidgin",                                           "ihb",     "",   "",    false, false },
  { u8"Iha",                                                        "ihp",     "",   "",    false, false },
  { u8"Ihievbe",                                                    "ihi",     "",   "",    false, false },
  { u8"Ija-Zuba",                                                   "vki",     "",   "",    false, true  },
  { u8"Ijo languages",                                              "ijo",     "",   "",    true,  false },
  { u8"Ik",                                                         "ikx",     "",   "",    false, false },
  { u8"Ika",                                                        "ikk",     "",   "",    false, false },
  { u8"Ikaranggal",                                                 "ikr",     "",   "",    false, false },
  { u8"Ikizu",                                                      "ikz",     "",   "",    false, false },
  { u8"Iko",                                                        "iki",     "",   "",    false, false },
  { u8"Ikobi",                                                      "meb",     "",   "",    false, false },
  { u8"Ikoma-Nata-Isenye",                                          "ntk",     "",   "",    false, false },
  { u8"Ikpeng",                                                     "txi",     "",   "",    false, false },
  { u8"Ikpeshi",                                                    "ikp",     "",   "",    false, false },
  { u8"Ikposo",                                                     "kpo",     "",   "",    false, false },
  { u8"Iku-Gora-Ankwa",                                             "ikv",     "",   "",    false, false },
  { u8"Ikulu",                                                      "ikl",     "",   "",    false, false },
  { u8"Ikwere",                                                     "ikw",     "",   "",    false, false },
  { u8"Ikwo",                                                       "iqw",     "",   "",    false, false },
  { u8"Ila",                                                        "ilb",     "",   "",    false, false },
  { u8"Ile Ape",                                                    "ila",     "",   "",    false, false },
  { u8"Ili Turki",                                                  "ili",     "",   "",    false, false },
  { u8"Ili'uun",                                                    "ilu",     "",   "",    false, false },
  { u8"Ilianen Manobo",                                             "mbi",     "",   "",    false, false },
  { u8"Illyrian",                                                   "xil",     "",   "",    false, false },
  { u8"Iloko",                                                      "ilo",     "",   "",    true,  false },
  { u8"Ilongot",                                                    "ilk",     "",   "",    false, false },
  { u8"Ilue",                                                       "ilv",     "",   "",    false, false },
  { u8"Ilwana",                                                     "mlk",     "",   "",    false, false },
  { u8"Imbabura Highland Quichua",                                  "qvi",     "",   "",    false, false },
  { u8"Imbongu",                                                    "imo",     "",   "",    false, false },
  { u8"Imeraguen",                                                  "ime",     "",   "",    false, true  },
  { u8"Imonda",                                                     "imn",     "",   "",    false, false },
  { u8"Imotong",                                                    "imt",     "",   "",    false, false },
  { u8"Imroing",                                                    "imr",     "",   "",    false, false },
  { u8"Inabaknon",                                                  "abx",     "",   "",    false, false },
  { u8"Inapang",                                                    "mzu",     "",   "",    false, false },
  { u8"Inari Sami",                                                 "smn",     "",   "",    true,  false },
  { u8"Indian Sign Language",                                       "ins",     "",   "",    false, false },
  { u8"Indic languages",                                            "inc",     "",   "",    true,  false },
  { u8"Indo-European languages",                                    "ine",     "",   "",    true,  false },
  { u8"Indo-Iranian languages",                                     "iir",     "",   "",    false, false },
  { u8"Indo-Portuguese",                                            "idb",     "",   "",    false, false },
  { u8"Indonesian Bajau",                                           "bdl",     "",   "",    false, false },
  { u8"Indonesian Sign Language",                                   "inl",     "",   "",    false, false },
  { u8"Indonesian",                                                 "ind",     "id", "",    true,  false },
  { u8"Indri",                                                      "idr",     "",   "",    false, false },
  { u8"Indus Kohistani",                                            "mvy",     "",   "",    false, false },
  { u8"Indus Valley Language",                                      "xiv",     "",   "",    false, false },
  { u8"Inebu One",                                                  "oin",     "",   "",    false, false },
  { u8"Ineseño",                                                    "inz",     "",   "",    false, false },
  { u8"Inga",                                                       "inb",     "",   "",    false, false },
  { u8"Ingrian",                                                    "izh",     "",   "",    false, false },
  { u8"Ingush",                                                     "inh",     "",   "",    true,  false },
  { u8"Inlaod Itneg",                                               "iti",     "",   "",    false, false },
  { u8"Innu",                                                       "moe",     "",   "",    false, false },
  { u8"Inoke-Yate",                                                 "ino",     "",   "",    false, false },
  { u8"Inonhan",                                                    "loc",     "",   "",    false, false },
  { u8"Inor",                                                       "ior",     "",   "",    false, false },
  { u8"Inpui Naga",                                                 "nkf",     "",   "",    false, false },
  { u8"Interglossa",                                                "igs",     "",   "",    false, false },
  { u8"Interlingua (International Auxiliary Language Association)", "ina",     "ia", "",    true,  false },
  { u8"Interlingue",                                                "ile",     "ie", "",    true,  false },
  { u8"International Sign",                                         "ils",     "",   "",    false, false },
  { u8"Intha",                                                      "int",     "",   "",    false, false },
  { u8"Inuinnaqtun",                                                "ikt",     "",   "",    false, false },
  { u8"Inuit Sign Language",                                        "iks",     "",   "",    false, false },
  { u8"Inuktitut",                                                  "iku",     "iu", "",    true,  false },
  { u8"Inupiaq",                                                    "ipk",     "ik", "",    true,  false },
  { u8"Iowa-Oto",                                                   "iow",     "",   "",    false, false },
  { u8"Ipalapa Amuzgo",                                             "azm",     "",   "",    false, false },
  { u8"Ipiko",                                                      "ipo",     "",   "",    false, false },
  { u8"Ipili",                                                      "ipi",     "",   "",    false, false },
  { u8"Ipulo",                                                      "ass",     "",   "",    false, false },
  { u8"Iquito",                                                     "iqu",     "",   "",    false, false },
  { u8"Ir",                                                         "irr",     "",   "",    false, false },
  { u8"Iranian Persian",                                            "pes",     "",   "",    false, false },
  { u8"Iranian Sign Language",                                      "psc",     "",   "",    false, false },
  { u8"Iranian languages",                                          "ira",     "",   "",    true,  false },
  { u8"Iranun (Malaysia)",                                          "ilm",     "",   "",    false, false },
  { u8"Iranun (Philippines)",                                       "ilp",     "",   "",    false, false },
  { u8"Iranun",                                                     "ill",     "",   "",    false, true  },
  { u8"Iraqw",                                                      "irk",     "",   "",    false, false },
  { u8"Irarutu",                                                    "irh",     "",   "",    false, false },
  { u8"Iraya",                                                      "iry",     "",   "",    false, false },
  { u8"Iresim",                                                     "ire",     "",   "",    false, false },
  { u8"Irish Sign Language",                                        "isg",     "",   "",    false, false },
  { u8"Irish",                                                      "gle",     "ga", "",    true,  false },
  { u8"Iroquoian languages",                                        "iro",     "",   "",    true,  false },
  { u8"Irula",                                                      "iru",     "",   "",    false, false },
  { u8"Irántxe",                                                    "irn",     "",   "",    false, false },
  { u8"Isabi",                                                      "isa",     "",   "",    false, false },
  { u8"Isanzu",                                                     "isn",     "",   "",    false, false },
  { u8"Isarog Agta",                                                "agk",     "",   "",    false, false },
  { u8"Isconahua",                                                  "isc",     "",   "",    false, false },
  { u8"Isebe",                                                      "igo",     "",   "",    false, false },
  { u8"Isekiri",                                                    "its",     "",   "",    false, false },
  { u8"Ishkashimi",                                                 "isk",     "",   "",    false, false },
  { u8"Isinai",                                                     "inn",     "",   "",    false, false },
  { u8"Isirawa",                                                    "srl",     "",   "",    false, false },
  { u8"Island Carib",                                               "crb",     "",   "",    false, false },
  { u8"Islander Creole English",                                    "icr",     "",   "",    false, false },
  { u8"Isnag",                                                      "isd",     "",   "",    false, false },
  { u8"Isoko",                                                      "iso",     "",   "",    false, false },
  { u8"Israeli Sign Language",                                      "isr",     "",   "",    false, false },
  { u8"Isthmus Mixe",                                               "mir",     "",   "",    false, false },
  { u8"Isthmus Zapotec",                                            "zai",     "",   "",    false, false },
  { u8"Isthmus-Cosoleacaque Nahuatl",                               "nhk",     "",   "",    false, false },
  { u8"Isthmus-Mecayapan Nahuatl",                                  "nhx",     "",   "",    false, false },
  { u8"Isthmus-Pajapan Nahuatl",                                    "nhp",     "",   "",    false, false },
  { u8"Istriot",                                                    "ist",     "",   "",    false, false },
  { u8"Istro Romanian",                                             "ruo",     "",   "",    false, false },
  { u8"Isu (Fako Division)",                                        "szv",     "",   "",    false, false },
  { u8"Isu (Menchum Division)",                                     "isu",     "",   "",    false, false },
  { u8"Italian Sign Language",                                      "ise",     "",   "",    false, false },
  { u8"Italian",                                                    "ita",     "it", "",    true,  false },
  { u8"Italic languages",                                           "itc",     "",   "",    false, false },
  { u8"Itawit",                                                     "itv",     "",   "",    false, false },
  { u8"Itelmen",                                                    "itl",     "",   "",    false, false },
  { u8"Itene",                                                      "ite",     "",   "",    false, false },
  { u8"Iteri",                                                      "itr",     "",   "",    false, false },
  { u8"Itik",                                                       "itx",     "",   "",    false, false },
  { u8"Ito",                                                        "itw",     "",   "",    false, false },
  { u8"Itonama",                                                    "ito",     "",   "",    false, false },
  { u8"Itu Mbon Uzo",                                               "itm",     "",   "",    false, false },
  { u8"Itundujia Mixtec",                                           "mce",     "",   "",    false, false },
  { u8"Itzá",                                                       "itz",     "",   "",    false, false },
  { u8"Iu Mien",                                                    "ium",     "",   "",    false, false },
  { u8"Ivatan",                                                     "ivv",     "",   "",    false, false },
  { u8"Ivbie North-Okpela-Arhe",                                    "atg",     "",   "",    false, false },
  { u8"Iwaidja",                                                    "ibd",     "",   "",    false, false },
  { u8"Iwal",                                                       "kbm",     "",   "",    false, false },
  { u8"Iwam",                                                       "iwm",     "",   "",    false, false },
  { u8"Iwur",                                                       "iwo",     "",   "",    false, false },
  { u8"Ixcatec",                                                    "ixc",     "",   "",    false, false },
  { u8"Ixcatlán Mazatec",                                           "mzi",     "",   "",    false, false },
  { u8"Ixil",                                                       "ixl",     "",   "",    false, false },
  { u8"Ixtayutla Mixtec",                                           "vmj",     "",   "",    false, false },
  { u8"Ixtenco Otomi",                                              "otz",     "",   "",    false, false },
  { u8"Iyayu",                                                      "iya",     "",   "",    false, false },
  { u8"Iyive",                                                      "uiv",     "",   "",    false, false },
  { u8"Iyo",                                                        "nca",     "",   "",    false, false },
  { u8"Iyo'wujwa Chorote",                                          "crq",     "",   "",    false, false },
  { u8"Iyojwa'ja Chorote",                                          "crt",     "",   "",    false, false },
  { u8"Izere",                                                      "izr",     "",   "",    false, false },
  { u8"Izi-Ezaa-Ikwo-Mgbo",                                         "izi",     "",   "",    false, true  },
  { u8"Izii",                                                       "izz",     "",   "",    false, false },
  { u8"Izon",                                                       "ijc",     "",   "",    false, false },
  { u8"Izora",                                                      "cbo",     "",   "",    false, false },
  { u8"Iñapari",                                                    "inp",     "",   "",    false, false },
  { u8"Jabutí",                                                     "jbt",     "",   "",    false, false },
  { u8"Jad",                                                        "jda",     "",   "",    false, false },
  { u8"Jadgali",                                                    "jdg",     "",   "",    false, false },
  { u8"Jah Hut",                                                    "jah",     "",   "",    false, false },
  { u8"Jahanka",                                                    "jad",     "",   "",    false, false },
  { u8"Jair Awyu",                                                  "awv",     "",   "",    false, false },
  { u8"Jaitmatang",                                                 "xjt",     "",   "",    false, false },
  { u8"Jakati",                                                     "jat",     "",   "",    false, false },
  { u8"Jakattoe",                                                   "jrt",     "",   "",    false, false },
  { u8"Jakun",                                                      "jak",     "",   "",    false, false },
  { u8"Jalapa De Díaz Mazatec",                                     "maj",     "",   "",    false, false },
  { u8"Jalkunan",                                                   "bxl",     "",   "",    false, false },
  { u8"Jamaican Country Sign Language",                             "jcs",     "",   "",    false, false },
  { u8"Jamaican Creole English",                                    "jam",     "",   "",    false, false },
  { u8"Jamaican Sign Language",                                     "jls",     "",   "",    false, false },
  { u8"Jamamadí",                                                   "jaa",     "",   "",    false, false },
  { u8"Jambi Malay",                                                "jax",     "",   "",    false, false },
  { u8"Jamiltepec Mixtec",                                          "mxt",     "",   "",    false, false },
  { u8"Jamsay Dogon",                                               "djm",     "",   "",    false, false },
  { u8"Jandai",                                                     "jan",     "",   "",    false, false },
  { u8"Jandavra",                                                   "jnd",     "",   "",    false, false },
  { u8"Jangkang",                                                   "djo",     "",   "",    false, false },
  { u8"Jangshung",                                                  "jna",     "",   "",    false, false },
  { u8"Janji",                                                      "jni",     "",   "",    false, false },
  { u8"Japanese (family)",                                          "jpx",     "",   "",    false, false },
  { u8"Japanese Sign Language",                                     "jsl",     "",   "",    false, false },
  { u8"Japanese",                                                   "jpn",     "ja", "",    true,  false },
  { u8"Japrería",                                                   "jru",     "",   "",    false, false },
  { u8"Jaqaru",                                                     "jqr",     "",   "",    false, false },
  { u8"Jara",                                                       "jaf",     "",   "",    false, false },
  { u8"Jarai",                                                      "jra",     "",   "",    false, false },
  { u8"Jarawa (India)",                                             "anq",     "",   "",    false, false },
  { u8"Jarawa (Nigeria)",                                           "jar",     "",   "",    false, true  },
  { u8"Jaru",                                                       "ddj",     "",   "",    false, false },
  { u8"Jauja Wanca Quechua",                                        "qxw",     "",   "",    false, false },
  { u8"Jaunsari",                                                   "jns",     "",   "",    false, false },
  { u8"Javanese",                                                   "jav",     "jv", "",    true,  false },
  { u8"Javindo",                                                    "jvd",     "",   "",    false, false },
  { u8"Jawe",                                                       "jaz",     "",   "",    false, false },
  { u8"Jawoyn",                                                     "djn",     "",   "",    false, false },
  { u8"Jaya",                                                       "jyy",     "",   "",    false, false },
  { u8"Jebero",                                                     "jeb",     "",   "",    false, false },
  { u8"Jeh",                                                        "jeh",     "",   "",    false, false },
  { u8"Jehai",                                                      "jhi",     "",   "",    false, false },
  { u8"Jejara Naga",                                                "pzn",     "",   "",    false, false },
  { u8"Jejueo",                                                     "jje",     "",   "",    false, false },
  { u8"Jemez",                                                      "tow",     "",   "",    false, false },
  { u8"Jenaama Bozo",                                               "bze",     "",   "",    false, false },
  { u8"Jeng",                                                       "jeg",     "",   "",    false, true  },
  { u8"Jennu Kurumba",                                              "xuj",     "",   "",    false, false },
  { u8"Jere",                                                       "jer",     "",   "",    false, false },
  { u8"Jeri Kuo",                                                   "jek",     "",   "",    false, false },
  { u8"Jerung",                                                     "jee",     "",   "",    false, false },
  { u8"Jewish Babylonian Aramaic (ca. 200-1200 CE)",                "tmr",     "",   "",    false, false },
  { u8"Jewish Palestinian Aramaic",                                 "jpa",     "",   "",    false, false },
  { u8"Jhankot Sign Language",                                      "jhs",     "",   "",    false, false },
  { u8"Jiamao",                                                     "jio",     "",   "",    false, false },
  { u8"Jiarong",                                                    "jya",     "",   "",    false, false },
  { u8"Jiba",                                                       "juo",     "",   "",    false, false },
  { u8"Jibu",                                                       "jib",     "",   "",    false, false },
  { u8"Jicarilla Apache",                                           "apj",     "",   "",    false, false },
  { u8"Jiiddu",                                                     "jii",     "",   "",    false, false },
  { u8"Jilbe",                                                      "jie",     "",   "",    false, false },
  { u8"Jilim",                                                      "jil",     "",   "",    false, false },
  { u8"Jimi (Cameroon)",                                            "jim",     "",   "",    false, false },
  { u8"Jimi (Nigeria)",                                             "jmi",     "",   "",    false, false },
  { u8"Jina",                                                       "jia",     "",   "",    false, false },
  { u8"Jingulu",                                                    "jig",     "",   "",    false, false },
  { u8"Jinyu Chinese",                                              "cjy",     "",   "",    false, false },
  { u8"Jiongnai Bunu",                                              "pnu",     "",   "",    false, false },
  { u8"Jirel",                                                      "jul",     "",   "",    false, false },
  { u8"Jiru",                                                       "jrr",     "",   "",    false, false },
  { u8"Jita",                                                       "jit",     "",   "",    false, false },
  { u8"Jju",                                                        "kaj",     "",   "",    false, false },
  { u8"Joba",                                                       "job",     "",   "",    false, false },
  { u8"Jofotek-Bromnya",                                            "jbr",     "",   "",    false, false },
  { u8"Jogi",                                                       "jog",     "",   "",    false, false },
  { u8"Jola-Fonyi",                                                 "dyo",     "",   "",    false, false },
  { u8"Jola-Kasa",                                                  "csk",     "",   "",    false, false },
  { u8"Jonkor Bourmataguil",                                        "jeu",     "",   "",    false, false },
  { u8"Jordanian Sign Language",                                    "jos",     "",   "",    false, false },
  { u8"Jorá",                                                       "jor",     "",   "",    false, false },
  { u8"Jowulu",                                                     "jow",     "",   "",    false, false },
  { u8"Ju",                                                         "juu",     "",   "",    false, false },
  { u8"Juang",                                                      "jun",     "",   "",    false, false },
  { u8"Judeo-Arabic",                                               "jrb",     "",   "",    true,  false },
  { u8"Judeo-Berber",                                               "jbe",     "",   "",    false, false },
  { u8"Judeo-Georgian",                                             "jge",     "",   "",    false, false },
  { u8"Judeo-Iraqi Arabic",                                         "yhd",     "",   "",    false, false },
  { u8"Judeo-Italian",                                              "itk",     "",   "",    false, false },
  { u8"Judeo-Moroccan Arabic",                                      "aju",     "",   "",    false, false },
  { u8"Judeo-Persian",                                              "jpr",     "",   "",    true,  false },
  { u8"Judeo-Tat",                                                  "jdt",     "",   "",    false, false },
  { u8"Judeo-Tripolitanian Arabic",                                 "yud",     "",   "",    false, false },
  { u8"Judeo-Tunisian Arabic",                                      "ajt",     "",   "",    false, true  },
  { u8"Judeo-Yemeni Arabic",                                        "jye",     "",   "",    false, false },
  { u8"Jukun Takum",                                                "jbu",     "",   "",    false, false },
  { u8"Jumjum",                                                     "jum",     "",   "",    false, false },
  { u8"Jumla Sign Language",                                        "jus",     "",   "",    false, false },
  { u8"Jumli",                                                      "jml",     "",   "",    false, false },
  { u8"Jungle Inga",                                                "inj",     "",   "",    false, false },
  { u8"Juquila Mixe",                                               "mxq",     "",   "",    false, false },
  { u8"Jur Modo",                                                   "bex",     "",   "",    false, false },
  { u8"Juray",                                                      "juy",     "",   "",    false, false },
  { u8"Jurchen",                                                    "juc",     "",   "",    false, false },
  { u8"Jurúna",                                                     "jur",     "",   "",    false, false },
  { u8"Jutish",                                                     "jut",     "",   "",    false, false },
  { u8"Juwal",                                                      "mwb",     "",   "",    false, false },
  { u8"Juxtlahuaca Mixtec",                                         "vmc",     "",   "",    false, false },
  { u8"Juǀʼhoan",                                                   "ktz",     "",   "",    false, false },
  { u8"Jwira-Pepesa",                                               "jwi",     "",   "",    false, false },
  { u8"Jèrriais",                                                   "nrf",     "",   "",    false, false },
  { u8"Júma",                                                       "jua",     "",   "",    false, false },
  { u8"K'iche'",                                                    "quc",     "",   "",    false, false },
  { u8"Kaamba",                                                     "xku",     "",   "",    false, false },
  { u8"Kaan",                                                       "ldl",     "",   "",    false, false },
  { u8"Kaang Chin",                                                 "ckn",     "",   "",    false, false },
  { u8"Kaansa",                                                     "gna",     "",   "",    false, false },
  { u8"Kaba",                                                       "ksp",     "",   "",    false, false },
  { u8"Kabalai",                                                    "kvf",     "",   "",    false, false },
  { u8"Kabardian",                                                  "kbd",     "",   "",    true,  false },
  { u8"Kabatei",                                                    "xkp",     "",   "",    false, false },
  { u8"Kabixí",                                                     "xbx",     "",   "",    false, true  },
  { u8"Kabiyè",                                                     "kbp",     "",   "",    false, false },
  { u8"Kabola",                                                     "klz",     "",   "",    false, false },
  { u8"Kabore One",                                                 "onk",     "",   "",    false, false },
  { u8"Kabras",                                                     "lkb",     "",   "",    false, false },
  { u8"Kaburi",                                                     "uka",     "",   "",    false, false },
  { u8"Kabutra",                                                    "kbu",     "",   "",    false, false },
  { u8"Kabuverdianu",                                               "kea",     "",   "",    false, false },
  { u8"Kabwa",                                                      "cwa",     "",   "",    false, false },
  { u8"Kabwari",                                                    "kcw",     "",   "",    false, false },
  { u8"Kabyle",                                                     "kab",     "",   "",    true,  false },
  { u8"Kachama-Ganjule",                                            "kcx",     "",   "",    false, false },
  { u8"Kachari",                                                    "xac",     "",   "",    false, false },
  { u8"Kachhi",                                                     "kfr",     "",   "",    false, false },
  { u8"Kachi Koli",                                                 "gjk",     "",   "",    false, false },
  { u8"Kachin",                                                     "kac",     "",   "",    true,  false },
  { u8"Kachok",                                                     "xkk",     "",   "",    false, false },
  { u8"Kacipo-Bale Suri",                                           "koe",     "",   "",    false, false },
  { u8"Kadai",                                                      "kzd",     "",   "",    false, false },
  { u8"Kadar",                                                      "kej",     "",   "",    false, false },
  { u8"Kadaru",                                                     "kdu",     "",   "",    false, false },
  { u8"Kadazan Dusun",                                              "dtp",     "",   "",    false, false },
  { u8"Kadiwéu",                                                    "kbc",     "",   "",    false, false },
  { u8"Kado",                                                       "kdv",     "",   "",    false, true  },
  { u8"Kadu",                                                       "zkd",     "",   "",    false, false },
  { u8"Kadung",                                                     "dkg",     "",   "",    false, false },
  { u8"Kaduo",                                                      "ktp",     "",   "",    false, false },
  { u8"Kaeku",                                                      "kkq",     "",   "",    false, false },
  { u8"Kaera",                                                      "jka",     "",   "",    false, false },
  { u8"Kafa",                                                       "kbr",     "",   "",    false, false },
  { u8"Kafoa",                                                      "kpu",     "",   "",    false, false },
  { u8"Kagan Kalagan",                                              "kll",     "",   "",    false, false },
  { u8"Kagate",                                                     "syw",     "",   "",    false, false },
  { u8"Kagayanen",                                                  "cgc",     "",   "",    false, false },
  { u8"Kagoma",                                                     "kdm",     "",   "",    false, false },
  { u8"Kagoro",                                                     "xkg",     "",   "",    false, false },
  { u8"Kagulu",                                                     "kki",     "",   "",    false, false },
  { u8"Kahe",                                                       "hka",     "",   "",    false, false },
  { u8"Kahua",                                                      "agw",     "",   "",    false, false },
  { u8"Kaian",                                                      "kct",     "",   "",    false, false },
  { u8"Kaibobo",                                                    "kzb",     "",   "",    false, false },
  { u8"Kaidipang",                                                  "kzp",     "",   "",    false, false },
  { u8"Kaiep",                                                      "kbw",     "",   "",    false, false },
  { u8"Kaikadi",                                                    "kep",     "",   "",    false, false },
  { u8"Kaikavian Literary Language",                                "kjv",     "",   "",    false, false },
  { u8"Kaike",                                                      "kzq",     "",   "",    false, false },
  { u8"Kaimbulawa",                                                 "zka",     "",   "",    false, false },
  { u8"Kaimbé",                                                     "xai",     "",   "",    false, false },
  { u8"Kaingang",                                                   "kgp",     "",   "",    false, false },
  { u8"Kairak",                                                     "ckr",     "",   "",    false, false },
  { u8"Kairiru",                                                    "kxa",     "",   "",    false, false },
  { u8"Kairui-Midiki",                                              "krd",     "",   "",    false, false },
  { u8"Kais",                                                       "kzm",     "",   "",    false, false },
  { u8"Kaitag",                                                     "xdq",     "",   "",    false, false },
  { u8"Kaivi",                                                      "kce",     "",   "",    false, false },
  { u8"Kaiwá",                                                      "kgk",     "",   "",    false, false },
  { u8"Kaiy",                                                       "tcq",     "",   "",    false, false },
  { u8"Kajakse",                                                    "ckq",     "",   "",    false, false },
  { u8"Kajali",                                                     "xkj",     "",   "",    false, false },
  { u8"Kajaman",                                                    "kag",     "",   "",    false, false },
  { u8"Kakabai",                                                    "kqf",     "",   "",    false, false },
  { u8"Kakabe",                                                     "kke",     "",   "",    false, false },
  { u8"Kakanda",                                                    "kka",     "",   "",    false, false },
  { u8"Kakauhua",                                                   "kbf",     "",   "",    false, true  },
  { u8"Kaki Ae",                                                    "tbd",     "",   "",    false, false },
  { u8"Kakihum",                                                    "kxe",     "",   "",    false, true  },
  { u8"Kako",                                                       "kkj",     "",   "",    false, false },
  { u8"Kakwa",                                                      "keo",     "",   "",    false, false },
  { u8"Kala Lagaw Ya",                                              "mwp",     "",   "",    false, false },
  { u8"Kalaallisut",                                                "kal",     "kl", "",    true,  false },
  { u8"Kalaamaya",                                                  "lkm",     "",   "",    false, false },
  { u8"Kalabakan",                                                  "kve",     "",   "",    false, false },
  { u8"Kalabari",                                                   "ijn",     "",   "",    false, false },
  { u8"Kalabra",                                                    "kzz",     "",   "",    false, false },
  { u8"Kalagan",                                                    "kqe",     "",   "",    false, false },
  { u8"Kalaktang Monpa",                                            "kkf",     "",   "",    false, false },
  { u8"Kalam",                                                      "kmh",     "",   "",    false, false },
  { u8"Kalamsé",                                                    "knz",     "",   "",    false, false },
  { u8"Kalanadi",                                                   "wkl",     "",   "",    false, false },
  { u8"Kalanga",                                                    "kck",     "",   "",    false, false },
  { u8"Kalanguya",                                                  "kak",     "",   "",    false, false },
  { u8"Kalao",                                                      "kly",     "",   "",    false, false },
  { u8"Kalapuya",                                                   "kyl",     "",   "",    false, false },
  { u8"Kalarko",                                                    "kba",     "",   "",    false, false },
  { u8"Kalasha",                                                    "kls",     "",   "",    false, false },
  { u8"Kalenjin",                                                   "kln",     "",   "",    false, false },
  { u8"Kalispel-Pend d'Oreille",                                    "fla",     "",   "",    false, false },
  { u8"Kalkoti",                                                    "xka",     "",   "",    false, false },
  { u8"Kalkutung",                                                  "ktg",     "",   "",    false, false },
  { u8"Kalmyk",                                                     "xal",     "",   "",    true,  false },
  { u8"Kalo Finnish Romani",                                        "rmf",     "",   "",    false, false },
  { u8"Kalou",                                                      "ywa",     "",   "",    false, false },
  { u8"Kaluli",                                                     "bco",     "",   "",    false, false },
  { u8"Kalumpang",                                                  "kli",     "",   "",    false, false },
  { u8"Kam",                                                        "kdx",     "",   "",    false, false },
  { u8"Kamakan",                                                    "vkm",     "",   "",    false, false },
  { u8"Kamang",                                                     "woi",     "",   "",    false, false },
  { u8"Kamano",                                                     "kbq",     "",   "",    false, false },
  { u8"Kamantan",                                                   "kci",     "",   "",    false, false },
  { u8"Kamar",                                                      "keq",     "",   "",    false, false },
  { u8"Kamara",                                                     "jmr",     "",   "",    false, false },
  { u8"Kamarian",                                                   "kzx",     "",   "",    false, false },
  { u8"Kamaru",                                                     "kgx",     "",   "",    false, false },
  { u8"Kamas",                                                      "xas",     "",   "",    false, false },
  { u8"Kamasa",                                                     "klp",     "",   "",    false, false },
  { u8"Kamasau",                                                    "kms",     "",   "",    false, false },
  { u8"Kamayo",                                                     "kyk",     "",   "",    false, false },
  { u8"Kamayurá",                                                   "kay",     "",   "",    false, false },
  { u8"Kamba (Brazil)",                                             "xba",     "",   "",    false, true  },
  { u8"Kamba (Kenya)",                                              "kam",     "",   "",    true,  false },
  { u8"Kambaata",                                                   "ktb",     "",   "",    false, false },
  { u8"Kambaira",                                                   "kyy",     "",   "",    false, false },
  { u8"Kambera",                                                    "xbr",     "",   "",    false, false },
  { u8"Kamberau",                                                   "irx",     "",   "",    false, false },
  { u8"Kambiwá",                                                    "xbw",     "",   "",    false, false },
  { u8"Kami (Nigeria)",                                             "kmi",     "",   "",    false, false },
  { u8"Kami (Tanzania)",                                            "kcu",     "",   "",    false, false },
  { u8"Kamo",                                                       "kcq",     "",   "",    false, false },
  { u8"Kamoro",                                                     "kgq",     "",   "",    false, false },
  { u8"Kamu",                                                       "xmu",     "",   "",    false, false },
  { u8"Kamula",                                                     "xla",     "",   "",    false, false },
  { u8"Kamviri",                                                    "xvi",     "",   "",    false, false },
  { u8"Kamwe",                                                      "hig",     "",   "",    false, false },
  { u8"Kanakanabu",                                                 "xnb",     "",   "",    false, false },
  { u8"Kanamarí",                                                   "knm",     "",   "",    false, false },
  { u8"Kanan",                                                      "zkn",     "",   "",    false, false },
  { u8"Kanashi",                                                    "xns",     "",   "",    false, false },
  { u8"Kanasi",                                                     "soq",     "",   "",    false, false },
  { u8"Kanauji",                                                    "bjj",     "",   "",    false, false },
  { u8"Kandas",                                                     "kqw",     "",   "",    false, false },
  { u8"Kandawo",                                                    "gam",     "",   "",    false, false },
  { u8"Kande",                                                      "kbs",     "",   "",    false, false },
  { u8"Kanembu",                                                    "kbl",     "",   "",    false, false },
  { u8"Kang",                                                       "kyp",     "",   "",    false, false },
  { u8"Kanga",                                                      "kcp",     "",   "",    false, false },
  { u8"Kangean",                                                    "kkv",     "",   "",    false, false },
  { u8"Kanggape",                                                   "igm",     "",   "",    false, false },
  { u8"Kangjia",                                                    "kxs",     "",   "",    false, false },
  { u8"Kango (Bas-Uélé District)",                                  "kty",     "",   "",    false, false },
  { u8"Kango (Tshopo District)",                                    "kzy",     "",   "",    false, false },
  { u8"Kangri",                                                     "xnr",     "",   "",    false, false },
  { u8"Kaniet",                                                     "ktk",     "",   "",    false, false },
  { u8"Kanikkaran",                                                 "kev",     "",   "",    false, false },
  { u8"Kaningdon-Nindem",                                           "kdp",     "",   "",    false, false },
  { u8"Kaningi",                                                    "kzo",     "",   "",    false, false },
  { u8"Kaningra",                                                   "knr",     "",   "",    false, false },
  { u8"Kaninuwa",                                                   "wat",     "",   "",    false, false },
  { u8"Kanite",                                                     "kmu",     "",   "",    false, false },
  { u8"Kanjari",                                                    "kft",     "",   "",    false, false },
  { u8"Kanju",                                                      "kbe",     "",   "",    false, false },
  { u8"Kankanaey",                                                  "kne",     "",   "",    false, false },
  { u8"Kannada Kurumba",                                            "kfi",     "",   "",    false, false },
  { u8"Kannada",                                                    "kan",     "kn", "",    true,  false },
  { u8"Kanowit-Tanjong Melanau",                                    "kxn",     "",   "",    false, false },
  { u8"Kanoé",                                                      "kxo",     "",   "",    false, false },
  { u8"Kansa",                                                      "ksk",     "",   "",    false, false },
  { u8"Kantosi",                                                    "xkt",     "",   "",    false, false },
  { u8"Kanu",                                                       "khx",     "",   "",    false, false },
  { u8"Kanufi",                                                     "kni",     "",   "",    false, false },
  { u8"Kanuri",                                                     "kau",     "kr", "",    true,  false },
  { u8"Kanyok",                                                     "kny",     "",   "",    false, false },
  { u8"Kao",                                                        "kax",     "",   "",    false, false },
  { u8"Kaonde",                                                     "kqn",     "",   "",    false, false },
  { u8"Kap",                                                        "ykm",     "",   "",    false, false },
  { u8"Kapin",                                                      "tbx",     "",   "",    false, false },
  { u8"Kapinawá",                                                   "xpn",     "",   "",    false, false },
  { u8"Kapingamarangi",                                             "kpg",     "",   "",    false, false },
  { u8"Kapori",                                                     "khp",     "",   "",    false, false },
  { u8"Kapriman",                                                   "dju",     "",   "",    false, false },
  { u8"Kaptiau",                                                    "kbi",     "",   "",    false, false },
  { u8"Kapya",                                                      "klo",     "",   "",    false, false },
  { u8"Kaqchikel",                                                  "cak",     "",   "",    false, false },
  { u8"Kara (Central African Republic)",                            "kah",     "",   "",    false, false },
  { u8"Kara (Korea)",                                               "zra",     "",   "",    false, false },
  { u8"Kara (Papua New Guinea)",                                    "leu",     "",   "",    false, false },
  { u8"Kara (Tanzania)",                                            "reg",     "",   "",    false, false },
  { u8"Kara-Kalpak",                                                "kaa",     "",   "",    true,  false },
  { u8"Karachay-Balkar",                                            "krc",     "",   "",    true,  false },
  { u8"Karagas",                                                    "kim",     "",   "",    false, false },
  { u8"Karahawyana",                                                "xkh",     "",   "",    false, true  },
  { u8"Karaim",                                                     "kdr",     "",   "",    false, false },
  { u8"Karajarri",                                                  "gbd",     "",   "",    false, false },
  { u8"Karajá",                                                     "kpj",     "",   "",    false, false },
  { u8"Karakhanid",                                                 "xqa",     "",   "",    false, false },
  { u8"Karami",                                                     "xar",     "",   "",    false, false },
  { u8"Karamojong",                                                 "kdj",     "",   "",    false, false },
  { u8"Karang",                                                     "kzr",     "",   "",    false, false },
  { u8"Karanga",                                                    "kth",     "",   "",    false, false },
  { u8"Karankawa",                                                  "zkk",     "",   "",    false, false },
  { u8"Karao",                                                      "kyj",     "",   "",    false, false },
  { u8"Karas",                                                      "kgv",     "",   "",    false, false },
  { u8"Karata",                                                     "kpt",     "",   "",    false, false },
  { u8"Karawa",                                                     "xrw",     "",   "",    false, false },
  { u8"Karbi",                                                      "mjw",     "",   "",    false, false },
  { u8"Kare (Central African Republic)",                            "kbn",     "",   "",    false, false },
  { u8"Kare (Papua New Guinea)",                                    "kmf",     "",   "",    false, false },
  { u8"Karekare",                                                   "kai",     "",   "",    false, false },
  { u8"Karelian",                                                   "krl",     "",   "",    true,  false },
  { u8"Karen languages",                                            "kar",     "",   "",    true,  false },
  { u8"Karenggapa",                                                 "eaa",     "",   "",    false, false },
  { u8"Karey",                                                      "kyd",     "",   "",    false, false },
  { u8"Kari",                                                       "kbj",     "",   "",    false, false },
  { u8"Karingani",                                                  "kgn",     "",   "",    false, false },
  { u8"Karipuna",                                                   "kuq",     "",   "",    false, false },
  { u8"Karipúna Creole French",                                     "kmv",     "",   "",    false, false },
  { u8"Karipúna",                                                   "kgm",     "",   "",    false, false },
  { u8"Karirí-Xocó",                                                "kzw",     "",   "",    false, false },
  { u8"Karitiâna",                                                  "ktn",     "",   "",    false, false },
  { u8"Kariya",                                                     "kil",     "",   "",    false, false },
  { u8"Kariyarra",                                                  "vka",     "",   "",    false, false },
  { u8"Karkar-Yuri",                                                "yuj",     "",   "",    false, false },
  { u8"Karkin",                                                     "krb",     "",   "",    false, false },
  { u8"Karko",                                                      "kko",     "",   "",    false, false },
  { u8"Karnai",                                                     "bbv",     "",   "",    false, false },
  { u8"Karo (Brazil)",                                              "arr",     "",   "",    false, false },
  { u8"Karo (Ethiopia)",                                            "kxh",     "",   "",    false, false },
  { u8"Karok",                                                      "kyh",     "",   "",    false, false },
  { u8"Karon Dori",                                                 "kgw",     "",   "",    false, false },
  { u8"Karon",                                                      "krx",     "",   "",    false, false },
  { u8"Karore",                                                     "xkx",     "",   "",    false, false },
  { u8"Karranga",                                                   "xrq",     "",   "",    false, true  },
  { u8"Karuwali",                                                   "rxw",     "",   "",    false, false },
  { u8"Kasanga",                                                    "ccj",     "",   "",    false, false },
  { u8"Kasem",                                                      "xsm",     "",   "",    false, false },
  { u8"Kashaya",                                                    "kju",     "",   "",    false, false },
  { u8"Kashmiri",                                                   "kas",     "ks", "",    true,  false },
  { u8"Kashubian",                                                  "csb",     "",   "",    true,  false },
  { u8"Kasiguranin",                                                "ksn",     "",   "",    false, false },
  { u8"Kaska",                                                      "kkz",     "",   "",    false, false },
  { u8"Kaskean",                                                    "zsk",     "",   "",    false, false },
  { u8"Kasseng",                                                    "kgc",     "",   "",    false, true  },
  { u8"Kasua",                                                      "khs",     "",   "",    false, false },
  { u8"Kataang",                                                    "kgd",     "",   "",    false, true  },
  { u8"Katabaga",                                                   "ktq",     "",   "",    false, false },
  { u8"Katawixi",                                                   "xat",     "",   "",    false, false },
  { u8"Katbol",                                                     "tmb",     "",   "",    false, false },
  { u8"Katcha-Kadugli-Miri",                                        "xtc",     "",   "",    false, false },
  { u8"Kathoriya Tharu",                                            "tkt",     "",   "",    false, false },
  { u8"Kathu",                                                      "ykt",     "",   "",    false, false },
  { u8"Kati",                                                       "bsh",     "",   "",    false, false },
  { u8"Katkari",                                                    "kfu",     "",   "",    false, false },
  { u8"Katla",                                                      "kcr",     "",   "",    false, false },
  { u8"Kato",                                                       "ktw",     "",   "",    false, false },
  { u8"Katso",                                                      "kaf",     "",   "",    false, false },
  { u8"Katua",                                                      "kta",     "",   "",    false, false },
  { u8"Katukína",                                                   "kav",     "",   "",    false, false },
  { u8"Kaulong",                                                    "pss",     "",   "",    false, false },
  { u8"Kaur",                                                       "vkk",     "",   "",    false, false },
  { u8"Kaure",                                                      "bpp",     "",   "",    false, false },
  { u8"Kaurna",                                                     "zku",     "",   "",    false, false },
  { u8"Kauwera",                                                    "xau",     "",   "",    false, false },
  { u8"Kavalan",                                                    "ckv",     "",   "",    false, false },
  { u8"Kavet",                                                      "krv",     "",   "",    false, false },
  { u8"Kawacha",                                                    "kcb",     "",   "",    false, false },
  { u8"Kawaiisu",                                                   "xaw",     "",   "",    false, false },
  { u8"Kawe",                                                       "kgb",     "",   "",    false, false },
  { u8"Kawi",                                                       "kaw",     "",   "",    true,  false },
  { u8"Kaxararí",                                                   "ktx",     "",   "",    false, false },
  { u8"Kaxuiâna",                                                   "kbb",     "",   "",    false, false },
  { u8"Kayabí",                                                     "kyz",     "",   "",    false, false },
  { u8"Kayagar",                                                    "kyt",     "",   "",    false, false },
  { u8"Kayan Mahakam",                                              "xay",     "",   "",    false, false },
  { u8"Kayan River Kayan",                                          "xkn",     "",   "",    false, false },
  { u8"Kayan",                                                      "pdu",     "",   "",    false, false },
  { u8"Kayapó",                                                     "txu",     "",   "",    false, false },
  { u8"Kayardild",                                                  "gyd",     "",   "",    false, false },
  { u8"Kayaw",                                                      "kvl",     "",   "",    false, false },
  { u8"Kayeli",                                                     "kzl",     "",   "",    false, false },
  { u8"Kayong",                                                     "kxy",     "",   "",    false, false },
  { u8"Kayort",                                                     "kyv",     "",   "",    false, false },
  { u8"Kaytetye",                                                   "gbb",     "",   "",    false, false },
  { u8"Kayupulau",                                                  "kzu",     "",   "",    false, false },
  { u8"Kazakh",                                                     "kaz",     "kk", "",    true,  false },
  { u8"Kazukuru",                                                   "kzk",     "",   "",    false, false },
  { u8"Ke'o",                                                       "xxk",     "",   "",    false, false },
  { u8"Keak",                                                       "keh",     "",   "",    false, false },
  { u8"Keapara",                                                    "khz",     "",   "",    false, false },
  { u8"Kedah Malay",                                                "meo",     "",   "",    false, false },
  { u8"Kedang",                                                     "ksx",     "",   "",    false, false },
  { u8"Keder",                                                      "kdy",     "",   "",    false, false },
  { u8"Keerray-Woorroong",                                          "wkr",     "",   "",    false, false },
  { u8"Kehu",                                                       "khh",     "",   "",    false, false },
  { u8"Kei",                                                        "kei",     "",   "",    false, false },
  { u8"Keiga",                                                      "kec",     "",   "",    false, false },
  { u8"Kein",                                                       "bmh",     "",   "",    false, false },
  { u8"Keiyo",                                                      "eyo",     "",   "",    false, false },
  { u8"Kekchí",                                                     "kek",     "",   "",    false, false },
  { u8"Kela (Democratic Republic of Congo)",                        "kel",     "",   "",    false, false },
  { u8"Kela (Papua New Guinea)",                                    "kcl",     "",   "",    false, false },
  { u8"Kelabit",                                                    "kzi",     "",   "",    false, false },
  { u8"Kele (Democratic Republic of Congo)",                        "khy",     "",   "",    false, false },
  { u8"Kele (Papua New Guinea)",                                    "sbc",     "",   "",    false, false },
  { u8"Keley-I Kallahan",                                           "ify",     "",   "",    false, false },
  { u8"Keliko",                                                     "kbo",     "",   "",    false, false },
  { u8"Kelo",                                                       "xel",     "",   "",    false, false },
  { u8"Kelon",                                                      "kyo",     "",   "",    false, false },
  { u8"Kemak",                                                      "kem",     "",   "",    false, false },
  { u8"Kembayan",                                                   "xem",     "",   "",    false, false },
  { u8"Kemberano",                                                  "bzp",     "",   "",    false, false },
  { u8"Kembra",                                                     "xkw",     "",   "",    false, false },
  { u8"Kemedzung",                                                  "dmo",     "",   "",    false, false },
  { u8"Kemi Sami",                                                  "sjk",     "",   "",    false, false },
  { u8"Kemiehua",                                                   "kfj",     "",   "",    false, false },
  { u8"Kemtuik",                                                    "kmt",     "",   "",    false, false },
  { u8"Kenaboi",                                                    "xbn",     "",   "",    false, false },
  { u8"Kenati",                                                     "gat",     "",   "",    false, false },
  { u8"Kendayan",                                                   "knx",     "",   "",    false, false },
  { u8"Kendeje",                                                    "klf",     "",   "",    false, false },
  { u8"Kendem",                                                     "kvm",     "",   "",    false, false },
  { u8"Kenga",                                                      "kyq",     "",   "",    false, false },
  { u8"Keningau Murut",                                             "kxi",     "",   "",    false, false },
  { u8"Keninjal",                                                   "knl",     "",   "",    false, false },
  { u8"Kensiu",                                                     "kns",     "",   "",    false, false },
  { u8"Kenswei Nsei",                                               "ndb",     "",   "",    false, false },
  { u8"Kenuzi-Dongola",                                             "kzh",     "",   "",    false, true  },
  { u8"Kenyan Sign Language",                                       "xki",     "",   "",    false, false },
  { u8"Kenyang",                                                    "ken",     "",   "",    false, false },
  { u8"Kenyi",                                                      "lke",     "",   "",    false, false },
  { u8"Kenzi",                                                      "xnz",     "",   "",    false, false },
  { u8"Keoru-Ahia",                                                 "xeu",     "",   "",    false, false },
  { u8"Kepkiriwát",                                                 "kpn",     "",   "",    false, false },
  { u8"Kepo'",                                                      "kuk",     "",   "",    false, false },
  { u8"Kera",                                                       "ker",     "",   "",    false, false },
  { u8"Kerak",                                                      "hhr",     "",   "",    false, false },
  { u8"Kereho",                                                     "xke",     "",   "",    false, false },
  { u8"Kerek",                                                      "krk",     "",   "",    false, false },
  { u8"Kerewe",                                                     "ked",     "",   "",    false, false },
  { u8"Kerewo",                                                     "kxz",     "",   "",    false, false },
  { u8"Kerinci",                                                    "kvr",     "",   "",    false, false },
  { u8"Kesawai",                                                    "xes",     "",   "",    false, false },
  { u8"Ket",                                                        "ket",     "",   "",    false, false },
  { u8"Ketangalan",                                                 "kae",     "",   "",    false, false },
  { u8"Kete",                                                       "kcv",     "",   "",    false, false },
  { u8"Ketengban",                                                  "xte",     "",   "",    false, false },
  { u8"Ketum",                                                      "ktt",     "",   "",    false, false },
  { u8"Keyagana",                                                   "kyg",     "",   "",    false, false },
  { u8"Kgalagadi",                                                  "xkv",     "",   "",    false, false },
  { u8"Khah",                                                       "hkh",     "",   "",    false, false },
  { u8"Khakas",                                                     "kjh",     "",   "",    false, false },
  { u8"Khalaj [Indo-Iranian]",                                      "kjf",     "",   "",    false, true  },
  { u8"Khalaj",                                                     "klj",     "",   "",    false, false },
  { u8"Khaling",                                                    "klr",     "",   "",    false, false },
  { u8"Khamba",                                                     "kbg",     "",   "",    false, false },
  { u8"Khams Tibetan",                                              "khg",     "",   "",    false, false },
  { u8"Khamti",                                                     "kht",     "",   "",    false, false },
  { u8"Khamyang",                                                   "ksu",     "",   "",    false, false },
  { u8"Khana",                                                      "ogo",     "",   "",    false, false },
  { u8"Khandesi",                                                   "khn",     "",   "",    false, false },
  { u8"Khanty",                                                     "kca",     "",   "",    false, false },
  { u8"Khao",                                                       "xao",     "",   "",    false, false },
  { u8"Kharam Naga",                                                "kfw",     "",   "",    false, false },
  { u8"Kharia Thar",                                                "ksy",     "",   "",    false, false },
  { u8"Kharia",                                                     "khr",     "",   "",    false, false },
  { u8"Khasi",                                                      "kha",     "",   "",    true,  false },
  { u8"Khayo",                                                      "lko",     "",   "",    false, false },
  { u8"Khazar",                                                     "zkz",     "",   "",    false, false },
  { u8"Khe",                                                        "kqg",     "",   "",    false, false },
  { u8"Khehek",                                                     "tlx",     "",   "",    false, false },
  { u8"Khengkha",                                                   "xkf",     "",   "",    false, false },
  { u8"Khetrani",                                                   "xhe",     "",   "",    false, false },
  { u8"Khezha Naga",                                                "nkh",     "",   "",    false, false },
  { u8"Khiamniungan Naga",                                          "kix",     "",   "",    false, false },
  { u8"Khinalugh",                                                  "kjj",     "",   "",    false, false },
  { u8"Khirwar",                                                    "kwx",     "",   "",    false, false },
  { u8"Khisa",                                                      "kqm",     "",   "",    false, false },
  { u8"Khlor",                                                      "llo",     "",   "",    false, true  },
  { u8"Khlula",                                                     "ykl",     "",   "",    false, false },
  { u8"Khmer",                                                      "khm",     "km", "",    true,  false },
  { u8"Khmu",                                                       "kjg",     "",   "",    false, false },
  { u8"Kho'ini",                                                    "xkc",     "",   "",    false, false },
  { u8"Khoekhoe",                                                   "naq",     "",   "",    false, false },
  { u8"Khoibu Naga",                                                "nkb",     "",   "",    false, false },
  { u8"Khoisan languages",                                          "khi",     "",   "",    true,  false },
  { u8"Kholok",                                                     "ktc",     "",   "",    false, false },
  { u8"Khorasani Turkish",                                          "kmz",     "",   "",    false, false },
  { u8"Khorezmian",                                                 "zkh",     "",   "",    false, false },
  { u8"Khotanese",                                                  "kho",     "",   "",    true,  false },
  { u8"Khowar",                                                     "khw",     "",   "",    false, false },
  { u8"Khua",                                                       "xhv",     "",   "",    false, false },
  { u8"Khuen",                                                      "khf",     "",   "",    false, false },
  { u8"Khumi Awa Chin",                                             "cka",     "",   "",    false, true  },
  { u8"Khumi Chin",                                                 "cnk",     "",   "",    false, false },
  { u8"Khunsari",                                                   "kfm",     "",   "",    false, false },
  { u8"Khvarshi",                                                   "khv",     "",   "",    false, false },
  { u8"Kháng",                                                      "kjm",     "",   "",    false, false },
  { u8"Khün",                                                       "kkh",     "",   "",    false, false },
  { u8"Kibala",                                                     "blv",     "",   "",    false, false },
  { u8"Kibet",                                                      "kie",     "",   "",    false, false },
  { u8"Kibiri",                                                     "prm",     "",   "",    false, false },
  { u8"Kickapoo",                                                   "kic",     "",   "",    false, false },
  { u8"Kija",                                                       "gia",     "",   "",    false, false },
  { u8"Kikai",                                                      "kzg",     "",   "",    false, false },
  { u8"Kikuyu",                                                     "kik",     "ki", "",    true,  false },
  { u8"Kildin Sami",                                                "sjd",     "",   "",    false, false },
  { u8"Kilivila",                                                   "kij",     "",   "",    false, false },
  { u8"Kiliwa",                                                     "klb",     "",   "",    false, false },
  { u8"Kilmeri",                                                    "kih",     "",   "",    false, false },
  { u8"Kim Mun",                                                    "mji",     "",   "",    false, false },
  { u8"Kim",                                                        "kia",     "",   "",    false, false },
  { u8"Kimaama",                                                    "kig",     "",   "",    false, false },
  { u8"Kimaragang",                                                 "kqr",     "",   "",    false, false },
  { u8"Kimbu",                                                      "kiv",     "",   "",    false, false },
  { u8"Kimbundu",                                                   "kmb",     "",   "",    true,  false },
  { u8"Kimki",                                                      "sbt",     "",   "",    false, false },
  { u8"Kimré",                                                      "kqp",     "",   "",    false, false },
  { u8"Kinabalian",                                                 "cbw",     "",   "",    false, false },
  { u8"Kinalakna",                                                  "kco",     "",   "",    false, false },
  { u8"Kinamiging Manobo",                                          "mkx",     "",   "",    false, false },
  { u8"Kinaray-A",                                                  "krj",     "",   "",    false, false },
  { u8"Kinga",                                                      "zga",     "",   "",    false, false },
  { u8"Kinnauri",                                                   "kfk",     "",   "",    false, false },
  { u8"Kintaq",                                                     "knq",     "",   "",    false, false },
  { u8"Kinuku",                                                     "kkd",     "",   "",    false, false },
  { u8"Kinyarwanda",                                                "kin",     "rw", "",    true,  false },
  { u8"Kioko",                                                      "ues",     "",   "",    false, false },
  { u8"Kiong",                                                      "kkm",     "",   "",    false, false },
  { u8"Kiorr",                                                      "xko",     "",   "",    false, false },
  { u8"Kiowa Apache",                                               "apk",     "",   "",    false, false },
  { u8"Kiowa",                                                      "kio",     "",   "",    false, false },
  { u8"Kipsigis",                                                   "sgc",     "",   "",    false, false },
  { u8"Kiput",                                                      "kyi",     "",   "",    false, false },
  { u8"Kir-Balar",                                                  "kkr",     "",   "",    false, false },
  { u8"Kire",                                                       "geb",     "",   "",    false, false },
  { u8"Kirghiz",                                                    "kir",     "ky", "",    true,  false },
  { u8"Kirike",                                                     "okr",     "",   "",    false, false },
  { u8"Kirikiri",                                                   "kiy",     "",   "",    false, false },
  { u8"Kirmanjki (individual language)",                            "kiu",     "",   "",    false, false },
  { u8"Kirya-Konzəl",                                               "fkk",     "",   "",    false, false },
  { u8"Kis",                                                        "kis",     "",   "",    false, false },
  { u8"Kisa",                                                       "lks",     "",   "",    false, false },
  { u8"Kisan",                                                      "xis",     "",   "",    false, false },
  { u8"Kisankasa",                                                  "kqh",     "",   "",    false, false },
  { u8"Kisar",                                                      "kje",     "",   "",    false, false },
  { u8"Kisi",                                                       "kiz",     "",   "",    false, false },
  { u8"Kistane",                                                    "gru",     "",   "",    false, false },
  { u8"Kita Maninkakan",                                            "mwk",     "",   "",    false, false },
  { u8"Kitan",                                                      "zkt",     "",   "",    false, false },
  { u8"Kitsai",                                                     "kii",     "",   "",    false, false },
  { u8"Kituba (Congo)",                                             "mkw",     "",   "",    false, false },
  { u8"Kituba (Democratic Republic of Congo)",                      "ktu",     "",   "",    false, false },
  { u8"Kiunum",                                                     "wei",     "",   "",    false, false },
  { u8"Kla-Dan",                                                    "lda",     "",   "",    false, false },
  { u8"Klamath-Modoc",                                              "kla",     "",   "",    false, false },
  { u8"Klao",                                                       "klu",     "",   "",    false, false },
  { u8"Klias River Kadazan",                                        "kqt",     "",   "",    false, false },
  { u8"Klingon",                                                    "tlh",     "",   "",    true,  false },
  { u8"Knaanic",                                                    "czk",     "",   "",    false, false },
  { u8"Ko",                                                         "fuj",     "",   "",    false, false },
  { u8"Koalib",                                                     "kib",     "",   "",    false, false },
  { u8"Koasati",                                                    "cku",     "",   "",    false, false },
  { u8"Koba",                                                       "kpd",     "",   "",    false, false },
  { u8"Kobiana",                                                    "kcj",     "",   "",    false, false },
  { u8"Kobo",                                                       "okc",     "",   "",    false, false },
  { u8"Kobol",                                                      "kgu",     "",   "",    false, false },
  { u8"Kobon",                                                      "kpw",     "",   "",    false, false },
  { u8"Koch",                                                       "kdq",     "",   "",    false, false },
  { u8"Kochila Tharu",                                              "thq",     "",   "",    false, false },
  { u8"Koda",                                                       "cdz",     "",   "",    false, false },
  { u8"Kodaku",                                                     "ksz",     "",   "",    false, false },
  { u8"Kodava",                                                     "kfa",     "",   "",    false, false },
  { u8"Kodeoha",                                                    "vko",     "",   "",    false, false },
  { u8"Kodi",                                                       "kod",     "",   "",    false, false },
  { u8"Kodia",                                                      "kwp",     "",   "",    false, false },
  { u8"Koenoem",                                                    "kcs",     "",   "",    false, false },
  { u8"Kofa",                                                       "kso",     "",   "",    false, false },
  { u8"Kofei",                                                      "kpi",     "",   "",    false, false },
  { u8"Kofyar",                                                     "kwl",     "",   "",    false, false },
  { u8"Koguryo",                                                    "zkg",     "",   "",    false, false },
  { u8"Kohin",                                                      "kkx",     "",   "",    false, false },
  { u8"Kohistani Shina",                                            "plk",     "",   "",    false, false },
  { u8"Koho",                                                       "kpm",     "",   "",    false, false },
  { u8"Kohumono",                                                   "bcs",     "",   "",    false, false },
  { u8"Koi",                                                        "kkt",     "",   "",    false, false },
  { u8"Koibal",                                                     "zkb",     "",   "",    false, false },
  { u8"Koireng",                                                    "nkd",     "",   "",    false, false },
  { u8"Koitabu",                                                    "kqi",     "",   "",    false, false },
  { u8"Koiwat",                                                     "kxt",     "",   "",    false, false },
  { u8"Kok Borok",                                                  "trp",     "",   "",    false, false },
  { u8"Kok-Nar",                                                    "gko",     "",   "",    false, false },
  { u8"Kokata",                                                     "ktd",     "",   "",    false, false },
  { u8"Koke",                                                       "kou",     "",   "",    false, false },
  { u8"Koki Naga",                                                  "nxk",     "",   "",    false, false },
  { u8"Koko Babangk",                                               "okg",     "",   "",    false, false },
  { u8"Kokoda",                                                     "xod",     "",   "",    false, false },
  { u8"Kokola",                                                     "kzn",     "",   "",    false, false },
  { u8"Kokota",                                                     "kkk",     "",   "",    false, false },
  { u8"Kol (Bangladesh)",                                           "ekl",     "",   "",    false, false },
  { u8"Kol (Cameroon)",                                             "biw",     "",   "",    false, false },
  { u8"Kol (Papua New Guinea)",                                     "kol",     "",   "",    false, false },
  { u8"Kola",                                                       "kvv",     "",   "",    false, false },
  { u8"Kolbila",                                                    "klc",     "",   "",    false, false },
  { u8"Kolibugan Subanon",                                          "skn",     "",   "",    false, false },
  { u8"Kolum So Dogon",                                             "dkl",     "",   "",    false, true  },
  { u8"Koluwawa",                                                   "klx",     "",   "",    false, false },
  { u8"Kom (Cameroon)",                                             "bkm",     "",   "",    false, false },
  { u8"Kom (India)",                                                "kmm",     "",   "",    false, false },
  { u8"Koma",                                                       "kmy",     "",   "",    false, false },
  { u8"Komba",                                                      "kpf",     "",   "",    false, false },
  { u8"Kombai",                                                     "tyn",     "",   "",    false, false },
  { u8"Kombio",                                                     "xbi",     "",   "",    false, false },
  { u8"Komering",                                                   "kge",     "",   "",    false, false },
  { u8"Komi",                                                       "kom",     "kv", "",    true,  false },
  { u8"Komi-Permyak",                                               "koi",     "",   "",    false, false },
  { u8"Komi-Zyrian",                                                "kpv",     "",   "",    false, false },
  { u8"Kominimung",                                                 "xoi",     "",   "",    false, false },
  { u8"Komo (Democratic Republic of Congo)",                        "kmw",     "",   "",    false, false },
  { u8"Komo (Sudan)",                                               "xom",     "",   "",    false, false },
  { u8"Komodo",                                                     "kvh",     "",   "",    false, false },
  { u8"Kompane",                                                    "kvp",     "",   "",    false, false },
  { u8"Komyandaret",                                                "kzv",     "",   "",    false, false },
  { u8"Kon Keu",                                                    "kkn",     "",   "",    false, false },
  { u8"Konai",                                                      "kxw",     "",   "",    false, false },
  { u8"Konda",                                                      "knd",     "",   "",    false, false },
  { u8"Konda-Dora",                                                 "kfc",     "",   "",    false, false },
  { u8"Koneraw",                                                    "kdw",     "",   "",    false, false },
  { u8"Kongo",                                                      "kon",     "kg", "",    true,  false },
  { u8"Konkani (individual language)",                              "knn",     "",   "",    false, false },
  { u8"Konkani (macrolanguage)",                                    "kok",     "",   "",    true,  false },
  { u8"Konkomba",                                                   "xon",     "",   "",    false, false },
  { u8"Konni",                                                      "kma",     "",   "",    false, false },
  { u8"Kono (Guinea)",                                              "knu",     "",   "",    false, false },
  { u8"Kono (Nigeria)",                                             "klk",     "",   "",    false, false },
  { u8"Kono (Sierra Leone)",                                        "kno",     "",   "",    false, false },
  { u8"Konomala",                                                   "koa",     "",   "",    false, false },
  { u8"Konongo",                                                    "kcz",     "",   "",    false, false },
  { u8"Konso",                                                      "kxc",     "",   "",    false, false },
  { u8"Konyak Naga",                                                "nbe",     "",   "",    false, false },
  { u8"Konyanka Maninka",                                           "mku",     "",   "",    false, false },
  { u8"Konzo",                                                      "koo",     "",   "",    false, false },
  { u8"Koongo",                                                     "kng",     "",   "",    false, false },
  { u8"Koonzime",                                                   "ozm",     "",   "",    false, false },
  { u8"Koorete",                                                    "kqy",     "",   "",    false, false },
  { u8"Kopar",                                                      "xop",     "",   "",    false, false },
  { u8"Kopkaka",                                                    "opk",     "",   "",    false, false },
  { u8"Korafe-Yegha",                                               "kpr",     "",   "",    false, false },
  { u8"Korak",                                                      "koz",     "",   "",    false, false },
  { u8"Korana",                                                     "kqz",     "",   "",    false, false },
  { u8"Korandje",                                                   "kcy",     "",   "",    false, false },
  { u8"Kordofanian languages",                                      "kdo",     "",   "",    false, false },
  { u8"Korean Sign Language",                                       "kvk",     "",   "",    false, false },
  { u8"Korean",                                                     "kor",     "ko", "",    true,  false },
  { u8"Koreguaje",                                                  "coe",     "",   "",    false, false },
  { u8"Koresh-e Rostam",                                            "okh",     "",   "",    false, false },
  { u8"Korku",                                                      "kfq",     "",   "",    false, false },
  { u8"Korlai Creole Portuguese",                                   "vkp",     "",   "",    false, false },
  { u8"Koro (Côte d'Ivoire)",                                       "kfo",     "",   "",    false, false },
  { u8"Koro (India)",                                               "jkr",     "",   "",    false, false },
  { u8"Koro (Papua New Guinea)",                                    "kxr",     "",   "",    false, false },
  { u8"Koro (Vanuatu)",                                             "krf",     "",   "",    false, false },
  { u8"Koro Nulu",                                                  "vkn",     "",   "",    false, false },
  { u8"Koro Wachi",                                                 "bqv",     "",   "",    false, false },
  { u8"Koro Zuba",                                                  "vkz",     "",   "",    false, false },
  { u8"Koromfé",                                                    "kfz",     "",   "",    false, false },
  { u8"Koromira",                                                   "kqj",     "",   "",    false, false },
  { u8"Koronadal Blaan",                                            "bpr",     "",   "",    false, false },
  { u8"Koroni",                                                     "xkq",     "",   "",    false, false },
  { u8"Korop",                                                      "krp",     "",   "",    false, false },
  { u8"Koropó",                                                     "xxr",     "",   "",    false, false },
  { u8"Koroshi",                                                    "ktl",     "",   "",    false, false },
  { u8"Korowai",                                                    "khe",     "",   "",    false, false },
  { u8"Korra Koraga",                                               "kfd",     "",   "",    false, false },
  { u8"Korubo",                                                     "xor",     "",   "",    false, false },
  { u8"Korupun-Sela",                                               "kpq",     "",   "",    false, false },
  { u8"Korwa",                                                      "kfp",     "",   "",    false, false },
  { u8"Koryak",                                                     "kpy",     "",   "",    false, false },
  { u8"Kosadle",                                                    "kiq",     "",   "",    false, false },
  { u8"Kosarek Yale",                                               "kkl",     "",   "",    false, false },
  { u8"Kosena",                                                     "kze",     "",   "",    false, false },
  { u8"Koshin",                                                     "kid",     "",   "",    false, false },
  { u8"Kosraean",                                                   "kos",     "",   "",    true,  false },
  { u8"Kota (Gabon)",                                               "koq",     "",   "",    false, false },
  { u8"Kota (India)",                                               "kfe",     "",   "",    false, false },
  { u8"Kota Bangun Kutai Malay",                                    "mqg",     "",   "",    false, false },
  { u8"Kota Marudu Talantang",                                      "grm",     "",   "",    false, false },
  { u8"Kota Marudu Tinagas",                                        "ktr",     "",   "",    false, true  },
  { u8"Kotafon Gbe",                                                "kqk",     "",   "",    false, false },
  { u8"Kotava",                                                     "avk",     "",   "",    false, false },
  { u8"Koti",                                                       "eko",     "",   "",    false, false },
  { u8"Kott",                                                       "zko",     "",   "",    false, false },
  { u8"Kou",                                                        "snz",     "",   "",    false, false },
  { u8"Kouya",                                                      "kyf",     "",   "",    false, false },
  { u8"Kovai",                                                      "kqb",     "",   "",    false, false },
  { u8"Kove",                                                       "kvc",     "",   "",    false, false },
  { u8"Kowaki",                                                     "xow",     "",   "",    false, false },
  { u8"Kowiai",                                                     "kwh",     "",   "",    false, false },
  { u8"Koy Sanjaq Surat",                                           "kqd",     "",   "",    false, false },
  { u8"Koya",                                                       "kff",     "",   "",    false, false },
  { u8"Koyaga",                                                     "kga",     "",   "",    false, false },
  { u8"Koyo",                                                       "koh",     "",   "",    false, false },
  { u8"Koyra Chiini Songhay",                                       "khq",     "",   "",    false, false },
  { u8"Koyraboro Senni Songhai",                                    "ses",     "",   "",    false, false },
  { u8"Koyukon",                                                    "koy",     "",   "",    false, false },
  { u8"Kpagua",                                                     "kuw",     "",   "",    false, false },
  { u8"Kpala",                                                      "kpl",     "",   "",    false, false },
  { u8"Kpan",                                                       "kpk",     "",   "",    false, false },
  { u8"Kpasam",                                                     "pbn",     "",   "",    false, false },
  { u8"Kpati",                                                      "koc",     "",   "",    false, false },
  { u8"Kpatili",                                                    "kym",     "",   "",    false, false },
  { u8"Kpeego",                                                     "cpo",     "",   "",    false, false },
  { u8"Kpelle",                                                     "kpe",     "",   "",    true,  false },
  { u8"Kpessi",                                                     "kef",     "",   "",    false, false },
  { u8"Kplang",                                                     "kph",     "",   "",    false, false },
  { u8"Krache",                                                     "kye",     "",   "",    false, false },
  { u8"Krahô",                                                      "xra",     "",   "",    false, false },
  { u8"Kraol",                                                      "rka",     "",   "",    false, false },
  { u8"Krenak",                                                     "kqq",     "",   "",    false, false },
  { u8"Krevinian",                                                  "zkv",     "",   "",    false, false },
  { u8"Kreye",                                                      "xre",     "",   "",    false, false },
  { u8"Kriang",                                                     "ngt",     "",   "",    false, false },
  { u8"Krikati-Timbira",                                            "xri",     "",   "",    false, false },
  { u8"Krim",                                                       "krm",     "",   "",    false, true  },
  { u8"Krio",                                                       "kri",     "",   "",    false, false },
  { u8"Kriol",                                                      "rop",     "",   "",    false, false },
  { u8"Krisa",                                                      "ksi",     "",   "",    false, false },
  { u8"Krobu",                                                      "kxb",     "",   "",    false, false },
  { u8"Krongo",                                                     "kgo",     "",   "",    false, false },
  { u8"Kru languages",                                              "kro",     "",   "",    true,  false },
  { u8"Krung",                                                      "krr",     "",   "",    false, false },
  { u8"Krymchak",                                                   "jct",     "",   "",    false, false },
  { u8"Kryts",                                                      "kry",     "",   "",    false, false },
  { u8"Kua",                                                        "tyu",     "",   "",    false, false },
  { u8"Kua-nsi",                                                    "ykn",     "",   "",    false, false },
  { u8"Kuamasi",                                                    "yku",     "",   "",    false, false },
  { u8"Kuan",                                                       "uan",     "",   "",    false, false },
  { u8"Kuanhua",                                                    "xnh",     "",   "",    false, false },
  { u8"Kuanua",                                                     "ksd",     "",   "",    false, false },
  { u8"Kuanyama",                                                   "kua",     "kj", "",    true,  false },
  { u8"Kubachi",                                                    "ugh",     "",   "",    false, false },
  { u8"Kube",                                                       "kgf",     "",   "",    false, false },
  { u8"Kubi",                                                       "kof",     "",   "",    false, false },
  { u8"Kubo",                                                       "jko",     "",   "",    false, false },
  { u8"Kubu",                                                       "kvb",     "",   "",    false, false },
  { u8"Kucong",                                                     "lkc",     "",   "",    false, false },
  { u8"Kudiya",                                                     "kfg",     "",   "",    false, false },
  { u8"Kudmali",                                                    "kyw",     "",   "",    false, false },
  { u8"Kudu-Camo",                                                  "kov",     "",   "",    false, false },
  { u8"Kufr Qassem Sign Language (KQSL)",                           "sqx",     "",   "",    false, false },
  { u8"Kugama",                                                     "kow",     "",   "",    false, false },
  { u8"Kugbo",                                                      "kes",     "",   "",    false, false },
  { u8"Kugu-Muminh",                                                "xmh",     "",   "",    false, false },
  { u8"Kui (India)",                                                "kxu",     "",   "",    false, true  },
  { u8"Kui (India)",                                                "uki",     "",   "",    false, false },
  { u8"Kui (Indonesia)",                                            "kvd",     "",   "",    false, false },
  { u8"Kuijau",                                                     "dkr",     "",   "",    false, false },
  { u8"Kuikúro-Kalapálo",                                           "kui",     "",   "",    false, false },
  { u8"Kujarge",                                                    "vkj",     "",   "",    false, false },
  { u8"Kuk",                                                        "kfn",     "",   "",    false, false },
  { u8"Kukatja",                                                    "kux",     "",   "",    false, false },
  { u8"Kuke",                                                       "ght",     "",   "",    false, false },
  { u8"Kukele",                                                     "kez",     "",   "",    false, false },
  { u8"Kukna",                                                      "kex",     "",   "",    false, false },
  { u8"Kuku",                                                       "ukv",     "",   "",    false, false },
  { u8"Kuku-Mangk",                                                 "xmq",     "",   "",    false, false },
  { u8"Kuku-Mu'inh",                                                "xmp",     "",   "",    false, false },
  { u8"Kuku-Ugbanh",                                                "ugb",     "",   "",    false, false },
  { u8"Kuku-Uwanh",                                                 "uwa",     "",   "",    false, false },
  { u8"Kuku-Yalanji",                                               "gvn",     "",   "",    false, false },
  { u8"Kula",                                                       "tpg",     "",   "",    false, false },
  { u8"Kulere",                                                     "kul",     "",   "",    false, false },
  { u8"Kulfa",                                                      "kxj",     "",   "",    false, false },
  { u8"Kulina Pano",                                                "xpk",     "",   "",    false, false },
  { u8"Kulisusu",                                                   "vkl",     "",   "",    false, false },
  { u8"Kullu Pahari",                                               "kfx",     "",   "",    false, false },
  { u8"Kulon",                                                      "uon",     "",   "",    false, false },
  { u8"Kulon-Pazeh",                                                "uun",     "",   "",    false, true  },
  { u8"Kulung (Nepal)",                                             "kle",     "",   "",    false, false },
  { u8"Kulung (Nigeria)",                                           "bbu",     "",   "",    false, false },
  { u8"Kumalu",                                                     "ksl",     "",   "",    false, false },
  { u8"Kumam",                                                      "kdi",     "",   "",    false, false },
  { u8"Kuman (Papua New Guinea)",                                   "kue",     "",   "",    false, false },
  { u8"Kuman (Russia)",                                             "qwm",     "",   "",    false, false },
  { u8"Kumaoni",                                                    "kfy",     "",   "",    false, false },
  { u8"Kumarbhag Paharia",                                          "kmj",     "",   "",    false, false },
  { u8"Kumba",                                                      "ksm",     "",   "",    false, false },
  { u8"Kumbainggar",                                                "kgs",     "",   "",    false, false },
  { u8"Kumbaran",                                                   "wkb",     "",   "",    false, false },
  { u8"Kumbewaha",                                                  "xks",     "",   "",    false, false },
  { u8"Kumhali",                                                    "kra",     "",   "",    false, false },
  { u8"Kumiai",                                                     "dih",     "",   "",    false, false },
  { u8"Kumukio",                                                    "kuo",     "",   "",    false, false },
  { u8"Kumyk",                                                      "kum",     "",   "",    true,  false },
  { u8"Kumzari",                                                    "zum",     "",   "",    false, false },
  { u8"Kunama",                                                     "kun",     "",   "",    false, false },
  { u8"Kunbarlang",                                                 "wlg",     "",   "",    false, false },
  { u8"Kunda",                                                      "kdn",     "",   "",    false, false },
  { u8"Kundal Shahi",                                               "shd",     "",   "",    false, false },
  { u8"Kunduvadi",                                                  "wku",     "",   "",    false, false },
  { u8"Kung",                                                       "kfl",     "",   "",    false, false },
  { u8"Kung-Ekoka",                                                 "knw",     "",   "",    false, false },
  { u8"Kungarakany",                                                "ggk",     "",   "",    false, false },
  { u8"Kungardutyi",                                                "gdt",     "",   "",    false, false },
  { u8"Kunggara",                                                   "kvs",     "",   "",    false, true  },
  { u8"Kunggari",                                                   "kgl",     "",   "",    false, false },
  { u8"Kungkari",                                                   "lku",     "",   "",    false, false },
  { u8"Kuni",                                                       "kse",     "",   "",    false, false },
  { u8"Kuni-Boazi",                                                 "kvg",     "",   "",    false, false },
  { u8"Kunigami",                                                   "xug",     "",   "",    false, false },
  { u8"Kunimaipa",                                                  "kup",     "",   "",    false, false },
  { u8"Kunja",                                                      "pep",     "",   "",    false, false },
  { u8"Kunjen",                                                     "kjn",     "",   "",    false, false },
  { u8"Kunyi",                                                      "njx",     "",   "",    false, false },
  { u8"Kunza",                                                      "kuz",     "",   "",    false, false },
  { u8"Kuo",                                                        "xuo",     "",   "",    false, false },
  { u8"Kuot",                                                       "kto",     "",   "",    false, false },
  { u8"Kupa",                                                       "kug",     "",   "",    false, false },
  { u8"Kupang Malay",                                               "mkn",     "",   "",    false, false },
  { u8"Kupia",                                                      "key",     "",   "",    false, false },
  { u8"Kupsabiny",                                                  "kpz",     "",   "",    false, false },
  { u8"Kur",                                                        "kuv",     "",   "",    false, false },
  { u8"Kura Ede Nago",                                              "nqk",     "",   "",    false, false },
  { u8"Kurama",                                                     "krh",     "",   "",    false, false },
  { u8"Kuranko",                                                    "knk",     "",   "",    false, false },
  { u8"Kurdish",                                                    "kur",     "ku", "",    true,  false },
  { u8"Kuri",                                                       "nbn",     "",   "",    false, false },
  { u8"Kuria",                                                      "kuj",     "",   "",    false, false },
  { u8"Kurichiya",                                                  "kfh",     "",   "",    false, false },
  { u8"Kurmukar",                                                   "kfv",     "",   "",    false, false },
  { u8"Kurnai",                                                     "unn",     "",   "",    false, false },
  { u8"Kurrama",                                                    "vku",     "",   "",    false, false },
  { u8"Kurti",                                                      "ktm",     "",   "",    false, false },
  { u8"Kurtokha",                                                   "xkz",     "",   "",    false, false },
  { u8"Kurudu",                                                     "kjr",     "",   "",    false, false },
  { u8"Kurukh",                                                     "kru",     "",   "",    true,  false },
  { u8"Kuruáya",                                                    "kyr",     "",   "",    false, false },
  { u8"Kusaal",                                                     "kus",     "",   "",    false, false },
  { u8"Kusaghe",                                                    "ksg",     "",   "",    false, false },
  { u8"Kushi",                                                      "kuh",     "",   "",    false, false },
  { u8"Kusu",                                                       "ksv",     "",   "",    false, false },
  { u8"Kusunda",                                                    "kgg",     "",   "",    false, false },
  { u8"Kutenai",                                                    "kut",     "",   "",    true,  false },
  { u8"Kutep",                                                      "kub",     "",   "",    false, false },
  { u8"Kuthant",                                                    "xut",     "",   "",    false, false },
  { u8"Kutong",                                                     "skm",     "",   "",    false, false },
  { u8"Kutto",                                                      "kpa",     "",   "",    false, false },
  { u8"Kutu",                                                       "kdc",     "",   "",    false, false },
  { u8"Kuturmi",                                                    "khj",     "",   "",    false, false },
  { u8"Kuuk Thaayorre",                                             "thd",     "",   "",    false, false },
  { u8"Kuuk-Yak",                                                   "uky",     "",   "",    false, false },
  { u8"Kuuku-Ya'u",                                                 "kuy",     "",   "",    false, false },
  { u8"Kuvale",                                                     "olu",     "",   "",    false, false },
  { u8"Kuvi",                                                       "kxv",     "",   "",    false, false },
  { u8"Kuwaa",                                                      "blh",     "",   "",    false, false },
  { u8"Kuwaataay",                                                  "cwt",     "",   "",    false, false },
  { u8"Kuwema",                                                     "woa",     "",   "",    false, false },
  { u8"Kuy",                                                        "kdt",     "",   "",    false, false },
  { u8"Kven Finnish",                                               "fkv",     "",   "",    false, false },
  { u8"Kw'adza",                                                    "wka",     "",   "",    false, false },
  { u8"Kwa",                                                        "kwb",     "",   "",    false, false },
  { u8"Kwa'",                                                       "bko",     "",   "",    false, false },
  { u8"Kwaami",                                                     "ksq",     "",   "",    false, false },
  { u8"Kwadi",                                                      "kwz",     "",   "",    false, false },
  { u8"Kwaio",                                                      "kwd",     "",   "",    false, false },
  { u8"Kwaja",                                                      "kdz",     "",   "",    false, false },
  { u8"Kwak",                                                       "kwq",     "",   "",    false, true  },
  { u8"Kwakiutl",                                                   "kwk",     "",   "",    false, false },
  { u8"Kwakum",                                                     "kwu",     "",   "",    false, false },
  { u8"Kwalhioqua-Tlatskanai",                                      "qwt",     "",   "",    false, false },
  { u8"Kwama",                                                      "kmq",     "",   "",    false, false },
  { u8"Kwambi",                                                     "kwm",     "",   "",    false, false },
  { u8"Kwamera",                                                    "tnk",     "",   "",    false, false },
  { u8"Kwami",                                                      "ktf",     "",   "",    false, false },
  { u8"Kwamtim One",                                                "okk",     "",   "",    false, false },
  { u8"Kwandu",                                                     "xdo",     "",   "",    false, false },
  { u8"Kwang",                                                      "kvi",     "",   "",    false, false },
  { u8"Kwanga",                                                     "kwj",     "",   "",    false, false },
  { u8"Kwangali",                                                   "kwn",     "",   "",    false, false },
  { u8"Kwanja",                                                     "knp",     "",   "",    false, false },
  { u8"Kwara'ae",                                                   "kwf",     "",   "",    false, false },
  { u8"Kwasio",                                                     "nmg",     "",   "",    false, false },
  { u8"Kwaya",                                                      "kya",     "",   "",    false, false },
  { u8"Kwaza",                                                      "xwa",     "",   "",    false, false },
  { u8"Kwegu",                                                      "xwg",     "",   "",    false, false },
  { u8"Kwer",                                                       "kwr",     "",   "",    false, false },
  { u8"Kwerba Mamberamo",                                           "xwr",     "",   "",    false, false },
  { u8"Kwerba",                                                     "kwe",     "",   "",    false, false },
  { u8"Kwere",                                                      "cwe",     "",   "",    false, false },
  { u8"Kwerisa",                                                    "kkb",     "",   "",    false, false },
  { u8"Kwese",                                                      "kws",     "",   "",    false, false },
  { u8"Kwesten",                                                    "kwt",     "",   "",    false, false },
  { u8"Kwini",                                                      "gww",     "",   "",    false, false },
  { u8"Kwinsu",                                                     "kuc",     "",   "",    false, false },
  { u8"Kwinti",                                                     "kww",     "",   "",    false, false },
  { u8"Kwoma",                                                      "kmo",     "",   "",    false, false },
  { u8"Kwomtari",                                                   "kwo",     "",   "",    false, false },
  { u8"Kxoe",                                                       "xuu",     "",   "",    false, false },
  { u8"Kyak",                                                       "bka",     "",   "",    false, false },
  { u8"Kyaka",                                                      "kyc",     "",   "",    false, false },
  { u8"Kyan-Karyaw Naga",                                           "nqq",     "",   "",    false, false },
  { u8"Kyanga",                                                     "tye",     "",   "",    false, false },
  { u8"Kyenele",                                                    "kql",     "",   "",    false, false },
  { u8"Kyerung",                                                    "kgy",     "",   "",    false, false },
  { u8"Kâte",                                                       "kmg",     "",   "",    false, false },
  { u8"Kélé",                                                       "keb",     "",   "",    false, false },
  { u8"Kölsch",                                                     "ksh",     "",   "",    false, false },
  { u8"Kɛlɛngaxo Bozo",                                             "bzx",     "",   "",    false, false },
  { u8"La'bi",                                                      "lbi",     "",   "",    false, false },
  { u8"Laal",                                                       "gdm",     "",   "",    false, false },
  { u8"Laari",                                                      "ldi",     "",   "",    false, false },
  { u8"Laba",                                                       "lau",     "",   "",    false, false },
  { u8"Label",                                                      "lbb",     "",   "",    false, false },
  { u8"Labir",                                                      "jku",     "",   "",    false, false },
  { u8"Labo Phowa",                                                 "ypb",     "",   "",    false, false },
  { u8"Labo",                                                       "mwi",     "",   "",    false, false },
  { u8"Labu",                                                       "lbu",     "",   "",    false, false },
  { u8"Labuk-Kinabatangan Kadazan",                                 "dtb",     "",   "",    false, false },
  { u8"Lacandon",                                                   "lac",     "",   "",    false, false },
  { u8"Lachi",                                                      "lbt",     "",   "",    false, false },
  { u8"Lachiguiri Zapotec",                                         "zpa",     "",   "",    false, false },
  { u8"Lachixío Zapotec",                                           "zpl",     "",   "",    false, false },
  { u8"Ladakhi",                                                    "lbj",     "",   "",    false, false },
  { u8"Ladin",                                                      "lld",     "",   "",    false, false },
  { u8"Ladino",                                                     "lad",     "",   "",    true,  false },
  { u8"Ladji Ladji",                                                "llj",     "",   "",    false, false },
  { u8"Laeko-Libuat",                                               "lkl",     "",   "",    false, false },
  { u8"Lafofa",                                                     "laf",     "",   "",    false, false },
  { u8"Laghu",                                                      "lgb",     "",   "",    false, false },
  { u8"Laghuu",                                                     "lgh",     "",   "",    false, false },
  { u8"Lagwan",                                                     "kot",     "",   "",    false, false },
  { u8"Laha (Indonesia)",                                           "lhh",     "",   "",    false, false },
  { u8"Laha (Viet Nam)",                                            "lha",     "",   "",    false, false },
  { u8"Lahanan",                                                    "lhn",     "",   "",    false, false },
  { u8"Lahnda",                                                     "lah",     "",   "",    true,  false },
  { u8"Lahta Karen",                                                "kvt",     "",   "",    false, false },
  { u8"Lahu Shi",                                                   "lhi",     "",   "",    false, false },
  { u8"Lahu",                                                       "lhu",     "",   "",    false, false },
  { u8"Lahul Lohar",                                                "lhl",     "",   "",    false, false },
  { u8"Laimbue",                                                    "lmx",     "",   "",    false, false },
  { u8"Laitu Chin",                                                 "clj",     "",   "",    false, false },
  { u8"Laiyolo",                                                    "lji",     "",   "",    false, false },
  { u8"Lak",                                                        "lbe",     "",   "",    false, false },
  { u8"Laka (Chad)",                                                "lap",     "",   "",    false, false },
  { u8"Laka (Nigeria)",                                             "lak",     "",   "",    false, true  },
  { u8"Lakalei",                                                    "lka",     "",   "",    false, false },
  { u8"Lake Miwok",                                                 "lmw",     "",   "",    false, false },
  { u8"Lakha",                                                      "lkh",     "",   "",    false, false },
  { u8"Laki",                                                       "lki",     "",   "",    false, false },
  { u8"Lakkia",                                                     "lbc",     "",   "",    false, false },
  { u8"Lakon",                                                      "lkn",     "",   "",    false, false },
  { u8"Lakondê",                                                    "lkd",     "",   "",    false, false },
  { u8"Lakota Dida",                                                "dic",     "",   "",    false, false },
  { u8"Lakota",                                                     "lkt",     "",   "",    false, false },
  { u8"Lakurumau",                                                  "lxm",     "",   "",    false, false },
  { u8"Lala",                                                       "nrz",     "",   "",    false, false },
  { u8"Lala-Bisa",                                                  "leb",     "",   "",    false, false },
  { u8"Lala-Roba",                                                  "lla",     "",   "",    false, false },
  { u8"Lalana Chinantec",                                           "cnl",     "",   "",    false, false },
  { u8"Lalia",                                                      "lal",     "",   "",    false, false },
  { u8"Lama (Togo)",                                                "las",     "",   "",    false, false },
  { u8"Lama Bai",                                                   "lay",     "",   "",    false, false },
  { u8"Lamaholot",                                                  "slp",     "",   "",    false, false },
  { u8"Lamalama",                                                   "lby",     "",   "",    false, false },
  { u8"Lamalera",                                                   "lmr",     "",   "",    false, false },
  { u8"Lamam",                                                      "lmm",     "",   "",    false, true  },
  { u8"Lamang",                                                     "hia",     "",   "",    false, false },
  { u8"Lamatuka",                                                   "lmq",     "",   "",    false, false },
  { u8"Lamba",                                                      "lam",     "",   "",    true,  false },
  { u8"Lambadi",                                                    "lmn",     "",   "",    false, false },
  { u8"Lambayeque Quechua",                                         "quf",     "",   "",    false, false },
  { u8"Lambichhong",                                                "lmh",     "",   "",    false, false },
  { u8"Lamboya",                                                    "lmy",     "",   "",    false, false },
  { u8"Lambya",                                                     "lai",     "",   "",    false, false },
  { u8"Lame",                                                       "bma",     "",   "",    false, false },
  { u8"Lamenu",                                                     "lmu",     "",   "",    false, false },
  { u8"Lamja-Dengsa-Tola",                                          "ldh",     "",   "",    false, false },
  { u8"Lamkang",                                                    "lmk",     "",   "",    false, false },
  { u8"Lamma",                                                      "lev",     "",   "",    false, false },
  { u8"Lamnso'",                                                    "lns",     "",   "",    false, false },
  { u8"Lamogai",                                                    "lmg",     "",   "",    false, false },
  { u8"Lampung Api",                                                "ljp",     "",   "",    false, false },
  { u8"Lampung Nyo",                                                "abl",     "",   "",    false, false },
  { u8"Lamu",                                                       "llh",     "",   "",    false, false },
  { u8"Lanas Lobu",                                                 "ruu",     "",   "",    false, false },
  { u8"Land Dayak languages",                                       "day",     "",   "",    true,  false },
  { u8"Landoma",                                                    "ldm",     "",   "",    false, false },
  { u8"Lang'e",                                                     "yne",     "",   "",    false, false },
  { u8"Langam",                                                     "lnm",     "",   "",    false, false },
  { u8"Langbashe",                                                  "lna",     "",   "",    false, false },
  { u8"Langi",                                                      "lag",     "",   "",    false, false },
  { u8"Langnian Buyang",                                            "yln",     "",   "",    false, false },
  { u8"Lango (South Sudan)",                                        "lgo",     "",   "",    false, false },
  { u8"Lango (South Sudan)",                                        "lno",     "",   "",    false, true  },
  { u8"Lango (Uganda)",                                             "laj",     "",   "",    false, false },
  { u8"Langobardic",                                                "lng",     "",   "",    false, false },
  { u8"Langue des signes de Belgique Francophone",                  "sfb",     "",   "",    false, false },
  { u8"Lanima",                                                     "lnw",     "",   "",    false, false },
  { u8"Lanoh",                                                      "lnh",     "",   "",    false, false },
  { u8"Lao Naga",                                                   "nlq",     "",   "",    false, false },
  { u8"Lao",                                                        "lao",     "lo", "",    true,  false },
  { u8"Laomian",                                                    "lwm",     "",   "",    false, false },
  { u8"Laopang",                                                    "lbg",     "",   "",    false, false },
  { u8"Laos Sign Language",                                         "lso",     "",   "",    false, false },
  { u8"Lapaguía-Guivini Zapotec",                                   "ztl",     "",   "",    false, false },
  { u8"Laragia",                                                    "lrg",     "",   "",    false, false },
  { u8"Larantuka Malay",                                            "lrt",     "",   "",    false, false },
  { u8"Lardil",                                                     "lbz",     "",   "",    false, false },
  { u8"Larevat",                                                    "lrv",     "",   "",    false, false },
  { u8"Large Flowery Miao",                                         "hmd",     "",   "",    false, false },
  { u8"Lari",                                                       "lrl",     "",   "",    false, false },
  { u8"Larike-Wakasihu",                                            "alo",     "",   "",    false, false },
  { u8"Laro",                                                       "lro",     "",   "",    false, false },
  { u8"Larteh",                                                     "lar",     "",   "",    false, false },
  { u8"Laru",                                                       "lan",     "",   "",    false, false },
  { u8"Las Delicias Zapotec",                                       "zcd",     "",   "",    false, false },
  { u8"Lasalimu",                                                   "llm",     "",   "",    false, false },
  { u8"Lasgerdi",                                                   "lsa",     "",   "",    false, false },
  { u8"Lashi",                                                      "lsi",     "",   "",    false, false },
  { u8"Lasi",                                                       "lss",     "",   "",    false, false },
  { u8"Late Middle Chinese",                                        "ltc",     "",   "",    false, false },
  { u8"Latgalian",                                                  "ltg",     "",   "",    false, false },
  { u8"Latin",                                                      "lat",     "la", "",    true,  false },
  { u8"Latu",                                                       "ltu",     "",   "",    false, false },
  { u8"Latundê",                                                    "ltn",     "",   "",    false, false },
  { u8"Latvian Sign Language",                                      "lsl",     "",   "",    false, false },
  { u8"Latvian",                                                    "lav",     "lv", "",    true,  false },
  { u8"Lau",                                                        "llu",     "",   "",    false, false },
  { u8"Laua",                                                       "luf",     "",   "",    false, false },
  { u8"Lauan",                                                      "llx",     "",   "",    false, false },
  { u8"Lauje",                                                      "law",     "",   "",    false, false },
  { u8"Laura",                                                      "lur",     "",   "",    false, false },
  { u8"Laurentian",                                                 "lre",     "",   "",    false, false },
  { u8"Lautu Chin",                                                 "clt",     "",   "",    false, false },
  { u8"Lavatbura-Lamusong",                                         "lbv",     "",   "",    false, false },
  { u8"Laven",                                                      "lbo",     "",   "",    false, false },
  { u8"Lavi",                                                       "lvi",     "",   "",    false, false },
  { u8"Lavukaleve",                                                 "lvk",     "",   "",    false, false },
  { u8"Lawangan",                                                   "lbx",     "",   "",    false, false },
  { u8"Lawu",                                                       "lwu",     "",   "",    false, false },
  { u8"Lawunuia",                                                   "tgi",     "",   "",    false, false },
  { u8"Layakha",                                                    "lya",     "",   "",    false, false },
  { u8"Laz",                                                        "lzz",     "",   "",    false, false },
  { u8"Lealao Chinantec",                                           "cle",     "",   "",    false, false },
  { u8"Leco",                                                       "lec",     "",   "",    false, false },
  { u8"Ledo Kaili",                                                 "lew",     "",   "",    false, false },
  { u8"Leelau",                                                     "ldk",     "",   "",    false, false },
  { u8"Lefa",                                                       "lfa",     "",   "",    false, false },
  { u8"Lega-Mwenga",                                                "lgm",     "",   "",    false, false },
  { u8"Lega-Shabunda",                                              "lea",     "",   "",    false, false },
  { u8"Legbo",                                                      "agb",     "",   "",    false, false },
  { u8"Legenyem",                                                   "lcc",     "",   "",    false, false },
  { u8"Lehali",                                                     "tql",     "",   "",    false, false },
  { u8"Lehalurup",                                                  "urr",     "",   "",    false, false },
  { u8"Lehar",                                                      "cae",     "",   "",    false, false },
  { u8"Leinong Naga",                                               "lzn",     "",   "",    false, false },
  { u8"Leipon",                                                     "lek",     "",   "",    false, false },
  { u8"Lelak",                                                      "llk",     "",   "",    false, false },
  { u8"Lele (Chad)",                                                "lln",     "",   "",    false, false },
  { u8"Lele (Democratic Republic of Congo)",                        "lel",     "",   "",    false, false },
  { u8"Lele (Guinea)",                                              "llc",     "",   "",    false, false },
  { u8"Lele (Papua New Guinea)",                                    "lle",     "",   "",    false, false },
  { u8"Lelemi",                                                     "lef",     "",   "",    false, false },
  { u8"Lelepa",                                                     "lpa",     "",   "",    false, false },
  { u8"Lembena",                                                    "leq",     "",   "",    false, false },
  { u8"Lemerig",                                                    "lrz",     "",   "",    false, false },
  { u8"Lemio",                                                      "lei",     "",   "",    false, false },
  { u8"Lemnian",                                                    "xle",     "",   "",    false, false },
  { u8"Lemolang",                                                   "ley",     "",   "",    false, false },
  { u8"Lemoro",                                                     "ldj",     "",   "",    false, false },
  { u8"Lenakel",                                                    "tnl",     "",   "",    false, false },
  { u8"Lenca",                                                      "len",     "",   "",    false, false },
  { u8"Lendu",                                                      "led",     "",   "",    false, false },
  { u8"Lengilu",                                                    "lgi",     "",   "",    false, false },
  { u8"Lengo",                                                      "lgr",     "",   "",    false, false },
  { u8"Lengola",                                                    "lej",     "",   "",    false, false },
  { u8"Lengua",                                                     "leg",     "",   "",    false, true  },
  { u8"Leningitij",                                                 "lnj",     "",   "",    false, false },
  { u8"Lenje",                                                      "leh",     "",   "",    false, false },
  { u8"Lenkau",                                                     "ler",     "",   "",    false, false },
  { u8"Lenyima",                                                    "ldg",     "",   "",    false, false },
  { u8"Lepcha",                                                     "lep",     "",   "",    false, false },
  { u8"Lepki",                                                      "lpe",     "",   "",    false, false },
  { u8"Lepontic",                                                   "xlp",     "",   "",    false, false },
  { u8"Lere",                                                       "gnh",     "",   "",    false, false },
  { u8"Lese",                                                       "les",     "",   "",    false, false },
  { u8"Lesing-Gelimi",                                              "let",     "",   "",    false, false },
  { u8"Letemboi",                                                   "nms",     "",   "",    false, false },
  { u8"Leti (Cameroon)",                                            "leo",     "",   "",    false, false },
  { u8"Leti (Indonesia)",                                           "lti",     "",   "",    false, false },
  { u8"Levuka",                                                     "lvu",     "",   "",    false, false },
  { u8"Lewo Eleng",                                                 "lwe",     "",   "",    false, false },
  { u8"Lewo",                                                       "lww",     "",   "",    false, false },
  { u8"Lewotobi",                                                   "lwt",     "",   "",    false, false },
  { u8"Leyigha",                                                    "ayi",     "",   "",    false, false },
  { u8"Lezghian",                                                   "lez",     "",   "",    true,  false },
  { u8"Lhokpu",                                                     "lhp",     "",   "",    false, false },
  { u8"Lhomi",                                                      "lhm",     "",   "",    false, false },
  { u8"Li'o",                                                       "ljl",     "",   "",    false, false },
  { u8"Liabuku",                                                    "lix",     "",   "",    false, false },
  { u8"Liana-Seti",                                                 "ste",     "",   "",    false, false },
  { u8"Liangmai Naga",                                              "njn",     "",   "",    false, false },
  { u8"Lianshan Zhuang",                                            "zln",     "",   "",    false, false },
  { u8"Liberia Kpelle",                                             "xpe",     "",   "",    false, false },
  { u8"Liberian English",                                           "lir",     "",   "",    false, false },
  { u8"Libido",                                                     "liq",     "",   "",    false, false },
  { u8"Libinza",                                                    "liz",     "",   "",    false, false },
  { u8"Libon Bikol",                                                "lbl",     "",   "",    false, false },
  { u8"Liburnian",                                                  "xli",     "",   "",    false, false },
  { u8"Libyan Arabic",                                              "ayl",     "",   "",    false, false },
  { u8"Libyan Sign Language",                                       "lbs",     "",   "",    false, false },
  { u8"Lidzonka",                                                   "add",     "",   "",    false, false },
  { u8"Ligbi",                                                      "lig",     "",   "",    false, false },
  { u8"Ligenza",                                                    "lgz",     "",   "",    false, false },
  { u8"Ligurian (Ancient)",                                         "xlg",     "",   "",    false, false },
  { u8"Ligurian",                                                   "lij",     "",   "",    false, false },
  { u8"Lihir",                                                      "lih",     "",   "",    false, false },
  { u8"Lijili",                                                     "mgi",     "",   "",    false, false },
  { u8"Lika",                                                       "lik",     "",   "",    false, false },
  { u8"Liki",                                                       "lio",     "",   "",    false, false },
  { u8"Likila",                                                     "lie",     "",   "",    false, false },
  { u8"Likuba",                                                     "kxx",     "",   "",    false, false },
  { u8"Likum",                                                      "lib",     "",   "",    false, false },
  { u8"Likwala",                                                    "kwc",     "",   "",    false, false },
  { u8"Lilau",                                                      "lll",     "",   "",    false, false },
  { u8"Lillooet",                                                   "lil",     "",   "",    false, false },
  { u8"Limassa",                                                    "bme",     "",   "",    false, false },
  { u8"Limbu",                                                      "lif",     "",   "",    false, false },
  { u8"Limbum",                                                     "lmp",     "",   "",    false, false },
  { u8"Limburgan",                                                  "lim",     "li", "",    true,  false },
  { u8"Limi",                                                       "ylm",     "",   "",    false, false },
  { u8"Limilngan",                                                  "lmc",     "",   "",    false, false },
  { u8"Limos Kalinga",                                              "kmk",     "",   "",    false, false },
  { u8"Linear A",                                                   "lab",     "",   "",    false, false },
  { u8"Lingala",                                                    "lin",     "ln", "",    true,  false },
  { u8"Lingao",                                                     "onb",     "",   "",    false, false },
  { u8"Lingarak",                                                   "lgk",     "",   "",    false, false },
  { u8"Lingkhim",                                                   "lii",     "",   "",    false, true  },
  { u8"Lingua Franca Nova",                                         "lfn",     "",   "",    false, false },
  { u8"Lingua Franca",                                              "pml",     "",   "",    false, false },
  { u8"Lipan Apache",                                               "apl",     "",   "",    false, false },
  { u8"Lipo",                                                       "lpo",     "",   "",    false, false },
  { u8"Lisabata-Nuniali",                                           "lcs",     "",   "",    false, false },
  { u8"Lisela",                                                     "lcl",     "",   "",    false, false },
  { u8"Lish",                                                       "lsh",     "",   "",    false, false },
  { u8"Lishana Deni",                                               "lsd",     "",   "",    false, false },
  { u8"Lishanid Noshan",                                            "aij",     "",   "",    false, false },
  { u8"Lishán Didán",                                               "trg",     "",   "",    false, false },
  { u8"Lisu",                                                       "lis",     "",   "",    false, false },
  { u8"Literary Chinese",                                           "lzh",     "",   "",    false, false },
  { u8"Lithuanian Sign Language",                                   "lls",     "",   "",    false, false },
  { u8"Lithuanian",                                                 "lit",     "lt", "",    true,  false },
  { u8"Litzlitz",                                                   "lzl",     "",   "",    false, false },
  { u8"Liujiang Zhuang",                                            "zlj",     "",   "",    false, false },
  { u8"Liuqian Zhuang",                                             "zlq",     "",   "",    false, false },
  { u8"Liv",                                                        "liv",     "",   "",    false, false },
  { u8"Livvi",                                                      "olo",     "",   "",    false, false },
  { u8"Lo-Toga",                                                    "lht",     "",   "",    false, false },
  { u8"Loarki",                                                     "lrk",     "",   "",    false, false },
  { u8"Lobala",                                                     "loq",     "",   "",    false, false },
  { u8"Lobi",                                                       "lob",     "",   "",    false, false },
  { u8"Lodhi",                                                      "lbm",     "",   "",    false, false },
  { u8"Logba",                                                      "lgq",     "",   "",    false, false },
  { u8"Logir",                                                      "lqr",     "",   "",    false, false },
  { u8"Logo",                                                       "log",     "",   "",    false, false },
  { u8"Logol",                                                      "lof",     "",   "",    false, false },
  { u8"Logooli",                                                    "rag",     "",   "",    false, false },
  { u8"Logorik",                                                    "liu",     "",   "",    false, false },
  { u8"Logudorese Sardinian",                                       "src",     "",   "",    false, false },
  { u8"Lohorung",                                                   "lbr",     "",   "",    false, false },
  { u8"Loja Highland Quichua",                                      "qvj",     "",   "",    false, false },
  { u8"Lojban",                                                     "jbo",     "",   "",    true,  false },
  { u8"Lokaa",                                                      "yaz",     "",   "",    false, false },
  { u8"Loke",                                                       "loy",     "",   "",    false, false },
  { u8"Loko",                                                       "lok",     "",   "",    false, false },
  { u8"Lokoya",                                                     "lky",     "",   "",    false, false },
  { u8"Lola",                                                       "lcd",     "",   "",    false, false },
  { u8"Lolak",                                                      "llq",     "",   "",    false, false },
  { u8"Lole",                                                       "llg",     "",   "",    false, false },
  { u8"Lolo",                                                       "llb",     "",   "",    false, false },
  { u8"Loloda",                                                     "loa",     "",   "",    false, false },
  { u8"Lolopo",                                                     "ycl",     "",   "",    false, false },
  { u8"Loma (Côte d'Ivoire)",                                       "loi",     "",   "",    false, false },
  { u8"Loma (Liberia)",                                             "lom",     "",   "",    false, false },
  { u8"Lomaiviti",                                                  "lmv",     "",   "",    false, false },
  { u8"Lomavren",                                                   "rmi",     "",   "",    false, false },
  { u8"Lombard",                                                    "lmo",     "",   "",    false, false },
  { u8"Lombi",                                                      "lmi",     "",   "",    false, false },
  { u8"Lombo",                                                      "loo",     "",   "",    false, false },
  { u8"Lomwe",                                                      "ngl",     "",   "",    false, false },
  { u8"Loncong",                                                    "lce",     "",   "",    false, false },
  { u8"Long Phuri Naga",                                            "lpn",     "",   "",    false, false },
  { u8"Long Wat",                                                   "ttw",     "",   "",    false, false },
  { u8"Longgu",                                                     "lgu",     "",   "",    false, false },
  { u8"Longto",                                                     "wok",     "",   "",    false, false },
  { u8"Longuda",                                                    "lnu",     "",   "",    false, false },
  { u8"Loniu",                                                      "los",     "",   "",    false, false },
  { u8"Lonwolwol",                                                  "crc",     "",   "",    false, false },
  { u8"Lonzo",                                                      "lnz",     "",   "",    false, false },
  { u8"Loo",                                                        "ldo",     "",   "",    false, false },
  { u8"Lopa",                                                       "lop",     "",   "",    false, false },
  { u8"Lopi",                                                       "lov",     "",   "",    false, false },
  { u8"Lopit",                                                      "lpx",     "",   "",    false, false },
  { u8"Lorang",                                                     "lrn",     "",   "",    false, false },
  { u8"Lorediakarkar",                                              "lnn",     "",   "",    false, false },
  { u8"Loreto-Ucayali Spanish",                                     "spq",     "",   "",    false, false },
  { u8"Lote",                                                       "uvl",     "",   "",    false, false },
  { u8"Lotha Naga",                                                 "njh",     "",   "",    false, false },
  { u8"Lotud",                                                      "dtr",     "",   "",    false, false },
  { u8"Lou",                                                        "loj",     "",   "",    false, false },
  { u8"Louisiana Creole",                                           "lou",     "",   "",    false, false },
  { u8"Loun",                                                       "lox",     "",   "",    false, false },
  { u8"Loup A",                                                     "xlo",     "",   "",    false, false },
  { u8"Loup B",                                                     "xlb",     "",   "",    false, false },
  { u8"Low German",                                                 "nds",     "",   "",    true,  false },
  { u8"Lower Burdekin",                                             "xbb",     "",   "",    false, false },
  { u8"Lower Chehalis",                                             "cea",     "",   "",    false, false },
  { u8"Lower Grand Valley Dani",                                    "dni",     "",   "",    false, false },
  { u8"Lower Nossob",                                               "nsb",     "",   "",    false, false },
  { u8"Lower Silesian",                                             "sli",     "",   "",    false, false },
  { u8"Lower Sorbian",                                              "dsb",     "",   "",    true,  false },
  { u8"Lower Southern Aranda",                                      "axl",     "",   "",    false, false },
  { u8"Lower Ta'oih",                                               "tto",     "",   "",    false, false },
  { u8"Lower Tanana",                                               "taa",     "",   "",    false, false },
  { u8"Lowland Oaxaca Chontal",                                     "clo",     "",   "",    false, false },
  { u8"Lowland Tarahumara",                                         "tac",     "",   "",    false, false },
  { u8"Loxicha Zapotec",                                            "ztp",     "",   "",    false, false },
  { u8"Lozi",                                                       "loz",     "",   "",    true,  false },
  { u8"Lua'",                                                       "prb",     "",   "",    false, true  },
  { u8"Luang",                                                      "lex",     "",   "",    false, false },
  { u8"Luba-Katanga",                                               "lub",     "lu", "",    true,  false },
  { u8"Luba-Lulua",                                                 "lua",     "",   "",    true,  false },
  { u8"Lubila",                                                     "kcc",     "",   "",    false, false },
  { u8"Lubu",                                                       "lcf",     "",   "",    false, false },
  { u8"Lubuagan Kalinga",                                           "knb",     "",   "",    false, false },
  { u8"Luchazi",                                                    "lch",     "",   "",    false, false },
  { u8"Lucumi",                                                     "luq",     "",   "",    false, false },
  { u8"Ludian",                                                     "lud",     "",   "",    false, false },
  { u8"Lufu",                                                       "ldq",     "",   "",    false, false },
  { u8"Lugbara",                                                    "lgg",     "",   "",    false, false },
  { u8"Luguru",                                                     "ruf",     "",   "",    false, false },
  { u8"Luhu",                                                       "lcq",     "",   "",    false, false },
  { u8"Lui",                                                        "lba",     "",   "",    false, true  },
  { u8"Luimbi",                                                     "lum",     "",   "",    false, false },
  { u8"Luiseno",                                                    "lui",     "",   "",    true,  false },
  { u8"Lukpa",                                                      "dop",     "",   "",    false, false },
  { u8"Lule Sami",                                                  "smj",     "",   "",    true,  false },
  { u8"Lule",                                                       "ule",     "",   "",    false, false },
  { u8"Lumba-Yakkha",                                               "luu",     "",   "",    false, false },
  { u8"Lumbee",                                                     "lmz",     "",   "",    false, true  },
  { u8"Lumbu",                                                      "lup",     "",   "",    false, false },
  { u8"Lumun",                                                      "lmd",     "",   "",    false, false },
  { u8"Luna",                                                       "luj",     "",   "",    false, false },
  { u8"Lunanakha",                                                  "luk",     "",   "",    false, false },
  { u8"Lunda",                                                      "lun",     "",   "",    true,  false },
  { u8"Lundayeh",                                                   "lnd",     "",   "",    false, false },
  { u8"Lungalunga",                                                 "vmg",     "",   "",    false, false },
  { u8"Lungga",                                                     "lga",     "",   "",    false, false },
  { u8"Luo (Cameroon)",                                             "luw",     "",   "",    false, false },
  { u8"Luo (Kenya and Tanzania)",                                   "luo",     "",   "",    true,  false },
  { u8"Luopohe Hmong",                                              "hml",     "",   "",    false, false },
  { u8"Luri",                                                       "ldd",     "",   "",    false, false },
  { u8"Lusengo",                                                    "lse",     "",   "",    false, false },
  { u8"Lushai",                                                     "lus",     "",   "",    true,  false },
  { u8"Lushootseed",                                                "lut",     "",   "",    false, false },
  { u8"Lusi",                                                       "khl",     "",   "",    false, false },
  { u8"Lusitanian",                                                 "xls",     "",   "",    false, false },
  { u8"Lutos",                                                      "ndy",     "",   "",    false, false },
  { u8"Luvale",                                                     "lue",     "",   "",    false, false },
  { u8"Luwati",                                                     "luv",     "",   "",    false, false },
  { u8"Luwo",                                                       "lwo",     "",   "",    false, false },
  { u8"Luxembourgish",                                              "ltz",     "lb", "",    true,  false },
  { u8"Luyana",                                                     "lyn",     "",   "",    false, false },
  { u8"Luyia",                                                      "luy",     "",   "",    false, false },
  { u8"Lwalu",                                                      "lwa",     "",   "",    false, false },
  { u8"Lycian",                                                     "xlc",     "",   "",    false, false },
  { u8"Lydian",                                                     "xld",     "",   "",    false, false },
  { u8"Lyngngam",                                                   "lyg",     "",   "",    false, false },
  { u8"Lyons Sign Language",                                        "lsg",     "",   "",    false, true  },
  { u8"Lyélé",                                                      "lee",     "",   "",    false, false },
  { u8"Láadan",                                                     "ldn",     "",   "",    false, false },
  { u8"Láá Láá Bwamu",                                              "bwj",     "",   "",    false, false },
  { u8"Lü",                                                         "khb",     "",   "",    false, false },
  { u8"Ma (Democratic Republic of Congo)",                          "msj",     "",   "",    false, false },
  { u8"Ma (Papua New Guinea)",                                      "mjn",     "",   "",    false, false },
  { u8"Ma Manda",                                                   "skc",     "",   "",    false, false },
  { u8"Ma'anyan",                                                   "mhy",     "",   "",    false, false },
  { u8"Ma'di",                                                      "mhi",     "",   "",    false, false },
  { u8"Ma'ya",                                                      "slz",     "",   "",    false, false },
  { u8"Maa",                                                        "cma",     "",   "",    false, false },
  { u8"Maaka",                                                      "mew",     "",   "",    false, false },
  { u8"Maasina Fulfulde",                                           "ffm",     "",   "",    false, false },
  { u8"Maay",                                                       "ymm",     "",   "",    false, false },
  { u8"Maba (Chad)",                                                "mde",     "",   "",    false, false },
  { u8"Maba (Indonesia)",                                           "mqa",     "",   "",    false, false },
  { u8"Mabaale",                                                    "mmz",     "",   "",    false, false },
  { u8"Mabaan",                                                     "mfz",     "",   "",    false, false },
  { u8"Mabaka Valley Kalinga",                                      "kkg",     "",   "",    false, false },
  { u8"Mabire",                                                     "muj",     "",   "",    false, false },
  { u8"Maca",                                                       "mca",     "",   "",    false, false },
  { u8"Macaguaje",                                                  "mcl",     "",   "",    false, false },
  { u8"Macaguán",                                                   "mbn",     "",   "",    false, false },
  { u8"Macanese",                                                   "mzs",     "",   "",    false, false },
  { u8"Macedo-Romanian",                                            "rup",     "",   "",    true,  false },
  { u8"Macedonian",                                                 "mac",     "mk", "mkd", true,  false },
  { u8"Machame",                                                    "jmc",     "",   "",    false, false },
  { u8"Machiguenga",                                                "mcb",     "",   "",    false, false },
  { u8"Machinere",                                                  "mpd",     "",   "",    false, false },
  { u8"Machinga",                                                   "mvw",     "",   "",    false, false },
  { u8"Maco",                                                       "wpc",     "",   "",    false, false },
  { u8"Macuna",                                                     "myy",     "",   "",    false, false },
  { u8"Macushi",                                                    "mbc",     "",   "",    false, false },
  { u8"Mada (Cameroon)",                                            "mxu",     "",   "",    false, false },
  { u8"Mada (Nigeria)",                                             "mda",     "",   "",    false, false },
  { u8"Madagascar Sign Language",                                   "mzc",     "",   "",    false, false },
  { u8"Madak",                                                      "mmx",     "",   "",    false, false },
  { u8"Madhi Madhi",                                                "dmd",     "",   "",    false, false },
  { u8"Madi",                                                       "grg",     "",   "",    false, false },
  { u8"Madurese",                                                   "mad",     "",   "",    true,  false },
  { u8"Mae",                                                        "mme",     "",   "",    false, false },
  { u8"Maek",                                                       "hmk",     "",   "",    false, false },
  { u8"Maeng Itneg",                                                "itt",     "",   "",    false, false },
  { u8"Mafa",                                                       "maf",     "",   "",    false, false },
  { u8"Mafea",                                                      "mkv",     "",   "",    false, false },
  { u8"Mag-Indi Ayta",                                              "blx",     "",   "",    false, false },
  { u8"Mag-antsi Ayta",                                             "sgb",     "",   "",    false, false },
  { u8"Magahi",                                                     "mag",     "",   "",    true,  false },
  { u8"Magbukun Ayta",                                              "ayt",     "",   "",    false, false },
  { u8"Magdalena Peñasco Mixtec",                                   "xtm",     "",   "",    false, false },
  { u8"Magoma",                                                     "gmx",     "",   "",    false, false },
  { u8"Magori",                                                     "zgr",     "",   "",    false, false },
  { u8"Maguindanaon",                                               "mdh",     "",   "",    false, false },
  { u8"Magɨ (Madang Province)",                                     "gkd",     "",   "",    false, false },
  { u8"Magɨyi",                                                     "gmg",     "",   "",    false, false },
  { u8"Mahali",                                                     "mjx",     "",   "",    false, false },
  { u8"Mahasu Pahari",                                              "bfz",     "",   "",    false, false },
  { u8"Mahei",                                                      "mja",     "",   "",    false, true  },
  { u8"Mahican",                                                    "mjy",     "",   "",    false, false },
  { u8"Mahongwe",                                                   "mhb",     "",   "",    false, false },
  { u8"Mahou",                                                      "mxx",     "",   "",    false, false },
  { u8"Mai Brat",                                                   "ayz",     "",   "",    false, false },
  { u8"Maia",                                                       "sks",     "",   "",    false, false },
  { u8"Maiadomu",                                                   "mzz",     "",   "",    false, false },
  { u8"Maiani",                                                     "tnh",     "",   "",    false, false },
  { u8"Maii",                                                       "mmm",     "",   "",    false, false },
  { u8"Mailu",                                                      "mgu",     "",   "",    false, false },
  { u8"Maindo",                                                     "cwb",     "",   "",    false, false },
  { u8"Mainfränkisch",                                              "vmf",     "",   "",    false, false },
  { u8"Mainstream Kenyah",                                          "xkl",     "",   "",    false, false },
  { u8"Mairasi",                                                    "zrs",     "",   "",    false, false },
  { u8"Maisin",                                                     "mbq",     "",   "",    false, false },
  { u8"Maithili",                                                   "mai",     "",   "",    true,  false },
  { u8"Maiwa (Indonesia)",                                          "wmm",     "",   "",    false, false },
  { u8"Maiwa (Papua New Guinea)",                                   "mti",     "",   "",    false, false },
  { u8"Maiwala",                                                    "mum",     "",   "",    false, false },
  { u8"Majang",                                                     "mpe",     "",   "",    false, false },
  { u8"Majera",                                                     "xmj",     "",   "",    false, false },
  { u8"Majhi",                                                      "mjz",     "",   "",    false, false },
  { u8"Majhwar",                                                    "mmj",     "",   "",    false, false },
  { u8"Majukayang Kalinga",                                         "kmd",     "",   "",    false, false },
  { u8"Mak (China)",                                                "mkg",     "",   "",    false, false },
  { u8"Mak (Nigeria)",                                              "pbl",     "",   "",    false, false },
  { u8"Makaa",                                                      "mcp",     "",   "",    false, false },
  { u8"Makah",                                                      "myh",     "",   "",    false, false },
  { u8"Makalero",                                                   "mjb",     "",   "",    false, false },
  { u8"Makasae",                                                    "mkz",     "",   "",    false, false },
  { u8"Makasar",                                                    "mak",     "",   "",    true,  false },
  { u8"Makassar Malay",                                             "mfp",     "",   "",    false, false },
  { u8"Makayam",                                                    "aup",     "",   "",    false, false },
  { u8"Makhuwa",                                                    "vmw",     "",   "",    false, false },
  { u8"Makhuwa-Marrevone",                                          "xmc",     "",   "",    false, false },
  { u8"Makhuwa-Meetto",                                             "mgh",     "",   "",    false, false },
  { u8"Makhuwa-Moniga",                                             "mhm",     "",   "",    false, false },
  { u8"Makhuwa-Saka",                                               "xsq",     "",   "",    false, false },
  { u8"Makhuwa-Shirima",                                            "vmk",     "",   "",    false, false },
  { u8"Maklew",                                                     "mgf",     "",   "",    false, false },
  { u8"Makolkol",                                                   "zmh",     "",   "",    false, false },
  { u8"Makonde",                                                    "kde",     "",   "",    false, false },
  { u8"Maku'a",                                                     "lva",     "",   "",    false, false },
  { u8"Makuri Naga",                                                "jmn",     "",   "",    false, false },
  { u8"Makuráp",                                                    "mpu",     "",   "",    false, false },
  { u8"Makwe",                                                      "ymk",     "",   "",    false, false },
  { u8"Makyan Naga",                                                "umn",     "",   "",    false, false },
  { u8"Mal Paharia",                                                "mkb",     "",   "",    false, false },
  { u8"Mal",                                                        "mlf",     "",   "",    false, false },
  { u8"Mala (Nigeria)",                                             "ruy",     "",   "",    false, false },
  { u8"Mala (Papua New Guinea)",                                    "ped",     "",   "",    false, false },
  { u8"Mala Malasar",                                               "ima",     "",   "",    false, false },
  { u8"Malaccan Creole Malay",                                      "ccm",     "",   "",    false, false },
  { u8"Malaccan Creole Portuguese",                                 "mcm",     "",   "",    false, false },
  { u8"Malagasy",                                                   "mlg",     "mg", "",    true,  false },
  { u8"Malak Malak",                                                "mpb",     "",   "",    false, false },
  { u8"Malakhel",                                                   "mld",     "",   "",    false, true  },
  { u8"Malalamai",                                                  "mmt",     "",   "",    false, false },
  { u8"Malango",                                                    "mln",     "",   "",    false, false },
  { u8"Malankuravan",                                               "mjo",     "",   "",    false, false },
  { u8"Malapandaram",                                               "mjp",     "",   "",    false, false },
  { u8"Malaryan",                                                   "mjq",     "",   "",    false, false },
  { u8"Malas",                                                      "mkr",     "",   "",    false, false },
  { u8"Malasar",                                                    "ymr",     "",   "",    false, false },
  { u8"Malavedan",                                                  "mjr",     "",   "",    false, false },
  { u8"Malawi Lomwe",                                               "lon",     "",   "",    false, false },
  { u8"Malawi Sena",                                                "swk",     "",   "",    false, false },
  { u8"Malawian Sign Language",                                     "lws",     "",   "",    false, false },
  { u8"Malay (individual language)",                                "zlm",     "",   "",    false, false },
  { u8"Malay (macrolanguage)",                                      "may",     "ms", "msa", true,  false },
  { u8"Malayalam",                                                  "mal",     "ml", "",    true,  false },
  { u8"Malayic Dayak",                                              "xdy",     "",   "",    false, false },
  { u8"Malaynon",                                                   "mlz",     "",   "",    false, false },
  { u8"Malayo",                                                     "mbp",     "",   "",    false, false },
  { u8"Malayo-Polynesian languages",                                "poz",     "",   "",    false, false },
  { u8"Malaysian Sign Language",                                    "xml",     "",   "",    false, false },
  { u8"Malba Birifor",                                              "bfo",     "",   "",    false, false },
  { u8"Male (Ethiopia)",                                            "mdy",     "",   "",    false, false },
  { u8"Male (Papua New Guinea)",                                    "mdc",     "",   "",    false, false },
  { u8"Malecite-Passamaquoddy",                                     "pqm",     "",   "",    false, false },
  { u8"Maleng",                                                     "pkt",     "",   "",    false, false },
  { u8"Maleu-Kilenge",                                              "mgl",     "",   "",    false, false },
  { u8"Malfaxal",                                                   "mlx",     "",   "",    false, false },
  { u8"Malgana",                                                    "vml",     "",   "",    false, false },
  { u8"Malgbe",                                                     "mxf",     "",   "",    false, false },
  { u8"Mali",                                                       "gcc",     "",   "",    false, false },
  { u8"Maligo",                                                     "mwj",     "",   "",    false, true  },
  { u8"Malila",                                                     "mgq",     "",   "",    false, false },
  { u8"Malimba",                                                    "mzd",     "",   "",    false, false },
  { u8"Malimpung",                                                  "mli",     "",   "",    false, false },
  { u8"Malinaltepec Me'phaa",                                       "tcf",     "",   "",    false, false },
  { u8"Malo",                                                       "mla",     "",   "",    false, false },
  { u8"Malol",                                                      "mbk",     "",   "",    false, false },
  { u8"Maltese Sign Language",                                      "mdl",     "",   "",    false, false },
  { u8"Maltese",                                                    "mlt",     "mt", "",    true,  false },
  { u8"Malua Bay",                                                  "mll",     "",   "",    false, false },
  { u8"Malvi",                                                      "mup",     "",   "",    false, false },
  { u8"Malyangapa",                                                 "yga",     "",   "",    false, false },
  { u8"Maléku Jaíka",                                               "gut",     "",   "",    false, false },
  { u8"Mam",                                                        "mam",     "",   "",    false, false },
  { u8"Mama",                                                       "mma",     "",   "",    false, false },
  { u8"Mamaa",                                                      "mhf",     "",   "",    false, false },
  { u8"Mamaindé",                                                   "wmd",     "",   "",    false, false },
  { u8"Mamanwa",                                                    "mmn",     "",   "",    false, false },
  { u8"Mamara Senoufo",                                             "myk",     "",   "",    false, false },
  { u8"Mamasa",                                                     "mqj",     "",   "",    false, false },
  { u8"Mambae",                                                     "mgm",     "",   "",    false, false },
  { u8"Mambai",                                                     "mcs",     "",   "",    false, false },
  { u8"Mamboru",                                                    "mvd",     "",   "",    false, false },
  { u8"Mambwe-Lungu",                                               "mgr",     "",   "",    false, false },
  { u8"Mampruli",                                                   "maw",     "",   "",    false, false },
  { u8"Mamuju",                                                     "mqx",     "",   "",    false, false },
  { u8"Mamulique",                                                  "emm",     "",   "",    false, false },
  { u8"Mamusi",                                                     "kdf",     "",   "",    false, false },
  { u8"Mamvu",                                                      "mdi",     "",   "",    false, false },
  { u8"Man Met",                                                    "mml",     "",   "",    false, false },
  { u8"Manado Malay",                                               "xmm",     "",   "",    false, false },
  { u8"Manam",                                                      "mva",     "",   "",    false, false },
  { u8"Manambu",                                                    "mle",     "",   "",    false, false },
  { u8"Manangba",                                                   "nmm",     "",   "",    false, false },
  { u8"Manangkari",                                                 "znk",     "",   "",    false, false },
  { u8"Manchu",                                                     "mnc",     "",   "",    true,  false },
  { u8"Manda (Australia)",                                          "zma",     "",   "",    false, false },
  { u8"Manda (India)",                                              "mha",     "",   "",    false, false },
  { u8"Manda (Tanzania)",                                           "mgs",     "",   "",    false, false },
  { u8"Mandahuaca",                                                 "mht",     "",   "",    false, false },
  { u8"Mandaic",                                                    "mid",     "",   "",    false, false },
  { u8"Mandan",                                                     "mhq",     "",   "",    false, false },
  { u8"Mandandanyi",                                                "zmk",     "",   "",    false, false },
  { u8"Mandar",                                                     "mdr",     "",   "",    true,  false },
  { u8"Mandara",                                                    "tbf",     "",   "",    false, false },
  { u8"Mandari",                                                    "mqu",     "",   "",    false, false },
  { u8"Mandarin Chinese",                                           "cmn",     "",   "",    false, false },
  { u8"Mandaya",                                                    "mry",     "",   "",    false, false },
  { u8"Mande languages",                                            "dmn",     "",   "",    false, false },
  { u8"Mandeali",                                                   "mjl",     "",   "",    false, false },
  { u8"Mander",                                                     "mqr",     "",   "",    false, false },
  { u8"Mandingo",                                                   "man",     "",   "",    true,  false },
  { u8"Mandinka",                                                   "mnk",     "",   "",    false, false },
  { u8"Mandjak",                                                    "mfv",     "",   "",    false, false },
  { u8"Mandobo Atas",                                               "aax",     "",   "",    false, false },
  { u8"Mandobo Bawah",                                              "bwp",     "",   "",    false, false },
  { u8"Manem",                                                      "jet",     "",   "",    false, false },
  { u8"Mang",                                                       "zng",     "",   "",    false, false },
  { u8"Manga Kanuri",                                               "kby",     "",   "",    false, false },
  { u8"Mangala",                                                    "mem",     "",   "",    false, false },
  { u8"Mangareva",                                                  "mrv",     "",   "",    false, false },
  { u8"Mangarrayi",                                                 "mpc",     "",   "",    false, false },
  { u8"Mangas",                                                     "zns",     "",   "",    false, false },
  { u8"Mangayat",                                                   "myj",     "",   "",    false, false },
  { u8"Mangbetu",                                                   "mdj",     "",   "",    false, false },
  { u8"Mangbutu",                                                   "mdk",     "",   "",    false, false },
  { u8"Mangerr",                                                    "zme",     "",   "",    false, false },
  { u8"Mangetti Dune ǃXung",                                        "gfx",     "",   "",    false, true  },
  { u8"Mangga Buang",                                               "mmo",     "",   "",    false, false },
  { u8"Manggarai",                                                  "mqy",     "",   "",    false, false },
  { u8"Mango",                                                      "mge",     "",   "",    false, false },
  { u8"Mangole",                                                    "mqc",     "",   "",    false, false },
  { u8"Mangseng",                                                   "mbh",     "",   "",    false, false },
  { u8"Mangue",                                                     "mom",     "",   "",    false, false },
  { u8"Manichaean Middle Persian",                                  "xmn",     "",   "",    false, false },
  { u8"Manide",                                                     "abd",     "",   "",    false, false },
  { u8"Manikion",                                                   "mnx",     "",   "",    false, false },
  { u8"Manipa",                                                     "mqp",     "",   "",    false, false },
  { u8"Manipuri",                                                   "mni",     "",   "",    true,  false },
  { u8"Mankanya",                                                   "knf",     "",   "",    false, false },
  { u8"Mankiyali",                                                  "nlm",     "",   "",    false, false },
  { u8"Manna-Dora",                                                 "mju",     "",   "",    false, false },
  { u8"Mannan",                                                     "mjv",     "",   "",    false, false },
  { u8"Mano",                                                       "mev",     "",   "",    false, false },
  { u8"Manobo languages",                                           "mno",     "",   "",    true,  false },
  { u8"Manombai",                                                   "woo",     "",   "",    false, false },
  { u8"Mansaka",                                                    "msk",     "",   "",    false, false },
  { u8"Mansi",                                                      "mns",     "",   "",    false, false },
  { u8"Mansoanka",                                                  "msw",     "",   "",    false, false },
  { u8"Manta",                                                      "myg",     "",   "",    false, false },
  { u8"Mantsi",                                                     "nty",     "",   "",    false, false },
  { u8"Manumanaw Karen",                                            "kxf",     "",   "",    false, false },
  { u8"Manx",                                                       "glv",     "gv", "",    true,  false },
  { u8"Manya",                                                      "mzj",     "",   "",    false, false },
  { u8"Manyawa",                                                    "mny",     "",   "",    false, false },
  { u8"Manyika",                                                    "mxc",     "",   "",    false, false },
  { u8"Manza",                                                      "mzv",     "",   "",    false, false },
  { u8"Mao Naga",                                                   "nbi",     "",   "",    false, false },
  { u8"Maonan",                                                     "mmd",     "",   "",    false, false },
  { u8"Maore Comorian",                                             "swb",     "",   "",    false, false },
  { u8"Maori",                                                      "mao",     "mi", "mri", true,  false },
  { u8"Mape",                                                       "mlh",     "",   "",    false, false },
  { u8"Mapena",                                                     "mnm",     "",   "",    false, false },
  { u8"Mapia",                                                      "mpy",     "",   "",    false, false },
  { u8"Mapidian",                                                   "mpw",     "",   "",    false, false },
  { u8"Mapos Buang",                                                "bzh",     "",   "",    false, false },
  { u8"Mapoyo",                                                     "mcg",     "",   "",    false, false },
  { u8"Mapudungun",                                                 "arn",     "",   "",    true,  false },
  { u8"Mapun",                                                      "sjm",     "",   "",    false, false },
  { u8"Maquiritari",                                                "mch",     "",   "",    false, false },
  { u8"Mara Chin",                                                  "mrh",     "",   "",    false, false },
  { u8"Marachi",                                                    "lri",     "",   "",    false, false },
  { u8"Maraghei",                                                   "vmh",     "",   "",    false, false },
  { u8"Maragus",                                                    "mrs",     "",   "",    false, false },
  { u8"Maram Naga",                                                 "nma",     "",   "",    false, false },
  { u8"Marama",                                                     "lrm",     "",   "",    false, false },
  { u8"Maramba",                                                    "myd",     "",   "",    false, true  },
  { u8"Maranao",                                                    "mrw",     "",   "",    false, false },
  { u8"Maranunggu",                                                 "zmr",     "",   "",    false, false },
  { u8"Mararit",                                                    "mgb",     "",   "",    false, false },
  { u8"Marathi",                                                    "mar",     "mr", "",    true,  false },
  { u8"Marau",                                                      "mvr",     "",   "",    false, false },
  { u8"Marba",                                                      "mpg",     "",   "",    false, false },
  { u8"Mardin Sign Language",                                       "dsz",     "",   "",    false, false },
  { u8"Maremgi",                                                    "mrx",     "",   "",    false, false },
  { u8"Marenje",                                                    "vmr",     "",   "",    false, false },
  { u8"Marfa",                                                      "mvu",     "",   "",    false, false },
  { u8"Margany",                                                    "zmc",     "",   "",    false, false },
  { u8"Marghi Central",                                             "mrt",     "",   "",    false, false },
  { u8"Marghi South",                                               "mfm",     "",   "",    false, false },
  { u8"Margos-Yarowilca-Lauricocha Quechua",                        "qvm",     "",   "",    false, false },
  { u8"Margu",                                                      "mhg",     "",   "",    false, false },
  { u8"Mari (East Sepik Province)",                                 "mbx",     "",   "",    false, false },
  { u8"Mari (Madang Province)",                                     "hob",     "",   "",    false, false },
  { u8"Mari (Russia)",                                              "chm",     "",   "",    true,  false },
  { u8"Maria (India)",                                              "mrr",     "",   "",    false, false },
  { u8"Maria (Papua New Guinea)",                                   "mds",     "",   "",    false, false },
  { u8"Maricopa",                                                   "mrc",     "",   "",    false, false },
  { u8"Maridan",                                                    "zmd",     "",   "",    false, false },
  { u8"Maridjabin",                                                 "zmj",     "",   "",    false, false },
  { u8"Marik",                                                      "dad",     "",   "",    false, false },
  { u8"Marimanindji",                                               "zmm",     "",   "",    false, false },
  { u8"Marind",                                                     "mrz",     "",   "",    false, false },
  { u8"Maring Naga",                                                "nng",     "",   "",    false, false },
  { u8"Maring",                                                     "mbw",     "",   "",    false, false },
  { u8"Maringarr",                                                  "zmt",     "",   "",    false, false },
  { u8"Marino",                                                     "mrb",     "",   "",    false, false },
  { u8"Mariri",                                                     "mqi",     "",   "",    false, false },
  { u8"Maritime Sign Language",                                     "nsr",     "",   "",    false, false },
  { u8"Maritsauá",                                                  "msp",     "",   "",    false, false },
  { u8"Mariyedi",                                                   "zmy",     "",   "",    false, false },
  { u8"Marka",                                                      "rkm",     "",   "",    false, false },
  { u8"Markweeta",                                                  "enb",     "",   "",    false, false },
  { u8"Marma",                                                      "rmz",     "",   "",    false, false },
  { u8"Marovo",                                                     "mvo",     "",   "",    false, false },
  { u8"Marra",                                                      "mec",     "",   "",    false, false },
  { u8"Marriammu",                                                  "xru",     "",   "",    false, false },
  { u8"Marrithiyel",                                                "mfr",     "",   "",    false, false },
  { u8"Marrucinian",                                                "umc",     "",   "",    false, false },
  { u8"Marshallese",                                                "mah",     "mh", "",    true,  false },
  { u8"Marsian",                                                    "ims",     "",   "",    false, false },
  { u8"Martha's Vineyard Sign Language",                            "mre",     "",   "",    false, false },
  { u8"Marti Ke",                                                   "zmg",     "",   "",    false, false },
  { u8"Martu Wangka",                                               "mpj",     "",   "",    false, false },
  { u8"Martuyhunira",                                               "vma",     "",   "",    false, false },
  { u8"Maru",                                                       "mhx",     "",   "",    false, false },
  { u8"Marwari (India)",                                            "rwr",     "",   "",    false, false },
  { u8"Marwari (Pakistan)",                                         "mve",     "",   "",    false, false },
  { u8"Marwari",                                                    "mwr",     "",   "",    true,  false },
  { u8"Marúbo",                                                     "mzr",     "",   "",    false, false },
  { u8"Masaaba",                                                    "myx",     "",   "",    false, false },
  { u8"Masadiit Itneg",                                             "tis",     "",   "",    false, false },
  { u8"Masai",                                                      "mas",     "",   "",    true,  false },
  { u8"Masalit",                                                    "mls",     "",   "",    false, false },
  { u8"Masana",                                                     "mcn",     "",   "",    false, false },
  { u8"Masbatenyo",                                                 "msb",     "",   "",    false, false },
  { u8"Mashco Piro",                                                "cuj",     "",   "",    false, false },
  { u8"Mashi (Nigeria)",                                            "jms",     "",   "",    false, false },
  { u8"Mashi (Zambia)",                                             "mho",     "",   "",    false, false },
  { u8"Masikoro Malagasy",                                          "msh",     "",   "",    false, false },
  { u8"Masimasi",                                                   "ism",     "",   "",    false, false },
  { u8"Masiwang",                                                   "bnf",     "",   "",    false, false },
  { u8"Maskelynes",                                                 "klv",     "",   "",    false, false },
  { u8"Maskoy Pidgin",                                              "mhh",     "",   "",    false, true  },
  { u8"Maslam",                                                     "msv",     "",   "",    false, false },
  { u8"Masmaje",                                                    "mes",     "",   "",    false, false },
  { u8"Massalat",                                                   "mdg",     "",   "",    false, false },
  { u8"Massep",                                                     "mvs",     "",   "",    false, false },
  { u8"Matagalpa",                                                  "mtn",     "",   "",    false, false },
  { u8"Matal",                                                      "mfh",     "",   "",    false, false },
  { u8"Matbat",                                                     "xmt",     "",   "",    false, false },
  { u8"Matengo",                                                    "mgv",     "",   "",    false, false },
  { u8"Matepi",                                                     "mqe",     "",   "",    false, false },
  { u8"Matigsalug Manobo",                                          "mbt",     "",   "",    false, false },
  { u8"Matipuhy",                                                   "mzo",     "",   "",    false, false },
  { u8"Matngala",                                                   "zml",     "",   "",    false, false },
  { u8"Mato Grosso Arára",                                          "axg",     "",   "",    false, false },
  { u8"Mato",                                                       "met",     "",   "",    false, false },
  { u8"Mator",                                                      "mtm",     "",   "",    false, false },
  { u8"Mator-Taygi-Karagas",                                        "ymt",     "",   "",    false, true  },
  { u8"Matsés",                                                     "mcf",     "",   "",    false, false },
  { u8"Mattole",                                                    "mvb",     "",   "",    false, false },
  { u8"Matu Chin",                                                  "hlt",     "",   "",    false, false },
  { u8"Matukar",                                                    "mjk",     "",   "",    false, false },
  { u8"Matumbi",                                                    "mgw",     "",   "",    false, false },
  { u8"Matya Samo",                                                 "stj",     "",   "",    false, false },
  { u8"Matís",                                                      "mpq",     "",   "",    false, false },
  { u8"Maung",                                                      "mph",     "",   "",    false, false },
  { u8"Mauritian Sign Language",                                    "lsy",     "",   "",    false, false },
  { u8"Mauwake",                                                    "mhl",     "",   "",    false, false },
  { u8"Mawa (Chad)",                                                "mcw",     "",   "",    false, false },
  { u8"Mawa (Nigeria)",                                             "wma",     "",   "",    false, false },
  { u8"Mawak",                                                      "mjj",     "",   "",    false, false },
  { u8"Mawan",                                                      "mcz",     "",   "",    false, false },
  { u8"Mawayana",                                                   "mzx",     "",   "",    false, false },
  { u8"Mawchi",                                                     "mke",     "",   "",    false, false },
  { u8"Mawes",                                                      "mgk",     "",   "",    false, false },
  { u8"Maxakalí",                                                   "mbl",     "",   "",    false, false },
  { u8"Maxi Gbe",                                                   "mxl",     "",   "",    false, false },
  { u8"Maya Samo",                                                  "sym",     "",   "",    false, false },
  { u8"Mayaguduna",                                                 "xmy",     "",   "",    false, false },
  { u8"Mayan languages",                                            "myn",     "",   "",    true,  false },
  { u8"Mayangna",                                                   "yan",     "",   "",    false, false },
  { u8"Mayawali",                                                   "yxa",     "",   "",    false, false },
  { u8"Mayeka",                                                     "myc",     "",   "",    false, false },
  { u8"Mayi-Kulan",                                                 "xyk",     "",   "",    false, false },
  { u8"Mayi-Thakurti",                                              "xyt",     "",   "",    false, false },
  { u8"Mayi-Yapi",                                                  "xyj",     "",   "",    false, false },
  { u8"Maykulan",                                                   "mnt",     "",   "",    false, true  },
  { u8"Mayo",                                                       "mfy",     "",   "",    false, false },
  { u8"Mayogo",                                                     "mdm",     "",   "",    false, false },
  { u8"Mayoyao Ifugao",                                             "ifu",     "",   "",    false, false },
  { u8"Mazagway",                                                   "dkx",     "",   "",    false, false },
  { u8"Mazaltepec Zapotec",                                         "zpy",     "",   "",    false, false },
  { u8"Mazanderani",                                                "mzn",     "",   "",    false, false },
  { u8"Mazatlán Mazatec",                                           "vmz",     "",   "",    false, false },
  { u8"Mazatlán Mixe",                                              "mzl",     "",   "",    false, false },
  { u8"Mba",                                                        "mfc",     "",   "",    false, false },
  { u8"Mbala",                                                      "mdp",     "",   "",    false, false },
  { u8"Mbalanhu",                                                   "lnb",     "",   "",    false, false },
  { u8"Mbandja",                                                    "zmz",     "",   "",    false, false },
  { u8"Mbangala",                                                   "mxg",     "",   "",    false, false },
  { u8"Mbangi",                                                     "mgn",     "",   "",    false, false },
  { u8"Mbangwe",                                                    "zmn",     "",   "",    false, false },
  { u8"Mbara (Australia)",                                          "mvl",     "",   "",    false, false },
  { u8"Mbara (Chad)",                                               "mpk",     "",   "",    false, false },
  { u8"Mbariman-Gudhinma",                                          "zmv",     "",   "",    false, false },
  { u8"Mbati",                                                      "mdn",     "",   "",    false, false },
  { u8"Mbato",                                                      "gwa",     "",   "",    false, false },
  { u8"Mbay",                                                       "myb",     "",   "",    false, false },
  { u8"Mbe",                                                        "mfo",     "",   "",    false, false },
  { u8"Mbe'",                                                       "mtk",     "",   "",    false, false },
  { u8"Mbelime",                                                    "mql",     "",   "",    false, false },
  { u8"Mbere",                                                      "mdt",     "",   "",    false, false },
  { u8"Mbesa",                                                      "zms",     "",   "",    false, false },
  { u8"Mbessa",                                                     "emz",     "",   "",    false, false },
  { u8"Mbo (Cameroon)",                                             "mbo",     "",   "",    false, false },
  { u8"Mbo (Democratic Republic of Congo)",                         "zmw",     "",   "",    false, false },
  { u8"Mboi",                                                       "moi",     "",   "",    false, false },
  { u8"Mboko",                                                      "mdu",     "",   "",    false, false },
  { u8"Mbole",                                                      "mdq",     "",   "",    false, false },
  { u8"Mbonga",                                                     "xmb",     "",   "",    false, false },
  { u8"Mbongno",                                                    "bgu",     "",   "",    false, false },
  { u8"Mbosi",                                                      "mdw",     "",   "",    false, false },
  { u8"Mbowe",                                                      "mxo",     "",   "",    false, false },
  { u8"Mbre",                                                       "mka",     "",   "",    false, false },
  { u8"Mbudum",                                                     "xmd",     "",   "",    false, false },
  { u8"Mbugu",                                                      "mhd",     "",   "",    false, false },
  { u8"Mbugwe",                                                     "mgz",     "",   "",    false, false },
  { u8"Mbuk",                                                       "bpc",     "",   "",    false, false },
  { u8"Mbuko",                                                      "mqb",     "",   "",    false, false },
  { u8"Mbukushu",                                                   "mhw",     "",   "",    false, false },
  { u8"Mbula",                                                      "mna",     "",   "",    false, false },
  { u8"Mbula-Bwazza",                                               "mbu",     "",   "",    false, false },
  { u8"Mbule",                                                      "mlb",     "",   "",    false, false },
  { u8"Mbulungish",                                                 "mbv",     "",   "",    false, false },
  { u8"Mbum",                                                       "mdd",     "",   "",    false, false },
  { u8"Mbunda",                                                     "mck",     "",   "",    false, false },
  { u8"Mbunga",                                                     "mgy",     "",   "",    false, false },
  { u8"Mburku",                                                     "bbt",     "",   "",    false, false },
  { u8"Mbwela",                                                     "mfu",     "",   "",    false, false },
  { u8"Mbyá Guaraní",                                               "gun",     "",   "",    false, false },
  { u8"Me'en",                                                      "mym",     "",   "",    false, false },
  { u8"Mea",                                                        "meg",     "",   "",    false, true  },
  { u8"Medebur",                                                    "mjm",     "",   "",    false, false },
  { u8"Medefaidrin",                                                "dmf",     "",   "",    false, false },
  { u8"Media Lengua",                                               "mue",     "",   "",    false, false },
  { u8"Mediak",                                                     "mwx",     "",   "",    false, true  },
  { u8"Median",                                                     "xme",     "",   "",    false, false },
  { u8"Mednyj Aleut",                                               "mud",     "",   "",    false, false },
  { u8"Medumba",                                                    "byv",     "",   "",    false, false },
  { u8"Mefele",                                                     "mfj",     "",   "",    false, false },
  { u8"Megam",                                                      "mef",     "",   "",    false, false },
  { u8"Megleno Romanian",                                           "ruq",     "",   "",    false, false },
  { u8"Mehek",                                                      "nux",     "",   "",    false, false },
  { u8"Mehináku",                                                   "mmh",     "",   "",    false, false },
  { u8"Mehri",                                                      "gdq",     "",   "",    false, false },
  { u8"Mekeo",                                                      "mek",     "",   "",    false, false },
  { u8"Mekmek",                                                     "mvk",     "",   "",    false, false },
  { u8"Mekwei",                                                     "msf",     "",   "",    false, false },
  { u8"Mel-Khaonh",                                                 "hkn",     "",   "",    false, false },
  { u8"Mele-Fila",                                                  "mxe",     "",   "",    false, false },
  { u8"Melo",                                                       "mfx",     "",   "",    false, false },
  { u8"Melpa",                                                      "med",     "",   "",    false, false },
  { u8"Memoni",                                                     "mby",     "",   "",    false, false },
  { u8"Mendalam Kayan",                                             "xkd",     "",   "",    false, false },
  { u8"Mendankwe-Nkwen",                                            "mfd",     "",   "",    false, false },
  { u8"Mende (Papua New Guinea)",                                   "sim",     "",   "",    false, false },
  { u8"Mende (Sierra Leone)",                                       "men",     "",   "",    true,  false },
  { u8"Mengaka",                                                    "xmg",     "",   "",    false, false },
  { u8"Mengen",                                                     "mee",     "",   "",    false, false },
  { u8"Mengisa",                                                    "mct",     "",   "",    false, false },
  { u8"Menka",                                                      "mea",     "",   "",    false, false },
  { u8"Menominee",                                                  "mez",     "",   "",    false, false },
  { u8"Mentawai",                                                   "mwv",     "",   "",    false, false },
  { u8"Menya",                                                      "mcr",     "",   "",    false, false },
  { u8"Meoswar",                                                    "mvx",     "",   "",    false, false },
  { u8"Mer",                                                        "mnu",     "",   "",    false, false },
  { u8"Meramera",                                                   "mxm",     "",   "",    false, false },
  { u8"Merei",                                                      "lmb",     "",   "",    false, false },
  { u8"Merey",                                                      "meq",     "",   "",    false, false },
  { u8"Meriam Mir",                                                 "ulk",     "",   "",    false, false },
  { u8"Merlav",                                                     "mrm",     "",   "",    false, false },
  { u8"Meroitic",                                                   "xmr",     "",   "",    false, false },
  { u8"Meru",                                                       "mer",     "",   "",    false, false },
  { u8"Merwari",                                                    "wry",     "",   "",    false, false },
  { u8"Mesaka",                                                     "iyo",     "",   "",    false, false },
  { u8"Mescalero-Chiricahua Apache",                                "apm",     "",   "",    false, false },
  { u8"Mese",                                                       "mci",     "",   "",    false, false },
  { u8"Meskwaki",                                                   "sac",     "",   "",    false, false },
  { u8"Mesme",                                                      "zim",     "",   "",    false, false },
  { u8"Mesmes",                                                     "mys",     "",   "",    false, false },
  { u8"Mesopotamian Arabic",                                        "acm",     "",   "",    false, false },
  { u8"Mesqan",                                                     "mvz",     "",   "",    false, false },
  { u8"Messapic",                                                   "cms",     "",   "",    false, false },
  { u8"Meta'",                                                      "mgo",     "",   "",    false, false },
  { u8"Metlatónoc Mixtec",                                          "mxv",     "",   "",    false, false },
  { u8"Mewari",                                                     "mtr",     "",   "",    false, false },
  { u8"Mewati",                                                     "wtm",     "",   "",    false, false },
  { u8"Mexican Sign Language",                                      "mfs",     "",   "",    false, false },
  { u8"Meyah",                                                      "mej",     "",   "",    false, false },
  { u8"Mezontla Popoloca",                                          "pbe",     "",   "",    false, false },
  { u8"Mezquital Otomi",                                            "ote",     "",   "",    false, false },
  { u8"Mfinu",                                                      "zmf",     "",   "",    false, false },
  { u8"Mfumte",                                                     "nfu",     "",   "",    false, false },
  { u8"Mgbolizhia",                                                 "gmz",     "",   "",    false, false },
  { u8"Mi'kmaq",                                                    "mic",     "",   "",    true,  false },
  { u8"Miahuatlán Zapotec",                                         "zam",     "",   "",    false, false },
  { u8"Miami",                                                      "mia",     "",   "",    false, false },
  { u8"Mian",                                                       "mpt",     "",   "",    false, false },
  { u8"Miani",                                                      "pla",     "",   "",    false, false },
  { u8"Michif",                                                     "crg",     "",   "",    false, false },
  { u8"Michigamea",                                                 "cmm",     "",   "",    false, false },
  { u8"Michoacán Mazahua",                                          "mmc",     "",   "",    false, false },
  { u8"Michoacán Nahuatl",                                          "ncl",     "",   "",    false, false },
  { u8"Mid Grand Valley Dani",                                      "dnt",     "",   "",    false, false },
  { u8"Mid-Southern Banda",                                         "bjo",     "",   "",    false, false },
  { u8"Middle Armenian",                                            "axm",     "",   "",    false, false },
  { u8"Middle Breton",                                              "xbm",     "",   "",    false, false },
  { u8"Middle Cornish",                                             "cnx",     "",   "",    false, false },
  { u8"Middle Dutch (ca. 1050-1350)",                               "dum",     "",   "",    true,  false },
  { u8"Middle English (1100-1500)",                                 "enm",     "",   "",    true,  false },
  { u8"Middle French (ca. 1400-1600)",                              "frm",     "",   "",    true,  false },
  { u8"Middle High German (ca. 1050-1500)",                         "gmh",     "",   "",    true,  false },
  { u8"Middle Hittite",                                             "htx",     "",   "",    false, false },
  { u8"Middle Irish (900-1200)",                                    "mga",     "",   "",    true,  false },
  { u8"Middle Khmer (1400 to 1850 CE)",                             "xhm",     "",   "",    false, false },
  { u8"Middle Korean (10th-16th cent.)",                            "okm",     "",   "",    false, false },
  { u8"Middle Low German",                                          "gml",     "",   "",    false, false },
  { u8"Middle Mongolian",                                           "xng",     "",   "",    false, false },
  { u8"Middle Newar",                                               "nwx",     "",   "",    false, false },
  { u8"Middle Watut",                                               "mpl",     "",   "",    false, false },
  { u8"Middle Welsh",                                               "wlm",     "",   "",    false, false },
  { u8"Midob",                                                      "mei",     "",   "",    false, false },
  { u8"Migaama",                                                    "mmy",     "",   "",    false, false },
  { u8"Migabac",                                                    "mpp",     "",   "",    false, false },
  { u8"Migum",                                                      "klm",     "",   "",    false, false },
  { u8"Miju-Mishmi",                                                "mxj",     "",   "",    false, false },
  { u8"Mikasuki",                                                   "mik",     "",   "",    false, false },
  { u8"Mili",                                                       "ymh",     "",   "",    false, false },
  { u8"Miltu",                                                      "mlj",     "",   "",    false, false },
  { u8"Miluk",                                                      "iml",     "",   "",    false, false },
  { u8"Milyan",                                                     "imy",     "",   "",    false, false },
  { u8"Min Bei Chinese",                                            "mnp",     "",   "",    false, false },
  { u8"Min Dong Chinese",                                           "cdo",     "",   "",    false, false },
  { u8"Min Nan Chinese",                                            "nan",     "",   "",    false, false },
  { u8"Min Zhong Chinese",                                          "czo",     "",   "",    false, false },
  { u8"Mina (Cameroon)",                                            "hna",     "",   "",    false, false },
  { u8"Mina (India)",                                               "myi",     "",   "",    false, true  },
  { u8"Minaean",                                                    "inm",     "",   "",    false, false },
  { u8"Minang",                                                     "xrg",     "",   "",    false, false },
  { u8"Minangkabau",                                                "min",     "",   "",    true,  false },
  { u8"Minanibai",                                                  "mcv",     "",   "",    false, false },
  { u8"Minaveha",                                                   "mvn",     "",   "",    false, false },
  { u8"Minderico",                                                  "drc",     "",   "",    false, false },
  { u8"Mindiri",                                                    "mpn",     "",   "",    false, false },
  { u8"Mingang Doso",                                               "mko",     "",   "",    false, false },
  { u8"Mingrelian",                                                 "xmf",     "",   "",    false, false },
  { u8"Minica Huitoto",                                             "hto",     "",   "",    false, false },
  { u8"Minidien",                                                   "wii",     "",   "",    false, false },
  { u8"Minjungbal",                                                 "xjb",     "",   "",    false, false },
  { u8"Minkin",                                                     "xxm",     "",   "",    false, false },
  { u8"Minoan",                                                     "omn",     "",   "",    false, false },
  { u8"Minokok",                                                    "mqq",     "",   "",    false, false },
  { u8"Minriq",                                                     "mnq",     "",   "",    false, false },
  { u8"Mintil",                                                     "mzt",     "",   "",    false, false },
  { u8"Minz Zhuang",                                                "zgm",     "",   "",    false, false },
  { u8"Miqie",                                                      "yiq",     "",   "",    false, false },
  { u8"Mirandese",                                                  "mwl",     "",   "",    true,  false },
  { u8"Miraya Bikol",                                               "rbl",     "",   "",    false, false },
  { u8"Mirgan",                                                     "zrg",     "",   "",    false, false },
  { u8"Miriti",                                                     "mmv",     "",   "",    false, false },
  { u8"Miriwoong Sign Language",                                    "rsm",     "",   "",    false, false },
  { u8"Miriwoong",                                                  "mep",     "",   "",    false, false },
  { u8"Mirning",                                                    "gmr",     "",   "",    false, false },
  { u8"Mirpur Panjabi",                                             "pmu",     "",   "",    false, true  },
  { u8"Miship",                                                     "mjs",     "",   "",    false, false },
  { u8"Misima-Panaeati",                                            "mpx",     "",   "",    false, false },
  { u8"Mising",                                                     "mrg",     "",   "",    false, false },
  { u8"Mitla Zapotec",                                              "zaw",     "",   "",    false, false },
  { u8"Mitlatongo Mixtec",                                          "vmm",     "",   "",    false, false },
  { u8"Mittu",                                                      "mwu",     "",   "",    false, false },
  { u8"Mituku",                                                     "zmq",     "",   "",    false, false },
  { u8"Miu",                                                        "mpo",     "",   "",    false, false },
  { u8"Miwa",                                                       "vmi",     "",   "",    false, false },
  { u8"Mixed Great Andamanese",                                     "gac",     "",   "",    false, false },
  { u8"Mixtepec Mixtec",                                            "mix",     "",   "",    false, false },
  { u8"Mixtepec Zapotec",                                           "zpm",     "",   "",    false, false },
  { u8"Miya",                                                       "mkf",     "",   "",    false, false },
  { u8"Miyako",                                                     "mvi",     "",   "",    false, false },
  { u8"Miyakubo Sign Language",                                     "ehs",     "",   "",    false, false },
  { u8"Miyobe",                                                     "soy",     "",   "",    false, false },
  { u8"Mlabri",                                                     "mra",     "",   "",    false, false },
  { u8"Mlahsö",                                                     "lhs",     "",   "",    false, false },
  { u8"Mlap",                                                       "kja",     "",   "",    false, false },
  { u8"Mlomp",                                                      "mlo",     "",   "",    false, false },
  { u8"Mmaala",                                                     "mmu",     "",   "",    false, false },
  { u8"Mmen",                                                       "bfm",     "",   "",    false, false },
  { u8"Mo'da",                                                      "gbn",     "",   "",    false, false },
  { u8"Moabite",                                                    "obm",     "",   "",    false, false },
  { u8"Moba",                                                       "mfq",     "",   "",    false, false },
  { u8"Mobilian",                                                   "mod",     "",   "",    false, false },
  { u8"Mobumrin Aizi",                                              "ahm",     "",   "",    false, false },
  { u8"Mobwa Karen",                                                "jkm",     "",   "",    false, false },
  { u8"Mochi",                                                      "old",     "",   "",    false, false },
  { u8"Mochica",                                                    "omc",     "",   "",    false, false },
  { u8"Mocho",                                                      "mhc",     "",   "",    false, false },
  { u8"Mocoví",                                                     "moc",     "",   "",    false, false },
  { u8"Modang",                                                     "mxd",     "",   "",    false, false },
  { u8"Modole",                                                     "mqo",     "",   "",    false, false },
  { u8"Moere",                                                      "mvq",     "",   "",    false, false },
  { u8"Mofu-Gudur",                                                 "mif",     "",   "",    false, false },
  { u8"Mogholi",                                                    "mhj",     "",   "",    false, false },
  { u8"Mogofin",                                                    "mfg",     "",   "",    false, false },
  { u8"Mogum",                                                      "mou",     "",   "",    false, false },
  { u8"Mohave",                                                     "mov",     "",   "",    false, false },
  { u8"Mohawk",                                                     "moh",     "",   "",    true,  false },
  { u8"Mohegan-Montauk-Narragansett",                               "mof",     "",   "",    false, true  },
  { u8"Mohegan-Pequot",                                             "xpq",     "",   "",    false, false },
  { u8"Moi (Congo)",                                                "mow",     "",   "",    false, false },
  { u8"Moi (Indonesia)",                                            "mxn",     "",   "",    false, false },
  { u8"Moikodi",                                                    "mkp",     "",   "",    false, false },
  { u8"Moingi",                                                     "mwz",     "",   "",    false, false },
  { u8"Moji",                                                       "ymi",     "",   "",    false, false },
  { u8"Mok",                                                        "mqt",     "",   "",    false, false },
  { u8"Moken",                                                      "mwt",     "",   "",    false, false },
  { u8"Mokerang",                                                   "mft",     "",   "",    false, false },
  { u8"Mokilese",                                                   "mkj",     "",   "",    false, false },
  { u8"Moklen",                                                     "mkm",     "",   "",    false, false },
  { u8"Mokole",                                                     "mkl",     "",   "",    false, false },
  { u8"Mokpwe",                                                     "bri",     "",   "",    false, false },
  { u8"Moksela",                                                    "vms",     "",   "",    false, false },
  { u8"Moksha",                                                     "mdf",     "",   "",    true,  false },
  { u8"Molale",                                                     "mbe",     "",   "",    false, false },
  { u8"Molbog",                                                     "pwm",     "",   "",    false, false },
  { u8"Moldova Sign Language",                                      "vsi",     "",   "",    false, false },
  { u8"Molengue",                                                   "bxc",     "",   "",    false, false },
  { u8"Molima",                                                     "mox",     "",   "",    false, false },
  { u8"Molmo One",                                                  "aun",     "",   "",    false, false },
  { u8"Molo",                                                       "zmo",     "",   "",    false, false },
  { u8"Molof",                                                      "msl",     "",   "",    false, false },
  { u8"Moloko",                                                     "mlw",     "",   "",    false, false },
  { u8"Mom Jango",                                                  "ver",     "",   "",    false, false },
  { u8"Moma",                                                       "myl",     "",   "",    false, false },
  { u8"Momare",                                                     "msz",     "",   "",    false, false },
  { u8"Mombo Dogon",                                                "dmb",     "",   "",    false, false },
  { u8"Mombum",                                                     "mso",     "",   "",    false, false },
  { u8"Momina",                                                     "mmb",     "",   "",    false, false },
  { u8"Momuna",                                                     "mqf",     "",   "",    false, false },
  { u8"Mon",                                                        "mnw",     "",   "",    false, false },
  { u8"Mon-Khmer languages",                                        "mkh",     "",   "",    true,  false },
  { u8"Monastic Sign Language",                                     "mzg",     "",   "",    false, false },
  { u8"Mondropolon",                                                "npn",     "",   "",    false, false },
  { u8"Mondé",                                                      "mnd",     "",   "",    false, false },
  { u8"Mongo",                                                      "lol",     "",   "",    true,  false },
  { u8"Mongol",                                                     "mgt",     "",   "",    false, false },
  { u8"Mongolia Buriat",                                            "bxm",     "",   "",    false, false },
  { u8"Mongolian Sign Language",                                    "msr",     "",   "",    false, false },
  { u8"Mongolian languages",                                        "xgn",     "",   "",    false, false },
  { u8"Mongolian",                                                  "mon",     "mn", "",    true,  false },
  { u8"Mongondow",                                                  "mog",     "",   "",    false, false },
  { u8"Moni",                                                       "mnz",     "",   "",    false, false },
  { u8"Mono (Cameroon)",                                            "mru",     "",   "",    false, false },
  { u8"Mono (Democratic Republic of Congo)",                        "mnh",     "",   "",    false, false },
  { u8"Mono (Solomon Islands)",                                     "mte",     "",   "",    false, false },
  { u8"Mono (USA)",                                                 "mnr",     "",   "",    false, false },
  { u8"Monom",                                                      "moo",     "",   "",    false, false },
  { u8"Monsang Naga",                                               "nmh",     "",   "",    false, false },
  { u8"Montenegrin",                                                "cnr",     "",   "",    true,  false },
  { u8"Montol",                                                     "mtl",     "",   "",    false, false },
  { u8"Monumbo",                                                    "mxk",     "",   "",    false, false },
  { u8"Monzombo",                                                   "moj",     "",   "",    false, false },
  { u8"Moo",                                                        "gwg",     "",   "",    false, false },
  { u8"Moose Cree",                                                 "crm",     "",   "",    false, false },
  { u8"Mopán Maya",                                                 "mop",     "",   "",    false, false },
  { u8"Mor (Bomberai Peninsula)",                                   "moq",     "",   "",    false, false },
  { u8"Mor (Mor Islands)",                                          "mhz",     "",   "",    false, false },
  { u8"Moraid",                                                     "msg",     "",   "",    false, false },
  { u8"Morawa",                                                     "mze",     "",   "",    false, false },
  { u8"Morelos Nahuatl",                                            "nhm",     "",   "",    false, false },
  { u8"Morerebi",                                                   "xmo",     "",   "",    false, false },
  { u8"Moresada",                                                   "msx",     "",   "",    false, false },
  { u8"Mori Atas",                                                  "mzq",     "",   "",    false, false },
  { u8"Mori Bawah",                                                 "xmz",     "",   "",    false, false },
  { u8"Morigi",                                                     "mdb",     "",   "",    false, false },
  { u8"Morisyen",                                                   "mfe",     "",   "",    false, false },
  { u8"Moro",                                                       "mor",     "",   "",    false, false },
  { u8"Moroccan Arabic",                                            "ary",     "",   "",    false, false },
  { u8"Moroccan Sign Language",                                     "xms",     "",   "",    false, false },
  { u8"Morokodo",                                                   "mgc",     "",   "",    false, false },
  { u8"Morom",                                                      "bdo",     "",   "",    false, false },
  { u8"Moronene",                                                   "mqn",     "",   "",    false, false },
  { u8"Morori",                                                     "mok",     "",   "",    false, false },
  { u8"Morouas",                                                    "mrp",     "",   "",    false, false },
  { u8"Morrobalama",                                                "umg",     "",   "",    false, false },
  { u8"Mortlockese",                                                "mrl",     "",   "",    false, false },
  { u8"Moru",                                                       "mgd",     "",   "",    false, false },
  { u8"Mosimo",                                                     "mqv",     "",   "",    false, false },
  { u8"Mosiro",                                                     "mwy",     "",   "",    false, true  },
  { u8"Moskona",                                                    "mtj",     "",   "",    false, false },
  { u8"Mossi",                                                      "mos",     "",   "",    true,  false },
  { u8"Mota",                                                       "mtt",     "",   "",    false, false },
  { u8"Motlav",                                                     "mlv",     "",   "",    false, false },
  { u8"Motu",                                                       "meu",     "",   "",    false, false },
  { u8"Mouk-Aria",                                                  "mwh",     "",   "",    false, false },
  { u8"Moundadan Chetty",                                           "cty",     "",   "",    false, false },
  { u8"Mountain Koiali",                                            "kpx",     "",   "",    false, false },
  { u8"Mouwase",                                                    "jmw",     "",   "",    false, false },
  { u8"Movima",                                                     "mzp",     "",   "",    false, false },
  { u8"Moyadan Itneg",                                              "ity",     "",   "",    false, false },
  { u8"Moyon Naga",                                                 "nmo",     "",   "",    false, false },
  { u8"Mozambican Sign Language",                                   "mzy",     "",   "",    false, false },
  { u8"Mozarabic",                                                  "mxi",     "",   "",    false, false },
  { u8"Mpade",                                                      "mpi",     "",   "",    false, false },
  { u8"Mpalitjanh",                                                 "xpj",     "",   "",    false, false },
  { u8"Mpi",                                                        "mpz",     "",   "",    false, false },
  { u8"Mpiemo",                                                     "mcx",     "",   "",    false, false },
  { u8"Mpinda",                                                     "pnd",     "",   "",    false, false },
  { u8"Mpoto",                                                      "mpa",     "",   "",    false, false },
  { u8"Mpotovoro",                                                  "mvt",     "",   "",    false, false },
  { u8"Mpumpong",                                                   "mgg",     "",   "",    false, false },
  { u8"Mpuono",                                                     "zmp",     "",   "",    false, false },
  { u8"Mpur",                                                       "akc",     "",   "",    false, false },
  { u8"Mro-Khimi Chin",                                             "cmr",     "",   "",    false, false },
  { u8"Mru",                                                        "mro",     "",   "",    false, false },
  { u8"Mser",                                                       "kqx",     "",   "",    false, false },
  { u8"Mt. Iraya Agta",                                             "atl",     "",   "",    false, false },
  { u8"Mt. Iriga Agta",                                             "agz",     "",   "",    false, false },
  { u8"Muak Sa-aak",                                                "ukk",     "",   "",    false, false },
  { u8"Mualang",                                                    "mtd",     "",   "",    false, false },
  { u8"Mubami",                                                     "tsx",     "",   "",    false, false },
  { u8"Mubi",                                                       "mub",     "",   "",    false, false },
  { u8"Muda",                                                       "ymd",     "",   "",    false, false },
  { u8"Mudbura",                                                    "mwd",     "",   "",    false, true  },
  { u8"Mudburra",                                                   "dmw",     "",   "",    false, false },
  { u8"Mudhili Gadaba",                                             "gau",     "",   "",    false, false },
  { u8"Mudu Koraga",                                                "vmd",     "",   "",    false, false },
  { u8"Muduga",                                                     "udg",     "",   "",    false, false },
  { u8"Mufian",                                                     "aoj",     "",   "",    false, false },
  { u8"Mugom",                                                      "muk",     "",   "",    false, false },
  { u8"Muinane",                                                    "bmr",     "",   "",    false, false },
  { u8"Mukha-Dora",                                                 "mmk",     "",   "",    false, false },
  { u8"Mukulu",                                                     "moz",     "",   "",    false, false },
  { u8"Mulaha",                                                     "mfw",     "",   "",    false, false },
  { u8"Mulam",                                                      "mlm",     "",   "",    false, false },
  { u8"Mulao",                                                      "giu",     "",   "",    false, false },
  { u8"Mulgi",                                                      "mvh",     "",   "",    false, false },
  { u8"Mullu Kurumba",                                              "kpb",     "",   "",    false, false },
  { u8"Multiple languages",                                         "mul",     "",   "",    true,  false },
  { u8"Muluridyi",                                                  "vmu",     "",   "",    false, false },
  { u8"Mum",                                                        "kqa",     "",   "",    false, false },
  { u8"Mumuye",                                                     "mzm",     "",   "",    false, false },
  { u8"Muna",                                                       "mnb",     "",   "",    false, false },
  { u8"Munda languages",                                            "mun",     "",   "",    true,  false },
  { u8"Munda",                                                      "unx",     "",   "",    false, false },
  { u8"Mundabli",                                                   "boe",     "",   "",    false, false },
  { u8"Mundang",                                                    "mua",     "",   "",    false, false },
  { u8"Mundani",                                                    "mnf",     "",   "",    false, false },
  { u8"Mundari",                                                    "unr",     "",   "",    false, false },
  { u8"Mundat",                                                     "mmf",     "",   "",    false, false },
  { u8"Mundurukú",                                                  "myu",     "",   "",    false, false },
  { u8"Mungaka",                                                    "mhk",     "",   "",    false, false },
  { u8"Munggui",                                                    "mth",     "",   "",    false, false },
  { u8"Mungkip",                                                    "mpv",     "",   "",    false, false },
  { u8"Muniche",                                                    "myr",     "",   "",    false, false },
  { u8"Munit",                                                      "mtc",     "",   "",    false, false },
  { u8"Munji",                                                      "mnj",     "",   "",    false, false },
  { u8"Munsee",                                                     "umu",     "",   "",    false, false },
  { u8"Muong",                                                      "mtq",     "",   "",    false, false },
  { u8"Mur Pano",                                                   "tkv",     "",   "",    false, false },
  { u8"Muratayak",                                                  "asx",     "",   "",    false, false },
  { u8"Murik (Malaysia)",                                           "mxr",     "",   "",    false, false },
  { u8"Murik (Papua New Guinea)",                                   "mtf",     "",   "",    false, false },
  { u8"Murkim",                                                     "rmh",     "",   "",    false, false },
  { u8"Murle",                                                      "mur",     "",   "",    false, false },
  { u8"Murrinh-Patha",                                              "mwf",     "",   "",    false, false },
  { u8"Mursi",                                                      "muz",     "",   "",    false, false },
  { u8"Murui Huitoto",                                              "huu",     "",   "",    false, false },
  { u8"Murupi",                                                     "mqw",     "",   "",    false, false },
  { u8"Muruwari",                                                   "zmu",     "",   "",    false, false },
  { u8"Musak",                                                      "mmq",     "",   "",    false, false },
  { u8"Musar",                                                      "mmi",     "",   "",    false, false },
  { u8"Musasa",                                                     "smm",     "",   "",    false, false },
  { u8"Musey",                                                      "mse",     "",   "",    false, false },
  { u8"Musgu",                                                      "mug",     "",   "",    false, false },
  { u8"Mushungulu",                                                 "xma",     "",   "",    false, false },
  { u8"Musi",                                                       "mui",     "",   "",    false, false },
  { u8"Muskum",                                                     "mje",     "",   "",    false, false },
  { u8"Muslim Tat",                                                 "ttt",     "",   "",    false, false },
  { u8"Musom",                                                      "msu",     "",   "",    false, false },
  { u8"Mussau-Emira",                                               "emi",     "",   "",    false, false },
  { u8"Muthuvan",                                                   "muv",     "",   "",    false, false },
  { u8"Mutu",                                                       "tuc",     "",   "",    false, false },
  { u8"Muya",                                                       "mvm",     "",   "",    false, true  },
  { u8"Muyang",                                                     "muy",     "",   "",    false, false },
  { u8"Muyuw",                                                      "myw",     "",   "",    false, false },
  { u8"Muzi",                                                       "ymz",     "",   "",    false, false },
  { u8"Mvanip",                                                     "mcj",     "",   "",    false, false },
  { u8"Mvuba",                                                      "mxh",     "",   "",    false, false },
  { u8"Mwaghavul",                                                  "sur",     "",   "",    false, false },
  { u8"Mwali Comorian",                                             "wlc",     "",   "",    false, false },
  { u8"Mwan",                                                       "moa",     "",   "",    false, false },
  { u8"Mwani",                                                      "wmw",     "",   "",    false, false },
  { u8"Mwatebu",                                                    "mwa",     "",   "",    false, false },
  { u8"Mwera (Chimwera)",                                           "mwe",     "",   "",    false, false },
  { u8"Mwera (Nyasa)",                                              "mjh",     "",   "",    false, false },
  { u8"Mwimbi-Muthambi",                                            "mws",     "",   "",    false, false },
  { u8"Myanmar Sign Language",                                      "ysm",     "",   "",    false, false },
  { u8"Mycenaean Greek",                                            "gmy",     "",   "",    false, false },
  { u8"Myene",                                                      "mye",     "",   "",    false, false },
  { u8"Mysian",                                                     "yms",     "",   "",    false, false },
  { u8"Mzieme Naga",                                                "nme",     "",   "",    false, false },
  { u8"Mághdì",                                                     "gmd",     "",   "",    false, false },
  { u8"Máku",                                                       "xak",     "",   "",    false, false },
  { u8"Ménik",                                                      "tnr",     "",   "",    false, false },
  { u8"Mískito",                                                    "miq",     "",   "",    false, false },
  { u8"Mócheno",                                                    "mhn",     "",   "",    false, false },
  { u8"Mün Chin",                                                   "mwq",     "",   "",    false, false },
  { u8"Mündü",                                                      "muh",     "",   "",    false, false },
  { u8"Māhārāṣṭri Prākrit",                                         "pmh",     "",   "",    false, false },
  { u8"N'Ko",                                                       "nqo",     "",   "",    true,  false },
  { u8"Na",                                                         "nbt",     "",   "",    false, false },
  { u8"Na-Dene languages",                                          "xnd",     "",   "",    false, false },
  { u8"Na-kara",                                                    "nck",     "",   "",    false, false },
  { u8"Naaba",                                                      "nao",     "",   "",    false, false },
  { u8"Naami",                                                      "bzv",     "",   "",    false, false },
  { u8"Naasioi",                                                    "nas",     "",   "",    false, false },
  { u8"Naba",                                                       "mne",     "",   "",    false, false },
  { u8"Nabak",                                                      "naf",     "",   "",    false, false },
  { u8"Nabi",                                                       "mty",     "",   "",    false, false },
  { u8"Nachering",                                                  "ncd",     "",   "",    false, false },
  { u8"Nadruvian",                                                  "ndf",     "",   "",    false, false },
  { u8"Nadëb",                                                      "mbj",     "",   "",    false, false },
  { u8"Nafaanra",                                                   "nfr",     "",   "",    false, false },
  { u8"Nafi",                                                       "srf",     "",   "",    false, false },
  { u8"Nafri",                                                      "nxx",     "",   "",    false, false },
  { u8"Nafusi",                                                     "jbn",     "",   "",    false, false },
  { u8"Naga Pidgin",                                                "nag",     "",   "",    false, false },
  { u8"Nagarchal",                                                  "nbg",     "",   "",    false, false },
  { u8"Nage",                                                       "nxe",     "",   "",    false, false },
  { u8"Nagumi",                                                     "ngv",     "",   "",    false, false },
  { u8"Nahali",                                                     "nlx",     "",   "",    false, false },
  { u8"Nahari",                                                     "nhh",     "",   "",    false, false },
  { u8"Nahuatl languages",                                          "nah",     "",   "",    true,  false },
  { u8"Nai",                                                        "bio",     "",   "",    false, false },
  { u8"Najdi Arabic",                                               "ars",     "",   "",    false, false },
  { u8"Naka'ela",                                                   "nae",     "",   "",    false, false },
  { u8"Nakai",                                                      "nkj",     "",   "",    false, false },
  { u8"Nakame",                                                     "nib",     "",   "",    false, false },
  { u8"Nakanai",                                                    "nak",     "",   "",    false, false },
  { u8"Nake",                                                       "nbk",     "",   "",    false, false },
  { u8"Naki",                                                       "mff",     "",   "",    false, false },
  { u8"Nakwi",                                                      "nax",     "",   "",    false, false },
  { u8"Nalca",                                                      "nlc",     "",   "",    false, false },
  { u8"Nali",                                                       "nss",     "",   "",    false, false },
  { u8"Nalik",                                                      "nal",     "",   "",    false, false },
  { u8"Nalu",                                                       "naj",     "",   "",    false, false },
  { u8"Naluo Yi",                                                   "ylo",     "",   "",    false, false },
  { u8"Nalögo",                                                     "nlz",     "",   "",    false, false },
  { u8"Nama (Papua New Guinea)",                                    "nmx",     "",   "",    false, false },
  { u8"Namakura",                                                   "nmk",     "",   "",    false, false },
  { u8"Namat",                                                      "nkm",     "",   "",    false, false },
  { u8"Nambo",                                                      "ncm",     "",   "",    false, false },
  { u8"Nambya",                                                     "nmq",     "",   "",    false, false },
  { u8"Namia",                                                      "nnm",     "",   "",    false, false },
  { u8"Namiae",                                                     "nvm",     "",   "",    false, false },
  { u8"Namibian Sign Language",                                     "nbs",     "",   "",    false, false },
  { u8"Namla",                                                      "naa",     "",   "",    false, false },
  { u8"Namo",                                                       "mxw",     "",   "",    false, false },
  { u8"Namonuito",                                                  "nmt",     "",   "",    false, false },
  { u8"Namosi-Naitasiri-Serua",                                     "bwb",     "",   "",    false, false },
  { u8"Namuyi",                                                     "nmy",     "",   "",    false, false },
  { u8"Nanai",                                                      "gld",     "",   "",    false, false },
  { u8"Nancere",                                                    "nnc",     "",   "",    false, false },
  { u8"Nande",                                                      "nnb",     "",   "",    false, false },
  { u8"Nandi",                                                      "niq",     "",   "",    false, false },
  { u8"Nanerigé Sénoufo",                                           "sen",     "",   "",    false, false },
  { u8"Nanga Dama Dogon",                                           "nzz",     "",   "",    false, false },
  { u8"Nankina",                                                    "nnk",     "",   "",    false, false },
  { u8"Nanti",                                                      "cox",     "",   "",    false, false },
  { u8"Nanticoke",                                                  "nnt",     "",   "",    false, false },
  { u8"Nanubae",                                                    "afk",     "",   "",    false, false },
  { u8"Napo Lowland Quechua",                                       "qvo",     "",   "",    false, false },
  { u8"Napu",                                                       "npy",     "",   "",    false, false },
  { u8"Nar Phu",                                                    "npa",     "",   "",    false, false },
  { u8"Nara",                                                       "nrb",     "",   "",    false, false },
  { u8"Narak",                                                      "nac",     "",   "",    false, false },
  { u8"Narango",                                                    "nrg",     "",   "",    false, false },
  { u8"Narau",                                                      "nxu",     "",   "",    false, true  },
  { u8"Nari Nari",                                                  "rnr",     "",   "",    false, false },
  { u8"Narim",                                                      "loh",     "",   "",    false, false },
  { u8"Naro",                                                       "nhr",     "",   "",    false, false },
  { u8"Narom",                                                      "nrm",     "",   "",    false, false },
  { u8"Narragansett",                                               "xnt",     "",   "",    false, false },
  { u8"Narua",                                                      "nru",     "",   "",    false, false },
  { u8"Narungga",                                                   "nnr",     "",   "",    false, false },
  { u8"Nasal",                                                      "nsy",     "",   "",    false, false },
  { u8"Nasarian",                                                   "nvh",     "",   "",    false, false },
  { u8"Naskapi",                                                    "nsk",     "",   "",    false, false },
  { u8"Natagaimas",                                                 "nts",     "",   "",    false, true  },
  { u8"Natanzi",                                                    "ntz",     "",   "",    false, false },
  { u8"Nataoran Amis",                                              "ais",     "",   "",    false, true  },
  { u8"Natchez",                                                    "ncz",     "",   "",    false, false },
  { u8"Nateni",                                                     "ntm",     "",   "",    false, false },
  { u8"Nathembo",                                                   "nte",     "",   "",    false, false },
  { u8"Natioro",                                                    "nti",     "",   "",    false, false },
  { u8"Natügu",                                                     "ntu",     "",   "",    false, false },
  { u8"Nauete",                                                     "nxa",     "",   "",    false, false },
  { u8"Naukan Yupik",                                               "ynk",     "",   "",    false, false },
  { u8"Nauna",                                                      "ncn",     "",   "",    false, false },
  { u8"Nauo",                                                       "nwo",     "",   "",    false, false },
  { u8"Nauru",                                                      "nau",     "na", "",    true,  false },
  { u8"Navajo",                                                     "nav",     "nv", "",    true,  false },
  { u8"Navut",                                                      "nsw",     "",   "",    false, false },
  { u8"Nawaru",                                                     "nwr",     "",   "",    false, false },
  { u8"Nawathinehena",                                              "nwa",     "",   "",    false, false },
  { u8"Nawdm",                                                      "nmz",     "",   "",    false, false },
  { u8"Nawuri",                                                     "naw",     "",   "",    false, false },
  { u8"Naxi",                                                       "nbf",     "",   "",    false, true  },
  { u8"Naxi",                                                       "nxq",     "",   "",    false, false },
  { u8"Nayi",                                                       "noz",     "",   "",    false, false },
  { u8"Nayini",                                                     "nyq",     "",   "",    false, false },
  { u8"Ncane",                                                      "ncr",     "",   "",    false, false },
  { u8"Nchumbulu",                                                  "nlu",     "",   "",    false, false },
  { u8"Nda'nda'",                                                   "nnz",     "",   "",    false, false },
  { u8"Ndai",                                                       "gke",     "",   "",    false, false },
  { u8"Ndaka",                                                      "ndk",     "",   "",    false, false },
  { u8"Ndaktup",                                                    "ncp",     "",   "",    false, true  },
  { u8"Ndali",                                                      "ndh",     "",   "",    false, false },
  { u8"Ndam",                                                       "ndm",     "",   "",    false, false },
  { u8"Ndamba",                                                     "ndj",     "",   "",    false, false },
  { u8"Ndambomo",                                                   "nxo",     "",   "",    false, false },
  { u8"Ndasa",                                                      "nda",     "",   "",    false, false },
  { u8"Ndau",                                                       "ndc",     "",   "",    false, false },
  { u8"Nde-Gbite",                                                  "ned",     "",   "",    false, false },
  { u8"Nde-Nsele-Nta",                                              "ndd",     "",   "",    false, false },
  { u8"Ndemli",                                                     "nml",     "",   "",    false, false },
  { u8"Ndendeule",                                                  "dne",     "",   "",    false, false },
  { u8"Ndengereko",                                                 "ndg",     "",   "",    false, false },
  { u8"Nding",                                                      "eli",     "",   "",    false, false },
  { u8"Ndo",                                                        "ndp",     "",   "",    false, false },
  { u8"Ndobo",                                                      "ndw",     "",   "",    false, false },
  { u8"Ndoe",                                                       "nbb",     "",   "",    false, false },
  { u8"Ndogo",                                                      "ndz",     "",   "",    false, false },
  { u8"Ndolo",                                                      "ndl",     "",   "",    false, false },
  { u8"Ndom",                                                       "nqm",     "",   "",    false, false },
  { u8"Ndombe",                                                     "ndq",     "",   "",    false, false },
  { u8"Ndonde Hamba",                                               "njd",     "",   "",    false, false },
  { u8"Ndonga",                                                     "ndo",     "ng", "",    true,  false },
  { u8"Ndoola",                                                     "ndr",     "",   "",    false, false },
  { u8"Ndra'ngith",                                                 "dgt",     "",   "",    false, false },
  { u8"Ndrulo",                                                     "dno",     "",   "",    false, false },
  { u8"Nduga",                                                      "ndx",     "",   "",    false, false },
  { u8"Ndumu",                                                      "nmd",     "",   "",    false, false },
  { u8"Ndunda",                                                     "nuh",     "",   "",    false, false },
  { u8"Ndunga",                                                     "ndt",     "",   "",    false, false },
  { u8"Ndut",                                                       "ndv",     "",   "",    false, false },
  { u8"Ndwewe",                                                     "nww",     "",   "",    false, false },
  { u8"Ndyuka-Trio Pidgin",                                         "njt",     "",   "",    false, false },
  { u8"Ndzwani Comorian",                                           "wni",     "",   "",    false, false },
  { u8"Neapolitan",                                                 "nap",     "",   "",    true,  false },
  { u8"Nedebang",                                                   "nec",     "",   "",    false, false },
  { u8"Nefamese",                                                   "nef",     "",   "",    false, false },
  { u8"Negerhollands",                                              "dcr",     "",   "",    false, false },
  { u8"Negeri Sembilan Malay",                                      "zmi",     "",   "",    false, false },
  { u8"Negidal",                                                    "neg",     "",   "",    false, false },
  { u8"Nehan",                                                      "nsn",     "",   "",    false, false },
  { u8"Nek",                                                        "nif",     "",   "",    false, false },
  { u8"Nekgini",                                                    "nkg",     "",   "",    false, false },
  { u8"Neko",                                                       "nej",     "",   "",    false, false },
  { u8"Neku",                                                       "nek",     "",   "",    false, false },
  { u8"Nema",                                                       "gsn",     "",   "",    false, false },
  { u8"Neme",                                                       "nex",     "",   "",    false, false },
  { u8"Nemi",                                                       "nem",     "",   "",    false, false },
  { u8"Nen",                                                        "nqn",     "",   "",    false, false },
  { u8"Nend",                                                       "anh",     "",   "",    false, false },
  { u8"Nenets",                                                     "yrk",     "",   "",    false, false },
  { u8"Nengone",                                                    "nen",     "",   "",    false, false },
  { u8"Neo",                                                        "neu",     "",   "",    false, false },
  { u8"Neo-Hittite",                                                "nei",     "",   "",    false, false },
  { u8"Nepalese Sign Language",                                     "nsp",     "",   "",    false, false },
  { u8"Nepali (individual language)",                               "npi",     "",   "",    false, false },
  { u8"Nepali (macrolanguage)",                                     "nep",     "ne", "",    true,  false },
  { u8"Nepali Kurux",                                               "kxl",     "",   "",    false, true  },
  { u8"Nete",                                                       "net",     "",   "",    false, false },
  { u8"New Caledonian Javanese",                                    "jas",     "",   "",    false, false },
  { u8"New Zealand Sign Language",                                  "nzs",     "",   "",    false, false },
  { u8"Newari",                                                     "new",     "",   "",    true,  false },
  { u8"Neyo",                                                       "ney",     "",   "",    false, false },
  { u8"Nez Perce",                                                  "nez",     "",   "",    false, false },
  { u8"Ngaanyatjarra",                                              "ntj",     "",   "",    false, false },
  { u8"Ngad'a",                                                     "nxg",     "",   "",    false, false },
  { u8"Ngadjunmaya",                                                "nju",     "",   "",    false, false },
  { u8"Ngadjuri",                                                   "jui",     "",   "",    false, false },
  { u8"Ngaing",                                                     "nnf",     "",   "",    false, false },
  { u8"Ngaju",                                                      "nij",     "",   "",    false, false },
  { u8"Ngala",                                                      "nud",     "",   "",    false, false },
  { u8"Ngalakgan",                                                  "nig",     "",   "",    false, false },
  { u8"Ngalum",                                                     "szb",     "",   "",    false, false },
  { u8"Ngam",                                                       "nmc",     "",   "",    false, false },
  { u8"Ngamambo",                                                   "nbv",     "",   "",    false, false },
  { u8"Ngambay",                                                    "sba",     "",   "",    false, false },
  { u8"Ngamini",                                                    "nmv",     "",   "",    false, false },
  { u8"Ngamo",                                                      "nbh",     "",   "",    false, false },
  { u8"Ngan'gityemerri",                                            "nam",     "",   "",    false, false },
  { u8"Nganakarti",                                                 "xnk",     "",   "",    false, false },
  { u8"Nganasan",                                                   "nio",     "",   "",    false, false },
  { u8"Ngandi",                                                     "nid",     "",   "",    false, false },
  { u8"Ngando (Central African Republic)",                          "ngd",     "",   "",    false, false },
  { u8"Ngando (Democratic Republic of Congo)",                      "nxd",     "",   "",    false, false },
  { u8"Ngandyera",                                                  "nne",     "",   "",    false, false },
  { u8"Ngangam",                                                    "gng",     "",   "",    false, false },
  { u8"Ngantangarra",                                               "ntg",     "",   "",    false, false },
  { u8"Nganyaywana",                                                "nyx",     "",   "",    false, false },
  { u8"Ngardi",                                                     "rxd",     "",   "",    false, false },
  { u8"Ngarigu",                                                    "xni",     "",   "",    false, false },
  { u8"Ngarinyin",                                                  "ung",     "",   "",    false, false },
  { u8"Ngarinyman",                                                 "nbj",     "",   "",    false, false },
  { u8"Ngarla",                                                     "nlr",     "",   "",    false, true  },
  { u8"Ngarla",                                                     "nrk",     "",   "",    false, false },
  { u8"Ngarluma",                                                   "nrl",     "",   "",    false, false },
  { u8"Ngarrindjeri",                                               "nay",     "",   "",    false, false },
  { u8"Ngas",                                                       "anc",     "",   "",    false, false },
  { u8"Ngasa",                                                      "nsg",     "",   "",    false, false },
  { u8"Ngatik Men's Creole",                                        "ngm",     "",   "",    false, false },
  { u8"Ngawn Chin",                                                 "cnw",     "",   "",    false, false },
  { u8"Ngawun",                                                     "nxn",     "",   "",    false, false },
  { u8"Ngayawung",                                                  "nwg",     "",   "",    false, false },
  { u8"Ngazidja Comorian",                                          "zdj",     "",   "",    false, false },
  { u8"Ngbaka Ma'bo",                                               "nbm",     "",   "",    false, false },
  { u8"Ngbaka Manza",                                               "ngg",     "",   "",    false, false },
  { u8"Ngbaka",                                                     "nga",     "",   "",    false, false },
  { u8"Ngbee",                                                      "jgb",     "",   "",    false, false },
  { u8"Ngbinda",                                                    "nbd",     "",   "",    false, false },
  { u8"Ngbundu",                                                    "nuu",     "",   "",    false, false },
  { u8"Ngelima",                                                    "agh",     "",   "",    false, false },
  { u8"Ngemba",                                                     "nge",     "",   "",    false, false },
  { u8"Ngen",                                                       "gnj",     "",   "",    false, false },
  { u8"Ngendelengo",                                                "nql",     "",   "",    false, false },
  { u8"Ngete",                                                      "nnn",     "",   "",    false, false },
  { u8"Nggem",                                                      "nbq",     "",   "",    false, false },
  { u8"Nggwahyi",                                                   "ngx",     "",   "",    false, false },
  { u8"Ngie",                                                       "ngj",     "",   "",    false, false },
  { u8"Ngiemboon",                                                  "nnh",     "",   "",    false, false },
  { u8"Ngile",                                                      "jle",     "",   "",    false, false },
  { u8"Ngindo",                                                     "nnq",     "",   "",    false, false },
  { u8"Ngiti",                                                      "niy",     "",   "",    false, false },
  { u8"Ngizim",                                                     "ngi",     "",   "",    false, false },
  { u8"Ngkâlmpw Kanum",                                             "kcd",     "",   "",    false, false },
  { u8"Ngom",                                                       "nra",     "",   "",    false, false },
  { u8"Ngomba",                                                     "jgo",     "",   "",    false, false },
  { u8"Ngombale",                                                   "nla",     "",   "",    false, false },
  { u8"Ngombe (Central African Republic)",                          "nmj",     "",   "",    false, false },
  { u8"Ngombe (Democratic Republic of Congo)",                      "ngc",     "",   "",    false, false },
  { u8"Ngong",                                                      "nnx",     "",   "",    false, true  },
  { u8"Ngongo",                                                     "noq",     "",   "",    false, false },
  { u8"Ngoni (Mozambique)",                                         "xnq",     "",   "",    false, false },
  { u8"Ngoni (Tanzania)",                                           "xnj",     "",   "",    false, false },
  { u8"Ngoni",                                                      "ngo",     "",   "",    false, true  },
  { u8"Ngoshie",                                                    "nsh",     "",   "",    false, false },
  { u8"Ngul",                                                       "nlo",     "",   "",    false, false },
  { u8"Ngulu",                                                      "ngp",     "",   "",    false, false },
  { u8"Nguluwan",                                                   "nuw",     "",   "",    false, false },
  { u8"Ngumbarl",                                                   "xnm",     "",   "",    false, false },
  { u8"Ngumbi",                                                     "nui",     "",   "",    false, false },
  { u8"Ngunawal",                                                   "xul",     "",   "",    false, false },
  { u8"Ngundi",                                                     "ndn",     "",   "",    false, false },
  { u8"Ngundu",                                                     "nue",     "",   "",    false, false },
  { u8"Ngungwel",                                                   "ngz",     "",   "",    false, false },
  { u8"Ngura",                                                      "nbx",     "",   "",    false, true  },
  { u8"Ngurimi",                                                    "ngq",     "",   "",    false, false },
  { u8"Ngurmbur",                                                   "nrx",     "",   "",    false, false },
  { u8"Nguôn",                                                      "nuo",     "",   "",    false, false },
  { u8"Ngwaba",                                                     "ngw",     "",   "",    false, false },
  { u8"Ngwe",                                                       "nwe",     "",   "",    false, false },
  { u8"Ngwo",                                                       "ngn",     "",   "",    false, false },
  { u8"Ngäbere",                                                    "gym",     "",   "",    false, false },
  { u8"Nhanda",                                                     "nha",     "",   "",    false, false },
  { u8"Nhengatu",                                                   "yrl",     "",   "",    false, false },
  { u8"Nhirrpi",                                                    "hrp",     "",   "",    false, false },
  { u8"Nhuwala",                                                    "nhf",     "",   "",    false, false },
  { u8"Nias",                                                       "nia",     "",   "",    true,  false },
  { u8"Nicaragua Creole English",                                   "bzk",     "",   "",    false, false },
  { u8"Nicaraguan Sign Language",                                   "ncs",     "",   "",    false, false },
  { u8"Niellim",                                                    "nie",     "",   "",    false, false },
  { u8"Niger-Kordofanian languages",                                "nic",     "",   "",    true,  false },
  { u8"Nigeria Mambila",                                            "mzk",     "",   "",    false, false },
  { u8"Nigerian Fulfulde",                                          "fuv",     "",   "",    false, false },
  { u8"Nigerian Pidgin",                                            "pcm",     "",   "",    false, false },
  { u8"Nigerian Sign Language",                                     "nsi",     "",   "",    false, false },
  { u8"Nihali",                                                     "nll",     "",   "",    false, false },
  { u8"Nii",                                                        "nii",     "",   "",    false, false },
  { u8"Nijadali",                                                   "nad",     "",   "",    false, true  },
  { u8"Niksek",                                                     "gbe",     "",   "",    false, false },
  { u8"Nila",                                                       "nil",     "",   "",    false, false },
  { u8"Nilamba",                                                    "nim",     "",   "",    false, false },
  { u8"Nilo-Saharan languages",                                     "ssa",     "",   "",    true,  false },
  { u8"Nimadi",                                                     "noe",     "",   "",    false, false },
  { u8"Nimanbur",                                                   "nmp",     "",   "",    false, false },
  { u8"Nimbari",                                                    "nmr",     "",   "",    false, false },
  { u8"Nimboran",                                                   "nir",     "",   "",    false, false },
  { u8"Nimi",                                                       "nis",     "",   "",    false, false },
  { u8"Nimo",                                                       "niw",     "",   "",    false, false },
  { u8"Nimoa",                                                      "nmw",     "",   "",    false, false },
  { u8"Ninam",                                                      "shb",     "",   "",    false, false },
  { u8"Nindi",                                                      "nxi",     "",   "",    false, false },
  { u8"Ningera",                                                    "nby",     "",   "",    false, false },
  { u8"Ninggerum",                                                  "nxr",     "",   "",    false, false },
  { u8"Ningil",                                                     "niz",     "",   "",    false, false },
  { u8"Ningye",                                                     "nns",     "",   "",    false, true  },
  { u8"Ninia Yali",                                                 "nlk",     "",   "",    false, false },
  { u8"Ninzo",                                                      "nin",     "",   "",    false, false },
  { u8"Nipsan",                                                     "nps",     "",   "",    false, false },
  { u8"Nisa",                                                       "njs",     "",   "",    false, false },
  { u8"Nisenan",                                                    "nsz",     "",   "",    false, false },
  { u8"Nisga'a",                                                    "ncg",     "",   "",    false, false },
  { u8"Nisi (China)",                                               "yso",     "",   "",    false, false },
  { u8"Nisi (India)",                                               "dap",     "",   "",    false, true  },
  { u8"Niuafo'ou",                                                  "num",     "",   "",    false, false },
  { u8"Niuatoputapu",                                               "nkp",     "",   "",    false, false },
  { u8"Niuean",                                                     "niu",     "",   "",    true,  false },
  { u8"Nivaclé",                                                    "cag",     "",   "",    false, false },
  { u8"Niwer Mil",                                                  "hrc",     "",   "",    false, false },
  { u8"Njalgulgule",                                                "njl",     "",   "",    false, false },
  { u8"Njebi",                                                      "nzb",     "",   "",    false, false },
  { u8"Njen",                                                       "njj",     "",   "",    false, false },
  { u8"Njerep",                                                     "njr",     "",   "",    false, false },
  { u8"Njyem",                                                      "njy",     "",   "",    false, false },
  { u8"Nkami",                                                      "nkq",     "",   "",    false, false },
  { u8"Nkangala",                                                   "nkn",     "",   "",    false, false },
  { u8"Nkari",                                                      "nkz",     "",   "",    false, false },
  { u8"Nkem-Nkum",                                                  "isi",     "",   "",    false, false },
  { u8"Nkhumbi",                                                    "khu",     "",   "",    false, false },
  { u8"Nkongho",                                                    "nkc",     "",   "",    false, false },
  { u8"Nkonya",                                                     "nko",     "",   "",    false, false },
  { u8"Nkoroo",                                                     "nkx",     "",   "",    false, false },
  { u8"Nkoya",                                                      "nka",     "",   "",    false, false },
  { u8"Nkukoli",                                                    "nbo",     "",   "",    false, false },
  { u8"Nkutu",                                                      "nkw",     "",   "",    false, false },
  { u8"Nnam",                                                       "nbp",     "",   "",    false, false },
  { u8"No linguistic content",                                      "zxx",     "",   "",    true,  false },
  { u8"Nobiin",                                                     "fia",     "",   "",    false, false },
  { u8"Nobonob",                                                    "gaw",     "",   "",    false, false },
  { u8"Nocamán",                                                    "nom",     "",   "",    false, false },
  { u8"Nocte Naga",                                                 "njb",     "",   "",    false, false },
  { u8"Nogai",                                                      "nog",     "",   "",    true,  false },
  { u8"Noipx",                                                      "npx",     "",   "",    false, false },
  { u8"Noiri",                                                      "noi",     "",   "",    false, false },
  { u8"Nokuku",                                                     "nkk",     "",   "",    false, false },
  { u8"Nomaande",                                                   "lem",     "",   "",    false, false },
  { u8"Nomane",                                                     "nof",     "",   "",    false, false },
  { u8"Nomatsiguenga",                                              "not",     "",   "",    false, false },
  { u8"Nomlaki",                                                    "nol",     "",   "",    false, false },
  { u8"Nomu",                                                       "noh",     "",   "",    false, false },
  { u8"Nong Zhuang",                                                "zhn",     "",   "",    false, false },
  { u8"Nonuya",                                                     "noj",     "",   "",    false, false },
  { u8"Nooksack",                                                   "nok",     "",   "",    false, false },
  { u8"Noon",                                                       "snf",     "",   "",    false, false },
  { u8"Noone",                                                      "nhu",     "",   "",    false, false },
  { u8"Nootka",                                                     "noo",     "",   "",    false, true  },
  { u8"Nopala Chatino",                                             "cya",     "",   "",    false, false },
  { u8"Noric",                                                      "nrc",     "",   "",    false, false },
  { u8"Norn",                                                       "nrn",     "",   "",    false, false },
  { u8"Norra",                                                      "nrr",     "",   "",    false, false },
  { u8"North Alaskan Inupiatun",                                    "esi",     "",   "",    false, false },
  { u8"North Ambrym",                                               "mmg",     "",   "",    false, false },
  { u8"North American Indian languages",                            "nai",     "",   "",    true,  false },
  { u8"North Asmat",                                                "nks",     "",   "",    false, false },
  { u8"North Awyu",                                                 "yir",     "",   "",    false, false },
  { u8"North Azerbaijani",                                          "azj",     "",   "",    false, false },
  { u8"North Babar",                                                "bcd",     "",   "",    false, false },
  { u8"North Bolivian Quechua",                                     "qul",     "",   "",    false, false },
  { u8"North Caucasian languages",                                  "ccn",     "",   "",    false, false },
  { u8"North Central Mixe",                                         "neq",     "",   "",    false, false },
  { u8"North Efate",                                                "llp",     "",   "",    false, false },
  { u8"North Fali",                                                 "fll",     "",   "",    false, false },
  { u8"North Germanic languages",                                   "gmq",     "",   "",    false, false },
  { u8"North Giziga",                                               "gis",     "",   "",    false, false },
  { u8"North Junín Quechua",                                        "qvn",     "",   "",    false, false },
  { u8"North Levantine Arabic",                                     "apc",     "",   "",    false, false },
  { u8"North Marquesan",                                            "mrq",     "",   "",    false, false },
  { u8"North Mesopotamian Arabic",                                  "ayp",     "",   "",    false, false },
  { u8"North Midlands Tasmanian",                                   "xph",     "",   "",    false, false },
  { u8"North Mofu",                                                 "mfk",     "",   "",    false, false },
  { u8"North Moluccan Malay",                                       "max",     "",   "",    false, false },
  { u8"North Muyu",                                                 "kti",     "",   "",    false, false },
  { u8"North Ndebele",                                              "nde",     "nd", "",    true,  false },
  { u8"North Nuaulu",                                               "nni",     "",   "",    false, false },
  { u8"North Picene",                                               "nrp",     "",   "",    false, false },
  { u8"North Slavey",                                               "scs",     "",   "",    false, false },
  { u8"North Tairora",                                              "tbg",     "",   "",    false, false },
  { u8"North Tanna",                                                "tnn",     "",   "",    false, false },
  { u8"North Wahgi",                                                "whg",     "",   "",    false, false },
  { u8"North Watut",                                                "una",     "",   "",    false, false },
  { u8"Northeast Kiwai",                                            "kiw",     "",   "",    false, false },
  { u8"Northeast Maidu",                                            "nmu",     "",   "",    false, false },
  { u8"Northeast Pashai",                                           "aee",     "",   "",    false, false },
  { u8"Northeastern Dinka",                                         "dip",     "",   "",    false, false },
  { u8"Northeastern Pomo",                                          "pef",     "",   "",    false, false },
  { u8"Northeastern Tasmanian",                                     "xpb",     "",   "",    false, false },
  { u8"Northeastern Thai",                                          "tts",     "",   "",    false, false },
  { u8"Northern Alta",                                              "aqn",     "",   "",    false, false },
  { u8"Northern Altai",                                             "atv",     "",   "",    false, false },
  { u8"Northern Amami-Oshima",                                      "ryn",     "",   "",    false, false },
  { u8"Northern Betsimisaraka Malagasy",                            "bmm",     "",   "",    false, false },
  { u8"Northern Binukidnon",                                        "kyn",     "",   "",    false, false },
  { u8"Northern Bobo Madaré",                                       "bbo",     "",   "",    false, false },
  { u8"Northern Bontok",                                            "rbk",     "",   "",    false, false },
  { u8"Northern Catanduanes Bikol",                                 "cts",     "",   "",    false, false },
  { u8"Northern Conchucos Ancash Quechua",                          "qxn",     "",   "",    false, false },
  { u8"Northern Dagara",                                            "dgi",     "",   "",    false, false },
  { u8"Northern Dong",                                              "doc",     "",   "",    false, false },
  { u8"Northern East Cree",                                         "crl",     "",   "",    false, false },
  { u8"Northern Emberá",                                            "emp",     "",   "",    false, false },
  { u8"Northern Frisian",                                           "frr",     "",   "",    true,  false },
  { u8"Northern Ghale",                                             "ghh",     "",   "",    false, false },
  { u8"Northern Gondi",                                             "gno",     "",   "",    false, false },
  { u8"Northern Grebo",                                             "gbo",     "",   "",    false, false },
  { u8"Northern Guiyang Hmong",                                     "huj",     "",   "",    false, false },
  { u8"Northern Haida",                                             "hdn",     "",   "",    false, false },
  { u8"Northern Hindko",                                            "hno",     "",   "",    false, false },
  { u8"Northern Huishui Hmong",                                     "hmi",     "",   "",    false, false },
  { u8"Northern Kalapuya",                                          "nrt",     "",   "",    false, false },
  { u8"Northern Kankanay",                                          "xnn",     "",   "",    false, false },
  { u8"Northern Katang",                                            "ncq",     "",   "",    false, false },
  { u8"Northern Khmer",                                             "kxm",     "",   "",    false, false },
  { u8"Northern Kissi",                                             "kqs",     "",   "",    false, false },
  { u8"Northern Kurdish",                                           "kmr",     "",   "",    false, false },
  { u8"Northern Luri",                                              "lrc",     "",   "",    false, false },
  { u8"Northern Mashan Hmong",                                      "hmp",     "",   "",    false, false },
  { u8"Northern Muji",                                              "ymx",     "",   "",    false, false },
  { u8"Northern Nago",                                              "xkb",     "",   "",    false, false },
  { u8"Northern Ngbandi",                                           "ngb",     "",   "",    false, false },
  { u8"Northern Nisu",                                              "yiv",     "",   "",    false, false },
  { u8"Northern Nuni",                                              "nuv",     "",   "",    false, false },
  { u8"Northern Oaxaca Nahuatl",                                    "nhy",     "",   "",    false, false },
  { u8"Northern Ohlone",                                            "cst",     "",   "",    false, false },
  { u8"Northern One",                                               "onr",     "",   "",    false, false },
  { u8"Northern Paiute",                                            "pao",     "",   "",    false, false },
  { u8"Northern Pame",                                              "pmq",     "",   "",    false, false },
  { u8"Northern Pashto",                                            "pbu",     "",   "",    false, false },
  { u8"Northern Pastaza Quichua",                                   "qvz",     "",   "",    false, false },
  { u8"Northern Ping Chinese",                                      "cnp",     "",   "",    false, false },
  { u8"Northern Pomo",                                              "pej",     "",   "",    false, false },
  { u8"Northern Puebla Nahuatl",                                    "ncj",     "",   "",    false, false },
  { u8"Northern Pumi",                                              "pmi",     "",   "",    false, false },
  { u8"Northern Qiandong Miao",                                     "hea",     "",   "",    false, false },
  { u8"Northern Qiang",                                             "cng",     "",   "",    false, false },
  { u8"Northern Rengma Naga",                                       "nnl",     "",   "",    false, false },
  { u8"Northern Roglai",                                            "rog",     "",   "",    false, false },
  { u8"Northern Sami",                                              "sme",     "se", "",    true,  false },
  { u8"Northern Sierra Miwok",                                      "nsq",     "",   "",    false, false },
  { u8"Northern Sorsoganon",                                        "bks",     "",   "",    false, false },
  { u8"Northern Subanen",                                           "stb",     "",   "",    false, false },
  { u8"Northern Tarahumara",                                        "thh",     "",   "",    false, false },
  { u8"Northern Tasmanian",                                         "xpv",     "",   "",    false, false },
  { u8"Northern Tepehuan",                                          "ntp",     "",   "",    false, false },
  { u8"Northern Thai",                                              "nod",     "",   "",    false, false },
  { u8"Northern Tidung",                                            "ntd",     "",   "",    false, false },
  { u8"Northern Tiwa",                                              "twf",     "",   "",    false, false },
  { u8"Northern Tlaxiaco Mixtec",                                   "xtn",     "",   "",    false, false },
  { u8"Northern Toussian",                                          "tsp",     "",   "",    false, false },
  { u8"Northern Tujia",                                             "tji",     "",   "",    false, false },
  { u8"Northern Tutchone",                                          "ttm",     "",   "",    false, false },
  { u8"Northern Uzbek",                                             "uzn",     "",   "",    false, false },
  { u8"Northern Yukaghir",                                          "ykg",     "",   "",    false, false },
  { u8"Northwest Alaska Inupiatun",                                 "esk",     "",   "",    false, false },
  { u8"Northwest Gbaya",                                            "gya",     "",   "",    false, false },
  { u8"Northwest Maidu",                                            "mjd",     "",   "",    false, false },
  { u8"Northwest Oaxaca Mixtec",                                    "mxa",     "",   "",    false, false },
  { u8"Northwest Pashai",                                           "glh",     "",   "",    false, false },
  { u8"Northwestern Dinka",                                         "diw",     "",   "",    false, false },
  { u8"Northwestern Fars",                                          "faz",     "",   "",    false, false },
  { u8"Northwestern Kolami",                                        "kfb",     "",   "",    false, false },
  { u8"Northwestern Nisu",                                          "nsf",     "",   "",    false, false },
  { u8"Northwestern Ojibwa",                                        "ojb",     "",   "",    false, false },
  { u8"Northwestern Tamang",                                        "tmk",     "",   "",    false, false },
  { u8"Northwestern Tasmanian",                                     "xpw",     "",   "",    false, false },
  { u8"Norwegian Bokmål",                                           "nob",     "nb", "",    true,  false },
  { u8"Norwegian Nynorsk",                                          "nno",     "nn", "",    true,  false },
  { u8"Norwegian Sign Language",                                    "nsl",     "",   "",    false, false },
  { u8"Norwegian",                                                  "nor",     "no", "",    true,  false },
  { u8"Notre",                                                      "bly",     "",   "",    false, false },
  { u8"Notsi",                                                      "ncf",     "",   "",    false, false },
  { u8"Nottoway",                                                   "ntw",     "",   "",    false, false },
  { u8"Nottoway-Meherrin",                                          "nwy",     "",   "",    false, false },
  { u8"Novial",                                                     "nov",     "",   "",    false, false },
  { u8"Noy",                                                        "noy",     "",   "",    false, false },
  { u8"Nsenga",                                                     "nse",     "",   "",    false, false },
  { u8"Nshi",                                                       "nsc",     "",   "",    false, false },
  { u8"Nsongo",                                                     "nsx",     "",   "",    false, false },
  { u8"Ntcham",                                                     "bud",     "",   "",    false, false },
  { u8"Nteng",                                                      "nqt",     "",   "",    false, false },
  { u8"Ntomba",                                                     "nto",     "",   "",    false, false },
  { u8"Nubaca",                                                     "baf",     "",   "",    false, false },
  { u8"Nubi",                                                       "kcn",     "",   "",    false, false },
  { u8"Nubian languages",                                           "nub",     "",   "",    true,  false },
  { u8"Nubri",                                                      "kte",     "",   "",    false, false },
  { u8"Nuer",                                                       "nus",     "",   "",    false, false },
  { u8"Nugunu (Australia)",                                         "nnv",     "",   "",    false, false },
  { u8"Nugunu (Cameroon)",                                          "yas",     "",   "",    false, false },
  { u8"Nuk",                                                        "noc",     "",   "",    false, false },
  { u8"Nukak Makú",                                                 "mbr",     "",   "",    false, false },
  { u8"Nukna",                                                      "klt",     "",   "",    false, false },
  { u8"Nukuini",                                                    "nuc",     "",   "",    false, false },
  { u8"Nukumanu",                                                   "nuq",     "",   "",    false, false },
  { u8"Nukunul",                                                    "xnu",     "",   "",    false, false },
  { u8"Nukuoro",                                                    "nkr",     "",   "",    false, false },
  { u8"Nukuria",                                                    "nur",     "",   "",    false, false },
  { u8"Numana",                                                     "nbr",     "",   "",    false, false },
  { u8"Numanggang",                                                 "nop",     "",   "",    false, false },
  { u8"Numbami",                                                    "sij",     "",   "",    false, false },
  { u8"Nume",                                                       "tgs",     "",   "",    false, false },
  { u8"Numidian",                                                   "nxm",     "",   "",    false, false },
  { u8"Numèè",                                                      "kdk",     "",   "",    false, false },
  { u8"Nung (Viet Nam)",                                            "nut",     "",   "",    false, false },
  { u8"Nungali",                                                    "nug",     "",   "",    false, false },
  { u8"Nunggubuyu",                                                 "nuy",     "",   "",    false, false },
  { u8"Nungu",                                                      "rin",     "",   "",    false, false },
  { u8"Nupbikha",                                                   "npb",     "",   "",    false, false },
  { u8"Nupe-Nupe-Tako",                                             "nup",     "",   "",    false, false },
  { u8"Nusa Laut",                                                  "nul",     "",   "",    false, false },
  { u8"Nusu",                                                       "nuf",     "",   "",    false, false },
  { u8"Nuu-chah-nulth",                                             "nuk",     "",   "",    false, false },
  { u8"Nyabwa",                                                     "nwb",     "",   "",    false, false },
  { u8"Nyaheun",                                                    "nev",     "",   "",    false, false },
  { u8"Nyahkur",                                                    "cbn",     "",   "",    false, false },
  { u8"Nyakyusa-Ngonde",                                            "nyy",     "",   "",    false, false },
  { u8"Nyali",                                                      "nlj",     "",   "",    false, false },
  { u8"Nyam",                                                       "nmi",     "",   "",    false, false },
  { u8"Nyamal",                                                     "nly",     "",   "",    false, false },
  { u8"Nyambo",                                                     "now",     "",   "",    false, false },
  { u8"Nyamusa-Molo",                                               "nwm",     "",   "",    false, false },
  { u8"Nyamwanga",                                                  "mwn",     "",   "",    false, false },
  { u8"Nyamwezi",                                                   "nym",     "",   "",    true,  false },
  { u8"Nyaneka",                                                    "nyk",     "",   "",    false, false },
  { u8"Nyang'i",                                                    "nyp",     "",   "",    false, false },
  { u8"Nyanga",                                                     "nyj",     "",   "",    false, false },
  { u8"Nyanga-li",                                                  "nyc",     "",   "",    false, false },
  { u8"Nyangatom",                                                  "nnj",     "",   "",    false, false },
  { u8"Nyangbo",                                                    "nyb",     "",   "",    false, false },
  { u8"Nyangga",                                                    "nny",     "",   "",    false, false },
  { u8"Nyangumarta",                                                "nna",     "",   "",    false, false },
  { u8"Nyanja",                                                     "nya",     "ny", "",    true,  false },
  { u8"Nyankole",                                                   "nyn",     "",   "",    true,  false },
  { u8"Nyankpa",                                                    "yes",     "",   "",    false, false },
  { u8"Nyarafolo Senoufo",                                          "sev",     "",   "",    false, false },
  { u8"Nyaturu",                                                    "rim",     "",   "",    false, false },
  { u8"Nyaw",                                                       "nyw",     "",   "",    false, false },
  { u8"Nyawaygi",                                                   "nyt",     "",   "",    false, false },
  { u8"Nyemba",                                                     "nba",     "",   "",    false, false },
  { u8"Nyengo",                                                     "nye",     "",   "",    false, false },
  { u8"Nyenkha",                                                    "neh",     "",   "",    false, false },
  { u8"Nyeu",                                                       "nyl",     "",   "",    false, false },
  { u8"Nyiha (Malawi)",                                             "nyr",     "",   "",    false, false },
  { u8"Nyiha (Tanzania)",                                           "nih",     "",   "",    false, false },
  { u8"Nyika (Malawi and Zambia)",                                  "nkv",     "",   "",    false, false },
  { u8"Nyika (Tanzania)",                                           "nkt",     "",   "",    false, false },
  { u8"Nyikina",                                                    "nyh",     "",   "",    false, false },
  { u8"Nyindrou",                                                   "lid",     "",   "",    false, false },
  { u8"Nyindu",                                                     "nyg",     "",   "",    false, false },
  { u8"Nyishi",                                                     "njz",     "",   "",    false, false },
  { u8"Nyiyaparli",                                                 "xny",     "",   "",    false, false },
  { u8"Nyokon",                                                     "nvo",     "",   "",    false, false },
  { u8"Nyole",                                                      "nuj",     "",   "",    false, false },
  { u8"Nyong",                                                      "muo",     "",   "",    false, false },
  { u8"Nyore",                                                      "nyd",     "",   "",    false, false },
  { u8"Nyoro",                                                      "nyo",     "",   "",    true,  false },
  { u8"Nyulnyul",                                                   "nyv",     "",   "",    false, false },
  { u8"Nyungar",                                                    "nys",     "",   "",    false, false },
  { u8"Nyungwe",                                                    "nyu",     "",   "",    false, false },
  { u8"Nyâlayu",                                                    "yly",     "",   "",    false, false },
  { u8"Nzadi",                                                      "nzd",     "",   "",    false, false },
  { u8"Nzakambay",                                                  "nzy",     "",   "",    false, false },
  { u8"Nzakara",                                                    "nzk",     "",   "",    false, false },
  { u8"Nzanyi",                                                     "nja",     "",   "",    false, false },
  { u8"Nzima",                                                      "nzi",     "",   "",    true,  false },
  { u8"Ná-Meo",                                                     "neo",     "",   "",    false, false },
  { u8"Nêlêmwa-Nixumwak",                                           "nee",     "",   "",    false, false },
  { u8"Nüpode Huitoto",                                             "hux",     "",   "",    false, false },
  { u8"Nǁng",                                                       "ngh",     "",   "",    false, false },
  { u8"O'chi'chi'",                                                 "xoc",     "",   "",    false, false },
  { u8"O'du",                                                       "tyh",     "",   "",    false, false },
  { u8"Obanliku",                                                   "bzy",     "",   "",    false, false },
  { u8"Obispeño",                                                   "obi",     "",   "",    false, false },
  { u8"Oblo",                                                       "obl",     "",   "",    false, false },
  { u8"Obo Manobo",                                                 "obo",     "",   "",    false, false },
  { u8"Obokuitai",                                                  "afz",     "",   "",    false, false },
  { u8"Obolo",                                                      "ann",     "",   "",    false, false },
  { u8"Obulom",                                                     "obu",     "",   "",    false, false },
  { u8"Ocaina",                                                     "oca",     "",   "",    false, false },
  { u8"Occitan (post 1500)",                                        "oci",     "oc", "",    true,  false },
  { u8"Ocotepec Mixtec",                                            "mie",     "",   "",    false, false },
  { u8"Ocotlán Zapotec",                                            "zac",     "",   "",    false, false },
  { u8"Od",                                                         "odk",     "",   "",    false, false },
  { u8"Odia",                                                       "ory",     "",   "",    false, false },
  { u8"Odiai",                                                      "bhf",     "",   "",    false, false },
  { u8"Odoodee",                                                    "kkc",     "",   "",    false, false },
  { u8"Odual",                                                      "odu",     "",   "",    false, false },
  { u8"Odut",                                                       "oda",     "",   "",    false, false },
  { u8"Ofayé",                                                      "opy",     "",   "",    false, false },
  { u8"Official Aramaic (700-300 BCE)",                             "arc",     "",   "",    true,  false },
  { u8"Ofo",                                                        "ofo",     "",   "",    false, false },
  { u8"Ogbah",                                                      "ogc",     "",   "",    false, false },
  { u8"Ogbia",                                                      "ogb",     "",   "",    false, false },
  { u8"Ogbogolo",                                                   "ogg",     "",   "",    false, false },
  { u8"Ogbronuagum",                                                "ogu",     "",   "",    false, false },
  { u8"Ogea",                                                       "eri",     "",   "",    false, false },
  { u8"Oirata",                                                     "oia",     "",   "",    false, false },
  { u8"Ojibwa",                                                     "oji",     "oj", "",    true,  false },
  { u8"Ojitlán Chinantec",                                          "chj",     "",   "",    false, false },
  { u8"Okanagan",                                                   "oka",     "",   "",    false, false },
  { u8"Oki-No-Erabu",                                               "okn",     "",   "",    false, false },
  { u8"Okiek",                                                      "oki",     "",   "",    false, false },
  { u8"Oko-Eni-Osayen",                                             "oks",     "",   "",    false, false },
  { u8"Oko-Juwoi",                                                  "okj",     "",   "",    false, false },
  { u8"Okobo",                                                      "okb",     "",   "",    false, false },
  { u8"Okodia",                                                     "okd",     "",   "",    false, false },
  { u8"Okolie",                                                     "oie",     "",   "",    false, false },
  { u8"Okolod",                                                     "kqv",     "",   "",    false, false },
  { u8"Okpamheri",                                                  "opa",     "",   "",    false, false },
  { u8"Okpe (Northwestern Edo)",                                    "okx",     "",   "",    false, false },
  { u8"Okpe (Southwestern Edo)",                                    "oke",     "",   "",    false, false },
  { u8"Oksapmin",                                                   "opm",     "",   "",    false, false },
  { u8"Oku",                                                        "oku",     "",   "",    false, false },
  { u8"Old Aramaic (up to 700 BCE)",                                "oar",     "",   "",    false, false },
  { u8"Old Avar",                                                   "oav",     "",   "",    false, false },
  { u8"Old Breton",                                                 "obt",     "",   "",    false, false },
  { u8"Old Burmese",                                                "obr",     "",   "",    false, false },
  { u8"Old Cham",                                                   "ocm",     "",   "",    false, false },
  { u8"Old Chinese",                                                "och",     "",   "",    false, false },
  { u8"Old Cornish",                                                "oco",     "",   "",    false, false },
  { u8"Old Dutch",                                                  "odt",     "",   "",    false, false },
  { u8"Old English (ca. 450-1100)",                                 "ang",     "",   "",    true,  false },
  { u8"Old French (842-ca. 1400)",                                  "fro",     "",   "",    true,  false },
  { u8"Old Frisian",                                                "ofs",     "",   "",    false, false },
  { u8"Old Georgian",                                               "oge",     "",   "",    false, false },
  { u8"Old High German (ca. 750-1050)",                             "goh",     "",   "",    true,  false },
  { u8"Old Hittite",                                                "oht",     "",   "",    false, false },
  { u8"Old Hungarian",                                              "ohu",     "",   "",    false, false },
  { u8"Old Irish (to 900)",                                         "sga",     "",   "",    true,  false },
  { u8"Old Japanese",                                               "ojp",     "",   "",    false, false },
  { u8"Old Kentish Sign Language",                                  "okl",     "",   "",    false, false },
  { u8"Old Khmer",                                                  "okz",     "",   "",    false, false },
  { u8"Old Korean (3rd-9th cent.)",                                 "oko",     "",   "",    false, false },
  { u8"Old Lithuanian",                                             "olt",     "",   "",    false, false },
  { u8"Old Malay",                                                  "omy",     "",   "",    false, false },
  { u8"Old Manipuri",                                               "omp",     "",   "",    false, false },
  { u8"Old Marathi",                                                "omr",     "",   "",    false, false },
  { u8"Old Mon",                                                    "omx",     "",   "",    false, false },
  { u8"Old Norse",                                                  "non",     "",   "",    true,  false },
  { u8"Old Nubian",                                                 "onw",     "",   "",    false, false },
  { u8"Old Ossetic",                                                "oos",     "",   "",    false, false },
  { u8"Old Persian (ca. 600-400 B.C.)",                             "peo",     "",   "",    true,  false },
  { u8"Old Provençal (to 1500)",                                    "pro",     "",   "",    true,  false },
  { u8"Old Russian",                                                "orv",     "",   "",    false, false },
  { u8"Old Saxon",                                                  "osx",     "",   "",    false, false },
  { u8"Old Spanish",                                                "osp",     "",   "",    false, false },
  { u8"Old Sundanese",                                              "osn",     "",   "",    false, false },
  { u8"Old Tamil",                                                  "oty",     "",   "",    false, false },
  { u8"Old Tibetan",                                                "otb",     "",   "",    false, false },
  { u8"Old Turkish",                                                "otk",     "",   "",    false, false },
  { u8"Old Uighur",                                                 "oui",     "",   "",    false, false },
  { u8"Old Welsh",                                                  "owl",     "",   "",    false, false },
  { u8"Olekha",                                                     "ole",     "",   "",    false, false },
  { u8"Olkol",                                                      "olk",     "",   "",    false, false },
  { u8"Olo",                                                        "ong",     "",   "",    false, false },
  { u8"Oloma",                                                      "olm",     "",   "",    false, false },
  { u8"Olrat",                                                      "olr",     "",   "",    false, false },
  { u8"Olu'bo",                                                     "lul",     "",   "",    false, false },
  { u8"Olulumo-Ikom",                                               "iko",     "",   "",    false, false },
  { u8"Oluta Popoluca",                                             "plo",     "",   "",    false, false },
  { u8"Omagua",                                                     "omg",     "",   "",    false, false },
  { u8"Omaha-Ponca",                                                "oma",     "",   "",    false, false },
  { u8"Omani Arabic",                                               "acx",     "",   "",    false, false },
  { u8"Omati",                                                      "mgx",     "",   "",    false, true  },
  { u8"Ombamba",                                                    "mbm",     "",   "",    false, false },
  { u8"Ombo",                                                       "oml",     "",   "",    false, false },
  { u8"Omejes",                                                     "ome",     "",   "",    false, true  },
  { u8"Ometepec Nahuatl",                                           "nht",     "",   "",    false, false },
  { u8"Omi",                                                        "omi",     "",   "",    false, false },
  { u8"Omok",                                                       "omk",     "",   "",    false, false },
  { u8"Omotic languages",                                           "omv",     "",   "",    false, false },
  { u8"Omotik",                                                     "omt",     "",   "",    false, false },
  { u8"Omurano",                                                    "omu",     "",   "",    false, false },
  { u8"Ona",                                                        "ona",     "",   "",    false, false },
  { u8"Oneida",                                                     "one",     "",   "",    false, false },
  { u8"Ong",                                                        "oog",     "",   "",    false, false },
  { u8"Onin Based Pidgin",                                          "onx",     "",   "",    false, false },
  { u8"Onin",                                                       "oni",     "",   "",    false, false },
  { u8"Onjob",                                                      "onj",     "",   "",    false, false },
  { u8"Ono",                                                        "ons",     "",   "",    false, false },
  { u8"Onobasulu",                                                  "onn",     "",   "",    false, false },
  { u8"Onondaga",                                                   "ono",     "",   "",    false, false },
  { u8"Ontenu",                                                     "ont",     "",   "",    false, false },
  { u8"Ontong Java",                                                "ojv",     "",   "",    false, false },
  { u8"Oorlams",                                                    "oor",     "",   "",    false, false },
  { u8"Opao",                                                       "opo",     "",   "",    false, false },
  { u8"Opata",                                                      "opt",     "",   "",    false, false },
  { u8"Orang Kanaq",                                                "orn",     "",   "",    false, false },
  { u8"Orang Seletar",                                              "ors",     "",   "",    false, false },
  { u8"Oraon Sadri",                                                "sdr",     "",   "",    false, false },
  { u8"Orejón",                                                     "ore",     "",   "",    false, false },
  { u8"Oring",                                                      "org",     "",   "",    false, false },
  { u8"Oriya (macrolanguage)",                                      "ori",     "or", "",    true,  false },
  { u8"Orizaba Nahuatl",                                            "nlv",     "",   "",    false, false },
  { u8"Orma",                                                       "orc",     "",   "",    false, false },
  { u8"Ormu",                                                       "orz",     "",   "",    false, false },
  { u8"Ormuri",                                                     "oru",     "",   "",    false, false },
  { u8"Oro Win",                                                    "orw",     "",   "",    false, false },
  { u8"Oro",                                                        "orx",     "",   "",    false, false },
  { u8"Oroch",                                                      "oac",     "",   "",    false, false },
  { u8"Oroha",                                                      "ora",     "",   "",    false, false },
  { u8"Orok",                                                       "oaa",     "",   "",    false, false },
  { u8"Orokaiva",                                                   "okv",     "",   "",    false, false },
  { u8"Oroko",                                                      "bdu",     "",   "",    false, false },
  { u8"Orokolo",                                                    "oro",     "",   "",    false, false },
  { u8"Oromo",                                                      "orm",     "om", "",    true,  false },
  { u8"Oroqen",                                                     "orh",     "",   "",    false, false },
  { u8"Orowe",                                                      "bpk",     "",   "",    false, false },
  { u8"Oruma",                                                      "orr",     "",   "",    false, false },
  { u8"Orya",                                                       "ury",     "",   "",    false, false },
  { u8"Osage",                                                      "osa",     "",   "",    true,  false },
  { u8"Osatu",                                                      "ost",     "",   "",    false, false },
  { u8"Oscan",                                                      "osc",     "",   "",    false, false },
  { u8"Osing",                                                      "osi",     "",   "",    false, false },
  { u8"Ososo",                                                      "oso",     "",   "",    false, false },
  { u8"Ossetian",                                                   "oss",     "os", "",    true,  false },
  { u8"Ot Danum",                                                   "otd",     "",   "",    false, false },
  { u8"Otank",                                                      "uta",     "",   "",    false, false },
  { u8"Oti",                                                        "oti",     "",   "",    false, false },
  { u8"Oto-Manguean languages",                                     "omq",     "",   "",    false, false },
  { u8"Otomian languages",                                          "oto",     "",   "",    true,  false },
  { u8"Otoro",                                                      "otr",     "",   "",    false, false },
  { u8"Ottawa",                                                     "otw",     "",   "",    false, false },
  { u8"Ottoman Turkish (1500-1928)",                                "ota",     "",   "",    true,  false },
  { u8"Otuho",                                                      "lot",     "",   "",    false, false },
  { u8"Otuke",                                                      "otu",     "",   "",    false, false },
  { u8"Ouma",                                                       "oum",     "",   "",    false, false },
  { u8"Oune",                                                       "oue",     "",   "",    false, false },
  { u8"Owa",                                                        "stn",     "",   "",    false, false },
  { u8"Owenia",                                                     "wsr",     "",   "",    false, false },
  { u8"Owiniga",                                                    "owi",     "",   "",    false, false },
  { u8"Oy",                                                         "oyb",     "",   "",    false, false },
  { u8"Oya'oya",                                                    "oyy",     "",   "",    false, false },
  { u8"Oyda",                                                       "oyd",     "",   "",    false, false },
  { u8"Oyster Bay Tasmanian",                                       "xpd",     "",   "",    false, false },
  { u8"Ozolotepec Zapotec",                                         "zao",     "",   "",    false, false },
  { u8"Ozumacín Chinantec",                                         "chz",     "",   "",    false, false },
  { u8"Pa Di",                                                      "pdi",     "",   "",    false, false },
  { u8"Pa'a",                                                       "pqa",     "",   "",    false, false },
  { u8"Pa'o Karen",                                                 "blk",     "",   "",    false, false },
  { u8"Pa-Hng",                                                     "pha",     "",   "",    false, false },
  { u8"Paakantyi",                                                  "drl",     "",   "",    false, false },
  { u8"Paama",                                                      "pma",     "",   "",    false, false },
  { u8"Paasaal",                                                    "sig",     "",   "",    false, false },
  { u8"Pacahuara",                                                  "pcp",     "",   "",    false, false },
  { u8"Pacaraos Quechua",                                           "qvp",     "",   "",    false, false },
  { u8"Pacific Gulf Yupik",                                         "ems",     "",   "",    false, false },
  { u8"Pacoh",                                                      "pac",     "",   "",    false, false },
  { u8"Padoe",                                                      "pdo",     "",   "",    false, false },
  { u8"Paekche",                                                    "pkc",     "",   "",    false, false },
  { u8"Paelignian",                                                 "pgn",     "",   "",    false, false },
  { u8"Pagi",                                                       "pgi",     "",   "",    false, false },
  { u8"Pagibete",                                                   "pae",     "",   "",    false, false },
  { u8"Pagu",                                                       "pgu",     "",   "",    false, false },
  { u8"Pahanan Agta",                                               "apf",     "",   "",    false, false },
  { u8"Pahari",                                                     "phj",     "",   "",    false, false },
  { u8"Pahari-Potwari",                                             "phr",     "",   "",    false, false },
  { u8"Pahi",                                                       "lgt",     "",   "",    false, false },
  { u8"Pahlavani",                                                  "phv",     "",   "",    false, false },
  { u8"Pahlavi",                                                    "pal",     "",   "",    true,  false },
  { u8"Pai Tavytera",                                               "pta",     "",   "",    false, false },
  { u8"Paicî",                                                      "pri",     "",   "",    false, false },
  { u8"Paipai",                                                     "ppi",     "",   "",    false, false },
  { u8"Paite Chin",                                                 "pck",     "",   "",    false, false },
  { u8"Paiwan",                                                     "pwn",     "",   "",    false, false },
  { u8"Pak-Tong",                                                   "pkg",     "",   "",    false, false },
  { u8"Pakanha",                                                    "pkn",     "",   "",    false, false },
  { u8"Pakaásnovos",                                                "pav",     "",   "",    false, false },
  { u8"Pakistan Sign Language",                                     "pks",     "",   "",    false, false },
  { u8"Paku Karen",                                                 "jkp",     "",   "",    false, false },
  { u8"Paku Karen",                                                 "kpp",     "",   "",    false, true  },
  { u8"Paku",                                                       "pku",     "",   "",    false, false },
  { u8"Pal",                                                        "abw",     "",   "",    false, false },
  { u8"Palaic",                                                     "plq",     "",   "",    false, false },
  { u8"Palaka Senoufo",                                             "plr",     "",   "",    false, false },
  { u8"Palantla Chinantec",                                         "cpa",     "",   "",    false, false },
  { u8"Palauan",                                                    "pau",     "",   "",    true,  false },
  { u8"Paleni",                                                     "pnl",     "",   "",    false, false },
  { u8"Palenquero",                                                 "pln",     "",   "",    false, false },
  { u8"Pali",                                                       "pli",     "pi", "",    true,  false },
  { u8"Palikúr",                                                    "plu",     "",   "",    false, false },
  { u8"Paliyan",                                                    "pcf",     "",   "",    false, false },
  { u8"Pallanganmiddang",                                           "pmd",     "",   "",    false, false },
  { u8"Paloor",                                                     "fap",     "",   "",    false, false },
  { u8"Palpa",                                                      "plp",     "",   "",    false, true  },
  { u8"Palu",                                                       "pbz",     "",   "",    false, true  },
  { u8"Palu'e",                                                     "ple",     "",   "",    false, false },
  { u8"Paluan",                                                     "plz",     "",   "",    false, false },
  { u8"Palumata",                                                   "pmc",     "",   "",    false, true  },
  { u8"Palya Bareli",                                               "bpx",     "",   "",    false, false },
  { u8"Pam",                                                        "pmn",     "",   "",    false, false },
  { u8"Pambia",                                                     "pmb",     "",   "",    false, false },
  { u8"Pamlico",                                                    "pmk",     "",   "",    false, false },
  { u8"Pamona",                                                     "pmf",     "",   "",    false, false },
  { u8"Pamosu",                                                     "hih",     "",   "",    false, false },
  { u8"Pampanga",                                                   "pam",     "",   "",    true,  false },
  { u8"Pamplona Atta",                                              "att",     "",   "",    false, false },
  { u8"Pana (Burkina Faso)",                                        "pnq",     "",   "",    false, false },
  { u8"Pana (Central African Republic)",                            "pnz",     "",   "",    false, false },
  { u8"Panamanian Sign Language",                                   "lsp",     "",   "",    false, false },
  { u8"Panamint",                                                   "par",     "",   "",    false, false },
  { u8"Panang",                                                     "pcr",     "",   "",    false, true  },
  { u8"Panao Huánuco Quechua",                                      "qxh",     "",   "",    false, false },
  { u8"Panará",                                                     "kre",     "",   "",    false, false },
  { u8"Panasuan",                                                   "psn",     "",   "",    false, false },
  { u8"Panawa",                                                     "pwb",     "",   "",    false, false },
  { u8"Pancana",                                                    "pnp",     "",   "",    false, false },
  { u8"Panchpargania",                                              "tdb",     "",   "",    false, false },
  { u8"Pande",                                                      "bkj",     "",   "",    false, false },
  { u8"Pangasinan",                                                 "pag",     "",   "",    true,  false },
  { u8"Pangseng",                                                   "pgs",     "",   "",    false, false },
  { u8"Pangu",                                                      "png",     "",   "",    false, false },
  { u8"Pangutaran Sama",                                            "slm",     "",   "",    false, false },
  { u8"Pangwa",                                                     "pbr",     "",   "",    false, false },
  { u8"Pangwali",                                                   "pgg",     "",   "",    false, false },
  { u8"Panim",                                                      "pnr",     "",   "",    false, false },
  { u8"Paniya",                                                     "pcg",     "",   "",    false, false },
  { u8"Panjabi",                                                    "pan",     "pa", "",    true,  false },
  { u8"Pankararé",                                                  "pax",     "",   "",    false, false },
  { u8"Pankararú",                                                  "paz",     "",   "",    false, false },
  { u8"Pankhu",                                                     "pkh",     "",   "",    false, false },
  { u8"Pannei",                                                     "pnc",     "",   "",    false, false },
  { u8"Pano",                                                       "mqz",     "",   "",    false, false },
  { u8"Panoan Katukína",                                            "knt",     "",   "",    false, false },
  { u8"Panobo",                                                     "pno",     "",   "",    false, false },
  { u8"Panyi Bai",                                                  "bfc",     "",   "",    false, false },
  { u8"Pao",                                                        "ppa",     "",   "",    false, true  },
  { u8"Papantla Totonac",                                           "top",     "",   "",    false, false },
  { u8"Papapana",                                                   "ppn",     "",   "",    false, false },
  { u8"Papar",                                                      "dpp",     "",   "",    false, false },
  { u8"Papasena",                                                   "pas",     "",   "",    false, false },
  { u8"Papel",                                                      "pbo",     "",   "",    false, false },
  { u8"Papi",                                                       "ppe",     "",   "",    false, false },
  { u8"Papiamento",                                                 "pap",     "",   "",    true,  false },
  { u8"Papitalai",                                                  "pat",     "",   "",    false, true  },
  { u8"Papora",                                                     "ppu",     "",   "",    false, false },
  { u8"Papua New Guinean Sign Language",                            "pgz",     "",   "",    false, false },
  { u8"Papuan Malay",                                               "pmy",     "",   "",    false, false },
  { u8"Papuan languages",                                           "paa",     "",   "",    true,  false },
  { u8"Papuma",                                                     "ppm",     "",   "",    false, false },
  { u8"Parachi",                                                    "prc",     "",   "",    false, false },
  { u8"Paraguayan Guaraní",                                         "gug",     "",   "",    false, false },
  { u8"Paraguayan Sign Language",                                   "pys",     "",   "",    false, false },
  { u8"Parakanã",                                                   "pak",     "",   "",    false, false },
  { u8"Paranan",                                                    "agp",     "",   "",    false, true  },
  { u8"Paranan",                                                    "prf",     "",   "",    false, false },
  { u8"Paranawát",                                                  "paf",     "",   "",    false, false },
  { u8"Paraujano",                                                  "pbg",     "",   "",    false, false },
  { u8"Parauk",                                                     "prk",     "",   "",    false, false },
  { u8"Parawen",                                                    "prw",     "",   "",    false, false },
  { u8"Pardhan",                                                    "pch",     "",   "",    false, false },
  { u8"Pardhi",                                                     "pcl",     "",   "",    false, false },
  { u8"Pare",                                                       "ppt",     "",   "",    false, false },
  { u8"Parecís",                                                    "pab",     "",   "",    false, false },
  { u8"Parenga",                                                    "pcj",     "",   "",    false, false },
  { u8"Parkari Koli",                                               "kvx",     "",   "",    false, false },
  { u8"Parkwa",                                                     "pbi",     "",   "",    false, false },
  { u8"Parsi",                                                      "prp",     "",   "",    false, false },
  { u8"Parsi-Dari",                                                 "prd",     "",   "",    false, false },
  { u8"Parthian",                                                   "xpr",     "",   "",    false, false },
  { u8"Parya",                                                      "paq",     "",   "",    false, false },
  { u8"Pará Arára",                                                 "aap",     "",   "",    false, false },
  { u8"Pará Gavião",                                                "gvp",     "",   "",    false, false },
  { u8"Pasi",                                                       "psq",     "",   "",    false, false },
  { u8"Pass Valley Yali",                                           "yac",     "",   "",    false, false },
  { u8"Patamona",                                                   "pbc",     "",   "",    false, false },
  { u8"Patani",                                                     "ptn",     "",   "",    false, false },
  { u8"Pataxó Hã-Ha-Hãe",                                           "pth",     "",   "",    false, false },
  { u8"Patep",                                                      "ptp",     "",   "",    false, false },
  { u8"Pathiya",                                                    "pty",     "",   "",    false, false },
  { u8"Patpatar",                                                   "gfk",     "",   "",    false, false },
  { u8"Pattani Malay",                                              "mfa",     "",   "",    false, false },
  { u8"Pattani",                                                    "lae",     "",   "",    false, false },
  { u8"Pattapu",                                                    "ptq",     "",   "",    false, false },
  { u8"Patwin",                                                     "pwi",     "",   "",    false, false },
  { u8"Paulohi",                                                    "plh",     "",   "",    false, false },
  { u8"Paumarí",                                                    "pad",     "",   "",    false, false },
  { u8"Paunaka",                                                    "pnk",     "",   "",    false, false },
  { u8"Pauri Bareli",                                               "bfb",     "",   "",    false, false },
  { u8"Pauserna",                                                   "psm",     "",   "",    false, false },
  { u8"Pawaia",                                                     "pwa",     "",   "",    false, false },
  { u8"Pawnee",                                                     "paw",     "",   "",    false, false },
  { u8"Paynamar",                                                   "pmr",     "",   "",    false, false },
  { u8"Pazeh",                                                      "pzh",     "",   "",    false, false },
  { u8"Pe",                                                         "pai",     "",   "",    false, false },
  { u8"Pear",                                                       "pcb",     "",   "",    false, false },
  { u8"Pech",                                                       "pay",     "",   "",    false, false },
  { u8"Pecheneg",                                                   "xpc",     "",   "",    false, false },
  { u8"Pedi",                                                       "nso",     "",   "",    true,  false },
  { u8"Pei",                                                        "ppq",     "",   "",    false, false },
  { u8"Pekal",                                                      "pel",     "",   "",    false, false },
  { u8"Pela",                                                       "bxd",     "",   "",    false, false },
  { u8"Pele-Ata",                                                   "ata",     "",   "",    false, false },
  { u8"Pelende",                                                    "ppp",     "",   "",    false, false },
  { u8"Pemon",                                                      "aoc",     "",   "",    false, false },
  { u8"Penang Sign Language",                                       "psg",     "",   "",    false, false },
  { u8"Penchal",                                                    "pek",     "",   "",    false, false },
  { u8"Pendau",                                                     "ums",     "",   "",    false, false },
  { u8"Pengo",                                                      "peg",     "",   "",    false, false },
  { u8"Pennsylvania German",                                        "pdc",     "",   "",    false, false },
  { u8"Penrhyn",                                                    "pnh",     "",   "",    false, false },
  { u8"Pentlatch",                                                  "ptw",     "",   "",    false, false },
  { u8"Perai",                                                      "wet",     "",   "",    false, false },
  { u8"Peranakan Indonesian",                                       "pea",     "",   "",    false, false },
  { u8"Pere",                                                       "pfe",     "",   "",    false, false },
  { u8"Peripheral Mongolian",                                       "mvf",     "",   "",    false, false },
  { u8"Pero",                                                       "pip",     "",   "",    false, false },
  { u8"Persian",                                                    "per",     "fa", "fas", true,  false },
  { u8"Peruvian Sign Language",                                     "prl",     "",   "",    false, false },
  { u8"Petapa Zapotec",                                             "zpe",     "",   "",    false, false },
  { u8"Petats",                                                     "pex",     "",   "",    false, false },
  { u8"Petjo",                                                      "pey",     "",   "",    false, false },
  { u8"Peñoles Mixtec",                                             "mil",     "",   "",    false, false },
  { u8"Pfaelzisch",                                                 "pfl",     "",   "",    false, false },
  { u8"Phai",                                                       "prt",     "",   "",    false, false },
  { u8"Phake",                                                      "phk",     "",   "",    false, false },
  { u8"Phala",                                                      "ypa",     "",   "",    false, false },
  { u8"Phalura",                                                    "phl",     "",   "",    false, false },
  { u8"Phana'",                                                     "phq",     "",   "",    false, false },
  { u8"Phangduwali",                                                "phw",     "",   "",    false, false },
  { u8"Phende",                                                     "pem",     "",   "",    false, false },
  { u8"Philippine Sign Language",                                   "psp",     "",   "",    false, false },
  { u8"Philippine languages",                                       "phi",     "",   "",    true,  false },
  { u8"Phimbi",                                                     "phm",     "",   "",    false, false },
  { u8"Phoenician",                                                 "phn",     "",   "",    true,  false },
  { u8"Phola",                                                      "ypg",     "",   "",    false, false },
  { u8"Pholo",                                                      "yip",     "",   "",    false, false },
  { u8"Phom Naga",                                                  "nph",     "",   "",    false, false },
  { u8"Phong-Kniang",                                               "pnx",     "",   "",    false, false },
  { u8"Phrae Pwo Karen",                                            "kjt",     "",   "",    false, false },
  { u8"Phrygian",                                                   "xpg",     "",   "",    false, false },
  { u8"Phu Thai",                                                   "pht",     "",   "",    false, false },
  { u8"Phuan",                                                      "phu",     "",   "",    false, false },
  { u8"Phudagi",                                                    "phd",     "",   "",    false, false },
  { u8"Phuie",                                                      "pug",     "",   "",    false, false },
  { u8"Phukha",                                                     "phh",     "",   "",    false, false },
  { u8"Phuma",                                                      "ypm",     "",   "",    false, false },
  { u8"Phunoi",                                                     "pho",     "",   "",    false, false },
  { u8"Phuong",                                                     "phg",     "",   "",    false, false },
  { u8"Phupa",                                                      "ypp",     "",   "",    false, false },
  { u8"Phupha",                                                     "yph",     "",   "",    false, false },
  { u8"Phuza",                                                      "ypz",     "",   "",    false, false },
  { u8"Piamatsina",                                                 "ptr",     "",   "",    false, false },
  { u8"Piame",                                                      "pin",     "",   "",    false, false },
  { u8"Piapoco",                                                    "pio",     "",   "",    false, false },
  { u8"Piaroa",                                                     "pid",     "",   "",    false, false },
  { u8"Picard",                                                     "pcd",     "",   "",    false, false },
  { u8"Pichis Ashéninka",                                           "cpu",     "",   "",    false, false },
  { u8"Pictish",                                                    "xpi",     "",   "",    false, false },
  { u8"Pidgin Delaware",                                            "dep",     "",   "",    false, false },
  { u8"Piemontese",                                                 "pms",     "",   "",    false, false },
  { u8"Pijao",                                                      "pij",     "",   "",    false, false },
  { u8"Pije",                                                       "piz",     "",   "",    false, false },
  { u8"Pijin",                                                      "pis",     "",   "",    false, false },
  { u8"Pilagá",                                                     "plg",     "",   "",    false, false },
  { u8"Pileni",                                                     "piv",     "",   "",    false, false },
  { u8"Pima Bajo",                                                  "pia",     "",   "",    false, false },
  { u8"Pimbwe",                                                     "piw",     "",   "",    false, false },
  { u8"Pinai-Hagahai",                                              "pnn",     "",   "",    false, false },
  { u8"Pindiini",                                                   "pti",     "",   "",    false, false },
  { u8"Pingelapese",                                                "pif",     "",   "",    false, false },
  { u8"Pini",                                                       "pii",     "",   "",    false, true  },
  { u8"Pinigura",                                                   "pnv",     "",   "",    false, false },
  { u8"Pinjarup",                                                   "pnj",     "",   "",    false, false },
  { u8"Pinji",                                                      "pic",     "",   "",    false, false },
  { u8"Pinotepa Nacional Mixtec",                                   "mio",     "",   "",    false, false },
  { u8"Pintupi-Luritja",                                            "piu",     "",   "",    false, false },
  { u8"Pinyin",                                                     "pny",     "",   "",    false, false },
  { u8"Pipil",                                                      "ppl",     "",   "",    false, false },
  { u8"Pirahã",                                                     "myp",     "",   "",    false, false },
  { u8"Piratapuyo",                                                 "pir",     "",   "",    false, false },
  { u8"Pirlatapa",                                                  "bxi",     "",   "",    false, false },
  { u8"Piro",                                                       "pie",     "",   "",    false, false },
  { u8"Pirriya",                                                    "xpa",     "",   "",    false, false },
  { u8"Piru",                                                       "ppr",     "",   "",    false, true  },
  { u8"Pisabo",                                                     "pig",     "",   "",    false, false },
  { u8"Pisaflores Tepehua",                                         "tpp",     "",   "",    false, false },
  { u8"Piscataway",                                                 "psy",     "",   "",    false, false },
  { u8"Pisidian",                                                   "xps",     "",   "",    false, false },
  { u8"Pitcairn-Norfolk",                                           "pih",     "",   "",    false, false },
  { u8"Pite Sami",                                                  "sje",     "",   "",    false, false },
  { u8"Piti",                                                       "pcn",     "",   "",    false, false },
  { u8"Pitjantjatjara",                                             "pjt",     "",   "",    false, false },
  { u8"Pitta Pitta",                                                "pit",     "",   "",    false, false },
  { u8"Piu",                                                        "pix",     "",   "",    false, false },
  { u8"Piya-Kwonci",                                                "piy",     "",   "",    false, false },
  { u8"Plains Cree",                                                "crk",     "",   "",    false, false },
  { u8"Plains Indian Sign Language",                                "psd",     "",   "",    false, false },
  { u8"Plains Miwok",                                               "pmw",     "",   "",    false, false },
  { u8"Plapo Krumen",                                               "ktj",     "",   "",    false, false },
  { u8"Plateau Malagasy",                                           "plt",     "",   "",    false, false },
  { u8"Plautdietsch",                                               "pdt",     "",   "",    false, false },
  { u8"Playero",                                                    "gob",     "",   "",    false, false },
  { u8"Pnar",                                                       "pbv",     "",   "",    false, false },
  { u8"Pochuri Naga",                                               "npo",     "",   "",    false, false },
  { u8"Pochutec",                                                   "xpo",     "",   "",    false, false },
  { u8"Podena",                                                     "pdn",     "",   "",    false, false },
  { u8"Pogolo",                                                     "poy",     "",   "",    false, false },
  { u8"Pohnpeian",                                                  "pon",     "",   "",    true,  false },
  { u8"Pokangá",                                                    "pok",     "",   "",    false, false },
  { u8"Poke",                                                       "pof",     "",   "",    false, false },
  { u8"Pokomo",                                                     "pkb",     "",   "",    false, false },
  { u8"Polabian",                                                   "pox",     "",   "",    false, false },
  { u8"Polari",                                                     "pld",     "",   "",    false, false },
  { u8"Polci",                                                      "plj",     "",   "",    false, false },
  { u8"Polish Sign Language",                                       "pso",     "",   "",    false, false },
  { u8"Polish",                                                     "pol",     "pl", "",    true,  false },
  { u8"Polonombauk",                                                "plb",     "",   "",    false, false },
  { u8"Pom",                                                        "pmo",     "",   "",    false, false },
  { u8"Pomo",                                                       "pmm",     "",   "",    false, false },
  { u8"Ponam",                                                      "ncc",     "",   "",    false, false },
  { u8"Ponares",                                                    "pod",     "",   "",    false, true  },
  { u8"Pongyong",                                                   "pgy",     "",   "",    false, true  },
  { u8"Ponosakan",                                                  "pns",     "",   "",    false, false },
  { u8"Pontic",                                                     "pnt",     "",   "",    false, false },
  { u8"Ponyo-Gongwang Naga",                                        "npg",     "",   "",    false, false },
  { u8"Popti'",                                                     "jac",     "",   "",    false, false },
  { u8"Poqomam",                                                    "poc",     "",   "",    false, false },
  { u8"Poqomchi'",                                                  "poh",     "",   "",    false, false },
  { u8"Porohanon",                                                  "prh",     "",   "",    false, false },
  { u8"Port Sandwich",                                              "psw",     "",   "",    false, false },
  { u8"Port Sorell Tasmanian",                                      "xpl",     "",   "",    false, false },
  { u8"Port Vato",                                                  "ptv",     "",   "",    false, false },
  { u8"Portuguese Sign Language",                                   "psr",     "",   "",    false, false },
  { u8"Portuguese",                                                 "por",     "pt", "",    true,  false },
  { u8"Potawatomi",                                                 "pot",     "",   "",    false, false },
  { u8"Potiguára",                                                  "pog",     "",   "",    false, false },
  { u8"Pottangi Ollar Gadaba",                                      "gdb",     "",   "",    false, false },
  { u8"Poumei Naga",                                                "pmx",     "",   "",    false, false },
  { u8"Pouye",                                                      "bye",     "",   "",    false, false },
  { u8"Powari",                                                     "pwr",     "",   "",    false, false },
  { u8"Powhatan",                                                   "pim",     "",   "",    false, false },
  { u8"Poyanáwa",                                                   "pyn",     "",   "",    false, false },
  { u8"Prakrit languages",                                          "pra",     "",   "",    true,  false },
  { u8"Prasuni",                                                    "prn",     "",   "",    false, false },
  { u8"Pray 3",                                                     "pry",     "",   "",    false, true  },
  { u8"Primitive Irish",                                            "pgl",     "",   "",    false, false },
  { u8"Principense",                                                "pre",     "",   "",    false, false },
  { u8"Providencia Sign Language",                                  "prz",     "",   "",    false, false },
  { u8"Prussian",                                                   "prg",     "",   "",    false, false },
  { u8"Psikye",                                                     "kvj",     "",   "",    false, false },
  { u8"Pu Ko",                                                      "puk",     "",   "",    false, true  },
  { u8"Pu-Xian Chinese",                                            "cpx",     "",   "",    false, false },
  { u8"Puare",                                                      "pux",     "",   "",    false, false },
  { u8"Pudtol Atta",                                                "atp",     "",   "",    false, false },
  { u8"Puebla Mazatec",                                             "pbm",     "",   "",    false, false },
  { u8"Puelche",                                                    "pue",     "",   "",    false, false },
  { u8"Puerto Rican Sign Language",                                 "psl",     "",   "",    false, false },
  { u8"Puimei Naga",                                                "npu",     "",   "",    false, false },
  { u8"Puinave",                                                    "pui",     "",   "",    false, false },
  { u8"Pukapuka",                                                   "pkp",     "",   "",    false, false },
  { u8"Pulaar",                                                     "fuc",     "",   "",    false, false },
  { u8"Pulabu",                                                     "pup",     "",   "",    false, false },
  { u8"Pular",                                                      "fuf",     "",   "",    false, false },
  { u8"Puluwatese",                                                 "puw",     "",   "",    false, false },
  { u8"Puma",                                                       "pum",     "",   "",    false, false },
  { u8"Pumpokol",                                                   "xpm",     "",   "",    false, false },
  { u8"Pumé",                                                       "yae",     "",   "",    false, false },
  { u8"Punan Aput",                                                 "pud",     "",   "",    false, false },
  { u8"Punan Bah-Biau",                                             "pna",     "",   "",    false, false },
  { u8"Punan Batu 1",                                               "pnm",     "",   "",    false, false },
  { u8"Punan Merah",                                                "puf",     "",   "",    false, false },
  { u8"Punan Merap",                                                "puc",     "",   "",    false, false },
  { u8"Punan Tubu",                                                 "puj",     "",   "",    false, false },
  { u8"Punic",                                                      "xpu",     "",   "",    false, false },
  { u8"Puno Quechua",                                               "qxp",     "",   "",    false, false },
  { u8"Punthamara",                                                 "xpt",     "",   "",    false, false },
  { u8"Punu",                                                       "puu",     "",   "",    false, false },
  { u8"Puoc",                                                       "puo",     "",   "",    false, false },
  { u8"Puquina",                                                    "puq",     "",   "",    false, false },
  { u8"Puragi",                                                     "pru",     "",   "",    false, false },
  { u8"Purari",                                                     "iar",     "",   "",    false, false },
  { u8"Purepecha",                                                  "tsz",     "",   "",    false, false },
  { u8"Puri",                                                       "prr",     "",   "",    false, false },
  { u8"Purik",                                                      "prx",     "",   "",    false, false },
  { u8"Purisimeño",                                                 "puy",     "",   "",    false, false },
  { u8"Puroik",                                                     "suv",     "",   "",    false, false },
  { u8"Puruborá",                                                   "pur",     "",   "",    false, false },
  { u8"Purum Naga",                                                 "puz",     "",   "",    false, true  },
  { u8"Purum",                                                      "pub",     "",   "",    false, false },
  { u8"Pushto",                                                     "pus",     "ps", "",    true,  false },
  { u8"Putai",                                                      "mfl",     "",   "",    false, false },
  { u8"Putoh",                                                      "put",     "",   "",    false, false },
  { u8"Putukwam",                                                   "afe",     "",   "",    false, false },
  { u8"Puyo",                                                       "xpy",     "",   "",    false, false },
  { u8"Puyo-Paekche",                                               "xpp",     "",   "",    false, false },
  { u8"Puyuma",                                                     "pyu",     "",   "",    false, false },
  { u8"Pwaamei",                                                    "pme",     "",   "",    false, false },
  { u8"Pwapwâ",                                                     "pop",     "",   "",    false, false },
  { u8"Pwo Eastern Karen",                                          "kjp",     "",   "",    false, false },
  { u8"Pwo Northern Karen",                                         "pww",     "",   "",    false, false },
  { u8"Pwo Western Karen",                                          "pwo",     "",   "",    false, false },
  { u8"Pyapun",                                                     "pcw",     "",   "",    false, false },
  { u8"Pye Krumen",                                                 "pye",     "",   "",    false, false },
  { u8"Pyen",                                                       "pyy",     "",   "",    false, false },
  { u8"Pyu (Myanmar)",                                              "pyx",     "",   "",    false, false },
  { u8"Pyu (Papua New Guinea)",                                     "pby",     "",   "",    false, false },
  { u8"Páez",                                                       "pbb",     "",   "",    false, false },
  { u8"Pááfang",                                                    "pfa",     "",   "",    false, false },
  { u8"Päri",                                                       "lkr",     "",   "",    false, false },
  { u8"Pémono",                                                     "pev",     "",   "",    false, false },
  { u8"Pévé",                                                       "lme",     "",   "",    false, false },
  { u8"Pökoot",                                                     "pko",     "",   "",    false, false },
  { u8"Q'anjob'al",                                                 "kjb",     "",   "",    false, false },
  { u8"Qabiao",                                                     "laq",     "",   "",    false, false },
  { u8"Qaqet",                                                      "byx",     "",   "",    false, false },
  { u8"Qashqa'i",                                                   "qxq",     "",   "",    false, false },
  { u8"Qatabanian",                                                 "xqt",     "",   "",    false, false },
  { u8"Qau",                                                        "gqu",     "",   "",    false, false },
  { u8"Qawasqar",                                                   "alc",     "",   "",    false, false },
  { u8"Qila Muji",                                                  "ymq",     "",   "",    false, false },
  { u8"Qimant",                                                     "ahg",     "",   "",    false, false },
  { u8"Qiubei Zhuang",                                              "zqe",     "",   "",    false, false },
  { u8"Quapaw",                                                     "qua",     "",   "",    false, false },
  { u8"Quebec Sign Language",                                       "fcs",     "",   "",    false, false },
  { u8"Quechan",                                                    "yum",     "",   "",    false, false },
  { u8"Quechua",                                                    "que",     "qu", "",    true,  false },
  { u8"Quechuan (family)",                                          "qwe",     "",   "",    false, false },
  { u8"Quenya",                                                     "qya",     "",   "",    false, false },
  { u8"Querétaro Otomi",                                            "otq",     "",   "",    false, false },
  { u8"Quetzaltepec Mixe",                                          "pxm",     "",   "",    false, false },
  { u8"Queyu",                                                      "qvy",     "",   "",    false, false },
  { u8"Quiavicuzas Zapotec",                                        "zpj",     "",   "",    false, false },
  { u8"Quileute",                                                   "qui",     "",   "",    false, false },
  { u8"Quinault",                                                   "qun",     "",   "",    false, false },
  { u8"Quinqui",                                                    "quq",     "",   "",    false, false },
  { u8"Quioquitani-Quierí Zapotec",                                 "ztq",     "",   "",    false, false },
  { u8"Quiotepec Chinantec",                                        "chq",     "",   "",    false, false },
  { u8"Quiripi",                                                    "qyp",     "",   "",    false, false },
  { u8"Rabha",                                                      "rah",     "",   "",    false, false },
  { u8"Rade",                                                       "rad",     "",   "",    false, false },
  { u8"Raetic",                                                     "xrr",     "",   "",    false, false },
  { u8"Rahambuu",                                                   "raz",     "",   "",    false, false },
  { u8"Rajah Kabunsuwan Manobo",                                    "mqk",     "",   "",    false, false },
  { u8"Rajasthani",                                                 "raj",     "",   "",    true,  false },
  { u8"Rajbanshi",                                                  "rjs",     "",   "",    false, false },
  { u8"Raji",                                                       "rji",     "",   "",    false, false },
  { u8"Rajong",                                                     "rjg",     "",   "",    false, false },
  { u8"Rajput Garasia",                                             "gra",     "",   "",    false, false },
  { u8"Rakahanga-Manihiki",                                         "rkh",     "",   "",    false, false },
  { u8"Rakhine",                                                    "rki",     "",   "",    false, false },
  { u8"Ralte",                                                      "ral",     "",   "",    false, false },
  { u8"Rama",                                                       "rma",     "",   "",    false, false },
  { u8"Ramoaaina",                                                  "rai",     "",   "",    false, false },
  { u8"Ramopa",                                                     "kjx",     "",   "",    false, false },
  { u8"Rampi",                                                      "lje",     "",   "",    false, false },
  { u8"Rana Tharu",                                                 "thr",     "",   "",    false, false },
  { u8"Rang",                                                       "rax",     "",   "",    false, false },
  { u8"Rangkas",                                                    "rgk",     "",   "",    false, false },
  { u8"Ranglong",                                                   "rnl",     "",   "",    false, false },
  { u8"Rangpuri",                                                   "rkt",     "",   "",    false, false },
  { u8"Rao",                                                        "rao",     "",   "",    false, false },
  { u8"Rapa",                                                       "ray",     "",   "",    false, false },
  { u8"Rapanui",                                                    "rap",     "",   "",    true,  false },
  { u8"Rapoisi",                                                    "kyx",     "",   "",    false, false },
  { u8"Rapting",                                                    "rpt",     "",   "",    false, false },
  { u8"Rara Bakati'",                                               "lra",     "",   "",    false, false },
  { u8"Rarotongan",                                                 "rar",     "",   "",    true,  false },
  { u8"Rasawa",                                                     "rac",     "",   "",    false, false },
  { u8"Ratagnon",                                                   "btn",     "",   "",    false, false },
  { u8"Ratahan",                                                    "rth",     "",   "",    false, false },
  { u8"Rathawi",                                                    "rtw",     "",   "",    false, false },
  { u8"Rathwi Bareli",                                              "bgd",     "",   "",    false, false },
  { u8"Raute",                                                      "rau",     "",   "",    false, false },
  { u8"Ravula",                                                     "yea",     "",   "",    false, false },
  { u8"Rawa",                                                       "rwo",     "",   "",    false, false },
  { u8"Rawang",                                                     "raw",     "",   "",    false, false },
  { u8"Rawat",                                                      "jnl",     "",   "",    false, false },
  { u8"Rawngtu Chin",                                               "weu",     "",   "",    false, false },
  { u8"Rawo",                                                       "rwa",     "",   "",    false, false },
  { u8"Rayón Zoque",                                                "zor",     "",   "",    false, false },
  { u8"Razajerdi",                                                  "rat",     "",   "",    false, false },
  { u8"Red Gelao",                                                  "gir",     "",   "",    false, false },
  { u8"Reel",                                                       "atu",     "",   "",    false, false },
  { u8"Rejang Kayan",                                               "ree",     "",   "",    false, false },
  { u8"Rejang",                                                     "rej",     "",   "",    false, false },
  { u8"Reli",                                                       "rei",     "",   "",    false, false },
  { u8"Rema",                                                       "bow",     "",   "",    false, false },
  { u8"Rembarrnga",                                                 "rmb",     "",   "",    false, false },
  { u8"Rembong",                                                    "reb",     "",   "",    false, false },
  { u8"Remo",                                                       "rem",     "",   "",    false, false },
  { u8"Remontado Dumagat",                                          "agv",     "",   "",    false, false },
  { u8"Rempi",                                                      "rmp",     "",   "",    false, false },
  { u8"Remun",                                                      "lkj",     "",   "",    false, false },
  { u8"Rendille",                                                   "rel",     "",   "",    false, false },
  { u8"Rengao",                                                     "ren",     "",   "",    false, false },
  { u8"Rennell-Bellona",                                            "mnv",     "",   "",    false, false },
  { u8"Rennellese Sign Language",                                   "rsi",     "",   "",    false, true  },
  { u8"Repanbitip",                                                 "rpn",     "",   "",    false, false },
  { u8"Rer Bare",                                                   "rer",     "",   "",    false, false },
  { u8"Rerau",                                                      "rea",     "",   "",    false, false },
  { u8"Rerep",                                                      "pgk",     "",   "",    false, false },
  { u8"Reserved for local use",                                     "qaa-qtz", "",   "",    true,  false },
  { u8"Reserved for local use: qaa",                                "qaa",     "",   "",    true,  false },
  { u8"Reserved for local use: qab",                                "qab",     "",   "",    true,  false },
  { u8"Reserved for local use: qac",                                "qac",     "",   "",    true,  false },
  { u8"Reserved for local use: qad",                                "qad",     "",   "",    true,  false },
  { u8"Reserved for local use: qae",                                "qae",     "",   "",    true,  false },
  { u8"Reserved for local use: qaf",                                "qaf",     "",   "",    true,  false },
  { u8"Reserved for local use: qag",                                "qag",     "",   "",    true,  false },
  { u8"Reserved for local use: qah",                                "qah",     "",   "",    true,  false },
  { u8"Reserved for local use: qai",                                "qai",     "",   "",    true,  false },
  { u8"Reserved for local use: qaj",                                "qaj",     "",   "",    true,  false },
  { u8"Reserved for local use: qak",                                "qak",     "",   "",    true,  false },
  { u8"Reserved for local use: qal",                                "qal",     "",   "",    true,  false },
  { u8"Reserved for local use: qam",                                "qam",     "",   "",    true,  false },
  { u8"Reserved for local use: qan",                                "qan",     "",   "",    true,  false },
  { u8"Reserved for local use: qao",                                "qao",     "",   "",    true,  false },
  { u8"Reserved for local use: qap",                                "qap",     "",   "",    true,  false },
  { u8"Reserved for local use: qaq",                                "qaq",     "",   "",    true,  false },
  { u8"Reserved for local use: qar",                                "qar",     "",   "",    true,  false },
  { u8"Reserved for local use: qas",                                "qas",     "",   "",    true,  false },
  { u8"Reserved for local use: qat",                                "qat",     "",   "",    true,  false },
  { u8"Reserved for local use: qau",                                "qau",     "",   "",    true,  false },
  { u8"Reserved for local use: qav",                                "qav",     "",   "",    true,  false },
  { u8"Reserved for local use: qaw",                                "qaw",     "",   "",    true,  false },
  { u8"Reserved for local use: qax",                                "qax",     "",   "",    true,  false },
  { u8"Reserved for local use: qay",                                "qay",     "",   "",    true,  false },
  { u8"Reserved for local use: qaz",                                "qaz",     "",   "",    true,  false },
  { u8"Reserved for local use: qba",                                "qba",     "",   "",    true,  false },
  { u8"Reserved for local use: qbb",                                "qbb",     "",   "",    true,  false },
  { u8"Reserved for local use: qbc",                                "qbc",     "",   "",    true,  false },
  { u8"Reserved for local use: qbd",                                "qbd",     "",   "",    true,  false },
  { u8"Reserved for local use: qbe",                                "qbe",     "",   "",    true,  false },
  { u8"Reserved for local use: qbf",                                "qbf",     "",   "",    true,  false },
  { u8"Reserved for local use: qbg",                                "qbg",     "",   "",    true,  false },
  { u8"Reserved for local use: qbh",                                "qbh",     "",   "",    true,  false },
  { u8"Reserved for local use: qbi",                                "qbi",     "",   "",    true,  false },
  { u8"Reserved for local use: qbj",                                "qbj",     "",   "",    true,  false },
  { u8"Reserved for local use: qbk",                                "qbk",     "",   "",    true,  false },
  { u8"Reserved for local use: qbl",                                "qbl",     "",   "",    true,  false },
  { u8"Reserved for local use: qbm",                                "qbm",     "",   "",    true,  false },
  { u8"Reserved for local use: qbn",                                "qbn",     "",   "",    true,  false },
  { u8"Reserved for local use: qbo",                                "qbo",     "",   "",    true,  false },
  { u8"Reserved for local use: qbp",                                "qbp",     "",   "",    true,  false },
  { u8"Reserved for local use: qbq",                                "qbq",     "",   "",    true,  false },
  { u8"Reserved for local use: qbr",                                "qbr",     "",   "",    true,  false },
  { u8"Reserved for local use: qbs",                                "qbs",     "",   "",    true,  false },
  { u8"Reserved for local use: qbt",                                "qbt",     "",   "",    true,  false },
  { u8"Reserved for local use: qbu",                                "qbu",     "",   "",    true,  false },
  { u8"Reserved for local use: qbv",                                "qbv",     "",   "",    true,  false },
  { u8"Reserved for local use: qbw",                                "qbw",     "",   "",    true,  false },
  { u8"Reserved for local use: qbx",                                "qbx",     "",   "",    true,  false },
  { u8"Reserved for local use: qby",                                "qby",     "",   "",    true,  false },
  { u8"Reserved for local use: qbz",                                "qbz",     "",   "",    true,  false },
  { u8"Reserved for local use: qca",                                "qca",     "",   "",    true,  false },
  { u8"Reserved for local use: qcb",                                "qcb",     "",   "",    true,  false },
  { u8"Reserved for local use: qcc",                                "qcc",     "",   "",    true,  false },
  { u8"Reserved for local use: qcd",                                "qcd",     "",   "",    true,  false },
  { u8"Reserved for local use: qce",                                "qce",     "",   "",    true,  false },
  { u8"Reserved for local use: qcf",                                "qcf",     "",   "",    true,  false },
  { u8"Reserved for local use: qcg",                                "qcg",     "",   "",    true,  false },
  { u8"Reserved for local use: qch",                                "qch",     "",   "",    true,  false },
  { u8"Reserved for local use: qci",                                "qci",     "",   "",    true,  false },
  { u8"Reserved for local use: qcj",                                "qcj",     "",   "",    true,  false },
  { u8"Reserved for local use: qck",                                "qck",     "",   "",    true,  false },
  { u8"Reserved for local use: qcl",                                "qcl",     "",   "",    true,  false },
  { u8"Reserved for local use: qcm",                                "qcm",     "",   "",    true,  false },
  { u8"Reserved for local use: qcn",                                "qcn",     "",   "",    true,  false },
  { u8"Reserved for local use: qco",                                "qco",     "",   "",    true,  false },
  { u8"Reserved for local use: qcp",                                "qcp",     "",   "",    true,  false },
  { u8"Reserved for local use: qcq",                                "qcq",     "",   "",    true,  false },
  { u8"Reserved for local use: qcr",                                "qcr",     "",   "",    true,  false },
  { u8"Reserved for local use: qcs",                                "qcs",     "",   "",    true,  false },
  { u8"Reserved for local use: qct",                                "qct",     "",   "",    true,  false },
  { u8"Reserved for local use: qcu",                                "qcu",     "",   "",    true,  false },
  { u8"Reserved for local use: qcv",                                "qcv",     "",   "",    true,  false },
  { u8"Reserved for local use: qcw",                                "qcw",     "",   "",    true,  false },
  { u8"Reserved for local use: qcx",                                "qcx",     "",   "",    true,  false },
  { u8"Reserved for local use: qcy",                                "qcy",     "",   "",    true,  false },
  { u8"Reserved for local use: qcz",                                "qcz",     "",   "",    true,  false },
  { u8"Reserved for local use: qda",                                "qda",     "",   "",    true,  false },
  { u8"Reserved for local use: qdb",                                "qdb",     "",   "",    true,  false },
  { u8"Reserved for local use: qdc",                                "qdc",     "",   "",    true,  false },
  { u8"Reserved for local use: qdd",                                "qdd",     "",   "",    true,  false },
  { u8"Reserved for local use: qde",                                "qde",     "",   "",    true,  false },
  { u8"Reserved for local use: qdf",                                "qdf",     "",   "",    true,  false },
  { u8"Reserved for local use: qdg",                                "qdg",     "",   "",    true,  false },
  { u8"Reserved for local use: qdh",                                "qdh",     "",   "",    true,  false },
  { u8"Reserved for local use: qdi",                                "qdi",     "",   "",    true,  false },
  { u8"Reserved for local use: qdj",                                "qdj",     "",   "",    true,  false },
  { u8"Reserved for local use: qdk",                                "qdk",     "",   "",    true,  false },
  { u8"Reserved for local use: qdl",                                "qdl",     "",   "",    true,  false },
  { u8"Reserved for local use: qdm",                                "qdm",     "",   "",    true,  false },
  { u8"Reserved for local use: qdn",                                "qdn",     "",   "",    true,  false },
  { u8"Reserved for local use: qdo",                                "qdo",     "",   "",    true,  false },
  { u8"Reserved for local use: qdp",                                "qdp",     "",   "",    true,  false },
  { u8"Reserved for local use: qdq",                                "qdq",     "",   "",    true,  false },
  { u8"Reserved for local use: qdr",                                "qdr",     "",   "",    true,  false },
  { u8"Reserved for local use: qds",                                "qds",     "",   "",    true,  false },
  { u8"Reserved for local use: qdt",                                "qdt",     "",   "",    true,  false },
  { u8"Reserved for local use: qdu",                                "qdu",     "",   "",    true,  false },
  { u8"Reserved for local use: qdv",                                "qdv",     "",   "",    true,  false },
  { u8"Reserved for local use: qdw",                                "qdw",     "",   "",    true,  false },
  { u8"Reserved for local use: qdx",                                "qdx",     "",   "",    true,  false },
  { u8"Reserved for local use: qdy",                                "qdy",     "",   "",    true,  false },
  { u8"Reserved for local use: qdz",                                "qdz",     "",   "",    true,  false },
  { u8"Reserved for local use: qea",                                "qea",     "",   "",    true,  false },
  { u8"Reserved for local use: qeb",                                "qeb",     "",   "",    true,  false },
  { u8"Reserved for local use: qec",                                "qec",     "",   "",    true,  false },
  { u8"Reserved for local use: qed",                                "qed",     "",   "",    true,  false },
  { u8"Reserved for local use: qee",                                "qee",     "",   "",    true,  false },
  { u8"Reserved for local use: qef",                                "qef",     "",   "",    true,  false },
  { u8"Reserved for local use: qeg",                                "qeg",     "",   "",    true,  false },
  { u8"Reserved for local use: qeh",                                "qeh",     "",   "",    true,  false },
  { u8"Reserved for local use: qei",                                "qei",     "",   "",    true,  false },
  { u8"Reserved for local use: qej",                                "qej",     "",   "",    true,  false },
  { u8"Reserved for local use: qek",                                "qek",     "",   "",    true,  false },
  { u8"Reserved for local use: qel",                                "qel",     "",   "",    true,  false },
  { u8"Reserved for local use: qem",                                "qem",     "",   "",    true,  false },
  { u8"Reserved for local use: qen",                                "qen",     "",   "",    true,  false },
  { u8"Reserved for local use: qeo",                                "qeo",     "",   "",    true,  false },
  { u8"Reserved for local use: qep",                                "qep",     "",   "",    true,  false },
  { u8"Reserved for local use: qeq",                                "qeq",     "",   "",    true,  false },
  { u8"Reserved for local use: qer",                                "qer",     "",   "",    true,  false },
  { u8"Reserved for local use: qes",                                "qes",     "",   "",    true,  false },
  { u8"Reserved for local use: qet",                                "qet",     "",   "",    true,  false },
  { u8"Reserved for local use: qeu",                                "qeu",     "",   "",    true,  false },
  { u8"Reserved for local use: qev",                                "qev",     "",   "",    true,  false },
  { u8"Reserved for local use: qew",                                "qew",     "",   "",    true,  false },
  { u8"Reserved for local use: qex",                                "qex",     "",   "",    true,  false },
  { u8"Reserved for local use: qey",                                "qey",     "",   "",    true,  false },
  { u8"Reserved for local use: qez",                                "qez",     "",   "",    true,  false },
  { u8"Reserved for local use: qfa",                                "qfa",     "",   "",    true,  false },
  { u8"Reserved for local use: qfb",                                "qfb",     "",   "",    true,  false },
  { u8"Reserved for local use: qfc",                                "qfc",     "",   "",    true,  false },
  { u8"Reserved for local use: qfd",                                "qfd",     "",   "",    true,  false },
  { u8"Reserved for local use: qfe",                                "qfe",     "",   "",    true,  false },
  { u8"Reserved for local use: qff",                                "qff",     "",   "",    true,  false },
  { u8"Reserved for local use: qfg",                                "qfg",     "",   "",    true,  false },
  { u8"Reserved for local use: qfh",                                "qfh",     "",   "",    true,  false },
  { u8"Reserved for local use: qfi",                                "qfi",     "",   "",    true,  false },
  { u8"Reserved for local use: qfj",                                "qfj",     "",   "",    true,  false },
  { u8"Reserved for local use: qfk",                                "qfk",     "",   "",    true,  false },
  { u8"Reserved for local use: qfl",                                "qfl",     "",   "",    true,  false },
  { u8"Reserved for local use: qfm",                                "qfm",     "",   "",    true,  false },
  { u8"Reserved for local use: qfn",                                "qfn",     "",   "",    true,  false },
  { u8"Reserved for local use: qfo",                                "qfo",     "",   "",    true,  false },
  { u8"Reserved for local use: qfp",                                "qfp",     "",   "",    true,  false },
  { u8"Reserved for local use: qfq",                                "qfq",     "",   "",    true,  false },
  { u8"Reserved for local use: qfr",                                "qfr",     "",   "",    true,  false },
  { u8"Reserved for local use: qfs",                                "qfs",     "",   "",    true,  false },
  { u8"Reserved for local use: qft",                                "qft",     "",   "",    true,  false },
  { u8"Reserved for local use: qfu",                                "qfu",     "",   "",    true,  false },
  { u8"Reserved for local use: qfv",                                "qfv",     "",   "",    true,  false },
  { u8"Reserved for local use: qfw",                                "qfw",     "",   "",    true,  false },
  { u8"Reserved for local use: qfx",                                "qfx",     "",   "",    true,  false },
  { u8"Reserved for local use: qfy",                                "qfy",     "",   "",    true,  false },
  { u8"Reserved for local use: qfz",                                "qfz",     "",   "",    true,  false },
  { u8"Reserved for local use: qga",                                "qga",     "",   "",    true,  false },
  { u8"Reserved for local use: qgb",                                "qgb",     "",   "",    true,  false },
  { u8"Reserved for local use: qgc",                                "qgc",     "",   "",    true,  false },
  { u8"Reserved for local use: qgd",                                "qgd",     "",   "",    true,  false },
  { u8"Reserved for local use: qge",                                "qge",     "",   "",    true,  false },
  { u8"Reserved for local use: qgf",                                "qgf",     "",   "",    true,  false },
  { u8"Reserved for local use: qgg",                                "qgg",     "",   "",    true,  false },
  { u8"Reserved for local use: qgh",                                "qgh",     "",   "",    true,  false },
  { u8"Reserved for local use: qgi",                                "qgi",     "",   "",    true,  false },
  { u8"Reserved for local use: qgj",                                "qgj",     "",   "",    true,  false },
  { u8"Reserved for local use: qgk",                                "qgk",     "",   "",    true,  false },
  { u8"Reserved for local use: qgl",                                "qgl",     "",   "",    true,  false },
  { u8"Reserved for local use: qgm",                                "qgm",     "",   "",    true,  false },
  { u8"Reserved for local use: qgn",                                "qgn",     "",   "",    true,  false },
  { u8"Reserved for local use: qgo",                                "qgo",     "",   "",    true,  false },
  { u8"Reserved for local use: qgp",                                "qgp",     "",   "",    true,  false },
  { u8"Reserved for local use: qgq",                                "qgq",     "",   "",    true,  false },
  { u8"Reserved for local use: qgr",                                "qgr",     "",   "",    true,  false },
  { u8"Reserved for local use: qgs",                                "qgs",     "",   "",    true,  false },
  { u8"Reserved for local use: qgt",                                "qgt",     "",   "",    true,  false },
  { u8"Reserved for local use: qgu",                                "qgu",     "",   "",    true,  false },
  { u8"Reserved for local use: qgv",                                "qgv",     "",   "",    true,  false },
  { u8"Reserved for local use: qgw",                                "qgw",     "",   "",    true,  false },
  { u8"Reserved for local use: qgx",                                "qgx",     "",   "",    true,  false },
  { u8"Reserved for local use: qgy",                                "qgy",     "",   "",    true,  false },
  { u8"Reserved for local use: qgz",                                "qgz",     "",   "",    true,  false },
  { u8"Reserved for local use: qha",                                "qha",     "",   "",    true,  false },
  { u8"Reserved for local use: qhb",                                "qhb",     "",   "",    true,  false },
  { u8"Reserved for local use: qhc",                                "qhc",     "",   "",    true,  false },
  { u8"Reserved for local use: qhd",                                "qhd",     "",   "",    true,  false },
  { u8"Reserved for local use: qhe",                                "qhe",     "",   "",    true,  false },
  { u8"Reserved for local use: qhf",                                "qhf",     "",   "",    true,  false },
  { u8"Reserved for local use: qhg",                                "qhg",     "",   "",    true,  false },
  { u8"Reserved for local use: qhh",                                "qhh",     "",   "",    true,  false },
  { u8"Reserved for local use: qhi",                                "qhi",     "",   "",    true,  false },
  { u8"Reserved for local use: qhj",                                "qhj",     "",   "",    true,  false },
  { u8"Reserved for local use: qhk",                                "qhk",     "",   "",    true,  false },
  { u8"Reserved for local use: qhl",                                "qhl",     "",   "",    true,  false },
  { u8"Reserved for local use: qhm",                                "qhm",     "",   "",    true,  false },
  { u8"Reserved for local use: qhn",                                "qhn",     "",   "",    true,  false },
  { u8"Reserved for local use: qho",                                "qho",     "",   "",    true,  false },
  { u8"Reserved for local use: qhp",                                "qhp",     "",   "",    true,  false },
  { u8"Reserved for local use: qhq",                                "qhq",     "",   "",    true,  false },
  { u8"Reserved for local use: qhr",                                "qhr",     "",   "",    true,  false },
  { u8"Reserved for local use: qhs",                                "qhs",     "",   "",    true,  false },
  { u8"Reserved for local use: qht",                                "qht",     "",   "",    true,  false },
  { u8"Reserved for local use: qhu",                                "qhu",     "",   "",    true,  false },
  { u8"Reserved for local use: qhv",                                "qhv",     "",   "",    true,  false },
  { u8"Reserved for local use: qhw",                                "qhw",     "",   "",    true,  false },
  { u8"Reserved for local use: qhx",                                "qhx",     "",   "",    true,  false },
  { u8"Reserved for local use: qhy",                                "qhy",     "",   "",    true,  false },
  { u8"Reserved for local use: qhz",                                "qhz",     "",   "",    true,  false },
  { u8"Reserved for local use: qia",                                "qia",     "",   "",    true,  false },
  { u8"Reserved for local use: qib",                                "qib",     "",   "",    true,  false },
  { u8"Reserved for local use: qic",                                "qic",     "",   "",    true,  false },
  { u8"Reserved for local use: qid",                                "qid",     "",   "",    true,  false },
  { u8"Reserved for local use: qie",                                "qie",     "",   "",    true,  false },
  { u8"Reserved for local use: qif",                                "qif",     "",   "",    true,  false },
  { u8"Reserved for local use: qig",                                "qig",     "",   "",    true,  false },
  { u8"Reserved for local use: qih",                                "qih",     "",   "",    true,  false },
  { u8"Reserved for local use: qii",                                "qii",     "",   "",    true,  false },
  { u8"Reserved for local use: qij",                                "qij",     "",   "",    true,  false },
  { u8"Reserved for local use: qik",                                "qik",     "",   "",    true,  false },
  { u8"Reserved for local use: qil",                                "qil",     "",   "",    true,  false },
  { u8"Reserved for local use: qim",                                "qim",     "",   "",    true,  false },
  { u8"Reserved for local use: qin",                                "qin",     "",   "",    true,  false },
  { u8"Reserved for local use: qio",                                "qio",     "",   "",    true,  false },
  { u8"Reserved for local use: qip",                                "qip",     "",   "",    true,  false },
  { u8"Reserved for local use: qiq",                                "qiq",     "",   "",    true,  false },
  { u8"Reserved for local use: qir",                                "qir",     "",   "",    true,  false },
  { u8"Reserved for local use: qis",                                "qis",     "",   "",    true,  false },
  { u8"Reserved for local use: qit",                                "qit",     "",   "",    true,  false },
  { u8"Reserved for local use: qiu",                                "qiu",     "",   "",    true,  false },
  { u8"Reserved for local use: qiv",                                "qiv",     "",   "",    true,  false },
  { u8"Reserved for local use: qiw",                                "qiw",     "",   "",    true,  false },
  { u8"Reserved for local use: qix",                                "qix",     "",   "",    true,  false },
  { u8"Reserved for local use: qiy",                                "qiy",     "",   "",    true,  false },
  { u8"Reserved for local use: qiz",                                "qiz",     "",   "",    true,  false },
  { u8"Reserved for local use: qja",                                "qja",     "",   "",    true,  false },
  { u8"Reserved for local use: qjb",                                "qjb",     "",   "",    true,  false },
  { u8"Reserved for local use: qjc",                                "qjc",     "",   "",    true,  false },
  { u8"Reserved for local use: qjd",                                "qjd",     "",   "",    true,  false },
  { u8"Reserved for local use: qje",                                "qje",     "",   "",    true,  false },
  { u8"Reserved for local use: qjf",                                "qjf",     "",   "",    true,  false },
  { u8"Reserved for local use: qjg",                                "qjg",     "",   "",    true,  false },
  { u8"Reserved for local use: qjh",                                "qjh",     "",   "",    true,  false },
  { u8"Reserved for local use: qji",                                "qji",     "",   "",    true,  false },
  { u8"Reserved for local use: qjj",                                "qjj",     "",   "",    true,  false },
  { u8"Reserved for local use: qjk",                                "qjk",     "",   "",    true,  false },
  { u8"Reserved for local use: qjl",                                "qjl",     "",   "",    true,  false },
  { u8"Reserved for local use: qjm",                                "qjm",     "",   "",    true,  false },
  { u8"Reserved for local use: qjn",                                "qjn",     "",   "",    true,  false },
  { u8"Reserved for local use: qjo",                                "qjo",     "",   "",    true,  false },
  { u8"Reserved for local use: qjp",                                "qjp",     "",   "",    true,  false },
  { u8"Reserved for local use: qjq",                                "qjq",     "",   "",    true,  false },
  { u8"Reserved for local use: qjr",                                "qjr",     "",   "",    true,  false },
  { u8"Reserved for local use: qjs",                                "qjs",     "",   "",    true,  false },
  { u8"Reserved for local use: qjt",                                "qjt",     "",   "",    true,  false },
  { u8"Reserved for local use: qju",                                "qju",     "",   "",    true,  false },
  { u8"Reserved for local use: qjv",                                "qjv",     "",   "",    true,  false },
  { u8"Reserved for local use: qjw",                                "qjw",     "",   "",    true,  false },
  { u8"Reserved for local use: qjx",                                "qjx",     "",   "",    true,  false },
  { u8"Reserved for local use: qjy",                                "qjy",     "",   "",    true,  false },
  { u8"Reserved for local use: qjz",                                "qjz",     "",   "",    true,  false },
  { u8"Reserved for local use: qka",                                "qka",     "",   "",    true,  false },
  { u8"Reserved for local use: qkb",                                "qkb",     "",   "",    true,  false },
  { u8"Reserved for local use: qkc",                                "qkc",     "",   "",    true,  false },
  { u8"Reserved for local use: qkd",                                "qkd",     "",   "",    true,  false },
  { u8"Reserved for local use: qke",                                "qke",     "",   "",    true,  false },
  { u8"Reserved for local use: qkf",                                "qkf",     "",   "",    true,  false },
  { u8"Reserved for local use: qkg",                                "qkg",     "",   "",    true,  false },
  { u8"Reserved for local use: qkh",                                "qkh",     "",   "",    true,  false },
  { u8"Reserved for local use: qki",                                "qki",     "",   "",    true,  false },
  { u8"Reserved for local use: qkj",                                "qkj",     "",   "",    true,  false },
  { u8"Reserved for local use: qkk",                                "qkk",     "",   "",    true,  false },
  { u8"Reserved for local use: qkl",                                "qkl",     "",   "",    true,  false },
  { u8"Reserved for local use: qkm",                                "qkm",     "",   "",    true,  false },
  { u8"Reserved for local use: qkn",                                "qkn",     "",   "",    true,  false },
  { u8"Reserved for local use: qko",                                "qko",     "",   "",    true,  false },
  { u8"Reserved for local use: qkp",                                "qkp",     "",   "",    true,  false },
  { u8"Reserved for local use: qkq",                                "qkq",     "",   "",    true,  false },
  { u8"Reserved for local use: qkr",                                "qkr",     "",   "",    true,  false },
  { u8"Reserved for local use: qks",                                "qks",     "",   "",    true,  false },
  { u8"Reserved for local use: qkt",                                "qkt",     "",   "",    true,  false },
  { u8"Reserved for local use: qku",                                "qku",     "",   "",    true,  false },
  { u8"Reserved for local use: qkv",                                "qkv",     "",   "",    true,  false },
  { u8"Reserved for local use: qkw",                                "qkw",     "",   "",    true,  false },
  { u8"Reserved for local use: qkx",                                "qkx",     "",   "",    true,  false },
  { u8"Reserved for local use: qky",                                "qky",     "",   "",    true,  false },
  { u8"Reserved for local use: qkz",                                "qkz",     "",   "",    true,  false },
  { u8"Reserved for local use: qla",                                "qla",     "",   "",    true,  false },
  { u8"Reserved for local use: qlb",                                "qlb",     "",   "",    true,  false },
  { u8"Reserved for local use: qlc",                                "qlc",     "",   "",    true,  false },
  { u8"Reserved for local use: qld",                                "qld",     "",   "",    true,  false },
  { u8"Reserved for local use: qle",                                "qle",     "",   "",    true,  false },
  { u8"Reserved for local use: qlf",                                "qlf",     "",   "",    true,  false },
  { u8"Reserved for local use: qlg",                                "qlg",     "",   "",    true,  false },
  { u8"Reserved for local use: qlh",                                "qlh",     "",   "",    true,  false },
  { u8"Reserved for local use: qli",                                "qli",     "",   "",    true,  false },
  { u8"Reserved for local use: qlj",                                "qlj",     "",   "",    true,  false },
  { u8"Reserved for local use: qlk",                                "qlk",     "",   "",    true,  false },
  { u8"Reserved for local use: qll",                                "qll",     "",   "",    true,  false },
  { u8"Reserved for local use: qlm",                                "qlm",     "",   "",    true,  false },
  { u8"Reserved for local use: qln",                                "qln",     "",   "",    true,  false },
  { u8"Reserved for local use: qlo",                                "qlo",     "",   "",    true,  false },
  { u8"Reserved for local use: qlp",                                "qlp",     "",   "",    true,  false },
  { u8"Reserved for local use: qlq",                                "qlq",     "",   "",    true,  false },
  { u8"Reserved for local use: qlr",                                "qlr",     "",   "",    true,  false },
  { u8"Reserved for local use: qls",                                "qls",     "",   "",    true,  false },
  { u8"Reserved for local use: qlt",                                "qlt",     "",   "",    true,  false },
  { u8"Reserved for local use: qlu",                                "qlu",     "",   "",    true,  false },
  { u8"Reserved for local use: qlv",                                "qlv",     "",   "",    true,  false },
  { u8"Reserved for local use: qlw",                                "qlw",     "",   "",    true,  false },
  { u8"Reserved for local use: qlx",                                "qlx",     "",   "",    true,  false },
  { u8"Reserved for local use: qly",                                "qly",     "",   "",    true,  false },
  { u8"Reserved for local use: qlz",                                "qlz",     "",   "",    true,  false },
  { u8"Reserved for local use: qma",                                "qma",     "",   "",    true,  false },
  { u8"Reserved for local use: qmb",                                "qmb",     "",   "",    true,  false },
  { u8"Reserved for local use: qmc",                                "qmc",     "",   "",    true,  false },
  { u8"Reserved for local use: qmd",                                "qmd",     "",   "",    true,  false },
  { u8"Reserved for local use: qme",                                "qme",     "",   "",    true,  false },
  { u8"Reserved for local use: qmf",                                "qmf",     "",   "",    true,  false },
  { u8"Reserved for local use: qmg",                                "qmg",     "",   "",    true,  false },
  { u8"Reserved for local use: qmh",                                "qmh",     "",   "",    true,  false },
  { u8"Reserved for local use: qmi",                                "qmi",     "",   "",    true,  false },
  { u8"Reserved for local use: qmj",                                "qmj",     "",   "",    true,  false },
  { u8"Reserved for local use: qmk",                                "qmk",     "",   "",    true,  false },
  { u8"Reserved for local use: qml",                                "qml",     "",   "",    true,  false },
  { u8"Reserved for local use: qmm",                                "qmm",     "",   "",    true,  false },
  { u8"Reserved for local use: qmn",                                "qmn",     "",   "",    true,  false },
  { u8"Reserved for local use: qmo",                                "qmo",     "",   "",    true,  false },
  { u8"Reserved for local use: qmp",                                "qmp",     "",   "",    true,  false },
  { u8"Reserved for local use: qmq",                                "qmq",     "",   "",    true,  false },
  { u8"Reserved for local use: qmr",                                "qmr",     "",   "",    true,  false },
  { u8"Reserved for local use: qms",                                "qms",     "",   "",    true,  false },
  { u8"Reserved for local use: qmt",                                "qmt",     "",   "",    true,  false },
  { u8"Reserved for local use: qmu",                                "qmu",     "",   "",    true,  false },
  { u8"Reserved for local use: qmv",                                "qmv",     "",   "",    true,  false },
  { u8"Reserved for local use: qmw",                                "qmw",     "",   "",    true,  false },
  { u8"Reserved for local use: qmx",                                "qmx",     "",   "",    true,  false },
  { u8"Reserved for local use: qmy",                                "qmy",     "",   "",    true,  false },
  { u8"Reserved for local use: qmz",                                "qmz",     "",   "",    true,  false },
  { u8"Reserved for local use: qna",                                "qna",     "",   "",    true,  false },
  { u8"Reserved for local use: qnb",                                "qnb",     "",   "",    true,  false },
  { u8"Reserved for local use: qnc",                                "qnc",     "",   "",    true,  false },
  { u8"Reserved for local use: qnd",                                "qnd",     "",   "",    true,  false },
  { u8"Reserved for local use: qne",                                "qne",     "",   "",    true,  false },
  { u8"Reserved for local use: qnf",                                "qnf",     "",   "",    true,  false },
  { u8"Reserved for local use: qng",                                "qng",     "",   "",    true,  false },
  { u8"Reserved for local use: qnh",                                "qnh",     "",   "",    true,  false },
  { u8"Reserved for local use: qni",                                "qni",     "",   "",    true,  false },
  { u8"Reserved for local use: qnj",                                "qnj",     "",   "",    true,  false },
  { u8"Reserved for local use: qnk",                                "qnk",     "",   "",    true,  false },
  { u8"Reserved for local use: qnl",                                "qnl",     "",   "",    true,  false },
  { u8"Reserved for local use: qnm",                                "qnm",     "",   "",    true,  false },
  { u8"Reserved for local use: qnn",                                "qnn",     "",   "",    true,  false },
  { u8"Reserved for local use: qno",                                "qno",     "",   "",    true,  false },
  { u8"Reserved for local use: qnp",                                "qnp",     "",   "",    true,  false },
  { u8"Reserved for local use: qnq",                                "qnq",     "",   "",    true,  false },
  { u8"Reserved for local use: qnr",                                "qnr",     "",   "",    true,  false },
  { u8"Reserved for local use: qns",                                "qns",     "",   "",    true,  false },
  { u8"Reserved for local use: qnt",                                "qnt",     "",   "",    true,  false },
  { u8"Reserved for local use: qnu",                                "qnu",     "",   "",    true,  false },
  { u8"Reserved for local use: qnv",                                "qnv",     "",   "",    true,  false },
  { u8"Reserved for local use: qnw",                                "qnw",     "",   "",    true,  false },
  { u8"Reserved for local use: qnx",                                "qnx",     "",   "",    true,  false },
  { u8"Reserved for local use: qny",                                "qny",     "",   "",    true,  false },
  { u8"Reserved for local use: qnz",                                "qnz",     "",   "",    true,  false },
  { u8"Reserved for local use: qoa",                                "qoa",     "",   "",    true,  false },
  { u8"Reserved for local use: qob",                                "qob",     "",   "",    true,  false },
  { u8"Reserved for local use: qoc",                                "qoc",     "",   "",    true,  false },
  { u8"Reserved for local use: qod",                                "qod",     "",   "",    true,  false },
  { u8"Reserved for local use: qoe",                                "qoe",     "",   "",    true,  false },
  { u8"Reserved for local use: qof",                                "qof",     "",   "",    true,  false },
  { u8"Reserved for local use: qog",                                "qog",     "",   "",    true,  false },
  { u8"Reserved for local use: qoh",                                "qoh",     "",   "",    true,  false },
  { u8"Reserved for local use: qoi",                                "qoi",     "",   "",    true,  false },
  { u8"Reserved for local use: qoj",                                "qoj",     "",   "",    true,  false },
  { u8"Reserved for local use: qok",                                "qok",     "",   "",    true,  false },
  { u8"Reserved for local use: qol",                                "qol",     "",   "",    true,  false },
  { u8"Reserved for local use: qom",                                "qom",     "",   "",    true,  false },
  { u8"Reserved for local use: qon",                                "qon",     "",   "",    true,  false },
  { u8"Reserved for local use: qoo",                                "qoo",     "",   "",    true,  false },
  { u8"Reserved for local use: qop",                                "qop",     "",   "",    true,  false },
  { u8"Reserved for local use: qoq",                                "qoq",     "",   "",    true,  false },
  { u8"Reserved for local use: qor",                                "qor",     "",   "",    true,  false },
  { u8"Reserved for local use: qos",                                "qos",     "",   "",    true,  false },
  { u8"Reserved for local use: qot",                                "qot",     "",   "",    true,  false },
  { u8"Reserved for local use: qou",                                "qou",     "",   "",    true,  false },
  { u8"Reserved for local use: qov",                                "qov",     "",   "",    true,  false },
  { u8"Reserved for local use: qow",                                "qow",     "",   "",    true,  false },
  { u8"Reserved for local use: qox",                                "qox",     "",   "",    true,  false },
  { u8"Reserved for local use: qoy",                                "qoy",     "",   "",    true,  false },
  { u8"Reserved for local use: qoz",                                "qoz",     "",   "",    true,  false },
  { u8"Reserved for local use: qpa",                                "qpa",     "",   "",    true,  false },
  { u8"Reserved for local use: qpb",                                "qpb",     "",   "",    true,  false },
  { u8"Reserved for local use: qpc",                                "qpc",     "",   "",    true,  false },
  { u8"Reserved for local use: qpd",                                "qpd",     "",   "",    true,  false },
  { u8"Reserved for local use: qpe",                                "qpe",     "",   "",    true,  false },
  { u8"Reserved for local use: qpf",                                "qpf",     "",   "",    true,  false },
  { u8"Reserved for local use: qpg",                                "qpg",     "",   "",    true,  false },
  { u8"Reserved for local use: qph",                                "qph",     "",   "",    true,  false },
  { u8"Reserved for local use: qpi",                                "qpi",     "",   "",    true,  false },
  { u8"Reserved for local use: qpj",                                "qpj",     "",   "",    true,  false },
  { u8"Reserved for local use: qpk",                                "qpk",     "",   "",    true,  false },
  { u8"Reserved for local use: qpl",                                "qpl",     "",   "",    true,  false },
  { u8"Reserved for local use: qpm",                                "qpm",     "",   "",    true,  false },
  { u8"Reserved for local use: qpn",                                "qpn",     "",   "",    true,  false },
  { u8"Reserved for local use: qpo",                                "qpo",     "",   "",    true,  false },
  { u8"Reserved for local use: qpp",                                "qpp",     "",   "",    true,  false },
  { u8"Reserved for local use: qpq",                                "qpq",     "",   "",    true,  false },
  { u8"Reserved for local use: qpr",                                "qpr",     "",   "",    true,  false },
  { u8"Reserved for local use: qps",                                "qps",     "",   "",    true,  false },
  { u8"Reserved for local use: qpt",                                "qpt",     "",   "",    true,  false },
  { u8"Reserved for local use: qpu",                                "qpu",     "",   "",    true,  false },
  { u8"Reserved for local use: qpv",                                "qpv",     "",   "",    true,  false },
  { u8"Reserved for local use: qpw",                                "qpw",     "",   "",    true,  false },
  { u8"Reserved for local use: qpx",                                "qpx",     "",   "",    true,  false },
  { u8"Reserved for local use: qpy",                                "qpy",     "",   "",    true,  false },
  { u8"Reserved for local use: qpz",                                "qpz",     "",   "",    true,  false },
  { u8"Reserved for local use: qqa",                                "qqa",     "",   "",    true,  false },
  { u8"Reserved for local use: qqb",                                "qqb",     "",   "",    true,  false },
  { u8"Reserved for local use: qqc",                                "qqc",     "",   "",    true,  false },
  { u8"Reserved for local use: qqd",                                "qqd",     "",   "",    true,  false },
  { u8"Reserved for local use: qqe",                                "qqe",     "",   "",    true,  false },
  { u8"Reserved for local use: qqf",                                "qqf",     "",   "",    true,  false },
  { u8"Reserved for local use: qqg",                                "qqg",     "",   "",    true,  false },
  { u8"Reserved for local use: qqh",                                "qqh",     "",   "",    true,  false },
  { u8"Reserved for local use: qqi",                                "qqi",     "",   "",    true,  false },
  { u8"Reserved for local use: qqj",                                "qqj",     "",   "",    true,  false },
  { u8"Reserved for local use: qqk",                                "qqk",     "",   "",    true,  false },
  { u8"Reserved for local use: qql",                                "qql",     "",   "",    true,  false },
  { u8"Reserved for local use: qqm",                                "qqm",     "",   "",    true,  false },
  { u8"Reserved for local use: qqn",                                "qqn",     "",   "",    true,  false },
  { u8"Reserved for local use: qqo",                                "qqo",     "",   "",    true,  false },
  { u8"Reserved for local use: qqp",                                "qqp",     "",   "",    true,  false },
  { u8"Reserved for local use: qqq",                                "qqq",     "",   "",    true,  false },
  { u8"Reserved for local use: qqr",                                "qqr",     "",   "",    true,  false },
  { u8"Reserved for local use: qqs",                                "qqs",     "",   "",    true,  false },
  { u8"Reserved for local use: qqt",                                "qqt",     "",   "",    true,  false },
  { u8"Reserved for local use: qqu",                                "qqu",     "",   "",    true,  false },
  { u8"Reserved for local use: qqv",                                "qqv",     "",   "",    true,  false },
  { u8"Reserved for local use: qqw",                                "qqw",     "",   "",    true,  false },
  { u8"Reserved for local use: qqx",                                "qqx",     "",   "",    true,  false },
  { u8"Reserved for local use: qqy",                                "qqy",     "",   "",    true,  false },
  { u8"Reserved for local use: qqz",                                "qqz",     "",   "",    true,  false },
  { u8"Reserved for local use: qra",                                "qra",     "",   "",    true,  false },
  { u8"Reserved for local use: qrb",                                "qrb",     "",   "",    true,  false },
  { u8"Reserved for local use: qrc",                                "qrc",     "",   "",    true,  false },
  { u8"Reserved for local use: qrd",                                "qrd",     "",   "",    true,  false },
  { u8"Reserved for local use: qre",                                "qre",     "",   "",    true,  false },
  { u8"Reserved for local use: qrf",                                "qrf",     "",   "",    true,  false },
  { u8"Reserved for local use: qrg",                                "qrg",     "",   "",    true,  false },
  { u8"Reserved for local use: qrh",                                "qrh",     "",   "",    true,  false },
  { u8"Reserved for local use: qri",                                "qri",     "",   "",    true,  false },
  { u8"Reserved for local use: qrj",                                "qrj",     "",   "",    true,  false },
  { u8"Reserved for local use: qrk",                                "qrk",     "",   "",    true,  false },
  { u8"Reserved for local use: qrl",                                "qrl",     "",   "",    true,  false },
  { u8"Reserved for local use: qrm",                                "qrm",     "",   "",    true,  false },
  { u8"Reserved for local use: qrn",                                "qrn",     "",   "",    true,  false },
  { u8"Reserved for local use: qro",                                "qro",     "",   "",    true,  false },
  { u8"Reserved for local use: qrp",                                "qrp",     "",   "",    true,  false },
  { u8"Reserved for local use: qrq",                                "qrq",     "",   "",    true,  false },
  { u8"Reserved for local use: qrr",                                "qrr",     "",   "",    true,  false },
  { u8"Reserved for local use: qrs",                                "qrs",     "",   "",    true,  false },
  { u8"Reserved for local use: qrt",                                "qrt",     "",   "",    true,  false },
  { u8"Reserved for local use: qru",                                "qru",     "",   "",    true,  false },
  { u8"Reserved for local use: qrv",                                "qrv",     "",   "",    true,  false },
  { u8"Reserved for local use: qrw",                                "qrw",     "",   "",    true,  false },
  { u8"Reserved for local use: qrx",                                "qrx",     "",   "",    true,  false },
  { u8"Reserved for local use: qry",                                "qry",     "",   "",    true,  false },
  { u8"Reserved for local use: qrz",                                "qrz",     "",   "",    true,  false },
  { u8"Reserved for local use: qsa",                                "qsa",     "",   "",    true,  false },
  { u8"Reserved for local use: qsb",                                "qsb",     "",   "",    true,  false },
  { u8"Reserved for local use: qsc",                                "qsc",     "",   "",    true,  false },
  { u8"Reserved for local use: qsd",                                "qsd",     "",   "",    true,  false },
  { u8"Reserved for local use: qse",                                "qse",     "",   "",    true,  false },
  { u8"Reserved for local use: qsf",                                "qsf",     "",   "",    true,  false },
  { u8"Reserved for local use: qsg",                                "qsg",     "",   "",    true,  false },
  { u8"Reserved for local use: qsh",                                "qsh",     "",   "",    true,  false },
  { u8"Reserved for local use: qsi",                                "qsi",     "",   "",    true,  false },
  { u8"Reserved for local use: qsj",                                "qsj",     "",   "",    true,  false },
  { u8"Reserved for local use: qsk",                                "qsk",     "",   "",    true,  false },
  { u8"Reserved for local use: qsl",                                "qsl",     "",   "",    true,  false },
  { u8"Reserved for local use: qsm",                                "qsm",     "",   "",    true,  false },
  { u8"Reserved for local use: qsn",                                "qsn",     "",   "",    true,  false },
  { u8"Reserved for local use: qso",                                "qso",     "",   "",    true,  false },
  { u8"Reserved for local use: qsp",                                "qsp",     "",   "",    true,  false },
  { u8"Reserved for local use: qsq",                                "qsq",     "",   "",    true,  false },
  { u8"Reserved for local use: qsr",                                "qsr",     "",   "",    true,  false },
  { u8"Reserved for local use: qss",                                "qss",     "",   "",    true,  false },
  { u8"Reserved for local use: qst",                                "qst",     "",   "",    true,  false },
  { u8"Reserved for local use: qsu",                                "qsu",     "",   "",    true,  false },
  { u8"Reserved for local use: qsv",                                "qsv",     "",   "",    true,  false },
  { u8"Reserved for local use: qsw",                                "qsw",     "",   "",    true,  false },
  { u8"Reserved for local use: qsx",                                "qsx",     "",   "",    true,  false },
  { u8"Reserved for local use: qsy",                                "qsy",     "",   "",    true,  false },
  { u8"Reserved for local use: qsz",                                "qsz",     "",   "",    true,  false },
  { u8"Reserved for local use: qta",                                "qta",     "",   "",    true,  false },
  { u8"Reserved for local use: qtb",                                "qtb",     "",   "",    true,  false },
  { u8"Reserved for local use: qtc",                                "qtc",     "",   "",    true,  false },
  { u8"Reserved for local use: qtd",                                "qtd",     "",   "",    true,  false },
  { u8"Reserved for local use: qte",                                "qte",     "",   "",    true,  false },
  { u8"Reserved for local use: qtf",                                "qtf",     "",   "",    true,  false },
  { u8"Reserved for local use: qtg",                                "qtg",     "",   "",    true,  false },
  { u8"Reserved for local use: qth",                                "qth",     "",   "",    true,  false },
  { u8"Reserved for local use: qti",                                "qti",     "",   "",    true,  false },
  { u8"Reserved for local use: qtj",                                "qtj",     "",   "",    true,  false },
  { u8"Reserved for local use: qtk",                                "qtk",     "",   "",    true,  false },
  { u8"Reserved for local use: qtl",                                "qtl",     "",   "",    true,  false },
  { u8"Reserved for local use: qtm",                                "qtm",     "",   "",    true,  false },
  { u8"Reserved for local use: qtn",                                "qtn",     "",   "",    true,  false },
  { u8"Reserved for local use: qto",                                "qto",     "",   "",    true,  false },
  { u8"Reserved for local use: qtp",                                "qtp",     "",   "",    true,  false },
  { u8"Reserved for local use: qtq",                                "qtq",     "",   "",    true,  false },
  { u8"Reserved for local use: qtr",                                "qtr",     "",   "",    true,  false },
  { u8"Reserved for local use: qts",                                "qts",     "",   "",    true,  false },
  { u8"Reserved for local use: qtt",                                "qtt",     "",   "",    true,  false },
  { u8"Reserved for local use: qtu",                                "qtu",     "",   "",    true,  false },
  { u8"Reserved for local use: qtv",                                "qtv",     "",   "",    true,  false },
  { u8"Reserved for local use: qtw",                                "qtw",     "",   "",    true,  false },
  { u8"Reserved for local use: qtx",                                "qtx",     "",   "",    true,  false },
  { u8"Reserved for local use: qty",                                "qty",     "",   "",    true,  false },
  { u8"Reserved for local use: qtz",                                "qtz",     "",   "",    true,  false },
  { u8"Reshe",                                                      "res",     "",   "",    false, false },
  { u8"Resígaro",                                                   "rgr",     "",   "",    false, false },
  { u8"Retta",                                                      "ret",     "",   "",    false, false },
  { u8"Reyesano",                                                   "rey",     "",   "",    false, false },
  { u8"Riang (India)",                                              "ria",     "",   "",    false, false },
  { u8"Riang Lai",                                                  "yin",     "",   "",    false, false },
  { u8"Riang Lang",                                                 "ril",     "",   "",    false, false },
  { u8"Riantana",                                                   "ran",     "",   "",    false, false },
  { u8"Ribun",                                                      "rir",     "",   "",    false, false },
  { u8"Rien",                                                       "rie",     "",   "",    false, true  },
  { u8"Rigwe",                                                      "iri",     "",   "",    false, false },
  { u8"Rikbaktsa",                                                  "rkb",     "",   "",    false, false },
  { u8"Rinconada Bikol",                                            "bto",     "",   "",    false, false },
  { u8"Rincón Zapotec",                                             "zar",     "",   "",    false, false },
  { u8"Ringgou",                                                    "rgu",     "",   "",    false, false },
  { u8"Ririo",                                                      "rri",     "",   "",    false, false },
  { u8"Ritharrngu",                                                 "rit",     "",   "",    false, false },
  { u8"Riung",                                                      "riu",     "",   "",    false, false },
  { u8"Riverain Sango",                                             "snj",     "",   "",    false, false },
  { u8"Rmeet",                                                      "lbn",     "",   "",    false, false },
  { u8"Rogo",                                                       "rod",     "",   "",    false, false },
  { u8"Rohingya",                                                   "rhg",     "",   "",    false, false },
  { u8"Roma",                                                       "rmm",     "",   "",    false, false },
  { u8"Romagnol",                                                   "rgn",     "",   "",    false, false },
  { u8"Romam",                                                      "rmx",     "",   "",    false, false },
  { u8"Romance languages",                                          "roa",     "",   "",    true,  false },
  { u8"Romanian Sign Language",                                     "rms",     "",   "",    false, false },
  { u8"Romanian",                                                   "rum",     "ro", "ron", true,  false },
  { u8"Romano-Greek",                                               "rge",     "",   "",    false, false },
  { u8"Romano-Serbian",                                             "rsb",     "",   "",    false, false },
  { u8"Romanova",                                                   "rmv",     "",   "",    false, false },
  { u8"Romansh",                                                    "roh",     "rm", "",    true,  false },
  { u8"Romany",                                                     "rom",     "",   "",    true,  false },
  { u8"Romblomanon",                                                "rol",     "",   "",    false, false },
  { u8"Rombo",                                                      "rof",     "",   "",    false, false },
  { u8"Romkun",                                                     "rmk",     "",   "",    false, false },
  { u8"Ron",                                                        "cla",     "",   "",    false, false },
  { u8"Ronga",                                                      "rng",     "",   "",    false, false },
  { u8"Rongga",                                                     "ror",     "",   "",    false, false },
  { u8"Rongmei Naga",                                               "nbu",     "",   "",    false, false },
  { u8"Rongpo",                                                     "rnp",     "",   "",    false, false },
  { u8"Ronji",                                                      "roe",     "",   "",    false, false },
  { u8"Roon",                                                       "rnn",     "",   "",    false, false },
  { u8"Roria",                                                      "rga",     "",   "",    false, false },
  { u8"Rotokas",                                                    "roo",     "",   "",    false, false },
  { u8"Rotuman",                                                    "rtm",     "",   "",    false, false },
  { u8"Roviana",                                                    "rug",     "",   "",    false, false },
  { u8"Ruching Palaung",                                            "pce",     "",   "",    false, false },
  { u8"Rudbari",                                                    "rdb",     "",   "",    false, false },
  { u8"Rufiji",                                                     "rui",     "",   "",    false, false },
  { u8"Ruga",                                                       "ruh",     "",   "",    false, false },
  { u8"Rukai",                                                      "dru",     "",   "",    false, false },
  { u8"Ruma",                                                       "ruz",     "",   "",    false, false },
  { u8"Rumai Palaung",                                              "rbb",     "",   "",    false, false },
  { u8"Rumu",                                                       "klq",     "",   "",    false, false },
  { u8"Runa",                                                       "rna",     "",   "",    false, true  },
  { u8"Rundi",                                                      "run",     "rn", "",    true,  false },
  { u8"Runga",                                                      "rou",     "",   "",    false, false },
  { u8"Rungtu Chin",                                                "rtc",     "",   "",    false, false },
  { u8"Rungus",                                                     "drg",     "",   "",    false, false },
  { u8"Rungwa",                                                     "rnw",     "",   "",    false, false },
  { u8"Russia Buriat",                                              "bxr",     "",   "",    false, false },
  { u8"Russian Sign Language",                                      "rsl",     "",   "",    false, false },
  { u8"Russian",                                                    "rus",     "ru", "",    true,  false },
  { u8"Rusyn",                                                      "rue",     "",   "",    false, false },
  { u8"Ruthenian",                                                  "rsk",     "",   "",    false, false },
  { u8"Rutul",                                                      "rut",     "",   "",    false, false },
  { u8"Ruuli",                                                      "ruc",     "",   "",    false, false },
  { u8"Ruund",                                                      "rnd",     "",   "",    false, false },
  { u8"Ruwila",                                                     "rwl",     "",   "",    false, false },
  { u8"Rwa",                                                        "rwk",     "",   "",    false, false },
  { u8"Rwandan Sign Language",                                      "rsn",     "",   "",    false, false },
  { u8"Réunion Creole French",                                      "rcf",     "",   "",    false, false },
  { u8"Rāziḥī",                                                     "rzh",     "",   "",    false, false },
  { u8"S'gaw Karen",                                                "ksw",     "",   "",    false, false },
  { u8"Sa",                                                         "sax",     "",   "",    false, false },
  { u8"Sa'a",                                                       "apb",     "",   "",    false, false },
  { u8"Sa'ban",                                                     "snv",     "",   "",    false, false },
  { u8"Sa'och",                                                     "scq",     "",   "",    false, false },
  { u8"Saafi-Saafi",                                                "sav",     "",   "",    false, false },
  { u8"Saam",                                                       "raq",     "",   "",    false, false },
  { u8"Saamia",                                                     "lsm",     "",   "",    false, false },
  { u8"Saaroa",                                                     "sxr",     "",   "",    false, false },
  { u8"Saba",                                                       "saa",     "",   "",    false, false },
  { u8"Sabaean",                                                    "xsa",     "",   "",    false, false },
  { u8"Sabah Bisaya",                                               "bsy",     "",   "",    false, false },
  { u8"Sabah Malay",                                                "msi",     "",   "",    false, false },
  { u8"Sabanê",                                                     "sae",     "",   "",    false, false },
  { u8"Sabaot",                                                     "spy",     "",   "",    false, false },
  { u8"Sabine",                                                     "sbv",     "",   "",    false, false },
  { u8"Sabu",                                                       "hvn",     "",   "",    false, false },
  { u8"Sabüm",                                                      "sbo",     "",   "",    false, false },
  { u8"Sacapulteco",                                                "quv",     "",   "",    false, false },
  { u8"Sadri",                                                      "sck",     "",   "",    false, false },
  { u8"Saek",                                                       "skb",     "",   "",    false, false },
  { u8"Saep",                                                       "spd",     "",   "",    false, false },
  { u8"Safaliba",                                                   "saf",     "",   "",    false, false },
  { u8"Safeyoka",                                                   "apz",     "",   "",    false, false },
  { u8"Safwa",                                                      "sbk",     "",   "",    false, false },
  { u8"Sagala",                                                     "sbm",     "",   "",    false, false },
  { u8"Sagalla",                                                    "tga",     "",   "",    false, false },
  { u8"Saho",                                                       "ssy",     "",   "",    false, false },
  { u8"Sahu",                                                       "saj",     "",   "",    false, false },
  { u8"Saidi Arabic",                                               "aec",     "",   "",    false, false },
  { u8"Saint Lucian Creole French",                                 "acf",     "",   "",    false, false },
  { u8"Saisiyat",                                                   "xsy",     "",   "",    false, false },
  { u8"Sajalong",                                                   "sjl",     "",   "",    false, false },
  { u8"Sajau Basap",                                                "sjb",     "",   "",    false, false },
  { u8"Sakachep",                                                   "sch",     "",   "",    false, false },
  { u8"Sakalava Malagasy",                                          "skg",     "",   "",    false, false },
  { u8"Sakao",                                                      "sku",     "",   "",    false, false },
  { u8"Sakata",                                                     "skt",     "",   "",    false, false },
  { u8"Sake",                                                       "sak",     "",   "",    false, false },
  { u8"Sakirabiá",                                                  "skf",     "",   "",    false, false },
  { u8"Sakizaya",                                                   "szy",     "",   "",    false, false },
  { u8"Sala",                                                       "shq",     "",   "",    false, false },
  { u8"Salampasu",                                                  "slx",     "",   "",    false, false },
  { u8"Salar",                                                      "slr",     "",   "",    false, false },
  { u8"Salas",                                                      "sgu",     "",   "",    false, false },
  { u8"Salasaca Highland Quichua",                                  "qxl",     "",   "",    false, false },
  { u8"Salawati",                                                   "xmx",     "",   "",    false, false },
  { u8"Salchuq",                                                    "slq",     "",   "",    false, false },
  { u8"Saleman",                                                    "sau",     "",   "",    false, false },
  { u8"Saliba",                                                     "sbe",     "",   "",    false, false },
  { u8"Salinan",                                                    "sln",     "",   "",    false, false },
  { u8"Salishan languages",                                         "sal",     "",   "",    true,  false },
  { u8"Sallands",                                                   "sdz",     "",   "",    false, false },
  { u8"Salt-Yui",                                                   "sll",     "",   "",    false, false },
  { u8"Saluan",                                                     "loe",     "",   "",    false, false },
  { u8"Salumá",                                                     "slj",     "",   "",    false, false },
  { u8"Salvadoran Sign Language",                                   "esn",     "",   "",    false, false },
  { u8"Sam",                                                        "snx",     "",   "",    false, false },
  { u8"Sama",                                                       "smd",     "",   "",    false, true  },
  { u8"Samaritan Aramaic",                                          "sam",     "",   "",    true,  false },
  { u8"Samaritan",                                                  "smp",     "",   "",    false, false },
  { u8"Samarokena",                                                 "tmj",     "",   "",    false, false },
  { u8"Samatao",                                                    "ysd",     "",   "",    false, false },
  { u8"Samay",                                                      "syx",     "",   "",    false, false },
  { u8"Samba Daka",                                                 "ccg",     "",   "",    false, false },
  { u8"Samba Leko",                                                 "ndi",     "",   "",    false, false },
  { u8"Samba",                                                      "smx",     "",   "",    false, false },
  { u8"Sambal",                                                     "xsb",     "",   "",    false, false },
  { u8"Sambalpuri",                                                 "spv",     "",   "",    false, false },
  { u8"Sambe",                                                      "xab",     "",   "",    false, false },
  { u8"Samberigi",                                                  "ssx",     "",   "",    false, false },
  { u8"Samburu",                                                    "saq",     "",   "",    false, false },
  { u8"Samei",                                                      "smh",     "",   "",    false, false },
  { u8"Sami languages",                                             "smi",     "",   "",    true,  false },
  { u8"Samo",                                                       "smq",     "",   "",    false, false },
  { u8"Samoan",                                                     "smo",     "sm", "",    true,  false },
  { u8"Samogitian",                                                 "sgs",     "",   "",    false, false },
  { u8"Samosa",                                                     "swm",     "",   "",    false, false },
  { u8"Samoyedic languages",                                        "syd",     "",   "",    false, false },
  { u8"Sampang",                                                    "rav",     "",   "",    false, false },
  { u8"Samre",                                                      "sxm",     "",   "",    false, false },
  { u8"Samtao",                                                     "stu",     "",   "",    false, false },
  { u8"Samvedi",                                                    "smv",     "",   "",    false, false },
  { u8"San Agustín Mixtepec Zapotec",                               "ztm",     "",   "",    false, false },
  { u8"San Baltazar Loxicha Zapotec",                               "zpx",     "",   "",    false, false },
  { u8"San Blas Kuna",                                              "cuk",     "",   "",    false, false },
  { u8"San Dionisio Del Mar Huave",                                 "hve",     "",   "",    false, false },
  { u8"San Felipe Otlaltepec Popoloca",                             "pow",     "",   "",    false, false },
  { u8"San Francisco Del Mar Huave",                                "hue",     "",   "",    false, false },
  { u8"San Francisco Matlatzinca",                                  "mat",     "",   "",    false, false },
  { u8"San Jerónimo Tecóatl Mazatec",                               "maa",     "",   "",    false, false },
  { u8"San Juan Atzingo Popoloca",                                  "poe",     "",   "",    false, false },
  { u8"San Juan Colorado Mixtec",                                   "mjc",     "",   "",    false, false },
  { u8"San Juan Teita Mixtec",                                      "xtj",     "",   "",    false, false },
  { u8"San Luís Temalacayuca Popoloca",                             "pps",     "",   "",    false, false },
  { u8"San Marcos Tlacoyalco Popoloca",                             "pls",     "",   "",    false, false },
  { u8"San Martín Itunyoso Triqui",                                 "trq",     "",   "",    false, false },
  { u8"San Martín Quechua",                                         "qvs",     "",   "",    false, false },
  { u8"San Mateo Del Mar Huave",                                    "huv",     "",   "",    false, false },
  { u8"San Miguel Creole French",                                   "scf",     "",   "",    false, false },
  { u8"San Miguel El Grande Mixtec",                                "mig",     "",   "",    false, false },
  { u8"San Miguel Piedras Mixtec",                                  "xtp",     "",   "",    false, false },
  { u8"San Pedro Amuzgos Amuzgo",                                   "azg",     "",   "",    false, false },
  { u8"San Pedro Quiatoni Zapotec",                                 "zpf",     "",   "",    false, false },
  { u8"San Salvador Kongo",                                         "kwy",     "",   "",    false, false },
  { u8"San Vicente Coatlán Zapotec",                                "zpt",     "",   "",    false, false },
  { u8"Sanaani Arabic",                                             "ayn",     "",   "",    false, false },
  { u8"Sanapaná",                                                   "sap",     "",   "",    false, true  },
  { u8"Sanapaná",                                                   "spn",     "",   "",    false, false },
  { u8"Sandawe",                                                    "sad",     "",   "",    true,  false },
  { u8"Sanga (Democratic Republic of Congo)",                       "sng",     "",   "",    false, false },
  { u8"Sanga (Nigeria)",                                            "xsn",     "",   "",    false, false },
  { u8"Sangab Mandaya",                                             "myt",     "",   "",    false, true  },
  { u8"Sanggau",                                                    "scg",     "",   "",    false, false },
  { u8"Sangil",                                                     "snl",     "",   "",    false, false },
  { u8"Sangir",                                                     "sxn",     "",   "",    false, false },
  { u8"Sangisari",                                                  "sgr",     "",   "",    false, false },
  { u8"Sangkong",                                                   "sgk",     "",   "",    false, false },
  { u8"Sanglechi",                                                  "sgy",     "",   "",    false, false },
  { u8"Sanglechi-Ishkashimi",                                       "sgl",     "",   "",    false, true  },
  { u8"Sango",                                                      "sag",     "sg", "",    true,  false },
  { u8"Sangtam Naga",                                               "nsa",     "",   "",    false, false },
  { u8"Sangu (Gabon)",                                              "snq",     "",   "",    false, false },
  { u8"Sangu (Tanzania)",                                           "sbp",     "",   "",    false, false },
  { u8"Sani",                                                       "ysn",     "",   "",    false, false },
  { u8"Sanie",                                                      "ysy",     "",   "",    false, false },
  { u8"Saniyo-Hiyewe",                                              "sny",     "",   "",    false, false },
  { u8"Sankaran Maninka",                                           "msc",     "",   "",    false, false },
  { u8"Sansi",                                                      "ssi",     "",   "",    false, false },
  { u8"Sanskrit",                                                   "san",     "sa", "",    true,  false },
  { u8"Sansu",                                                      "sca",     "",   "",    false, true  },
  { u8"Santa Ana de Tusi Pasco Quechua",                            "qxt",     "",   "",    false, false },
  { u8"Santa Catarina Albarradas Zapotec",                          "ztn",     "",   "",    false, false },
  { u8"Santa Inés Ahuatempan Popoloca",                             "pca",     "",   "",    false, false },
  { u8"Santa Inés Yatzechi Zapotec",                                "zpn",     "",   "",    false, false },
  { u8"Santa Lucía Monteverde Mixtec",                              "mdv",     "",   "",    false, false },
  { u8"Santa María Del Mar Huave",                                  "hvv",     "",   "",    false, false },
  { u8"Santa María La Alta Nahuatl",                                "nhz",     "",   "",    false, false },
  { u8"Santa María Quiegolani Zapotec",                             "zpi",     "",   "",    false, false },
  { u8"Santa María Zacatepec Mixtec",                               "mza",     "",   "",    false, false },
  { u8"Santa Teresa Cora",                                          "cok",     "",   "",    false, false },
  { u8"Santali",                                                    "sat",     "",   "",    true,  false },
  { u8"Santiago Xanica Zapotec",                                    "zpr",     "",   "",    false, false },
  { u8"Santiago del Estero Quichua",                                "qus",     "",   "",    false, false },
  { u8"Santo Domingo Albarradas Zapotec",                           "zas",     "",   "",    false, false },
  { u8"Sanumá",                                                     "xsu",     "",   "",    false, false },
  { u8"Saparua",                                                    "spr",     "",   "",    false, false },
  { u8"Sapo",                                                       "krn",     "",   "",    false, false },
  { u8"Saponi",                                                     "spi",     "",   "",    false, false },
  { u8"Saposa",                                                     "sps",     "",   "",    false, false },
  { u8"Sapuan",                                                     "spu",     "",   "",    false, false },
  { u8"Sapé",                                                       "spc",     "",   "",    false, false },
  { u8"Sar",                                                        "mwm",     "",   "",    false, false },
  { u8"Sara Dunjo",                                                 "koj",     "",   "",    false, true  },
  { u8"Sara Kaba Deme",                                             "kwg",     "",   "",    false, false },
  { u8"Sara Kaba Náà",                                              "kwv",     "",   "",    false, false },
  { u8"Sara Kaba",                                                  "sbz",     "",   "",    false, false },
  { u8"Sara",                                                       "sre",     "",   "",    false, false },
  { u8"Saraiki",                                                    "skr",     "",   "",    false, false },
  { u8"Saramaccan",                                                 "srm",     "",   "",    false, false },
  { u8"Sarangani Blaan",                                            "bps",     "",   "",    false, false },
  { u8"Sarangani Manobo",                                           "mbs",     "",   "",    false, false },
  { u8"Sarasira",                                                   "zsa",     "",   "",    false, false },
  { u8"Saraveca",                                                   "sar",     "",   "",    false, false },
  { u8"Sardinian",                                                  "srd",     "sc", "",    true,  false },
  { u8"Sari",                                                       "asj",     "",   "",    false, false },
  { u8"Sarikoli",                                                   "srh",     "",   "",    false, false },
  { u8"Sarli",                                                      "sdf",     "",   "",    false, false },
  { u8"Sarsi",                                                      "srs",     "",   "",    false, false },
  { u8"Sartang",                                                    "onp",     "",   "",    false, false },
  { u8"Sarua",                                                      "swy",     "",   "",    false, false },
  { u8"Sarudu",                                                     "sdu",     "",   "",    false, false },
  { u8"Saruga",                                                     "sra",     "",   "",    false, false },
  { u8"Sasak",                                                      "sas",     "",   "",    true,  false },
  { u8"Sasaru",                                                     "sxs",     "",   "",    false, false },
  { u8"Sassarese Sardinian",                                        "sdc",     "",   "",    false, false },
  { u8"Satawalese",                                                 "stw",     "",   "",    false, false },
  { u8"Saterfriesisch",                                             "stq",     "",   "",    false, false },
  { u8"Sateré-Mawé",                                                "mav",     "",   "",    false, false },
  { u8"Saudi Arabian Sign Language",                                "sdl",     "",   "",    false, false },
  { u8"Sauraseni Prākrit",                                          "psu",     "",   "",    false, false },
  { u8"Saurashtra",                                                 "saz",     "",   "",    false, false },
  { u8"Sauri",                                                      "srt",     "",   "",    false, false },
  { u8"Sauria Paharia",                                             "mjt",     "",   "",    false, false },
  { u8"Sause",                                                      "sao",     "",   "",    false, false },
  { u8"Sausi",                                                      "ssj",     "",   "",    false, false },
  { u8"Savara",                                                     "svr",     "",   "",    false, true  },
  { u8"Savi",                                                       "sdg",     "",   "",    false, false },
  { u8"Savosavo",                                                   "svs",     "",   "",    false, false },
  { u8"Sawai",                                                      "szw",     "",   "",    false, false },
  { u8"Saweru",                                                     "swr",     "",   "",    false, false },
  { u8"Sawi",                                                       "saw",     "",   "",    false, false },
  { u8"Sawila",                                                     "swt",     "",   "",    false, false },
  { u8"Sawknah",                                                    "swn",     "",   "",    false, false },
  { u8"Saxwe Gbe",                                                  "sxw",     "",   "",    false, false },
  { u8"Saya",                                                       "say",     "",   "",    false, false },
  { u8"Sayula Popoluca",                                            "pos",     "",   "",    false, false },
  { u8"Scots",                                                      "sco",     "",   "",    true,  false },
  { u8"Scottish Gaelic",                                            "gla",     "gd", "",    true,  false },
  { u8"Scythian",                                                   "xsc",     "",   "",    false, false },
  { u8"Sea Island Creole English",                                  "gul",     "",   "",    false, false },
  { u8"Seba",                                                       "kdg",     "",   "",    false, false },
  { u8"Sebat Bet Gurage",                                           "sgw",     "",   "",    false, false },
  { u8"Seberuang",                                                  "sbx",     "",   "",    false, false },
  { u8"Sebop",                                                      "sib",     "",   "",    false, false },
  { u8"Sebuyau",                                                    "snb",     "",   "",    false, true  },
  { u8"Sechelt",                                                    "sec",     "",   "",    false, false },
  { u8"Secoya",                                                     "sey",     "",   "",    false, false },
  { u8"Sedang",                                                     "sed",     "",   "",    false, false },
  { u8"Sediq",                                                      "trv",     "",   "",    false, false },
  { u8"Sedoa",                                                      "tvw",     "",   "",    false, false },
  { u8"Seeku",                                                      "sos",     "",   "",    false, false },
  { u8"Segai",                                                      "sge",     "",   "",    false, false },
  { u8"Segeju",                                                     "seg",     "",   "",    false, false },
  { u8"Seget",                                                      "sbg",     "",   "",    false, false },
  { u8"Sehwi",                                                      "sfw",     "",   "",    false, false },
  { u8"Seimat",                                                     "ssg",     "",   "",    false, false },
  { u8"Seit-Kaitetu",                                               "hik",     "",   "",    false, false },
  { u8"Sekani",                                                     "sek",     "",   "",    false, false },
  { u8"Sekapan",                                                    "skp",     "",   "",    false, false },
  { u8"Sekar",                                                      "skz",     "",   "",    false, false },
  { u8"Seke (Nepal)",                                               "skj",     "",   "",    false, false },
  { u8"Seke (Vanuatu)",                                             "ske",     "",   "",    false, false },
  { u8"Sekele",                                                     "vaj",     "",   "",    false, false },
  { u8"Seki",                                                       "syi",     "",   "",    false, false },
  { u8"Seko Padang",                                                "skx",     "",   "",    false, false },
  { u8"Seko Tengah",                                                "sko",     "",   "",    false, false },
  { u8"Sekpele",                                                    "lip",     "",   "",    false, false },
  { u8"Selangor Sign Language",                                     "kgi",     "",   "",    false, false },
  { u8"Selaru",                                                     "slu",     "",   "",    false, false },
  { u8"Selayar",                                                    "sly",     "",   "",    false, false },
  { u8"Selee",                                                      "snw",     "",   "",    false, false },
  { u8"Selepet",                                                    "spl",     "",   "",    false, false },
  { u8"Selian",                                                     "sxl",     "",   "",    false, false },
  { u8"Selkup",                                                     "sel",     "",   "",    true,  false },
  { u8"Selungai Murut",                                             "slg",     "",   "",    false, false },
  { u8"Seluwasan",                                                  "sws",     "",   "",    false, false },
  { u8"Semai",                                                      "sea",     "",   "",    false, false },
  { u8"Semandang",                                                  "sdm",     "",   "",    false, true  },
  { u8"Semandang",                                                  "sdq",     "",   "",    false, false },
  { u8"Semaq Beri",                                                 "szc",     "",   "",    false, false },
  { u8"Sembakung Murut",                                            "sbr",     "",   "",    false, false },
  { u8"Semelai",                                                    "sza",     "",   "",    false, false },
  { u8"Semimi",                                                     "etz",     "",   "",    false, false },
  { u8"Semitic languages",                                          "sem",     "",   "",    true,  false },
  { u8"Semnam",                                                     "ssm",     "",   "",    false, false },
  { u8"Semnani",                                                    "smy",     "",   "",    false, false },
  { u8"Sempan",                                                     "xse",     "",   "",    false, false },
  { u8"Sena",                                                       "seh",     "",   "",    false, false },
  { u8"Senara Sénoufo",                                             "seq",     "",   "",    false, false },
  { u8"Senaya",                                                     "syn",     "",   "",    false, false },
  { u8"Sene",                                                       "sej",     "",   "",    false, false },
  { u8"Seneca",                                                     "see",     "",   "",    false, false },
  { u8"Sened",                                                      "sds",     "",   "",    false, false },
  { u8"Sengele",                                                    "szg",     "",   "",    false, false },
  { u8"Senggi",                                                     "snu",     "",   "",    false, false },
  { u8"Sengo",                                                      "spk",     "",   "",    false, false },
  { u8"Sengseng",                                                   "ssz",     "",   "",    false, false },
  { u8"Senhaja De Srair",                                           "sjs",     "",   "",    false, false },
  { u8"Sensi",                                                      "sni",     "",   "",    false, false },
  { u8"Sentani",                                                    "set",     "",   "",    false, false },
  { u8"Senthang Chin",                                              "sez",     "",   "",    false, false },
  { u8"Sentinel",                                                   "std",     "",   "",    false, false },
  { u8"Sepa (Indonesia)",                                           "spb",     "",   "",    false, false },
  { u8"Sepa (Papua New Guinea)",                                    "spe",     "",   "",    false, false },
  { u8"Sepik Iwam",                                                 "iws",     "",   "",    false, false },
  { u8"Sera",                                                       "sry",     "",   "",    false, false },
  { u8"Serbian",                                                    "srp",     "sr", "",    true,  false },
  { u8"Serbo-Croatian",                                             "hbs",     "sh", "",    false, false },
  { u8"Sere",                                                       "swf",     "",   "",    false, false },
  { u8"Serer",                                                      "srr",     "",   "",    true,  false },
  { u8"Seri",                                                       "sei",     "",   "",    false, false },
  { u8"Serili",                                                     "sve",     "",   "",    false, false },
  { u8"Seroa",                                                      "kqu",     "",   "",    false, false },
  { u8"Serrano",                                                    "ser",     "",   "",    false, false },
  { u8"Seru",                                                       "szd",     "",   "",    false, false },
  { u8"Serua",                                                      "srw",     "",   "",    false, false },
  { u8"Serudung Murut",                                             "srk",     "",   "",    false, false },
  { u8"Serui-Laut",                                                 "seu",     "",   "",    false, false },
  { u8"Seselwa Creole French",                                      "crs",     "",   "",    false, false },
  { u8"Seta",                                                       "stf",     "",   "",    false, false },
  { u8"Setaman",                                                    "stm",     "",   "",    false, false },
  { u8"Seti",                                                       "sbi",     "",   "",    false, false },
  { u8"Settla",                                                     "sta",     "",   "",    false, false },
  { u8"Severn Ojibwa",                                              "ojs",     "",   "",    false, false },
  { u8"Sewa Bay",                                                   "sew",     "",   "",    false, false },
  { u8"Seychelles Sign Language",                                   "lsw",     "",   "",    false, false },
  { u8"Seze",                                                       "sze",     "",   "",    false, false },
  { u8"Sha",                                                        "scw",     "",   "",    false, false },
  { u8"Shabak",                                                     "sdb",     "",   "",    false, false },
  { u8"Shahmirzadi",                                                "srz",     "",   "",    false, false },
  { u8"Shahrudi",                                                   "shm",     "",   "",    false, false },
  { u8"Shall-Zwall",                                                "sha",     "",   "",    false, false },
  { u8"Shama-Sambuga",                                              "sqa",     "",   "",    false, false },
  { u8"Shamang",                                                    "xsh",     "",   "",    false, false },
  { u8"Shambala",                                                   "ksb",     "",   "",    false, false },
  { u8"Shan",                                                       "shn",     "",   "",    true,  false },
  { u8"Shanenawa",                                                  "swo",     "",   "",    false, false },
  { u8"Shanga",                                                     "sho",     "",   "",    false, false },
  { u8"Sharanahua",                                                 "mcd",     "",   "",    false, false },
  { u8"Shark Bay",                                                  "ssv",     "",   "",    false, false },
  { u8"Sharwa",                                                     "swq",     "",   "",    false, false },
  { u8"Shasta",                                                     "sht",     "",   "",    false, false },
  { u8"Shatt",                                                      "shj",     "",   "",    false, false },
  { u8"Shau",                                                       "sqh",     "",   "",    false, false },
  { u8"Shawnee",                                                    "sjw",     "",   "",    false, false },
  { u8"She",                                                        "shx",     "",   "",    false, false },
  { u8"Shehri",                                                     "shv",     "",   "",    false, false },
  { u8"Shekhawati",                                                 "swv",     "",   "",    false, false },
  { u8"Shekkacho",                                                  "moy",     "",   "",    false, false },
  { u8"Sheko",                                                      "she",     "",   "",    false, false },
  { u8"Shelta",                                                     "sth",     "",   "",    false, false },
  { u8"Shempire Senoufo",                                           "seb",     "",   "",    false, false },
  { u8"Shendu",                                                     "shl",     "",   "",    false, false },
  { u8"Sheni",                                                      "scv",     "",   "",    false, false },
  { u8"Sherbro",                                                    "bun",     "",   "",    false, false },
  { u8"Sherdukpen",                                                 "sdp",     "",   "",    false, false },
  { u8"Sherpa",                                                     "xsr",     "",   "",    false, false },
  { u8"Sheshi Kham",                                                "kip",     "",   "",    false, false },
  { u8"Shi",                                                        "shr",     "",   "",    false, false },
  { u8"Shihhi Arabic",                                              "ssh",     "",   "",    false, false },
  { u8"Shiki",                                                      "gua",     "",   "",    false, false },
  { u8"Shilluk",                                                    "shk",     "",   "",    false, false },
  { u8"Shina",                                                      "scl",     "",   "",    false, false },
  { u8"Shinabo",                                                    "snh",     "",   "",    false, true  },
  { u8"Shipibo-Conibo",                                             "shp",     "",   "",    false, false },
  { u8"Sholaga",                                                    "sle",     "",   "",    false, false },
  { u8"Shom Peng",                                                  "sii",     "",   "",    false, false },
  { u8"Shona",                                                      "sna",     "sn", "",    true,  false },
  { u8"Shoo-Minda-Nye",                                             "bcv",     "",   "",    false, false },
  { u8"Shor",                                                       "cjs",     "",   "",    false, false },
  { u8"Shoshoni",                                                   "shh",     "",   "",    false, false },
  { u8"Shua",                                                       "shg",     "",   "",    false, false },
  { u8"Shuadit",                                                    "sdt",     "",   "",    false, false },
  { u8"Shuar",                                                      "jiv",     "",   "",    false, false },
  { u8"Shubi",                                                      "suj",     "",   "",    false, false },
  { u8"Shughni",                                                    "sgh",     "",   "",    false, false },
  { u8"Shuhi",                                                      "sxg",     "",   "",    false, false },
  { u8"Shumashti",                                                  "sts",     "",   "",    false, false },
  { u8"Shumcho",                                                    "scu",     "",   "",    false, false },
  { u8"Shuswap",                                                    "shs",     "",   "",    false, false },
  { u8"Shuwa-Zamani",                                               "ksa",     "",   "",    false, false },
  { u8"Shwai",                                                      "shw",     "",   "",    false, false },
  { u8"Shwe Palaung",                                               "pll",     "",   "",    false, false },
  { u8"Sialum",                                                     "slw",     "",   "",    false, false },
  { u8"Siamou",                                                     "sif",     "",   "",    false, false },
  { u8"Sian",                                                       "spg",     "",   "",    false, false },
  { u8"Siane",                                                      "snp",     "",   "",    false, false },
  { u8"Siang",                                                      "sya",     "",   "",    false, false },
  { u8"Siar-Lak",                                                   "sjr",     "",   "",    false, false },
  { u8"Siawi",                                                      "mmp",     "",   "",    false, false },
  { u8"Sibe",                                                       "nco",     "",   "",    false, false },
  { u8"Siberian Tatar",                                             "sty",     "",   "",    false, false },
  { u8"Sibu Melanau",                                               "sdx",     "",   "",    false, false },
  { u8"Sicanian",                                                   "sxc",     "",   "",    false, false },
  { u8"Sicel",                                                      "scx",     "",   "",    false, false },
  { u8"Sichuan Yi",                                                 "iii",     "ii", "",    true,  false },
  { u8"Sicilian",                                                   "scn",     "",   "",    true,  false },
  { u8"Siculo Arabic",                                              "sqr",     "",   "",    false, false },
  { u8"Sidamo",                                                     "sid",     "",   "",    true,  false },
  { u8"Sidetic",                                                    "xsd",     "",   "",    false, false },
  { u8"Sie",                                                        "erg",     "",   "",    false, false },
  { u8"Sierra Leone Sign Language",                                 "sgx",     "",   "",    false, false },
  { u8"Sierra Negra Nahuatl",                                       "nsu",     "",   "",    false, false },
  { u8"Sierra de Juárez Zapotec",                                   "zaa",     "",   "",    false, false },
  { u8"Sighu",                                                      "sxe",     "",   "",    false, false },
  { u8"Sign Languages",                                             "sgn",     "",   "",    true,  false },
  { u8"Sihan",                                                      "snr",     "",   "",    false, false },
  { u8"Sihuas Ancash Quechua",                                      "qws",     "",   "",    false, false },
  { u8"Sika",                                                       "ski",     "",   "",    false, false },
  { u8"Sikaiana",                                                   "sky",     "",   "",    false, false },
  { u8"Sikaritai",                                                  "tty",     "",   "",    false, false },
  { u8"Sikiana",                                                    "sik",     "",   "",    false, false },
  { u8"Sikkimese",                                                  "sip",     "",   "",    false, false },
  { u8"Siksika",                                                    "bla",     "",   "",    true,  false },
  { u8"Sikule",                                                     "skh",     "",   "",    false, false },
  { u8"Sila",                                                       "slt",     "",   "",    false, false },
  { u8"Silacayoapan Mixtec",                                        "mks",     "",   "",    false, false },
  { u8"Sileibi",                                                    "sbq",     "",   "",    false, false },
  { u8"Silesian",                                                   "szl",     "",   "",    false, false },
  { u8"Silimo",                                                     "wul",     "",   "",    false, false },
  { u8"Siliput",                                                    "mkc",     "",   "",    false, false },
  { u8"Silopi",                                                     "xsp",     "",   "",    false, false },
  { u8"Silt'e",                                                     "stv",     "",   "",    false, false },
  { u8"Simaa",                                                      "sie",     "",   "",    false, false },
  { u8"Simba",                                                      "sbw",     "",   "",    false, false },
  { u8"Simbali",                                                    "smg",     "",   "",    false, false },
  { u8"Simbari",                                                    "smb",     "",   "",    false, false },
  { u8"Simbo",                                                      "sbb",     "",   "",    false, false },
  { u8"Simeku",                                                     "smz",     "",   "",    false, false },
  { u8"Simeulue",                                                   "smr",     "",   "",    false, false },
  { u8"Simte",                                                      "smt",     "",   "",    false, false },
  { u8"Sinagen",                                                    "siu",     "",   "",    false, false },
  { u8"Sinasina",                                                   "sst",     "",   "",    false, false },
  { u8"Sinaugoro",                                                  "snc",     "",   "",    false, false },
  { u8"Sindarin",                                                   "sjn",     "",   "",    false, false },
  { u8"Sindhi Bhil",                                                "sbn",     "",   "",    false, false },
  { u8"Sindhi",                                                     "snd",     "sd", "",    true,  false },
  { u8"Sindihui Mixtec",                                            "xts",     "",   "",    false, false },
  { u8"Singa",                                                      "sgm",     "",   "",    false, false },
  { u8"Singapore Sign Language",                                    "sls",     "",   "",    false, false },
  { u8"Singpho",                                                    "sgp",     "",   "",    false, false },
  { u8"Sinhala",                                                    "sin",     "si", "",    true,  false },
  { u8"Sinicahua Mixtec",                                           "xti",     "",   "",    false, false },
  { u8"Sininkere",                                                  "skq",     "",   "",    false, false },
  { u8"Sino-Tibetan languages",                                     "sit",     "",   "",    true,  false },
  { u8"Sinte Romani",                                               "rmo",     "",   "",    false, false },
  { u8"Sinyar",                                                     "sys",     "",   "",    false, false },
  { u8"Sio",                                                        "xsi",     "",   "",    false, false },
  { u8"Siona",                                                      "snn",     "",   "",    false, false },
  { u8"Siouan languages",                                           "sio",     "",   "",    true,  false },
  { u8"Sipacapense",                                                "qum",     "",   "",    false, false },
  { u8"Sira",                                                       "swj",     "",   "",    false, false },
  { u8"Siraya",                                                     "fos",     "",   "",    false, false },
  { u8"Sirenik Yupik",                                              "ysr",     "",   "",    false, false },
  { u8"Siri",                                                       "sir",     "",   "",    false, false },
  { u8"Siriano",                                                    "sri",     "",   "",    false, false },
  { u8"Sirionó",                                                    "srq",     "",   "",    false, false },
  { u8"Sirmauri",                                                   "srx",     "",   "",    false, false },
  { u8"Siroi",                                                      "ssd",     "",   "",    false, false },
  { u8"Sissala",                                                    "sld",     "",   "",    false, false },
  { u8"Sissano",                                                    "sso",     "",   "",    false, false },
  { u8"Siuslaw",                                                    "sis",     "",   "",    false, false },
  { u8"Sivandi",                                                    "siy",     "",   "",    false, false },
  { u8"Sivia Sign Language",                                        "lsv",     "",   "",    false, false },
  { u8"Siwai",                                                      "siw",     "",   "",    false, false },
  { u8"Siwi",                                                       "siz",     "",   "",    false, false },
  { u8"Siwu",                                                       "akp",     "",   "",    false, false },
  { u8"Siyin Chin",                                                 "csy",     "",   "",    false, false },
  { u8"Skagit",                                                     "ska",     "",   "",    false, false },
  { u8"Skalvian",                                                   "svx",     "",   "",    false, false },
  { u8"Skepi Creole Dutch",                                         "skw",     "",   "",    false, false },
  { u8"Skolt Sami",                                                 "sms",     "",   "",    true,  false },
  { u8"Skou",                                                       "skv",     "",   "",    false, false },
  { u8"Slave (Athapascan)",                                         "den",     "",   "",    true,  false },
  { u8"Slavic languages",                                           "sla",     "",   "",    true,  false },
  { u8"Slavomolisano",                                              "svm",     "",   "",    false, false },
  { u8"Slovak",                                                     "slo",     "sk", "slk", true,  false },
  { u8"Slovakian Sign Language",                                    "svk",     "",   "",    false, false },
  { u8"Slovenian",                                                  "slv",     "sl", "",    true,  false },
  { u8"Small Flowery Miao",                                         "sfm",     "",   "",    false, false },
  { u8"Smärky Kanum",                                               "kxq",     "",   "",    false, false },
  { u8"Snohomish",                                                  "sno",     "",   "",    false, false },
  { u8"So (Democratic Republic of Congo)",                          "soc",     "",   "",    false, false },
  { u8"So'a",                                                       "ssq",     "",   "",    false, false },
  { u8"Sobei",                                                      "sob",     "",   "",    false, false },
  { u8"Sochiapam Chinantec",                                        "cso",     "",   "",    false, false },
  { u8"Soga",                                                       "xog",     "",   "",    false, false },
  { u8"Sogdian",                                                    "sog",     "",   "",    true,  false },
  { u8"Soi",                                                        "soj",     "",   "",    false, false },
  { u8"Sok",                                                        "skk",     "",   "",    false, true  },
  { u8"Sokoro",                                                     "sok",     "",   "",    false, false },
  { u8"Solano",                                                     "xso",     "",   "",    false, false },
  { u8"Soli",                                                       "sby",     "",   "",    false, false },
  { u8"Solomon Islands Sign Language",                              "szs",     "",   "",    false, false },
  { u8"Solong",                                                     "aaw",     "",   "",    false, false },
  { u8"Solos",                                                      "sol",     "",   "",    false, false },
  { u8"Som",                                                        "smc",     "",   "",    false, false },
  { u8"Somali",                                                     "som",     "so", "",    true,  false },
  { u8"Somba-Siawari",                                              "bmu",     "",   "",    false, false },
  { u8"Somrai",                                                     "sor",     "",   "",    false, false },
  { u8"Somray",                                                     "smu",     "",   "",    false, false },
  { u8"Somyev",                                                     "kgt",     "",   "",    false, false },
  { u8"Sonaga",                                                     "ysg",     "",   "",    false, false },
  { u8"Sonde",                                                      "shc",     "",   "",    false, false },
  { u8"Songa",                                                      "sgo",     "",   "",    false, true  },
  { u8"Songe",                                                      "sop",     "",   "",    false, false },
  { u8"Songhai languages",                                          "son",     "",   "",    true,  false },
  { u8"Songlai Chin",                                               "csj",     "",   "",    false, false },
  { u8"Songo",                                                      "soo",     "",   "",    false, false },
  { u8"Songomeno",                                                  "soe",     "",   "",    false, false },
  { u8"Songoora",                                                   "sod",     "",   "",    false, false },
  { u8"Sonha",                                                      "soi",     "",   "",    false, false },
  { u8"Sonia",                                                      "siq",     "",   "",    false, false },
  { u8"Soninke",                                                    "snk",     "",   "",    true,  false },
  { u8"Sonsorol",                                                   "sov",     "",   "",    false, false },
  { u8"Soo",                                                        "teu",     "",   "",    false, false },
  { u8"Sop",                                                        "urw",     "",   "",    false, false },
  { u8"Soqotri",                                                    "sqt",     "",   "",    false, false },
  { u8"Sora",                                                       "srb",     "",   "",    false, false },
  { u8"Sorbian languages",                                          "wen",     "",   "",    true,  false },
  { u8"Sori-Harengan",                                              "sbh",     "",   "",    false, false },
  { u8"Sorkhei",                                                    "sqo",     "",   "",    false, false },
  { u8"Sorothaptic",                                                "sxo",     "",   "",    false, false },
  { u8"Sorsogon Ayta",                                              "ays",     "",   "",    false, false },
  { u8"Sos Kundi",                                                  "sdk",     "",   "",    false, false },
  { u8"Sota Kanum",                                                 "krz",     "",   "",    false, false },
  { u8"Sou Nama",                                                   "tlt",     "",   "",    false, false },
  { u8"Sou Upaa",                                                   "wha",     "",   "",    false, false },
  { u8"Sou",                                                        "sqq",     "",   "",    false, false },
  { u8"South African Sign Language",                                "sfs",     "",   "",    false, false },
  { u8"South American Indian languages",                            "sai",     "",   "",    true,  false },
  { u8"South Awyu",                                                 "aws",     "",   "",    false, false },
  { u8"South Azerbaijani",                                          "azb",     "",   "",    false, false },
  { u8"South Bolivian Quechua",                                     "quh",     "",   "",    false, false },
  { u8"South Caucasian languages",                                  "ccs",     "",   "",    false, false },
  { u8"South Central Banda",                                        "lnl",     "",   "",    false, false },
  { u8"South Central Dinka",                                        "dib",     "",   "",    false, false },
  { u8"South Efate",                                                "erk",     "",   "",    false, false },
  { u8"South Fali",                                                 "fal",     "",   "",    false, false },
  { u8"South Giziga",                                               "giz",     "",   "",    false, false },
  { u8"South Lembata",                                              "lmf",     "",   "",    false, false },
  { u8"South Levantine Arabic",                                     "ajp",     "",   "",    false, false },
  { u8"South Marquesan",                                            "mqm",     "",   "",    false, false },
  { u8"South Muyu",                                                 "kts",     "",   "",    false, false },
  { u8"South Ndebele",                                              "nbl",     "nr", "",    true,  false },
  { u8"South Nuaulu",                                               "nxl",     "",   "",    false, false },
  { u8"South Picene",                                               "spx",     "",   "",    false, false },
  { u8"South Slavey",                                               "xsl",     "",   "",    false, false },
  { u8"South Slavic languages",                                     "zls",     "",   "",    false, false },
  { u8"South Tairora",                                              "omw",     "",   "",    false, false },
  { u8"South Ucayali Ashéninka",                                    "cpy",     "",   "",    false, false },
  { u8"South Watut",                                                "mcy",     "",   "",    false, false },
  { u8"South Wemale",                                               "tlw",     "",   "",    false, true  },
  { u8"South West Bay",                                             "sns",     "",   "",    false, false },
  { u8"Southeast Ambrym",                                           "tvk",     "",   "",    false, false },
  { u8"Southeast Babar",                                            "vbb",     "",   "",    false, false },
  { u8"Southeast Ijo",                                              "ijs",     "",   "",    false, false },
  { u8"Southeast Pashai",                                           "psi",     "",   "",    false, false },
  { u8"Southeast Tasmanian",                                        "xpf",     "",   "",    false, false },
  { u8"Southeastern Dinka",                                         "dks",     "",   "",    false, false },
  { u8"Southeastern Ixtlán Zapotec",                                "zpd",     "",   "",    false, false },
  { u8"Southeastern Kolami",                                        "nit",     "",   "",    false, false },
  { u8"Southeastern Nochixtlán Mixtec",                             "mxy",     "",   "",    false, false },
  { u8"Southeastern Pomo",                                          "pom",     "",   "",    false, false },
  { u8"Southeastern Puebla Nahuatl",                                "npl",     "",   "",    false, false },
  { u8"Southeastern Tarahumara",                                    "tcu",     "",   "",    false, false },
  { u8"Southeastern Tepehuan",                                      "stp",     "",   "",    false, false },
  { u8"Southern Alta",                                              "agy",     "",   "",    false, false },
  { u8"Southern Altai",                                             "alt",     "",   "",    true,  false },
  { u8"Southern Amami-Oshima",                                      "ams",     "",   "",    false, false },
  { u8"Southern Aymara",                                            "ayc",     "",   "",    false, false },
  { u8"Southern Bai",                                               "bfs",     "",   "",    false, false },
  { u8"Southern Balochi",                                           "bcc",     "",   "",    false, false },
  { u8"Southern Betsimisaraka Malagasy",                            "bjq",     "",   "",    false, true  },
  { u8"Southern Betsimisaraka Malagasy",                            "bzc",     "",   "",    false, false },
  { u8"Southern Binukidnon",                                        "mtw",     "",   "",    false, false },
  { u8"Southern Birifor",                                           "biv",     "",   "",    false, false },
  { u8"Southern Bobo Madaré",                                       "bwq",     "",   "",    false, false },
  { u8"Southern Bontok",                                            "obk",     "",   "",    false, false },
  { u8"Southern Carrier",                                           "caf",     "",   "",    false, false },
  { u8"Southern Catanduanes Bikol",                                 "bln",     "",   "",    false, false },
  { u8"Southern Conchucos Ancash Quechua",                          "qxo",     "",   "",    false, false },
  { u8"Southern Dagaare",                                           "dga",     "",   "",    false, false },
  { u8"Southern Dong",                                              "kmc",     "",   "",    false, false },
  { u8"Southern East Cree",                                         "crj",     "",   "",    false, false },
  { u8"Southern Ghale",                                             "ghe",     "",   "",    false, false },
  { u8"Southern Gondi",                                             "ggo",     "",   "",    false, true  },
  { u8"Southern Grebo",                                             "grj",     "",   "",    false, false },
  { u8"Southern Guiyang Hmong",                                     "hmy",     "",   "",    false, false },
  { u8"Southern Haida",                                             "hax",     "",   "",    false, false },
  { u8"Southern Hindko",                                            "hnd",     "",   "",    false, false },
  { u8"Southern Kalapuya",                                          "sxk",     "",   "",    false, false },
  { u8"Southern Kalinga",                                           "ksc",     "",   "",    false, false },
  { u8"Southern Katang",                                            "sct",     "",   "",    false, false },
  { u8"Southern Kisi",                                              "kss",     "",   "",    false, false },
  { u8"Southern Kiwai",                                             "kjd",     "",   "",    false, false },
  { u8"Southern Kurdish",                                           "sdh",     "",   "",    false, false },
  { u8"Southern Lolopo",                                            "ysp",     "",   "",    false, false },
  { u8"Southern Luri",                                              "luz",     "",   "",    false, false },
  { u8"Southern Ma'di",                                             "snm",     "",   "",    false, false },
  { u8"Southern Mashan Hmong",                                      "hma",     "",   "",    false, false },
  { u8"Southern Mnong",                                             "mnn",     "",   "",    false, false },
  { u8"Southern Muji",                                              "ymc",     "",   "",    false, false },
  { u8"Southern Nago",                                              "nqg",     "",   "",    false, false },
  { u8"Southern Nambikuára",                                        "nab",     "",   "",    false, false },
  { u8"Southern Ngbandi",                                           "nbw",     "",   "",    false, false },
  { u8"Southern Nicobarese",                                        "nik",     "",   "",    false, false },
  { u8"Southern Nisu",                                              "nsd",     "",   "",    false, false },
  { u8"Southern Nuni",                                              "nnw",     "",   "",    false, false },
  { u8"Southern Ohlone",                                            "css",     "",   "",    false, false },
  { u8"Southern One",                                               "osu",     "",   "",    false, false },
  { u8"Southern Pame",                                              "pmz",     "",   "",    false, false },
  { u8"Southern Pashto",                                            "pbt",     "",   "",    false, false },
  { u8"Southern Pastaza Quechua",                                   "qup",     "",   "",    false, false },
  { u8"Southern Ping Chinese",                                      "csp",     "",   "",    false, false },
  { u8"Southern Pomo",                                              "peq",     "",   "",    false, false },
  { u8"Southern Puebla Mixtec",                                     "mit",     "",   "",    false, false },
  { u8"Southern Puget Sound Salish",                                "slh",     "",   "",    false, false },
  { u8"Southern Pumi",                                              "pmj",     "",   "",    false, false },
  { u8"Southern Qiandong Miao",                                     "hms",     "",   "",    false, false },
  { u8"Southern Qiang",                                             "qxs",     "",   "",    false, false },
  { u8"Southern Rengma Naga",                                       "nre",     "",   "",    false, false },
  { u8"Southern Rincon Zapotec",                                    "zsr",     "",   "",    false, false },
  { u8"Southern Roglai",                                            "rgs",     "",   "",    false, false },
  { u8"Southern Sama",                                              "ssb",     "",   "",    false, false },
  { u8"Southern Sami",                                              "sma",     "",   "",    true,  false },
  { u8"Southern Samo",                                              "sbd",     "",   "",    false, false },
  { u8"Southern Sierra Miwok",                                      "skd",     "",   "",    false, false },
  { u8"Southern Sorsoganon",                                        "srv",     "",   "",    false, false },
  { u8"Southern Sotho",                                             "sot",     "st", "",    true,  false },
  { u8"Southern Subanen",                                           "laa",     "",   "",    false, false },
  { u8"Southern Thai",                                              "sou",     "",   "",    false, false },
  { u8"Southern Tidung",                                            "itd",     "",   "",    false, false },
  { u8"Southern Tiwa",                                              "tix",     "",   "",    false, false },
  { u8"Southern Toussian",                                          "wib",     "",   "",    false, false },
  { u8"Southern Tujia",                                             "tjs",     "",   "",    false, false },
  { u8"Southern Tutchone",                                          "tce",     "",   "",    false, false },
  { u8"Southern Uzbek",                                             "uzs",     "",   "",    false, false },
  { u8"Southern Yamphu",                                            "lrr",     "",   "",    false, false },
  { u8"Southern Yukaghir",                                          "yux",     "",   "",    false, false },
  { u8"Southwest Gbaya",                                            "gso",     "",   "",    false, false },
  { u8"Southwest Palawano",                                         "plv",     "",   "",    false, false },
  { u8"Southwest Pashai",                                           "psh",     "",   "",    false, false },
  { u8"Southwest Tanna",                                            "nwi",     "",   "",    false, false },
  { u8"Southwestern Bontok",                                        "vbk",     "",   "",    false, false },
  { u8"Southwestern Dinka",                                         "dik",     "",   "",    false, false },
  { u8"Southwestern Fars",                                          "fay",     "",   "",    false, false },
  { u8"Southwestern Guiyang Hmong",                                 "hmg",     "",   "",    false, false },
  { u8"Southwestern Huishui Hmong",                                 "hmh",     "",   "",    false, false },
  { u8"Southwestern Nisu",                                          "nsv",     "",   "",    false, false },
  { u8"Southwestern Tamang",                                        "tsf",     "",   "",    false, true  },
  { u8"Southwestern Tarahumara",                                    "twr",     "",   "",    false, false },
  { u8"Southwestern Tasmanian",                                     "xpx",     "",   "",    false, false },
  { u8"Southwestern Tepehuan",                                      "tla",     "",   "",    false, false },
  { u8"Southwestern Tlaxiaco Mixtec",                               "meh",     "",   "",    false, false },
  { u8"Sowa",                                                       "sww",     "",   "",    false, false },
  { u8"Sowanda",                                                    "sow",     "",   "",    false, false },
  { u8"Soyaltepec Mazatec",                                         "vmp",     "",   "",    false, false },
  { u8"Soyaltepec Mixtec",                                          "vmq",     "",   "",    false, false },
  { u8"Spanish Sign Language",                                      "ssp",     "",   "",    false, false },
  { u8"Spanish",                                                    "spa",     "es", "",    true,  false },
  { u8"Spiti Bhoti",                                                "spt",     "",   "",    false, false },
  { u8"Spokane",                                                    "spo",     "",   "",    false, false },
  { u8"Squamish",                                                   "squ",     "",   "",    false, false },
  { u8"Sranan Tongo",                                               "srn",     "",   "",    true,  false },
  { u8"Sri Lankan Creole Malay",                                    "sci",     "",   "",    false, false },
  { u8"Sri Lankan Sign Language",                                   "sqs",     "",   "",    false, false },
  { u8"Standard Arabic",                                            "arb",     "",   "",    false, false },
  { u8"Standard Estonian",                                          "ekk",     "",   "",    false, false },
  { u8"Standard Latvian",                                           "lvs",     "",   "",    false, false },
  { u8"Standard Malay",                                             "zsm",     "",   "",    false, false },
  { u8"Standard Moroccan Tamazight",                                "zgh",     "",   "",    true,  false },
  { u8"Stellingwerfs",                                              "stl",     "",   "",    false, false },
  { u8"Stod Bhoti",                                                 "sbu",     "",   "",    false, false },
  { u8"Stoney",                                                     "sto",     "",   "",    false, false },
  { u8"Straits Salish",                                             "str",     "",   "",    false, false },
  { u8"Suabo",                                                      "szp",     "",   "",    false, false },
  { u8"Suarmin",                                                    "seo",     "",   "",    false, false },
  { u8"Suau",                                                       "swp",     "",   "",    false, false },
  { u8"Suba",                                                       "sxb",     "",   "",    false, false },
  { u8"Suba-Simbiti",                                               "ssc",     "",   "",    false, false },
  { u8"Subi",                                                       "xsj",     "",   "",    false, false },
  { u8"Subiya",                                                     "sbs",     "",   "",    false, false },
  { u8"Subtiaba",                                                   "sut",     "",   "",    false, false },
  { u8"Sudanese Arabic",                                            "apd",     "",   "",    false, false },
  { u8"Sudanese Creole Arabic",                                     "pga",     "",   "",    false, false },
  { u8"Sudest",                                                     "tgo",     "",   "",    false, false },
  { u8"Sudovian",                                                   "xsv",     "",   "",    false, false },
  { u8"Suena",                                                      "sue",     "",   "",    false, false },
  { u8"Suga",                                                       "sgi",     "",   "",    false, false },
  { u8"Suganga",                                                    "sug",     "",   "",    false, false },
  { u8"Sugut Dusun",                                                "kzs",     "",   "",    false, false },
  { u8"Sui",                                                        "swi",     "",   "",    false, false },
  { u8"Suki",                                                       "sui",     "",   "",    false, false },
  { u8"Suku",                                                       "sub",     "",   "",    false, false },
  { u8"Sukuma",                                                     "suk",     "",   "",    true,  false },
  { u8"Sukur",                                                      "syk",     "",   "",    false, false },
  { u8"Sukurum",                                                    "zsu",     "",   "",    false, false },
  { u8"Sula",                                                       "szn",     "",   "",    false, false },
  { u8"Sulka",                                                      "sua",     "",   "",    false, false },
  { u8"Sulod",                                                      "srg",     "",   "",    false, false },
  { u8"Suma",                                                       "sqm",     "",   "",    false, false },
  { u8"Sumariup",                                                   "siv",     "",   "",    false, false },
  { u8"Sumau",                                                      "six",     "",   "",    false, false },
  { u8"Sumbawa",                                                    "smw",     "",   "",    false, false },
  { u8"Sumbwa",                                                     "suw",     "",   "",    false, false },
  { u8"Sumerian",                                                   "sux",     "",   "",    true,  false },
  { u8"Sumi Naga",                                                  "nsm",     "",   "",    false, false },
  { u8"Sumo-Mayangna",                                              "sum",     "",   "",    false, true  },
  { u8"Sumtu Chin",                                                 "csv",     "",   "",    false, false },
  { u8"Sunam",                                                      "ssk",     "",   "",    false, false },
  { u8"Sundanese",                                                  "sun",     "su", "",    true,  false },
  { u8"Sunwar",                                                     "suz",     "",   "",    false, false },
  { u8"Suoy",                                                       "syo",     "",   "",    false, false },
  { u8"Supyire Senoufo",                                            "spp",     "",   "",    false, false },
  { u8"Sur",                                                        "tdl",     "",   "",    false, false },
  { u8"Surbakhal",                                                  "sbj",     "",   "",    false, false },
  { u8"Surgujia",                                                   "sgj",     "",   "",    false, false },
  { u8"Surigaonon",                                                 "sgd",     "",   "",    false, false },
  { u8"Surigaonon",                                                 "sul",     "",   "",    false, true  },
  { u8"Surjapuri",                                                  "sjp",     "",   "",    false, false },
  { u8"Sursurunga",                                                 "sgz",     "",   "",    false, false },
  { u8"Suruahá",                                                    "swx",     "",   "",    false, false },
  { u8"Surubu",                                                     "sde",     "",   "",    false, false },
  { u8"Suruí Do Pará",                                              "mdz",     "",   "",    false, false },
  { u8"Suruí",                                                      "sru",     "",   "",    false, false },
  { u8"Susquehannock",                                              "sqn",     "",   "",    false, false },
  { u8"Susu",                                                       "sus",     "",   "",    true,  false },
  { u8"Susuami",                                                    "ssu",     "",   "",    false, false },
  { u8"Suundi",                                                     "sdj",     "",   "",    false, false },
  { u8"Suwawa",                                                     "swu",     "",   "",    false, false },
  { u8"Suyá",                                                       "suy",     "",   "",    false, false },
  { u8"Svan",                                                       "sva",     "",   "",    false, false },
  { u8"Swabian",                                                    "swg",     "",   "",    false, false },
  { u8"Swahili (individual language)",                              "swh",     "",   "",    false, false },
  { u8"Swahili (macrolanguage)",                                    "swa",     "sw", "",    true,  false },
  { u8"Swampy Cree",                                                "csw",     "",   "",    false, false },
  { u8"Swati",                                                      "ssw",     "ss", "",    true,  false },
  { u8"Swedish Sign Language",                                      "swl",     "",   "",    false, false },
  { u8"Swedish",                                                    "swe",     "sv", "",    true,  false },
  { u8"Swiss German",                                               "gsw",     "",   "",    true,  false },
  { u8"Swiss-French Sign Language",                                 "ssr",     "",   "",    false, false },
  { u8"Swiss-German Sign Language",                                 "sgg",     "",   "",    false, false },
  { u8"Swiss-Italian Sign Language",                                "slf",     "",   "",    false, false },
  { u8"Swo",                                                        "sox",     "",   "",    false, false },
  { u8"Syenara Senoufo",                                            "shz",     "",   "",    false, false },
  { u8"Sylheti",                                                    "syl",     "",   "",    false, false },
  { u8"Syriac",                                                     "syr",     "",   "",    true,  false },
  { u8"Sáliba",                                                     "slc",     "",   "",    false, false },
  { u8"São Paulo Kaingáng",                                         "zkp",     "",   "",    false, false },
  { u8"Sãotomense",                                                 "cri",     "",   "",    false, false },
  { u8"Sìcìté Sénoufo",                                             "sep",     "",   "",    false, false },
  { u8"Sô",                                                         "sss",     "",   "",    false, false },
  { u8"T'apo",                                                      "lgn",     "",   "",    false, false },
  { u8"T'en",                                                       "tct",     "",   "",    false, false },
  { u8"Ta'izzi-Adeni Arabic",                                       "acq",     "",   "",    false, false },
  { u8"Taabwa",                                                     "tap",     "",   "",    false, false },
  { u8"Tabaa Zapotec",                                              "zat",     "",   "",    false, false },
  { u8"Tabaru",                                                     "tby",     "",   "",    false, false },
  { u8"Tabasco Chontal",                                            "chf",     "",   "",    false, false },
  { u8"Tabasco Nahuatl",                                            "nhc",     "",   "",    false, false },
  { u8"Tabasco Zoque",                                              "zoq",     "",   "",    false, false },
  { u8"Tabassaran",                                                 "tab",     "",   "",    false, false },
  { u8"Tabla",                                                      "tnm",     "",   "",    false, false },
  { u8"Tabo",                                                       "knv",     "",   "",    false, false },
  { u8"Tabriak",                                                    "tzx",     "",   "",    false, false },
  { u8"Tacahua Mixtec",                                             "xtt",     "",   "",    false, false },
  { u8"Tacana",                                                     "tna",     "",   "",    false, false },
  { u8"Tachawit",                                                   "shy",     "",   "",    false, false },
  { u8"Tachelhit",                                                  "shi",     "",   "",    false, false },
  { u8"Tachoni",                                                    "lts",     "",   "",    false, false },
  { u8"Tadaksahak",                                                 "dsq",     "",   "",    false, false },
  { u8"Tado",                                                       "klw",     "",   "",    false, false },
  { u8"Tadyawan",                                                   "tdy",     "",   "",    false, false },
  { u8"Tae'",                                                       "rob",     "",   "",    false, false },
  { u8"Tafi",                                                       "tcd",     "",   "",    false, false },
  { u8"Tagabawa",                                                   "bgs",     "",   "",    false, false },
  { u8"Tagakaulo",                                                  "klg",     "",   "",    false, false },
  { u8"Tagal Murut",                                                "mvv",     "",   "",    false, false },
  { u8"Tagalaka",                                                   "tgz",     "",   "",    false, false },
  { u8"Tagalog",                                                    "tgl",     "tl", "",    true,  false },
  { u8"Tagargrent",                                                 "oua",     "",   "",    false, false },
  { u8"Tagbanwa",                                                   "tbw",     "",   "",    false, false },
  { u8"Tagbu",                                                      "tbm",     "",   "",    false, false },
  { u8"Tagdal",                                                     "tda",     "",   "",    false, false },
  { u8"Tagin",                                                      "tgj",     "",   "",    false, false },
  { u8"Tagish",                                                     "tgx",     "",   "",    false, false },
  { u8"Tagoi",                                                      "tag",     "",   "",    false, false },
  { u8"Tagwana Senoufo",                                            "tgw",     "",   "",    false, false },
  { u8"Tahaggart Tamahaq",                                          "thv",     "",   "",    false, false },
  { u8"Tahitian",                                                   "tah",     "ty", "",    true,  false },
  { u8"Tahltan",                                                    "tht",     "",   "",    false, false },
  { u8"Tai Daeng",                                                  "tyr",     "",   "",    false, false },
  { u8"Tai Dam",                                                    "blt",     "",   "",    false, false },
  { u8"Tai Do",                                                     "tyj",     "",   "",    false, false },
  { u8"Tai Dón",                                                    "twh",     "",   "",    false, false },
  { u8"Tai Hang Tong",                                              "thc",     "",   "",    false, true  },
  { u8"Tai Hongjin",                                                "tiz",     "",   "",    false, false },
  { u8"Tai Laing",                                                  "tjl",     "",   "",    false, false },
  { u8"Tai Loi",                                                    "tlq",     "",   "",    false, false },
  { u8"Tai Long",                                                   "thi",     "",   "",    false, false },
  { u8"Tai Mène",                                                   "tmp",     "",   "",    false, true  },
  { u8"Tai Nüa",                                                    "tdd",     "",   "",    false, false },
  { u8"Tai Pao",                                                    "tpo",     "",   "",    false, false },
  { u8"Tai Thanh",                                                  "tmm",     "",   "",    false, false },
  { u8"Tai Ya",                                                     "cuu",     "",   "",    false, false },
  { u8"Tai languages",                                              "tai",     "",   "",    true,  false },
  { u8"Tai",                                                        "taw",     "",   "",    false, false },
  { u8"Taiap",                                                      "gpn",     "",   "",    false, false },
  { u8"Taikat",                                                     "aos",     "",   "",    false, false },
  { u8"Tainae",                                                     "ago",     "",   "",    false, false },
  { u8"Taino",                                                      "tnq",     "",   "",    false, false },
  { u8"Tairaha",                                                    "bxa",     "",   "",    false, false },
  { u8"Tairuma",                                                    "uar",     "",   "",    false, false },
  { u8"Taita",                                                      "dav",     "",   "",    false, false },
  { u8"Taivoan",                                                    "tvx",     "",   "",    false, false },
  { u8"Taiwan Sign Language",                                       "tss",     "",   "",    false, false },
  { u8"Taje",                                                       "pee",     "",   "",    false, false },
  { u8"Tajik",                                                      "tgk",     "tg", "",    true,  false },
  { u8"Tajiki Arabic",                                              "abh",     "",   "",    false, false },
  { u8"Tajio",                                                      "tdj",     "",   "",    false, false },
  { u8"Tajuasohn",                                                  "tja",     "",   "",    false, false },
  { u8"Takelma",                                                    "tkm",     "",   "",    false, false },
  { u8"Takestani",                                                  "tks",     "",   "",    false, false },
  { u8"Takia",                                                      "tbc",     "",   "",    false, false },
  { u8"Takpa",                                                      "tkk",     "",   "",    false, true  },
  { u8"Takua",                                                      "tkz",     "",   "",    false, false },
  { u8"Takuu",                                                      "nho",     "",   "",    false, false },
  { u8"Takwane",                                                    "tke",     "",   "",    false, false },
  { u8"Tal",                                                        "tal",     "",   "",    false, false },
  { u8"Tala",                                                       "tak",     "",   "",    false, false },
  { u8"Talaud",                                                     "tld",     "",   "",    false, false },
  { u8"Taliabu",                                                    "tlv",     "",   "",    false, false },
  { u8"Talieng",                                                    "tdf",     "",   "",    false, false },
  { u8"Talinga-Bwisi",                                              "tlj",     "",   "",    false, false },
  { u8"Talise",                                                     "tlr",     "",   "",    false, false },
  { u8"Talodi",                                                     "tlo",     "",   "",    false, false },
  { u8"Taloki",                                                     "tlk",     "",   "",    false, false },
  { u8"Talondo'",                                                   "tln",     "",   "",    false, false },
  { u8"Talossan",                                                   "tzl",     "",   "",    false, false },
  { u8"Talu",                                                       "yta",     "",   "",    false, false },
  { u8"Talur",                                                      "ilw",     "",   "",    false, true  },
  { u8"Talysh",                                                     "tly",     "",   "",    false, false },
  { u8"Tama (Chad)",                                                "tma",     "",   "",    false, false },
  { u8"Tama (Colombia)",                                            "ten",     "",   "",    false, false },
  { u8"Tamagario",                                                  "tcg",     "",   "",    false, false },
  { u8"Taman (Indonesia)",                                          "tmn",     "",   "",    false, false },
  { u8"Taman (Myanmar)",                                            "tcl",     "",   "",    false, false },
  { u8"Tamanaku",                                                   "tmz",     "",   "",    false, false },
  { u8"Tamashek",                                                   "tmh",     "",   "",    true,  false },
  { u8"Tamasheq",                                                   "taq",     "",   "",    false, false },
  { u8"Tamazola Mixtec",                                            "vmx",     "",   "",    false, false },
  { u8"Tambas",                                                     "tdk",     "",   "",    false, false },
  { u8"Tambora",                                                    "xxt",     "",   "",    false, false },
  { u8"Tambotalo",                                                  "tls",     "",   "",    false, false },
  { u8"Tambunan Dusun",                                             "kzt",     "",   "",    false, true  },
  { u8"Tami",                                                       "tmy",     "",   "",    false, false },
  { u8"Tamil",                                                      "tam",     "ta", "",    true,  false },
  { u8"Tamki",                                                      "tax",     "",   "",    false, false },
  { u8"Tamnim Citak",                                               "tml",     "",   "",    false, false },
  { u8"Tampias Lobu",                                               "low",     "",   "",    false, false },
  { u8"Tampuan",                                                    "tpu",     "",   "",    false, false },
  { u8"Tampulma",                                                   "tpm",     "",   "",    false, false },
  { u8"Tanacross",                                                  "tcb",     "",   "",    false, false },
  { u8"Tanahmerah",                                                 "tcm",     "",   "",    false, false },
  { u8"Tanaina",                                                    "tfn",     "",   "",    false, false },
  { u8"Tanapag",                                                    "tpv",     "",   "",    false, false },
  { u8"Tandaganon",                                                 "tgn",     "",   "",    false, false },
  { u8"Tandia",                                                     "tni",     "",   "",    false, false },
  { u8"Tandroy-Mahafaly Malagasy",                                  "tdx",     "",   "",    false, false },
  { u8"Tanema",                                                     "tnx",     "",   "",    false, false },
  { u8"Tangale",                                                    "tan",     "",   "",    false, false },
  { u8"Tangchangya",                                                "tnv",     "",   "",    false, false },
  { u8"Tangga",                                                     "tgg",     "",   "",    false, true  },
  { u8"Tanggu",                                                     "tgu",     "",   "",    false, false },
  { u8"Tangkhul Naga (India)",                                      "nmf",     "",   "",    false, false },
  { u8"Tangkhul Naga (Myanmar)",                                    "ntx",     "",   "",    false, false },
  { u8"Tangko",                                                     "tkx",     "",   "",    false, false },
  { u8"Tanglang",                                                   "ytl",     "",   "",    false, false },
  { u8"Tangoa",                                                     "tgp",     "",   "",    false, false },
  { u8"Tangshewi",                                                  "tnf",     "",   "",    false, true  },
  { u8"Tanguat",                                                    "tbs",     "",   "",    false, false },
  { u8"Tangut",                                                     "txg",     "",   "",    false, false },
  { u8"Tanimbili",                                                  "tbe",     "",   "",    false, false },
  { u8"Tanimuca-Retuarã",                                           "tnc",     "",   "",    false, false },
  { u8"Tanjijili",                                                  "uji",     "",   "",    false, false },
  { u8"Tanosy Malagasy",                                            "txy",     "",   "",    false, false },
  { u8"Tanudan Kalinga",                                            "kml",     "",   "",    false, false },
  { u8"Tanzanian Sign Language",                                    "tza",     "",   "",    false, false },
  { u8"Tapeba",                                                     "tbb",     "",   "",    false, true  },
  { u8"Tapei",                                                      "afp",     "",   "",    false, false },
  { u8"Tapieté",                                                    "tpj",     "",   "",    false, false },
  { u8"Tapirapé",                                                   "taf",     "",   "",    false, false },
  { u8"Tarao Naga",                                                 "tro",     "",   "",    false, false },
  { u8"Tareng",                                                     "tgr",     "",   "",    false, false },
  { u8"Tariana",                                                    "tae",     "",   "",    false, false },
  { u8"Tarifit",                                                    "rif",     "",   "",    false, false },
  { u8"Tarjumo",                                                    "txj",     "",   "",    false, false },
  { u8"Tarok",                                                      "yer",     "",   "",    false, false },
  { u8"Tarpia",                                                     "tpf",     "",   "",    false, false },
  { u8"Tartessian",                                                 "txr",     "",   "",    false, false },
  { u8"Taruma",                                                     "tdm",     "",   "",    false, false },
  { u8"Tasawaq",                                                    "twq",     "",   "",    false, false },
  { u8"Tase Naga",                                                  "nst",     "",   "",    false, false },
  { u8"Tasmanian",                                                  "xtz",     "",   "",    false, true  },
  { u8"Tasmate",                                                    "tmt",     "",   "",    false, false },
  { u8"Tataltepec Chatino",                                         "cta",     "",   "",    false, false },
  { u8"Tatana",                                                     "txx",     "",   "",    false, false },
  { u8"Tatar",                                                      "tat",     "tt", "",    true,  false },
  { u8"Tatuyo",                                                     "tav",     "",   "",    false, false },
  { u8"Tauade",                                                     "ttd",     "",   "",    false, false },
  { u8"Taulil",                                                     "tuh",     "",   "",    false, false },
  { u8"Taungyo",                                                    "tco",     "",   "",    false, false },
  { u8"Taupota",                                                    "tpa",     "",   "",    false, false },
  { u8"Tause",                                                      "tad",     "",   "",    false, false },
  { u8"Taushiro",                                                   "trr",     "",   "",    false, false },
  { u8"Tausug",                                                     "tsg",     "",   "",    false, false },
  { u8"Tauya",                                                      "tya",     "",   "",    false, false },
  { u8"Taveta",                                                     "tvs",     "",   "",    false, false },
  { u8"Tavoyan",                                                    "tvn",     "",   "",    false, false },
  { u8"Tavringer Romani",                                           "rmu",     "",   "",    false, false },
  { u8"Tawala",                                                     "tbo",     "",   "",    false, false },
  { u8"Tawallammat Tamajaq",                                        "ttq",     "",   "",    false, false },
  { u8"Tawandê",                                                    "xtw",     "",   "",    false, false },
  { u8"Tawang Monpa",                                               "twm",     "",   "",    false, false },
  { u8"Tawara",                                                     "twl",     "",   "",    false, false },
  { u8"Taworta",                                                    "tbp",     "",   "",    false, false },
  { u8"Tawoyan",                                                    "twy",     "",   "",    false, false },
  { u8"Tawr Chin",                                                  "tcp",     "",   "",    false, false },
  { u8"Tay Boi",                                                    "tas",     "",   "",    false, false },
  { u8"Tay Khang",                                                  "tnu",     "",   "",    false, false },
  { u8"Tayabas Ayta",                                               "ayy",     "",   "",    false, true  },
  { u8"Tayart Tamajeq",                                             "thz",     "",   "",    false, false },
  { u8"Tayo",                                                       "cks",     "",   "",    false, false },
  { u8"Taznatit",                                                   "grr",     "",   "",    false, false },
  { u8"Tboli",                                                      "tbl",     "",   "",    false, false },
  { u8"Tchitchege",                                                 "tck",     "",   "",    false, false },
  { u8"Tchumbuli",                                                  "bqa",     "",   "",    false, false },
  { u8"Te'un",                                                      "tve",     "",   "",    false, false },
  { u8"Teanu",                                                      "tkw",     "",   "",    false, false },
  { u8"Tebul Sign Language",                                        "tsy",     "",   "",    false, false },
  { u8"Tebul Ure Dogon",                                            "dtu",     "",   "",    false, false },
  { u8"Tecpatlán Totonac",                                          "tcw",     "",   "",    false, false },
  { u8"Tedaga",                                                     "tuq",     "",   "",    false, false },
  { u8"Tedim Chin",                                                 "ctd",     "",   "",    false, false },
  { u8"Tee",                                                        "tkq",     "",   "",    false, false },
  { u8"Tefaro",                                                     "tfo",     "",   "",    false, false },
  { u8"Tegali",                                                     "ras",     "",   "",    false, false },
  { u8"Tehit",                                                      "kps",     "",   "",    false, false },
  { u8"Tehuelche",                                                  "teh",     "",   "",    false, false },
  { u8"Tejalapan Zapotec",                                          "ztt",     "",   "",    false, false },
  { u8"Teke-Ebo",                                                   "ebo",     "",   "",    false, false },
  { u8"Teke-Fuumu",                                                 "ifm",     "",   "",    false, false },
  { u8"Teke-Kukuya",                                                "kkw",     "",   "",    false, false },
  { u8"Teke-Laali",                                                 "lli",     "",   "",    false, false },
  { u8"Teke-Nzikou",                                                "nzu",     "",   "",    false, false },
  { u8"Teke-Tege",                                                  "teg",     "",   "",    false, false },
  { u8"Teke-Tsaayi",                                                "tyi",     "",   "",    false, false },
  { u8"Teke-Tyee",                                                  "tyx",     "",   "",    false, false },
  { u8"Tektiteko",                                                  "ttc",     "",   "",    false, false },
  { u8"Tela-Masbuar",                                               "tvm",     "",   "",    false, false },
  { u8"Telefol",                                                    "tlf",     "",   "",    false, false },
  { u8"Telugu",                                                     "tel",     "te", "",    true,  false },
  { u8"Tem",                                                        "kdh",     "",   "",    false, false },
  { u8"Temacine Tamazight",                                         "tjo",     "",   "",    false, false },
  { u8"Temascaltepec Nahuatl",                                      "nhv",     "",   "",    false, false },
  { u8"Tembo (Kitembo)",                                            "tbt",     "",   "",    false, false },
  { u8"Tembo (Motembo)",                                            "tmv",     "",   "",    false, false },
  { u8"Tembé",                                                      "tqb",     "",   "",    false, false },
  { u8"Teme",                                                       "tdo",     "",   "",    false, false },
  { u8"Temein",                                                     "teq",     "",   "",    false, false },
  { u8"Temi",                                                       "soz",     "",   "",    false, false },
  { u8"Temiar",                                                     "tea",     "",   "",    false, false },
  { u8"Temoaya Otomi",                                              "ott",     "",   "",    false, false },
  { u8"Temoq",                                                      "tmo",     "",   "",    false, false },
  { u8"Tempasuk Dusun",                                             "tdu",     "",   "",    false, true  },
  { u8"Temuan",                                                     "tmw",     "",   "",    false, false },
  { u8"Ten'edn",                                                    "tnz",     "",   "",    false, false },
  { u8"Tena Lowland Quichua",                                       "quw",     "",   "",    false, false },
  { u8"Tenango Otomi",                                              "otn",     "",   "",    false, false },
  { u8"Tene Kan Dogon",                                             "dtk",     "",   "",    false, false },
  { u8"Tenggarong Kutai Malay",                                     "vkt",     "",   "",    false, false },
  { u8"Tengger",                                                    "tes",     "",   "",    false, false },
  { u8"Tenharim",                                                   "pah",     "",   "",    false, false },
  { u8"Tenino",                                                     "tqn",     "",   "",    false, false },
  { u8"Tenis",                                                      "tns",     "",   "",    false, false },
  { u8"Tennet",                                                     "tex",     "",   "",    false, false },
  { u8"Teop",                                                       "tio",     "",   "",    false, false },
  { u8"Teor",                                                       "tev",     "",   "",    false, false },
  { u8"Tepecano",                                                   "tep",     "",   "",    false, false },
  { u8"Tepetotutla Chinantec",                                      "cnt",     "",   "",    false, false },
  { u8"Tepeuxila Cuicatec",                                         "cux",     "",   "",    false, false },
  { u8"Tepinapa Chinantec",                                         "cte",     "",   "",    false, false },
  { u8"Tepo Krumen",                                                "ted",     "",   "",    false, false },
  { u8"Ter Sami",                                                   "sjt",     "",   "",    false, false },
  { u8"Tera",                                                       "ttr",     "",   "",    false, false },
  { u8"Terebu",                                                     "trb",     "",   "",    false, false },
  { u8"Terei",                                                      "buo",     "",   "",    false, false },
  { u8"Tereno",                                                     "ter",     "",   "",    true,  false },
  { u8"Teressa",                                                    "tef",     "",   "",    false, false },
  { u8"Tereweng",                                                   "twg",     "",   "",    false, false },
  { u8"Teribe",                                                     "tfr",     "",   "",    false, false },
  { u8"Terik",                                                      "tec",     "",   "",    false, false },
  { u8"Termanu",                                                    "twu",     "",   "",    false, false },
  { u8"Ternate",                                                    "tft",     "",   "",    false, false },
  { u8"Ternateño",                                                  "tmg",     "",   "",    false, false },
  { u8"Tesaka Malagasy",                                            "tkg",     "",   "",    false, false },
  { u8"Tese",                                                       "keg",     "",   "",    false, false },
  { u8"Teshenawa",                                                  "twc",     "",   "",    false, false },
  { u8"Teso",                                                       "teo",     "",   "",    false, false },
  { u8"Tetela",                                                     "tll",     "",   "",    false, false },
  { u8"Tetelcingo Nahuatl",                                         "nhg",     "",   "",    false, false },
  { u8"Tetete",                                                     "teb",     "",   "",    false, false },
  { u8"Tetserret",                                                  "tez",     "",   "",    false, false },
  { u8"Tetum",                                                      "tet",     "",   "",    true,  false },
  { u8"Tetun Dili",                                                 "tdt",     "",   "",    false, false },
  { u8"Teutila Cuicatec",                                           "cut",     "",   "",    false, false },
  { u8"Tewa (Indonesia)",                                           "twe",     "",   "",    false, false },
  { u8"Tewa (USA)",                                                 "tew",     "",   "",    false, false },
  { u8"Tewe",                                                       "twx",     "",   "",    false, false },
  { u8"Texcatepec Otomi",                                           "otx",     "",   "",    false, false },
  { u8"Texistepec Popoluca",                                        "poq",     "",   "",    false, false },
  { u8"Texmelucan Zapotec",                                         "zpz",     "",   "",    false, false },
  { u8"Tezoatlán Mixtec",                                           "mxb",     "",   "",    false, false },
  { u8"Tha",                                                        "thy",     "",   "",    false, false },
  { u8"Thachanadan",                                                "thn",     "",   "",    false, false },
  { u8"Thado Chin",                                                 "tcz",     "",   "",    false, false },
  { u8"Thai Sign Language",                                         "tsq",     "",   "",    false, false },
  { u8"Thai Song",                                                  "soa",     "",   "",    false, false },
  { u8"Thai",                                                       "tha",     "th", "",    true,  false },
  { u8"Thaiphum Chin",                                              "cth",     "",   "",    false, false },
  { u8"Thakali",                                                    "ths",     "",   "",    false, false },
  { u8"Thangal Naga",                                               "nki",     "",   "",    false, false },
  { u8"Thangmi",                                                    "thf",     "",   "",    false, false },
  { u8"Thao",                                                       "ssf",     "",   "",    false, false },
  { u8"Tharaka",                                                    "thk",     "",   "",    false, false },
  { u8"Thawa",                                                      "xtv",     "",   "",    false, false },
  { u8"Thaypan",                                                    "typ",     "",   "",    false, false },
  { u8"The",                                                        "thx",     "",   "",    false, true  },
  { u8"Thiin",                                                      "iin",     "",   "",    false, false },
  { u8"Tho",                                                        "tou",     "",   "",    false, false },
  { u8"Thompson",                                                   "thp",     "",   "",    false, false },
  { u8"Thopho",                                                     "ytp",     "",   "",    false, false },
  { u8"Thracian",                                                   "txh",     "",   "",    false, false },
  { u8"Thu Lao",                                                    "tyl",     "",   "",    false, false },
  { u8"Thudam",                                                     "thw",     "",   "",    false, true  },
  { u8"Thulung",                                                    "tdh",     "",   "",    false, false },
  { u8"Thur",                                                       "lth",     "",   "",    false, false },
  { u8"Thuri",                                                      "thu",     "",   "",    false, false },
  { u8"Tiagbamrin Aizi",                                            "ahi",     "",   "",    false, false },
  { u8"Tiale",                                                      "mnl",     "",   "",    false, false },
  { u8"Tiang",                                                      "tbj",     "",   "",    false, false },
  { u8"Tibea",                                                      "ngy",     "",   "",    false, false },
  { u8"Tibetan Sign Language",                                      "lsn",     "",   "",    false, false },
  { u8"Tibetan",                                                    "tib",     "bo", "bod", true,  false },
  { u8"Tibeto-Burman languages",                                    "tbq",     "",   "",    false, false },
  { u8"Tichurong",                                                  "tcn",     "",   "",    false, false },
  { u8"Ticuna",                                                     "tca",     "",   "",    false, false },
  { u8"Tidaá Mixtec",                                               "mtx",     "",   "",    false, false },
  { u8"Tidikelt Tamazight",                                         "tia",     "",   "",    false, false },
  { u8"Tidong",                                                     "tid",     "",   "",    false, true  },
  { u8"Tidore",                                                     "tvo",     "",   "",    false, false },
  { u8"Tiemacèwè Bozo",                                             "boo",     "",   "",    false, false },
  { u8"Tiene",                                                      "tii",     "",   "",    false, false },
  { u8"Tifal",                                                      "tif",     "",   "",    false, false },
  { u8"Tigak",                                                      "tgc",     "",   "",    false, false },
  { u8"Tigon Mbembe",                                               "nza",     "",   "",    false, false },
  { u8"Tigre",                                                      "tig",     "",   "",    true,  false },
  { u8"Tigrinya",                                                   "tir",     "ti", "",    true,  false },
  { u8"Tii",                                                        "txq",     "",   "",    false, false },
  { u8"Tijaltepec Mixtec",                                          "xtl",     "",   "",    false, false },
  { u8"Tikar",                                                      "tik",     "",   "",    false, false },
  { u8"Tikopia",                                                    "tkp",     "",   "",    false, false },
  { u8"Tilapa Otomi",                                               "otl",     "",   "",    false, false },
  { u8"Tillamook",                                                  "til",     "",   "",    false, false },
  { u8"Tilquiapan Zapotec",                                         "zts",     "",   "",    false, false },
  { u8"Tilung",                                                     "tij",     "",   "",    false, false },
  { u8"Tima",                                                       "tms",     "",   "",    false, false },
  { u8"Timbe",                                                      "tim",     "",   "",    false, false },
  { u8"Timne",                                                      "tem",     "",   "",    true,  false },
  { u8"Timor Pidgin",                                               "tvy",     "",   "",    false, false },
  { u8"Timucua",                                                    "tjm",     "",   "",    false, false },
  { u8"Timugon Murut",                                              "tih",     "",   "",    false, false },
  { u8"Tinani",                                                     "lbf",     "",   "",    false, false },
  { u8"Tindi",                                                      "tin",     "",   "",    false, false },
  { u8"Tingal",                                                     "tie",     "",   "",    false, true  },
  { u8"Tingui-Boto",                                                "tgv",     "",   "",    false, false },
  { u8"Tinigua",                                                    "tit",     "",   "",    false, false },
  { u8"Tinoc Kallahan",                                             "tne",     "",   "",    false, true  },
  { u8"Tinputz",                                                    "tpz",     "",   "",    false, false },
  { u8"Tippera",                                                    "tpe",     "",   "",    false, false },
  { u8"Tira",                                                       "tic",     "",   "",    false, false },
  { u8"Tirahi",                                                     "tra",     "",   "",    false, false },
  { u8"Tiranige Diga Dogon",                                        "tde",     "",   "",    false, false },
  { u8"Tiri",                                                       "cir",     "",   "",    false, false },
  { u8"Tirmaga-Chai Suri",                                          "suq",     "",   "",    false, false },
  { u8"Tiruray",                                                    "tiy",     "",   "",    false, false },
  { u8"Tita",                                                       "tdq",     "",   "",    false, false },
  { u8"Titan",                                                      "ttv",     "",   "",    false, false },
  { u8"Tiv",                                                        "tiv",     "",   "",    true,  false },
  { u8"Tiwa",                                                       "lax",     "",   "",    false, false },
  { u8"Tiwi",                                                       "tiw",     "",   "",    false, false },
  { u8"Tiyaa",                                                      "tyy",     "",   "",    false, false },
  { u8"Tiéfo",                                                      "tiq",     "",   "",    false, false },
  { u8"Tiéyaxo Bozo",                                               "boz",     "",   "",    false, false },
  { u8"Tjungundji",                                                 "tjj",     "",   "",    false, false },
  { u8"Tjupany",                                                    "tjp",     "",   "",    false, false },
  { u8"Tjurruru",                                                   "tju",     "",   "",    false, false },
  { u8"Tlachichilco Tepehua",                                       "tpt",     "",   "",    false, false },
  { u8"Tlacoapa Me'phaa",                                           "tpl",     "",   "",    false, false },
  { u8"Tlacoatzintepec Chinantec",                                  "ctl",     "",   "",    false, false },
  { u8"Tlacolulita Zapotec",                                        "zpk",     "",   "",    false, false },
  { u8"Tlahuitoltepec Mixe",                                        "mxp",     "",   "",    false, false },
  { u8"Tlamacazapa Nahuatl",                                        "nuz",     "",   "",    false, false },
  { u8"Tlazoyaltepec Mixtec",                                       "mqh",     "",   "",    false, false },
  { u8"Tlingit",                                                    "tli",     "",   "",    true,  false },
  { u8"To",                                                         "toz",     "",   "",    false, false },
  { u8"To'abaita",                                                  "mlu",     "",   "",    false, false },
  { u8"Toaripi",                                                    "tqo",     "",   "",    false, false },
  { u8"Toba",                                                       "tob",     "",   "",    false, false },
  { u8"Toba-Maskoy",                                                "tmf",     "",   "",    false, false },
  { u8"Tobagonian Creole English",                                  "tgh",     "",   "",    false, false },
  { u8"Tobanga",                                                    "tng",     "",   "",    false, false },
  { u8"Tobati",                                                     "tti",     "",   "",    false, false },
  { u8"Tobelo",                                                     "tlb",     "",   "",    false, false },
  { u8"Tobian",                                                     "tox",     "",   "",    false, false },
  { u8"Tobilung",                                                   "tgb",     "",   "",    false, false },
  { u8"Tobo",                                                       "tbv",     "",   "",    false, false },
  { u8"Tocantins Asurini",                                          "asu",     "",   "",    false, false },
  { u8"Tocho",                                                      "taz",     "",   "",    false, false },
  { u8"Toda",                                                       "tcx",     "",   "",    false, false },
  { u8"Todrah",                                                     "tdr",     "",   "",    false, false },
  { u8"Tofanma",                                                    "tlg",     "",   "",    false, false },
  { u8"Tofin Gbe",                                                  "tfi",     "",   "",    false, false },
  { u8"Togbo-Vara Banda",                                           "tor",     "",   "",    false, false },
  { u8"Togoyo",                                                     "tgy",     "",   "",    false, false },
  { u8"Tohono O'odham",                                             "ood",     "",   "",    false, false },
  { u8"Tojolabal",                                                  "toj",     "",   "",    false, false },
  { u8"Tok Pisin",                                                  "tpi",     "",   "",    true,  false },
  { u8"Tokano",                                                     "zuh",     "",   "",    false, false },
  { u8"Tokelau",                                                    "tkl",     "",   "",    true,  false },
  { u8"Tokharian A",                                                "xto",     "",   "",    false, false },
  { u8"Tokharian B",                                                "txb",     "",   "",    false, false },
  { u8"Toki Pona",                                                  "tok",     "",   "",    false, false },
  { u8"Toku-No-Shima",                                              "tkn",     "",   "",    false, false },
  { u8"Tol",                                                        "jic",     "",   "",    false, false },
  { u8"Tolaki",                                                     "lbw",     "",   "",    false, false },
  { u8"Tolomako",                                                   "tlm",     "",   "",    false, false },
  { u8"Tolowa",                                                     "tol",     "",   "",    false, false },
  { u8"Toma",                                                       "tod",     "",   "",    false, false },
  { u8"Tomadino",                                                   "tdi",     "",   "",    false, false },
  { u8"Tombelala",                                                  "ttp",     "",   "",    false, false },
  { u8"Tombonuo",                                                   "txa",     "",   "",    false, false },
  { u8"Tombulu",                                                    "tom",     "",   "",    false, false },
  { u8"Tomedes",                                                    "toe",     "",   "",    false, true  },
  { u8"Tomini",                                                     "txm",     "",   "",    false, false },
  { u8"Tommo So Dogon",                                             "dto",     "",   "",    false, false },
  { u8"Tomo Kan Dogon",                                             "dtm",     "",   "",    false, false },
  { u8"Tomoip",                                                     "tqp",     "",   "",    false, false },
  { u8"Tondano",                                                    "tdn",     "",   "",    false, false },
  { u8"Tondi Songway Kiini",                                        "tst",     "",   "",    false, false },
  { u8"Tonga (Nyasa)",                                              "tog",     "",   "",    true,  false },
  { u8"Tonga (Tonga Islands)",                                      "ton",     "to", "",    true,  false },
  { u8"Tonga (Zambia)",                                             "toi",     "",   "",    false, false },
  { u8"Tongwe",                                                     "tny",     "",   "",    false, false },
  { u8"Tonjon",                                                     "tjn",     "",   "",    false, false },
  { u8"Tonkawa",                                                    "tqw",     "",   "",    false, false },
  { u8"Tonsawang",                                                  "tnw",     "",   "",    false, false },
  { u8"Tonsea",                                                     "txs",     "",   "",    false, false },
  { u8"Tontemboan",                                                 "tnt",     "",   "",    false, false },
  { u8"Tooro",                                                      "ttj",     "",   "",    false, false },
  { u8"Topoiyo",                                                    "toy",     "",   "",    false, false },
  { u8"Toposa",                                                     "toq",     "",   "",    false, false },
  { u8"Toraja-Sa'dan",                                              "sda",     "",   "",    false, false },
  { u8"Toram",                                                      "trj",     "",   "",    false, false },
  { u8"Torau",                                                      "ttu",     "",   "",    false, false },
  { u8"Tornedalen Finnish",                                         "fit",     "",   "",    false, false },
  { u8"Toro So Dogon",                                              "dts",     "",   "",    false, false },
  { u8"Toro Tegu Dogon",                                            "dtt",     "",   "",    false, false },
  { u8"Toro",                                                       "tdv",     "",   "",    false, false },
  { u8"Toromono",                                                   "tno",     "",   "",    false, false },
  { u8"Torona",                                                     "tqr",     "",   "",    false, false },
  { u8"Torres Strait Creole",                                       "tcs",     "",   "",    false, false },
  { u8"Torricelli",                                                 "tei",     "",   "",    false, false },
  { u8"Torwali",                                                    "trw",     "",   "",    false, false },
  { u8"Torá",                                                       "trz",     "",   "",    false, false },
  { u8"Tosk Albanian",                                              "als",     "",   "",    false, false },
  { u8"Totela",                                                     "ttl",     "",   "",    false, false },
  { u8"Toto",                                                       "txo",     "",   "",    false, false },
  { u8"Totoli",                                                     "txe",     "",   "",    false, false },
  { u8"Totomachapan Zapotec",                                       "zph",     "",   "",    false, false },
  { u8"Totontepec Mixe",                                            "mto",     "",   "",    false, false },
  { u8"Totoro",                                                     "ttk",     "",   "",    false, false },
  { u8"Touo",                                                       "tqu",     "",   "",    false, false },
  { u8"Toura (Côte d'Ivoire)",                                      "neb",     "",   "",    false, false },
  { u8"Toura (Papua New Guinea)",                                   "don",     "",   "",    false, false },
  { u8"Towei",                                                      "ttn",     "",   "",    false, false },
  { u8"Trans-New Guinea languages",                                 "ngf",     "",   "",    false, false },
  { u8"Transalpine Gaulish",                                        "xtg",     "",   "",    false, false },
  { u8"Traveller Danish",                                           "rmd",     "",   "",    false, false },
  { u8"Traveller Norwegian",                                        "rmg",     "",   "",    false, false },
  { u8"Traveller Scottish",                                         "trl",     "",   "",    false, false },
  { u8"Tregami",                                                    "trm",     "",   "",    false, false },
  { u8"Tremembé",                                                   "tme",     "",   "",    false, false },
  { u8"Trieng",                                                     "stg",     "",   "",    false, false },
  { u8"Trimuris",                                                   "tip",     "",   "",    false, false },
  { u8"Tring",                                                      "tgq",     "",   "",    false, false },
  { u8"Tringgus-Sembaan Bidayuh",                                   "trx",     "",   "",    false, false },
  { u8"Trinidad and Tobago Sign Language",                          "lst",     "",   "",    false, false },
  { u8"Trinidadian Creole English",                                 "trf",     "",   "",    false, false },
  { u8"Trinitario",                                                 "trn",     "",   "",    false, false },
  { u8"Trió",                                                       "tri",     "",   "",    false, false },
  { u8"Truká",                                                      "tka",     "",   "",    false, false },
  { u8"Trumai",                                                     "tpy",     "",   "",    false, false },
  { u8"Ts'ün-Lao",                                                  "tsl",     "",   "",    false, false },
  { u8"Tsaangi",                                                    "tsa",     "",   "",    false, false },
  { u8"Tsakhur",                                                    "tkr",     "",   "",    false, false },
  { u8"Tsakonian",                                                  "tsd",     "",   "",    false, false },
  { u8"Tsakwambo",                                                  "kvz",     "",   "",    false, false },
  { u8"Tsamai",                                                     "tsb",     "",   "",    false, false },
  { u8"Tsat",                                                       "huq",     "",   "",    false, false },
  { u8"Tseku",                                                      "tsk",     "",   "",    false, false },
  { u8"Tsetsaut",                                                   "txc",     "",   "",    false, false },
  { u8"Tshangla",                                                   "tsj",     "",   "",    false, false },
  { u8"Tsikimba",                                                   "kdl",     "",   "",    false, false },
  { u8"Tsimané",                                                    "cas",     "",   "",    false, false },
  { u8"Tsimihety Malagasy",                                         "xmw",     "",   "",    false, false },
  { u8"Tsimshian",                                                  "tsi",     "",   "",    true,  false },
  { u8"Tsishingini",                                                "tsw",     "",   "",    false, false },
  { u8"Tso",                                                        "ldp",     "",   "",    false, false },
  { u8"Tsoa",                                                       "hio",     "",   "",    false, false },
  { u8"Tsogo",                                                      "tsv",     "",   "",    false, false },
  { u8"Tsonga",                                                     "tso",     "ts", "",    true,  false },
  { u8"Tsotso",                                                     "lto",     "",   "",    false, false },
  { u8"Tsou",                                                       "tsu",     "",   "",    false, false },
  { u8"Tsucuba",                                                    "cbq",     "",   "",    false, false },
  { u8"Tsum",                                                       "ttz",     "",   "",    false, false },
  { u8"Tsuvadi",                                                    "tvd",     "",   "",    false, false },
  { u8"Tsuvan",                                                     "tsh",     "",   "",    false, false },
  { u8"Tswa",                                                       "tsc",     "",   "",    false, false },
  { u8"Tswana",                                                     "tsn",     "tn", "",    true,  false },
  { u8"Tswapong",                                                   "two",     "",   "",    false, false },
  { u8"Tu",                                                         "mjg",     "",   "",    false, false },
  { u8"Tuamotuan",                                                  "pmt",     "",   "",    false, false },
  { u8"Tubar",                                                      "tbu",     "",   "",    false, false },
  { u8"Tucano",                                                     "tuo",     "",   "",    false, false },
  { u8"Tugen",                                                      "tuy",     "",   "",    false, false },
  { u8"Tugun",                                                      "tzn",     "",   "",    false, false },
  { u8"Tugutil",                                                    "tuj",     "",   "",    false, false },
  { u8"Tukang Besi North",                                          "khc",     "",   "",    false, false },
  { u8"Tukang Besi South",                                          "bhq",     "",   "",    false, false },
  { u8"Tuki",                                                       "bag",     "",   "",    false, false },
  { u8"Tukpa",                                                      "tpq",     "",   "",    false, false },
  { u8"Tukudede",                                                   "tkd",     "",   "",    false, false },
  { u8"Tukumanféd",                                                 "tkf",     "",   "",    false, false },
  { u8"Tula",                                                       "tul",     "",   "",    false, false },
  { u8"Tulehu",                                                     "tlu",     "",   "",    false, false },
  { u8"Tulishi",                                                    "tey",     "",   "",    false, false },
  { u8"Tulu",                                                       "tcy",     "",   "",    false, false },
  { u8"Tulu-Bohuai",                                                "rak",     "",   "",    false, false },
  { u8"Tuma-Irumu",                                                 "iou",     "",   "",    false, false },
  { u8"Tumak",                                                      "tmc",     "",   "",    false, false },
  { u8"Tumari Kanuri",                                              "krt",     "",   "",    false, false },
  { u8"Tumbuka",                                                    "tum",     "",   "",    true,  false },
  { u8"Tumi",                                                       "kku",     "",   "",    false, false },
  { u8"Tumleo",                                                     "tmq",     "",   "",    false, false },
  { u8"Tumshuqese",                                                 "xtq",     "",   "",    false, false },
  { u8"Tumtum",                                                     "tbr",     "",   "",    false, false },
  { u8"Tumulung Sisaala",                                           "sil",     "",   "",    false, false },
  { u8"Tumzabt",                                                    "mzb",     "",   "",    false, false },
  { u8"Tundra Enets",                                               "enh",     "",   "",    false, false },
  { u8"Tunen",                                                      "baz",     "",   "",    false, true  },
  { u8"Tunen",                                                      "tvu",     "",   "",    false, false },
  { u8"Tungag",                                                     "lcm",     "",   "",    false, false },
  { u8"Tunggare",                                                   "trt",     "",   "",    false, false },
  { u8"Tungus languages",                                           "tuw",     "",   "",    false, false },
  { u8"Tunia",                                                      "tug",     "",   "",    false, false },
  { u8"Tunica",                                                     "tun",     "",   "",    false, false },
  { u8"Tunisian Arabic",                                            "aeb",     "",   "",    false, false },
  { u8"Tunisian Sign Language",                                     "tse",     "",   "",    false, false },
  { u8"Tunjung",                                                    "tjg",     "",   "",    false, false },
  { u8"Tunni",                                                      "tqq",     "",   "",    false, false },
  { u8"Tunzu",                                                      "dza",     "",   "",    false, false },
  { u8"Tuotomb",                                                    "ttf",     "",   "",    false, false },
  { u8"Tuparí",                                                     "tpr",     "",   "",    false, false },
  { u8"Tupi languages",                                             "tup",     "",   "",    true,  false },
  { u8"Tupinambá",                                                  "tpn",     "",   "",    false, false },
  { u8"Tupinikin",                                                  "tpk",     "",   "",    false, false },
  { u8"Tupuri",                                                     "tui",     "",   "",    false, false },
  { u8"Tupí",                                                       "tpw",     "",   "",    false, false },
  { u8"Turaka",                                                     "trh",     "",   "",    false, false },
  { u8"Turi",                                                       "trd",     "",   "",    false, false },
  { u8"Turiwára",                                                   "twt",     "",   "",    false, false },
  { u8"Turka",                                                      "tuz",     "",   "",    false, false },
  { u8"Turkana",                                                    "tuv",     "",   "",    false, false },
  { u8"Turkic languages",                                           "trk",     "",   "",    false, false },
  { u8"Turkish Sign Language",                                      "tsm",     "",   "",    false, false },
  { u8"Turkish",                                                    "tur",     "tr", "",    true,  false },
  { u8"Turkmen",                                                    "tuk",     "tk", "",    true,  false },
  { u8"Turks And Caicos Creole English",                            "tch",     "",   "",    false, false },
  { u8"Turoyo",                                                     "tru",     "",   "",    false, false },
  { u8"Turumsa",                                                    "tqm",     "",   "",    false, false },
  { u8"Turung",                                                     "try",     "",   "",    false, false },
  { u8"Tuscarora",                                                  "tus",     "",   "",    false, false },
  { u8"Tutelo",                                                     "tta",     "",   "",    false, false },
  { u8"Tutong",                                                     "ttg",     "",   "",    false, false },
  { u8"Tutsa Naga",                                                 "tvt",     "",   "",    false, false },
  { u8"Tutuba",                                                     "tmi",     "",   "",    false, false },
  { u8"Tututepec Mixtec",                                           "mtu",     "",   "",    false, false },
  { u8"Tututni",                                                    "tuu",     "",   "",    false, false },
  { u8"Tuvalu",                                                     "tvl",     "",   "",    true,  false },
  { u8"Tuvinian",                                                   "tyv",     "",   "",    true,  false },
  { u8"Tuwali Ifugao",                                              "ifk",     "",   "",    false, false },
  { u8"Tuwari",                                                     "tww",     "",   "",    false, false },
  { u8"Tuwuli",                                                     "bov",     "",   "",    false, false },
  { u8"Tuxináwa",                                                   "tux",     "",   "",    false, false },
  { u8"Tuxá",                                                       "tud",     "",   "",    false, false },
  { u8"Tuyuca",                                                     "tue",     "",   "",    false, false },
  { u8"Twana",                                                      "twa",     "",   "",    false, false },
  { u8"Twendi",                                                     "twn",     "",   "",    false, false },
  { u8"Twents",                                                     "twd",     "",   "",    false, false },
  { u8"Twi",                                                        "twi",     "tw", "",    true,  false },
  { u8"Tyap",                                                       "kcg",     "",   "",    false, false },
  { u8"Tz'utujil",                                                  "tzj",     "",   "",    false, false },
  { u8"Tzeltal",                                                    "tzh",     "",   "",    false, false },
  { u8"Tzotzil",                                                    "tzo",     "",   "",    false, false },
  { u8"Tày Sa Pa",                                                  "tys",     "",   "",    false, false },
  { u8"Tày Tac",                                                    "tyt",     "",   "",    false, false },
  { u8"Tày",                                                        "tyz",     "",   "",    false, false },
  { u8"Téén",                                                       "lor",     "",   "",    false, false },
  { u8"Tübatulabal",                                                "tub",     "",   "",    false, false },
  { u8"U",                                                          "uuu",     "",   "",    false, false },
  { u8"Uab Meto",                                                   "aoz",     "",   "",    false, false },
  { u8"Uamué",                                                      "uam",     "",   "",    false, false },
  { u8"Uare",                                                       "ksj",     "",   "",    false, false },
  { u8"Ubaghara",                                                   "byc",     "",   "",    false, false },
  { u8"Ubang",                                                      "uba",     "",   "",    false, false },
  { u8"Ubi",                                                        "ubi",     "",   "",    false, false },
  { u8"Ubir",                                                       "ubr",     "",   "",    false, false },
  { u8"Ubykh",                                                      "uby",     "",   "",    false, false },
  { u8"Ucayali-Yurúa Ashéninka",                                    "cpb",     "",   "",    false, false },
  { u8"Uda",                                                        "uda",     "",   "",    false, false },
  { u8"Udi",                                                        "udi",     "",   "",    false, false },
  { u8"Udihe",                                                      "ude",     "",   "",    false, false },
  { u8"Udmurt",                                                     "udm",     "",   "",    true,  false },
  { u8"Uduk",                                                       "udu",     "",   "",    false, false },
  { u8"Ufim",                                                       "ufi",     "",   "",    false, false },
  { u8"Ugandan Sign Language",                                      "ugn",     "",   "",    false, false },
  { u8"Ugaritic",                                                   "uga",     "",   "",    true,  false },
  { u8"Ughele",                                                     "uge",     "",   "",    false, false },
  { u8"Ugong",                                                      "ugo",     "",   "",    false, false },
  { u8"Uhami",                                                      "uha",     "",   "",    false, false },
  { u8"Uighur",                                                     "uig",     "ug", "",    true,  false },
  { u8"Uisai",                                                      "uis",     "",   "",    false, false },
  { u8"Ujir",                                                       "udj",     "",   "",    false, false },
  { u8"Ukaan",                                                      "kcf",     "",   "",    false, false },
  { u8"Ukhwejo",                                                    "ukh",     "",   "",    false, false },
  { u8"Ukit",                                                       "umi",     "",   "",    false, false },
  { u8"Ukpe-Bayobiri",                                              "ukp",     "",   "",    false, false },
  { u8"Ukpet-Ehom",                                                 "akd",     "",   "",    false, false },
  { u8"Ukrainian Sign Language",                                    "ukl",     "",   "",    false, false },
  { u8"Ukrainian",                                                  "ukr",     "uk", "",    true,  false },
  { u8"Ukue",                                                       "uku",     "",   "",    false, false },
  { u8"Ukuriguma",                                                  "ukg",     "",   "",    false, false },
  { u8"Ukwa",                                                       "ukq",     "",   "",    false, false },
  { u8"Ukwuani-Aboh-Ndoni",                                         "ukw",     "",   "",    false, false },
  { u8"Ulau-Suain",                                                 "svb",     "",   "",    false, false },
  { u8"Ulch",                                                       "ulc",     "",   "",    false, false },
  { u8"Ulithian",                                                   "uli",     "",   "",    false, false },
  { u8"Ullatan",                                                    "ull",     "",   "",    false, false },
  { u8"Ulukwumi",                                                   "ulb",     "",   "",    false, false },
  { u8"Ulumanda'",                                                  "ulm",     "",   "",    false, false },
  { u8"Ulwa",                                                       "ulw",     "",   "",    false, false },
  { u8"Uma",                                                        "ppk",     "",   "",    false, false },
  { u8"Uma' Lasan",                                                 "xky",     "",   "",    false, false },
  { u8"Uma' Lung",                                                  "ulu",     "",   "",    false, false },
  { u8"Umanakaina",                                                 "gdn",     "",   "",    false, false },
  { u8"Umatilla",                                                   "uma",     "",   "",    false, false },
  { u8"Umbindhamu",                                                 "umd",     "",   "",    false, false },
  { u8"Umbrian",                                                    "xum",     "",   "",    false, false },
  { u8"Umbu-Ungu",                                                  "ubu",     "",   "",    false, false },
  { u8"Umbugarla",                                                  "umr",     "",   "",    false, false },
  { u8"Umbundu",                                                    "umb",     "",   "",    true,  false },
  { u8"Ume Sami",                                                   "sju",     "",   "",    false, false },
  { u8"Umeda",                                                      "upi",     "",   "",    false, false },
  { u8"Umiida",                                                     "xud",     "",   "",    false, false },
  { u8"Umiray Dumaget Agta",                                        "due",     "",   "",    false, false },
  { u8"Umon",                                                       "umm",     "",   "",    false, false },
  { u8"Umotína",                                                    "umo",     "",   "",    false, false },
  { u8"Umpila",                                                     "ump",     "",   "",    false, false },
  { u8"Una",                                                        "mtg",     "",   "",    false, false },
  { u8"Unami",                                                      "unm",     "",   "",    false, false },
  { u8"Uncoded languages",                                          "mis",     "",   "",    true,  false },
  { u8"Unde Kaili",                                                 "unz",     "",   "",    false, false },
  { u8"Undetermined",                                               "und",     "",   "",    true,  false },
  { u8"Uneapa",                                                     "bbn",     "",   "",    false, false },
  { u8"Uneme",                                                      "une",     "",   "",    false, false },
  { u8"Unggaranggu",                                                "xun",     "",   "",    false, false },
  { u8"Unggumi",                                                    "xgu",     "",   "",    false, false },
  { u8"Uni",                                                        "uni",     "",   "",    false, false },
  { u8"Unserdeutsch",                                               "uln",     "",   "",    false, false },
  { u8"Unua",                                                       "onu",     "",   "",    false, false },
  { u8"Unubahe",                                                    "unu",     "",   "",    false, false },
  { u8"Uokha",                                                      "uok",     "",   "",    false, true  },
  { u8"Upper Chehalis",                                             "cjh",     "",   "",    false, false },
  { u8"Upper Grand Valley Dani",                                    "dna",     "",   "",    false, false },
  { u8"Upper Guinea Crioulo",                                       "pov",     "",   "",    false, false },
  { u8"Upper Kinabatangan",                                         "dmg",     "",   "",    false, false },
  { u8"Upper Kuskokwim",                                            "kuu",     "",   "",    false, false },
  { u8"Upper Necaxa Totonac",                                       "tku",     "",   "",    false, false },
  { u8"Upper Saxon",                                                "sxu",     "",   "",    false, false },
  { u8"Upper Sorbian",                                              "hsb",     "",   "",    true,  false },
  { u8"Upper Ta'oih",                                               "tth",     "",   "",    false, false },
  { u8"Upper Tanana",                                               "tau",     "",   "",    false, false },
  { u8"Upper Tanudan Kalinga",                                      "kgh",     "",   "",    false, true  },
  { u8"Upper Taromi",                                               "tov",     "",   "",    false, false },
  { u8"Upper Umpqua",                                               "xup",     "",   "",    false, false },
  { u8"Ura (Papua New Guinea)",                                     "uro",     "",   "",    false, false },
  { u8"Ura (Vanuatu)",                                              "uur",     "",   "",    false, false },
  { u8"Uradhi",                                                     "urf",     "",   "",    false, false },
  { u8"Urak Lawoi'",                                                "urk",     "",   "",    false, false },
  { u8"Urali",                                                      "url",     "",   "",    false, false },
  { u8"Uralic languages",                                           "urj",     "",   "",    false, false },
  { u8"Urapmin",                                                    "urm",     "",   "",    false, false },
  { u8"Urarina",                                                    "ura",     "",   "",    false, false },
  { u8"Urartian",                                                   "xur",     "",   "",    false, false },
  { u8"Urat",                                                       "urt",     "",   "",    false, false },
  { u8"Urdu",                                                       "urd",     "ur", "",    true,  false },
  { u8"Urhobo",                                                     "urh",     "",   "",    false, false },
  { u8"Uri",                                                        "uvh",     "",   "",    false, false },
  { u8"Urigina",                                                    "urg",     "",   "",    false, false },
  { u8"Urim",                                                       "uri",     "",   "",    false, false },
  { u8"Urimo",                                                      "urx",     "",   "",    false, false },
  { u8"Uripiv-Wala-Rano-Atchin",                                    "upv",     "",   "",    false, false },
  { u8"Urningangg",                                                 "urc",     "",   "",    false, false },
  { u8"Uru",                                                        "ure",     "",   "",    false, false },
  { u8"Uru-Eu-Wau-Wau",                                             "urz",     "",   "",    false, false },
  { u8"Uru-Pa-In",                                                  "urp",     "",   "",    false, false },
  { u8"Uruangnirin",                                                "urn",     "",   "",    false, false },
  { u8"Uruava",                                                     "urv",     "",   "",    false, false },
  { u8"Urubú-Kaapor Sign Language",                                 "uks",     "",   "",    false, false },
  { u8"Urubú-Kaapor",                                               "urb",     "",   "",    false, false },
  { u8"Uruguayan Sign Language",                                    "ugy",     "",   "",    false, false },
  { u8"Urum",                                                       "uum",     "",   "",    false, false },
  { u8"Urumi",                                                      "uru",     "",   "",    false, false },
  { u8"Usaghade",                                                   "usk",     "",   "",    false, false },
  { u8"Usan",                                                       "wnu",     "",   "",    false, false },
  { u8"Usarufa",                                                    "usa",     "",   "",    false, false },
  { u8"Ushojo",                                                     "ush",     "",   "",    false, false },
  { u8"Usila Chinantec",                                            "cuc",     "",   "",    false, false },
  { u8"Usku",                                                       "ulf",     "",   "",    false, false },
  { u8"Uspanteco",                                                  "usp",     "",   "",    false, false },
  { u8"Usui",                                                       "usi",     "",   "",    false, false },
  { u8"Utarmbung",                                                  "omo",     "",   "",    false, false },
  { u8"Ute-Southern Paiute",                                        "ute",     "",   "",    false, false },
  { u8"Uto-Aztecan languages",                                      "azc",     "",   "",    false, false },
  { u8"Utu",                                                        "utu",     "",   "",    false, false },
  { u8"Uvbie",                                                      "evh",     "",   "",    false, false },
  { u8"Uya",                                                        "usu",     "",   "",    false, false },
  { u8"Uyajitaya",                                                  "duk",     "",   "",    false, false },
  { u8"Uzbek",                                                      "uzb",     "uz", "",    true,  false },
  { u8"Uzbeki Arabic",                                              "auz",     "",   "",    false, false },
  { u8"Uzekwe",                                                     "eze",     "",   "",    false, false },
  { u8"Vaagri Booli",                                               "vaa",     "",   "",    false, false },
  { u8"Vafsi",                                                      "vaf",     "",   "",    false, false },
  { u8"Vaghat-Ya-Bijim-Legeri",                                     "bij",     "",   "",    false, true  },
  { u8"Vaghri",                                                     "vgr",     "",   "",    false, false },
  { u8"Vaghua",                                                     "tva",     "",   "",    false, false },
  { u8"Vagla",                                                      "vag",     "",   "",    false, false },
  { u8"Vai",                                                        "vai",     "",   "",    true,  false },
  { u8"Vaiphei",                                                    "vap",     "",   "",    false, false },
  { u8"Vale",                                                       "vae",     "",   "",    false, false },
  { u8"Valencian Sign Language",                                    "vsv",     "",   "",    false, false },
  { u8"Valle Nacional Chinantec",                                   "cvn",     "",   "",    false, false },
  { u8"Valley Maidu",                                               "vmv",     "",   "",    false, false },
  { u8"Valman",                                                     "van",     "",   "",    false, false },
  { u8"Valpei",                                                     "vlp",     "",   "",    false, false },
  { u8"Vamale",                                                     "mkt",     "",   "",    false, false },
  { u8"Vame",                                                       "mlr",     "",   "",    false, false },
  { u8"Vandalic",                                                   "xvn",     "",   "",    false, false },
  { u8"Vangunu",                                                    "mpr",     "",   "",    false, false },
  { u8"Vanimo",                                                     "vam",     "",   "",    false, false },
  { u8"Vano",                                                       "vnk",     "",   "",    false, false },
  { u8"Vanuma",                                                     "vau",     "",   "",    false, false },
  { u8"Vao",                                                        "vao",     "",   "",    false, false },
  { u8"Varhadi-Nagpuri",                                            "vah",     "",   "",    false, false },
  { u8"Varisi",                                                     "vrs",     "",   "",    false, false },
  { u8"Varli",                                                      "vav",     "",   "",    false, false },
  { u8"Vasavi",                                                     "vas",     "",   "",    false, false },
  { u8"Veddah",                                                     "ved",     "",   "",    false, false },
  { u8"Vehes",                                                      "val",     "",   "",    false, false },
  { u8"Veluws",                                                     "vel",     "",   "",    false, false },
  { u8"Vemgo-Mabas",                                                "vem",     "",   "",    false, false },
  { u8"Venda",                                                      "ven",     "ve", "",    true,  false },
  { u8"Venetian",                                                   "vec",     "",   "",    false, false },
  { u8"Venetic",                                                    "xve",     "",   "",    false, false },
  { u8"Venezuelan Sign Language",                                   "vsl",     "",   "",    false, false },
  { u8"Vengo",                                                      "bav",     "",   "",    false, false },
  { u8"Ventureño",                                                  "veo",     "",   "",    false, false },
  { u8"Veps",                                                       "vep",     "",   "",    false, false },
  { u8"Vera'a",                                                     "vra",     "",   "",    false, false },
  { u8"Vestinian",                                                  "xvs",     "",   "",    false, false },
  { u8"Vidunda",                                                    "vid",     "",   "",    false, false },
  { u8"Viemo",                                                      "vig",     "",   "",    false, false },
  { u8"Vietnamese",                                                 "vie",     "vi", "",    true,  false },
  { u8"Vilela",                                                     "vil",     "",   "",    false, false },
  { u8"Vili",                                                       "vif",     "",   "",    false, false },
  { u8"Villa Viciosa Agta",                                         "dyg",     "",   "",    false, false },
  { u8"Vincentian Creole English",                                  "svc",     "",   "",    false, false },
  { u8"Vinmavis",                                                   "vnm",     "",   "",    false, false },
  { u8"Vinza",                                                      "vin",     "",   "",    false, false },
  { u8"Virgin Islands Creole English",                              "vic",     "",   "",    false, false },
  { u8"Vishavan",                                                   "vis",     "",   "",    false, false },
  { u8"Viti",                                                       "vit",     "",   "",    false, false },
  { u8"Vitou",                                                      "vto",     "",   "",    false, false },
  { u8"Vitu",                                                       "wiv",     "",   "",    false, false },
  { u8"Vlaams",                                                     "vls",     "",   "",    false, false },
  { u8"Vlaamse Gebarentaal",                                        "vgt",     "",   "",    false, false },
  { u8"Vlax Romani",                                                "rmy",     "",   "",    false, false },
  { u8"Volapük",                                                    "vol",     "vo", "",    true,  false },
  { u8"Volscian",                                                   "xvo",     "",   "",    false, false },
  { u8"Vono",                                                       "kch",     "",   "",    false, false },
  { u8"Voro",                                                       "vor",     "",   "",    false, false },
  { u8"Votic",                                                      "vot",     "",   "",    true,  false },
  { u8"Vumbu",                                                      "vum",     "",   "",    false, false },
  { u8"Vunapu",                                                     "vnp",     "",   "",    false, false },
  { u8"Vunjo",                                                      "vun",     "",   "",    false, false },
  { u8"Vurës",                                                      "msn",     "",   "",    false, false },
  { u8"Vute",                                                       "vut",     "",   "",    false, false },
  { u8"Vwanji",                                                     "wbi",     "",   "",    false, false },
  { u8"Võro",                                                       "vro",     "",   "",    false, false },
  { u8"Wa",                                                         "wbm",     "",   "",    false, false },
  { u8"Wa'ema",                                                     "wag",     "",   "",    false, false },
  { u8"Waama",                                                      "wwa",     "",   "",    false, false },
  { u8"Waamwang",                                                   "wmn",     "",   "",    false, false },
  { u8"Waata",                                                      "ssn",     "",   "",    false, false },
  { u8"Wab",                                                        "wab",     "",   "",    false, false },
  { u8"Wabo",                                                       "wbb",     "",   "",    false, false },
  { u8"Waboda",                                                     "kmx",     "",   "",    false, false },
  { u8"Waci Gbe",                                                   "wci",     "",   "",    false, false },
  { u8"Wadaginam",                                                  "wdg",     "",   "",    false, false },
  { u8"Waddar",                                                     "wbq",     "",   "",    false, false },
  { u8"Wadi Wadi",                                                  "xwd",     "",   "",    false, false },
  { u8"Wadikali",                                                   "wdk",     "",   "",    false, false },
  { u8"Wadiyara Koli",                                              "kxp",     "",   "",    false, false },
  { u8"Wadjabangayi",                                               "wdy",     "",   "",    false, false },
  { u8"Wadjiginy",                                                  "wdj",     "",   "",    false, false },
  { u8"Wadjigu",                                                    "wdu",     "",   "",    false, false },
  { u8"Wae Rana",                                                   "wrx",     "",   "",    false, false },
  { u8"Waffa",                                                      "waj",     "",   "",    false, false },
  { u8"Wagawaga",                                                   "wgb",     "",   "",    false, false },
  { u8"Wagawaga",                                                   "wgw",     "",   "",    false, true  },
  { u8"Wagaya",                                                     "wga",     "",   "",    false, false },
  { u8"Wagdi",                                                      "wbr",     "",   "",    false, false },
  { u8"Wagi",                                                       "fad",     "",   "",    false, false },
  { u8"Wagiman",                                                    "waq",     "",   "",    false, false },
  { u8"Wahau Kayan",                                                "whu",     "",   "",    false, false },
  { u8"Wahau Kenyah",                                               "whk",     "",   "",    false, false },
  { u8"Wahgi",                                                      "wgi",     "",   "",    false, false },
  { u8"Waigali",                                                    "wbk",     "",   "",    false, false },
  { u8"Waigeo",                                                     "wgo",     "",   "",    false, false },
  { u8"Wailaki",                                                    "wlk",     "",   "",    false, false },
  { u8"Wailapa",                                                    "wlr",     "",   "",    false, false },
  { u8"Waima",                                                      "rro",     "",   "",    false, false },
  { u8"Waima'a",                                                    "wmh",     "",   "",    false, false },
  { u8"Waimaha",                                                    "bao",     "",   "",    false, false },
  { u8"Waimiri-Atroari",                                            "atr",     "",   "",    false, false },
  { u8"Waioli",                                                     "wli",     "",   "",    false, false },
  { u8"Waiwai",                                                     "waw",     "",   "",    false, false },
  { u8"Waja",                                                       "wja",     "",   "",    false, false },
  { u8"Wajarri",                                                    "wbv",     "",   "",    false, false },
  { u8"Wajuk",                                                      "xwj",     "",   "",    false, false },
  { u8"Waka",                                                       "wav",     "",   "",    false, false },
  { u8"Wakabunga",                                                  "wwb",     "",   "",    false, false },
  { u8"Wakashan languages",                                         "wak",     "",   "",    true,  false },
  { u8"Wakawaka",                                                   "wkw",     "",   "",    false, false },
  { u8"Wakde",                                                      "wkd",     "",   "",    false, false },
  { u8"Wakhi",                                                      "wbl",     "",   "",    false, false },
  { u8"Wakoná",                                                     "waf",     "",   "",    false, false },
  { u8"Wala",                                                       "lgl",     "",   "",    false, false },
  { u8"Walak",                                                      "wlw",     "",   "",    false, false },
  { u8"Walangama",                                                  "nlw",     "",   "",    false, false },
  { u8"Wali (Ghana)",                                               "wlx",     "",   "",    false, false },
  { u8"Wali (Sudan)",                                               "wll",     "",   "",    false, false },
  { u8"Waling",                                                     "wly",     "",   "",    false, false },
  { u8"Walio",                                                      "wla",     "",   "",    false, false },
  { u8"Walla Walla",                                                "waa",     "",   "",    false, false },
  { u8"Wallisian",                                                  "wls",     "",   "",    false, false },
  { u8"Walloon",                                                    "wln",     "wa", "",    true,  false },
  { u8"Walmajarri",                                                 "wmt",     "",   "",    false, false },
  { u8"Walo Kumbe Dogon",                                           "dwl",     "",   "",    false, true  },
  { u8"Walser",                                                     "wae",     "",   "",    false, false },
  { u8"Walungge",                                                   "ola",     "",   "",    false, false },
  { u8"Waluwarra",                                                  "wrb",     "",   "",    false, false },
  { u8"Wamas",                                                      "wmc",     "",   "",    false, false },
  { u8"Wambaya",                                                    "wmb",     "",   "",    false, false },
  { u8"Wambon",                                                     "wms",     "",   "",    false, false },
  { u8"Wambule",                                                    "wme",     "",   "",    false, false },
  { u8"Wamesa",                                                     "wad",     "",   "",    false, false },
  { u8"Wamey",                                                      "cou",     "",   "",    false, false },
  { u8"Wamin",                                                      "wmi",     "",   "",    false, false },
  { u8"Wampanoag",                                                  "wam",     "",   "",    false, false },
  { u8"Wampar",                                                     "lbq",     "",   "",    false, false },
  { u8"Wampur",                                                     "waz",     "",   "",    false, false },
  { u8"Wan",                                                        "wan",     "",   "",    false, false },
  { u8"Wanambre",                                                   "wnb",     "",   "",    false, false },
  { u8"Wanap",                                                      "wnp",     "",   "",    false, false },
  { u8"Wancho Naga",                                                "nnp",     "",   "",    false, false },
  { u8"Wanda",                                                      "wbh",     "",   "",    false, false },
  { u8"Wandala",                                                    "mfi",     "",   "",    false, false },
  { u8"Wandarang",                                                  "wnd",     "",   "",    false, false },
  { u8"Wandji",                                                     "wdd",     "",   "",    false, false },
  { u8"Waneci",                                                     "wne",     "",   "",    false, false },
  { u8"Wanga",                                                      "lwg",     "",   "",    false, false },
  { u8"Wangaaybuwan-Ngiyambaa",                                     "wyb",     "",   "",    false, false },
  { u8"Wanggamala",                                                 "wnm",     "",   "",    false, false },
  { u8"Wanggom",                                                    "wng",     "",   "",    false, false },
  { u8"Wangkangurru",                                               "wgg",     "",   "",    false, false },
  { u8"Wangkayutyuru",                                              "wky",     "",   "",    false, false },
  { u8"Wangkumara",                                                 "xwk",     "",   "",    false, false },
  { u8"Wannu",                                                      "jub",     "",   "",    false, false },
  { u8"Wano",                                                       "wno",     "",   "",    false, false },
  { u8"Wantoat",                                                    "wnc",     "",   "",    false, false },
  { u8"Wanukaka",                                                   "wnk",     "",   "",    false, false },
  { u8"Wanyi",                                                      "wny",     "",   "",    false, false },
  { u8"Wané",                                                       "hwa",     "",   "",    false, false },
  { u8"Waorani",                                                    "auc",     "",   "",    false, false },
  { u8"Wapan",                                                      "juk",     "",   "",    false, false },
  { u8"Wapishana",                                                  "wap",     "",   "",    false, false },
  { u8"Wappo",                                                      "wao",     "",   "",    false, false },
  { u8"War-Jaintia",                                                "aml",     "",   "",    false, false },
  { u8"Wara",                                                       "wbf",     "",   "",    false, false },
  { u8"Warao",                                                      "wba",     "",   "",    false, false },
  { u8"Warapu",                                                     "wra",     "",   "",    false, true  },
  { u8"Waray (Australia)",                                          "wrz",     "",   "",    false, false },
  { u8"Waray (Philippines)",                                        "war",     "",   "",    true,  false },
  { u8"Wardaman",                                                   "wrr",     "",   "",    false, false },
  { u8"Wardandi",                                                   "wxw",     "",   "",    false, false },
  { u8"Warduji",                                                    "wrd",     "",   "",    false, true  },
  { u8"Warembori",                                                  "wsa",     "",   "",    false, false },
  { u8"Wares",                                                      "wai",     "",   "",    false, false },
  { u8"Waris",                                                      "wrs",     "",   "",    false, false },
  { u8"Waritai",                                                    "wbe",     "",   "",    false, false },
  { u8"Wariyangga",                                                 "wri",     "",   "",    false, false },
  { u8"Warji",                                                      "wji",     "",   "",    false, false },
  { u8"Warkay-Bipim",                                               "bgv",     "",   "",    false, false },
  { u8"Warlmanpa",                                                  "wrl",     "",   "",    false, false },
  { u8"Warlpiri",                                                   "wbp",     "",   "",    false, false },
  { u8"Warnang",                                                    "wrn",     "",   "",    false, false },
  { u8"Warnman",                                                    "wbt",     "",   "",    false, false },
  { u8"Waropen",                                                    "wrp",     "",   "",    false, false },
  { u8"Warrgamay",                                                  "wgy",     "",   "",    false, false },
  { u8"Warrwa",                                                     "wwr",     "",   "",    false, false },
  { u8"Waru",                                                       "wru",     "",   "",    false, false },
  { u8"Warumungu",                                                  "wrm",     "",   "",    false, false },
  { u8"Waruna",                                                     "wrv",     "",   "",    false, false },
  { u8"Warungu",                                                    "wrg",     "",   "",    false, false },
  { u8"Warwar Feni",                                                "hrw",     "",   "",    false, false },
  { u8"Wasa",                                                       "wss",     "",   "",    false, false },
  { u8"Wasco-Wishram",                                              "wac",     "",   "",    false, false },
  { u8"Wasembo",                                                    "gsp",     "",   "",    false, false },
  { u8"Washo",                                                      "was",     "",   "",    true,  false },
  { u8"Waskia",                                                     "wsk",     "",   "",    false, false },
  { u8"Wasu",                                                       "wsu",     "",   "",    false, false },
  { u8"Watakataui",                                                 "wtk",     "",   "",    false, false },
  { u8"Watam",                                                      "wax",     "",   "",    false, false },
  { u8"Wathawurrung",                                               "wth",     "",   "",    false, false },
  { u8"Watiwa",                                                     "wtf",     "",   "",    false, false },
  { u8"Watubela",                                                   "wah",     "",   "",    false, false },
  { u8"Waube",                                                      "kop",     "",   "",    false, false },
  { u8"Waurá",                                                      "wau",     "",   "",    false, false },
  { u8"Wauyai",                                                     "wuy",     "",   "",    false, false },
  { u8"Wawa",                                                       "www",     "",   "",    false, false },
  { u8"Wawonii",                                                    "wow",     "",   "",    false, false },
  { u8"Waxianghua",                                                 "wxa",     "",   "",    false, false },
  { u8"Wayampi",                                                    "oym",     "",   "",    false, false },
  { u8"Wayana",                                                     "way",     "",   "",    false, false },
  { u8"Wayanad Chetti",                                             "ctt",     "",   "",    false, false },
  { u8"Wayoró",                                                     "wyr",     "",   "",    false, false },
  { u8"Wayu",                                                       "vay",     "",   "",    false, false },
  { u8"Wayuu",                                                      "guc",     "",   "",    false, false },
  { u8"Wedau",                                                      "wed",     "",   "",    false, false },
  { u8"Weh",                                                        "weh",     "",   "",    false, false },
  { u8"Wejewa",                                                     "wew",     "",   "",    false, false },
  { u8"Welaun",                                                     "wlh",     "",   "",    false, false },
  { u8"Weliki",                                                     "klh",     "",   "",    false, false },
  { u8"Welsh Romani",                                               "rmw",     "",   "",    false, false },
  { u8"Welsh",                                                      "wel",     "cy", "cym", true,  false },
  { u8"Wemale",                                                     "weo",     "",   "",    false, false },
  { u8"Wemba Wemba",                                                "xww",     "",   "",    false, false },
  { u8"Weme Gbe",                                                   "wem",     "",   "",    false, false },
  { u8"Wendat",                                                     "wdt",     "",   "",    false, false },
  { u8"Wergaia",                                                    "weg",     "",   "",    false, false },
  { u8"Weri",                                                       "wer",     "",   "",    false, false },
  { u8"Wersing",                                                    "kvw",     "",   "",    false, false },
  { u8"West Albay Bikol",                                           "fbl",     "",   "",    false, false },
  { u8"West Ambae",                                                 "nnd",     "",   "",    false, false },
  { u8"West Bengal Sign Language",                                  "wbs",     "",   "",    false, false },
  { u8"West Berawan",                                               "zbw",     "",   "",    false, false },
  { u8"West Central Banda",                                         "bbp",     "",   "",    false, false },
  { u8"West Central Oromo",                                         "gaz",     "",   "",    false, false },
  { u8"West Coast Bajau",                                           "bdr",     "",   "",    false, false },
  { u8"West Damar",                                                 "drn",     "",   "",    false, false },
  { u8"West Germanic languages",                                    "gmw",     "",   "",    false, false },
  { u8"West Goodenough",                                            "ddi",     "",   "",    false, false },
  { u8"West Kewa",                                                  "kew",     "",   "",    false, false },
  { u8"West Lembata",                                               "lmj",     "",   "",    false, false },
  { u8"West Makian",                                                "mqs",     "",   "",    false, false },
  { u8"West Masela",                                                "mss",     "",   "",    false, false },
  { u8"West Slavic languages",                                      "zlw",     "",   "",    false, false },
  { u8"West Tarangan",                                              "txn",     "",   "",    false, false },
  { u8"West Uvean",                                                 "uve",     "",   "",    false, false },
  { u8"West Yugur",                                                 "ybe",     "",   "",    false, false },
  { u8"West-Central Limba",                                         "lia",     "",   "",    false, false },
  { u8"Western Abnaki",                                             "abe",     "",   "",    false, false },
  { u8"Western Apache",                                             "apw",     "",   "",    false, false },
  { u8"Western Armenian",                                           "hyw",     "",   "",    false, false },
  { u8"Western Arrarnta",                                           "are",     "",   "",    false, false },
  { u8"Western Balochi",                                            "bgn",     "",   "",    false, false },
  { u8"Western Bolivian Guaraní",                                   "gnw",     "",   "",    false, false },
  { u8"Western Bru",                                                "brv",     "",   "",    false, false },
  { u8"Western Bukidnon Manobo",                                    "mbb",     "",   "",    false, false },
  { u8"Western Cham",                                               "cja",     "",   "",    false, false },
  { u8"Western Dani",                                               "dnw",     "",   "",    false, false },
  { u8"Western Durango Nahuatl",                                    "azn",     "",   "",    false, false },
  { u8"Western Fijian",                                             "wyy",     "",   "",    false, false },
  { u8"Western Frisian",                                            "fry",     "fy", "",    true,  false },
  { u8"Western Highland Chatino",                                   "ctp",     "",   "",    false, false },
  { u8"Western Highland Purepecha",                                 "pua",     "",   "",    false, false },
  { u8"Western Huasteca Nahuatl",                                   "nhw",     "",   "",    false, false },
  { u8"Western Juxtlahuaca Mixtec",                                 "jmx",     "",   "",    false, false },
  { u8"Western Kanjobal",                                           "knj",     "",   "",    false, false },
  { u8"Western Karaboro",                                           "kza",     "",   "",    false, false },
  { u8"Western Katu",                                               "kuf",     "",   "",    false, false },
  { u8"Western Kayah",                                              "kyu",     "",   "",    false, false },
  { u8"Western Keres",                                              "kjq",     "",   "",    false, false },
  { u8"Western Krahn",                                              "krw",     "",   "",    false, false },
  { u8"Western Lalu",                                               "ywl",     "",   "",    false, false },
  { u8"Western Lawa",                                               "lcp",     "",   "",    false, false },
  { u8"Western Magar",                                              "mrd",     "",   "",    false, false },
  { u8"Western Malayo-Polynesian languages",                        "pqw",     "",   "",    false, false },
  { u8"Western Maninkakan",                                         "mlq",     "",   "",    false, false },
  { u8"Western Mari",                                               "mrj",     "",   "",    false, false },
  { u8"Western Mashan Hmong",                                       "hmw",     "",   "",    false, false },
  { u8"Western Meohang",                                            "raf",     "",   "",    false, false },
  { u8"Western Minyag",                                             "wmg",     "",   "",    false, false },
  { u8"Western Muria",                                              "mut",     "",   "",    false, false },
  { u8"Western Neo-Aramaic",                                        "amw",     "",   "",    false, false },
  { u8"Western Niger Fulfulde",                                     "fuh",     "",   "",    false, false },
  { u8"Western Ojibwa",                                             "ojw",     "",   "",    false, false },
  { u8"Western Panjabi",                                            "pnb",     "",   "",    false, false },
  { u8"Western Parbate Kham",                                       "kjl",     "",   "",    false, false },
  { u8"Western Penan",                                              "pne",     "",   "",    false, false },
  { u8"Western Sisaala",                                            "ssl",     "",   "",    false, false },
  { u8"Western Subanon",                                            "suc",     "",   "",    false, false },
  { u8"Western Tamang",                                             "tdg",     "",   "",    false, false },
  { u8"Western Tawbuid",                                            "twb",     "",   "",    false, false },
  { u8"Western Tlacolula Valley Zapotec",                           "zab",     "",   "",    false, false },
  { u8"Western Totonac",                                            "tqt",     "",   "",    false, false },
  { u8"Western Tunebo",                                             "tnb",     "",   "",    false, false },
  { u8"Western Xiangxi Miao",                                       "mmr",     "",   "",    false, false },
  { u8"Western Xwla Gbe",                                           "xwl",     "",   "",    false, false },
  { u8"Western Yiddish",                                            "yih",     "",   "",    false, false },
  { u8"Westphalien",                                                "wep",     "",   "",    false, false },
  { u8"Wetamut",                                                    "wwo",     "",   "",    false, false },
  { u8"Wewaw",                                                      "wea",     "",   "",    false, false },
  { u8"Weyto",                                                      "woy",     "",   "",    false, false },
  { u8"White Gelao",                                                "giw",     "",   "",    false, false },
  { u8"White Lachi",                                                "lwh",     "",   "",    false, false },
  { u8"Whitesands",                                                 "tnp",     "",   "",    false, false },
  { u8"Wiarumus",                                                   "tua",     "",   "",    false, false },
  { u8"Wichita",                                                    "wic",     "",   "",    false, false },
  { u8"Wichí Lhamtés Güisnay",                                      "mzh",     "",   "",    false, false },
  { u8"Wichí Lhamtés Nocten",                                       "mtp",     "",   "",    false, false },
  { u8"Wichí Lhamtés Vejoz",                                        "wlv",     "",   "",    false, false },
  { u8"Wik Ngathan",                                                "wig",     "",   "",    false, false },
  { u8"Wik-Epa",                                                    "wie",     "",   "",    false, false },
  { u8"Wik-Iiyanh",                                                 "wij",     "",   "",    false, false },
  { u8"Wik-Keyangan",                                               "wif",     "",   "",    false, false },
  { u8"Wik-Me'anha",                                                "wih",     "",   "",    false, false },
  { u8"Wik-Mungkan",                                                "wim",     "",   "",    false, false },
  { u8"Wikalkan",                                                   "wik",     "",   "",    false, false },
  { u8"Wikngenchera",                                               "wua",     "",   "",    false, false },
  { u8"Wilawila",                                                   "wil",     "",   "",    false, false },
  { u8"Wintu",                                                      "wit",     "",   "",    false, true  },
  { u8"Wintu",                                                      "wnw",     "",   "",    false, false },
  { u8"Winyé",                                                      "kst",     "",   "",    false, false },
  { u8"Wipi",                                                       "gdr",     "",   "",    false, false },
  { u8"Wiradjuri",                                                  "wrh",     "",   "",    false, false },
  { u8"Wiraféd",                                                    "wir",     "",   "",    false, false },
  { u8"Wirangu",                                                    "wgu",     "",   "",    false, false },
  { u8"Wirangu",                                                    "wiw",     "",   "",    false, true  },
  { u8"Wiru",                                                       "wiu",     "",   "",    false, false },
  { u8"Wiyot",                                                      "wiy",     "",   "",    false, false },
  { u8"Woccon",                                                     "xwc",     "",   "",    false, false },
  { u8"Wogamusin",                                                  "wog",     "",   "",    false, false },
  { u8"Wogeo",                                                      "woc",     "",   "",    false, false },
  { u8"Woi",                                                        "wbw",     "",   "",    false, false },
  { u8"Woiwurrung",                                                 "wyi",     "",   "",    false, false },
  { u8"Wojenaka",                                                   "jod",     "",   "",    false, false },
  { u8"Wolane",                                                     "wle",     "",   "",    false, false },
  { u8"Wolani",                                                     "wod",     "",   "",    false, false },
  { u8"Wolaytta",                                                   "wal",     "",   "",    true,  false },
  { u8"Woleaian",                                                   "woe",     "",   "",    false, false },
  { u8"Wolio",                                                      "wlo",     "",   "",    false, false },
  { u8"Wolof",                                                      "wol",     "wo", "",    true,  false },
  { u8"Wom (Nigeria)",                                              "wom",     "",   "",    false, false },
  { u8"Wom (Papua New Guinea)",                                     "wmo",     "",   "",    false, false },
  { u8"Womo",                                                       "wmx",     "",   "",    false, false },
  { u8"Wongo",                                                      "won",     "",   "",    false, false },
  { u8"Woods Cree",                                                 "cwd",     "",   "",    false, false },
  { u8"Woria",                                                      "wor",     "",   "",    false, false },
  { u8"Worimi",                                                     "kda",     "",   "",    false, false },
  { u8"Worodougou",                                                 "jud",     "",   "",    false, false },
  { u8"Worora",                                                     "unp",     "",   "",    false, true  },
  { u8"Worrorra",                                                   "wro",     "",   "",    false, false },
  { u8"Wotapuri-Katarqalai",                                        "wsv",     "",   "",    false, false },
  { u8"Wotjobaluk",                                                 "xwt",     "",   "",    false, false },
  { u8"Wotu",                                                       "wtw",     "",   "",    false, false },
  { u8"Woun Meu",                                                   "noa",     "",   "",    false, false },
  { u8"Written Oirat",                                              "xwo",     "",   "",    false, false },
  { u8"Wu Chinese",                                                 "wuu",     "",   "",    false, false },
  { u8"Wuding-Luquan Yi",                                           "ywq",     "",   "",    false, false },
  { u8"Wudu",                                                       "wud",     "",   "",    false, false },
  { u8"Wuliwuli",                                                   "wlu",     "",   "",    false, false },
  { u8"Wulna",                                                      "wux",     "",   "",    false, false },
  { u8"Wumboko",                                                    "bqm",     "",   "",    false, false },
  { u8"Wumbvu",                                                     "wum",     "",   "",    false, false },
  { u8"Wumeng Nasu",                                                "ywu",     "",   "",    false, false },
  { u8"Wunai Bunu",                                                 "bwn",     "",   "",    false, false },
  { u8"Wunambal",                                                   "wub",     "",   "",    false, false },
  { u8"Wunumara",                                                   "wnn",     "",   "",    false, false },
  { u8"Wurrugu",                                                    "wur",     "",   "",    false, false },
  { u8"Wusa Nasu",                                                  "yig",     "",   "",    false, false },
  { u8"Wushi",                                                      "bse",     "",   "",    false, false },
  { u8"Wusi",                                                       "wsi",     "",   "",    false, false },
  { u8"Wutung",                                                     "wut",     "",   "",    false, false },
  { u8"Wutunhua",                                                   "wuh",     "",   "",    false, false },
  { u8"Wuvulu-Aua",                                                 "wuv",     "",   "",    false, false },
  { u8"Wuzlam",                                                     "udl",     "",   "",    false, false },
  { u8"Wyandot",                                                    "wya",     "",   "",    false, true  },
  { u8"Wyandot",                                                    "wyn",     "",   "",    false, false },
  { u8"Wymysorys",                                                  "wym",     "",   "",    false, false },
  { u8"Wára",                                                       "tci",     "",   "",    false, false },
  { u8"Wãpha",                                                      "juw",     "",   "",    false, false },
  { u8"Wè Northern",                                                "wob",     "",   "",    false, false },
  { u8"Wè Southern",                                                "gxx",     "",   "",    false, false },
  { u8"Wè Western",                                                 "wec",     "",   "",    false, false },
  { u8"Xaasongaxango",                                              "kao",     "",   "",    false, false },
  { u8"Xadani Zapotec",                                             "zax",     "",   "",    false, false },
  { u8"Xakriabá",                                                   "xkr",     "",   "",    false, false },
  { u8"Xamtanga",                                                   "xan",     "",   "",    false, false },
  { u8"Xanaguía Zapotec",                                           "ztg",     "",   "",    false, false },
  { u8"Xavánte",                                                    "xav",     "",   "",    false, false },
  { u8"Xerénte",                                                    "xer",     "",   "",    false, false },
  { u8"Xetá",                                                       "xet",     "",   "",    false, false },
  { u8"Xhosa",                                                      "xho",     "xh", "",    true,  false },
  { u8"Xiandao",                                                    "xia",     "",   "",    false, true  },
  { u8"Xiang Chinese",                                              "hsn",     "",   "",    false, false },
  { u8"Xibe",                                                       "sjo",     "",   "",    false, false },
  { u8"Xicotepec De Juárez Totonac",                                "too",     "",   "",    false, false },
  { u8"Xinca",                                                      "xin",     "",   "",    false, false },
  { u8"Xingú Asuriní",                                              "asn",     "",   "",    false, false },
  { u8"Xipaya",                                                     "xiy",     "",   "",    false, false },
  { u8"Xipináwa",                                                   "xip",     "",   "",    false, true  },
  { u8"Xiri",                                                       "xii",     "",   "",    false, false },
  { u8"Xiriâna",                                                    "xir",     "",   "",    false, false },
  { u8"Xishanba Lalo",                                              "ywt",     "",   "",    false, false },
  { u8"Xokleng",                                                    "xok",     "",   "",    false, false },
  { u8"Xukurú",                                                     "xoo",     "",   "",    false, false },
  { u8"Xwela Gbe",                                                  "xwe",     "",   "",    false, false },
  { u8"Xârâcùù",                                                    "ane",     "",   "",    false, false },
  { u8"Xârâgurè",                                                   "axx",     "",   "",    false, false },
  { u8"Yaaku",                                                      "muu",     "",   "",    false, false },
  { u8"Yabarana",                                                   "yar",     "",   "",    false, false },
  { u8"Yabaâna",                                                    "ybn",     "",   "",    false, false },
  { u8"Yabem",                                                      "jae",     "",   "",    false, false },
  { u8"Yaben",                                                      "ybm",     "",   "",    false, false },
  { u8"Yabong",                                                     "ybo",     "",   "",    false, false },
  { u8"Yabula Yabula",                                              "yxy",     "",   "",    false, false },
  { u8"Yace",                                                       "ekr",     "",   "",    false, false },
  { u8"Yaeyama",                                                    "rys",     "",   "",    false, false },
  { u8"Yafi",                                                       "wfg",     "",   "",    false, false },
  { u8"Yagara",                                                     "yxg",     "",   "",    false, false },
  { u8"Yagaria",                                                    "ygr",     "",   "",    false, false },
  { u8"Yagnobi",                                                    "yai",     "",   "",    false, false },
  { u8"Yagomi",                                                     "ygm",     "",   "",    false, false },
  { u8"Yagua",                                                      "yad",     "",   "",    false, false },
  { u8"Yagwoia",                                                    "ygw",     "",   "",    false, false },
  { u8"Yahadian",                                                   "ner",     "",   "",    false, false },
  { u8"Yahang",                                                     "rhp",     "",   "",    false, false },
  { u8"Yahuna",                                                     "ynu",     "",   "",    false, false },
  { u8"Yaka (Central African Republic)",                            "axk",     "",   "",    false, false },
  { u8"Yaka (Congo)",                                               "iyx",     "",   "",    false, false },
  { u8"Yaka (Democratic Republic of Congo)",                        "yaf",     "",   "",    false, false },
  { u8"Yakaikeke",                                                  "ykk",     "",   "",    false, false },
  { u8"Yakama",                                                     "yak",     "",   "",    false, false },
  { u8"Yakan",                                                      "yka",     "",   "",    false, false },
  { u8"Yakha",                                                      "ybh",     "",   "",    false, false },
  { u8"Yakoma",                                                     "yky",     "",   "",    false, false },
  { u8"Yakut",                                                      "sah",     "",   "",    true,  false },
  { u8"Yala",                                                       "yba",     "",   "",    false, false },
  { u8"Yalahatan",                                                  "jal",     "",   "",    false, false },
  { u8"Yalakalore",                                                 "xyl",     "",   "",    false, false },
  { u8"Yalarnnga",                                                  "ylr",     "",   "",    false, false },
  { u8"Yale",                                                       "nce",     "",   "",    false, false },
  { u8"Yaleba",                                                     "ylb",     "",   "",    false, false },
  { u8"Yalunka",                                                    "yal",     "",   "",    false, false },
  { u8"Yalálag Zapotec",                                            "zpu",     "",   "",    false, false },
  { u8"Yamap",                                                      "ymp",     "",   "",    false, false },
  { u8"Yamba",                                                      "yam",     "",   "",    false, false },
  { u8"Yambes",                                                     "ymb",     "",   "",    false, false },
  { u8"Yambeta",                                                    "yat",     "",   "",    false, false },
  { u8"Yamdena",                                                    "jmd",     "",   "",    false, false },
  { u8"Yameo",                                                      "yme",     "",   "",    false, false },
  { u8"Yami",                                                       "tao",     "",   "",    false, false },
  { u8"Yaminahua",                                                  "yaa",     "",   "",    false, false },
  { u8"Yamna",                                                      "ymn",     "",   "",    false, false },
  { u8"Yamongeri",                                                  "ymg",     "",   "",    false, false },
  { u8"Yamphe",                                                     "yma",     "",   "",    false, true  },
  { u8"Yamphu",                                                     "ybi",     "",   "",    false, false },
  { u8"Yan-nhangu",                                                 "jay",     "",   "",    false, false },
  { u8"Yan-nhaŋu Sign Language",                                    "yhs",     "",   "",    false, false },
  { u8"Yana",                                                       "ynn",     "",   "",    false, false },
  { u8"Yanahuanca Pasco Quechua",                                   "qur",     "",   "",    false, false },
  { u8"Yanda Dom Dogon",                                            "dym",     "",   "",    false, false },
  { u8"Yanda",                                                      "yda",     "",   "",    false, false },
  { u8"Yandjibara",                                                 "xyb",     "",   "",    false, false },
  { u8"Yandruwandha",                                               "ynd",     "",   "",    false, false },
  { u8"Yanesha'",                                                   "ame",     "",   "",    false, false },
  { u8"Yang Zhuang",                                                "zyg",     "",   "",    false, false },
  { u8"Yangben",                                                    "yav",     "",   "",    false, false },
  { u8"Yangbye",                                                    "ybd",     "",   "",    false, true  },
  { u8"Yangho",                                                     "ynh",     "",   "",    false, true  },
  { u8"Yangkam",                                                    "bsx",     "",   "",    false, false },
  { u8"Yangman",                                                    "jng",     "",   "",    false, false },
  { u8"Yango",                                                      "yng",     "",   "",    false, false },
  { u8"Yangulam",                                                   "ynl",     "",   "",    false, false },
  { u8"Yangum Dey",                                                 "yde",     "",   "",    false, false },
  { u8"Yangum Gel",                                                 "ygl",     "",   "",    false, false },
  { u8"Yangum Mon",                                                 "ymo",     "",   "",    false, false },
  { u8"Yankunytjatjara",                                            "kdd",     "",   "",    false, false },
  { u8"Yanomamö",                                                   "guu",     "",   "",    false, false },
  { u8"Yanomámi",                                                   "wca",     "",   "",    false, false },
  { u8"Yansi",                                                      "yns",     "",   "",    false, false },
  { u8"Yanyuwa",                                                    "jao",     "",   "",    false, false },
  { u8"Yao",                                                        "yao",     "",   "",    true,  false },
  { u8"Yaosakor Asmat",                                             "asy",     "",   "",    false, false },
  { u8"Yaouré",                                                     "yre",     "",   "",    false, false },
  { u8"Yapese",                                                     "yap",     "",   "",    true,  false },
  { u8"Yapunda",                                                    "yev",     "",   "",    false, false },
  { u8"Yaqay",                                                      "jaq",     "",   "",    false, false },
  { u8"Yaqui",                                                      "yaq",     "",   "",    false, false },
  { u8"Yarawata",                                                   "yrw",     "",   "",    false, false },
  { u8"Yardliyawarra",                                              "yxl",     "",   "",    false, false },
  { u8"Yareba",                                                     "yrb",     "",   "",    false, false },
  { u8"Yareni Zapotec",                                             "zae",     "",   "",    false, false },
  { u8"Yarluyandi",                                                 "yry",     "",   "",    false, false },
  { u8"Yaroamë",                                                    "yro",     "",   "",    false, false },
  { u8"Yarsun",                                                     "yrs",     "",   "",    false, false },
  { u8"Yarí",                                                       "yri",     "",   "",    false, true  },
  { u8"Yasa",                                                       "yko",     "",   "",    false, false },
  { u8"Yassic",                                                     "ysc",     "",   "",    false, false },
  { u8"Yatay",                                                      "yty",     "",   "",    false, false },
  { u8"Yatee Zapotec",                                              "zty",     "",   "",    false, false },
  { u8"Yatzachi Zapotec",                                           "zav",     "",   "",    false, false },
  { u8"Yau (Morobe Province)",                                      "yuw",     "",   "",    false, false },
  { u8"Yau (Sandaun Province)",                                     "yyu",     "",   "",    false, false },
  { u8"Yaul",                                                       "yla",     "",   "",    false, false },
  { u8"Yauma",                                                      "yax",     "",   "",    false, false },
  { u8"Yaur",                                                       "jau",     "",   "",    false, false },
  { u8"Yautepec Zapotec",                                           "zpb",     "",   "",    false, false },
  { u8"Yauyos Quechua",                                             "qux",     "",   "",    false, false },
  { u8"Yavitero",                                                   "yvt",     "",   "",    false, false },
  { u8"Yawa",                                                       "yva",     "",   "",    false, false },
  { u8"Yawalapití",                                                 "yaw",     "",   "",    false, false },
  { u8"Yawanawa",                                                   "ywn",     "",   "",    false, false },
  { u8"Yawarawarga",                                                "yww",     "",   "",    false, false },
  { u8"Yaweyuha",                                                   "yby",     "",   "",    false, false },
  { u8"Yawijibaya",                                                 "jbw",     "",   "",    false, false },
  { u8"Yawiyo",                                                     "ybx",     "",   "",    false, false },
  { u8"Yawuru",                                                     "ywr",     "",   "",    false, false },
  { u8"Yaygir",                                                     "xya",     "",   "",    false, false },
  { u8"Yazgulyam",                                                  "yah",     "",   "",    false, false },
  { u8"Yecuatla Totonac",                                           "tlc",     "",   "",    false, false },
  { u8"Yei",                                                        "jei",     "",   "",    false, false },
  { u8"Yekhee",                                                     "ets",     "",   "",    false, false },
  { u8"Yekora",                                                     "ykr",     "",   "",    false, false },
  { u8"Yela",                                                       "yel",     "",   "",    false, false },
  { u8"Yele",                                                       "yle",     "",   "",    false, false },
  { u8"Yelmek",                                                     "jel",     "",   "",    false, false },
  { u8"Yelogu",                                                     "ylg",     "",   "",    false, false },
  { u8"Yemba",                                                      "ybb",     "",   "",    false, false },
  { u8"Yemsa",                                                      "jnj",     "",   "",    false, false },
  { u8"Yendang",                                                    "yen",     "",   "",    false, true  },
  { u8"Yendang",                                                    "ynq",     "",   "",    false, false },
  { u8"Yeni",                                                       "yei",     "",   "",    false, false },
  { u8"Yeniche",                                                    "yec",     "",   "",    false, false },
  { u8"Yerakai",                                                    "yra",     "",   "",    false, false },
  { u8"Yeretuar",                                                   "gop",     "",   "",    false, false },
  { u8"Yerong",                                                     "yrn",     "",   "",    false, false },
  { u8"Yerukula",                                                   "yeu",     "",   "",    false, false },
  { u8"Yessan-Mayo",                                                "yss",     "",   "",    false, false },
  { u8"Yetfa",                                                      "yet",     "",   "",    false, false },
  { u8"Yevanic",                                                    "yej",     "",   "",    false, false },
  { u8"Yeyi",                                                       "yey",     "",   "",    false, false },
  { u8"Yiddish Sign Language",                                      "yds",     "",   "",    false, true  },
  { u8"Yiddish",                                                    "yid",     "yi", "",    true,  false },
  { u8"Yidgha",                                                     "ydg",     "",   "",    false, false },
  { u8"Yidiny",                                                     "yii",     "",   "",    false, false },
  { u8"Yil",                                                        "yll",     "",   "",    false, false },
  { u8"Yimas",                                                      "yee",     "",   "",    false, false },
  { u8"Yimchungru Naga",                                            "yim",     "",   "",    false, false },
  { u8"Yinbaw Karen",                                               "kvu",     "",   "",    false, false },
  { u8"Yindjibarndi",                                               "yij",     "",   "",    false, false },
  { u8"Yindjilandji",                                               "yil",     "",   "",    false, false },
  { u8"Yine",                                                       "pib",     "",   "",    false, false },
  { u8"Yinggarda",                                                  "yia",     "",   "",    false, false },
  { u8"Yinhawangka",                                                "ywg",     "",   "",    false, false },
  { u8"Yiningayi",                                                  "ygi",     "",   "",    false, false },
  { u8"Yintale Karen",                                              "kvy",     "",   "",    false, false },
  { u8"Yinwum",                                                     "yxm",     "",   "",    false, false },
  { u8"Yir Yoront",                                                 "yiy",     "",   "",    false, true  },
  { u8"Yir Yoront",                                                 "yyr",     "",   "",    false, false },
  { u8"Yirandali",                                                  "ljw",     "",   "",    false, false },
  { u8"Yirrk-Mel",                                                  "yrm",     "",   "",    false, false },
  { u8"Yis",                                                        "yis",     "",   "",    false, false },
  { u8"Yitha Yitha",                                                "xth",     "",   "",    false, false },
  { u8"Yoba",                                                       "yob",     "",   "",    false, false },
  { u8"Yocoboué Dida",                                              "gud",     "",   "",    false, false },
  { u8"Yogad",                                                      "yog",     "",   "",    false, false },
  { u8"Yoidik",                                                     "ydk",     "",   "",    false, false },
  { u8"Yoke",                                                       "yki",     "",   "",    false, false },
  { u8"Yokuts",                                                     "yok",     "",   "",    false, false },
  { u8"Yola",                                                       "yol",     "",   "",    false, false },
  { u8"Yoloxochitl Mixtec",                                         "xty",     "",   "",    false, false },
  { u8"Yolŋu Sign Language",                                        "ygs",     "",   "",    false, false },
  { u8"Yom",                                                        "pil",     "",   "",    false, false },
  { u8"Yombe",                                                      "yom",     "",   "",    false, false },
  { u8"Yonaguni",                                                   "yoi",     "",   "",    false, false },
  { u8"Yong",                                                       "yno",     "",   "",    false, false },
  { u8"Yongbei Zhuang",                                             "zyb",     "",   "",    false, false },
  { u8"Yongkom",                                                    "yon",     "",   "",    false, false },
  { u8"Yongnan Zhuang",                                             "zyn",     "",   "",    false, false },
  { u8"Yopno",                                                      "yut",     "",   "",    false, false },
  { u8"Yora",                                                       "mts",     "",   "",    false, false },
  { u8"Yoron",                                                      "yox",     "",   "",    false, false },
  { u8"Yorta Yorta",                                                "xyy",     "",   "",    false, false },
  { u8"Yoruba",                                                     "yor",     "yo", "",    true,  false },
  { u8"Yos",                                                        "yos",     "",   "",    false, true  },
  { u8"Yosondúa Mixtec",                                            "mpm",     "",   "",    false, false },
  { u8"Yotti",                                                      "yot",     "",   "",    false, false },
  { u8"Youjiang Zhuang",                                            "zyj",     "",   "",    false, false },
  { u8"Youle Jinuo",                                                "jiu",     "",   "",    false, false },
  { u8"Younuo Bunu",                                                "buh",     "",   "",    false, false },
  { u8"Yout Wam",                                                   "ytw",     "",   "",    false, false },
  { u8"Yoy",                                                        "yoy",     "",   "",    false, false },
  { u8"Yuanga",                                                     "nua",     "",   "",    false, false },
  { u8"Yucatec Maya Sign Language",                                 "msd",     "",   "",    false, false },
  { u8"Yucateco",                                                   "yua",     "",   "",    false, false },
  { u8"Yuchi",                                                      "yuc",     "",   "",    false, false },
  { u8"Yucuañe Mixtec",                                             "mvg",     "",   "",    false, false },
  { u8"Yucuna",                                                     "ycn",     "",   "",    false, false },
  { u8"Yue Chinese",                                                "yue",     "",   "",    false, false },
  { u8"Yug",                                                        "yug",     "",   "",    false, false },
  { u8"Yugambal",                                                   "yub",     "",   "",    false, false },
  { u8"Yugh",                                                       "yuu",     "",   "",    false, true  },
  { u8"Yugoslavian Sign Language",                                  "ysl",     "",   "",    false, false },
  { u8"Yugul",                                                      "ygu",     "",   "",    false, false },
  { u8"Yuhup",                                                      "yab",     "",   "",    false, false },
  { u8"Yuki",                                                       "yuk",     "",   "",    false, false },
  { u8"Yukpa",                                                      "yup",     "",   "",    false, false },
  { u8"Yukuben",                                                    "ybl",     "",   "",    false, false },
  { u8"Yulu",                                                       "yul",     "",   "",    false, false },
  { u8"Yupik languages",                                            "ypk",     "",   "",    true,  false },
  { u8"Yuqui",                                                      "yuq",     "",   "",    false, false },
  { u8"Yuracare",                                                   "yuz",     "",   "",    false, false },
  { u8"Yurats",                                                     "rts",     "",   "",    false, false },
  { u8"Yurok",                                                      "yur",     "",   "",    false, false },
  { u8"Yuru",                                                       "ljx",     "",   "",    false, false },
  { u8"Yurutí",                                                     "yui",     "",   "",    false, false },
  { u8"Yutanduchi Mixtec",                                          "mab",     "",   "",    false, false },
  { u8"Yuwana",                                                     "yau",     "",   "",    false, false },
  { u8"Yuyu",                                                       "yxu",     "",   "",    false, false },
  { u8"Ywom",                                                       "gek",     "",   "",    false, false },
  { u8"Yámana",                                                     "yag",     "",   "",    false, false },
  { u8"Zaachila Zapotec",                                           "ztx",     "",   "",    false, false },
  { u8"Zabana",                                                     "kji",     "",   "",    false, false },
  { u8"Zacatepec Chatino",                                          "ctz",     "",   "",    false, false },
  { u8"Zacatlán-Ahuacatlán-Tepetzintla Nahuatl",                    "nhi",     "",   "",    false, false },
  { u8"Zaghawa",                                                    "zag",     "",   "",    false, false },
  { u8"Zaiwa",                                                      "atb",     "",   "",    false, false },
  { u8"Zakhring",                                                   "zkr",     "",   "",    false, false },
  { u8"Zambian Sign Language",                                      "zsl",     "",   "",    false, false },
  { u8"Zan Gula",                                                   "zna",     "",   "",    false, false },
  { u8"Zanaki",                                                     "zak",     "",   "",    false, false },
  { u8"Zande (individual language)",                                "zne",     "",   "",    false, false },
  { u8"Zande languages",                                            "znd",     "",   "",    true,  false },
  { u8"Zangskari",                                                  "zau",     "",   "",    false, false },
  { u8"Zangwal",                                                    "zah",     "",   "",    false, false },
  { u8"Zaniza Zapotec",                                             "zpw",     "",   "",    false, false },
  { u8"Zapotec",                                                    "zap",     "",   "",    true,  false },
  { u8"Zaramo",                                                     "zaj",     "",   "",    false, false },
  { u8"Zari",                                                       "zaz",     "",   "",    false, false },
  { u8"Zarma",                                                      "dje",     "",   "",    false, false },
  { u8"Zarphatic",                                                  "zrp",     "",   "",    false, false },
  { u8"Zauzou",                                                     "zal",     "",   "",    false, false },
  { u8"Zay",                                                        "zwa",     "",   "",    false, false },
  { u8"Zayein Karen",                                               "kxk",     "",   "",    false, false },
  { u8"Zayse-Zergulla",                                             "zay",     "",   "",    false, false },
  { u8"Zaza",                                                       "zza",     "",   "",    true,  false },
  { u8"Zazao",                                                      "jaj",     "",   "",    false, false },
  { u8"Zeem",                                                       "zua",     "",   "",    false, false },
  { u8"Zeeuws",                                                     "zea",     "",   "",    false, false },
  { u8"Zemba",                                                      "dhm",     "",   "",    false, false },
  { u8"Zeme Naga",                                                  "nzm",     "",   "",    false, false },
  { u8"Zemgalian",                                                  "xzm",     "",   "",    false, false },
  { u8"Zenag",                                                      "zeg",     "",   "",    false, false },
  { u8"Zenaga",                                                     "zen",     "",   "",    true,  false },
  { u8"Zenzontepec Chatino",                                        "czn",     "",   "",    false, false },
  { u8"Zerenkel",                                                   "zrn",     "",   "",    false, false },
  { u8"Zhaba",                                                      "zhb",     "",   "",    false, false },
  { u8"Zhang-Zhung",                                                "xzh",     "",   "",    false, false },
  { u8"Zhire",                                                      "zhi",     "",   "",    false, false },
  { u8"Zhoa",                                                       "zhw",     "",   "",    false, false },
  { u8"Zhuang",                                                     "zha",     "za", "",    true,  false },
  { u8"Zia",                                                        "zia",     "",   "",    false, false },
  { u8"Zialo",                                                      "zil",     "",   "",    false, false },
  { u8"Zigula",                                                     "ziw",     "",   "",    false, false },
  { u8"Zimakani",                                                   "zik",     "",   "",    false, false },
  { u8"Zimba",                                                      "zmb",     "",   "",    false, false },
  { u8"Zimbabwe Sign Language",                                     "zib",     "",   "",    false, false },
  { u8"Zinza",                                                      "zin",     "",   "",    false, false },
  { u8"Zire",                                                       "sih",     "",   "",    false, false },
  { u8"Ziriya",                                                     "zir",     "",   "",    false, true  },
  { u8"Zizilivakan",                                                "ziz",     "",   "",    false, false },
  { u8"Zo'é",                                                       "pto",     "",   "",    false, false },
  { u8"Zokhuo",                                                     "yzk",     "",   "",    false, false },
  { u8"Zoogocho Zapotec",                                           "zpq",     "",   "",    false, false },
  { u8"Zoroastrian Dari",                                           "gbz",     "",   "",    false, false },
  { u8"Zotung Chin",                                                "czt",     "",   "",    false, false },
  { u8"Zou",                                                        "zom",     "",   "",    false, false },
  { u8"Zula",                                                       "zla",     "",   "",    false, false },
  { u8"Zulgo-Gemzek",                                               "gnd",     "",   "",    false, false },
  { u8"Zulu",                                                       "zul",     "zu", "",    true,  false },
  { u8"Zumaya",                                                     "zuy",     "",   "",    false, false },
  { u8"Zumbun",                                                     "jmb",     "",   "",    false, false },
  { u8"Zuni",                                                       "zun",     "",   "",    true,  false },
  { u8"Zuojiang Zhuang",                                            "zzj",     "",   "",    false, false },
  { u8"Zyphe Chin",                                                 "zyp",     "",   "",    false, false },
  { u8"Záparo",                                                     "zro",     "",   "",    false, false },
  { u8"sTodsde",                                                    "jih",     "",   "",    false, false },
  { u8"us-Saare",                                                   "uss",     "",   "",    false, false },
  { u8"ut-Hun",                                                     "uth",     "",   "",    false, false },
  { u8"ut-Ma'in",                                                   "gel",     "",   "",    false, false },
  { u8"Àhàn",                                                       "ahn",     "",   "",    false, false },
  { u8"Áncá",                                                       "acb",     "",   "",    false, false },
  { u8"Ömie",                                                       "aom",     "",   "",    false, false },
  { u8"Önge",                                                       "oon",     "",   "",    false, false },
  { u8"ǀGwi",                                                       "gwj",     "",   "",    false, false },
  { u8"ǀXam",                                                       "xam",     "",   "",    false, false },
  { u8"ǁAni",                                                       "hnh",     "",   "",    false, false },
  { u8"ǁGana",                                                      "gnk",     "",   "",    false, false },
  { u8"ǁXegwi",                                                     "xeg",     "",   "",    false, false },
  { u8"ǂHua",                                                       "huc",     "",   "",    false, false },
  { u8"ǂKxʼauǁʼein",                                                "aue",     "",   "",    false, true  },
  { u8"ǂUngkue",                                                    "gku",     "",   "",    false, false },
  { u8"ǃOǃung",                                                     "oun",     "",   "",    false, true  },
  { u8"ǃXóõ",                                                       "nmn",     "",   "",    false, false },
};

void
init() {
  g_languages.reserve(8755);

  for (language_init_t const *lang = s_languages_init, *end = lang + 8755; lang < end; ++lang)
    g_languages.emplace_back(lang->english_name, lang->alpha_3_code, lang->alpha_2_code, lang->terminology_abbrev, lang->is_part_of_iso639_2, lang->is_deprecated);
}

} // namespace mtx::iso639
