# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class LagrangianParticleTracker(DataObjectAlgorithm):
    r"""
    LagrangianParticleTracker - Filter to inject and track particles
    in a flow
    
    Superclass: DataObjectAlgorithm
    
    Introduce lagrangian_particle_tracker
    
    This is a very flexible and adaptive filter to inject and track
    particles in a flow. It takes three inputs :
    * port 0 : Flow Input, a volumic dataset containing data to integrate
    with, any kind of data object, support distributed input.
    * port 1 : Seed (source) Input, a dataset containing point to
      generate particles with, any kind of data object, support
      distributed input. Only first leaf of composite dataset is used.
    * port 2 : Optional Surface Input, containing dataset to interact
      with, any kind of data object, support distributed input.
    
    It has two outputs :
    * port 0 : particle_paths : a multipiece of polyData (one per thread)
      of polyLines showing the paths of particles in the flow
    * port 1 : particle_interactions : empty if no surface input, contains
    a a multiblock with as many children as the number of threads, each
      children containing a multiblock with the same structure as the
      surfaces. The leafs of these structures contain a polydata of
      vertexes corresponding to the interactions. with the same composite
    layout of surface input if any, showing all interactions between
      particles and the surface input.
    
    It has a parallel implementation which streams particle between
    domains.
    
    The most important parameters of this filter is it's
    integrationModel. Only one integration model implementation exist
    currently in para_view ,vtklagrangian_matida_integration_model but the
    design enables plugin developers to expand this tracker by creating
    new models. A model can define  :
    * The number of integration variable and new user defined integration
    variable
    * the way the particle are integrated
    * the way particles intersect and interact with the surface
    * the way freeFlight termination is handled
    * pre_process and post_process methods
    * Manual Integration, Manual partichle shifting see
      LagrangianBasicIntegrationModel and
      LagrangianMatidaIntegrationModel for more information
    
    It also let the user choose the Locator to use when integrating in
    the flow, as well as the Integrator to use. Integration steps are
    also highly configurable, step, step min and step max are passed down
    to the integrator (hence min and max does not matter with a non
    adaptive integrator like RK4/5)
    
    
     An integration_model is a very specific FunctionSet with a lot of
    features allowing inherited classes to concentrate on the
    mathematical part of the code.
     a Particle is basically a class wrapper around three table
    containing variables about the particle at previous, current and next
    position.
     The particle is passed to the integrator, which use the integration
    model to integrate the particle in the flow.
    
    It has other features also, including :
    * Adaptative Step Reintegration, to retry the step with different
      time step when the next position is too far
    * Different kind of cell length computation, including a divergence
      theorem based computation
    * Optional lines rendering controlled by a threshold
    * Ghost cell support
    * Non planar quad interaction support
    * Built-in support for surface interaction including, terminate,
      bounce, break-up and pass-through surface The serial and parallel
      filters are fully tested.
    
    @sa
    LagrangianMatidaIntegrationModel LagrangianParticle
    LagrangianBasicIntegrationModel
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLagrangianParticleTracker, obj, update, **traits)
    
    adaptive_step_reintegration = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get the Adaptive Step Reintegration feature. it checks the
        step size after the integration and if it is too big will retry
        with a smaller step Default is false.
        """
    )

    def _adaptive_step_reintegration_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAdaptiveStepReintegration,
                        self.adaptive_step_reintegration_)

    generate_particle_paths_output = tvtk_base.true_bool_trait(desc=\
        r"""
        Set/Get the generation of the particle path output, Default is
        true.
        """
    )

    def _generate_particle_paths_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateParticlePathsOutput,
                        self.generate_particle_paths_output_)

    cell_length_computation_mode = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the cell length computation mode. Available modes are :
        - STEP_CUR_CELL_LENGTH : Compute cell length using getLength
          method on the current cell the particle is in
        - STEP_CUR_CELL_VEL_DIR : Compute cell length using the particle
          velocity and the edges of the last cell the particle was in.
        - STEP_CUR_CELL_DIV_THEO : Compute cell length using the particle
        velocity and the divergence theorem.
        """
    )

    def _cell_length_computation_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellLengthComputationMode,
                        self.cell_length_computation_mode)

    generate_poly_vertex_interaction_output = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get whether or not to use poly_vertex cell type for the
        interaction output Default is false
        """
    )

    def _generate_poly_vertex_interaction_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGeneratePolyVertexInteractionOutput,
                        self.generate_poly_vertex_interaction_output)

    def _get_integration_model(self):
        return wrap_vtk(self._vtk_obj.GetIntegrationModel())
    def _set_integration_model(self, arg):
        old_val = self._get_integration_model()
        self._wrap_call(self._vtk_obj.SetIntegrationModel,
                        arg)
        self.trait_property_changed('integration_model', old_val, arg)
    integration_model = traits.Property(_get_integration_model, _set_integration_model, desc=\
        r"""
        
        """
    )

    def _get_integrator(self):
        return wrap_vtk(self._vtk_obj.GetIntegrator())
    def _set_integrator(self, arg):
        old_val = self._get_integrator()
        self._wrap_call(self._vtk_obj.SetIntegrator,
                        deref_vtk(arg))
        self.trait_property_changed('integrator', old_val, arg)
    integrator = traits.Property(_get_integrator, _set_integrator, desc=\
        r"""
        
        """
    )

    maximum_integration_time = traits.Float(-1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the maximum integration time. A negative value means no
        limit. Default is -1.
        """
    )

    def _maximum_integration_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumIntegrationTime,
                        self.maximum_integration_time)

    maximum_number_of_steps = traits.Int(100, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the maximum number of steps. -1 means no limit. Default
        is 100.
        """
    )

    def _maximum_number_of_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumNumberOfSteps,
                        self.maximum_number_of_steps)

    step_factor = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the integration step factor. Default is 1.0.
        """
    )

    def _step_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStepFactor,
                        self.step_factor)

    step_factor_max = traits.Float(1.5, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the integration step factor max. Default is 1.5.
        """
    )

    def _step_factor_max_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStepFactorMax,
                        self.step_factor_max)

    step_factor_min = traits.Float(0.5, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the integration step factor min. Default is 0.5.
        """
    )

    def _step_factor_min_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStepFactorMin,
                        self.step_factor_min)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_new_particle_id(self):
        return self._vtk_obj.GetNewParticleId()
    new_particle_id = traits.Property(_get_new_particle_id, desc=\
        r"""
        Get an unique id for a particle This method is thread safe
        """
    )

    def _get_source(self):
        return wrap_vtk(self._vtk_obj.GetSource())
    source = traits.Property(_get_source, desc=\
        r"""
        
        """
    )

    def _get_surface(self):
        return wrap_vtk(self._vtk_obj.GetSurface())
    surface = traits.Property(_get_surface, desc=\
        r"""
        
        """
    )

    def fill_input_port_information(self, *args):
        """
        fill_input_port_information(self, port:int, info:Information)
            -> int
        C++: int fill_input_port_information(int port, Information *info)
            override;
        Declare input port type
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FillInputPortInformation, *my_args)
        return ret

    def fill_output_port_information(self, *args):
        """
        fill_output_port_information(self, port:int, info:Information)
            -> int
        C++: int fill_output_port_information(int port, Information *info)
             override;
        Declare output port type
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FillOutputPortInformation, *my_args)
        return ret

    def set_source_connection(self, *args):
        """
        set_source_connection(self, algOutput:AlgorithmOutput) -> None
        C++: void set_source_connection(AlgorithmOutput *algOutput)
        Specify the source object used to generate particle initial
        position (seeds).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceConnection, *my_args)
        return ret

    def set_source_data(self, *args):
        """
        set_source_data(self, source:DataObject) -> None
        C++: void set_source_data(DataObject *source)
        Specify the source object used to generate particle initial
        position (seeds). Note that this method does not connect the
        pipeline. The algorithm will work on the input data as it is
        without updating the producer of the data. See
        set_source_connection for connecting the pipeline.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceData, *my_args)
        return ret

    def set_surface_connection(self, *args):
        """
        set_surface_connection(self, algOutput:AlgorithmOutput) -> None
        C++: void set_surface_connection(AlgorithmOutput *algOutput)
        Specify the object used to compute surface interaction with.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSurfaceConnection, *my_args)
        return ret

    def set_surface_data(self, *args):
        """
        set_surface_data(self, source:DataObject) -> None
        C++: void set_surface_data(DataObject *source)
        Specify the source object used to compute surface interaction
        with Note that this method does not connect the pipeline. The
        algorithm will work on the input data as it is without updating
        the producer of the data. See set_surface_connection for connecting
        the pipeline.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSurfaceData, *my_args)
        return ret

    _updateable_traits_ = \
    (('adaptive_step_reintegration', 'GetAdaptiveStepReintegration'),
    ('generate_particle_paths_output', 'GetGenerateParticlePathsOutput'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('cell_length_computation_mode', 'GetCellLengthComputationMode'),
    ('generate_poly_vertex_interaction_output',
    'GetGeneratePolyVertexInteractionOutput'),
    ('maximum_integration_time', 'GetMaximumIntegrationTime'),
    ('maximum_number_of_steps', 'GetMaximumNumberOfSteps'),
    ('step_factor', 'GetStepFactor'), ('step_factor_max',
    'GetStepFactorMax'), ('step_factor_min', 'GetStepFactorMin'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'adaptive_step_reintegration', 'debug',
    'generate_particle_paths_output', 'global_warning_display',
    'release_data_flag', 'cell_length_computation_mode',
    'generate_poly_vertex_interaction_output', 'maximum_integration_time',
    'maximum_number_of_steps', 'progress_text', 'step_factor',
    'step_factor_max', 'step_factor_min'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LagrangianParticleTracker, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LagrangianParticleTracker properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['adaptive_step_reintegration',
            'generate_particle_paths_output'], [],
            ['cell_length_computation_mode',
            'generate_poly_vertex_interaction_output', 'maximum_integration_time',
            'maximum_number_of_steps', 'step_factor', 'step_factor_max',
            'step_factor_min']),
            title='Edit LagrangianParticleTracker properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LagrangianParticleTracker properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

