
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file HiLoMarkerAttributes.h
    \\brief Definition of HiLoMarker Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "HiLoMarkerAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

HiLoMarkerAttributes::HiLoMarkerAttributes():
	height_(ParameterManager::getDouble("contour_hilo_marker_height")),
	index_(ParameterManager::getInt("contour_hilo_marker_index"))
	,
	colour_(MagTranslator<string, Colour>().magics("contour_hilo_marker_colour"))
	 
{
} 


HiLoMarkerAttributes::~HiLoMarkerAttributes()
{
	
}

    
void HiLoMarkerAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "contour_hilo_marker_height", height_, params);
	setAttribute(prefix, "contour_hilo_marker_index", index_, params);
	
	setMember(prefix, "contour_hilo_marker_colour", colour_, params);
	
}

void HiLoMarkerAttributes::copy(const HiLoMarkerAttributes& other)
{
	height_ = other.height_;
	index_ = other.index_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	
} 


bool HiLoMarkerAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void HiLoMarkerAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void HiLoMarkerAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " height = " <<  height_;
	out << " index = " <<  index_;
	out << " colour = " <<  *colour_;
	
	out << "]" << "\n";
}

void HiLoMarkerAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"contour_hilo_marker_height\":";
	niceprint(out,height_);
	out << ", \"contour_hilo_marker_index\":";
	niceprint(out,index_);
	out << ", \"contour_hilo_marker_colour\":";
	niceprint(out, *colour_);
	
}

static MagicsParameter<double> contour_hilo_marker_height("contour_hilo_marker_height", 0.1, "");
static MagicsParameter<int> contour_hilo_marker_index("contour_hilo_marker_index", 3, "");
static MagicsParameter<string> contour_hilo_marker_colour("contour_hilo_marker_colour", "red", ""); 
