; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefix NOSUBREG
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s -riscv-enable-subreg-liveness=true | FileCheck %s --check-prefix SUBREG

; This test checks that vrgatherei16 instructions are correctly
; register-allocated. The LMUL=1 destination register groups may not overlap
; with the EMUL=2 source vector register groups.

; FIXME: enabling subregister liveness results in incorrect register
; allocation!

define internal void @foo(<vscale x 1 x i16> %v15, <vscale x 1 x i16> %0, <vscale x 1 x i16> %vs12.i.i.i, <vscale x 1 x i16> %1, <vscale x 8 x i8> %v37) {
; NOSUBREG-LABEL: foo:
; NOSUBREG:       # %bb.0: # %loopIR.preheader.i.i
; NOSUBREG-NEXT:    # kill: def $v10 killed $v10 def $v10m2
; NOSUBREG-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; NOSUBREG-NEXT:    vmv.v.i v14, 0
; NOSUBREG-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; NOSUBREG-NEXT:    vmv.v.i v9, 0
; NOSUBREG-NEXT:    vsetivli zero, 4, e8, m1, tu, mu
; NOSUBREG-NEXT:    vmv1r.v v8, v9
; NOSUBREG-NEXT:    vrgatherei16.vv v8, v9, v14
; NOSUBREG-NEXT:  .LBB0_1: # %loopIR3.i.i
; NOSUBREG-NEXT:    # =>This Inner Loop Header: Depth=1
; NOSUBREG-NEXT:    vl1r.v v9, (zero)
; NOSUBREG-NEXT:    vsetivli zero, 4, e8, m1, tu, mu
; NOSUBREG-NEXT:    vmv1r.v v13, v12
; NOSUBREG-NEXT:    vrgatherei16.vv v13, v9, v10
; NOSUBREG-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; NOSUBREG-NEXT:    vand.vv v9, v8, v13
; NOSUBREG-NEXT:    vs1r.v v9, (zero)
; NOSUBREG-NEXT:    j .LBB0_1
;
; SUBREG-LABEL: foo:
; SUBREG:       # %bb.0: # %loopIR.preheader.i.i
; SUBREG-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; SUBREG-NEXT:    vmv.v.i v14, 0
; SUBREG-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; SUBREG-NEXT:    vmv.v.i v9, 0
; SUBREG-NEXT:    vsetivli zero, 4, e8, m1, tu, mu
; SUBREG-NEXT:    vmv1r.v v8, v9
; SUBREG-NEXT:    vrgatherei16.vv v8, v9, v14
; SUBREG-NEXT:  .LBB0_1: # %loopIR3.i.i
; SUBREG-NEXT:    # =>This Inner Loop Header: Depth=1
; SUBREG-NEXT:    vl1r.v v9, (zero)
; SUBREG-NEXT:    vsetivli zero, 4, e8, m1, tu, mu
; SUBREG-NEXT:    vmv1r.v v11, v12
; SUBREG-NEXT:    vrgatherei16.vv v11, v9, v10
; SUBREG-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; SUBREG-NEXT:    vand.vv v9, v8, v11
; SUBREG-NEXT:    vs1r.v v9, (zero)
; SUBREG-NEXT:    j .LBB0_1
loopIR.preheader.i.i:
  %v18 = tail call <vscale x 8 x i16> @llvm.vector.insert.nxv8i16.nxv1i16(<vscale x 8 x i16> poison, <vscale x 1 x i16> %vs12.i.i.i, i64 0)
  br label %loopIR3.i.i

loopIR3.i.i:                                      ; preds = %loopIR3.i.i, %loopIR.preheader.i.i
  %v376 = load <vscale x 8 x i8>, ptr addrspace(1) null, align 8
  %v38 = tail call <vscale x 8 x i8> @llvm.riscv.vrgatherei16.vv.nxv8i8.i64(<vscale x 8 x i8> zeroinitializer, <vscale x 8 x i8> zeroinitializer, <vscale x 8 x i16> zeroinitializer, i64 4)
  %v40 = tail call <vscale x 8 x i8> @llvm.riscv.vrgatherei16.vv.nxv8i8.i64(<vscale x 8 x i8> %v37, <vscale x 8 x i8> %v376, <vscale x 8 x i16> %v18, i64 4)
  %v42 = and <vscale x 8 x i8> %v38, %v40
  store <vscale x 8 x i8> %v42, ptr addrspace(1) null, align 4
  br label %loopIR3.i.i
}

; Function Attrs: nocallback nofree nosync nounwind readnone willreturn
declare <vscale x 8 x i16> @llvm.vector.insert.nxv8i16.nxv1i16(<vscale x 8 x i16>, <vscale x 1 x i16>, i64 immarg) #0

; Function Attrs: nounwind readnone
declare <vscale x 8 x i8> @llvm.riscv.vrgatherei16.vv.nxv8i8.i64(<vscale x 8 x i8>, <vscale x 8 x i8>, <vscale x 8 x i16>, i64) #1

attributes #0 = { nocallback nofree nosync nounwind readnone willreturn }
attributes #1 = { nounwind readnone }
