(*Generated by Lem from set_helpers.lem.*)
(******************************************************************************)
(* Helper functions for sets                                                  *)
(******************************************************************************)

(* Usually there is a something.lem file containing the main definitions and a 
   something_extra.lem one containing functions that might cause problems for
   some backends or are just seldomly used.

   For sets the situation is different. folding is not well defined, since it
   is only sensibly defined for finite sets and it the traversel 
   order is underspecified. *) 

(* ========================================================================== *)
(* Header                                                                     *)
(* ========================================================================== *)

open Lem_bool
open Lem_basic_classes
open Lem_maybe
open Lem_function
open Lem_num

(* ------------------------ *)
(* fold                     *)
(* ------------------------ *)

(* fold is suspicious, because if given a function, for which
   the order, in which the arguments are given, matters, it's
   results are undefined. On the other hand, it is very handy to
   define other - non suspicious functions. 

   Moreover, fold is central for OCaml, size it is used to
   compile set comprehensions *)

(*val fold : forall 'a 'b. ('a -> 'b -> 'b) -> set 'a -> 'b -> 'b*)


