#include "a_rr.h"

namespace ADNS {

	A_RR::A_RR()
	{
		addr = gcnew IPAddress(0);
		rr_type = RR_TYPE::A;
		rr_class = RR_CLASS::IN;
		UpdateRdata();
	}

	A_RR::A_RR(UInt32 ip)
	{
		addr = gcnew IPAddress(ip);
		rr_type = RR_TYPE::A;
		UpdateRdata();
	}

	A_RR::A_RR(array<Byte>^ ip)
	{
		addr = gcnew IPAddress(ip);
		rr_type = RR_TYPE::A;
		UpdateRdata();
	}


	UInt32 A_RR::GetAddressAsUInt32()
	{
		return addr->Address;
	}

	IPAddress^ A_RR::GetAddress()
	{
		return gcnew IPAddress(addr->GetAddressBytes());
	}
	
	Void A_RR::SetAddress(IPAddress^ ip)
	{
		addr = gcnew IPAddress(ip->GetAddressBytes());
		UpdateRdata();
	}
	Void A_RR::SetAddress(UInt32 ip)
	{
		addr = gcnew IPAddress(ip);
		UpdateRdata();
	}

	String^ A_RR::Print()
	{
		String^ output;
		output = PrintHeader();
		output += " ";
		output += addr->ToString();

		return output;
	}
	
	Void A_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(4);
		else
			rdata->Resize(rdata,4);

		addr->GetAddressBytes()->CopyTo(rdata,0);

		return;
	}

	A_RR^ A_RR::Clone()
	{
		A_RR^ newrr = gcnew A_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->addr = gcnew IPAddress(addr->Address);
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ A_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		A_RR^ aout;
		array<Byte>^ tmparray;

		tmparray = gcnew array<Byte>(4);
		packet->Copy(packet,rdata_start,tmparray,0,4);
		aout = gcnew A_RR(tmparray);
		aout->rr_class = (RR_CLASS) rr_class;
		aout->ttl = ttl;
		aout->owner = gcnew DOMAIN_NAME(domainname);
		aout->SetAddress(aout->GetAddress());  //redundant, but necessary to invoke the UpdateRdata method

		return aout;
	}

	String^ A_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<A_RR^>(rec)->Print();
	}

	ResourceRecord^ A_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<A_RR^>(rec)->Clone();
	}

}