/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/exitPoints")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class HighlightExitPointsTestGenerated extends AbstractHighlightExitPointsTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInExitPoints() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/exitPoints"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("getter.kt")
    public void testGetter() throws Exception {
        runTest("idea/testData/exitPoints/getter.kt");
    }

    @TestMetadata("inline1.kt")
    public void testInline1() throws Exception {
        runTest("idea/testData/exitPoints/inline1.kt");
    }

    @TestMetadata("inline2.kt")
    public void testInline2() throws Exception {
        runTest("idea/testData/exitPoints/inline2.kt");
    }

    @TestMetadata("inline3.kt")
    public void testInline3() throws Exception {
        runTest("idea/testData/exitPoints/inline3.kt");
    }

    @TestMetadata("inlineLocalReturn1.kt")
    public void testInlineLocalReturn1() throws Exception {
        runTest("idea/testData/exitPoints/inlineLocalReturn1.kt");
    }

    @TestMetadata("inlineLocalReturn2.kt")
    public void testInlineLocalReturn2() throws Exception {
        runTest("idea/testData/exitPoints/inlineLocalReturn2.kt");
    }

    @TestMetadata("inlineWithNoInlineParam.kt")
    public void testInlineWithNoInlineParam() throws Exception {
        runTest("idea/testData/exitPoints/inlineWithNoInlineParam.kt");
    }

    @TestMetadata("invalidReturn.kt")
    public void testInvalidReturn() throws Exception {
        runTest("idea/testData/exitPoints/invalidReturn.kt");
    }

    @TestMetadata("invalidThrow.kt")
    public void testInvalidThrow() throws Exception {
        runTest("idea/testData/exitPoints/invalidThrow.kt");
    }

    @TestMetadata("localFunction1.kt")
    public void testLocalFunction1() throws Exception {
        runTest("idea/testData/exitPoints/localFunction1.kt");
    }

    @TestMetadata("localFunction2.kt")
    public void testLocalFunction2() throws Exception {
        runTest("idea/testData/exitPoints/localFunction2.kt");
    }

    @TestMetadata("localFunctionThrow.kt")
    public void testLocalFunctionThrow() throws Exception {
        runTest("idea/testData/exitPoints/localFunctionThrow.kt");
    }

    @TestMetadata("notInline1.kt")
    public void testNotInline1() throws Exception {
        runTest("idea/testData/exitPoints/notInline1.kt");
    }

    @TestMetadata("notInline2.kt")
    public void testNotInline2() throws Exception {
        runTest("idea/testData/exitPoints/notInline2.kt");
    }

    @TestMetadata("simple.kt")
    public void testSimple() throws Exception {
        runTest("idea/testData/exitPoints/simple.kt");
    }

    @TestMetadata("throw1.kt")
    public void testThrow1() throws Exception {
        runTest("idea/testData/exitPoints/throw1.kt");
    }

    @TestMetadata("throw2.kt")
    public void testThrow2() throws Exception {
        runTest("idea/testData/exitPoints/throw2.kt");
    }
}
