
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQParallelAnimationGroup.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QParallelAnimationGroup>
#include <QAbstractAnimation>
#include <QAnimationGroup>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include "gsiDeclQtCoreTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QParallelAnimationGroup

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QParallelAnimationGroup::staticMetaObject);
}


// int QParallelAnimationGroup::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QParallelAnimationGroup *)cls)->duration ());
}


// static QString QParallelAnimationGroup::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QParallelAnimationGroup::tr (arg1, arg2, arg3));
}


// static QString QParallelAnimationGroup::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QParallelAnimationGroup::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QParallelAnimationGroup () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method int QParallelAnimationGroup::duration()\nThis is a reimplementation of QAbstractAnimation::duration", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += gsi::qt_signal<int > ("currentLoopChanged(int)", "currentLoopChanged", gsi::arg("currentLoop"), "@brief Signal declaration for QParallelAnimationGroup::currentLoopChanged(int currentLoop)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QParallelAnimationGroup::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > ("directionChanged(QAbstractAnimation::Direction)", "directionChanged", gsi::arg("arg1"), "@brief Signal declaration for QParallelAnimationGroup::directionChanged(QAbstractAnimation::Direction)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QParallelAnimationGroup::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > ("stateChanged(QAbstractAnimation::State, QAbstractAnimation::State)", "stateChanged", gsi::arg("newState"), gsi::arg("oldState"), "@brief Signal declaration for QParallelAnimationGroup::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QParallelAnimationGroup::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QParallelAnimationGroup::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAnimationGroup> &qtdecl_QAnimationGroup ();

qt_gsi::QtNativeClass<QParallelAnimationGroup> decl_QParallelAnimationGroup (qtdecl_QAnimationGroup (), "QtCore", "QParallelAnimationGroup_Native",
  methods_QParallelAnimationGroup (),
  "@hide\n@alias QParallelAnimationGroup");

GSI_QTCORE_PUBLIC gsi::Class<QParallelAnimationGroup> &qtdecl_QParallelAnimationGroup () { return decl_QParallelAnimationGroup; }

}


class QParallelAnimationGroup_Adaptor : public QParallelAnimationGroup, public qt_gsi::QtObjectBase
{
public:

  virtual ~QParallelAnimationGroup_Adaptor();

  //  [adaptor ctor] QParallelAnimationGroup::QParallelAnimationGroup(QObject *parent)
  QParallelAnimationGroup_Adaptor() : QParallelAnimationGroup()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QParallelAnimationGroup::QParallelAnimationGroup(QObject *parent)
  QParallelAnimationGroup_Adaptor(QObject *parent) : QParallelAnimationGroup(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QParallelAnimationGroup::isSignalConnected(const QMetaMethod &signal)
  bool fp_QParallelAnimationGroup_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QParallelAnimationGroup::isSignalConnected(signal);
  }

  //  [expose] int QParallelAnimationGroup::receivers(const char *signal)
  int fp_QParallelAnimationGroup_receivers_c1731 (const char *signal) const {
    return QParallelAnimationGroup::receivers(signal);
  }

  //  [expose] QObject *QParallelAnimationGroup::sender()
  QObject * fp_QParallelAnimationGroup_sender_c0 () const {
    return QParallelAnimationGroup::sender();
  }

  //  [expose] int QParallelAnimationGroup::senderSignalIndex()
  int fp_QParallelAnimationGroup_senderSignalIndex_c0 () const {
    return QParallelAnimationGroup::senderSignalIndex();
  }

  //  [emitter impl] void QParallelAnimationGroup::currentLoopChanged(int currentLoop)
  void emitter_QParallelAnimationGroup_currentLoopChanged_767(int currentLoop)
  {
    emit QParallelAnimationGroup::currentLoopChanged(currentLoop);
  }

  //  [emitter impl] void QParallelAnimationGroup::destroyed(QObject *)
  void emitter_QParallelAnimationGroup_destroyed_1302(QObject *arg1)
  {
    emit QParallelAnimationGroup::destroyed(arg1);
  }

  //  [emitter impl] void QParallelAnimationGroup::directionChanged(QAbstractAnimation::Direction)
  void emitter_QParallelAnimationGroup_directionChanged_3310(QAbstractAnimation::Direction arg1)
  {
    emit QParallelAnimationGroup::directionChanged(arg1);
  }

  //  [adaptor impl] int QParallelAnimationGroup::duration()
  int cbs_duration_c0_0() const
  {
    return QParallelAnimationGroup::duration();
  }

  virtual int duration() const
  {
    if (cb_duration_c0_0.can_issue()) {
      return cb_duration_c0_0.issue<QParallelAnimationGroup_Adaptor, int>(&QParallelAnimationGroup_Adaptor::cbs_duration_c0_0);
    } else {
      return QParallelAnimationGroup::duration();
    }
  }

  //  [adaptor impl] bool QParallelAnimationGroup::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QParallelAnimationGroup::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QParallelAnimationGroup_Adaptor, bool, QObject *, QEvent *>(&QParallelAnimationGroup_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QParallelAnimationGroup::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QParallelAnimationGroup::finished()
  void emitter_QParallelAnimationGroup_finished_0()
  {
    emit QParallelAnimationGroup::finished();
  }

  //  [emitter impl] void QParallelAnimationGroup::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void emitter_QParallelAnimationGroup_stateChanged_5680(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    emit QParallelAnimationGroup::stateChanged(newState, oldState);
  }

  //  [adaptor impl] void QParallelAnimationGroup::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QParallelAnimationGroup::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QParallelAnimationGroup_Adaptor, QChildEvent *>(&QParallelAnimationGroup_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QParallelAnimationGroup::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QParallelAnimationGroup::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QParallelAnimationGroup::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QParallelAnimationGroup_Adaptor, QEvent *>(&QParallelAnimationGroup_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QParallelAnimationGroup::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QParallelAnimationGroup::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QParallelAnimationGroup::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QParallelAnimationGroup_Adaptor, const QMetaMethod &>(&QParallelAnimationGroup_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QParallelAnimationGroup::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QParallelAnimationGroup::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QParallelAnimationGroup::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QParallelAnimationGroup_Adaptor, bool, QEvent *>(&QParallelAnimationGroup_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QParallelAnimationGroup::event(_event);
    }
  }

  //  [adaptor impl] void QParallelAnimationGroup::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QParallelAnimationGroup::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QParallelAnimationGroup_Adaptor, QTimerEvent *>(&QParallelAnimationGroup_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QParallelAnimationGroup::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QParallelAnimationGroup::updateCurrentTime(int currentTime)
  void cbs_updateCurrentTime_767_0(int currentTime)
  {
    QParallelAnimationGroup::updateCurrentTime(currentTime);
  }

  virtual void updateCurrentTime(int currentTime)
  {
    if (cb_updateCurrentTime_767_0.can_issue()) {
      cb_updateCurrentTime_767_0.issue<QParallelAnimationGroup_Adaptor, int>(&QParallelAnimationGroup_Adaptor::cbs_updateCurrentTime_767_0, currentTime);
    } else {
      QParallelAnimationGroup::updateCurrentTime(currentTime);
    }
  }

  //  [adaptor impl] void QParallelAnimationGroup::updateDirection(QAbstractAnimation::Direction direction)
  void cbs_updateDirection_3310_0(const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & direction)
  {
    QParallelAnimationGroup::updateDirection(qt_gsi::QtToCppAdaptor<QAbstractAnimation::Direction>(direction).cref());
  }

  virtual void updateDirection(QAbstractAnimation::Direction direction)
  {
    if (cb_updateDirection_3310_0.can_issue()) {
      cb_updateDirection_3310_0.issue<QParallelAnimationGroup_Adaptor, const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type &>(&QParallelAnimationGroup_Adaptor::cbs_updateDirection_3310_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::Direction>(direction));
    } else {
      QParallelAnimationGroup::updateDirection(direction);
    }
  }

  //  [adaptor impl] void QParallelAnimationGroup::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void cbs_updateState_5680_0(const qt_gsi::Converter<QAbstractAnimation::State>::target_type & newState, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & oldState)
  {
    QParallelAnimationGroup::updateState(qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(newState).cref(), qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(oldState).cref());
  }

  virtual void updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    if (cb_updateState_5680_0.can_issue()) {
      cb_updateState_5680_0.issue<QParallelAnimationGroup_Adaptor, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &>(&QParallelAnimationGroup_Adaptor::cbs_updateState_5680_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(newState), qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(oldState));
    } else {
      QParallelAnimationGroup::updateState(newState, oldState);
    }
  }

  gsi::Callback cb_duration_c0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateCurrentTime_767_0;
  gsi::Callback cb_updateDirection_3310_0;
  gsi::Callback cb_updateState_5680_0;
};

QParallelAnimationGroup_Adaptor::~QParallelAnimationGroup_Adaptor() { }

//  Constructor QParallelAnimationGroup::QParallelAnimationGroup(QObject *parent) (adaptor class)

static void _init_ctor_QParallelAnimationGroup_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QParallelAnimationGroup_Adaptor> ();
}

static void _call_ctor_QParallelAnimationGroup_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QParallelAnimationGroup_Adaptor *> (new QParallelAnimationGroup_Adaptor (arg1));
}


// void QParallelAnimationGroup::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QParallelAnimationGroup_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QParallelAnimationGroup::currentLoopChanged(int currentLoop)

static void _init_emitter_currentLoopChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("currentLoop");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentLoopChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QParallelAnimationGroup_Adaptor *)cls)->emitter_QParallelAnimationGroup_currentLoopChanged_767 (arg1);
}


// void QParallelAnimationGroup::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QParallelAnimationGroup_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QParallelAnimationGroup::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QParallelAnimationGroup_Adaptor *)cls)->emitter_QParallelAnimationGroup_destroyed_1302 (arg1);
}


// emitter void QParallelAnimationGroup::directionChanged(QAbstractAnimation::Direction)

static void _init_emitter_directionChanged_3310 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_directionChanged_3310 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & >() (args, heap);
  ((QParallelAnimationGroup_Adaptor *)cls)->emitter_QParallelAnimationGroup_directionChanged_3310 (arg1);
}


// void QParallelAnimationGroup::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QParallelAnimationGroup_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// int QParallelAnimationGroup::duration()

static void _init_cbs_duration_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_duration_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QParallelAnimationGroup_Adaptor *)cls)->cbs_duration_c0_0 ());
}

static void _set_callback_cbs_duration_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_duration_c0_0 = cb;
}


// bool QParallelAnimationGroup::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QParallelAnimationGroup_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QParallelAnimationGroup::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QParallelAnimationGroup_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QParallelAnimationGroup::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QParallelAnimationGroup_Adaptor *)cls)->emitter_QParallelAnimationGroup_finished_0 ();
}


// exposed bool QParallelAnimationGroup::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QParallelAnimationGroup_Adaptor *)cls)->fp_QParallelAnimationGroup_isSignalConnected_c2394 (arg1));
}


// exposed int QParallelAnimationGroup::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QParallelAnimationGroup_Adaptor *)cls)->fp_QParallelAnimationGroup_receivers_c1731 (arg1));
}


// exposed QObject *QParallelAnimationGroup::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QParallelAnimationGroup_Adaptor *)cls)->fp_QParallelAnimationGroup_sender_c0 ());
}


// exposed int QParallelAnimationGroup::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QParallelAnimationGroup_Adaptor *)cls)->fp_QParallelAnimationGroup_senderSignalIndex_c0 ());
}


// emitter void QParallelAnimationGroup::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_emitter_stateChanged_5680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_5680 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  ((QParallelAnimationGroup_Adaptor *)cls)->emitter_QParallelAnimationGroup_stateChanged_5680 (arg1, arg2);
}


// void QParallelAnimationGroup::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QParallelAnimationGroup_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QParallelAnimationGroup::updateCurrentTime(int currentTime)

static void _init_cbs_updateCurrentTime_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("currentTime");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateCurrentTime_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QParallelAnimationGroup_Adaptor *)cls)->cbs_updateCurrentTime_767_0 (arg1);
}

static void _set_callback_cbs_updateCurrentTime_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_updateCurrentTime_767_0 = cb;
}


// void QParallelAnimationGroup::updateDirection(QAbstractAnimation::Direction direction)

static void _init_cbs_updateDirection_3310_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateDirection_3310_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QParallelAnimationGroup_Adaptor *)cls)->cbs_updateDirection_3310_0 (arg1);
}

static void _set_callback_cbs_updateDirection_3310_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_updateDirection_3310_0 = cb;
}


// void QParallelAnimationGroup::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_cbs_updateState_5680_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_updateState_5680_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QParallelAnimationGroup_Adaptor *)cls)->cbs_updateState_5680_0 (arg1, arg2);
}

static void _set_callback_cbs_updateState_5680_0 (void *cls, const gsi::Callback &cb)
{
  ((QParallelAnimationGroup_Adaptor *)cls)->cb_updateState_5680_0 = cb;
}


namespace gsi
{

gsi::Class<QParallelAnimationGroup> &qtdecl_QParallelAnimationGroup ();

static gsi::Methods methods_QParallelAnimationGroup_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QParallelAnimationGroup::QParallelAnimationGroup(QObject *parent)\nThis method creates an object of class QParallelAnimationGroup.", &_init_ctor_QParallelAnimationGroup_Adaptor_1302, &_call_ctor_QParallelAnimationGroup_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QParallelAnimationGroup::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_currentLoopChanged", "@brief Emitter for signal void QParallelAnimationGroup::currentLoopChanged(int currentLoop)\nCall this method to emit this signal.", false, &_init_emitter_currentLoopChanged_767, &_call_emitter_currentLoopChanged_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QParallelAnimationGroup::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QParallelAnimationGroup::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("emit_directionChanged", "@brief Emitter for signal void QParallelAnimationGroup::directionChanged(QAbstractAnimation::Direction)\nCall this method to emit this signal.", false, &_init_emitter_directionChanged_3310, &_call_emitter_directionChanged_3310);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QParallelAnimationGroup::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("duration", "@hide", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Virtual method int QParallelAnimationGroup::duration()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0, &_set_callback_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QParallelAnimationGroup::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QParallelAnimationGroup::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QParallelAnimationGroup::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QParallelAnimationGroup::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QParallelAnimationGroup::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QParallelAnimationGroup::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QParallelAnimationGroup::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QParallelAnimationGroup::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_5680, &_call_emitter_stateChanged_5680);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QParallelAnimationGroup::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@hide", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@brief Virtual method void QParallelAnimationGroup::updateCurrentTime(int currentTime)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0, &_set_callback_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@hide", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@brief Virtual method void QParallelAnimationGroup::updateDirection(QAbstractAnimation::Direction direction)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0, &_set_callback_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@hide", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@brief Virtual method void QParallelAnimationGroup::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0, &_set_callback_cbs_updateState_5680_0);
  return methods;
}

gsi::Class<QParallelAnimationGroup_Adaptor> decl_QParallelAnimationGroup_Adaptor (qtdecl_QParallelAnimationGroup (), "QtCore", "QParallelAnimationGroup",
  methods_QParallelAnimationGroup_Adaptor (),
  "@qt\n@brief Binding of QParallelAnimationGroup");

}

