package jalview.gui;

import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SequenceFetcherTest
{
  @Test(groups = { "Functional" }, dataProvider = "queryConversions")
  public void testQueryConversions(String query0, boolean replaceSemiColons,
          boolean removeVersions, String result)
  {
    Assert.assertEquals(
            SequenceFetcher.replaceQueryText(query0, replaceSemiColons,
                    removeVersions),
            result, "Converted query string isn't as expected");
  }

  @DataProvider(name = "queryConversions")
  public Object[][] queryConversions()
  {
    /**
     * String typedInQuery, replaceSemiColons, removeVersions, resultantQuery
     */
    return new Object[][] {
        //

        { "P12345", false, false, "P12345" },
        { "P12345", true, false, "P12345" },
        { "P12345", false, true, "P12345" },
        { "P12345", true, true, "P12345" },
        //
        { "P12345.1", false, false, "P12345.1" },
        { "P12345.1", true, false, "P12345.1" },
        { "P12345.1", false, true, "P12345" },
        { "P12345.1", true, true, "P12345" },
        //
        { "P12345.1 P22222.2", false, false, "P12345.1;P22222.2" },
        { "P12345.1 P22222.2", true, false, "P12345.1;P22222.2" },
        { "P12345.1 P22222.2", false, true, "P12345;P22222" },
        { "P12345.1 P22222.2", true, true, "P12345;P22222" },
        //
        { "P12345.1,P22222.2", false, false, "P12345.1,P22222.2" },
        { "P12345.1,P22222.2", true, false, "P12345.1;P22222.2" },
        { "P12345.1,P22222.2", false, true, "P12345,P22222" },
        { "P12345.1,P22222.2", true, true, "P12345;P22222" },
        //
        { "P12345.1.9; P22222.2", false, false, "P12345.1.9;P22222.2" },
        { "P12345.1.9; P22222.2", true, false, "P12345.1.9;P22222.2" },
        { "P12345.1.9; P22222.2", false, true, "P12345.1;P22222" },
        { "P12345.1.9; P22222.2", true, true, "P12345.1;P22222" },
        //
        { "P12345.1x; P22222.2", false, false, "P12345.1x;P22222.2" },
        { "P12345.1x; P22222.2", true, false, "P12345.1x;P22222.2" },
        { "P12345.1x; P22222.2", false, true, "P12345.1x;P22222" },
        { "P12345.1x; P22222.2", true, true, "P12345.1x;P22222" },

        //
    };
  }

}
