;;; initz-vars.el --- Customization.

;; Copyright (C) 2001-2002 OHASHI Akira <bg66@koka-in.org>

;; Author: OHASHI Akira <bg66@koka-in.org>
;; Keywords: startup, init

;; This file is part of Initz.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;;; Commentary:
;;

;;; Code:

(defgroup initz nil
  "Initz specific customize group")

(defgroup initz-face nil
  "Faces for Initz."
  :group 'initz
  :prefix "initz-")

;; User modifiable variables.
(defcustom initz-directory "~/.initz"
  "*Initz files path."
  :type 'directory
  :group 'initz)

(defcustom initz-prefix "init"
  "*Initz files prefix."
  :type 'string
  :group 'initz)

(defcustom initz-interactively nil
  "*If non-nil, initz loads files interactively."
  :type 'boolean
  :group 'initz)

(defcustom initz-verbose 'errors
  "*If non-nil, initz runs verbose."
  :type '(choice
	  (const :tag "Show messages and errors." errors)
	  (const :tag "Show only messages." messages)
	  (const :tag "Quietly." nil))
  :group 'initz)

(defcustom initz-load-list '()
  "*If non-nil, initz loads only the module contained in this list."
  :type '(repeat string)
  :group 'initz)

(defcustom initz-ignore-list '()
  "*If non-nil, initz ignores the module contained in this list."
  :type '(repeat string)
  :group 'initz)

(defcustom initz-list-default-node-status 'expand
  "*Default node status of `initz-list'."
  :type '(choice
	  (const :tag "Expand" expand)
	  (const :tag "Collapse" collapse))
  :group 'initz)

(defcustom initz-list-input-module-completing t
  "*If non-nil, initz completes the module with `features'."
  :type 'boolean
  :group 'initz)

(defcustom initz-list-loaded-mark "@"
  "*If module was loaded, print this at the rear."
  :type 'string
  :group 'initz)

(defcustom initz-delete-compile-log-buffer t
  "*If non-nil, initz deletes compile log buffer."
  :type 'boolean
  :group 'initz)

(defcustom initz-list-all-modules nil
  "*If non-nil, initz lists all modules in `initz-list'."
  :type 'boolean
  :group 'initz)

;; Faces.
(defface initz-list-node-face
  '((((class color) (background light)) (:foreground "blue"))
    (((class color) (background dark)) (:foreground "cyan"))
    (t (:bold t)))
  "Face used to initz list node."
  :group 'initz-face)

(defface initz-list-module-face
  '((((class color) (background light)) (:foreground "ForestGreen"))
    (((class color) (background dark)) (:foreground "green"))
    (t (:bold t)))
  "Face used to initz list module."
  :group 'initz-face)

(defface initz-list-unloaded-module-face
  '((((class color)) (:foreground "gray"))
    (t (:italic t)))
  "Face used to initz list unloaded module."
  :group 'initz-face)

(provide 'initz-vars)

;;; initz-vars.el ends here
