
// tiltdrivepro_out_3_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  6.000000
 // --table_div  80.394349
 // --table_op  0.500000

struct tabletiltdrivepro_out_3 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tabletiltdrivepro_out_3_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tabletiltdrivepro_out_3&() const { return *(tabletiltdrivepro_out_3*)this; }
};

 static tabletiltdrivepro_out_3_imp<2048> tiltdrivepro_out_3_table __rt_data = {
	0,-0.833333,170.583,2048, {
	0.000000000000,-0.000426384949,-0.000852804951,-0.001279259879,-0.001705749610,
	-0.002132274020,-0.002558832984,-0.002985426378,-0.003412054081,-0.003838715967,
	-0.004265411915,-0.004692141802,-0.005118905505,-0.005545702903,-0.005972533873,
	-0.006399398294,-0.006826296044,-0.007253227003,-0.007680191050,-0.008107188063,
	-0.008534217924,-0.008961280511,-0.009388375705,-0.009815503386,-0.010242663436,
	-0.010669855734,-0.011097080163,-0.011524336604,-0.011951624938,-0.012378945047,
	-0.012806296814,-0.013233680121,-0.013661094851,-0.014088540886,-0.014516018110,
	-0.014943526407,-0.015371065659,-0.015798635751,-0.016226236567,-0.016653867991,
	-0.017081529908,-0.017509222203,-0.017936944761,-0.018364697467,-0.018792480207,
	-0.019220292867,-0.019648135332,-0.020076007489,-0.020503909224,-0.020931840425,
	-0.021359800978,-0.021787790770,-0.022215809689,-0.022643857623,-0.023071934458,
	-0.023500040084,-0.023928174389,-0.024356337262,-0.024784528590,-0.025212748264,
	-0.025640996172,-0.026069272205,-0.026497576250,-0.026925908200,-0.027354267943,
	-0.027782655370,-0.028211070371,-0.028639512839,-0.029067982662,-0.029496479734,
	-0.029925003944,-0.030353555186,-0.030782133350,-0.031210738329,-0.031639370015,
	-0.032068028301,-0.032496713079,-0.032925424243,-0.033354161685,-0.033782925299,
	-0.034211714979,-0.034640530619,-0.035069372111,-0.035498239352,-0.035927132235,
	-0.036356050654,-0.036784994505,-0.037213963682,-0.037642958082,-0.038071977599,
	-0.038501022129,-0.038930091568,-0.039359185812,-0.039788304758,-0.040217448301,
	-0.040646616339,-0.041075808768,-0.041505025486,-0.041934266389,-0.042363531376,
	-0.042792820344,-0.043222133191,-0.043651469815,-0.044080830114,-0.044510213987,
	-0.044939621332,-0.045369052048,-0.045798506035,-0.046227983192,-0.046657483418,
	-0.047087006612,-0.047516552675,-0.047946121506,-0.048375713007,-0.048805327076,
	-0.049234963616,-0.049664622526,-0.050094303707,-0.050524007061,-0.050953732490,
	-0.051383479894,-0.051813249176,-0.052243040236,-0.052672852979,-0.053102687305,
	-0.053532543117,-0.053962420317,-0.054392318810,-0.054822238497,-0.055252179282,
	-0.055682141068,-0.056112123759,-0.056542127259,-0.056972151471,-0.057402196299,
	-0.057832261649,-0.058262347424,-0.058692453528,-0.059122579868,-0.059552726347,
	-0.059982892871,-0.060413079345,-0.060843285675,-0.061273511766,-0.061703757525,
	-0.062134022857,-0.062564307668,-0.062994611866,-0.063424935356,-0.063855278045,
	-0.064285639840,-0.064716020648,-0.065146420377,-0.065576838933,-0.066007276225,
	-0.066437732160,-0.066868206646,-0.067298699591,-0.067729210904,-0.068159740492,
	-0.068590288264,-0.069020854130,-0.069451437997,-0.069882039776,-0.070312659375,
	-0.070743296703,-0.071173951671,-0.071604624187,-0.072035314163,-0.072466021507,
	-0.072896746130,-0.073327487943,-0.073758246855,-0.074189022779,-0.074619815624,
	-0.075050625301,-0.075481451722,-0.075912294798,-0.076343154440,-0.076774030560,
	-0.077204923070,-0.077635831882,-0.078066756908,-0.078497698060,-0.078928655251,
	-0.079359628393,-0.079790617398,-0.080221622180,-0.080652642652,-0.081083678727,
	-0.081514730318,-0.081945797338,-0.082376879702,-0.082807977323,-0.083239090115,
	-0.083670217992,-0.084101360869,-0.084532518659,-0.084963691277,-0.085394878638,
	-0.085826080656,-0.086257297248,-0.086688528327,-0.087119773809,-0.087551033609,
	-0.087982307643,-0.088413595827,-0.088844898076,-0.089276214307,-0.089707544435,
	-0.090138888377,-0.090570246049,-0.091001617368,-0.091433002250,-0.091864400613,
	-0.092295812373,-0.092727237447,-0.093158675753,-0.093590127207,-0.094021591728,
	-0.094453069234,-0.094884559641,-0.095316062868,-0.095747578833,-0.096179107454,
	-0.096610648650,-0.097042202339,-0.097473768439,-0.097905346870,-0.098336937550,
	-0.098768540399,-0.099200155335,-0.099631782278,-0.100063421147,-0.100495071862,
	-0.100926734343,-0.101358408508,-0.101790094279,-0.102221791576,-0.102653500318,
	-0.103085220426,-0.103516951820,-0.103948694422,-0.104380448151,-0.104812212929,
	-0.105243988677,-0.105675775315,-0.106107572766,-0.106539380950,-0.106971199789,
	-0.107403029204,-0.107834869118,-0.108266719453,-0.108698580129,-0.109130451070,
	-0.109562332198,-0.109994223435,-0.110426124703,-0.110858035926,-0.111289957026,
	-0.111721887926,-0.112153828548,-0.112585778817,-0.113017738655,-0.113449707986,
	-0.113881686733,-0.114313674820,-0.114745672170,-0.115177678708,-0.115609694358,
	-0.116041719043,-0.116473752687,-0.116905795216,-0.117337846553,-0.117769906624,
	-0.118201975352,-0.118634052663,-0.119066138482,-0.119498232733,-0.119930335342,
	-0.120362446234,-0.120794565335,-0.121226692570,-0.121658827864,-0.122090971144,
	-0.122523122335,-0.122955281363,-0.123387448154,-0.123819622635,-0.124251804732,
	-0.124683994371,-0.125116191479,-0.125548395982,-0.125980607807,-0.126412826882,
	-0.126845053132,-0.127277286486,-0.127709526870,-0.128141774212,-0.128574028439,
	-0.129006289478,-0.129438557258,-0.129870831706,-0.130303112750,-0.130735400318,
	-0.131167694338,-0.131599994737,-0.132032301446,-0.132464614391,-0.132896933502,
	-0.133329258706,-0.133761589934,-0.134193927113,-0.134626270172,-0.135058619041,
	-0.135490973649,-0.135923333925,-0.136355699798,-0.136788071198,-0.137220448054,
	-0.137652830296,-0.138085217854,-0.138517610657,-0.138950008636,-0.139382411721,
	-0.139814819842,-0.140247232929,-0.140679650912,-0.141112073723,-0.141544501291,
	-0.141976933547,-0.142409370423,-0.142841811848,-0.143274257755,-0.143706708073,
	-0.144139162735,-0.144571621671,-0.145004084814,-0.145436552093,-0.145869023442,
	-0.146301498791,-0.146733978073,-0.147166461219,-0.147598948161,-0.148031438831,
	-0.148463933162,-0.148896431086,-0.149328932535,-0.149761437441,-0.150193945738,
	-0.150626457357,-0.151058972232,-0.151491490295,-0.151924011479,-0.152356535718,
	-0.152789062944,-0.153221593090,-0.153654126090,-0.154086661878,-0.154519200386,
	-0.154951741548,-0.155384285299,-0.155816831571,-0.156249380298,-0.156681931416,
	-0.157114484856,-0.157547040555,-0.157979598445,-0.158412158461,-0.158844720538,
	-0.159277284610,-0.159709850611,-0.160142418477,-0.160574988142,-0.161007559541,
	-0.161440132608,-0.161872707279,-0.162305283489,-0.162737861173,-0.163170440267,
	-0.163603020705,-0.164035602424,-0.164468185358,-0.164900769443,-0.165333354615,
	-0.165765940811,-0.166198527964,-0.166631116013,-0.167063704892,-0.167496294538,
	-0.167928884888,-0.168361475876,-0.168794067440,-0.169226659517,-0.169659252042,
	-0.170091844953,-0.170524438186,-0.170957031678,-0.171389625366,-0.171822219186,
	-0.172254813076,-0.172687406974,-0.173120000815,-0.173552594538,-0.173985188080,
	-0.174417781378,-0.174850374370,-0.175282966994,-0.175715559187,-0.176148150887,
	-0.176580742031,-0.177013332559,-0.177445922407,-0.177878511514,-0.178311099818,
	-0.178743687257,-0.179176273771,-0.179608859296,-0.180041443771,-0.180474027136,
	-0.180906609329,-0.181339190288,-0.181771769952,-0.182204348261,-0.182636925153,
	-0.183069500567,-0.183502074442,-0.183934646717,-0.184367217332,-0.184799786227,
	-0.185232353339,-0.185664918610,-0.186097481978,-0.186530043383,-0.186962602765,
	-0.187395160064,-0.187827715219,-0.188260268170,-0.188692818858,-0.189125367222,
	-0.189557913203,-0.189990456740,-0.190422997775,-0.190855536247,-0.191288072098,
	-0.191720605266,-0.192153135694,-0.192585663321,-0.193018188089,-0.193450709938,
	-0.193883228809,-0.194315744643,-0.194748257381,-0.195180766964,-0.195613273333,
	-0.196045776430,-0.196478276196,-0.196910772571,-0.197343265498,-0.197775754919,
	-0.198208240774,-0.198640723005,-0.199073201554,-0.199505676363,-0.199938147373,
	-0.200370614527,-0.200803077766,-0.201235537033,-0.201667992270,-0.202100443418,
	-0.202532890420,-0.202965333219,-0.203397771756,-0.203830205974,-0.204262635817,
	-0.204695061225,-0.205127482143,-0.205559898512,-0.205992310275,-0.206424717376,
	-0.206857119756,-0.207289517360,-0.207721910130,-0.208154298010,-0.208586680941,
	-0.209019058869,-0.209451431735,-0.209883799484,-0.210316162058,-0.210748519401,
	-0.211180871458,-0.211613218170,-0.212045559483,-0.212477895339,-0.212910225683,
	-0.213342550458,-0.213774869609,-0.214207183079,-0.214639490812,-0.215071792753,
	-0.215504088845,-0.215936379033,-0.216368663261,-0.216800941474,-0.217233213616,
	-0.217665479631,-0.218097739464,-0.218529993060,-0.218962240362,-0.219394481317,
	-0.219826715868,-0.220258943961,-0.220691165540,-0.221123380550,-0.221555588937,
	-0.221987790645,-0.222419985619,-0.222852173805,-0.223284355148,-0.223716529594,
	-0.224148697087,-0.224580857572,-0.225013010997,-0.225445157305,-0.225877296443,
	-0.226309428356,-0.226741552990,-0.227173670291,-0.227605780204,-0.228037882675,
	-0.228469977651,-0.228902065077,-0.229334144900,-0.229766217064,-0.230198281518,
	-0.230630338206,-0.231062387075,-0.231494428071,-0.231926461141,-0.232358486231,
	-0.232790503288,-0.233222512258,-0.233654513087,-0.234086505723,-0.234518490112,
	-0.234950466200,-0.235382433935,-0.235814393264,-0.236246344133,-0.236678286489,
	-0.237110220280,-0.237542145451,-0.237974061952,-0.238405969728,-0.238837868726,
	-0.239269758895,-0.239701640182,-0.240133512533,-0.240565375897,-0.240997230220,
	-0.241429075450,-0.241860911536,-0.242292738424,-0.242724556062,-0.243156364398,
	-0.243588163379,-0.244019952954,-0.244451733071,-0.244883503677,-0.245315264720,
	-0.245747016149,-0.246178757911,-0.246610489954,-0.247042212228,-0.247473924679,
	-0.247905627257,-0.248337319909,-0.248769002584,-0.249200675231,-0.249632337797,
	-0.250063990232,-0.250495632484,-0.250927264502,-0.251358886233,-0.251790497628,
	-0.252222098634,-0.252653689201,-0.253085269278,-0.253516838812,-0.253948397754,
	-0.254379946052,-0.254811483655,-0.255243010513,-0.255674526574,-0.256106031788,
	-0.256537526104,-0.256969009471,-0.257400481838,-0.257831943155,-0.258263393372,
	-0.258694832437,-0.259126260300,-0.259557676911,-0.259989082220,-0.260420476175,
	-0.260851858727,-0.261283229826,-0.261714589420,-0.262145937461,-0.262577273897,
	-0.263008598679,-0.263439911757,-0.263871213080,-0.264302502599,-0.264733780263,
	-0.265165046024,-0.265596299830,-0.266027541633,-0.266458771382,-0.266889989027,
	-0.267321194520,-0.267752387810,-0.268183568848,-0.268614737584,-0.269045893969,
	-0.269477037953,-0.269908169487,-0.270339288522,-0.270770395008,-0.271201488895,
	-0.271632570135,-0.272063638679,-0.272494694477,-0.272925737480,-0.273356767638,
	-0.273787784904,-0.274218789228,-0.274649780560,-0.275080758853,-0.275511724056,
	-0.275942676122,-0.276373615001,-0.276804540645,-0.277235453005,-0.277666352032,
	-0.278097237678,-0.278528109893,-0.278958968630,-0.279389813840,-0.279820645473,
	-0.280251463483,-0.280682267820,-0.281113058436,-0.281543835283,-0.281974598312,
	-0.282405347476,-0.282836082725,-0.283266804011,-0.283697511287,-0.284128204505,
	-0.284558883615,-0.284989548571,-0.285420199324,-0.285850835826,-0.286281458030,
	-0.286712065886,-0.287142659349,-0.287573238368,-0.288003802898,-0.288434352890,
	-0.288864888296,-0.289295409068,-0.289725915160,-0.290156406523,-0.290586883109,
	-0.291017344872,-0.291447791764,-0.291878223736,-0.292308640743,-0.292739042736,
	-0.293169429668,-0.293599801491,-0.294030158159,-0.294460499624,-0.294890825838,
	-0.295321136755,-0.295751432328,-0.296181712509,-0.296611977251,-0.297042226507,
	-0.297472460230,-0.297902678373,-0.298332880889,-0.298763067731,-0.299193238852,
	-0.299623394206,-0.300053533745,-0.300483657423,-0.300913765193,-0.301343857007,
	-0.301773932821,-0.302203992586,-0.302634036255,-0.303064063784,-0.303494075124,
	-0.303924070230,-0.304354049054,-0.304784011550,-0.305213957673,-0.305643887374,
	-0.306073800609,-0.306503697330,-0.306933577491,-0.307363441047,-0.307793287950,
	-0.308223118154,-0.308652931613,-0.309082728282,-0.309512508113,-0.309942271060,
	-0.310372017079,-0.310801746121,-0.311231458143,-0.311661153096,-0.312090830936,
	-0.312520491616,-0.312950135091,-0.313379761315,-0.313809370241,-0.314238961824,
	-0.314668536018,-0.315098092778,-0.315527632056,-0.315957153809,-0.316386657990,
	-0.316816144553,-0.317245613453,-0.317675064644,-0.318104498080,-0.318533913716,
	-0.318963311507,-0.319392691407,-0.319822053370,-0.320251397351,-0.320680723304,
	-0.321110031184,-0.321539320946,-0.321968592545,-0.322397845934,-0.322827081069,
	-0.323256297905,-0.323685496395,-0.324114676496,-0.324543838161,-0.324972981346,
	-0.325402106005,-0.325831212093,-0.326260299565,-0.326689368377,-0.327118418482,
	-0.327547449837,-0.327976462395,-0.328405456113,-0.328834430944,-0.329263386845,
	-0.329692323769,-0.330121241673,-0.330550140512,-0.330979020240,-0.331407880812,
	-0.331836722185,-0.332265544313,-0.332694347151,-0.333123130655,-0.333551894780,
	-0.333980639482,-0.334409364715,-0.334838070435,-0.335266756598,-0.335695423159,
	-0.336124070073,-0.336552697295,-0.336981304782,-0.337409892489,-0.337838460371,
	-0.338267008383,-0.338695536482,-0.339124044623,-0.339552532762,-0.339981000854,
	-0.340409448854,-0.340837876719,-0.341266284404,-0.341694671866,-0.342123039058,
	-0.342551385938,-0.342979712462,-0.343408018584,-0.343836304261,-0.344264569448,
	-0.344692814102,-0.345121038178,-0.345549241633,-0.345977424421,-0.346405586500,
	-0.346833727824,-0.347261848350,-0.347689948035,-0.348118026833,-0.348546084701,
	-0.348974121595,-0.349402137471,-0.349830132285,-0.350258105993,-0.350686058552,
	-0.351113989917,-0.351541900044,-0.351969788891,-0.352397656412,-0.352825502564,
	-0.353253327304,-0.353681130587,-0.354108912370,-0.354536672609,-0.354964411260,
	-0.355392128280,-0.355819823625,-0.356247497251,-0.356675149115,-0.357102779173,
	-0.357530387381,-0.357957973696,-0.358385538074,-0.358813080472,-0.359240600845,
	-0.359668099152,-0.360095575347,-0.360523029387,-0.360950461230,-0.361377870831,
	-0.361805258147,-0.362232623134,-0.362659965750,-0.363087285950,-0.363514583692,
	-0.363941858931,-0.364369111624,-0.364796341729,-0.365223549202,-0.365650733999,
	-0.366077896076,-0.366505035392,-0.366932151902,-0.367359245563,-0.367786316332,
	-0.368213364165,-0.368640389020,-0.369067390852,-0.369494369620,-0.369921325279,
	-0.370348257786,-0.370775167099,-0.371202053173,-0.371628915966,-0.372055755435,
	-0.372482571537,-0.372909364227,-0.373336133464,-0.373762879204,-0.374189601404,
	-0.374616300021,-0.375042975011,-0.375469626332,-0.375896253941,-0.376322857794,
	-0.376749437849,-0.377175994062,-0.377602526391,-0.378029034792,-0.378455519222,
	-0.378881979639,-0.379308415999,-0.379734828260,-0.380161216378,-0.380587580310,
	-0.381013920014,-0.381440235446,-0.381866526564,-0.382292793324,-0.382719035684,
	-0.383145253601,-0.383571447031,-0.383997615933,-0.384423760262,-0.384849879977,
	-0.385275975033,-0.385702045389,-0.386128091002,-0.386554111828,-0.386980107825,
	-0.387406078949,-0.387832025159,-0.388257946411,-0.388683842662,-0.389109713869,
	-0.389535559990,-0.389961380982,-0.390387176802,-0.390812947407,-0.391238692754,
	-0.391664412801,-0.392090107504,-0.392515776822,-0.392941420710,-0.393367039127,
	-0.393792632029,-0.394218199374,-0.394643741119,-0.395069257221,-0.395494747637,
	-0.395920212325,-0.396345651242,-0.396771064344,-0.397196451590,-0.397621812937,
	-0.398047148341,-0.398472457760,-0.398897741151,-0.399322998472,-0.399748229680,
	-0.400173434731,-0.400598613583,-0.401023766194,-0.401448892520,-0.401873992520,
	-0.402299066149,-0.402724113366,-0.403149134127,-0.403574128390,-0.403999096112,
	-0.404424037250,-0.404848951762,-0.405273839605,-0.405698700735,-0.406123535111,
	-0.406548342690,-0.406973123428,-0.407397877282,-0.407822604211,-0.408247304172,
	-0.408671977121,-0.409096623015,-0.409521241813,-0.409945833471,-0.410370397946,
	-0.410794935196,-0.411219445177,-0.411643927848,-0.412068383165,-0.412492811085,
	-0.412917211566,-0.413341584564,-0.413765930038,-0.414190247943,-0.414614538238,
	-0.415038800879,-0.415463035823,-0.415887243028,-0.416311422451,-0.416735574049,
	-0.417159697779,-0.417583793599,-0.418007861464,-0.418431901333,-0.418855913162,
	-0.419279896909,-0.419703852530,-0.420127779984,-0.420551679226,-0.420975550213,
	-0.421399392904,-0.421823207255,-0.422246993222,-0.422670750764,-0.423094479836,
	-0.423518180396,-0.423941852402,-0.424365495809,-0.424789110575,-0.425212696657,
	-0.425636254012,-0.426059782596,-0.426483282367,-0.426906753282,-0.427330195297,
	-0.427753608369,-0.428176992456,-0.428600347514,-0.429023673499,-0.429446970370,
	-0.429870238082,-0.430293476592,-0.430716685858,-0.431139865835,-0.431563016482,
	-0.431986137753,-0.432409229607,-0.432832292000,-0.433255324889,-0.433678328230,
	-0.434101301980,-0.434524246096,-0.434947160534,-0.435370045251,-0.435792900203,
	-0.436215725348,-0.436638520642,-0.437061286041,-0.437484021501,-0.437906726980,
	-0.438329402434,-0.438752047820,-0.439174663093,-0.439597248210,-0.440019803128,
	-0.440442327804,-0.440864822192,-0.441287286251,-0.441709719936,-0.442132123204,
	-0.442554496010,-0.442976838312,-0.443399150065,-0.443821431226,-0.444243681750,
	-0.444665901595,-0.445088090716,-0.445510249070,-0.445932376612,-0.446354473298,
	-0.446776539086,-0.447198573930,-0.447620577787,-0.448042550613,-0.448464492364,
	-0.448886402996,-0.449308282465,-0.449730130726,-0.450151947736,-0.450573733450,
	-0.450995487824,-0.451417210815,-0.451838902377,-0.452260562467,-0.452682191040,
	-0.453103788052,-0.453525221247,-0.453946512337,-0.454367700084,-0.454788798204,
	-0.455209814602,-0.455630754594,-0.456051622072,-0.456472420041,-0.456893150910,
	-0.457313816666,-0.457734418980,-0.458154959283,-0.458575438817,-0.458995858673,
	-0.459416219817,-0.459836523113,-0.460256769337,-0.460676959192,-0.461097093320,
	-0.461517172303,-0.461937196681,-0.462357166949,-0.462777083563,-0.463196946950,
	-0.463616757505,-0.464036515595,-0.464456221566,-0.464875875740,-0.465295478420,
	-0.465715029890,-0.466134530420,-0.466553980260,-0.466973379650,-0.467392728816,
	-0.467812027972,-0.468231277319,-0.468650477050,-0.469069627347,-0.469488728383,
	-0.469907780324,-0.470326783326,-0.470745737539,-0.471164643104,-0.471583500158,
	-0.472002308831,-0.472421069245,-0.472839781519,-0.473258445766,-0.473677062094,
	-0.474095630606,-0.474514151399,-0.474932624569,-0.475351050206,-0.475769428396,
	-0.476187759221,-0.476606042760,-0.477024279090,-0.477442468281,-0.477860610404,
	-0.478278705525,-0.478696753707,-0.479114755011,-0.479532709495,-0.479950617213,
	-0.480368478220,-0.480786292567,-0.481204060300,-0.481621781467,-0.482039456112,
	-0.482457084276,-0.482874666001,-0.483292201324,-0.483709690282,-0.484127132909,
	-0.484544529239,-0.484961879303,-0.485379183130,-0.485796440748,-0.486213652185,
	-0.486630817466,-0.487047936614,-0.487465009652,-0.487882036601,-0.488299017480,
	-0.488715952309,-0.489132841104,-0.489549683882,-0.489966480657,-0.490383231444,
	-0.490799936255,-0.491216595102,-0.491633207995,-0.492049774944,-0.492466295958,
	-0.492882771045,-0.493299200210,-0.493715583460,-0.494131920800,-0.494548212233,
	-0.494964457763,-0.495380657392,-0.495796811121,-0.496212918952,-0.496628980883,
	-0.497044996915,-0.497460967045,-0.497876891271,-0.498292769590,-0.498708601998,
	-0.499124388490,-0.499540129062,-0.499955823708,-0.500371472420,-0.500787075192,
	-0.501202632016,-0.501618142884,-0.502033607786,-0.502449026712,-0.502864399654,
	-0.503279726599,-0.503695007536,-0.504110242454,-0.504525431340,-0.504940574181,
	-0.505355670963,-0.505770721672,-0.506185726294,-0.506600684814,-0.507015597215,
	-0.507430463483,-0.507845283599,-0.508260057548,-0.508674785312,-0.509089466872,
	-0.509504102210,-0.509918691307,-0.510333234145,-0.510747730702,-0.511162180959,
	-0.511576584895,-0.511990942489,-0.512405253720,-0.512819518565,-0.513233737002,
	-0.513647909009,-0.514062034562,-0.514476113638,-0.514890146212,-0.515304132261,
	-0.515718071760,-0.516131964683,-0.516545811005,-0.516959610701,-0.517373363744,
	-0.517787070107,-0.518200729764,-0.518614342688,-0.519027908850,-0.519441428222,
	-0.519854900777,-0.520268326485,-0.520681705318,-0.521095037247,-0.521508322240,
	-0.521921560269,-0.522334751304,-0.522747895312,-0.523160992264,-0.523574042128,
	-0.523987044872,-0.524400000464,-0.524812908872,-0.525225770064,-0.525638584006,
	-0.526051350665,-0.526464070007,-0.526876741999,-0.527289366607,-0.527701943796,
	-0.528114473530,-0.528526955776,-0.528939390498,-0.529351777660,-0.529764117226,
	-0.530176409159,-0.530588653423,-0.531000849982,-0.531412998798,-0.531825099834,
	-0.532237153052,-0.532649158414,-0.533061115880,-0.533473025415,-0.533884886977,
	-0.534296700528,-0.534708466030,-0.535120183440,-0.535531852721,-0.535943473831,
	-0.536355046730,-0.536766571376,-0.537178047730,-0.537589475750,-0.538000855393,
	-0.538412186618,-0.538823469383,-0.539234703645,-0.539645889362,-0.540057026490,
	-0.540468114985,-0.540879154806,-0.541290145906,-0.541701088244,-0.542111981773,
	-0.542522826449,-0.542933622228,-0.543344369064,-0.543755066911,-0.544165715724,
	-0.544576315457,-0.544986866063,-0.545397367497,-0.545807819710,-0.546218222656,
	-0.546628576288,-0.547038880557,-0.547449135417,-0.547859340818,-0.548269496712,
	-0.548679603051,-0.549089659785,-0.549499666865,-0.549909624242,-0.550319531866,
	-0.550729389686,-0.551139197652,-0.551548955715,-0.551958663822,-0.552368321922,
	-0.552777929965,-0.553187487898,-0.553596995669,-0.554006453227,-0.554415860518,
	-0.554825217489,-0.555234524088,-0.555643780262,-0.556052985956,-0.556462141116,
	-0.556871245689,-0.557280299620,-0.557689302854,-0.558098255337,-0.558507157012,
	-0.558916007824,-0.559324807717,-0.559733556636,-0.560142254524,-0.560550901323,
	-0.560959496978,-0.561368041430,-0.561776534623,-0.562184976497,-0.562593366996,
	-0.563001706061,-0.563409993633,-0.563818229652,-0.564226414061,-0.564634546798,
	-0.565042627805,-0.565450657021,-0.565858634385,-0.566266559838,-0.566674433317,
	-0.567082254761,-0.567490024110,-0.567897741301,-0.568305406271,-0.568713018958,
	-0.569120579300,-0.569528087233,-0.569935542694,-0.570342945619,-0.570750295944,
	-0.571157593604,-0.571564838536,-0.571972030673,-0.572379169952,-0.572786256305,
	-0.573193289668,-0.573600269974,-0.574007197157,-0.574414071150,-0.574820891885,
	-0.575227659295,-0.575634373313,-0.576041033870,-0.576447640898,-0.576854194328,
	-0.577260694091,-0.577667140118,-0.578073532339,-0.578479870683,-0.578886155082,
	-0.579292385463,-0.579698561756,-0.580104683889,-0.580510751791,-0.580916765390,
	-0.581322724613,-0.581728629387,-0.582134479640,-0.582540275299,-0.582946016288,
	-0.583351702535,-0.583757333965,-0.584162910503,-0.584568432074,-0.584973898602,
	-0.585379310011,-0.585784666227,-0.586189967171,-0.586595212766,-0.587000402937,
	-0.587405537605,-0.587810616691,-0.588215640118,-0.588620607807,-0.589025519679,
	-0.589430375655,-0.589835175653,-0.590239919596,-0.590644607400,-0.591049238987,
	-0.591453814274,-0.591858333179,-0.592262795621,-0.592667201517,-0.593071550784,
	-0.593475843339,-0.593880079098,-0.594284257977,-0.594688379892,-0.595092444757,
	-0.595496452488,-0.595900402999,-0.596304296204,-0.596708132015,-0.597111910348,
	-0.597515631113,-0.597919294224,-0.598322899592,-0.598726447129,-0.599129936746,
	-0.599533368354,-0.599936741861,-0.600340057180,-0.600743314218,-0.601146512885,
	-0.601549653089,-0.601952734739,-0.602355757741,-0.602758722003,-0.603161627432,
	-0.603564473935,-0.603967261416,-0.604369989781,-0.604772658936,-0.605175268785,
	-0.605577819231,-0.605980310179,-0.606382741531,-0.606785113191,-0.607187425060,
	-0.607589677040,-0.607991869032,-0.608394000937,-0.608796072656,-0.609198084088,
	-0.609600035133,-0.610001925689,-0.610403755655,-0.610805524928,-0.611207233406,
	-0.611608880987,-0.612010467565,-0.612411993038,-0.612813457301,-0.613214860248,
	-0.613616201773,-0.614017481772,-0.614418700136,-0.614819856760,-0.615220951534,
	-0.615621984352,-0.616022955103,-0.616423863680,-0.616824709971,-0.617225493868,
	-0.617626215258,-0.618026874031,-0.618427470074,-0.618828003275,-0.619228473521,
	-0.619628880698,-0.620029224693,-0.620429505389,-0.620829722673,-0.621229876428,
	-0.621629966537,-0.622029992884,-0.622429955352,-0.622829853821,-0.623229688173,
	-0.623629458289,-0.624029164049,-0.624428805332,-0.624828382018,-0.625227893984,
	-0.625627341108,-0.626026723267,-0.626426040338,-0.626825292196,-0.627224478717,
	-0.627623599775,-0.628022655244,-0.628421644998,-0.628820568909,-0.629219426849,
	-0.629618218690,-0.630016944303,-0.630415603557,-0.630814196323,-0.631212722468,
	-0.631611181861,-0.632009574370,-0.632407899862,-0.632806158202,-0.633204349256,
	-0.633602472889,-0.634000528965,-0.634398517347,-0.634796437899,-0.635194290482,
	-0.635592074957,-0.635989791186,-0.636387439028,-0.636785018342,-0.637182528987,
	-0.637579970821,-0.637977343701,-0.638374647483,-0.638771882022,-0.639169047174,
	-0.639566142793,-0.639963168732,-0.640360124843,-0.640757010980,-0.641153826992,
	-0.641550572729,-0.641947248043,-0.642343852781,-0.642740386792,-0.643136849922,
	-0.643533242018,-0.643929562926,-0.644325812491,-0.644721990557,-0.645118096967,
	-0.645514131563,-0.645910094188,-0.646305984681,-0.646701802883,-0.647097548634,
	-0.647493221771,-0.647888822131,-0.648284349553,-0.648679803870,-0.649075184919,
	-0.649470492534,-0.649865726546,-0.650260886790,-0.650655973096,-0.651050985295,
	-0.651445923217,-0.651840786690,-0.652235575542,-0.652630289600,-0.653024928691,
	-0.653419492640,-0.653813981270,-0.654208394406,-0.654602731869,-0.654996993481,
	-0.655391179062,-0.655785288433,-0.656179321411,-0.656573277815,-0.656967157461,
	-0.657360960165,-0.657754685741,-0.658148334003,-0.658541904765,-0.658935397838,
	-0.659328813032,-0.659722150158,-0.660115409024,-0.660508589438,-0.660901691207,
	-0.661294714136,-0.661687658031,-0.662080522694,-0.662473307928,-0.662866013535,
	-0.663258639316,-0.663651185069,-0.664043650593,-0.664436035685,-0.664828340142,
	-0.665220563758,-0.665612706327,-0.666004767642,-0.666396747496,-0.666788645678,
	-0.667180461977,-0.667572196184,-0.667963848083,-0.668355417462,-0.668746904106,
	-0.669138307798,-0.669529628321,-0.669920865455,-0.670312018983,-0.670703088681,
	-0.671094074329,-0.671484975703,-0.671875792578,-0.672266524728,-0.672657171927,
	-0.673047733945,-0.673438210555,-0.673828601524,-0.674218906621,-0.674609125612,
	-0.674999258264,-0.675389304339,-0.675779263602,-0.676169135813,-0.676558920733,
	-0.676948618121,-0.677338227734,-0.677727749329,-0.678117182661,-0.678506527483,
	-0.678895783548,-0.679284950606,-0.679674028408,-0.680063016701,-0.680451915233,
	-0.680840723748,-0.681229441990,-0.681618069703,-0.682006606627,-0.682395052503,
	-0.682783407068,-0.683171670060,-0.683559841213,-0.683947920262,-0.684335906940,
	-0.684723800977,-0.685111602103,-0.685499310046,-0.685886924532,-0.686274445288,
	-0.686661872035,-0.687049204496,-0.687436442391,-0.687823585440,-0.688210633360,
	-0.688597585866,-0.688984442673,-0.689371203493,-0.689757868037,-0.690144436014,
	-0.690530907133,-0.690917281100,-0.691303557618,-0.691689736392,-0.692075817121,
	-0.692461799506,-0.692847683244,-0.693233468032,-0.693619153564,-0.694004739533,
	-0.694390225630,-0.694775611544,-0.695160896963,-0.695546081572,-0.695931165056,
	-0.696316147098,-0.696701027377,-0.697085805572,-0.697470481361,-0.697855054418,
	-0.698239524417,-0.698623891029,-0.699008153925,-0.699392312771,-0.699776367233,
	-0.700160316977,-0.700544161663,-0.700927900952,-0.701311534503,-0.701695061971,
	-0.702078483013,-0.702461797279,-0.702845004420,-0.703228104086,-0.703611095923,
	-0.703993979575,-0.704376754686,-0.704759420895,-0.705141977842,-0.705524425163,
	-0.705906762492,-0.706288989463,-0.706671105705,-0.707053110847,-0.707435004515,
	-0.707816786333,-0.708198455923,-0.708580012905,-0.708961456897,-0.709342787514,
	-0.709724004369,-0.710105107075,-0.710486095239,-0.710866968469,-0.711247726368,
	-0.711628368540,-0.712008894585,-0.712389304100,-0.712769596681,-0.713149771920,
	-0.713529829410,-0.713909768738,-0.714289589491,-0.714669291253,-0.715048873605,
	-0.715428336127,-0.715807678395,-0.716186899984,-0.716566000466,-0.716944979410,
	-0.717323836384,-0.717702570953,-0.718081182678,-0.718459671119,-0.718838035834,
	-0.719216276377,-0.719594392301,-0.719972383155,-0.720350248487,-0.720727987840,
	-0.721105600758,-0.721483086778,-0.721860445439,-0.722237676274,-0.722614778815,
	-0.722991752591,-0.723368597127,-0.723745311948,-0.724121896574,-0.724498350522,
	-0.724874673310,-0.725250864448,-0.725626923448,-0.726002849815,-0.726378643055,
	-0.726754302669,-0.727129828155,-0.727505219009,-0.727880474724,-0.728255594791,
	-0.728630578695,-0.729005425923,-0.729380135954,-0.729754708268,-0.730129142339,
	-0.730503437641,-0.730877593643,-0.731251609811,-0.731625485609,-0.731999220498,
	-0.732372813934,-0.732746265372,-0.733119574264,-0.733492740057,-0.733865762197,
	-0.734238640125,-0.734611373280,-0.734983961099,-0.735356403012,-0.735728698451,
	-0.736100846839,-0.736472847601,-0.736844700156,-0.737216403919,-0.737587958305,
	-0.737959362722,-0.738330616577,-0.738701719273,-0.739072670209,-0.739443468783,
	-0.739814114386,-0.740184606408,-0.740554944235,-0.740925127250,-0.741295154831,
	-0.741665026355,-0.742034741194,-0.742404298716,-0.742773698287,-0.743142939267,
	-0.743512021015,-0.743880942885,-0.744249704229,-0.744618304392,-0.744986742719,
	-0.745355018550,-0.745723131220,-0.746091080063,-0.746458864406,-0.746826483575,
	-0.747193936892,-0.747561223673,-0.747928343232,-0.748295294880,-0.748662077922,
	-0.749028691661,-0.749395135395,-0.749761408418,-0.750127510021,-0.750493439490,
	-0.750859196109,-0.751224779156,-0.751590187907,-0.751955421630,-0.752320479595,
	-0.752685361062,-0.753050065292,-0.753414591537,-0.753778939050,-0.754143107077,
	-0.754507094859,-0.754870901636,-0.755234526640,-0.755597969102,-0.755961228247,
	-0.756324303297,-0.756687193470,-0.757049897977,-0.757412416027,-0.757774746825,
	-0.758136889571,-0.758498843460,-0.758860607684,-0.759222181430,-0.759583563880,
	-0.759944754213,-0.760305751601,-0.760666555216,-0.761027164220,-0.761387577775,
	-0.761747795037,-0.762107815156,-0.762467637280,-0.762827260551,-0.763186684106,
	-0.763545907079,-0.763904928598,-0.764263747787,-0.764622363765,-0.764980775646,
	-0.765338982541,-0.765696983554,-0.766054777786,-0.766412364333,-0.766769742286,
	-0.767126910730,-0.767483868747,-0.767840615414,-0.768197149802,-0.768553470979,
	-0.768909578006,-0.769265469940,-0.769621145834,-0.769976604736,-0.770331845687,
	-0.770686867725,-0.771041669882,-0.771396251187,-0.771750610662,-0.772104747324,
	-0.772458660185,-0.772812348255,-0.773165810534,-0.773519046020,-0.773872053705,
	-0.774224832578,-0.774577381619,-0.774929699805,-0.775281786109,-0.775633639497,
	-0.775985258931,-0.776336643366,-0.776687791754,-0.777038703041,-0.777389376167,
	-0.777739810067,-0.778090003672,-0.778439955907,-0.778789665691,-0.779139131937,
	-0.779488353556,-0.779837329451,-0.780186058519,-0.780534539655,-0.780882771745,
	-0.781230753671,-0.781578484311,-0.781925962535,-0.782273187211,-0.782620157197,
	-0.782966871350,-0.783313328519,-0.783659527548,-0.784005467277,-0.784351146538,
	-0.784696564160,-0.785041718964,-0.785386609768,-0.785731235383,-0.786075594615,
	-0.786419686264,-0.786763509125,-0.787107061988,-0.787450343636,-0.787793352848,
	-0.788136088396,-0.788478549047,-0.788820733563,-0.789162640700,-0.789504269209,
	-0.789845617835,-0.790186685316,-0.790527470386,-0.790867971774,-0.791208188203,
	-0.791548118389,-0.791887761044,-0.792227114874,-0.792566178578,-0.792904950853,
	-0.793243430386,-0.793581615861,-0.793919505957,-0.794257099346,-0.794594394694,
	-0.794931390662,-0.795268085908,-0.795604479079,-0.795940568822,-0.796276353775,
	-0.796611832571,-0.796947003839,-0.797281866200,-0.797616418272,-0.797950658666,
	-0.798284585987,-0.798618198836,-0.798951495807,-0.799284475490,-0.799617136469,
	-0.799949477322,-0.800281496622,-0.800613192936,-0.800944564826,-0.801275610849,
	-0.801606329555,-0.801936719492,-0.802266779198,-0.802596507210,-0.802925902057,
	-0.803254962263,-0.803583686347,-0.803912072823,-0.804240120200,-0.804567826980,
	-0.804895191663,-0.805222212740,-0.805548888699,-0.805875218023,-0.806201199190,
	-0.806526830671,-0.806852110933,-0.807177038439,-0.807501611645,-0.807825829004,
	-0.808149688963,-0.808473189964,-0.808796330443,-0.809119108834,-0.809441523564,
	-0.809763573054,-0.810085255724,-0.810406569986,-0.810727514249,-0.811048086915,
	-0.811368286385,-0.811688111052,-0.812007559306,-0.812326629533,-0.812645320112,
	-0.812963629422,-0.813281555832,-0.813599097711,-0.813916253423,-0.814233021325,
	-0.814549399772,-0.814865387116,-0.815180981701,-0.815496181871,-0.815810985964,
	-0.816125392313,-0.816439399249,-0.816753005098,-0.817066208182,-0.817379006821,
	-0.817691399329,-0.818003384018,-0.818314959194,-0.818626123162,-0.818936874223,
	-0.819247210673,-0.819557130807,-0.819866632915,-0.820175715283,-0.820484376196,
	-0.820792613935,-0.821100426777,-0.821407812997,-0.821714770866,-0.822021298654,
	-0.822327394627,-0.822633057048,-0.822938284177,-0.823243074274,-0.823547425593,
	-0.823851336388,-0.824154804910,-0.824457829406,-0.824760408125,-0.825062539309,
	-0.825364221202,-0.825665452042,-0.825966230069,-0.826266553520,-0.826566420629,
	-0.826865829629,-0.827164778751,-0.827463266228,-0.827761290286,-0.828058849154,
	-0.828355941058,-0.828652564223,-0.828948716875,-0.829244397235,-0.829539603527,
	-0.829834333973,-0.830128586794,-0.830422360210,-0.830715652442,-0.831008461710,
	-0.831300786233,-0.831592624232,-0.831883973925,-0.832174833533,-0.832465201276,
	-0.832755075372,-0.833044454044,-0.833333335511
	}
};

double always_inline tiltdrivepro_out_3clip(double x) {
    double f = fabs(x);
    f = f * tiltdrivepro_out_3_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = tiltdrivepro_out_3_table.data[0];
    } else if (i >= tiltdrivepro_out_3_table.size-1) {
        f = tiltdrivepro_out_3_table.data[tiltdrivepro_out_3_table.size-1];
    } else {
    f -= i;
    f = tiltdrivepro_out_3_table.data[i]*(1-f) + tiltdrivepro_out_3_table.data[i+1]*f;
    }
    return copysign(f, x);
}

