% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.pval.R
\name{stars.pval}
\alias{stars.pval}
\title{Generate significance stars from p-values}
\usage{
stars.pval(p.value)
}
\arguments{
\item{p.value}{numeric vector of p-values}
}
\value{
A character vector containing the same number of elements as
\code{p-value}, with an attribute "legend" providing the conversion pattern.
}
\description{
Generate significance stars (e.g. '***', '**', '*', '.') from p-values using
R's standard definitions.
}
\details{
Mapping from p-value ranges to symbols: \describe{ \item{0 - 0.001}{'***'}
\item{0.001 - 0.01}{'**'} \item{0.01 - 0.05}{'*'} \item{0.05 - 0.1}{'.'}
\item{0.1 - 1.0}{'' (No symbol)} }
}
\examples{

p.val <- c(0.0004, 0.0015, 0.013, 0.044, 0.067, 0.24)
stars.pval(p.val)
}
\seealso{
\code{\link[stats]{symnum}}
}
\author{
Gregory R. Warnes \email{greg@warnes.net}
}
\keyword{misc}
